/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import java.util.ArrayList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class SeqDrift2ChangeDetector
extends AbstractChangeDetector {
    protected SeqDrift2 seqdrift;
    public FloatOption deltaSeqDrift2Option = new FloatOption("deltaSeq2Drift", 'd', "Delta of SeqDrift2 change detection", 0.01, 0.0, 1.0);
    public IntOption blockSeqDrift2Option = new IntOption("blockSeqDrift2Option", 'b', "Block size of SeqDrift2 change detector", 200, 100, 10000);

    @Override
    public void input(double inputValue) {
        if (this.seqdrift == null) {
            this.resetLearning();
        }
        this.isChangeDetected = this.seqdrift.setInput(inputValue);
        this.isWarningZone = false;
        this.delay = 0.0;
        this.estimation = this.seqdrift.getEstimation();
    }

    @Override
    public void resetLearning() {
        this.seqdrift = new SeqDrift2(this.deltaSeqDrift2Option.getValue(), this.blockSeqDrift2Option.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    public class Block {
        public double[] data;
        public double total;
        private int indexOfLastValue;
        private boolean b_IsTested;

        Block(int _iLength) {
            this.data = new double[_iLength];
            this.total = 0.0;
            this.indexOfLastValue = 0;
            for (int iIndex = 0; iIndex < this.data.length; ++iIndex) {
                this.data[iIndex] = -1.0;
            }
        }

        Block(int _iLength, boolean _isTested) {
            this.data = new double[_iLength];
            this.total = 0.0;
            this.indexOfLastValue = 0;
            this.b_IsTested = _isTested;
            for (int iIndex = 0; iIndex < this.data.length; ++iIndex) {
                this.data[iIndex] = -1.0;
            }
        }

        public void add(double _dValue) {
            if (this.indexOfLastValue < this.data.length) {
                this.data[this.indexOfLastValue] = _dValue;
                this.total += _dValue;
                ++this.indexOfLastValue;
            } else {
                System.out.println("ERROR in adding to Block. Last Index :" + this.indexOfLastValue + " Total :" + this.total + " Array Length :" + this.data.length);
                System.exit(2);
            }
        }

        public void addAt(int _iIndex, double _dNewValue) {
            this.total = this.total - this.data[_iIndex] + _dNewValue;
            this.data[_iIndex] = _dNewValue;
        }

        public void setTested(boolean _isTested) {
            this.b_IsTested = _isTested;
        }

        public boolean IsTested() {
            return this.b_IsTested;
        }
    }

    public class Repository {
        private final int blockSize;
        private final List<Block> blocks;
        private int indexOfLastBlock;
        private int instanceCount;
        private double total;

        public Repository(int _iBlockSize) {
            this.blockSize = _iBlockSize;
            this.indexOfLastBlock = -1;
            this.instanceCount = 0;
            this.total = 0.0;
            this.blocks = new ArrayList<Block>();
        }

        public void add(double _dValue) {
            if (this.instanceCount % this.blockSize == 0) {
                this.blocks.add(new Block(this.blockSize));
                ++this.indexOfLastBlock;
            }
            this.blocks.get(this.indexOfLastBlock).add(_dValue);
            ++this.instanceCount;
            this.total += _dValue;
        }

        public void add(double _dValue, boolean _isTested) {
            if (this.instanceCount % this.blockSize == 0) {
                this.blocks.add(new Block(this.blockSize, _isTested));
                ++this.indexOfLastBlock;
            }
            this.blocks.get(this.indexOfLastBlock).add(_dValue);
            ++this.instanceCount;
            this.total += _dValue;
        }

        public double get(int _iIndex) {
            return this.blocks.get((int)(_iIndex / this.blockSize)).data[_iIndex % this.blockSize];
        }

        public void addAt(int _iIndex, double _dValue) {
            this.blocks.get(_iIndex / this.blockSize).addAt(_iIndex % this.blockSize, _dValue);
        }

        public int getSize() {
            return this.instanceCount;
        }

        public double getTotal() {
            double dTotal = 0.0;
            for (int iIndex = 0; iIndex < this.blocks.size(); ++iIndex) {
                dTotal += this.blocks.get((int)iIndex).total;
            }
            return dTotal;
        }

        public double getFirstBlockTotal() {
            return this.blocks.get((int)0).total;
        }

        public void markLastAddedBlock() {
            if (this.blocks.size() > 0) {
                this.blocks.get(this.blocks.size() - 1).setTested(true);
            }
        }

        public void removeFirstBlock() {
            this.total -= this.blocks.get((int)0).total;
            this.blocks.remove(0);
            this.instanceCount -= this.blockSize;
            --this.indexOfLastBlock;
        }

        public void removeAll() {
            this.blocks.clear();
            this.indexOfLastBlock = -1;
            this.instanceCount = 0;
            this.total = 0.0;
        }

        public int getNumOfTests() {
            int iNumTests = 0;
            for (int iIndex = 0; iIndex < this.blocks.size(); ++iIndex) {
                if (!this.blocks.get(iIndex).IsTested()) continue;
                ++iNumTests;
            }
            return iNumTests;
        }
    }

    public class Reservoir {
        private int size;
        private double total;
        private final int blocksize;
        private final Repository dataContainer;
        private int instanceCount;
        private int MAX_SIZE;

        public Reservoir(int _iSize, int _iBlockSize) {
            this.MAX_SIZE = _iSize;
            this.total = 0.0;
            this.blocksize = _iBlockSize;
            this.instanceCount = 0;
            this.dataContainer = new Repository(this.blocksize);
        }

        public double getSampleMean() {
            return this.total / (double)this.size;
        }

        public void addElement(double _dValue) {
            try {
                if (this.size < this.MAX_SIZE) {
                    this.dataContainer.add(new Double(_dValue));
                    this.total += _dValue;
                    ++this.size;
                } else {
                    int irIndex = (int)(Math.random() * (double)this.instanceCount);
                    if (irIndex < this.MAX_SIZE) {
                        this.total -= this.dataContainer.get(irIndex);
                        this.dataContainer.addAt(irIndex, _dValue);
                        this.total += _dValue;
                    }
                }
                ++this.instanceCount;
            }
            catch (Exception e) {
                System.out.println("2 Exception" + e);
            }
        }

        public double get(int _iIndex) {
            return this.dataContainer.get(_iIndex);
        }

        public int getSize() {
            return this.size;
        }

        public void clear() {
            this.dataContainer.removeAll();
            this.total = 0.0;
            this.size = 0;
        }

        public double getTotal() {
            return this.total;
        }

        public void copy(Reservoir _oSource) {
            for (int iIndex = 0; iIndex < _oSource.getSize(); ++iIndex) {
                this.addElement(_oSource.get(iIndex));
            }
            _oSource.clear();
        }

        public void setMaxSize(int _iMaxSize) {
            this.MAX_SIZE = _iMaxSize;
        }
    }

    public class SeqDrift2
    extends AbstractMOAObject {
        private final Reservoir rightRepository;
        private final Reservoir leftReservoir;
        private final int blockSize;
        private final double significanceLevel;
        private int leftReservoirSize;
        private final int rightRepositorySize;
        private final double k;
        private int instanceCount = 0;
        private double leftReservoirMean = 0.0;
        private double rightRepositoryMean = 0.0;
        private double variance = 0.0;
        private double total = 0.0;
        private double epsilon = 0.0;
        private static final int DRIFT = 0;
        private static final int NODRIFT = 2;
        private static final int INTERNAL_DRIFT = 3;

        public SeqDrift2(double _significanceLevel, int _blockSize) {
            this.significanceLevel = _significanceLevel;
            this.blockSize = _blockSize;
            this.leftReservoirSize = _blockSize;
            this.rightRepositorySize = _blockSize;
            this.k = 0.5;
            this.instanceCount = 0;
            this.variance = 0.0;
            this.total = 0.0;
            this.epsilon = 0.0;
            this.leftReservoir = new Reservoir(this.leftReservoirSize, this.blockSize);
            this.rightRepository = new Reservoir(this.rightRepositorySize, this.blockSize);
        }

        public boolean setInput(double _inputValue) {
            ++this.instanceCount;
            this.addToRightReservoir(_inputValue);
            this.total += _inputValue;
            if (this.instanceCount % this.blockSize == 0) {
                int iDriftType = this.getDriftType();
                if (iDriftType == 0) {
                    this.clearLeftReservoir();
                    this.moveFromRepositoryToReservoir();
                    return true;
                }
                this.moveFromRepositoryToReservoir();
                return false;
            }
            return false;
        }

        private void addToRightReservoir(double _inputValue) {
            this.rightRepository.addElement(_inputValue);
        }

        private void moveFromRepositoryToReservoir() {
            this.leftReservoir.copy(this.rightRepository);
        }

        private void clearLeftReservoir() {
            this.total -= this.leftReservoir.getTotal();
            this.leftReservoir.clear();
        }

        private int getDriftType() {
            if (this.getWidth() > this.blockSize) {
                this.leftReservoirMean = this.getLeftReservoirMean();
                this.rightRepositoryMean = this.getRightRepositoryMean();
                this.optimizeEpsilon();
                if (this.instanceCount > this.blockSize && this.leftReservoir.getSize() > 0) {
                    if (this.epsilon <= Math.abs(this.rightRepositoryMean - this.leftReservoirMean)) {
                        return 0;
                    }
                    return 2;
                }
                return 2;
            }
            return 2;
        }

        private double getLeftReservoirMean() {
            return this.leftReservoir.getSampleMean();
        }

        private double getRightRepositoryMean() {
            return this.rightRepository.getSampleMean();
        }

        private double getVariance() {
            double mean = this.getMean();
            double meanminum1 = mean - 1.0;
            double size = this.getWidth();
            double x = this.getTotal() * meanminum1 * meanminum1 + (size - this.getTotal()) * mean * mean;
            double y = size - 1.0;
            return x / y;
        }

        private void optimizeEpsilon() {
            int tests = this.leftReservoir.getSize() / this.blockSize;
            if (tests >= 1) {
                double currentStepEpsilon;
                this.variance = this.getVariance();
                if (this.variance == 0.0) {
                    this.variance = 1.0E-4;
                }
                double ddeltadash = this.getDriftEpsilon(tests);
                double x = Math.log(4.0 / ddeltadash);
                double ktemp = this.k;
                double squareRootValue = 0.0;
                boolean IsNotOptimized = true;
                while (IsNotOptimized) {
                    squareRootValue = Math.sqrt(x * x + (double)(18 * this.rightRepositorySize) * x * this.variance);
                    double previousStepEpsilon = 1.0 / ((double)(3 * this.rightRepositorySize) * (1.0 - ktemp)) * (x + squareRootValue);
                    if (!((previousStepEpsilon - (currentStepEpsilon = 1.0 / ((double)(3 * this.rightRepositorySize) * (1.0 - (ktemp = 3.0 * ktemp / 4.0))) * (x + squareRootValue))) / previousStepEpsilon < 1.0E-4)) continue;
                    IsNotOptimized = false;
                }
                ktemp = 4.0 * ktemp / 3.0;
                ktemp = this.adjustForDataRate(ktemp);
                this.leftReservoirSize = (int)((double)this.rightRepositorySize * (1.0 - ktemp) / ktemp);
                this.leftReservoir.setMaxSize(this.leftReservoirSize);
                squareRootValue = Math.sqrt(x * x + (double)(18 * this.rightRepositorySize) * x * this.variance);
                this.epsilon = currentStepEpsilon = 1.0 / ((double)(3 * this.rightRepositorySize) * (1.0 - ktemp)) * (x + squareRootValue);
            }
        }

        private double getDriftEpsilon(int _inumTests) {
            double dSeriesTotal = 2.0 * (1.0 - Math.pow(0.5, _inumTests));
            double ddeltadash = this.significanceLevel / dSeriesTotal;
            return ddeltadash;
        }

        private double getMean() {
            return this.getTotal() / (double)this.getWidth();
        }

        private double getTotal() {
            return this.rightRepository.getTotal() + this.leftReservoir.getTotal();
        }

        private double adjustForDataRate(double _dKr) {
            double meanIncrease = this.rightRepository.getSampleMean() - this.leftReservoir.getSampleMean();
            double dk = _dKr;
            if (meanIncrease > 0.0) {
                dk += (-1.0 * (meanIncrease * meanIncrease * meanIncrease * meanIncrease) + 1.0) * _dKr;
            } else if (meanIncrease <= 0.0) {
                dk = _dKr;
            }
            return dk;
        }

        private int getWidth() {
            return this.leftReservoir.getSize() + this.rightRepository.getSize();
        }

        public double getEstimation() {
            int iWidth = this.getWidth();
            if (iWidth != 0) {
                return this.getTotal() / (double)this.getWidth();
            }
            return 0.0;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
        }
    }
}

