/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.NumericalDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.SsqNumericalDerivatives;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.akf.AkfToolkit;
import jdplus.toolkit.base.core.ssf.likelihood.AugmentedLikelihoodFunction;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodFunctionPoint;

public class AugmentedLikelihoodFunctionPoint<S, F extends ISsf>
implements LikelihoodFunctionPoint<DiffuseLikelihood> {
    private final F currentSsf;
    private final S current;
    private final DiffuseLikelihood ll;
    private final DoubleSeq p;
    private final DoubleSeq E;
    private final AugmentedLikelihoodFunction<S, F> fn;

    public AugmentedLikelihoodFunctionPoint(AugmentedLikelihoodFunction<S, F> fn, DoubleSeq p) {
        this.fn = fn;
        this.p = p;
        this.current = fn.getMapping().map(p);
        this.currentSsf = fn.getBuilder().buildSsf(this.current);
        boolean fastcomputer = fn.isFast() && !fn.isMissing() && this.currentSsf.isTimeInvariant();
        DiffuseLikelihood dl = null;
        DataBlock e = null;
        try {
            dl = fn.isRobust() ? AkfToolkit.robustLikelihoodComputer(fn.isScalingFactor(), fn.isResiduals()).compute((ISsf)this.currentSsf, fn.getData()) : (fastcomputer ? AkfToolkit.fastLikelihoodComputer(fn.isScalingFactor(), fn.isResiduals()).compute((ISsf)this.currentSsf, fn.getData()) : AkfToolkit.likelihoodComputer(fn.isCollapsing(), fn.isScalingFactor(), fn.isResiduals()).compute((ISsf)this.currentSsf, fn.getData()));
            if (fn.isScalingFactor()) {
                DoubleSeq res = dl.e();
                DataBlock r = DataBlock.select(res, x -> Double.isFinite(x));
                if (fn.isMaximumLikelihood()) {
                    double factor = Math.sqrt(dl.factor());
                    r.mul(factor);
                }
                e = r;
            }
        }
        catch (SsfException err) {
            dl = null;
        }
        this.ll = dl;
        this.E = e;
    }

    public F getSsf() {
        return this.currentSsf;
    }

    public S getCore() {
        return this.current;
    }

    @Override
    public DoubleSeq getE() {
        return this.E;
    }

    @Override
    public DiffuseLikelihood getLikelihood() {
        return this.ll;
    }

    @Override
    public DoubleSeq getParameters() {
        return this.p;
    }

    @Override
    public double getSsqE() {
        if (this.ll == null) {
            return Double.NaN;
        }
        return this.fn.isMaximumLikelihood() ? this.ll.ssq() * this.ll.factor() : this.ll.ssq();
    }

    @Override
    public double getValue() {
        if (this.ll == null) {
            return Double.NaN;
        }
        if (this.fn.isLog()) {
            return this.fn.isMaximumLikelihood() ? -this.ll.logLikelihood() : Math.log(this.ll.ssq());
        }
        return this.fn.isMaximumLikelihood() ? this.ll.ssq() * this.ll.factor() : this.ll.ssq();
    }

    @Override
    public ISsqFunction getSsqFunction() {
        return this.fn;
    }

    @Override
    public IFunction getFunction() {
        return this.fn;
    }

    @Override
    public IFunctionDerivatives derivatives() {
        return new NumericalDerivatives(this, this.fn.isSymmetric(), this.fn.isMultiThreaded());
    }

    @Override
    public ISsqFunctionDerivatives ssqDerivatives() {
        return new SsqNumericalDerivatives(this, this.fn.isSymmetric(), this.fn.isMultiThreaded());
    }
}

