/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public abstract class AbstractPropDistanceXYZ
extends Propagator<IntVar> {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;

    public AbstractPropDistanceXYZ(IntVar[] vars) {
        super((Variable[])vars, (Priority)PropagatorPriority.TERNARY, true);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    public final void propagate() throws ContradictionException {
        do {
            boolean change = this.filterFromXYtoZ();
            change |= this.filterFromYZToX();
        } while (change |= this.filterFromXZToY());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.propagate();
    }

    protected abstract boolean filterFromYZToX() throws ContradictionException;

    protected abstract boolean filterFromXZToY() throws ContradictionException;

    protected abstract boolean filterFromXYtoZ() throws ContradictionException;

    public boolean filterFromXYtoLBZ(int delta) throws ContradictionException {
        int dYX = ((IntVar[])this.vars)[1].getLB() - ((IntVar[])this.vars)[0].getUB();
        if (dYX > 0) {
            return ((IntVar[])this.vars)[2].updateLowerBound(dYX + delta, (ICause)this);
        }
        int dXY = ((IntVar[])this.vars)[0].getLB() - ((IntVar[])this.vars)[1].getUB();
        return dXY > 0 && ((IntVar[])this.vars)[2].updateLowerBound(dXY + delta, (ICause)this);
    }

    public boolean filterFromXYtoUBZ(int delta) throws ContradictionException {
        int a = Math.abs(((IntVar[])this.vars)[1].getUB() - ((IntVar[])this.vars)[0].getLB());
        int b = Math.abs(((IntVar[])this.vars)[0].getUB() - ((IntVar[])this.vars)[1].getLB());
        return ((IntVar[])this.vars)[2].updateUpperBound((a > b ? a : b) - delta, (ICause)this);
    }

    public boolean filterLowerFromIZToJ(int i, int j, int delta) throws ContradictionException {
        int lI = ((IntVar[])this.vars)[i].getLB();
        int uI = ((IntVar[])this.vars)[i].getUB();
        int uZ = ((IntVar[])this.vars)[2].getUB();
        int lb = lI - uZ + delta;
        int ub = uI + uZ - delta;
        return ((IntVar[])this.vars)[j].updateBounds(lb, ub, this);
    }

    public boolean filterGreaterFromIZToJ(int i, int j, int delta) throws ContradictionException {
        int lI = ((IntVar[])this.vars)[i].getLB();
        int uI = ((IntVar[])this.vars)[i].getUB();
        int lZ = ((IntVar[])this.vars)[2].getLB();
        int lbv = uI - lZ + delta;
        int ubv = lI + lZ - delta;
        return ((IntVar[])this.vars)[j].removeInterval(lbv, ubv, this);
    }

    protected abstract boolean isEntailed(int var1, int var2);

    protected abstract String getOperator();

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int distance = Math.abs(((IntVar[])this.vars)[0].getValue() - ((IntVar[])this.vars)[1].getValue());
            int z = ((IntVar[])this.vars)[2].getValue();
            return ESat.eval(this.isEntailed(distance, z));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "|" + ((IntVar[])this.vars)[0] + " - " + ((IntVar[])this.vars)[1] + "| " + this.getOperator() + " " + ((IntVar[])this.vars)[2];
    }
}

