
<!-- README.md is generated from README.Rmd. Please edit that file -->

# rcolors: 270 ncl colormaps in R

<!-- badges: start -->
[![AppVeyor build status](https://ci.appveyor.com/api/projects/status/github/kongdd/rcolors?branch=master&svg=true)](https://ci.appveyor.com/project/kongdd/rcolormap)
[![Travis build status](https://travis-ci.com/kongdd/rcolors.svg?branch=master)](https://travis-ci.com/kongdd/rcolors)
[![Codecov test coverage](https://codecov.io/gh/kongdd/rcolors/branch/master/graph/badge.svg)](https://codecov.io/gh/kongdd/rcolors?branch=master)
<!-- badges: end -->

## Installation

``` r
devtools::install_github("kongdd/rcolors")
```

## Example

This is a basic example which shows you how to use `rcolors`:

``` r
library(rcolors)
rcolors$amwg_blueyellowred %>% show_cols()
```

<img src="man/figures/README-get_color-1.svg" width="100%" />

``` r
get_color("amwg_blueyellowred", n = 20)
#>  [1] "#8220F0" "#1B06A8" "#0000B5" "#1726D4" "#3B6FE5" "#1F8DFD" "#07B2FF"
#>  [8] "#54C9FF" "#AFDDFF" "#D6F6F9" "#FAFDCD" "#FFEA61" "#FFC61A" "#FF9A00"
#> [15] "#FF6800" "#FF1100" "#DC0000" "#B70E0E" "#B33141" "#FF69B4"
```

``` r
print(names(rcolors2))
#>  [1] "rainbow"                "small rainbow"          "earth_ocean"           
#>  [4] "oceanography"           "aid in color blindness" "meteoswiss"            
#>  [7] "blue_red"               "blue_green"             "red_orange"            
#> [10] "red_green"              "green_yellow"           "red_purple"            
#> [13] "blue_purple"            "green_purple"           "brown_copper"          
#> [16] "blue_yellow_red"        "blue"                   "purple"                
#> [19] "green"                  "gray"                   "banded"                
#> [22] "faded"                  "circular"               "miscellaneous"         
#> [25] "vegetation"             "white-in-the-middle"    "starts-with-white"     
#> [28] "gmt"                    "grads"                  "matplotlib"            
#> [31] "ncview"                 "svg"                    "colorbrewer"
show_cols(rcolors2$rainbow, margin = 14)
```

<img src="man/figures/README-show_cols-1.svg" width="100%" />

# Color Table Gallery

[about color
tables](https://www.ncl.ucar.edu/Document/Graphics/color_tables.shtml) |
[named
colors](https://www.ncl.ucar.edu/Document/Graphics/named_colors.shtml)

| [Rainbow](#rainbow)                         | [Small rainbow](#small-rainbow)         | [Earth/Ocean](#Earth_Ocean) | [Oceanography](#Oceanography)   | [Aid in color blindness](#Aid_in_color_blindness) |
| ------------------------------------------- | --------------------------------------- | --------------------------- | ------------------------------- | ------------------------------------------------- |
| [MeteoSwiss](#MeteoSwiss)                   | [Blue/Red](#Blue_Red)                   | [Blue/Green](#Blue_Green)   | [Red/Orange](#Red_Orange)       | [Red/Green](#Red_Green)                           |
| [Green/Yellow](#Green_Yellow)               | [Red/Purple](#Red_Purple)               | [Blue/Purple](#Blue_Purple) | [Green/Purple](#Green_Purple)   | [Brown/Copper](#Brown_Copper)                     |
| [Blue/Yellow/Red](#Blue_Yellow_Red)         | [Blue](#Blue)                           | [Purple](#Purple)           | [Green](#Green)                 | [Gray](#Gray)                                     |
| [Banded](#Banded)                           | [Faded](#Faded)                         | [Circular](#Circular)       | [Miscellaneous](#Miscellaneous) | [Vegetation](#Vegetation)                         |
| [White-in-the-middle](#White-in-the-middle) | [Starts-with-white](#Starts-with-white) | [GMT](#GMT)                 | [GrADS](#GrADS)                 | [matplotlib](#matplotlib)                         |
| [Ncview](#Ncview)                           | [SVG](#SVG)                             | [ColorBrewer](#ColorBrewer) |                                 |                                                   |

## Rainbow

| amwg256<br>[![img](images/amwg256_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/amwg256.shtml) n=254       | BkBlAqGrYeOrReViWh200<br>[![img](images/BkBlAqGrYeOrReViWh200_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BkBlAqGrYeOrReViWh200.shtml) n=200       | BlAqGrYeOrRe<br>[![img](images/BlAqGrYeOrRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlAqGrYeOrRe.shtml) n=100       | BlAqGrYeOrReVi200<br>[![img](images/BlAqGrYeOrReVi200_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlAqGrYeOrReVi200.shtml) n=200 |
| ------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| BlGrYeOrReVi200<br>[![img](images/BlGrYeOrReVi200_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlGrYeOrReVi200.shtml) n=200 | example<br>[![img](images/example_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/example.shtml) n=113                                                 | GMT\_seis<br>[![img](images/GMT_seis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_seis.shtml) n=256                  | GMT\_wysiwygcont<br>[![img](images/GMT_wysiwygcont_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_wysiwygcont.shtml) n=200      |
| matlab\_hsv<br>[![img](images/matlab_hsv_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/matlab_hsv.shtml) n=64                | matlab\_jet<br>[![img](images/matlab_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/matlab_jet.shtml) n=64                                        | MPL\_gist\_ncar<br>[![img](images/MPL_gist_ncar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_ncar.shtml) n=128  | MPL\_gist\_rainbow<br>[![img](images/MPL_gist_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_rainbow.shtml) n=128  |
| MPL\_hsv<br>[![img](images/MPL_hsv_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_hsv.shtml) n=128                        | MPL\_jet<br>[![img](images/MPL_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_jet.shtml) n=128                                                | MPL\_rainbow<br>[![img](images/MPL_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_rainbow.shtml) n=128         | MPL\_Spectral<br>[![img](images/MPL_Spectral_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Spectral.shtml) n=128               |
| NCV\_bright<br>[![img](images/NCV_bright_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_bright.shtml) n=256               | NCV\_jaisnd<br>[![img](images/NCV_jaisnd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_jaisnd.shtml) n=256                                       | NCV\_jet<br>[![img](images/NCV_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_jet.shtml) n=256                     | NCV\_rainbow2<br>[![img](images/NCV_rainbow2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_rainbow2.shtml) n=256               |
| ncview\_default<br>[![img](images/ncview_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/ncview_default.shtml) n=254   | nice\_gfdl<br>[![img](images/nice_gfdl_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/nice_gfdl.shtml) n=225                                          | rainbow<br>[![img](images/rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/rainbow.shtml) n=188                      | rainbow+gray<br>[![img](images/rainbow+gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/rainbow+gray.shtml) n=237                |
| rainbow+white<br>[![img](images/rainbow+white_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/rainbow+white.shtml) n=237       | rainbow+white+gray<br>[![img](images/rainbow+white+gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/rainbow+white+gray.shtml) n=238                | tbr\_240-300<br>[![img](images/tbr_240-300_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/tbr_240-300.shtml) n=200         | tbr\_stdev\_0-30<br>[![img](images/tbr_stdev_0-30_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/tbr_stdev_0-30.shtml) n=200        |
| tbr\_var\_0-500<br>[![img](images/tbr_var_0-500_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/tbr_var_0-500.shtml) n=200     | tbrAvg1<br>[![img](images/tbrAvg1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/tbrAvg1.shtml) n=100                                                 | tbrStd1<br>[![img](images/tbrStd1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/tbrStd1.shtml) n=101                      | tbrVar1<br>[![img](images/tbrVar1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/tbrVar1.shtml) n=101                               |
| temp1<br>[![img](images/temp1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp1.shtml) n=61                                | testcmap<br>[![img](images/testcmap_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/testcmap.shtml) n=199                                              | ViBlGrWhYeOrRe<br>[![img](images/ViBlGrWhYeOrRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/ViBlGrWhYeOrRe.shtml) n=101 | wh-bl-gr-ye-re<br>[![img](images/wh-bl-gr-ye-re_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/wh-bl-gr-ye-re.shtml) n=199          |
| WhBlGrYeRe<br>[![img](images/WhBlGrYeRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhBlGrYeRe.shtml) n=100                | WhiteBlueGreenYellowRed<br>[![img](images/WhiteBlueGreenYellowRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteBlueGreenYellowRed.shtml) n=254 | WhViBlGrYeOrRe<br>[![img](images/WhViBlGrYeOrRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhViBlGrYeOrRe.shtml) n=101 | WhViBlGrYeOrReWh<br>[![img](images/WhViBlGrYeOrReWh_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhViBlGrYeOrReWh.shtml) n=101    |

## Small rainbow

| amwg<br>[![img](images/amwg_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/amwg.shtml) n=16                       | BlAqGrWh2YeOrReVi22<br>[![img](images/BlAqGrWh2YeOrReVi22_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlAqGrWh2YeOrReVi22.shtml) n=22 | cosam<br>[![img](images/cosam_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cosam.shtml) n=10                    | cosam12<br>[![img](images/cosam12_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cosam12.shtml) n=12                    |
| ------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- |
| cyclic<br>[![img](images/cyclic_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cyclic.shtml) n=6                  | GHRSST\_anomaly<br>[![img](images/GHRSST_anomaly_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GHRSST_anomaly.shtml) n=42               | GMT\_wysiwyg<br>[![img](images/GMT_wysiwyg_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_wysiwyg.shtml) n=20 | grads\_rainbow<br>[![img](images/grads_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/grads_rainbow.shtml) n=13 |
| gui\_default<br>[![img](images/gui_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/gui_default.shtml) n=22 | prcp\_1<br>[![img](images/prcp_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/prcp_1.shtml) n=17                                       | prcp\_2<br>[![img](images/prcp_2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/prcp_2.shtml) n=12                | prcp\_3<br>[![img](images/prcp_3_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/prcp_3.shtml) n=23                      |
| radar<br>[![img](images/radar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/radar.shtml) n=15                    | radar\_1<br>[![img](images/radar_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/radar_1.shtml) n=24                                    | seaice\_1<br>[![img](images/seaice_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/seaice_1.shtml) n=13          | seaice\_2<br>[![img](images/seaice_2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/seaice_2.shtml) n=14                |
| so4\_21<br>[![img](images/so4_21_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/so4_21.shtml) n=21                | so4\_23<br>[![img](images/so4_23_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/so4_23.shtml) n=23                                       | wgne15<br>[![img](images/wgne15_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/wgne15.shtml) n=15                 |                                                                                                                                                   |

## Earth/Ocean

| cmocean\_deep<br>[![img](images/cmocean_deep_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_deep.shtml) n=256                          | cmp\_haxby<br>[![img](images/cmp_haxby_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmp_haxby.shtml) n=64             | GMT\_drywet<br>[![img](images/GMT_drywet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_drywet.shtml) n=60 | GMT\_globe<br>[![img](images/GMT_globe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_globe.shtml) n=256                        |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| GMT\_haxby<br>[![img](images/GMT_haxby_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_haxby.shtml) n=32                                    | GMT\_nighttime<br>[![img](images/GMT_nighttime_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_nighttime.shtml) n=20 | GMT\_ocean<br>[![img](images/GMT_ocean_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_ocean.shtml) n=80    | GMT\_relief<br>[![img](images/GMT_relief_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_relief.shtml) n=256                     |
| GMT\_relief\_oceanonly<br>[![img](images/GMT_relief_oceanonly_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_relief_oceanonly.shtml) n=160 | GMT\_topo<br>[![img](images/GMT_topo_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_topo.shtml) n=256               | MPL\_BrBG<br>[![img](images/MPL_BrBG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BrBG.shtml) n=128      | MPL\_gist\_earth<br>[![img](images/MPL_gist_earth_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_earth.shtml) n=128        |
| MPL\_ocean<br>[![img](images/MPL_ocean_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_ocean.shtml) n=128                                   | MPL\_terrain<br>[![img](images/MPL_terrain_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_terrain.shtml) n=128      | NCV\_gebco<br>[![img](images/NCV_gebco_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_gebco.shtml) n=24    | OceanLakeLandSnow<br>[![img](images/OceanLakeLandSnow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/OceanLakeLandSnow.shtml) n=254 |
| topo\_15lev<br>[![img](images/topo_15lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/topo_15lev.shtml) n=16                                 |                                                                                                                                                   |                                                                                                                                          |                                                                                                                                                               |

## Oceanography

| cmocean\_algae<br>[![img](images/cmocean_algae_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_algae.shtml) n=256       | cmocean\_amp<br>[![img](images/cmocean_amp_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_amp.shtml) n=256          | cmocean\_balance<br>[![img](images/cmocean_balance_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_balance.shtml) n=256 | cmocean\_curl<br>[![img](images/cmocean_curl_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_curl.shtml) n=256    |
| -------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------- |
| cmocean\_deep<br>[![img](images/cmocean_deep_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_deep.shtml) n=256          | cmocean\_delta<br>[![img](images/cmocean_delta_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_delta.shtml) n=256    | cmocean\_dense<br>[![img](images/cmocean_dense_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_dense.shtml) n=256       | cmocean\_gray<br>[![img](images/cmocean_gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_gray.shtml) n=256    |
| cmocean\_haline<br>[![img](images/cmocean_haline_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_haline.shtml) n=256    | cmocean\_ice<br>[![img](images/cmocean_ice_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_ice.shtml) n=256          | cmocean\_matter<br>[![img](images/cmocean_matter_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_matter.shtml) n=256    | cmocean\_oxy<br>[![img](images/cmocean_oxy_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_oxy.shtml) n=256       |
| cmocean\_phase<br>[![img](images/cmocean_phase_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_phase.shtml) n=256       | cmocean\_solar<br>[![img](images/cmocean_solar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_solar.shtml) n=256    | cmocean\_speed<br>[![img](images/cmocean_speed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_speed.shtml) n=256       | cmocean\_tempo<br>[![img](images/cmocean_tempo_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_tempo.shtml) n=256 |
| cmocean\_thermal<br>[![img](images/cmocean_thermal_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_thermal.shtml) n=256 | cmocean\_turbid<br>[![img](images/cmocean_turbid_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_turbid.shtml) n=256 |                                                                                                                                                          |                                                                                                                                                    |

## Aid in color blindness

| BlueDarkOrange18<br>[![img](images/BlueDarkOrange18_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueDarkOrange18.shtml) n=18 | BlueDarkRed18<br>[![img](images/BlueDarkRed18_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueDarkRed18.shtml) n=18 | BlueGreen14<br>[![img](images/BlueGreen14_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueGreen14.shtml) n=14 | BrownBlue12<br>[![img](images/BrownBlue12_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BrownBlue12.shtml) n=12              |
| --------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Cat12<br>[![img](images/Cat12_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/Cat12.shtml) n=12                                  | cb\_9step<br>[![img](images/cb_9step_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cb_9step.shtml) n=78               | cb\_rainbow<br>[![img](images/cb_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cb_rainbow.shtml) n=241  | cb\_rainbow\_inv<br>[![img](images/cb_rainbow_inv_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cb_rainbow_inv.shtml) n=241  |
| CBR\_coldhot<br>[![img](images/CBR_coldhot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_coldhot.shtml) n=11               | CBR\_drywet<br>[![img](images/CBR_drywet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_drywet.shtml) n=11         | CBR\_wet<br>[![img](images/CBR_wet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_wet.shtml) n=11            | cividis<br>[![img](images/cividis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cividis.shtml) n=256                         |
| GreenMagenta16<br>[![img](images/GreenMagenta16_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GreenMagenta16.shtml) n=16       | posneg\_1<br>[![img](images/posneg_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/posneg_1.shtml) n=19               | posneg\_2<br>[![img](images/posneg_2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/posneg_2.shtml) n=20         | srip\_reanalysis<br>[![img](images/srip_reanalysis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/srip_reanalysis.shtml) n=19 |
| StepSeq25<br>[![img](images/StepSeq25_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/StepSeq25.shtml) n=25                      |                                                                                                                                                  |                                                                                                                                            |                                                                                                                                                         |

## [MeteoSwiss](https://www.meteoswiss.admin.ch/home.html)

| hotcold\_18lev<br>[![img](images/hotcold_18lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotcold_18lev.shtml) n=19                    | hotcolr\_19lev<br>[![img](images/hotcolr_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotcolr_19lev.shtml) n=20                 | mch\_default<br>[![img](images/mch_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/mch_default.shtml) n=15       | perc2\_9lev<br>[![img](images/perc2_9lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/perc2_9lev.shtml) n=10                       |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| percent\_11lev<br>[![img](images/percent_11lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/percent_11lev.shtml) n=12                    | precip2\_15lev<br>[![img](images/precip2_15lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip2_15lev.shtml) n=16                 | precip2\_17lev<br>[![img](images/precip2_17lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip2_17lev.shtml) n=18 | precip3\_16lev<br>[![img](images/precip3_16lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip3_16lev.shtml) n=17              |
| precip4\_11lev<br>[![img](images/precip4_11lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip4_11lev.shtml) n=12                    | precip4\_diff\_19lev<br>[![img](images/precip4_diff_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip4_diff_19lev.shtml) n=20 | precip\_11lev<br>[![img](images/precip_11lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_11lev.shtml) n=12    | precip\_diff\_12lev<br>[![img](images/precip_diff_12lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_diff_12lev.shtml) n=13 |
| precip\_diff\_1lev<br>[![img](images/precip_diff_1lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_diff_1lev.shtml) n=2           | rh\_19lev<br>[![img](images/rh_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/rh_19lev.shtml) n=20                                | spread\_15lev<br>[![img](images/spread_15lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/spread_15lev.shtml) n=16    | sunshine\_9lev<br>[![img](images/sunshine_9lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/sunshine_9lev.shtml) n=10              |
| sunshine\_diff\_12lev<br>[![img](images/sunshine_diff_12lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/sunshine_diff_12lev.shtml) n=13 | t2m\_29lev<br>[![img](images/t2m_29lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/t2m_29lev.shtml) n=30                             | temp\_19lev<br>[![img](images/temp_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_19lev.shtml) n=20          | temp\_diff\_18lev<br>[![img](images/temp_diff_18lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_diff_18lev.shtml) n=19       |
| temp\_diff\_1lev<br>[![img](images/temp_diff_1lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_diff_1lev.shtml) n=2                 | topo\_15lev<br>[![img](images/topo_15lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/topo_15lev.shtml) n=16                          | wind\_17lev<br>[![img](images/wind_17lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/wind_17lev.shtml) n=18          |                                                                                                                                                                |

## Blue/Red

| BlRe<br>[![img](images/BlRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlRe.shtml) n=96                        | BlueDarkRed18<br>[![img](images/BlueDarkRed18_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueDarkRed18.shtml) n=18 | BlueRed<br>[![img](images/BlueRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueRed.shtml) n=252                          | BlueRedGray<br>[![img](images/BlueRedGray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueRedGray.shtml) n=253          |
| -------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------- |
| BlWhRe<br>[![img](images/BlWhRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlWhRe.shtml) n=101                 | CBR\_coldhot<br>[![img](images/CBR_coldhot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_coldhot.shtml) n=11      | cmocean\_balance<br>[![img](images/cmocean_balance_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_balance.shtml) n=256 | cmp\_b2r<br>[![img](images/cmp_b2r_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmp_b2r.shtml) n=64                      |
| GMT\_polar<br>[![img](images/GMT_polar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_polar.shtml) n=20        | GMT\_split<br>[![img](images/GMT_split_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_split.shtml) n=40            | hotcold\_18lev<br>[![img](images/hotcold_18lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotcold_18lev.shtml) n=19        | hotcolr\_19lev<br>[![img](images/hotcolr_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotcolr_19lev.shtml) n=20    |
| hotres<br>[![img](images/hotres_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotres.shtml) n=254                 | MPL\_bwr<br>[![img](images/MPL_bwr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_bwr.shtml) n=128                 | MPL\_coolwarm<br>[![img](images/MPL_coolwarm_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_coolwarm.shtml) n=128          | MPL\_RdBu<br>[![img](images/MPL_RdBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdBu.shtml) n=128                  |
| MPL\_seismic<br>[![img](images/MPL_seismic_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_seismic.shtml) n=128 | NCV\_blu\_red<br>[![img](images/NCV_blu_red_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_blu_red.shtml) n=256    | NCV\_blue\_red<br>[![img](images/NCV_blue_red_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_blue_red.shtml) n=256         | posneg\_1<br>[![img](images/posneg_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/posneg_1.shtml) n=19                   |
| posneg\_2<br>[![img](images/posneg_2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/posneg_2.shtml) n=20           | temp\_19lev<br>[![img](images/temp_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_19lev.shtml) n=20         | temp\_diff\_18lev<br>[![img](images/temp_diff_18lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_diff_18lev.shtml) n=19 | temp\_diff\_1lev<br>[![img](images/temp_diff_1lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_diff_1lev.shtml) n=2 |
| WhBlReWh<br>[![img](images/WhBlReWh_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhBlReWh.shtml) n=100           |                                                                                                                                                  |                                                                                                                                                          |                                                                                                                                                      |

## Blue/Green

| BlueGreen14<br>[![img](images/BlueGreen14_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueGreen14.shtml) n=14   | CBR\_wet<br>[![img](images/CBR_wet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_wet.shtml) n=11           | cmocean\_deep<br>[![img](images/cmocean_deep_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_deep.shtml) n=256                          | cmocean\_haline<br>[![img](images/cmocean_haline_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_haline.shtml) n=256                                |
| -------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| GMT\_gebco<br>[![img](images/GMT_gebco_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_gebco.shtml) n=70        | GMT\_ocean<br>[![img](images/GMT_ocean_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_ocean.shtml) n=80     | GMT\_relief\_oceanonly<br>[![img](images/GMT_relief_oceanonly_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_relief_oceanonly.shtml) n=160 | GSFC\_landsat\_udf\_density<br>[![img](images/GSFC_landsat_udf_density_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GSFC_landsat_udf_density.shtml) n=11 |
| MPL\_BuGn<br>[![img](images/MPL_BuGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BuGn.shtml) n=128          | MPL\_GnBu<br>[![img](images/MPL_GnBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_GnBu.shtml) n=128       | MPL\_ocean<br>[![img](images/MPL_ocean_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_ocean.shtml) n=128                                   | MPL\_PuBuGn<br>[![img](images/MPL_PuBuGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuBuGn.shtml) n=128                                            |
| MPL\_viridis<br>[![img](images/MPL_viridis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_viridis.shtml) n=256 | MPL\_winter<br>[![img](images/MPL_winter_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_winter.shtml) n=128 | MPL\_YlGnBu<br>[![img](images/MPL_YlGnBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlGnBu.shtml) n=128                                |                                                                                                                                                                                      |

## Red/Orange

| cmocean\_matter<br>[![img](images/cmocean_matter_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_matter.shtml) n=256 | GMT\_hot<br>[![img](images/GMT_hot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_hot.shtml) n=100                  | hotres<br>[![img](images/hotres_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotres.shtml) n=254                                           | matlab\_hot<br>[![img](images/matlab_hot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/matlab_hot.shtml) n=64  |
| ----------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- |
| MPL\_afmhot<br>[![img](images/MPL_afmhot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_afmhot.shtml) n=128             | MPL\_autumn<br>[![img](images/MPL_autumn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_autumn.shtml) n=128         | MPL\_gist\_heat<br>[![img](images/MPL_gist_heat_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_heat.shtml) n=128                    | MPL\_hot<br>[![img](images/MPL_hot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_hot.shtml) n=128          |
| MPL\_Oranges<br>[![img](images/MPL_Oranges_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Oranges.shtml) n=128          | MPL\_OrRd<br>[![img](images/MPL_OrRd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_OrRd.shtml) n=128               | MPL\_Reds<br>[![img](images/MPL_Reds_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Reds.shtml) n=128                                    | MPL\_YlOrBr<br>[![img](images/MPL_YlOrBr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlOrBr.shtml) n=128 |
| MPL\_YlOrRd<br>[![img](images/MPL_YlOrRd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlOrRd.shtml) n=128             | sunshine\_9lev<br>[![img](images/sunshine_9lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/sunshine_9lev.shtml) n=10 | WhiteYellowOrangeRed<br>[![img](images/WhiteYellowOrangeRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteYellowOrangeRed.shtml) n=254 |                                                                                                                                           |

## Red/Green

| cmocean\_curl<br>[![img](images/cmocean_curl_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_curl.shtml) n=256 | drought\_severity<br>[![img](images/drought_severity_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/drought_severity.shtml) n=7 | GMT\_red2green<br>[![img](images/GMT_red2green_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_red2green.shtml) n=20 | helix1<br>[![img](images/helix1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/helix1.shtml) n=254 |
| ----------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- |
| MPL\_RdYlGn<br>[![img](images/MPL_RdYlGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdYlGn.shtml) n=128       | SVG\_fs2006<br>[![img](images/SVG_fs2006_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_fs2006.shtml) n=220                 |                                                                                                                                                   |                                                                                                                              |

## Green/Yellow

| cmocean\_speed<br>[![img](images/cmocean_speed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_speed.shtml) n=256 | GreenYellow<br>[![img](images/GreenYellow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GreenYellow.shtml) n=252 | MPL\_summer<br>[![img](images/MPL_summer_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_summer.shtml) n=128 | MPL\_YlGn<br>[![img](images/MPL_YlGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlGn.shtml) n=128 |
| -------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                                    |                                                                                                                                             |                                                                                                                                           |                                                                                                                                     |

## Red/Purple

| cmocean\_matter<br>[![img](images/cmocean_matter_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_matter.shtml) n=256                | MPL\_gnuplot<br>[![img](images/MPL_gnuplot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gnuplot.shtml) n=128 | MPL\_PuRd<br>[![img](images/MPL_PuRd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuRd.shtml) n=128 | MPL\_RdPu<br>[![img](images/MPL_RdPu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdPu.shtml) n=128 |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
| sunshine\_diff\_12lev<br>[![img](images/sunshine_diff_12lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/sunshine_diff_12lev.shtml) n=13 |                                                                                                                                              |                                                                                                                                     |                                                                                                                                     |

## Blue/Purple

| cmocean\_dense<br>[![img](images/cmocean_dense_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_dense.shtml) n=256 | GMT\_cool<br>[![img](images/GMT_cool_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_cool.shtml) n=10 | MPL\_cool<br>[![img](images/MPL_cool_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_cool.shtml) n=128 |
| -------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                                    |                                                                                                                                    |                                                                                                                                     |

## Green/Purple

| GreenMagenta16<br>[![img](images/GreenMagenta16_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GreenMagenta16.shtml) n=16 | MPL\_PRGn<br>[![img](images/MPL_PRGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PRGn.shtml) n=128 |
| --------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                                     |                                                                                                                                     |

## Brown/Copper

| BlueDarkOrange18<br>[![img](images/BlueDarkOrange18_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueDarkOrange18.shtml) n=18 | BrownBlue12<br>[![img](images/BrownBlue12_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BrownBlue12.shtml) n=12                             | CBR\_drywet<br>[![img](images/CBR_drywet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_drywet.shtml) n=11                       | cmocean\_turbid<br>[![img](images/cmocean_turbid_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_turbid.shtml) n=256      |
| --------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
| GMT\_copper<br>[![img](images/GMT_copper_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_copper.shtml) n=50                  | MPL\_BrBG<br>[![img](images/MPL_BrBG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BrBG.shtml) n=128                                    | MPL\_copper<br>[![img](images/MPL_copper_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_copper.shtml) n=128                      | MPL\_pink<br>[![img](images/MPL_pink_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_pink.shtml) n=128                        |
| MPL\_s3pcpn<br>[![img](images/MPL_s3pcpn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_s3pcpn.shtml) n=128                 | OceanLakeLandSnow<br>[![img](images/OceanLakeLandSnow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/OceanLakeLandSnow.shtml) n=254          | precip\_diff\_12lev<br>[![img](images/precip_diff_12lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_diff_12lev.shtml) n=13 | precip\_diff\_1lev<br>[![img](images/precip_diff_1lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_diff_1lev.shtml) n=2 |
| SVG\_bhw3\_22<br>[![img](images/SVG_bhw3_22_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_bhw3_22.shtml) n=220             | SVG\_es\_landscape\_79<br>[![img](images/SVG_es_landscape_79_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_es_landscape_79.shtml) n=220 |                                                                                                                                                                |                                                                                                                                                            |

## Blue/Yellow/Red

| amwg\_blueyellowred<br>[![img](images/amwg_blueyellowred_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/amwg_blueyellowred.shtml) n=16 | BlueWhiteOrangeRed<br>[![img](images/BlueWhiteOrangeRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueWhiteOrangeRed.shtml) n=254 | BlueYellowRed<br>[![img](images/BlueYellowRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueYellowRed.shtml) n=254 | cmp\_b2r<br>[![img](images/cmp_b2r_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmp_b2r.shtml) n=64                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| cmp\_flux<br>[![img](images/cmp_flux_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmp_flux.shtml) n=22                               | GMT\_jet<br>[![img](images/GMT_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_jet.shtml) n=256                                 | GMT\_no\_green<br>[![img](images/GMT_no_green_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_no_green.shtml) n=16   | GMT\_panoply<br>[![img](images/GMT_panoply_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_panoply.shtml) n=16                       |
| MPL\_RdYlBu<br>[![img](images/MPL_RdYlBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdYlBu.shtml) n=128                        | ncl\_default<br>[![img](images/ncl_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/ncl_default.shtml) n=254                     | nrl\_sirkes<br>[![img](images/nrl_sirkes_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/nrl_sirkes.shtml) n=21          | nrl\_sirkes\_nowhite<br>[![img](images/nrl_sirkes_nowhite_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/nrl_sirkes_nowhite.shtml) n=19 |
| UKM\_hadcrut<br>[![img](images/UKM_hadcrut_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/UKM_hadcrut.shtml) n=12                      |                                                                                                                                                                  |                                                                                                                                                   |                                                                                                                                                                   |

## Blue

| cmocean\_ice<br>[![img](images/cmocean_ice_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_ice.shtml) n=256 | MPL\_Blues<br>[![img](images/MPL_Blues_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Blues.shtml) n=128 | MPL\_PuBu<br>[![img](images/MPL_PuBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuBu.shtml) n=128 | WhiteBlue<br>[![img](images/WhiteBlue_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteBlue.shtml) n=254 |
| -------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                              |                                                                                                                                        |                                                                                                                                     |                                                                                                                                       |

## Purple

| MPL\_BuPu<br>[![img](images/MPL_BuPu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BuPu.shtml) n=128 | MPL\_Purples<br>[![img](images/MPL_Purples_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Purples.shtml) n=128 |
| ----------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                     |                                                                                                                                              |

## Green

| cmocean\_algae<br>[![img](images/cmocean_algae_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_algae.shtml) n=256 | cmocean\_tempo<br>[![img](images/cmocean_tempo_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_tempo.shtml) n=256 | MPL\_BuGn<br>[![img](images/MPL_BuGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BuGn.shtml) n=128 | MPL\_Greens<br>[![img](images/MPL_Greens_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Greens.shtml) n=128 |
| -------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- |
| WhiteGreen<br>[![img](images/WhiteGreen_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteGreen.shtml) n=254           |                                                                                                                                                    |                                                                                                                                     |                                                                                                                                           |

## Gray

| cmocean\_gray<br>[![img](images/cmocean_gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_gray.shtml) n=256     | GMT\_gray<br>[![img](images/GMT_gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_gray.shtml) n=10                  | GMT\_relief\_oceanonly<br>[![img](images/GMT_relief_oceanonly_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_relief_oceanonly.shtml) n=160 | GrayWhiteGray<br>[![img](images/GrayWhiteGray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GrayWhiteGray.shtml) n=254 |
| --------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------- |
| gscyclic<br>[![img](images/gscyclic_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/gscyclic.shtml) n=6                    | gsdtol<br>[![img](images/gsdtol_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/gsdtol.shtml) n=31                         | gsltod<br>[![img](images/gsltod_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/gsltod.shtml) n=31                                              | mch\_default<br>[![img](images/mch_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/mch_default.shtml) n=15       |
| MPL\_gist\_gray<br>[![img](images/MPL_gist_gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_gray.shtml) n=128 | MPL\_gist\_yarg<br>[![img](images/MPL_gist_yarg_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_yarg.shtml) n=128 | MPL\_Greys<br>[![img](images/MPL_Greys_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Greys.shtml) n=128                                   | MPL\_RdGy<br>[![img](images/MPL_RdGy_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdGy.shtml) n=128               |
| wxpEnIR<br>[![img](images/wxpEnIR_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/wxpEnIR.shtml) n=100                     |                                                                                                                                                     |                                                                                                                                                                          |                                                                                                                                                   |

## Banded

| 3gauss<br>[![img](images/3gauss_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/3gauss.shtml) n=254                    | 3saw<br>[![img](images/3saw_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/3saw.shtml) n=254                          | cb\_9step<br>[![img](images/cb_9step_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cb_9step.shtml) n=78              | detail<br>[![img](images/detail_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/detail.shtml) n=254              |
| ----------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- |
| extrema<br>[![img](images/extrema_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/extrema.shtml) n=254                 | matlab\_lines<br>[![img](images/matlab_lines_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/matlab_lines.shtml) n=64  | MPL\_StepSeq<br>[![img](images/MPL_StepSeq_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_StepSeq.shtml) n=128    | NCV\_banded<br>[![img](images/NCV_banded_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_banded.shtml) n=256 |
| NCV\_manga<br>[![img](images/NCV_manga_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_manga.shtml) n=256          | NCV\_roullet<br>[![img](images/NCV_roullet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_roullet.shtml) n=256    | psgcap<br>[![img](images/psgcap_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/psgcap.shtml) n=238                    | StepSeq25<br>[![img](images/StepSeq25_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/StepSeq25.shtml) n=25      |
| SVG\_Gallet13<br>[![img](images/SVG_Gallet13_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_Gallet13.shtml) n=220 | SVG\_Lindaa06<br>[![img](images/SVG_Lindaa06_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_Lindaa06.shtml) n=220 | SVG\_Lindaa07<br>[![img](images/SVG_Lindaa07_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_Lindaa07.shtml) n=220 | uniform<br>[![img](images/uniform_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/uniform.shtml) n=173           |

## Faded

| CBR\_set3<br>[![img](images/CBR_set3_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_set3.shtml) n=12        | GMT\_topo<br>[![img](images/GMT_topo_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_topo.shtml) n=256          | MPL\_Accent<br>[![img](images/MPL_Accent_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Accent.shtml) n=128                 | MPL\_Dark2<br>[![img](images/MPL_Dark2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Dark2.shtml) n=128                          |
| ----------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| MPL\_Paired<br>[![img](images/MPL_Paired_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Paired.shtml) n=128 | MPL\_Pastel1<br>[![img](images/MPL_Pastel1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Pastel1.shtml) n=128 | MPL\_Pastel2<br>[![img](images/MPL_Pastel2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Pastel2.shtml) n=128              | MPL\_Set1<br>[![img](images/MPL_Set1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Set1.shtml) n=128                             |
| MPL\_Set2<br>[![img](images/MPL_Set2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Set2.shtml) n=128       | MPL\_Set3<br>[![img](images/MPL_Set3_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Set3.shtml) n=128          | SVG\_feb\_sunrise<br>[![img](images/SVG_feb_sunrise_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_feb_sunrise.shtml) n=220 | SVG\_foggy\_sunrise<br>[![img](images/SVG_foggy_sunrise_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_foggy_sunrise.shtml) n=220 |

## Circular

| circular\_0<br>[![img](images/circular_0_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/circular_0.shtml) n=18          | circular\_1<br>[![img](images/circular_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/circular_1.shtml) n=12       | circular\_2<br>[![img](images/circular_2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/circular_2.shtml) n=24 | cmocean\_phase<br>[![img](images/cmocean_phase_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_phase.shtml) n=256 |
| ------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------- |
| GrayWhiteGray<br>[![img](images/GrayWhiteGray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GrayWhiteGray.shtml) n=254 | matlab\_lines<br>[![img](images/matlab_lines_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/matlab_lines.shtml) n=64 |                                                                                                                                          |                                                                                                                                                    |

## Miscellaneous

| default<br>[![img](images/default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/default.shtml) n=30 | helix<br>[![img](images/helix_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/helix.shtml) n=254 | hlu\_default<br>[![img](images/hlu_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hlu_default.shtml) n=30 | lithology<br>[![img](images/lithology_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/lithology.shtml) n=213 |
| ------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
| thelix<br>[![img](images/thelix_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/thelix.shtml) n=254   |                                                                                                                           |                                                                                                                                             |                                                                                                                                       |

## Vegetation

| MPL\_BrBG<br>[![img](images/MPL_BrBG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BrBG.shtml) n=128                    | NEO\_div\_vegetation\_a<br>[![img](images/NEO_div_vegetation_a_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NEO_div_vegetation_a.shtml) n=256 | NEO\_div\_vegetation\_b<br>[![img](images/NEO_div_vegetation_b_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NEO_div_vegetation_b.shtml) n=256 | NEO\_div\_vegetation\_c<br>[![img](images/NEO_div_vegetation_c_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NEO_div_vegetation_c.shtml) n=256 |
| ------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| NEO\_modis\_ndvi<br>[![img](images/NEO_modis_ndvi_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NEO_modis_ndvi.shtml) n=256 | NOC\_ndvi<br>[![img](images/NOC_ndvi_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NOC_ndvi.shtml) n=253                                       | vegetation\_ClarkU<br>[![img](images/vegetation_ClarkU_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/vegetation_ClarkU.shtml) n=256            | vegetation\_modis<br>[![img](images/vegetation_modis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/vegetation_modis.shtml) n=21                |

## White-in-the-middle

| BlAqGrWh2YeOrReVi22<br>[![img](images/BlAqGrWh2YeOrReVi22_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlAqGrWh2YeOrReVi22.shtml) n=22 | BlueDarkRed18<br>[![img](images/BlueDarkRed18_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueDarkRed18.shtml) n=18                          | BlueWhiteOrangeRed<br>[![img](images/BlueWhiteOrangeRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlueWhiteOrangeRed.shtml) n=254          | BlWhRe<br>[![img](images/BlWhRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/BlWhRe.shtml) n=101                             |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------- |
| CBR\_coldhot<br>[![img](images/CBR_coldhot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_coldhot.shtml) n=11                        | CBR\_drywet<br>[![img](images/CBR_drywet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_drywet.shtml) n=11                                  | circular\_0<br>[![img](images/circular_0_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/circular_0.shtml) n=18                                  | cmocean\_balance<br>[![img](images/cmocean_balance_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_balance.shtml) n=256 |
| cmocean\_curl<br>[![img](images/cmocean_curl_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmocean_curl.shtml) n=256                    | cmp\_flux<br>[![img](images/cmp_flux_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/cmp_flux.shtml) n=22                                        | GMT\_polar<br>[![img](images/GMT_polar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_polar.shtml) n=20                                     | GMT\_red2green<br>[![img](images/GMT_red2green_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_red2green.shtml) n=20        |
| GrayWhiteGray<br>[![img](images/GrayWhiteGray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GrayWhiteGray.shtml) n=254                  | GreenMagenta16<br>[![img](images/GreenMagenta16_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GreenMagenta16.shtml) n=16                       | hotcold\_18lev<br>[![img](images/hotcold_18lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotcold_18lev.shtml) n=19                         | hotcolr\_19lev<br>[![img](images/hotcolr_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/hotcolr_19lev.shtml) n=20        |
| MPL\_BrBG<br>[![img](images/MPL_BrBG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BrBG.shtml) n=128                                | MPL\_bwr<br>[![img](images/MPL_bwr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_bwr.shtml) n=128                                          | MPL\_PiYG<br>[![img](images/MPL_PiYG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PiYG.shtml) n=128                                       | MPL\_PRGn<br>[![img](images/MPL_PRGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PRGn.shtml) n=128                      |
| MPL\_PuOr<br>[![img](images/MPL_PuOr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuOr.shtml) n=128                                | MPL\_RdBu<br>[![img](images/MPL_RdBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdBu.shtml) n=128                                       | MPL\_RdGy<br>[![img](images/MPL_RdGy_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdGy.shtml) n=128                                       | MPL\_seismic<br>[![img](images/MPL_seismic_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_seismic.shtml) n=128             |
| NCV\_blu\_red<br>[![img](images/NCV_blu_red_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_blu_red.shtml) n=256                      | NCV\_blue\_red<br>[![img](images/NCV_blue_red_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_blue_red.shtml) n=256                          | NCV\_jaisnd<br>[![img](images/NCV_jaisnd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_jaisnd.shtml) n=256                                 | NCV\_manga<br>[![img](images/NCV_manga_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_manga.shtml) n=256                   |
| NCV\_roullet<br>[![img](images/NCV_roullet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_roullet.shtml) n=256                       | NEO\_div\_vegetation\_b<br>[![img](images/NEO_div_vegetation_b_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NEO_div_vegetation_b.shtml) n=256 | NEO\_div\_vegetation\_c<br>[![img](images/NEO_div_vegetation_c_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NEO_div_vegetation_c.shtml) n=256 | nrl\_sirkes<br>[![img](images/nrl_sirkes_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/nrl_sirkes.shtml) n=21                 |
| precip4\_diff\_19lev<br>[![img](images/precip4_diff_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip4_diff_19lev.shtml) n=20  | precip\_diff\_12lev<br>[![img](images/precip_diff_12lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_diff_12lev.shtml) n=13            | sunshine\_diff\_12lev<br>[![img](images/sunshine_diff_12lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/sunshine_diff_12lev.shtml) n=13      | temp\_19lev<br>[![img](images/temp_19lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_19lev.shtml) n=20                 |
| temp\_diff\_18lev<br>[![img](images/temp_diff_18lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/temp_diff_18lev.shtml) n=19           | testcmap<br>[![img](images/testcmap_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/testcmap.shtml) n=199                                        | ViBlGrWhYeOrRe<br>[![img](images/ViBlGrWhYeOrRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/ViBlGrWhYeOrRe.shtml) n=101                      |                                                                                                                                                          |

## Starts-with-white

| CBR\_wet<br>[![img](images/CBR_wet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_wet.shtml) n=11                                                 | mch\_default<br>[![img](images/mch_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/mch_default.shtml) n=15    | posneg\_1<br>[![img](images/posneg_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/posneg_1.shtml) n=19                                     | posneg\_2<br>[![img](images/posneg_2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/posneg_2.shtml) n=20                   |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------- |
| prcp\_1<br>[![img](images/prcp_1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/prcp_1.shtml) n=17                                                    | prcp\_3<br>[![img](images/prcp_3_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/prcp_3.shtml) n=23                   | precip2\_15lev<br>[![img](images/precip2_15lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip2_15lev.shtml) n=16                      | precip2\_17lev<br>[![img](images/precip2_17lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip2_17lev.shtml) n=18    |
| precip3\_16lev<br>[![img](images/precip3_16lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip3_16lev.shtml) n=17                               | precip\_11lev<br>[![img](images/precip_11lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/precip_11lev.shtml) n=12 | spread\_15lev<br>[![img](images/spread_15lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/spread_15lev.shtml) n=16                         | sunshine\_9lev<br>[![img](images/sunshine_9lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/sunshine_9lev.shtml) n=10    |
| wh-bl-gr-ye-re<br>[![img](images/wh-bl-gr-ye-re_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/wh-bl-gr-ye-re.shtml) n=199                            | WhBlGrYeRe<br>[![img](images/WhBlGrYeRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhBlGrYeRe.shtml) n=100       | WhBlReWh<br>[![img](images/WhBlReWh_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhBlReWh.shtml) n=100                                     | WhiteBlue<br>[![img](images/WhiteBlue_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteBlue.shtml) n=254                |
| WhiteBlueGreenYellowRed<br>[![img](images/WhiteBlueGreenYellowRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteBlueGreenYellowRed.shtml) n=254 | WhiteGreen<br>[![img](images/WhiteGreen_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteGreen.shtml) n=254       | WhiteYellowOrangeRed<br>[![img](images/WhiteYellowOrangeRed_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhiteYellowOrangeRed.shtml) n=254 | WhViBlGrYeOrRe<br>[![img](images/WhViBlGrYeOrRe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhViBlGrYeOrRe.shtml) n=101 |
| WhViBlGrYeOrReWh<br>[![img](images/WhViBlGrYeOrReWh_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/WhViBlGrYeOrReWh.shtml) n=101                      | wind\_17lev<br>[![img](images/wind_17lev_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/wind_17lev.shtml) n=18       |                                                                                                                                                                        |                                                                                                                                                      |

## [GMT](http://gmt.soest.hawaii.edu/)

| GMT\_cool<br>[![img](images/GMT_cool_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_cool.shtml) n=10        | GMT\_copper<br>[![img](images/GMT_copper_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_copper.shtml) n=50                                 | GMT\_drywet<br>[![img](images/GMT_drywet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_drywet.shtml) n=60                 | GMT\_gebco<br>[![img](images/GMT_gebco_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_gebco.shtml) n=70             |
| ----------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- |
| GMT\_globe<br>[![img](images/GMT_globe_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_globe.shtml) n=256    | GMT\_gray<br>[![img](images/GMT_gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_gray.shtml) n=10                                       | GMT\_haxby<br>[![img](images/GMT_haxby_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_haxby.shtml) n=32                    | GMT\_hot<br>[![img](images/GMT_hot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_hot.shtml) n=100                  |
| GMT\_jet<br>[![img](images/GMT_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_jet.shtml) n=256          | GMT\_nighttime<br>[![img](images/GMT_nighttime_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_nighttime.shtml) n=20                        | GMT\_no\_green<br>[![img](images/GMT_no_green_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_no_green.shtml) n=16          | GMT\_ocean<br>[![img](images/GMT_ocean_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_ocean.shtml) n=80             |
| GMT\_paired<br>[![img](images/GMT_paired_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_paired.shtml) n=12  | GMT\_panoply<br>[![img](images/GMT_panoply_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_panoply.shtml) n=16                              | GMT\_polar<br>[![img](images/GMT_polar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_polar.shtml) n=20                    | GMT\_red2green<br>[![img](images/GMT_red2green_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_red2green.shtml) n=20 |
| GMT\_relief<br>[![img](images/GMT_relief_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_relief.shtml) n=256 | GMT\_relief\_oceanonly<br>[![img](images/GMT_relief_oceanonly_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_relief_oceanonly.shtml) n=160 | GMT\_seis<br>[![img](images/GMT_seis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_seis.shtml) n=256                      | GMT\_split<br>[![img](images/GMT_split_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_split.shtml) n=40             |
| GMT\_topo<br>[![img](images/GMT_topo_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_topo.shtml) n=256       | GMT\_wysiwyg<br>[![img](images/GMT_wysiwyg_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_wysiwyg.shtml) n=20                              | GMT\_wysiwygcont<br>[![img](images/GMT_wysiwygcont_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/GMT_wysiwygcont.shtml) n=200 |                                                                                                                                                   |

## [GrADS]

| grads\_default<br>[![img](images/grads_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/grads_default.shtml) n=14 | grads\_rainbow<br>[![img](images/grads_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/grads_rainbow.shtml) n=13 |
| ------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                                   |                                                                                                                                                   |

## [matplotlib](https://matplotlib.org/)

| MPL\_Accent<br>[![img](images/MPL_Accent_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Accent.shtml) n=128                    | MPL\_afmhot<br>[![img](images/MPL_afmhot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_afmhot.shtml) n=128              | MPL\_autumn<br>[![img](images/MPL_autumn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_autumn.shtml) n=128           | MPL\_Blues<br>[![img](images/MPL_Blues_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Blues.shtml) n=128              |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
| MPL\_bone<br>[![img](images/MPL_bone_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_bone.shtml) n=128                          | MPL\_BrBG<br>[![img](images/MPL_BrBG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BrBG.shtml) n=128                    | MPL\_brg<br>[![img](images/MPL_brg_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_brg.shtml) n=128                    | MPL\_BuGn<br>[![img](images/MPL_BuGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BuGn.shtml) n=128                 |
| MPL\_BuPu<br>[![img](images/MPL_BuPu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_BuPu.shtml) n=128                          | MPL\_bwr<br>[![img](images/MPL_bwr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_bwr.shtml) n=128                       | MPL\_cool<br>[![img](images/MPL_cool_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_cool.shtml) n=128                 | MPL\_coolwarm<br>[![img](images/MPL_coolwarm_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_coolwarm.shtml) n=128     |
| MPL\_copper<br>[![img](images/MPL_copper_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_copper.shtml) n=128                    | MPL\_cubehelix<br>[![img](images/MPL_cubehelix_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_cubehelix.shtml) n=128     | MPL\_Dark2<br>[![img](images/MPL_Dark2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Dark2.shtml) n=128              | MPL\_flag<br>[![img](images/MPL_flag_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_flag.shtml) n=128                 |
| MPL\_gist\_earth<br>[![img](images/MPL_gist_earth_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_earth.shtml) n=128       | MPL\_gist\_gray<br>[![img](images/MPL_gist_gray_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_gray.shtml) n=128    | MPL\_gist\_heat<br>[![img](images/MPL_gist_heat_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_heat.shtml) n=128 | MPL\_gist\_ncar<br>[![img](images/MPL_gist_ncar_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_ncar.shtml) n=128 |
| MPL\_gist\_rainbow<br>[![img](images/MPL_gist_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_rainbow.shtml) n=128 | MPL\_gist\_stern<br>[![img](images/MPL_gist_stern_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_stern.shtml) n=128 | MPL\_gist\_yarg<br>[![img](images/MPL_gist_yarg_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gist_yarg.shtml) n=128 | MPL\_GnBu<br>[![img](images/MPL_GnBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_GnBu.shtml) n=128                 |
| MPL\_gnuplot<br>[![img](images/MPL_gnuplot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gnuplot.shtml) n=128                 | MPL\_gnuplot2<br>[![img](images/MPL_gnuplot2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_gnuplot2.shtml) n=128        | MPL\_Greens<br>[![img](images/MPL_Greens_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Greens.shtml) n=128           | MPL\_Greys<br>[![img](images/MPL_Greys_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Greys.shtml) n=128              |
| MPL\_hot<br>[![img](images/MPL_hot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_hot.shtml) n=128                             | MPL\_hsv<br>[![img](images/MPL_hsv_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_hsv.shtml) n=128                       | MPL\_jet<br>[![img](images/MPL_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_jet.shtml) n=128                    | MPL\_ocean<br>[![img](images/MPL_ocean_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_ocean.shtml) n=128              |
| MPL\_Oranges<br>[![img](images/MPL_Oranges_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Oranges.shtml) n=128                 | MPL\_OrRd<br>[![img](images/MPL_OrRd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_OrRd.shtml) n=128                    | MPL\_Paired<br>[![img](images/MPL_Paired_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Paired.shtml) n=128           | MPL\_Pastel1<br>[![img](images/MPL_Pastel1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Pastel1.shtml) n=128        |
| MPL\_Pastel2<br>[![img](images/MPL_Pastel2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Pastel2.shtml) n=128                 | MPL\_pink<br>[![img](images/MPL_pink_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_pink.shtml) n=128                    | MPL\_PiYG<br>[![img](images/MPL_PiYG_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PiYG.shtml) n=128                 | MPL\_PRGn<br>[![img](images/MPL_PRGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PRGn.shtml) n=128                 |
| MPL\_prism<br>[![img](images/MPL_prism_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_prism.shtml) n=128                       | MPL\_PuBu<br>[![img](images/MPL_PuBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuBu.shtml) n=128                    | MPL\_PuBuGn<br>[![img](images/MPL_PuBuGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuBuGn.shtml) n=128           | MPL\_PuOr<br>[![img](images/MPL_PuOr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuOr.shtml) n=128                 |
| MPL\_PuRd<br>[![img](images/MPL_PuRd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_PuRd.shtml) n=128                          | MPL\_Purples<br>[![img](images/MPL_Purples_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Purples.shtml) n=128           | MPL\_rainbow<br>[![img](images/MPL_rainbow_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_rainbow.shtml) n=128        | MPL\_RdBu<br>[![img](images/MPL_RdBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdBu.shtml) n=128                 |
| MPL\_RdGy<br>[![img](images/MPL_RdGy_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdGy.shtml) n=128                          | MPL\_RdPu<br>[![img](images/MPL_RdPu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdPu.shtml) n=128                    | MPL\_RdYlBu<br>[![img](images/MPL_RdYlBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdYlBu.shtml) n=128           | MPL\_RdYlGn<br>[![img](images/MPL_RdYlGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_RdYlGn.shtml) n=128           |
| MPL\_Reds<br>[![img](images/MPL_Reds_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Reds.shtml) n=128                          | MPL\_s3pcpn<br>[![img](images/MPL_s3pcpn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_s3pcpn.shtml) n=128              | MPL\_s3pcpn\_l<br>[![img](images/MPL_s3pcpn_l_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_s3pcpn_l.shtml) n=128    | MPL\_seismic<br>[![img](images/MPL_seismic_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_seismic.shtml) n=128        |
| MPL\_Set1<br>[![img](images/MPL_Set1_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Set1.shtml) n=128                          | MPL\_Set2<br>[![img](images/MPL_Set2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Set2.shtml) n=128                    | MPL\_Set3<br>[![img](images/MPL_Set3_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Set3.shtml) n=128                 | MPL\_Spectral<br>[![img](images/MPL_Spectral_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_Spectral.shtml) n=128     |
| MPL\_spring<br>[![img](images/MPL_spring_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_spring.shtml) n=128                    | MPL\_sstanom<br>[![img](images/MPL_sstanom_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_sstanom.shtml) n=128           | MPL\_StepSeq<br>[![img](images/MPL_StepSeq_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_StepSeq.shtml) n=128        | MPL\_summer<br>[![img](images/MPL_summer_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_summer.shtml) n=128           |
| MPL\_terrain<br>[![img](images/MPL_terrain_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_terrain.shtml) n=128                 | MPL\_viridis<br>[![img](images/MPL_viridis_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_viridis.shtml) n=256           | MPL\_winter<br>[![img](images/MPL_winter_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_winter.shtml) n=128           | MPL\_YlGn<br>[![img](images/MPL_YlGn_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlGn.shtml) n=128                 |
| MPL\_YlGnBu<br>[![img](images/MPL_YlGnBu_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlGnBu.shtml) n=128                    | MPL\_YlOrBr<br>[![img](images/MPL_YlOrBr_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlOrBr.shtml) n=128              | MPL\_YlOrRd<br>[![img](images/MPL_YlOrRd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/MPL_YlOrRd.shtml) n=128           |                                                                                                                                                     |

## [Ncview](http://meteora.ucsd.edu/~pierce/ncview_home_page.html)

| NCV\_banded<br>[![img](images/NCV_banded_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_banded.shtml) n=256       | NCV\_blu\_red<br>[![img](images/NCV_blu_red_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_blu_red.shtml) n=256 | NCV\_blue\_red<br>[![img](images/NCV_blue_red_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_blue_red.shtml) n=256      | NCV\_bright<br>[![img](images/NCV_bright_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_bright.shtml) n=256 |
| ----------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- |
| NCV\_gebco<br>[![img](images/NCV_gebco_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_gebco.shtml) n=24           | NCV\_jaisnd<br>[![img](images/NCV_jaisnd_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_jaisnd.shtml) n=256     | NCV\_jet<br>[![img](images/NCV_jet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_jet.shtml) n=256                      | NCV\_manga<br>[![img](images/NCV_manga_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_manga.shtml) n=256    |
| NCV\_rainbow2<br>[![img](images/NCV_rainbow2_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_rainbow2.shtml) n=256 | NCV\_roullet<br>[![img](images/NCV_roullet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/NCV_roullet.shtml) n=256  | ncview\_default<br>[![img](images/ncview_default_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/ncview_default.shtml) n=254 |                                                                                                                                           |

## SVG

| SVG\_bhw3\_22<br>[![img](images/SVG_bhw3_22_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_bhw3_22.shtml) n=220 | SVG\_es\_landscape\_79<br>[![img](images/SVG_es_landscape_79_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_es_landscape_79.shtml) n=220 | SVG\_feb\_sunrise<br>[![img](images/SVG_feb_sunrise_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_feb_sunrise.shtml) n=220 | SVG\_foggy\_sunrise<br>[![img](images/SVG_foggy_sunrise_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_foggy_sunrise.shtml) n=220 |
| --------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| SVG\_fs2006<br>[![img](images/SVG_fs2006_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_fs2006.shtml) n=220     | SVG\_Gallet13<br>[![img](images/SVG_Gallet13_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_Gallet13.shtml) n=220                        | SVG\_Lindaa06<br>[![img](images/SVG_Lindaa06_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_Lindaa06.shtml) n=220           | SVG\_Lindaa07<br>[![img](images/SVG_Lindaa07_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/SVG_Lindaa07.shtml) n=220                 |

## [ColorBrewer](https://colorbrewer2.org/)

| CBR\_coldhot<br>[![img](images/CBR_coldhot_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_coldhot.shtml) n=11 | CBR\_drywet<br>[![img](images/CBR_drywet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_drywet.shtml) n=11 | CBR\_set3<br>[![img](images/CBR_set3_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_set3.shtml) n=12 | CBR\_wet<br>[![img](images/CBR_wet_labelbar.sm.png)](https://www.ncl.ucar.edu/Document/Graphics/ColorTables/CBR_wet.shtml) n=11 |
| ------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- |
|                                                                                                                                             |                                                                                                                                          |                                                                                                                                    |                                                                                                                                 |
