/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.doccat;

import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.uima.doccat.DoccatModelResource;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

abstract class AbstractDocumentCategorizer
extends CasAnnotator_ImplBase {
    private UimaContext context;
    private Logger mLogger;
    private DocumentCategorizer mCategorizer;
    private Type mTokenType;

    AbstractDocumentCategorizer() {
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        DoccatModel model;
        super.initialize(context);
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Categorizer.");
        }
        try {
            DoccatModelResource modelResource = (DoccatModelResource)context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.mCategorizer = new DocumentCategorizerME(model);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, UimaUtil.SENTENCE_TYPE_PARAMETER);
    }

    protected abstract void setBestCategory(CAS var1, String var2);

    public void process(CAS cas) {
        double[] result = this.mTokenType != null ? this.mCategorizer.categorize(cas.getDocumentText()) : this.mCategorizer.categorize(cas.getDocumentText());
        String bestCategory = this.mCategorizer.getBestCategory(result);
        this.setBestCategory(cas, bestCategory);
    }
}

