/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class LexChain
extends AbstractLargeIntSConstraint {
    public int n;
    public IntDomainVar[][] x;
    public int[][] upperBoundVector;
    public int[][] lowerBoundVector;
    public boolean strict;
    public int numOfVectors;

    public LexChain(IntDomainVar[] vars, int n, boolean strict) {
        super(ConstraintEvent.LINEAR, vars);
        this.strict = strict;
        this.n = n;
        this.numOfVectors = vars.length / n;
        this.x = new IntDomainVar[this.numOfVectors][n];
        this.upperBoundVector = new int[this.numOfVectors][n];
        this.lowerBoundVector = new int[this.numOfVectors][n];
        for (int i = 0; i < this.numOfVectors; ++i) {
            System.arraycopy(vars, n * i, this.x[i], 0, n);
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    public void boundsLex(int[] a, IntDomainVar[] x, int[] b, int j) throws ContradictionException {
        int i = 0;
        while (i < this.n && a[i] == b[i]) {
            if ((x[i].getInf() == a[i] || x[i].updateInf(a[i], this, false)) && (x[i].getSup() == b[i] || x[i].updateSup(b[i], this, false))) {
                ++i;
                continue;
            }
            this.fail();
        }
        if (i < this.n && (x[i].getInf() != a[i] && !x[i].updateInf(a[i], this, false) || x[i].getSup() != b[i] && !x[i].updateSup(b[i], this, false))) {
            this.fail();
        }
        if (i == this.n || x[i].getNextDomainValue(a[i]) < b[i]) {
            return;
        }
        ++i;
        while (i < this.n && b[i] + 1 <= a[i] - 1 && x[i].getInf() == b[i] && x[i].getSup() == a[i]) {
            if (x[i].removeInterval(b[i] + 1, a[i] - 1, this, false)) {
                ++i;
                continue;
            }
            this.fail();
        }
        if (i < this.n && b[i] + 1 <= a[i] - 1 && x[i].getInf() <= b[i] && b[i] <= x[i].getSup() && x[i].getSup() >= a[i] && a[i] >= x[i].getInf() && !x[i].removeInterval(b[i] + 1, a[i] - 1, this, false)) {
            this.fail();
        }
    }

    public int computeAlpha(IntDomainVar[] x, int[] b) throws ContradictionException {
        int i;
        int alpha = -1;
        for (i = 0; i < this.n && x[i].getInf() <= b[i] && x[i].getSup() >= b[i] && x[i].getDomain().contains(b[i]); ++i) {
            if (b[i] <= x[i].getInf()) continue;
            alpha = i;
        }
        if (!this.strict) {
            if (i == this.n || b[i] > x[i].getInf()) {
                alpha = i;
            }
        } else if (i < this.n && b[i] > x[i].getInf()) {
            alpha = i;
        }
        return alpha;
    }

    public int computeBeta(IntDomainVar[] x, int[] a) throws ContradictionException {
        int i;
        int beta = -1;
        for (i = 0; i < this.n && x[i].getInf() <= a[i] && x[i].getSup() >= a[i] && x[i].getDomain().contains(a[i]); ++i) {
            if (a[i] >= x[i].getSup()) continue;
            beta = i;
        }
        if (!this.strict) {
            if (i == this.n || a[i] < x[i].getSup()) {
                beta = i;
            }
        } else if (i < this.n && a[i] < x[i].getSup()) {
            beta = i;
        }
        return beta;
    }

    public void computeUB(IntDomainVar[] x, int[] b, int[] u) throws ContradictionException {
        int alpha = this.computeAlpha(x, b);
        if (alpha == -1) {
            this.fail();
        }
        for (int i = 0; i < this.n; ++i) {
            u[i] = i < alpha ? b[i] : (i == alpha ? x[i].getPrevDomainValue(b[i]) : x[i].getSup());
        }
    }

    public void computeLB(IntDomainVar[] x, int[] a, int[] lower) throws ContradictionException {
        int beta = this.computeBeta(x, a);
        if (beta == -1) {
            this.fail();
        }
        for (int i = 0; i < this.n; ++i) {
            lower[i] = i < beta ? a[i] : (i == beta ? x[i].getNextDomainValue(a[i]) : x[i].getInf());
        }
    }

    public void filter() throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.upperBoundVector[this.numOfVectors - 1][i] = this.x[this.numOfVectors - 1][i].getSup();
        }
        for (i = this.numOfVectors - 2; i >= 0; --i) {
            this.computeUB(this.x[i], this.upperBoundVector[i + 1], this.upperBoundVector[i]);
        }
        for (i = 0; i < this.n; ++i) {
            this.lowerBoundVector[0][i] = this.x[0][i].getInf();
        }
        for (i = 1; i < this.numOfVectors; ++i) {
            this.computeLB(this.x[i], this.lowerBoundVector[i - 1], this.lowerBoundVector[i]);
        }
        for (i = 0; i < this.numOfVectors; ++i) {
            this.boundsLex(this.lowerBoundVector[i], this.x[i], this.upperBoundVector[i], i);
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.filter();
    }

    @Override
    public Boolean isEntailed() {
        throw new SolverException("isEntailed not yet implemented on choco.cp.cpsolver.constraints.global.LexChain");
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.checkTuple(0, tuple);
    }

    private boolean checkTuple(int i, int[] tuple) {
        if (i == this.x.length - 1) {
            return true;
        }
        int index = this.n * i;
        int j = 0;
        while (j < this.n) {
            if (tuple[index] > tuple[index + this.n]) {
                return false;
            }
            if (tuple[index] < tuple[index + this.n]) {
                return this.checkTuple(i + 1, tuple);
            }
            ++j;
            ++index;
        }
        return !this.strict && this.checkTuple(i + 1, tuple);
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.numOfVectors; ++i) {
            for (int j = 0; j < this.n; ++j) {
                sb = j > 0 ? sb.append(", ") : sb.append("{");
                sb.append(this.x[i][j].pretty());
            }
            sb = i + 1 == this.numOfVectors ? sb.append("} ") : (this.strict ? sb.append("} < lex ") : sb.append("} <= lex "));
        }
        return sb.toString();
    }
}

