## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  
#  #% Here is a macro comment
#  
#  # Here is a regular comment
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  
#  # Here is a regular comment
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Assignment using left arrow
#  #%let a <- 1
#  x <- `&a`
#  
#  #% Assignment using equals sign
#  #%let b = 2
#  y <- `&b`
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  x <- 1
#  
#  y <- 2
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Quoted Assignment
#  #%let a <- "One"
#  x <- `&a`
#  
#  #% Unquoted Assignment
#  #%let b <- Two
#  y <- "&b"
#  z <- '&b'
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  x <- "One"
#  
#  y <- "Two"
#  z <- 'Two'
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Unquoted Assignment
#  #%let c <- Three
#  
#  # Unquoted resolution
#  z <- `&c`
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Macro assignment
#  #%let b <- 2
#  x <- `&b`
#  
#  #% Clear assignment
#  #%let b
#  y <- `&b`
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Assignment before msource()
#  `&c` <- 3
#  
#  # Pre-process
#  msource("./temp1.R", "./temp1_mod.R")
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Print macro variable
#  z <- `&c`

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Print macro variable
#  z <- 3

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let x <- 1
#  #%let mvar1 <- Hello!
#  
#  print("&mvar&x")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let x <- 1
#  #%let mvar <- Goodbye!
#  #%let mvar1 <- Hello!
#  
#  print("&mvar&x")
#  print("&&mvar&x")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let a <- # Subset mtcars
#  #%let b <- mtcars
#  #%let c <- , mpg > 25
#  #%let d <- dat <- subset(&b&c)
#  #%let e <- (dat)
#  `&a`
#  `&d`
#  print&e

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Subset mtcars
#  dat <- subset(mtcars, mpg > 25)
#  print(dat)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Assign variable name to macro
#  #%let x <- cyl
#  
#  # Leading macro replacement
#  `&x._mean` <- mean(mtcars[["&x"]])
#  
#  # Trailing macro replacement
#  mean_&x <- mean(mtcars[["&x"]])
#  
#  # Middle macro replacement
#  my_&x_mean <- mean(mtcars[["&x"]])
#  
#  # Intermediate macro replacement
#  #%let myvar <- &x_mean
#  `&myvar` <- mean(mtcars[["&x"]])
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  
#  # Leading macro replacement
#  `cyl_mean` <- mean(mtcars[["cyl"]])
#  
#  # Trailing macro replacement
#  mean_cyl <- mean(mtcars[["cyl"]])
#  
#  # Middle macro replacement
#  my_cyl_mean <- mean(mtcars[["cyl"]])
#  
#  # Intermediate macro replacement
#  cyl_mean <- mean(mtcars[["cyl"]])

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let dev_path <- ./dev/data
#  #%let prod_path <- ./prod/data
#  #%let env <- dev
#  
#  # Path to data
#  #%if ("&env" == "prod")
#  pth <- "&prod_path/dm.sas7bdat"
#  #%else
#  pth <- "&dev_path/dm.sas7bdat"
#  #%end

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  
#  # Path to data
#  pth <- "./dev/data/dm.sas7bdat"

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Data source SAS or RDS
#  #%let src <- SAS
#  
#  #% Select analysis variables
#  #%let anal_vars <- c("AGE", "AGEG", "SEX", "RACE", "PULSE", "TEMP")
#  
#  ###################
#  # Get data
#  ###################
#  #%if ("&src" == "SAS")
#    library(haven)
#  
#    # Get adsl dataset
#    adsl <- haven("./data/ADSL.sas7bdat")
#  
#    #%if (any(c("PULSE", "TEMP", "BP") %in% &anal_vars))
#    # Get advs dataset
#    advs <- haven("./data/ADVS.sas7bdat")
#    #%end
#  
#  #%else
#  
#    # Get adsl dataset
#    adsl <- readRDS("./data/ADSL.rds")
#  
#    #%if (any(c("PULSE", "TEMP", "BP") %in% &anal_vars))
#    # Get advs dataset
#    advs <- readRDS("./data/ADVS.rds")
#    #%end
#  
#  #%end

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  ######################
#  # Get data
#  ######################
#    library(haven)
#  
#    # Get adsl dataset
#    adsl <- haven("./data/ADSL.sas7bdat")
#  
#    # Get advs dataset
#    advs <- haven("./data/ADVS.sas7bdat")
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Create sample data
#  #%include "./templates/dat01.R"
#  
#  # Print sample data
#  print(dat)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Create sample data
#  dm <- read.table(header = TRUE, text = '
#         SUBJID  ARM    SEX  RACE    AGE
#         "001"   "ARM A" "F"  "ASIAN" 19
#         "002"   "ARM B" "F"  "WHITE" 21
#         "003"   "ARM C" "F"  "WHITE" 23
#         "004"   "ARM D" "F"  "BLACK OR AFRICAN AMERICAN" 28
#         "005"   "ARM A" "M"  "WHITE" 37
#         "006"   "ARM B" "M"  "WHITE" 34
#         "007"   "ARM C" "M"  "ASIAN" 36
#         "008"   "ARM D" "M"  "WHITE" 30
#         "009"   "ARM A" "F"  "WHITE" 39
#         "010"   "ARM B" "F"  "WHITE" 31
#         "011"   "ARM C" "F"  "BLACK OR AFRICAN AMERICAN" 33
#         "012"   "ARM D" "F"  "WHITE" 38
#         "013"   "ARM A" "M"  "BLACK OR AFRICAN AMERICAN" 37
#         "014"   "ARM B" "M"  "WHITE" 34
#         "015"   "ARM C" "M"  "WHITE" 36
#         "016"   "ARM A" "M"  "WHITE" 40')
#  
#  # Print sample data
#  print(dm)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Unevaluated assignment
#  #%let a <- 2 + 2
#  w <- `&a`
#  
#  #% Evaluated assignment
#  #%let b <- %sysfunc(2 + 2)
#  x <- `&b`
#  
#  #% Unevaluated replacement
#  #%let c <- &a + &b
#  y <- `&c`
#  
#  #% Evaluated replacement
#  #%let d <- %sysfunc(&a + &b)
#  z <- `&d`
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  w <- 2 + 2
#  x <- 4
#  y <- 2 + 2 + 4
#  z <- 8

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let a <- c(1.205, 4.683, 3.812, 6.281, 9.467)
#  
#  #%if (%sysfunc(mean(&a.)) > 5)
#  x <- "> 5"
#  #%else
#  x <- "<= 5"
#  #%end
#  print(x)
#  print("The mean of 'a' is %sysfunc(mean(&a.), %.2f)")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  > msource()
#  # ---------
#  # x <- "> 5"
#  #  print(x)
#  #  print("The mean of 'a' is 5.09")
#  # ---------
#  # [1] "> 5"
#  # [1] "The mean of 'a' is 5.09"

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let a = 1
#  
#  #%if (%symexist(a))
#  
#    print("Macro variable 'a' exists!")
#    print("Here is the value: &a")
#  
#  #%else
#  
#    print("Macro variable 'a' does not exist!")
#  
#  #%end
#  
#  #%if (%symexist(b))
#  
#    print("Macro variable 'b' exists!")
#    print("Here is the value: &b")
#  
#  #%else
#  
#    print("Macro variable 'b' does not exist!")
#  
#  #%end
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  
#    print("Macro variable 'a' exists!")
#    print("Here is the value: 1")
#  
#    print("Macro variable 'b' does not exist!")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Assign vector
#  v1 <- c("one", "two", "three")
#  
#  #% Get length of vector
#  #%let x <- %symput(length(v1))
#  
#  #% Get vector values
#  #%let y <- %symput(v1)
#  
#  # Use macro variables
#  a <- `&x`
#  b <- `&y`
#  
#  # Print to console
#  print(a)
#  print(b)
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #% Assign variables
#  #%let x <- 1
#  print("The value of %nrstr(&x) is &x")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%do x = 1 %to 3
#  print("Hello #&x.")
#  #%end

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  [1] "Hello #1"
#  [1] "Hello #2"
#  [1] "Hello #3"

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  print("Hello #1")
#  print("Hello #2")
#  print("Hello #3")

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let vars <- c("mpg", "disp", "hp", "drat")
#  # Get data
#  dat <- mtcars
#  
#  #% Print mean for each variable
#  #%do v = 1 %to %sysfunc(length(&vars))
#  #%let var <- %sysfunc(&vars[&v])
#  
#  # Calculate mean for &var.
#  mn&v. <- sprintf("%.2f", mean(dat$`&var.`))
#  print(paste0("Mean of '&var.' is ", mn&v.))
#  
#  #%end
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  # Get data
#  dat <- mtcars
#  
#  # Calculate mean for mpg
#  mn1 <- sprintf("%.2f", mean(dat$mpg))
#  print(paste0("Mean of 'mpg' is ", mn1))
#  
#  # Calculate mean for disp
#  mn2 <- sprintf("%.2f", mean(dat$disp))
#  print(paste0("Mean of 'disp' is ", mn2))
#  
#  # Calculate mean for hp
#  mn3 <- sprintf("%.2f", mean(dat$hp))
#  print(paste0("Mean of 'hp' is ", mn3))
#  
#  # Calculate mean for drat
#  mn4 <- sprintf("%.2f", mean(dat$drat))
#  print(paste0("Mean of 'drat' is ", mn4))
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%macro printit(txt)
#  print("Print the text: &txt.")
#  #%mend
#  #%printit(Hello!)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  library(dplyr)
#  
#  #%macro print_analysis(dat, byvar, var)
#  cat("Analysis for &var.\n")
#  `&dat` |>
#    select(`&byvar`, `&var`) |>
#    group_by(`&byvar`) |>
#    summarize(Mean = mean(`&var`, rm.na = TRUE),
#              SD = sd(`&var`),
#              Quantile = quantile(`&var`, probs = .25, rm.na = TRUE)) |>
#    as.data.frame() |> print()
#  cat("\n")
#  
#  #%mend
#  
#  #%let vars <- c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")
#  #%do idx = 1 %to %sysfunc(length(&vars))
#  #%print_analysis(iris, Species, %sysfunc(&vars[&idx]))
#  #%end

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  library(dplyr)
#  
#  cat("Analysis for Sepal.Length\n")
#  iris |>
#    select(Species, Sepal.Length) |>
#    group_by(Species) |>
#    summarize(Mean = mean(Sepal.Length, rm.na = TRUE),
#              SD = sd(Sepal.Length),
#              Quantile = quantile(Sepal.Length, probs = .25, rm.na = TRUE)) |>
#    as.data.frame() |> print()
#  cat("\n")
#  
#  cat("Analysis for Sepal.Width\n")
#  iris |>
#    select(Species, Sepal.Width) |>
#    group_by(Species) |>
#    summarize(Mean = mean(Sepal.Width, rm.na = TRUE),
#              SD = sd(Sepal.Width),
#              Quantile = quantile(Sepal.Width, probs = .25, rm.na = TRUE)) |>
#    as.data.frame() |> print()
#  cat("\n")
#  
#  cat("Analysis for Petal.Length\n")
#  iris |>
#    select(Species, Petal.Length) |>
#    group_by(Species) |>
#    summarize(Mean = mean(Petal.Length, rm.na = TRUE),
#              SD = sd(Petal.Length),
#              Quantile = quantile(Petal.Length, probs = .25, rm.na = TRUE)) |>
#    as.data.frame() |> print()
#  cat("\n")
#  
#  cat("Analysis for Petal.Width\n")
#  iris |>
#    select(Species, Petal.Width) |>
#    group_by(Species) |>
#    summarize(Mean = mean(Petal.Width, rm.na = TRUE),
#              SD = sd(Petal.Width),
#              Quantile = quantile(Petal.Width, probs = .25, rm.na = TRUE)) |>
#    as.data.frame() |> print()
#  cat("\n")
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  #%let trt_grps <- c("ARM A" = "Placebo",
#  #%>                 "ARM B" = "Drug 10mg",
#  #%>                 "ARM C" = "Drug 20mg",
#  #%>                 "ARM D" = "Competitor")
#  
#  a <- `&trt_grps`
#  print(a)
#  

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  a <- c("ARM A" = "Placebo",
#                   "ARM B" = "Drug 10mg",
#                   "ARM C" = "Drug 20mg",
#                   "ARM D" = "Competitor")
#  print(a)
#  

