/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.SsqNumericalDerivatives;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfAlgorithm;
import ec.tstoolkit.ssf.SsfFunctionInstance;
import ec.tstoolkit.ssf.SsfModel;

public class SsfFunction<S extends ISsf>
implements IFunction,
ISsqFunction {
    private final boolean mt;
    private final boolean sym;
    public final ISsfAlgorithm<S> algorithm;
    public final IParametricMapping<S> mapper;
    public final SsfModel<S> model;

    public SsfFunction(SsfModel<S> model, IParametricMapping<S> mapper, ISsfAlgorithm<S> algorithm) {
        this.model = model;
        this.mapper = mapper;
        this.algorithm = algorithm;
        this.mt = false;
        this.sym = false;
    }

    public SsfFunction(SsfModel<S> model, IParametricMapping<S> mapper, ISsfAlgorithm<S> algorithm, boolean symderivatives, boolean mt) {
        this.model = model;
        this.mapper = mapper;
        this.algorithm = algorithm;
        this.mt = mt;
        this.sym = symderivatives;
    }

    @Override
    public IFunctionInstance evaluate(IReadDataBlock parameters) {
        return new SsfFunctionInstance(this, parameters);
    }

    @Override
    public IFunctionDerivatives getDerivatives(IFunctionInstance point) {
        return new NumericalDerivatives(this, point, this.sym, this.mt);
    }

    @Override
    public ISsqFunctionDerivatives getDerivatives(ISsqFunctionInstance point) {
        return new SsqNumericalDerivatives(this, point, this.sym, this.mt);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapper;
    }

    @Override
    public ISsqFunctionInstance ssqEvaluate(IReadDataBlock parameters) {
        return new SsfFunctionInstance(this, parameters);
    }
}

