## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(MUGS)

## ----load_data----------------------------------------------------------------
set.seed(1)
S <- matrix(rnorm(100^2), 100, 100)
library(rsvd)
svd <- rsvd(S, 20)

## ----run_function-------------------------------------------------------------
# Example usage of get_embed
U <- get_embed(svd, d=10, normalize=TRUE)

## ----examine_output-----------------------------------------------------------
# View the structure of the output
str(U)

# Display the first few rows of the results
cat("\nEmbedding Results (first 5 rows):\n")
print(head(U, 5))

