# Licensing Information for `ChileDataAPI` Package

This package, `ChileDataAPI`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **pinochet_regime_df**: 
  Originally pinochet from the pinochet 0.1.0 package, licensed under MIT + file LICENSE. The dataset name has been changed to 'pinochet_regime_df' to indicate that this dataset is a data frame object.    

- **chile_plebiscite_df**:
  Originally Chile from the carData 3.0-5 package, licensed under GPL (>= 2). The dataset name has been changed to 'chile_plebiscite_df' to indicate that this dataset is a data frame object.

- **census_chile_2017_df**: 
  Originally c17_example from the ismtchile 2.1.5 package, licensed under MIT + file LICENSE. The dataset name has been changed to 'census_chile_2017_df' to indicate that this dataset is a data frame object.   

- **chile_election_2021_df**: 
  Originally chile_election_2021 from the fastei 0.0.0.7 package, licensed under MIT + file LICENSE. The dataset name has been changed to 'chile_election_2021_df' to indicate that this dataset is a data frame object.     

- **chile_health_survey_df**: 
  Originally ens from the abms 0.2 package, licensed under GPL (>= 3). The dataset name has been changed to 'chile_health_survey_df' to indicate that this dataset is a data frame object.   

- **territorial_codes_tbl_df**: 
  Originally codigos_territoriales from the chilemapas 0.3.0 package, licensed under GPL-3. The dataset name has been changed to 'territorial_codes_tbl_df' to indicate that this dataset is a tibble object.   

- **malleco_tree_rings_ts**: 
  Originally malleco from the LSTS 2.1 package, licensed under Apache License (>= 2). The dataset name has been changed to 'malleco_tree_rings_ts' to indicate that this dataset is a time series object.   

### Dataset: `chile_earthquakes_tbl_df`

- **Source**: Kaggle  
- **Original title**: [Earthquakes on Chile](https://www.kaggle.com/datasets/nicolasgonzalezmunoz/earthquakes-on-chile)  
- **Original file**: `seismic_data.csv`  
- **License**: [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)  

**Description**  
This dataset compiles information on significant (perceptible) earthquakes in Chile from the year 2012 to present. The data originates from the *Centro Sismológico Nacional de Chile*.


## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `ChileDataAPI`, is licensed under the GPL-3 License.
