## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(BioWorldR)
library(ggplot2)
library(dplyr)

## ----Brains-subcortical-plot, fig.width=6, fig.height=4, out.width="100%"-----
Brain_animals %>%
  # Select only the species and bodyweight columns
  select(species, brainweight) %>%
  # Create the bar chart
  ggplot(aes(x = reorder(species, brainweight), y = brainweight)) +
  geom_col(fill = "steelblue") +
  coord_flip() +  # Flip coordinates for better readability
  labs(
    title = "Brainweight of Different Animal Species",
    x = "Species",
    y = "Brainweight "
  ) +
  theme_minimal()

