/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.io.AlignmentExporter;
import jebl.evolution.io.TreeExporter;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHYLIPExporter
implements AlignmentExporter,
TreeExporter {
    private PrintWriter writer;

    public PHYLIPExporter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    private boolean namesUnique(List<String> names) {
        HashSet<String> all = new HashSet<String>();
        for (String name : names) {
            if (all.contains(name)) {
                return false;
            }
            all.add(name);
        }
        return true;
    }

    private List<String> tryNames(List<String> names, int fromBegining, int fromEnd) {
        ArrayList<String> pnames = new ArrayList<String>(names.size());
        int total = fromBegining + fromEnd;
        for (String name : names) {
            int len = name.length();
            String n = len <= total ? name + (len < total ? String.format("%" + (total - len) + "s", " ") : "") : name.substring(0, fromBegining) + name.substring(len - fromEnd, len);
            pnames.add(n);
        }
        if (this.namesUnique(pnames)) {
            return pnames;
        }
        return null;
    }

    private List<String> phylipNames(List<Sequence> seqs) {
        ArrayList<String> names = new ArrayList<String>();
        for (Sequence s : seqs) {
            names.add(s.getTaxon().getName().replace(' ', '_'));
        }
        List<String> pnames = this.tryNames(names, 9, 0);
        if (pnames == null) {
            pnames = this.tryNames(names, 0, 9);
        }
        if (pnames == null) {
            pnames = this.tryNames(names, 5, 4);
        }
        if (pnames == null) {
            int nDig = (int)Math.ceil(Math.log10(names.size()));
            pnames = new ArrayList<String>(names.size());
            for (int i = 0; i < names.size(); ++i) {
                String f = "%" + (9 - nDig) + "." + (9 - nDig) + "s%0" + nDig + "d";
                pnames.add(String.format(f, names.get(i), i));
            }
        }
        return pnames;
    }

    @Override
    public void exportAlignment(Alignment alignment) throws IOException {
        List<Sequence> seqs = alignment.getSequenceList();
        int alignmentLength = seqs.isEmpty() ? 0 : seqs.get(0).getLength();
        this.writer.println(" " + seqs.size() + " " + alignmentLength);
        List<String> names = this.phylipNames(seqs);
        for (int i = 0; i < seqs.size(); ++i) {
            this.writer.print(names.get(i) + " ");
            this.writer.println(seqs.get(i).getString());
        }
    }

    @Override
    public void exportTree(Tree tree) throws IOException {
        RootedTree rtree = Utils.rootTheTree(tree);
        this.writer.print(Utils.toNewick(rtree));
        this.writer.println(";");
    }

    @Override
    public void exportTrees(Collection<? extends Tree> trees) throws IOException {
        for (Tree tree : trees) {
            this.exportTree(tree);
        }
    }
}

