/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.LatentFactorModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.PathDependent;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;

public class LatentFactorModelPrecisionGibbsOperator
extends SimpleMCMCOperator
implements PathDependent,
GibbsOperator {
    private LatentFactorModel LFM;
    private GammaDistribution prior;
    private boolean randomScan;
    private double shape;
    double pathWeight = 1.0;
    final Parameter missingIndicator;

    public LatentFactorModelPrecisionGibbsOperator(LatentFactorModel latentFactorModel, DistributionLikelihood distributionLikelihood, double d, boolean bl) {
        this.setWeight(d);
        this.LFM = latentFactorModel;
        this.prior = (GammaDistribution)distributionLikelihood.getDistribution();
        this.randomScan = bl;
        this.missingIndicator = latentFactorModel.getMissingIndicator();
    }

    private double getShape(int n) {
        return this.prior.getShape() + (double)this.LFM.getRowCount(n) * 0.5 * this.pathWeight;
    }

    private void setPrecision(int n) {
        MatrixParameterInterface matrixParameterInterface = this.LFM.getFactors();
        MatrixParameterInterface matrixParameterInterface2 = this.LFM.getLoadings();
        DiagonalMatrix diagonalMatrix = (DiagonalMatrix)this.LFM.getColumnPrecision();
        MatrixParameterInterface matrixParameterInterface3 = this.LFM.getScaledData();
        double d = 0.0;
        for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
            double d2 = 0.0;
            if (this.missingIndicator != null && this.missingIndicator.getParameterValue(i * this.LFM.getScaledData().getRowDimension() + n) == 1.0) continue;
            for (int j = 0; j < matrixParameterInterface.getRowDimension(); ++j) {
                d2 += matrixParameterInterface.getParameterValue(j, i) * matrixParameterInterface2.getParameterValue(n, j);
            }
            double d3 = matrixParameterInterface3.getParameterValue(n, i) - d2;
            d += d3 * d3;
        }
        double d4 = 1.0 / (1.0 / this.prior.getScale() + this.pathWeight * d * 0.5);
        double d5 = GammaDistribution.nextGamma(this.getShape(n), d4);
        diagonalMatrix.setParameterValueQuietly(n, d5);
    }

    @Override
    public void setPathParameter(double d) {
        this.pathWeight = d;
    }

    @Override
    public String getOperatorName() {
        return "Latent Factor Model Precision Gibbs Operator";
    }

    @Override
    public double doOperation() {
        if (!this.randomScan) {
            for (int i = 0; i < this.LFM.getColumnPrecision().getColumnDimension(); ++i) {
                if (this.LFM.getContinuous().getParameterValue(i) == 0.0) continue;
                this.setPrecision(i);
            }
        } else {
            int n = MathUtils.nextInt(this.LFM.getColumnPrecision().getColumnDimension());
            while (this.LFM.getContinuous().getParameterValue(n) == 0.0) {
                n = MathUtils.nextInt(this.LFM.getColumnPrecision().getColumnDimension());
            }
            this.setPrecision(n);
        }
        this.LFM.getColumnPrecision().getParameter(0).fireParameterChangedEvent();
        return 0.0;
    }
}

