/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.math.matrixAlgebra.missingData.MissingOps;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class ConditionalPrecisionAndTransform2 {
    private final DenseMatrix64F affineTransform;
    private final DenseMatrix64F P11Inv;
    private final int[] missingIndices;
    private final int[] notMissingIndices;
    private final int numMissing;
    private final int numNotMissing;
    private static final boolean DEBUG = false;

    public ConditionalPrecisionAndTransform2(DenseMatrix64F denseMatrix64F, int[] nArray, int[] nArray2) {
        assert (nArray.length + nArray2.length == denseMatrix64F.getNumRows());
        assert (nArray.length + nArray2.length == denseMatrix64F.getNumCols());
        this.missingIndices = nArray;
        this.notMissingIndices = nArray2;
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(nArray.length, nArray.length);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F2, nArray, nArray);
        this.P11Inv = new DenseMatrix64F(nArray.length, nArray.length);
        CommonOps.invert(denseMatrix64F2, this.P11Inv);
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(nArray.length, nArray2.length);
        MissingOps.gatherRowsAndColumns(denseMatrix64F, denseMatrix64F3, nArray, nArray2);
        DenseMatrix64F denseMatrix64F4 = new DenseMatrix64F(nArray.length, nArray2.length);
        CommonOps.mult(this.P11Inv, denseMatrix64F3, denseMatrix64F4);
        this.affineTransform = denseMatrix64F4;
        this.numMissing = nArray.length;
        this.numNotMissing = nArray2.length;
    }

    public DenseMatrix64F getConditionalVariance() {
        return this.P11Inv;
    }

    public double[] getConditionalMean(double[] dArray, int n, double[] dArray2, int n2) {
        int n3;
        double[] dArray3 = new double[this.numMissing];
        double[] dArray4 = new double[this.numNotMissing];
        for (n3 = 0; n3 < this.numNotMissing; ++n3) {
            int n4 = this.notMissingIndices[n3];
            dArray4[n3] = dArray[n + n4] - dArray2[n2 + n4];
        }
        for (n3 = 0; n3 < this.numMissing; ++n3) {
            double d = 0.0;
            for (int i = 0; i < this.numNotMissing; ++i) {
                d += this.affineTransform.unsafe_get(n3, i) * dArray4[i];
            }
            dArray3[n3] = dArray2[n2 + this.missingIndices[n3]] - d;
        }
        return dArray3;
    }
}

