/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree.treemetrics;

import dr.evolution.tree.Clade;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.treemetrics.BranchScoreMetric;
import dr.evolution.tree.treemetrics.TreeMetric;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class RootedBranchScoreMetric
extends BranchScoreMetric
implements Citable {
    public static TreeMetric.Type TYPE = TreeMetric.Type.ROOTED_BRANCH_SCORE;
    public static Citation CITATION = new Citation(new Author[]{new Author("J", "Heled"), new Author("AJ", "Drummond")}, "Bayesian inference of species trees from multilocus data", 2010, "Mol. Biol. Evol.", 27, 570, 580, Citation.Status.PUBLISHED);

    @Override
    public double getMetric(Tree tree, Tree tree2) {
        TreeMetric.Utils.checkTreeTaxa(tree, tree2);
        List<Clade> list = Clade.getCladeList(tree);
        List<Clade> list2 = Clade.getCladeList(tree2);
        return Math.sqrt(Math.pow(this.getDistance(list, list2), 2.0) + this.getExternalDistance(tree, tree2));
    }

    private double getExternalDistance(Tree tree, Tree tree2) {
        double d = 0.0;
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            NodeRef nodeRef2 = tree2.getExternalNode(i);
            NodeRef nodeRef3 = tree.getParent(nodeRef);
            NodeRef nodeRef4 = tree2.getParent(nodeRef2);
            d += Math.pow(tree.getNodeHeight(nodeRef3) - tree.getNodeHeight(nodeRef) - (tree2.getNodeHeight(nodeRef4) - tree2.getNodeHeight(nodeRef2)), 2.0);
        }
        return d;
    }

    @Override
    public TreeMetric.Type getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getType().getShortName();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_METRICS;
    }

    @Override
    public String getDescription() {
        return "Normalized Rooted Branch Score";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

