/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import org.vikamine.kernel.data.AbstractDataRecord;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.OntologyCreator;

public abstract class AbstractOntologyCreator
implements OntologyCreator {
    protected DataRecordSet dataset;

    protected void createDatasetIDs() {
        long i = 0L;
        while (i < (long)this.dataset.getNumInstances()) {
            AbstractDataRecord dataRecord = (AbstractDataRecord)this.dataset.get((int)i);
            dataRecord.setID(i);
            ++i;
        }
    }

    protected void copyAttributesToOntology(Ontology ontology) {
        Iterator<Attribute> iter = this.dataset.attributeIterator();
        while (iter.hasNext()) {
            Attribute att = iter.next();
            if (att.getDescription() == null) {
                att.setDescription(att.getId());
            }
            ontology.addAttribute(att);
        }
    }

    protected static class AttributeNameComparatorAscending
    implements Comparator<Attribute> {
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(Attribute a1, Attribute a2) {
            return this.collator.compare(a1.getId(), a2.getId());
        }
    }
}

