/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class BowmanShenton {
    private final DescriptiveStatistics stats;

    public BowmanShenton(DoubleSeq data) {
        this.stats = DescriptiveStatistics.of(data);
    }

    public StatisticalTest build() {
        int n = this.stats.getObservationsCount();
        double m3 = this.stats.getSkewness();
        double m4 = this.stats.getKurtosis() - 3.0;
        double val = (double)n / 6.0 * m3 * m3 + (double)n / 24.0 * m4 * m4;
        Chi2 chi = new Chi2(2.0);
        return TestsUtility.testOf(val, chi, TestType.Upper);
    }
}

