/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;
import lombok.NonNull;

public final class VarNoise {
    public static StateComponent of(@NonNull double[] std, double scale) {
        if (std == null) {
            throw new NullPointerException("std is marked non-null but is null");
        }
        return new StateComponent(new Initialization(scale), new Dynamics(std, scale));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    @Generated
    private VarNoise() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        private final double std;

        Initialization(double std) {
            this.std = std;
        }

        @Override
        public int getStateDim() {
            return 1;
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            pf0.set(0, 0, this.std * this.std);
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final double scale;
        private final double scale2;
        private final double[] std;

        Dynamics(double[] std, double scale) {
            this.scale = scale;
            this.scale2 = scale * scale;
            this.std = std;
        }

        private double v(int pos) {
            if (pos < this.std.length) {
                double q = this.scale * this.std[pos];
                return q * q;
            }
            return this.scale2;
        }

        private double e(int pos) {
            return pos < this.std.length ? this.std[pos] * this.scale : this.scale;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(0, 0, this.v(pos));
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            cm.set(0, 0, this.e(pos));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return false;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.set(0.0);
        }

        @Override
        public void TVT(int pos, FastMatrix v) {
            v.set(0, 0, 0.0);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(0, this.e(pos) * u.get(0));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.v(pos));
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.set(0, 0.0);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, x.get(0) * this.e(pos));
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }
}

