/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.arima.AbstractArimaModel;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;
import lombok.NonNull;

public final class ArimaModel
extends AbstractArimaModel {
    public static final ArimaModel ONE = ArimaModel.whiteNoise();
    public static final ArimaModel NULL = ArimaModel.whiteNoise(0.0);
    private static final double EPS = 1.0E-6;
    private final BackFilter ar;
    private final BackFilter delta;
    private final BackFilter ma;
    private final double var;
    private final SymmetricFilter sma;
    private volatile SymmetricFilter.Factorization smaFactorization;
    private volatile SymmetricFilter sar;
    private volatile SymmetricFilter derivedsma;

    public static ArimaModel whiteNoise() {
        return new ArimaModel(BackFilter.ONE, BackFilter.ONE, BackFilter.ONE, 1.0);
    }

    public static ArimaModel whiteNoise(double var) {
        return new ArimaModel(BackFilter.ONE, BackFilter.ONE, BackFilter.ONE, var);
    }

    public static ArimaModel of(IArimaModel arima) {
        return new ArimaModel(arima.getStationaryAr(), arima.getNonStationaryAr(), arima.getMa(), arima.getInnovationVariance());
    }

    public ArimaModel(@NonNull BackFilter ar, @NonNull BackFilter delta, @NonNull BackFilter ma, double var) {
        if (ar == null) {
            throw new NullPointerException("ar is marked non-null but is null");
        }
        if (delta == null) {
            throw new NullPointerException("delta is marked non-null but is null");
        }
        if (ma == null) {
            throw new NullPointerException("ma is marked non-null but is null");
        }
        this.var = var;
        this.ar = ar;
        this.delta = delta;
        this.ma = ma;
        this.sma = null;
    }

    public ArimaModel(@NonNull BackFilter ar, @NonNull BackFilter delta, @NonNull SymmetricFilter sma) {
        if (ar == null) {
            throw new NullPointerException("ar is marked non-null but is null");
        }
        if (delta == null) {
            throw new NullPointerException("delta is marked non-null but is null");
        }
        if (sma == null) {
            throw new NullPointerException("sma is marked non-null but is null");
        }
        this.ar = ar;
        this.delta = delta;
        this.sma = sma;
        this.ma = null;
        this.var = 0.0;
    }

    public static ArimaModel add(double var, ArimaModel arima) {
        return arima.plus(var);
    }

    public static ArimaModel add(IArimaModel l, ArimaModel r) {
        return ArimaModel.of(l).plus(r);
    }

    public static ArimaModel subtract(IArimaModel l, ArimaModel r) {
        return ArimaModel.of(l).minus(r);
    }

    public static boolean same(IArimaModel lm, IArimaModel rm, double eps) {
        if (Math.abs(lm.getInnovationVariance() - rm.getInnovationVariance()) > eps) {
            return false;
        }
        if (!lm.getNonStationaryAr().asPolynomial().equals(rm.getNonStationaryAr().asPolynomial(), eps)) {
            return false;
        }
        if (!lm.getStationaryAr().asPolynomial().equals(rm.getStationaryAr().asPolynomial(), eps)) {
            return false;
        }
        return lm.getMa().asPolynomial().equals(rm.getMa().asPolynomial(), eps);
    }

    public ArimaModel scaleVariance(double factor) {
        SymmetricFilter.Factorization fac;
        ArimaModel m = this.sma == null ? new ArimaModel(this.ar, this.delta, this.ma, this.var * factor) : new ArimaModel(this.ar, this.delta, this.sma.times(factor));
        m.sar = this.sar;
        SymmetricFilter dma = this.derivedsma;
        if (dma != null) {
            m.derivedsma = this.derivedsma.times(factor);
        }
        if ((fac = this.smaFactorization) != null) {
            m.smaFactorization = new SymmetricFilter.Factorization(fac.factor, fac.scaling * factor);
        }
        return m;
    }

    public ArimaModel normalize() {
        return this.scaleVariance(1.0 / this.getInnovationVariance());
    }

    private static ArimaModel pm(ArimaModel l, ArimaModel r, boolean plus, boolean simplify) {
        BackFilter ur;
        BackFilter ar;
        if (r.isWhiteNoise()) {
            if (plus) {
                return l.plus(r.getInnovationVariance());
            }
            return l.minus(r.getInnovationVariance());
        }
        if (l.isWhiteNoise() && plus) {
            return ArimaModel.add(l.getInnovationVariance(), r);
        }
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool();
        BackFilter lar = l.ar;
        BackFilter rar = r.ar;
        if (smp.simplify(lar, rar)) {
            ar = lar.times((BackFilter)smp.getRight());
            lar = (BackFilter)smp.getLeft();
            rar = (BackFilter)smp.getRight();
        } else {
            ar = lar.times(rar);
        }
        BackFilter lur = l.delta;
        BackFilter rur = r.delta;
        BackFilter.SimplifyingTool smpur = new BackFilter.SimplifyingTool();
        if (smpur.simplify(lur, rur)) {
            ur = lur.times((BackFilter)smpur.getRight());
            lar = lar.times((BackFilter)smpur.getLeft());
            rar = rar.times((BackFilter)smpur.getRight());
        } else {
            ur = lur.times(rur);
            lar = lar.times(lur);
            rar = rar.times(rur);
        }
        SymmetricFilter sl = SymmetricFilter.convolutionOf(lar);
        SymmetricFilter sr = SymmetricFilter.convolutionOf(rar);
        SymmetricFilter lma = l.symmetricMa();
        SymmetricFilter rma = r.symmetricMa();
        SymmetricFilter snum = plus ? lma.times(sr).plus(rma.times(sl)) : lma.times(sr).minus(rma.times(sl));
        if (snum.isNull()) {
            return NULL;
        }
        ArimaModel rslt = new ArimaModel(ar, ur, snum);
        if (simplify) {
            return rslt.simplify();
        }
        return rslt.simplifyAr();
    }

    @Override
    public BackFilter getAr() {
        return this.ar.times(this.delta);
    }

    @Override
    public int getArOrder() {
        return this.getStationaryArOrder() + this.getNonStationaryArOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getInnovationVariance() throws ArimaException {
        if (this.ma != null) {
            return this.var;
        }
        SymmetricFilter.Factorization fac = this.smaFactorization;
        if (fac == null) {
            ArimaModel arimaModel = this;
            synchronized (arimaModel) {
                fac = this.smaFactorization;
                if (fac == null) {
                    this.smaFactorization = fac = this.sma.factorize();
                }
            }
        }
        return fac.scaling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackFilter getMa() {
        if (this.ma != null) {
            return this.ma;
        }
        SymmetricFilter.Factorization fac = this.smaFactorization;
        if (fac == null) {
            ArimaModel arimaModel = this;
            synchronized (arimaModel) {
                fac = this.smaFactorization;
                if (fac == null) {
                    this.smaFactorization = fac = this.sma.factorize();
                }
            }
        }
        if (fac == null) {
            throw new ArimaException("invalid ARIMA");
        }
        return fac.factor;
    }

    @Override
    public int getMaOrder() {
        if (this.ma != null) {
            return this.ma.length() - 1;
        }
        return this.sma.getUpperBound();
    }

    @Override
    public BackFilter getNonStationaryAr() {
        return this.delta;
    }

    @Override
    public int getNonStationaryArOrder() {
        return this.delta.length() - 1;
    }

    @Override
    public BackFilter getStationaryAr() {
        return this.ar;
    }

    @Override
    public int getStationaryArOrder() {
        return this.ar.length() - 1;
    }

    @Override
    public boolean isInvertible() {
        try {
            Complex[] rma = this.getMa().roots();
            if (rma != null) {
                for (int i = 0; i < rma.length; ++i) {
                    double nrm = rma[i].absSquare();
                    if (!(nrm <= 1.000001)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (ArimaException ex) {
            return false;
        }
    }

    @Override
    public boolean isNull() {
        if (this == NULL) {
            return true;
        }
        return this.delta.length() == 1 && (this.sma != null ? this.sma.isNull() : Math.abs(this.var) < 1.0E-6);
    }

    public boolean isWhiteNoise() {
        if (this.ar.length() > 1) {
            return false;
        }
        if (this.delta.length() > 1) {
            return false;
        }
        if (this.ma != null && this.ma.length() > 1) {
            return false;
        }
        if (this.sma != null && this.sma.length() > 1) {
            return false;
        }
        return this.getInnovationVariance() > 0.0;
    }

    public ArimaModel minus(ArimaModel r) {
        return ArimaModel.pm(this, r, false, false);
    }

    public ArimaModel minus(ArimaModel r, boolean simplify) {
        return ArimaModel.pm(this, r, false, simplify);
    }

    public ArimaModel minus(double v) {
        if (this.isWhiteNoise() && Math.abs(this.var - this.getInnovationVariance()) < 1.0E-6) {
            return NULL;
        }
        SymmetricFilter sma = this.symmetricMa();
        SymmetricFilter sar = this.symmetricAr();
        SymmetricFilter snum = sma.minus(SymmetricFilter.multiply(v, sar));
        ArimaModel rslt = new ArimaModel(this.ar, this.delta, snum);
        rslt.sar = sar;
        return rslt;
    }

    public ArimaModel plus(ArimaModel r) {
        return ArimaModel.pm(this, r, true, true);
    }

    public ArimaModel plus(ArimaModel r, boolean simplify) {
        return ArimaModel.pm(this, r, true, simplify);
    }

    public ArimaModel plus(double v) {
        if (this.isWhiteNoise()) {
            return ArimaModel.whiteNoise(v + this.getInnovationVariance());
        }
        SymmetricFilter sma = this.symmetricMa();
        SymmetricFilter sar = this.symmetricAr();
        SymmetricFilter snum = sma.plus(SymmetricFilter.multiply(v, sar));
        ArimaModel rslt = new ArimaModel(this.ar, this.delta, snum);
        rslt.sar = sar;
        return rslt;
    }

    public ArimaModel plus(IArimaModel r) throws ArimaException {
        return this.plus(ArimaModel.of(r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymmetricFilter symmetricAr() {
        SymmetricFilter s = this.sar;
        if (s == null) {
            ArimaModel arimaModel = this;
            synchronized (arimaModel) {
                s = this.sar;
                if (s == null) {
                    this.sar = s = SymmetricFilter.convolutionOf(this.ar.times(this.delta));
                }
            }
        }
        return s;
    }

    public ArimaModel simplify() {
        ArimaModel m = this.simplifyAr();
        return m.simplifyUr();
    }

    public ArimaModel simplifyAr() {
        try {
            BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool();
            if (smp.simplify(this.ar, this.getMa())) {
                BackFilter nar = (BackFilter)smp.getLeft();
                BackFilter nma = (BackFilter)smp.getRight();
                return new ArimaModel(nar, this.delta, nma, this.getInnovationVariance());
            }
            return this;
        }
        catch (ArimaException e) {
            return this;
        }
    }

    public ArimaModel simplifyUr() {
        try {
            UnitRootsSolver urs = new UnitRootsSolver();
            if (!urs.factorize(this.getMa().asPolynomial())) {
                return this;
            }
            Polynomial.SimplifyingTool smp = new Polynomial.SimplifyingTool();
            if (smp.simplify(urs.getUnitRoots().asPolynomial(), this.delta.asPolynomial())) {
                BackFilter ndelta = new BackFilter((Polynomial)smp.getRight());
                BackFilter nma = new BackFilter(((Polynomial)smp.getLeft()).times(urs.remainder()));
                return new ArimaModel(this.getStationaryAr(), ndelta, nma, this.getInnovationVariance());
            }
            return this;
        }
        catch (ArimaException e) {
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymmetricFilter symmetricMa() {
        if (this.sma != null) {
            return this.sma;
        }
        SymmetricFilter s = this.derivedsma;
        if (s == null) {
            ArimaModel arimaModel = this;
            synchronized (arimaModel) {
                s = this.derivedsma;
                if (s == null) {
                    this.derivedsma = s = SymmetricFilter.convolutionOf(this.ma, this.var);
                }
            }
        }
        return this.derivedsma;
    }

    @Override
    public StationaryTransformation<ArimaModel> stationaryTransformation() {
        ArimaModel st;
        if (this.sma == null) {
            st = new ArimaModel(this.ar, BackFilter.ONE, this.ma, this.var);
            st.derivedsma = this.derivedsma;
        } else {
            st = new ArimaModel(this.ar, BackFilter.ONE, this.sma);
            st.smaFactorization = this.smaFactorization;
        }
        return new StationaryTransformation<ArimaModel>(st, this.delta);
    }
}

