/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import java.util.function.ToDoubleFunction;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;

public class IntDomainMiddle
implements IntValueSelector {
    public static final boolean FLOOR = true;
    private static final ToDoubleFunction<IntVar> MIDEDEF = var -> (double)(var.getLB() + var.getUB()) / 2.0;
    private final boolean roundingPolicy;
    private final ToDoubleFunction<IntVar> middle;

    public IntDomainMiddle(boolean roundingPolicy) {
        this(MIDEDEF, roundingPolicy);
    }

    public IntDomainMiddle(ToDoubleFunction<IntVar> middle, boolean roudingPolicy) {
        this.middle = middle;
        this.roundingPolicy = roudingPolicy;
    }

    @Override
    public int selectValue(IntVar var) {
        double mean = this.middle.applyAsDouble(var);
        int value = this.roundingPolicy ? (int)Math.floor(mean) : (int)Math.ceil(mean);
        if (var.hasEnumeratedDomain() && !var.contains(value)) {
            double b;
            double a2 = var.previousValue(value);
            if (mean - a2 < (b = (double)var.nextValue(value)) - mean) {
                return (int)a2;
            }
            if (mean - a2 > b - mean) {
                return (int)b;
            }
            if (this.roundingPolicy) {
                return (int)a2;
            }
            return (int)b;
        }
        return value;
    }
}

