/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Metric;
import cc.mallet.types.SparseVector;

public class EuclideanDistance
implements Metric {
    @Override
    public double distance(SparseVector a, SparseVector b) {
        double diff;
        double dist = 0.0;
        if (a == null || b == null) {
            throw new IllegalArgumentException("Distance from a null vector is undefined.");
        }
        int leftLength = a.numLocations();
        int rightLength = b.numLocations();
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < leftLength && rightIndex < rightLength) {
            int rightFeature;
            int leftFeature = a.indexAtLocation(leftIndex);
            if (leftFeature < (rightFeature = b.indexAtLocation(rightIndex))) {
                diff = a.valueAtLocation(leftIndex);
                ++leftIndex;
            } else if (leftFeature == rightFeature) {
                diff = a.valueAtLocation(leftIndex) - b.valueAtLocation(rightIndex);
                ++leftIndex;
                ++rightIndex;
            } else {
                diff = b.valueAtLocation(rightIndex);
                ++rightIndex;
            }
            dist += diff * diff;
        }
        while (leftIndex < leftLength) {
            diff = a.valueAtLocation(leftIndex);
            dist += diff * diff;
            ++leftIndex;
        }
        while (rightIndex < rightLength) {
            diff = b.valueAtLocation(rightIndex);
            dist += diff * diff;
            ++rightIndex;
        }
        return Math.sqrt(dist);
    }
}

