/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.extract.StringSpan;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.StringIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenSequence2PorterStems
extends Pipe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    @Override
    public Instance pipe(Instance carrier) {
        if (carrier.getData() instanceof TokenSequence) {
            TokenSequence data = (TokenSequence)carrier.getData();
            carrier.setData(this.stem(data));
            return carrier;
        }
        throw new IllegalArgumentException("TokenSequence2PorterStems expects a TokenSequence, found a " + carrier.getData().getClass());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }

    private TokenSequence stem(TokenSequence tokenSequence) {
        PorterStemmer stemmer = new PorterStemmer();
        StringIterator text = new StringIterator("");
        for (Token token : tokenSequence) {
            char c;
            if (token == null || !(token instanceof StringSpan)) continue;
            text.reset(token.getText());
            while (!text.isEndOfText() && Character.isLetter(c = text.peek())) {
                stemmer.add(c);
                text.moveAhead();
            }
            stemmer.stem();
            token.setText(stemmer.toString());
        }
        return tokenSequence;
    }

    private class PorterStemmer {
        private static final int INC = 50;
        private char[] b = new char[50];
        private int i = 0;
        private int i_end = 0;
        private int j;
        private int k;

        public String toString() {
            return new String(this.b, 0, this.i_end);
        }

        public void add(char ch) {
            if (this.i == this.b.length) {
                char[] new_b = new char[this.i + 50];
                for (int c = 0; c < this.i; ++c) {
                    new_b[c] = this.b[c];
                }
                this.b = new_b;
            }
            this.b[this.i++] = ch;
        }

        private boolean cons(int i) {
            switch (this.b[i]) {
                case 'a': {
                    return false;
                }
                case 'e': {
                    return false;
                }
                case 'i': {
                    return false;
                }
                case 'o': {
                    return false;
                }
                case 'u': {
                    return false;
                }
                case 'y': {
                    return i == 0 ? true : !this.cons(i - 1);
                }
            }
            return true;
        }

        private int m() {
            int n = 0;
            int i = 0;
            while (true) {
                if (i > this.j) {
                    return n;
                }
                if (!this.cons(i)) break;
                ++i;
            }
            ++i;
            while (i <= this.j) {
                if (!this.cons(i)) {
                    ++i;
                    continue;
                }
                ++i;
                ++n;
                while (true) {
                    if (i > this.j) {
                        return n;
                    }
                    if (!this.cons(i)) break;
                    ++i;
                }
                ++i;
            }
            return n;
        }

        private boolean vowelinstem() {
            for (int i = 0; i <= this.j; ++i) {
                if (this.cons(i)) continue;
                return true;
            }
            return false;
        }

        private boolean doublec(int j) {
            if (j < 1) {
                return false;
            }
            if (this.b[j] != this.b[j - 1]) {
                return false;
            }
            return this.cons(j);
        }

        private boolean cvc(int i) {
            if (i < 2 || !this.cons(i) || this.cons(i - 1) || !this.cons(i - 2)) {
                return false;
            }
            char ch = this.b[i];
            return ch != 'w' && ch != 'x' && ch != 'y';
        }

        private boolean ends(String s) {
            int l = s.length();
            int o = this.k - l + 1;
            if (o < 0) {
                return false;
            }
            for (int i = 0; i < l; ++i) {
                if (this.b[o + i] == s.charAt(i)) continue;
                return false;
            }
            this.j = this.k - l;
            return true;
        }

        private void setto(String s) {
            int l = s.length();
            int o = this.j + 1;
            for (int i = 0; i < l; ++i) {
                this.b[o + i] = s.charAt(i);
            }
            this.k = this.j + l;
        }

        private void r(String s) {
            if (this.m() > 0) {
                this.setto(s);
            }
        }

        private void step1() {
            if (this.b[this.k] == 's') {
                if (this.ends("sses")) {
                    this.k -= 2;
                } else if (this.ends("ies")) {
                    this.setto("i");
                } else if (this.b[this.k - 1] != 's') {
                    --this.k;
                }
            }
            if (this.ends("eed")) {
                if (this.m() > 0) {
                    --this.k;
                }
            } else if ((this.ends("ed") || this.ends("ing")) && this.vowelinstem()) {
                this.k = this.j;
                if (this.ends("at")) {
                    this.setto("ate");
                } else if (this.ends("bl")) {
                    this.setto("ble");
                } else if (this.ends("iz")) {
                    this.setto("ize");
                } else if (this.doublec(this.k)) {
                    --this.k;
                    char ch = this.b[this.k];
                    if (ch == 'l' || ch == 's' || ch == 'z') {
                        ++this.k;
                    }
                } else if (this.m() == 1 && this.cvc(this.k)) {
                    this.setto("e");
                }
            }
        }

        private void step2() {
            if (this.ends("y") && this.vowelinstem()) {
                this.b[this.k] = 105;
            }
        }

        private void step3() {
            if (this.k == 0) {
                return;
            }
            switch (this.b[this.k - 1]) {
                case 'a': {
                    if (this.ends("ational")) {
                        this.r("ate");
                        break;
                    }
                    if (!this.ends("tional")) break;
                    this.r("tion");
                    break;
                }
                case 'c': {
                    if (this.ends("enci")) {
                        this.r("ence");
                        break;
                    }
                    if (!this.ends("anci")) break;
                    this.r("ance");
                    break;
                }
                case 'e': {
                    if (!this.ends("izer")) break;
                    this.r("ize");
                    break;
                }
                case 'l': {
                    if (this.ends("bli")) {
                        this.r("ble");
                        break;
                    }
                    if (this.ends("alli")) {
                        this.r("al");
                        break;
                    }
                    if (this.ends("entli")) {
                        this.r("ent");
                        break;
                    }
                    if (this.ends("eli")) {
                        this.r("e");
                        break;
                    }
                    if (!this.ends("ousli")) break;
                    this.r("ous");
                    break;
                }
                case 'o': {
                    if (this.ends("ization")) {
                        this.r("ize");
                        break;
                    }
                    if (this.ends("ation")) {
                        this.r("ate");
                        break;
                    }
                    if (!this.ends("ator")) break;
                    this.r("ate");
                    break;
                }
                case 's': {
                    if (this.ends("alism")) {
                        this.r("al");
                        break;
                    }
                    if (this.ends("iveness")) {
                        this.r("ive");
                        break;
                    }
                    if (this.ends("fulness")) {
                        this.r("ful");
                        break;
                    }
                    if (!this.ends("ousness")) break;
                    this.r("ous");
                    break;
                }
                case 't': {
                    if (this.ends("aliti")) {
                        this.r("al");
                        break;
                    }
                    if (this.ends("iviti")) {
                        this.r("ive");
                        break;
                    }
                    if (!this.ends("biliti")) break;
                    this.r("ble");
                    break;
                }
                case 'g': {
                    if (!this.ends("logi")) break;
                    this.r("log");
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void step4() {
            switch (this.b[this.k]) {
                case 'e': {
                    if (this.ends("icate")) {
                        this.r("ic");
                        break;
                    }
                    if (this.ends("ative")) {
                        this.r("");
                        break;
                    }
                    if (!this.ends("alize")) break;
                    this.r("al");
                    break;
                }
                case 'i': {
                    if (!this.ends("iciti")) break;
                    this.r("ic");
                    break;
                }
                case 'l': {
                    if (this.ends("ical")) {
                        this.r("ic");
                        break;
                    }
                    if (!this.ends("ful")) break;
                    this.r("");
                    break;
                }
                case 's': {
                    if (!this.ends("ness")) break;
                    this.r("");
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void step5() {
            if (this.k == 0) {
                return;
            }
            switch (this.b[this.k - 1]) {
                case 'a': {
                    if (this.ends("al")) break;
                    return;
                }
                case 'c': {
                    if (this.ends("ance") || this.ends("ence")) break;
                    return;
                }
                case 'e': {
                    if (this.ends("er")) break;
                    return;
                }
                case 'i': {
                    if (this.ends("ic")) break;
                    return;
                }
                case 'l': {
                    if (this.ends("able") || this.ends("ible")) break;
                    return;
                }
                case 'n': {
                    if (this.ends("ant") || this.ends("ement") || this.ends("ment") || this.ends("ent")) break;
                    return;
                }
                case 'o': {
                    if (this.ends("ion") && this.j >= 0 && (this.b[this.j] == 's' || this.b[this.j] == 't') || this.ends("ou")) break;
                    return;
                }
                case 's': {
                    if (this.ends("ism")) break;
                    return;
                }
                case 't': {
                    if (this.ends("ate") || this.ends("iti")) break;
                    return;
                }
                case 'u': {
                    if (this.ends("ous")) break;
                    return;
                }
                case 'v': {
                    if (this.ends("ive")) break;
                    return;
                }
                case 'z': {
                    if (this.ends("ize")) break;
                    return;
                }
                default: {
                    return;
                }
            }
            if (this.m() > 1) {
                this.k = this.j;
            }
        }

        private void step6() {
            int a;
            this.j = this.k;
            if (this.b[this.k] == 'e' && ((a = this.m()) > 1 || a == 1 && !this.cvc(this.k - 1))) {
                --this.k;
            }
            if (this.b[this.k] == 'l' && this.doublec(this.k) && this.m() > 1) {
                --this.k;
            }
        }

        private void stem() {
            this.k = this.i - 1;
            if (this.k > 1) {
                this.step1();
                this.step2();
                this.step3();
                this.step4();
                this.step5();
                this.step6();
            }
            this.i_end = this.k + 1;
            this.i = 0;
        }
    }
}

