/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.corehunter.data.CoreHunterData;
import org.corehunter.objectives.distance.DistanceMeasure;
import org.corehunter.objectives.distance.measures.MissingValuesPolicy;
import org.jamesframework.core.exceptions.IncompatibleDeltaEvaluationException;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.objectives.evaluations.SimpleEvaluation;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;

public class AverageEntryToEntry
implements Objective<SubsetSolution, CoreHunterData> {
    private final DistanceMeasure distanceMeasure;

    public AverageEntryToEntry(DistanceMeasure distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
        distanceMeasure.setMissingValuesPolicy(MissingValuesPolicy.FLOOR);
    }

    @Override
    public Evaluation evaluate(SubsetSolution solution, CoreHunterData data) {
        double value = 0.0;
        if (solution.getNumSelectedIDs() >= 2) {
            double sumDist = 0.0;
            Integer[] selected = new Integer[solution.getNumSelectedIDs()];
            solution.getSelectedIDs().toArray(selected);
            int n = selected.length;
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    sumDist += this.distanceMeasure.getDistance(selected[i], selected[j], data);
                }
            }
            int numDist = n * (n - 1) / 2;
            value = sumDist / (double)numDist;
        }
        return SimpleEvaluation.WITH_VALUE(value);
    }

    @Override
    public Evaluation evaluate(Move move, SubsetSolution curSolution, Evaluation curEvaluation, CoreHunterData data) {
        int ret;
        Iterator<Object> iterator;
        if (!(move instanceof SubsetMove)) {
            throw new IncompatibleDeltaEvaluationException("Entry-to-entry distance objective should be used in combination with neighbourhoods that generate moves of type SubsetMove.");
        }
        SubsetMove subsetMove = (SubsetMove)move;
        double curEval = curEvaluation.getValue();
        int n = curSolution.getNumSelectedIDs();
        int numDistances = n * (n - 1) / 2;
        double sumDist = curEval * (double)numDistances;
        Set<Integer> added = subsetMove.getAddedIDs();
        Set<Integer> removed = subsetMove.getDeletedIDs();
        ArrayList<Integer> retained = new ArrayList<Integer>(curSolution.getSelectedIDs());
        retained.removeAll(removed);
        for (int rem : removed) {
            iterator = retained.iterator();
            while (iterator.hasNext()) {
                ret = (Integer)iterator.next();
                sumDist -= this.distanceMeasure.getDistance(rem, ret, data);
                --numDistances;
            }
        }
        for (int rem1 : removed) {
            iterator = removed.iterator();
            while (iterator.hasNext()) {
                int rem2 = (Integer)iterator.next();
                if (rem1 >= rem2) continue;
                sumDist -= this.distanceMeasure.getDistance(rem1, rem2, data);
                --numDistances;
            }
        }
        for (int add : added) {
            iterator = retained.iterator();
            while (iterator.hasNext()) {
                ret = (Integer)iterator.next();
                sumDist += this.distanceMeasure.getDistance(add, ret, data);
                ++numDistances;
            }
        }
        for (int add1 : added) {
            iterator = added.iterator();
            while (iterator.hasNext()) {
                int add2 = (Integer)iterator.next();
                if (add1 >= add2) continue;
                sumDist += this.distanceMeasure.getDistance(add1, add2, data);
                ++numDistances;
            }
        }
        double newEval = numDistances > 0 ? sumDist / (double)numDistances : 0.0;
        return SimpleEvaluation.WITH_VALUE(newEval);
    }

    @Override
    public boolean isMinimizing() {
        return false;
    }

    public String toString() {
        return "Average entry to entry (" + this.distanceMeasure + ")";
    }
}

