## ---- setup, include=FALSE----------------------------------------------------
knitr::opts_template$set(fullwidth = list(
  fig.width = 4, fig.height = 4, 
  fig.retina = 2, out.width = '50%', out.height = '50%'
))

## ----fig-workflow, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 1: PERK Workflow",  out.width="100%"----
knitr::include_graphics("img/perk_workflow-min.png")

## ----fig-features, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 2. PERK: Features",  out.width="100%"----
knitr::include_graphics("img/perk_features-min.png")

## ----fig-upload-data, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 3. PERK: Upload Data",  out.width="100%"----
knitr::include_graphics("img/datainput-min.png")

## ----fig-predicted01, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 4. Predicted: Prescription - AV Panel.",  out.width="100%"----
knitr::include_graphics("img/predicted01-min.png")

## ----fig-prescraw, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 5. PC: kg/month.",  out.width="100%"----
knitr::include_graphics("img/prescplot01-1-min.png")

## ----fig-prescpndp, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 6. PC: PNDP.",  out.width="100%"----
knitr::include_graphics("img/prescplot02-1-min.png")

## ----fig-predicted02, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 7. Predicted: Predicted Concentrations - AV Panel.",  out.width="100%"----
knitr::include_graphics("img/predicted02-min.png")

## ----fig-predicted03, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 8. PC: concentration/month.",  out.width="100%"----
knitr::include_graphics("img/predplot01-1-min.png")

## ----fig-predicted04, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 9. PC: concentration/period.",  out.width="100%"----
knitr::include_graphics("img/predplot02-1-min.png")

## ----fig-measured01, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 10. Measured: Measured Concentrations - AV Panel.",  out.width="100%"----
knitr::include_graphics("img/measured01-min.png")

## ----fig-mcmonth, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 11. MC: concentration/month.",  out.width="100%"----
knitr::include_graphics("img/mcplot01-1-min.png")

## ----fig-mctotal, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 12. MC: concentration/period.",  out.width="100%"----
knitr::include_graphics("img/mcplot02-1-min.png")

## ----fig-pcsvsmc01, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 13. Predicted vs Measured: Predicted vs Measured - AV Panel.",  out.width="100%"----
knitr::include_graphics("img/pcvsmc01-min.png")

## ----fig-pcvsmcplot1, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 14. PCvsMC: PEC-I.",  out.width="100%"----
knitr::include_graphics("img/pcvsmcplot01-1-min.png")

## ----fig-pcvsmcplot2, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 15. PCvsMC: PEC-II.",  out.width="100%"----
knitr::include_graphics("img/pcvsmcplot02-1-min.png")

## ----fig-pcsvsmc02, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 16. Predicted vs Measured: Prediction Accuracy - AV Panel.",  out.width="100%"----
knitr::include_graphics("img/pcvsmc02-min.png")

## ----fig-paplot01, echo=FALSE, message=FALSE, warning=FALSE, fig.cap="Figure 17. PCvsMC: PA-I.",  out.width="100%"----
knitr::include_graphics("img/paplot01-1-min.png")

