## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(IndiAPIs)
library(ggplot2)
library(dplyr)

## ----india-gdp,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


india_gdp <- head(get_india_gdp())

print(india_gdp)


## ----india-life-expectancy,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

india_life_expectancy <- head(get_india_life_expectancy())

print(india_life_expectancy)


## ----india-population,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

india_population <- head(get_india_population())

print(india_population)


## ----india-gold-price-plot, message=FALSE, warning=FALSE, fig.width=7, fig.height=5----

# Calculate average prices by city
city_avg <- GoldPricesIndia_df %>%
  mutate(
    Chennai_Avg = (Chennai_Low + Chennai_High) / 2,
    Kolkatta_Avg = (Kolkatta_Low + Kolkatta_High) / 2,
    Bangalore_Avg = (Bangalore_Low + Bangalore_High) / 2,
    Madurai_Avg = (Madurai_Low + Madurai_High) / 2,
    Hyderabad_Avg = (Hyderabad_Low + Hyderabad_High) / 2,
    Delhi_Avg = (Delhi_Low + Delhi_High) / 2,
    Month = factor(Month, levels = c("Feb", "Mar", "Apr", "May", "Jun", 
                                    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"))
  )

# Create the plot
ggplot(city_avg, aes(x = Month)) +
  geom_line(aes(y = Chennai_Avg, color = "Chennai", group = 1)) +
  geom_line(aes(y = Kolkatta_Avg, color = "Kolkatta", group = 1)) +
  geom_line(aes(y = Bangalore_Avg, color = "Bangalore", group = 1)) +
  geom_line(aes(y = Madurai_Avg, color = "Madurai", group = 1)) +
  geom_line(aes(y = Hyderabad_Avg, color = "Hyderabad", group = 1)) +
  geom_line(aes(y = Delhi_Avg, color = "Delhi", group = 1)) +
  labs(title = "Gold Prices Across Indian Cities",
       x = "Month",
       y = "Average Price (INR)",
       color = "City") +
  theme_minimal() +
  theme(axis.text.x = element_text(angle = 45, hjust = 1))


