/*
Copyright (c) 2014-2015, Michael Daines
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

(function(global) {
var Module = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||16777216;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;if(Module["buffer"]){buffer=Module["buffer"];assert(buffer.byteLength===TOTAL_MEMORY,"provided buffer should be "+TOTAL_MEMORY+" bytes, but it is "+buffer.byteLength)}else{buffer=new ArrayBuffer(TOTAL_MEMORY)}HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[(function($0){{appendError($0)}})];function _emscripten_asm_const_1(code,a0){return ASM_CONSTS[code](a0)}STATIC_BASE=8;STATICTOP=STATIC_BASE+193488;__ATINIT__.push();allocate([0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,32,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,2,16,0,0,0,0,0,0,0,0,0,0,0,0,16,64,184,176,0,0,8,0,0,0,1,0,0,0,0,0,0,0,2,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,150,64,0,0,0,0,0,128,150,64,4,144,195,0,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,0,32,3,2,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,66,64,0,0,0,0,0,0,66,64,0,0,0,0,0,32,131,64,0,0,0,0,0,192,136,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,64,0,0,0,0,0,0,66,64,0,0,0,0,0,32,131,64,0,0,0,0,0,192,136,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,176,193,0,0,0,0,0,0,0,0,0,0,0,16,64,176,182,0,0,147,0,0,0,1,0,0,0,0,0,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,16,0,2,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,0,176,193,0,0,0,0,0,0,0,0,0,0,0,0,0,176,186,0,0,16,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,64,0,0,0,0,0,0,88,64,64,32,62,3,0,0,0,0,0,0,0,0,0,0,16,64,184,187,0,0,122,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,64,0,0,0,0,0,0,82,64],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([255,255,255,255,255,255,239,127,255,255,255,255,255,255,239,127,255,255,255,255,255,255,239,255,255,255,255,255,255,255,239,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,51,51,51,51,51,211,63,0,0,0,0,0,0,248,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,169,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,169,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,169,241,210,77,98,80,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,38,245,107,12,195,1,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,224,63,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,4,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,51,51,51,51,51,51,243,63,5,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,154,153,153,153,153,153,233,63,6,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,7,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,224,63,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,255,255,255,255,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,191,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,51,51,51,51,51,211,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,128,70,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,153,153,153,153,153,217,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,51,51,51,51,51,227,63,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,20,174,71,225,122,228,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,128,102,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,128,102,64,154,153,153,153,153,153,217,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,128,102,64,123,20,174,71,225,122,228,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,128,70,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,0,1,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,1,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,64,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,81,218,27,124,97,50,227,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,244,108,86,125,174,182,214,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,196,66,173,105,222,113,236,63,16,122,54,171,62,87,229,63,245,219,215,129,115,70,204,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,136,133,90,211,188,227,216,63,1,77,132,13,79,175,226,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,1,77,132,13,79,175,226,63,1,77,132,13,79,175,226,63,1,77,132,13,79,175,226,63,181,21,251,203,238,201,225,63,204,93,75,200,7,61,240,63,16,122,54,171,62,87,229,63,16,122,54,171,62,87,229,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,120,11,36,40,126,140,227,63,106,222,113,138,142,228,232,63,210,111,95,7,206,25,231,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,16,122,54,171,62,87,229,63,181,21,251,203,238,201,225,63,44,212,154,230,29,167,234,63,210,111,95,7,206,25,231,63,106,222,113,138,142,228,232,63,16,122,54,171,62,87,229,63,106,222,113,138,142,228,232,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,120,11,36,40,126,140,227,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,134,56,214,197,109,52,238,63,16,122,54,171,62,87,229,63,16,122,54,171,62,87,229,63,120,11,36,40,126,140,227,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,166,10,70,37,117,2,222,63,181,21,251,203,238,201,225,63,72,191,125,29,56,103,204,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,224,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,72,191,125,29,56,103,204,63,72,191,125,29,56,103,204,63,0,0,0,0,0,0,224,63,72,191,125,29,56,103,204,63,44,212,154,230,29,167,234,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,224,63,210,111,95,7,206,25,231,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,2,154,8,27,158,94,213,63,224,190,14,156,51,162,208,63,2,154,8,27,158,94,213,63,1,77,132,13,79,175,226,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,62,232,217,172,250,92,197,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,29,56,103,68,105,111,200,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,231,29,167,232,72,46,225,63,162,180,55,248,194,100,214,63,72,191,125,29,56,103,204,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,211,188,227,20,29,201,209,63,120,11,36,40,126,140,227,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,240,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,240,63,211,188,227,20,29,201,209,63,234,149,178,12,113,172,215,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,181,21,251,203,238,201,225,63,106,222,113,138,142,228,232,63,0,0,0,0,0,0,240,63,152,221,147,135,133,90,215,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,196,66,173,105,222,113,236,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,72,191,125,29,56,103,204,63,120,11,36,40,126,140,227,63,134,56,214,197,109,52,238,63,120,11,36,40,126,140,227,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,37,117,2,154,8,27,218,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,44,212,154,230,29,167,234,63,106,222,113,138,142,228,232,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,93,220,70,3,120,11,226,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,208,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,93,220,70,3,120,11,226,63,93,220,70,3,120,11,226,63,93,220,70,3,120,11,226,63,13,113,172,139,219,104,220,63,100,93,220,70,3,120,237,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,16,122,54,171,62,87,229,63,210,111,95,7,206,25,231,63,120,11,36,40,126,140,227,63,181,21,251,203,238,201,225,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,88,168,53,205,59,78,213,63,136,133,90,211,188,227,216,63,210,111,95,7,206,25,231,63,120,11,36,40,126,140,227,63,196,66,173,105,222,113,236,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,181,21,251,203,238,201,225,63,210,111,95,7,206,25,231,63,16,122,54,171,62,87,229,63,181,21,251,203,238,201,225,63,120,11,36,40,126,140,227,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,134,56,214,197,109,52,238,63,210,111,95,7,206,25,231,63,210,111,95,7,206,25,231,63,120,11,36,40,126,140,227,63,88,168,53,205,59,78,213,63,211,188,227,20,29,201,209,63,88,168,53,205,59,78,213,63,166,10,70,37,117,2,222,63,0,0,0,0,0,0,224,63,88,168,53,205,59,78,213,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,13,113,172,139,219,104,220,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,211,188,227,20,29,201,209,63,106,222,113,138,142,228,232,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,88,168,53,205,59,78,213,63,136,133,90,211,188,227,216,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,210,111,95,7,206,25,231,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,13,113,172,139,219,104,220,63,244,108,86,125,174,182,222,63,17,54,60,189,82,150,201,63,244,108,86,125,174,182,222,63,59,1,77,132,13,79,225,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,62,232,217,172,250,92,197,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,130,115,70,148,246,6,199,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,181,21,251,203,238,201,225,63,181,21,251,203,238,201,225,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,7,240,22,72,80,252,220,63,162,180,55,248,194,100,214,63,88,168,53,205,59,78,213,63,13,113,172,139,219,104,220,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,208,63,13,113,172,139,219,104,220,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,208,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,88,168,53,205,59,78,213,63,0,0,0,0,0,0,240,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,196,66,173,105,222,113,236,63,0,0,0,0,0,0,208,63,127,217,61,121,88,168,209,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,120,11,36,40,126,140,227,63,210,111,95,7,206,25,231,63,196,66,173,105,222,113,236,63,19,242,65,207,102,213,211,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,16,122,54,171,62,87,229,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,211,188,227,20,29,201,209,63,0,0,0,0,0,0,224,63,210,111,95,7,206,25,231,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,0,0,0,0,0,0,208,63,132,245,127,14,243,101,15,64,96,118,79,30,22,42,43,192,98,189,81,43,76,223,205,191,23,133,184,205,175,65,138,63,212,130,23,125,5,105,241,191,93,134,255,116,3,133,235,63,247,21,214,83,204,189,55,63,186,205,91,66,44,5,46,63,58,205,2,237,14,41,238,191,250,185,161,41,59,253,216,63,249,97,41,55,246,145,128,63,167,57,30,216,150,166,125,63,155,200,204,5,46,143,231,191,198,51,104,232,159,224,202,63,54,130,67,94,197,152,138,63,26,142,66,237,18,48,133,63,122,52,213,147,249,71,217,191,205,228,155,109,110,76,27,64,229,103,126,144,192,122,185,63,254,198,232,202,177,6,137,63,115,243,141,232,158,117,225,191,231,86,99,100,36,214,179,63,209,99,239,32,209,95,155,63,231,208,216,77,223,33,139,63,7,242,71,172,32,97,171,63,15,149,235,18,122,162,182,191,179,181,190,72,104,203,137,63,124,90,234,197,245,148,161,63,7,234,148,71,55,194,202,63,70,227,154,76,38,184,174,191,51,242,129,54,156,166,125,191,45,30,197,214,191,45,128,63,210,26,131,78,8,29,182,63,88,57,180,200,118,30,39,192,85,193,168,164,78,128,5,192,246,9,160,24,89,50,199,63,137,149,209,200,231,21,207,63,98,45,62,5,192,248,252,191,11,94,244,21,164,25,249,63,129,236,245,238,143,247,250,63,43,47,249,159,252,221,205,63,115,187,151,251,228,40,221,191,250,210,219,159,139,134,204,63,235,201,252,163,111,210,217,63,230,44,162,220,108,98,175,63,228,132,9,163,89,217,186,191,225,188,147,170,72,224,166,63,204,197,8,118,54,195,129,63,88,55,222,29,25,171,157,63,234,178,152,216,124,188,26,64,206,0,23,100,203,242,197,63,117,250,139,234,190,173,149,63,192,189,33,67,125,129,159,63,171,93,19,210,26,131,170,191,36,176,222,77,92,51,150,63,170,17,85,83,237,46,179,191,9,198,28,95,214,31,168,191,63,198,220,181,132,124,192,63,82,147,133,84,246,2,180,191,0,0,0,0,0,0,0,64,111,210,217,110,39,182,159,191,60,37,49,82,57,55,171,63,66,108,250,253,172,67,151,191,197,80,243,250,56,63,166,63,123,20,174,71,225,122,148,63,164,112,61,10,215,163,6,64,0,0,0,0,0,0,192,63,123,20,174,71,225,122,132,63,81,160,79,228,73,210,14,64,180,200,118,190,159,58,53,192,58,34,223,165,212,37,213,191,243,130,62,71,154,46,138,63,159,229,121,112,119,214,249,191,126,253,16,27,44,156,230,63,150,236,216,8,196,235,204,63,205,206,162,119,42,224,208,63,176,227,191,64,16,32,237,191],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+33272);allocate([173,161,212,94,68,219,216,63,59,161,124,230,81,150,118,63,211,110,112,249,122,132,123,63,129,204,206,162,119,42,228,191,209,173,215,244,160,160,200,63,106,223,55,25,176,63,132,63,190,202,144,25,94,255,132,63,28,150,6,126,84,195,196,191,165,73,41,232,246,226,35,64,169,217,3,173,192,144,193,63,8,196,144,65,147,105,137,63,250,68,158,36,93,51,208,191,1,240,153,54,45,194,94,63,13,156,125,47,207,148,151,63,137,181,248,20,0,227,137,63,229,169,88,70,52,203,177,191,143,0,201,207,161,103,166,191,92,181,198,251,204,180,136,63,77,164,143,84,58,179,144,63,230,199,4,161,97,214,160,191,199,105,103,28,19,247,130,191,42,127,107,229,45,112,92,191,228,87,98,84,8,154,117,63,209,241,135,85,114,4,183,63,149,212,9,104,34,60,51,192,100,35,16,175,235,119,16,192,167,33,170,240,103,120,199,63,218,255,0,107,213,174,193,63,78,40,68,192,33,84,247,191,170,72,133,177,133,32,245,63,157,104,87,33,229,39,246,63,77,46,198,192,58,142,205,63,89,107,40,181,23,209,220,191,3,63,170,97,191,39,204,63,166,71,83,61,153,127,218,63,182,129,59,80,167,60,174,63,81,76,222,0,51,223,185,191,245,118,149,255,218,11,166,63,212,165,53,188,15,246,148,63,31,173,32,188,44,220,144,63,40,44,241,128,178,201,35,64,35,90,225,76,2,138,183,63,72,163,101,81,150,41,127,63,187,180,134,247,193,158,147,63,23,168,123,83,71,125,160,191,33,43,174,224,109,148,139,63,51,115,220,132,214,30,181,191,160,120,132,137,245,252,143,63,105,53,36,238,177,244,145,191,184,205,51,122,94,191,106,63,146,62,173,162,63,52,205,191,126,176,231,198,79,62,152,191,7,35,155,80,45,199,164,63,62,24,194,123,88,185,145,191,45,124,125,173,75,141,198,63,252,169,241,210,77,98,80,63,236,81,184,30,133,235,19,64,229,208,34,219,249,126,202,63,83,150,33,142,117,113,123,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,223,65,0,0,0,64,251,33,249,63,0,0,0,0,45,68,116,62,0,0,0,128,152,70,248,60,0,0,0,96,81,204,120,59,0,0,0,128,131,27,240,57,0,0,0,64,32,37,122,56,0,0,0,128,34,130,227,54,0,0,0,0,29,243,105,53,0,0,0,0,0,0,0,0,0,0,0,0,93,153,1,0,116,172,0,0,3,0,0,0,64,174,0,0,3,0,0,0,144,176,0,0,3,0,0,0,52,177,0,0,3,0,0,0,104,178,0,0,3,0,0,0,136,182,0,0,3,0,0,0,172,185,0,0,3,0,0,0,120,186,0,0,3,0,0,0,72,190,0,0,3,0,0,0,144,187,0,0,0,0,0,0,4,174,0,0,0,0,0,0,104,176,0,0,0,0,0,0,12,177,0,0,0,0,0,0,64,178,0,0,0,0,0,0,96,182,0,0,0,0,0,0,132,185,0,0,0,0,0,0,80,186,0,0,0,0,0,0,32,190,0,0,0,0,0,0,104,187,0,0,4,0,0,0,152,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,24,2,0,1,0,0,0,20,173,0,0,8,0,0,0,4,0,0,0,101,153,1,0,1,0,0,0,140,173,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,114,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,1,0,0,0,121,153,1,0,1,0,0,0,0,0,0,0,72,0,0,0,2,0,0,0,131,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,3,0,0,0,141,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,4,0,0,0,155,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,5,0,0,0,165,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,6,0,0,0,178,153,1,0,1,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,175,0,0,128,175,0,0,144,175,0,0,160,175,0,0,176,175,0,0,192,175,0,0,208,175,0,0,224,175,0,0,128,175,0,0,128,175,0,0,192,175,0,0,192,175,0,0,0,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,1,0,0,0,5,0,0,0,2,0,0,0,2,0,0,0,6,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,120,154,1,0,1,0,0,0,240,175,0,0,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,154,1,0,1,0,0,0,0,0,0,0,56,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,171,2,0,74,148,2,0,219,149,2,0,27,156,2,0,18,163,2,0,81,167,2,0,209,170,2,0,226,170,2,0,0,0,0,0,69,171,2,0,74,148,2,0,27,156,2,0,219,149,2,0,81,167,2,0,18,163,2,0,226,170,2,0,209,170,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,72,156,1,0,1,0,0,0,192,177,0,0,112,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,76,156,1,0,1,0,0,0,0,0,0,0,144,1,0,0,2,0,0,0,86,156,1,0,1,0,0,0,0,0,0,0,200,1,0,0,0,0,0,0,95,156,1,0,1,0,0,0,0,0,0,0,200,1,0,0,3,0,0,0,104,156,1,0,1,0,0,0,0,0,0,0,200,1,0,0,0,0,0,0,114,156,1,0,1,0,0,0,0,0,0,0,144,1,0,0,3,0,0,0,126,156,1,0,1,0,0,0,0,0,0,0,144,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,33,2,0,1,0,0,0,184,178,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,217,1,0,1,0,0,0,0,0,0,0,32,2,0,0,1,0,0,0,197,157,1,0,1,0,0,0,0,0,0,0,32,2,0,0,2,0,0,0,42,217,1,0,1,0,0,0,0,0,0,0,88,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,3,0,0,0,9,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,196,161,1,0,210,161,1,0,232,161,1,0,86,185,2,0,246,161,1,0,5,162,1,0,10,162,1,0,40,162,1,0,86,185,2,0,58,162,1,0,106,162,1,0,86,185,2,0,136,162,1,0,176,162,1,0,190,162,1,0,237,162,1,0,33,163,1,0,50,163,1,0,87,163,1,0,122,163,1,0,128,163,1,0,156,163,1,0,185,163,1,0,212,163,1,0,245,163,1,0,15,164,1,0,49,164,1,0,80,164,1,0,118,164,1,0,142,164,1,0,174,164,1,0,203,164,1,0,239,164,1,0,251,164,1,0,86,185,2,0,6,165,1,0,44,165,1,0,80,165,1,0,118,165,1,0,86,185,2,0,172,165,1,0,196,165,1,0,209,165,1,0,0,166,1,0,251,164,1,0,86,185,2,0,13,166,1,0,22,166,1,0,55,166,1,0,114,166,1,0,189,166,1,0,17,167,1,0,51,167,1,0,72,167,1,0,95,167,1,0,117,167,1,0,141,167,1,0,86,185,2,0,163,167,1,0,190,167,1,0,226,167,1,0,6,168,1,0,43,168,1,0,86,185,2,0,76,168,1,0,102,168,1,0,120,168,1,0,133,168,1,0,146,168,1,0,166,168,1,0,181,168,1,0,189,168,1,0,210,168,1,0,224,168,1,0,30,169,1,0,41,169,1,0,251,164,1,0,86,185,2,0,47,169,1,0,59,169,1,0,74,169,1,0,122,163,1,0,86,185,2,0,93,169,1,0,134,169,1,0,164,169,1,0,180,169,1,0,197,169,1,0,204,169,1,0,219,169,1,0,235,169,1,0,47,170,1,0,54,170,1,0,122,163,1,0,86,185,2,0,64,170,1,0,108,170,1,0,119,170,1,0,128,170,1,0,137,170,1,0,154,170,1,0,171,170,1,0,191,170,1,0,251,164,1,0,86,185,2,0,203,170,1,0,219,170,1,0,233,170,1,0,247,170,1,0,4,171,1,0,17,171,1,0,39,171,1,0,48,171,1,0,63,171,1,0,76,171,1,0,93,171,1,0,251,164,1,0,86,185,2,0,104,171,1,0,135,171,1,0,86,185,2,0,153,171,1,0,168,171,1,0,216,171,1,0,226,171,1,0,239,171,1,0,252,171,1,0,9,172,1,0,22,172,1,0,25,172,1,0,86,185,2,0,29,172,1,0,86,185,2,0,64,172,1,0,113,172,1,0,160,172,1,0,183,172,1,0,210,172,1,0,237,172,1,0,251,164,1,0,86,185,2,0,9,173,1,0,86,185,2,0,49,173,1,0,61,173,1,0,80,173,1,0,99,173,1,0,120,173,1,0,141,173,1,0,145,173,1,0,122,163,1,0,86,185,2,0,157,173,1,0,86,185,2,0,173,173,1,0,187,173,1,0,199,173,1,0,212,173,1,0,244,173,1,0,4,174,1,0,26,174,1,0,86,185,2,0,46,174,1,0,119,174,1,0,189,174,1,0,237,174,1,0,32,175,1,0,39,175,1,0,78,175,1,0,117,175,1,0,86,185,2,0,122,175,1,0,0,0,0,0,26,0,0,0,0,0,0,0,27,0,0,0,28,0,0,0,5,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,4,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,11,0,0,0,6,0,0,0,4,0,0,0,12,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,128,33,2,0,1,0,0,0,232,181,0,0,144,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,218,1,0,1,0,0,0,0,0,0,0,176,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,147,2,0,108,147,2,0,50,184,1,0,177,147,2,0,236,147,2,0,14,148,2,0,20,148,2,0,69,171,2,0,59,148,2,0,74,148,2,0,103,148,2,0,114,148,2,0,148,148,2,0,202,148,2,0,0,149,2,0,59,149,2,0,113,149,2,0,147,149,2,0,162,149,2,0,211,149,2,0,219,149,2,0,238,175,1,0,247,175,1,0,248,149,2,0,0,176,1,0,66,150,2,0,9,176,1,0,76,150,2,0,18,176,1,0,86,150,2,0,165,150,2,0,224,150,2,0,30,176,1,0,27,151,2,0,38,151,2,0,107,151,2,0,121,151,2,0,195,151,2,0,209,151,2,0,223,151,2,0,234,151,2,0,27,152,2,0,91,152,2,0,99,152,2,0,107,152,2,0,166,152,2,0,220,152,2,0,232,152,2,0,55,184,1,0,244,152,2,0,254,152,2,0,9,153,2,0,38,153,2,0,92,153,2,0,27,156,2,0,61,156,2,0,73,156,2,0,8,159,2,0,57,159,2,0,101,159,2,0,155,159,2,0,168,159,2,0,202,159,2,0,236,159,2,0,245,159,2,0,63,160,2,0,73,160,2,0,142,160,2,0,196,160,2,0,207,160,2,0,84,161,2,0,105,161,2,0,38,176,1,0,115,161,2,0,125,161,2,0,179,161,2,0,243,161,2,0,1,162,2,0,85,162,2,0,100,162,2,0,115,162,2,0,194,162,2,0,63,184,1,0,2,163,2,0,12,163,2,0,18,163,2,0,62,163,2,0,101,163,2,0,118,163,2,0,129,163,2,0,198,163,2,0,11,164,2,0,26,164,2,0,42,164,2,0,60,164,2,0,76,164,2,0,92,164,2,0,105,164,2,0,115,164,2,0,169,164,2,0,178,164,2,0,242,164,2,0,5,165,2,0,68,184,1,0,13,165,2,0,67,165,2,0,106,165,2,0,160,165,2,0,199,165,2,0,213,165,2,0,11,166,2,0,85,166,2,0,159,166,2,0,170,166,2,0,224,166,2,0,229,166,2,0,2,167,2,0,31,167,2,0,42,167,2,0,81,167,2,0,105,167,2,0,159,167,2,0,213,167,2,0,225,167,2,0,8,168,2,0,19,168,2,0,68,168,2,0,117,168,2,0,111,196,1,0,156,168,2,0,200,168,2,0,254,168,2,0,52,169,2,0,62,169,2,0,91,169,2,0,155,169,2,0,209,169,2,0,74,184,1,0,233,169,2,0,21,170,2,0,60,170,2,0,114,170,2,0,175,170,2,0,209,170,2,0,215,170,2,0,226,170,2,0,9,171,2,0,214,176,1,0,210,176,1,0,0,0,0,0,0,0,0,0,39,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,0,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,14,0,0,0,7,0,0,0,5,0,0,0,15,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,195,182,1,0,1,0,0,0,12,185,0,0,232,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,182,1,0,1,0,0,0,0,0,0,0,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,0,0,0,0,0,0,0,44,0,0,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,17,0,0,0,8,0,0,0,6,0,0,0,18,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,38,184,1,0,1,0,0,0,216,185,0,0,64,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,184,1,0,1,0,0,0,0,0,0,0,96,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,184,1,0,69,171,2,0,74,148,2,0,55,184,1,0,92,153,2,0,27,156,2,0,63,184,1,0,62,163,2,0,242,164,2,0,68,184,1,0,42,167,2,0,81,167,2,0,111,196,1,0,74,184,1,0,209,170,2,0,226,170,2,0,47,0,0,0,0,0,0,0,48,0,0,0,49,0,0,0,9,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,0,0,0,0,20,0,0,0,10,0,0,0,7,0,0,0,21,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,249,194,1,0,1,0,0,0,240,186,0,0,152,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,194,1,0,1,0,0,0,0,0,0,0,184,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,147,2,0,5,195,1,0,69,171,2,0,74,148,2,0,103,148,2,0,16,195,1,0,22,195,1,0,33,195,1,0,40,195,1,0,114,148,2,0,202,148,2,0,48,195,1,0,54,195,1,0,65,195,1,0,113,149,2,0,147,149,2,0,219,149,2,0,72,195,1,0,66,150,2,0,86,150,2,0,224,150,2,0,82,195,1,0,107,151,2,0,121,151,2,0,195,151,2,0,93,195,1,0,209,151,2,0,101,195,1,0,110,195,1,0,124,195,1,0,134,195,1,0,166,152,2,0,143,195,1,0,232,152,2,0,9,153,2,0,38,153,2,0,149,195,1,0,109,153,2,0,152,153,2,0,193,153,2,0,228,153,2,0,13,154,2,0,48,154,2,0,89,154,2,0,124,154,2,0,165,154,2,0,200,154,2,0,241,154,2,0,20,155,2,0,61,155,2,0,96,155,2,0,137,155,2,0,172,155,2,0,213,155,2,0,248,155,2,0,27,156,2,0,156,195,1,0,61,156,2,0,168,195,1,0,101,159,2,0,202,159,2,0,142,160,2,0,181,195,1,0,115,162,2,0,194,195,1,0,2,163,2,0,18,163,2,0,204,195,1,0,62,163,2,0,101,163,2,0,118,163,2,0,219,195,1,0,237,195,1,0,129,163,2,0,11,164,2,0,26,164,2,0,42,164,2,0,60,164,2,0,76,164,2,0,253,195,1,0,8,196,1,0,19,196,1,0,92,164,2,0,242,164,2,0,247,164,2,0,24,196,1,0,33,196,1,0,42,196,1,0,58,196,1,0,65,196,1,0,67,165,2,0,106,165,2,0,160,165,2,0,213,165,2,0,229,166,2,0,2,167,2,0,73,196,1,0,81,167,2,0,80,196,1,0,225,167,2,0,89,196,1,0,19,168,2,0,97,196,1,0,117,168,2,0,111,196,1,0,156,168,2,0,200,168,2,0,118,196,1,0,91,169,2,0,155,169,2,0,128,196,1,0,209,169,2,0,233,169,2,0,60,170,2,0,138,196,1,0,152,196,1,0,114,170,2,0,121,170,2,0,175,170,2,0,209,170,2,0,226,170,2,0,9,171,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,61,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,23,0,0,0,11,0,0,0,8,0,0,0,24,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,206,1,0,255,255,255,255,168,189,0,0,240,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,206,1,0,255,255,255,255,0,0,0,0,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,206,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,66,0,0,160,52,2,0,65,73,0,0,122,52,2,0,65,82,0,0,77,52,2,0,65,88,0,0,181,52,2,0,66,32,0,0,241,54,2,0,66,73,0,0,2,55,2,0,67,66,0,0,58,53,2,0,67,79,0,0,40,53,2,0,67,88,0,0,71,53,2,0,72,32,0,0,107,53,2,0,72,66,0,0,117,53,2,0,72,73,0,0,1,54,2,0,72,88,0,0,132,53,2,0,72,98,0,0,181,53,2,0,72,105,0,0,232,53,2,0,72,114,0,0,154,53,2,0,72,120,0,0,203,53,2,0,73,32,0,0,19,55,2,0,75,66,0,0,204,52,2,0,75,73,0,0,20,53,2,0,75,82,0,0,0,53,2,0,75,88,0,0,237,52,2,0,78,66,0,0,19,54,2,0,78,73,0,0,90,54,2,0,78,82,0,0,114,54,2,0,78,88,0,0,62,54,2,0,80,65,0,0,211,54,2,0,80,66,0,0,143,54,2,0,80,73,0,0,195,54,2,0,80,88,0,0,175,54,2,0,82,32,0,0,193,56,2,0,83,32,0,0,226,54,2,0,90,68,0,0,80,55,2,0,0,0,0,0,0,0,0,0,1,0,0,0,15,0,0,0,170,216,1,0,1,0,0,0,128,195,0,0,0,0,0,0,16,0,0,0,178,216,1,0,1,0,0,0,128,195,0,0,0,0,0,0,17,0,0,0,186,216,1,0,1,0,0,0,128,195,0,0,0,0,0,0,17,0,0,0,195,216,1,0,1,0,0,0,128,195,0,0,0,0,0,0,17,0,0,0,203,216,1,0,1,0,0,0,128,195,0,0,0,0,0,0,19,0,0,0,211,216,1,0,1,0,0,0,132,195,0,0,0,0,0,0,20,0,0,0,219,216,1,0,1,0,0,0,132,195,0,0,0,0,0,0,21,0,0,0,227,216,1,0,1,0,0,0,132,195,0,0,0,0,0,0,21,0,0,0,236,216,1,0,1,0,0,0,132,195,0,0,0,0,0,0,21,0,0,0,244,216,1,0,1,0,0,0,132,195,0,0,0,0,0,0,22,0,0,0,252,216,1,0,1,0,0,0,136,195,0,0,0,0,0,0,23,0,0,0,5,217,1,0,1,0,0,0,136,195,0,0,0,0,0,0,24,0,0,0,14,217,1,0,1,0,0,0,136,195,0,0,0,0,0,0,24,0,0,0,24,217,1,0,1,0,0,0,136,195,0,0,0,0,0,0,24,0,0,0,33,217,1,0,1,0,0,0,136,195,0,0,0,0,0,0,25,0,0,0,42,217,1,0,1,0,0,0,140,195,0,0,0,0,0,0,25,0,0,0,49,217,1,0,1,0,0,0,140,195,0,0,0,0,0,0,26,0,0,0,55,217,1,0,1,0,0,0,144,195,0,0,0,0,0,0,10,0,0,0,64,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,11,0,0,0,72,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,12,0,0,0,80,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,12,0,0,0,89,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,12,0,0,0,97,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,14,0,0,0,105,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,14,0,0,0,112,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,13,0,0,0,120,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,5,0,0,0,128,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,6,0,0,0,136,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,7,0,0,0,144,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,7,0,0,0,153,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,7,0,0,0,161,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,9,0,0,0,169,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,9,0,0,0,176,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,8,0,0,0,184,217,1,0,1,0,0,0,148,195,0,0,0,0,0,0,0,0,0,0,192,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,1,0,0,0,201,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,2,0,0,0,210,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,2,0,0,0,220,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,2,0,0,0,229,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,4,0,0,0,238,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,4,0,0,0,246,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,3,0,0,0,255,217,1,0,1,0,0,0,152,195,0,0,0,0,0,0,18,0,0,0,8,218,1,0,1,0,0,0,128,195,0,0,0,0,0,0,27,0,0,0,16,218,1,0,1,0,0,0,156,195,0,0,0,0,0,0,28,0,0,0,24,218,1,0,1,0,0,0,156,195,0,0,0,0,0,0,29,0,0,0,32,218,1,0,1,0,0,0,156,195,0,0,0,0,0,0,29,0,0,0,41,218,1,0,1,0,0,0,156,195,0,0,0,0,0,0,29,0,0,0,49,218,1,0,1,0,0,0,156,195,0,0,0,0,0,0,30,0,0,0,57,218,1,0,1,0,0,0,160,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,164,221,1,0,172,195,0,0,1,0,0,0,200,195,0,0,0,0,0,0,0,0,0,0,63,0,0,0,64,0,0,0,1,0,0,0,0,0,0,0,209,24,2,0,0,0,0,0,188,195,0,0,196,195,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,1,0,0,48,1,0,0,176,0,0,0,47,229,1,0,52,229,1,0,56,229,1,0,63,229,1,0,67,229,1,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,234,1,0,120,197,0,0,1,0,0,0,212,197,0,0,0,0,0,0,0,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,66,0,0,0,76,0,0,0,66,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,50,234,1,0,0,0,0,0,136,197,0,0,208,197,0,0,1,0,0,0,56,234,1,0,0,0,0,0,144,197,0,0,208,197,0,0,2,0,0,0,60,234,1,0,0,0,0,0,152,197,0,0,208,197,0,0,3,0,0,0,65,234,1,0,0,0,0,0,160,197,0,0,208,197,0,0,4,0,0,0,71,234,1,0,0,0,0,0,168,197,0,0,208,197,0,0,5,0,0,0,77,234,1,0,0,0,0,0,192,197,0,0,208,197,0,0,6,0,0,0,87,234,1,0,0,0,0,0,200,197,0,0,208,197,0,0,7,0,0,0,93,234,1,0,0,0,0,0,176,197,0,0,208,197,0,0,7,0,0,0,97,234,1,0,0,0,0,0,176,197,0,0,208,197,0,0,7,0,0,0,102,234,1,0,0,0,0,0,184,197,0,0,208,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,242,236,1,0,8,0,0,0,48,0,0,0,0,0,0,0,1,0,0,0,28,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,185,2,0,0,0,0,0,0,165,2,0,1,0,0,0,245,252,1,0,7,0,0,0,253,252,1,0,3,0,0,0,63,186,2,0,5,0,0,0,5,253,1,0,15,0,0,0,101,33,2,0,8,0,0,0,101,33,2,0,16,0,0,0,13,253,1,0,4,0,0,0,13,253,1,0,17,0,0,0,18,253,1,0,5,0,0,0,18,253,1,0,2,0,0,0,24,253,1,0,6,0,0,0,31,253,1,0,4,0,0,0,43,253,1,0,7,0,0,0,51,253,1,0,7,0,0,0,67,253,1,0,5,0,0,0,73,253,1,0,8,0,0,0,96,253,1,0,8,0,0,0,73,253,1,0,9,0,0,0,105,253,1,0,7,0,0,0,113,253,1,0,10,0,0,0,139,253,1,0,7,0,0,0,147,253,1,0,11,0,0,0,173,253,1,0,6,0,0,0,180,253,1,0,12,0,0,0,210,253,1,0,9,0,0,0,180,253,1,0,13,0,0,0,220,253,1,0,8,0,0,0,229,253,1,0,14,0,0,0,6,254,1,0,8,0,0,0,15,254,1,0,18,0,0,0,48,254,1,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,12,0,0,0,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,3,0,0,0,29,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,30,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,64,0,0,0,228,202,0,0,109,11,2,0,8,203,0,0,16,203,0,0,6,0,0,0,4,0,0,0,252,202,0,0,6,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,8,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,11,2,0,0,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,8,0,0,0,10,0,0,0,196,204,0,0,68,204,0,0,172,204,0,0,0,0,0,0,1,0,0,0,1,0,0,0,7,0,0,0,32,0,0,0,8,0,0,0,81,0,0,0,33,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,9,0,0,0,2,0,0,0,5,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,3,0,0,0,12,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,0,0,14,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,6,0,0,0,1,0,0,0,1,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,1,0,0,0,1,0,0,0,11,0,0,0,1,0,0,0,12,0,0,0,1,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,19,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,1,0,0,0,30,0,0,0,1,0,0,0,1,0,0,0,19,0,0,0,1,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,19,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,19,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,46,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,47,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,48,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+43512);allocate([19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,4,0,0,0,1,0,0,0,5,0,0,0,1,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,1,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,3,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,70,2,0,87,70,2,0,213,14,2,0,106,70,2,0,112,70,2,0,97,70,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,89,19,2,0,96,19,2,0,133,70,2,0,103,19,2,0,110,19,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,20,2,0,8,0,0,0,3,0,0,0,229,20,2,0,233,20,2,0,11,0,0,0,6,0,0,0,125,33,2,0,245,20,2,0,2,0,0,0,1,0,0,0,248,20,2,0,252,20,2,0,4,0,0,0,2,0,0,0,1,21,2,0,5,21,2,0,4,0,0,0,4,0,0,0,10,21,2,0,15,21,2,0,5,0,0,0,5,0,0,0,21,21,2,0,25,21,2,0,4,0,0,0,7,0,0,0,30,21,2,0,34,21,2,0,5,0,0,0,9,0,0,0,40,21,2,0,44,21,2,0,4,0,0,0,10,0,0,0,49,21,2,0,54,21,2,0,4,0,0,0,12,0,0,0,59,21,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,29,2,0,0,0,0,0,1,0,0,0,94,29,2,0,1,0,0,0,0,0,0,0,47,69,2,0,1,0,0,0,1,0,0,0,0,165,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,24,2,0,49,0,0,0,0,0,0,0,0,0,0,0,230,57,2,0,16,0,0,0,142,177,2,0,128,0,0,0,236,24,2,0,64,0,0,0,23,47,2,0,16,0,0,0,238,24,2,0,64,0,0,0,0,0,0,0,0,0,0,0,193,24,2,0,1,0,0,0,200,24,2,0,2,0,0,0,205,24,2,0,3,0,0,0,212,64,2,0,4,0,0,0,107,47,2,0,5,0,0,0,209,24,2,0,6,0,0,0,0,165,2,0,8,0,0,0,213,24,2,0,33,0,0,0,217,24,2,0,34,0,0,0,221,24,2,0,34,0,0,0,225,24,2,0,1,0,0,0,230,24,2,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,28,2,0,235,28,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,208,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,33,2,0,125,33,2,0,128,33,2,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,255,255,255,255,61,33,2,0,67,33,2,0,0,165,2,0,0,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,39,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,11,0,0,0,40,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,64,2,0,208,222,0,0,80,133,0,0,0,0,0,0,58,47,2,0,208,222,0,0,128,133,0,0,0,0,0,0,185,56,2,0,208,222,0,0,176,133,0,0,0,0,0,0,66,47,2,0,208,222,0,0,176,133,0,0,0,0,0,0,71,47,2,0,208,222,0,0,224,133,0,0,0,0,0,0,78,47,2,0,232,222,0,0,224,133,0,0,0,0,0,0,84,47,2,0,208,222,0,0,16,134,0,0,0,0,0,0,88,47,2,0,208,222,0,0,64,134,0,0,0,0,0,0,0,165,2,0,208,222,0,0,112,134,0,0,0,0,0,0,97,47,2,0,208,222,0,0,112,134,0,0,0,0,0,0,107,47,2,0,208,222,0,0,160,134,0,0,0,0,0,0,115,47,2,0,208,222,0,0,208,134,0,0,0,0,0,0,125,47,2,0,208,222,0,0,0,135,0,0,0,0,0,0,139,47,2,0,208,222,0,0,48,135,0,0,0,0,0,0,145,47,2,0,208,222,0,0,96,135,0,0,0,0,0,0,154,47,2,0,208,222,0,0,144,135,0,0,0,0,0,0,162,47,2,0,208,222,0,0,192,135,0,0,0,0,0,0,171,47,2,0,208,222,0,0,240,135,0,0,0,0,0,0,179,47,2,0,208,222,0,0,32,136,0,0,0,0,0,0,184,47,2,0,208,222,0,0,80,136,0,0,0,0,0,0,188,47,2,0,208,222,0,0,128,136,0,0,0,0,0,0,195,47,2,0,208,222,0,0,176,136,0,0,0,0,0,0,201,47,2,0,208,222,0,0,224,136,0,0,0,0,0,0,211,47,2,0,208,222,0,0,80,133,0,0,0,0,0,0,216,47,2,0,208,222,0,0,80,133,0,0,0,0,0,0,226,47,2,0,208,222,0,0,16,137,0,0,0,0,0,0,233,47,2,0,208,222,0,0,64,137,0,0,0,0,0,0,246,47,2,0,208,222,0,0,112,137,0,0,0,0,0,0,4,48,2,0,208,222,0,0,160,137,0,0,0,0,0,0,18,48,2,0,208,222,0,0,208,137,0,0,0,0,0,0,30,48,2,0,208,222,0,0,0,138,0,0,0,0,0,0,43,48,2,0,208,222,0,0,48,138,0,0,0,0,0,0,52,48,2,0,208,222,0,0,96,138,0,0,0,0,0,0,62,48,2,0,208,222,0,0,144,138,0,0,0,0,0,0,71,48,2,0,208,222,0,0,192,138,0,0,0,0,0,0,79,48,2,0,208,222,0,0,240,138,0,0,0,0,0,0,87,48,2,0,208,222,0,0,32,139,0,0,0,0,0,0,96,48,2,0,208,222,0,0,80,139,0,0,0,0,0,0,100,48,2,0,208,222,0,0,128,139,0,0,0,0,0,0,111,48,2,0,208,222,0,0,176,139,0,0,0,0,0,0,115,48,2,0,208,222,0,0,224,139,0,0,0,0,0,0,125,48,2,0,208,222,0,0,16,140,0,0,0,0,0,0,134,48,2,0,208,222,0,0,64,140,0,0,0,0,0,0,142,48,2,0,208,222,0,0,112,140,0,0,0,0,0,0,155,48,2,0,208,222,0,0,160,140,0,0,0,0,0,0,167,48,2,0,208,222,0,0,208,140,0,0,0,0,0,0,178,48,2,0,208,222,0,0,0,141,0,0,0,0,0,0,194,48,2,0,208,222,0,0,48,141,0,0,0,0,0,0,208,48,2,0,208,222,0,0,96,141,0,0,0,0,0,0,223,48,2,0,208,222,0,0,144,141,0,0,0,0,0,0,233,48,2,0,208,222,0,0,192,141,0,0,0,0,0,0,242,48,2,0,208,222,0,0,240,141,0,0,0,0,0,0,252,48,2,0,208,222,0,0,32,142,0,0,0,0,0,0,6,49,2,0,208,222,0,0,80,142,0,0,0,0,0,0,13,49,2,0,208,222,0,0,128,142,0,0,0,0,0,0,20,49,2,0,208,222,0,0,176,142,0,0,0,0,0,0,30,49,2,0,0,223,0,0,0,0,0,0,0,0,0,0,37,49,2,0,0,223,0,0,0,0,0,0,0,0,0,0,9,47,2,0,24,223,0,0,0,0,0,0,0,0,0,0,45,49,2,0,48,223,0,0,224,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,47,2,0,23,47,2,0,233,177,2,0,25,47,2,0,82,0,0,0,83,0,0,0,21,0,0,0,4,0,0,0,2,0,0,0,10,0,0,0,84,0,0,0,83,0,0,0,21,0,0,0,5,0,0,0,0,0,0,0,11,0,0,0,85,0,0,0,86,0,0,0,22,0,0,0,6,0,0,0,3,0,0,0,12,0,0,0,87,0,0,0,88,0,0,0,21,0,0,0,7,0,0,0,0,0,0,0,13,0,0,0,82,0,0,0,83,0,0,0,21,0,0,0,8,0,0,0,2,0,0,0,10,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,50,2,0,54,50,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,4,0,0,0,6,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,9,0,0,0,8,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,77,52,2,0,93,52,2,0,106,52,2,0,0,0,0,0,0,0,0,0,4,0,0,0,111,52,2,0,0,0,0,0,0,0,0,0,122,52,2,0,93,52,2,0,106,52,2,0,0,0,0,0,145,52,2,0,5,0,0,0,111,52,2,0,0,0,0,0,153,52,2,0,160,52,2,0,93,52,2,0,176,52,2,0,0,0,0,0,0,0,0,0,6,0,0,0,111,52,2,0,165,68,2,0,0,0,0,0,181,52,2,0,93,52,2,0,176,52,2,0,0,0,0,0,145,52,2,0,7,0,0,0,111,52,2,0,165,68,2,0,153,52,2,0,204,52,2,0,217,52,2,0,176,52,2,0,0,0,0,0,0,0,0,0,10,0,0,0,231,52,2,0,165,68,2,0,0,0,0,0,237,52,2,0,217,52,2,0,176,52,2,0,0,0,0,0,153,52,2,0,11,0,0,0,231,52,2,0,165,68,2,0,153,52,2,0,0,53,2,0,217,52,2,0,14,53,2,0,0,0,0,0,0,0,0,0,8,0,0,0,231,52,2,0,0,0,0,0,0,0,0,0,20,53,2,0,217,52,2,0,14,53,2,0,0,0,0,0,153,52,2,0,9,0,0,0,231,52,2,0,0,0,0,0,153,52,2,0,40,53,2,0,40,53,2,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,48,53,2,0,0,0,0,0,0,0,0,0,58,53,2,0,40,53,2,0,165,68,2,0,0,0,0,0,0,0,0,0,14,0,0,0,48,53,2,0,165,68,2,0,0,0,0,0,71,53,2,0,40,53,2,0,165,68,2,0,0,0,0,0,145,52,2,0,15,0,0,0,48,53,2,0,165,68,2,0,153,52,2,0,91,53,2,0,40,53,2,0,0,0,0,0,0,0,0,0,145,52,2,0,13,0,0,0,48,53,2,0,0,0,0,0,153,52,2,0,107,53,2,0,107,53,2,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,111,52,2,0,0,0,0,0,0,0,0,0,117,53,2,0,107,53,2,0,165,68,2,0,0,0,0,0,0,0,0,0,18,0,0,0,111,52,2,0,165,68,2,0,0,0,0,0,132,53,2,0,107,53,2,0,165,68,2,0,0,0,0,0,145,52,2,0,19,0,0,0,111,52,2,0,165,68,2,0,153,52,2,0,154,53,2,0,107,53,2,0,0,0,0,0,171,53,2,0,0,0,0,0,20,0,0,0,111,52,2,0,0,0,0,0,0,0,0,0,181,53,2,0,107,53,2,0,165,68,2,0,171,53,2,0,0,0,0,0,22,0,0,0,111,52,2,0,165,68,2,0,0,0,0,0,203,53,2,0,107,53,2,0,165,68,2,0,171,53,2,0,145,52,2,0,23,0,0,0,111,52,2,0,165,68,2,0,153,52,2,0,232,53,2,0,107,53,2,0,0,0,0,0,171,53,2,0,145,52,2,0,21,0,0,0,111,52,2,0,0,0,0,0,153,52,2,0,1,54,2,0,107,53,2,0,0,0,0,0,0,0,0,0,145,52,2,0,17,0,0,0,111,52,2,0,0,0,0,0,153,52,2,0,19,54,2,0,41,54,2,0,165,68,2,0,0,0,0,0,0,0,0,0,26,0,0,0,231,52,2,0,165,68,2,0,0,0,0,0,62,54,2,0,41,54,2,0,165,68,2,0,0,0,0,0,153,52,2,0,27,0,0,0,231,52,2,0,165,68,2,0,153,52,2,0,90,54,2,0,41,54,2,0,0,0,0,0,0,0,0,0,153,52,2,0,25,0,0,0,231,52,2,0,0,0,0,0,153,52,2,0,114,54,2,0,41,54,2,0,137,54,2,0,0,0,0,0,0,0,0,0,24,0,0,0,231,52,2,0,0,0,0,0,0,0,0,0,143,54,2,0,157,54,2,0,165,68,2,0,0,0,0,0,0,0,0,0,30,0,0,0,231,52,2,0,165,68,2,0,0,0,0,0,175,54,2,0,157,54,2,0,165,68,2,0,0,0,0,0,153,52,2,0,31,0,0,0,231,52,2,0,165,68,2,0,153,52,2,0,195,54,2,0,157,54,2,0,0,0,0,0,0,0,0,0,153,52,2,0,29,0,0,0,231,52,2,0,0,0,0,0,153,52,2,0,211,54,2,0,157,54,2,0,137,54,2,0,0,0,0,0,0,0,0,0,28,0,0,0,231,52,2,0,0,0,0,0,0,0,0,0,226,54,2,0,226,54,2,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,233,54,2,0,0,0,0,0,0,0,0,0,241,54,2,0,252,54,2,0,165,68,2,0,0,0,0,0,0,0,0,0,2,0,0,0,231,52,2,0,165,68,2,0,0,0,0,0,2,55,2,0,252,54,2,0,165,68,2,0,0,0,0,0,153,52,2,0,3,0,0,0,231,52,2,0,165,68,2,0,153,52,2,0,19,55,2,0,252,54,2,0,0,0,0,0,0,0,0,0,153,52,2,0,1,0,0,0,231,52,2,0,0,0,0,0,153,52,2,0,193,56,2,0,252,54,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,231,52,2,0,0,0,0,0,0,0,0,0,32,55,2,0,58,55,2,0,73,55,2,0,0,0,0,0,153,52,2,0,33,0,0,0,231,52,2,0,0,0,0,0,153,52,2,0,80,55,2,0,93,55,2,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,0,0,233,54,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,12,0,0,0,42,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,58,2,0,198,0,0,0,80,58,2,0,193,0,0,0,87,58,2,0,194,0,0,0,93,58,2,0,192,0,0,0,100,58,2,0,145,3,0,0,106,58,2,0,197,0,0,0,112,58,2,0,195,0,0,0,119,58,2,0,196,0,0,0,124,58,2,0,146,3,0,0,129,58,2,0,199,0,0,0,136,58,2,0,167,3,0,0,140,58,2,0,33,32,0,0,147,58,2,0,148,3,0,0,153,58,2,0,208,0,0,0,157,58,2,0,201,0,0,0,164,58,2,0,202,0,0,0,170,58,2,0,200,0,0,0,177,58,2,0,149,3,0,0,185,58,2,0,151,3,0,0,189,58,2,0,203,0,0,0,194,58,2,0,147,3,0,0,200,58,2,0,205,0,0,0,207,58,2,0,206,0,0,0,213,58,2,0,204,0,0,0,220,58,2,0,153,3,0,0,225,58,2,0,207,0,0,0,230,58,2,0,154,3,0,0,236,58,2,0,155,3,0,0,243,58,2,0,156,3,0,0,246,58,2,0,209,0,0,0,253,58,2,0,157,3,0,0,0,59,2,0,82,1,0,0,6,59,2,0,211,0,0,0,13,59,2,0,212,0,0,0,19,59,2,0,210,0,0,0,26,59,2,0,169,3,0,0,32,59,2,0,159,3,0,0,40,59,2,0,216,0,0,0,47,59,2,0,213,0,0,0,54,59,2,0,214,0,0,0,59,59,2,0,166,3,0,0,63,59,2,0,160,3,0,0,66,59,2,0,51,32,0,0,72,59,2,0,168,3,0,0,76,59,2,0,161,3,0,0,80,59,2,0,96,1,0,0,87,59,2,0,163,3,0,0,93,59,2,0,222,0,0,0,99,59,2,0,164,3,0,0,103,59,2,0,152,3,0,0,109,59,2,0,218,0,0,0,116,59,2,0,219,0,0,0,122,59,2,0,217,0,0,0,129,59,2,0,165,3,0,0,137,59,2,0,220,0,0,0,142,59,2,0,158,3,0,0,145,59,2,0,221,0,0,0,152,59,2,0,120,1,0,0,157,59,2,0,150,3,0,0,162,59,2,0,225,0,0,0,169,59,2,0,226,0,0,0,175,59,2,0,180,0,0,0,181,59,2,0,230,0,0,0,187,59,2,0,224,0,0,0,194,59,2,0,53,33,0,0,202,59,2,0,177,3,0,0,208,59,2,0,38,0,0,0,212,59,2,0,39,34,0,0,216,59,2,0,32,34,0,0,220,59,2,0,229,0,0,0,226,59,2,0,72,34,0,0,232,59,2,0,227,0,0,0,239,59,2,0,228,0,0,0,244,59,2,0,30,32,0,0,250,59,2,0,178,3,0,0,255,59,2,0,166,0,0,0,6,60,2,0,34,32,0,0,11,60,2,0,41,34,0,0,15,60,2,0,231,0,0,0,22,60,2,0,184,0,0,0,28,60,2,0,162,0,0,0,33,60,2,0,199,3,0,0,37,60,2,0,198,2,0,0,42,60,2,0,99,38,0,0,48,60,2,0,69,34,0,0,53,60,2,0,169,0,0,0,58,60,2,0,181,33,0,0,64,60,2,0,42,34,0,0,68,60,2,0,164,0,0,0,75,60,2,0,211,33,0,0,80,60,2,0,32,32,0,0,87,60,2,0,147,33,0,0,92,60,2,0,176,0,0,0,96,60,2,0,180,3,0,0,102,60,2,0,102,38,0,0,108,60,2,0,247,0,0,0,115,60,2,0,233,0,0,0,122,60,2,0,234,0,0,0,128,60,2,0,232,0,0,0,135,60,2,0,5,34,0,0,141,60,2,0,3,32,0,0,146,60,2,0,2,32,0,0,151,60,2,0,181,3,0,0,159,60,2,0,97,34,0,0,165,60,2,0,183,3,0,0,169,60,2,0,240,0,0,0,173,60,2,0,235,0,0,0,178,60,2,0,172,32,0,0,183,60,2,0,3,34,0,0,189,60,2,0,146,1,0,0,194,60,2,0,0,34,0,0,201,60,2,0,189,0,0,0,208,60,2,0,188,0,0,0,215,60,2,0,190,0,0,0,222,60,2,0,68,32,0,0,228,60,2,0,179,3,0,0,234,60,2,0,101,34,0,0,237,60,2,0,62,0,0,0,240,60,2,0,212,33,0,0,245,60,2,0,148,33,0,0,250,60,2,0,101,38,0,0,1,61,2,0,38,32,0,0,8,61,2,0,237,0,0,0,15,61,2,0,238,0,0,0,21,61,2,0,161,0,0,0,27,61,2,0,236,0,0,0,34,61,2,0,17,33,0,0,40,61,2,0,30,34,0,0,46,61,2,0,43,34,0,0,50,61,2,0,185,3,0,0,55,61,2,0,191,0,0,0,62,61,2,0,8,34,0,0,67,61,2,0,239,0,0,0,72,61,2,0,186,3,0,0,78,61,2,0,208,33,0,0,83,61,2,0,187,3,0,0,90,61,2,0,41,35,0,0,95,61,2,0,171,0,0,0,101,61,2,0,144,33,0,0,106,61,2,0,8,35,0,0,112,61,2,0,28,32,0,0,118,61,2,0,100,34,0,0,121,61,2,0,10,35,0,0,128,61,2,0,23,34,0,0,135,61,2,0,202,37,0,0,139,61,2,0,14,32,0,0,143,61,2,0,57,32,0,0,150,61,2,0,24,32,0,0,156,61,2,0,60,0,0,0,159,61,2,0,175,0,0,0,164,61,2,0,20,32,0,0,170,61,2,0,181,0,0,0,176,61,2,0,183,0,0,0,32,70,2,0,18,34,0,0,183,61,2,0,188,3,0,0,186,61,2,0,7,34,0,0,192,61,2,0,160,0,0,0,197,61,2,0,19,32,0,0,203,61,2,0,96,34,0,0,206,61,2,0,11,34,0,0,209,61,2,0,172,0,0,0,213,61,2,0,9,34,0,0,219,61,2,0,132,34,0,0,224,61,2,0,241,0,0,0,231,61,2,0,189,3,0,0,234,61,2,0,243,0,0,0,241,61,2,0,244,0,0,0,247,61,2,0,83,1,0,0,253,61,2,0,242,0,0,0,4,62,2,0,62,32,0,0,10,62,2,0,201,3,0,0,16,62,2,0,191,3,0,0,24,62,2,0,149,34,0,0,30,62,2,0,40,34,0,0,33,62,2,0,170,0,0,0,38,62,2,0,186,0,0,0,43,62,2,0,248,0,0,0,50,62,2,0,245,0,0,0,57,62,2,0,151,34,0,0,64,62,2,0,246,0,0,0,69,62,2,0,182,0,0,0,74,62,2,0,2,34,0,0,79,62,2,0,48,32,0,0,86,62,2,0,165,34,0,0,91,62,2,0,198,3,0,0,95,62,2,0,192,3,0,0,98,62,2,0,214,3,0,0,102,62,2,0,177,0,0,0,109,62,2,0,163,0,0,0,115,62,2,0,50,32,0,0,121,62,2,0,15,34,0,0,126,62,2,0,29,34,0,0,131,62,2,0,200,3,0,0,135,62,2,0,34,0,0,0,140,62,2,0,210,33,0,0,145,62,2,0,26,34,0,0,151,62,2,0,42,35,0,0,156,62,2,0,187,0,0,0,162,62,2,0,146,33,0,0,167,62,2,0,9,35,0,0,173,62,2,0,29,32,0,0,179,62,2,0,28,33,0,0,184,62,2,0,174,0,0,0,188,62,2,0,11,35,0,0,195,62,2,0,193,3,0,0,199,62,2,0,15,32,0,0,203,62,2,0,58,32,0,0,210,62,2,0,25,32,0,0,216,62,2,0,26,32,0,0,222,62,2,0,97,1,0,0,229,62,2,0,197,34,0,0,234,62,2,0,167,0,0,0,239,62,2,0,173,0,0,0,243,62,2,0,195,3,0,0,249,62,2,0,194,3,0,0,0,63,2,0,60,34,0,0,4,63,2,0,96,38,0,0,11,63,2,0,130,34,0,0,15,63,2,0,134,34,0,0,20,63,2,0,17,34,0,0,24,63,2,0,131,34,0,0,28,63,2,0,185,0,0,0,33,63,2,0,178,0,0,0,38,63,2,0,179,0,0,0,43,63,2,0,135,34,0,0,48,63,2,0,223,0,0,0,54,63,2,0,196,3,0,0,58,63,2,0,52,34,0,0,65,63,2,0,184,3,0,0,71,63,2,0,209,3,0,0,80,63,2,0,9,32,0,0,87,63,2,0,254,0,0,0,93,63,2,0,220,2,0,0,99,63,2,0,215,0,0,0,105,63,2,0,34,33,0,0,111,63,2,0,209,33,0,0,116,63,2,0,250,0,0,0,123,63,2,0,145,33,0,0,128,63,2,0,251,0,0,0,134,63,2,0,249,0,0,0,141,63,2,0,168,0,0,0,145,63,2,0,210,3,0,0,151,63,2,0,197,3,0,0,159,63,2,0,252,0,0,0,164,63,2,0,24,33,0,0,171,63,2,0,190,3,0,0,174,63,2,0,253,0,0,0,181,63,2,0,165,0,0,0,185,63,2,0,255,0,0,0,190,63,2,0,182,3,0,0,195,63,2,0,13,32,0,0,199,63,2,0,12,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,8,0,0,0,1,1,0,0,239,65,2,0,131,65,2,0,8,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,45,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,69,2,0,203,69,2,0,210,69,2,0,0,0,0,0,0,0,0,0,224,69,2,0,9,0,0,0,226,69,2,0,10,0,0,0,231,69,2,0,10,0,0,0,239,69,2,0,11,0,0,0,245,69,2,0,11,0,0,0,254,69,2,0,12,0,0,0,1,70,2,0,12,0,0,0,7,70,2,0,13,0,0,0,12,70,2,0,13,0,0,0,20,70,2,0,14,0,0,0,25,70,2,0,14,0,0,0,32,70,2,0,15,0,0,0,38,70,2,0,15,0,0,0,50,70,2,0,16,0,0,0,14,0,0,0,89,0,0,0,46,0,0,0,47,0,0,0,16,0,0,0,48,0,0,0,90,0,0,0,49,0,0,0,17,0,0,0,50,0,0,0,166,187,2,0,87,70,2,0,78,70,2,0,69,70,2,0,65,70,2,0,120,187,2,0,61,70,2,0,92,70,2,0,112,70,2,0,106,70,2,0,97,70,2,0,8,0,0,0,4,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,71,2,0,85,93,201,127,201,127,255,0,145,71,2,0,187,45,212,190,174,212,255,0,156,71,2,0,20,119,253,253,192,134,255,0,167,71,2,0,85,93,201,127,201,127,255,0,178,71,2,0,187,45,212,190,174,212,255,0,189,71,2,0,20,119,253,253,192,134,255,0,200,71,2,0,42,102,255,255,255,153,255,0,211,71,2,0,85,93,201,127,201,127,255,0,222,71,2,0,187,45,212,190,174,212,255,0,233,71,2,0,20,119,253,253,192,134,255,0,244,71,2,0,42,102,255,255,255,153,255,0,255,71,2,0,151,173,176,56,108,176,255,0,10,72,2,0,85,93,201,127,201,127,255,0,21,72,2,0,187,45,212,190,174,212,255,0,32,72,2,0,20,119,253,253,192,134,255,0,43,72,2,0,42,102,255,255,255,153,255,0,54,72,2,0,151,173,176,56,108,176,255,0,65,72,2,0,232,252,240,240,2,127,255,0,76,72,2,0,85,93,201,127,201,127,255,0,87,72,2,0,187,45,212,190,174,212,255,0,98,72,2,0,20,119,253,253,192,134,255,0,109,72,2,0,42,102,255,255,255,153,255,0,120,72,2,0,151,173,176,56,108,176,255,0,131,72,2,0,232,252,240,240,2,127,255,0,142,72,2,0,17,224,191,191,91,23,255,0,153,72,2,0,85,93,201,127,201,127,255,0,164,72,2,0,187,45,212,190,174,212,255,0,175,72,2,0,20,119,253,253,192,134,255,0,186,72,2,0,42,102,255,255,255,153,255,0,197,72,2,0,151,173,176,56,108,176,255,0,208,72,2,0,232,252,240,240,2,127,255,0,219,72,2,0,17,224,191,191,91,23,255,0,230,72,2,0,0,0,102,102,102,102,255,0,241,72,2,0,147,25,247,222,235,247,255,0,251,72,2,0,142,75,225,158,202,225,255,0,5,73,2,0,145,188,189,49,130,189,255,0,15,73,2,0,159,16,255,239,243,255,255,0,25,73,2,0,143,46,231,189,215,231,255,0,35,73,2,0,143,127,214,107,174,214,255,0,45,73,2,0,147,208,181,33,113,181,255,0,55,73,2,0,159,16,255,239,243,255,255,0,65,73,2,0,143,46,231,189,215,231,255,0,75,73,2,0,143,127,214,107,174,214,255,0,85,73,2,0,145,188,189,49,130,189,255,0,95,73,2,0,149,241,156,8,81,156,255,0,105,73,2,0,159,16,255,239,243,255,255,0,115,73,2,0,148,43,239,198,219,239,255,0,125,73,2,0,142,75,225,158,202,225,255,0,135,73,2,0,143,127,214,107,174,214,255,0,145,73,2,0,145,188,189,49,130,189,255,0,155,73,2,0,149,241,156,8,81,156,255,0,165,73,2,0,159,16,255,239,243,255,255,0,175,73,2,0,148,43,239,198,219,239,255,0,185,73,2,0,142,75,225,158,202,225,255,0,195,73,2,0,143,127,214,107,174,214,255,0,205,73,2,0,144,169,198,66,146,198,255,0,215,73,2,0,147,208,181,33,113,181,255,0,225,73,2,0,151,241,148,8,69,148,255,0,235,73,2,0,148,8,255,247,251,255,255,0,245,73,2,0,147,25,247,222,235,247,255,0,255,73,2,0,148,43,239,198,219,239,255,0,9,74,2,0,142,75,225,158,202,225,255,0,19,74,2,0,143,127,214,107,174,214,255,0,29,74,2,0,144,169,198,66,146,198,255,0,39,74,2,0,147,208,181,33,113,181,255,0,49,74,2,0,151,241,148,8,69,148,255,0,59,74,2,0,148,8,255,247,251,255,255,0,69,74,2,0,147,25,247,222,235,247,255,0,79,74,2,0,148,43,239,198,219,239,255,0,89,74,2,0,142,75,225,158,202,225,255,0,99,74,2,0,143,127,214,107,174,214,255,0,109,74,2,0,144,169,198,66,146,198,255,0,119,74,2,0,147,208,181,33,113,181,255,0,129,74,2,0,149,241,156,8,81,156,255,0,139,74,2,0,152,235,107,8,48,107,255,0,149,74,2,0,23,239,84,84,48,5,255,0,159,74,2,0,119,255,60,0,60,48,255,0,170,74,2,0,23,236,140,140,81,10,255,0,180,74,2,0,24,194,191,191,129,45,255,0,190,74,2,0,29,112,223,223,194,125,255,0,200,74,2,0,30,52,246,246,232,195,255,0,210,74,2,0,121,38,234,199,234,229,255,0,220,74,2,0,120,95,205,128,205,193,255,0,230,74,2,0,124,165,151,53,151,143,255,0,240,74,2,0,124,252,102,1,102,94,255,0,250,74,2,0,23,239,84,84,48,5,255,0,4,75,2,0,124,252,102,1,102,94,255,0,15,75,2,0,119,255,60,0,60,48,255,0,26,75,2,0,23,236,140,140,81,10,255,0,36,75,2,0,24,194,191,191,129,45,255,0,46,75,2,0,29,112,223,223,194,125,255,0,56,75,2,0,30,52,246,246,232,195,255,0,66,75,2,0,0,0,245,245,245,245,255,0,76,75,2,0,121,38,234,199,234,229,255,0,86,75,2,0,120,95,205,128,205,193,255,0,96,75,2,0,124,165,151,53,151,143,255,0,106,75,2,0,28,135,216,216,179,101,255,0,115,75,2,0,0,0,245,245,245,245,255,0,124,75,2,0,123,127,180,90,180,172,255,0,133,75,2,0,21,215,166,166,97,26,255,0,142,75,2,0,29,112,223,223,194,125,255,0,151,75,2,0,120,95,205,128,205,193,255,0,160,75,2,0,121,253,133,1,133,113,255,0,169,75,2,0,21,215,166,166,97,26,255,0,178,75,2,0,29,112,223,223,194,125,255,0,187,75,2,0,0,0,245,245,245,245,255,0,196,75,2,0,120,95,205,128,205,193,255,0,205,75,2,0,121,253,133,1,133,113,255,0,214,75,2,0,23,236,140,140,81,10,255,0,223,75,2,0,28,135,216,216,179,101,255,0,232,75,2,0,30,52,246,246,232,195,255,0,241,75,2,0,121,38,234,199,234,229,255,0,250,75,2,0,123,127,180,90,180,172,255,0,3,76,2,0,124,252,102,1,102,94,255,0,12,76,2,0,23,236,140,140,81,10,255,0,21,76,2,0,28,135,216,216,179,101,255,0,30,76,2,0,30,52,246,246,232,195,255,0,39,76,2,0,0,0,245,245,245,245,255,0,48,76,2,0,121,38,234,199,234,229,255,0,57,76,2,0,123,127,180,90,180,172,255,0,66,76,2,0,124,252,102,1,102,94,255,0,75,76,2,0,23,236,140,140,81,10,255,0,84,76,2,0,24,194,191,191,129,45,255,0,93,76,2,0,29,112,223,223,194,125,255,0,102,76,2,0,30,52,246,246,232,195,255,0,111,76,2,0,121,38,234,199,234,229,255,0,120,76,2,0,120,95,205,128,205,193,255,0,129,76,2,0,124,165,151,53,151,143,255,0,138,76,2,0,124,252,102,1,102,94,255,0,147,76,2,0,23,236,140,140,81,10,255,0,156,76,2,0,24,194,191,191,129,45,255,0,165,76,2,0,29,112,223,223,194,125,255,0,174,76,2,0,30,52,246,246,232,195,255,0,183,76,2,0,0,0,245,245,245,245,255,0,192,76,2,0,121,38,234,199,234,229,255,0,201,76,2,0,120,95,205,128,205,193,255,0,210,76,2,0,124,165,151,53,151,143,255,0,219,76,2,0,124,252,102,1,102,94,255,0,228,76,2,0,135,20,249,229,245,249,255,0,237,76,2,0,117,74,216,153,216,201,255,0,246,76,2,0,103,185,162,44,162,95,255,0,255,76,2,0,136,14,251,237,248,251,255,0,8,77,2,0,127,54,226,178,226,226,255,0,17,77,2,0,113,120,194,102,194,164,255,0,26,77,2,0,98,190,139,35,139,69,255,0,35,77,2,0,136,14,251,237,248,251,255,0,44,77,2,0,127,54,226,178,226,226,255,0,53,77,2,0,113,120,194,102,194,164,255,0,62,77,2,0,103,185,162,44,162,95,255,0,71,77,2,0,102,255,109,0,109,44,255,0,80,77,2,0,136,14,251,237,248,251,255,0,89,77,2,0,119,34,236,204,236,230,255,0,98,77,2,0,117,74,216,153,216,201,255,0,107,77,2,0,113,120,194,102,194,164,255,0,116,77,2,0,103,185,162,44,162,95,255,0,125,77,2,0,102,255,109,0,109,44,255,0,134,77,2,0,136,14,251,237,248,251,255,0,143,77,2,0,119,34,236,204,236,230,255,0,152,77,2,0,117,74,216,153,216,201,255,0,161,77,2,0,113,120,194,102,194,164,255,0,170,77,2,0,105,159,174,65,174,118,255,0,179,77,2,0,98,190,139,35,139,69,255,0,188,77,2,0,102,255,88,0,88,36,255,0,197,77,2,0,134,6,253,247,252,253,255,0,206,77,2,0,135,20,249,229,245,249,255,0,215,77,2,0,119,34,236,204,236,230,255,0,224,77,2,0,117,74,216,153,216,201,255,0,233,77,2,0,113,120,194,102,194,164,255,0,242,77,2,0,105,159,174,65,174,118,255,0,251,77,2,0,98,190,139,35,139,69,255,0,4,78,2,0,102,255,88,0,88,36,255,0,13,78,2,0,134,6,253,247,252,253,255,0,22,78,2,0,135,20,249,229,245,249,255,0,31,78,2,0,119,34,236,204,236,230,255,0,40,78,2,0,117,74,216,153,216,201,255,0,49,78,2,0,113,120,194,102,194,164,255,0,58,78,2,0,105,159,174,65,174,118,255,0,67,78,2,0,98,190,139,35,139,69,255,0,76,78,2,0,102,255,109,0,109,44,255,0,85,78,2,0,101,255,68,0,68,27,255,0,94,78,2,0,144,20,244,224,236,244,255,0,103,78,2,0,148,70,218,158,188,218,255,0,112,78,2,0,196,123,167,136,86,167,255,0,121,78,2,0,136,14,251,237,248,251,255,0,130,78,2,0,146,53,227,179,205,227,255,0,139,78,2,0,162,74,198,140,150,198,255,0,148,78,2,0,202,149,157,136,65,157,255,0,157,78,2,0,136,14,251,237,248,251,255,0,166,78,2,0,146,53,227,179,205,227,255,0,175,78,2,0,162,74,198,140,150,198,255,0,184,78,2,0,196,123,167,136,86,167,255,0,193,78,2,0,214,225,129,129,15,124,255,0,202,78,2,0,136,14,251,237,248,251,255,0,211,78,2,0,148,43,230,191,211,230,255,0,220,78,2,0,148,70,218,158,188,218,255,0,229,78,2,0,162,74,198,140,150,198,255,0,238,78,2,0,196,123,167,136,86,167,255,0,247,78,2,0,214,225,129,129,15,124,255,0,0,79,2,0,136,14,251,237,248,251,255,0,9,79,2,0,148,43,230,191,211,230,255,0,18,79,2,0,148,70,218,158,188,218,255,0,27,79,2,0,162,74,198,140,150,198,255,0,36,79,2,0,190,100,177,140,107,177,255,0,45,79,2,0,202,149,157,136,65,157,255,0,54,79,2,0,213,252,110,110,1,107,255,0,63,79,2,0,134,6,253,247,252,253,255,0,72,79,2,0,144,20,244,224,236,244,255,0,81,79,2,0,148,43,230,191],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+53752);allocate([211,230,255,0,90,79,2,0,148,70,218,158,188,218,255,0,99,79,2,0,162,74,198,140,150,198,255,0,108,79,2,0,190,100,177,140,107,177,255,0,117,79,2,0,202,149,157,136,65,157,255,0,126,79,2,0,213,252,110,110,1,107,255,0,135,79,2,0,134,6,253,247,252,253,255,0,144,79,2,0,144,20,244,224,236,244,255,0,153,79,2,0,148,43,230,191,211,230,255,0,162,79,2,0,148,70,218,158,188,218,255,0,171,79,2,0,162,74,198,140,150,198,255,0,180,79,2,0,190,100,177,140,107,177,255,0,189,79,2,0,202,149,157,136,65,157,255,0,198,79,2,0,214,225,129,129,15,124,255,0,207,79,2,0,213,255,77,77,0,75,255,0,216,79,2,0,114,211,158,27,158,119,255,0,226,79,2,0,18,252,217,217,95,2,255,0,236,79,2,0,173,95,179,117,112,179,255,0,246,79,2,0,114,211,158,27,158,119,255,0,0,80,2,0,18,252,217,217,95,2,255,0,10,80,2,0,173,95,179,117,112,179,255,0,20,80,2,0,233,209,231,231,41,138,255,0,30,80,2,0,114,211,158,27,158,119,255,0,40,80,2,0,18,252,217,217,95,2,255,0,50,80,2,0,173,95,179,117,112,179,255,0,60,80,2,0,233,209,231,231,41,138,255,0,70,80,2,0,62,208,166,102,166,30,255,0,80,80,2,0,114,211,158,27,158,119,255,0,90,80,2,0,18,252,217,217,95,2,255,0,100,80,2,0,173,95,179,117,112,179,255,0,110,80,2,0,233,209,231,231,41,138,255,0,120,80,2,0,62,208,166,102,166,30,255,0,130,80,2,0,31,252,230,230,171,2,255,0,140,80,2,0,114,211,158,27,158,119,255,0,150,80,2,0,18,252,217,217,95,2,255,0,160,80,2,0,173,95,179,117,112,179,255,0,170,80,2,0,233,209,231,231,41,138,255,0,180,80,2,0,62,208,166,102,166,30,255,0,190,80,2,0,31,252,230,230,171,2,255,0,200,80,2,0,27,210,166,166,118,29,255,0,210,80,2,0,114,211,158,27,158,119,255,0,220,80,2,0,18,252,217,217,95,2,255,0,230,80,2,0,173,95,179,117,112,179,255,0,240,80,2,0,233,209,231,231,41,138,255,0,250,80,2,0,62,208,166,102,166,30,255,0,4,81,2,0,31,252,230,230,171,2,255,0,14,81,2,0,27,210,166,166,118,29,255,0,24,81,2,0,0,0,102,102,102,102,255,0,34,81,2,0,76,25,243,224,243,219,255,0,43,81,2,0,95,61,221,168,221,181,255,0,52,81,2,0,140,170,202,67,162,202,255,0,61,81,2,0,65,17,249,240,249,232,255,0,70,81,2,0,87,46,228,186,228,188,255,0,79,81,2,0,123,101,204,123,204,196,255,0,88,81,2,0,141,197,190,43,140,190,255,0,97,81,2,0,65,17,249,240,249,232,255,0,106,81,2,0,87,46,228,186,228,188,255,0,115,81,2,0,123,101,204,123,204,196,255,0,124,81,2,0,140,170,202,67,162,202,255,0,133,81,2,0,145,243,172,8,104,172,255,0,142,81,2,0,65,17,249,240,249,232,255,0,151,81,2,0,77,41,235,204,235,197,255,0,160,81,2,0,95,61,221,168,221,181,255,0,169,81,2,0,123,101,204,123,204,196,255,0,178,81,2,0,140,170,202,67,162,202,255,0,187,81,2,0,145,243,172,8,104,172,255,0,196,81,2,0,65,17,249,240,249,232,255,0,205,81,2,0,77,41,235,204,235,197,255,0,214,81,2,0,95,61,221,168,221,181,255,0,223,81,2,0,123,101,204,123,204,196,255,0,232,81,2,0,137,160,211,78,179,211,255,0,241,81,2,0,141,197,190,43,140,190,255,0,250,81,2,0,147,242,158,8,88,158,255,0,3,82,2,0,60,12,252,247,252,240,255,0,12,82,2,0,76,25,243,224,243,219,255,0,21,82,2,0,77,41,235,204,235,197,255,0,30,82,2,0,95,61,221,168,221,181,255,0,39,82,2,0,123,101,204,123,204,196,255,0,48,82,2,0,137,160,211,78,179,211,255,0,57,82,2,0,141,197,190,43,140,190,255,0,66,82,2,0,147,242,158,8,88,158,255,0,75,82,2,0,60,12,252,247,252,240,255,0,84,82,2,0,76,25,243,224,243,219,255,0,93,82,2,0,77,41,235,204,235,197,255,0,102,82,2,0,95,61,221,168,221,181,255,0,111,82,2,0,123,101,204,123,204,196,255,0,120,82,2,0,137,160,211,78,179,211,255,0,129,82,2,0,141,197,190,43,140,190,255,0,138,82,2,0,145,243,172,8,104,172,255,0,147,82,2,0,150,239,129,8,64,129,255,0,156,82,2,0,74,21,245,229,245,224,255,0,167,82,2,0,80,72,217,161,217,155,255,0,178,82,2,0,98,178,163,49,163,84,255,0,189,82,2,0,73,15,248,237,248,233,255,0,200,82,2,0,78,54,228,186,228,179,255,0,211,82,2,0,86,104,196,116,196,118,255,0,222,82,2,0,98,190,139,35,139,69,255,0,233,82,2,0,73,15,248,237,248,233,255,0,244,82,2,0,78,54,228,186,228,179,255,0,255,82,2,0,86,104,196,116,196,118,255,0,10,83,2,0,98,178,163,49,163,84,255,0,21,83,2,0,102,255,109,0,109,44,255,0,32,83,2,0,73,15,248,237,248,233,255,0,43,83,2,0,77,44,233,199,233,192,255,0,54,83,2,0,80,72,217,161,217,155,255,0,65,83,2,0,86,104,196,116,196,118,255,0,76,83,2,0,98,178,163,49,163,84,255,0,87,83,2,0,102,255,109,0,109,44,255,0,98,83,2,0,73,15,248,237,248,233,255,0,109,83,2,0,77,44,233,199,233,192,255,0,120,83,2,0,80,72,217,161,217,155,255,0,131,83,2,0,86,104,196,116,196,118,255,0,142,83,2,0,96,158,171,65,171,93,255,0,153,83,2,0,98,190,139,35,139,69,255,0,164,83,2,0,108,255,90,0,90,50,255,0,175,83,2,0,72,7,252,247,252,245,255,0,186,83,2,0,74,21,245,229,245,224,255,0,197,83,2,0,77,44,233,199,233,192,255,0,208,83,2,0,80,72,217,161,217,155,255,0,219,83,2,0,86,104,196,116,196,118,255,0,230,83,2,0,96,158,171,65,171,93,255,0,241,83,2,0,98,190,139,35,139,69,255,0,252,83,2,0,108,255,90,0,90,50,255,0,7,84,2,0,72,7,252,247,252,245,255,0,18,84,2,0,74,21,245,229,245,224,255,0,29,84,2,0,77,44,233,199,233,192,255,0,40,84,2,0,80,72,217,161,217,155,255,0,51,84,2,0,86,104,196,116,196,118,255,0,62,84,2,0,96,158,171,65,171,93,255,0,73,84,2,0,98,190,139,35,139,69,255,0,84,84,2,0,102,255,109,0,109,44,255,0,95,84,2,0,101,255,68,0,68,27,255,0,106,84,2,0,0,0,240,240,240,240,255,0,116,84,2,0,0,0,189,189,189,189,255,0,126,84,2,0,0,0,99,99,99,99,255,0,136,84,2,0,0,0,247,247,247,247,255,0,146,84,2,0,0,0,204,204,204,204,255,0,156,84,2,0,0,0,150,150,150,150,255,0,166,84,2,0,0,0,82,82,82,82,255,0,176,84,2,0,0,0,247,247,247,247,255,0,186,84,2,0,0,0,204,204,204,204,255,0,196,84,2,0,0,0,150,150,150,150,255,0,206,84,2,0,0,0,99,99,99,99,255,0,216,84,2,0,0,0,37,37,37,37,255,0,226,84,2,0,0,0,247,247,247,247,255,0,236,84,2,0,0,0,217,217,217,217,255,0,246,84,2,0,0,0,189,189,189,189,255,0,0,85,2,0,0,0,150,150,150,150,255,0,10,85,2,0,0,0,99,99,99,99,255,0,20,85,2,0,0,0,37,37,37,37,255,0,30,85,2,0,0,0,247,247,247,247,255,0,40,85,2,0,0,0,217,217,217,217,255,0,50,85,2,0,0,0,189,189,189,189,255,0,60,85,2,0,0,0,150,150,150,150,255,0,70,85,2,0,0,0,115,115,115,115,255,0,80,85,2,0,0,0,82,82,82,82,255,0,90,85,2,0,0,0,37,37,37,37,255,0,100,85,2,0,0,0,255,255,255,255,255,0,110,85,2,0,0,0,240,240,240,240,255,0,120,85,2,0,0,0,217,217,217,217,255,0,130,85,2,0,0,0,189,189,189,189,255,0,140,85,2,0,0,0,150,150,150,150,255,0,150,85,2,0,0,0,115,115,115,115,255,0,160,85,2,0,0,0,82,82,82,82,255,0,170,85,2,0,0,0,37,37,37,37,255,0,180,85,2,0,0,0,255,255,255,255,255,0,190,85,2,0,0,0,240,240,240,240,255,0,200,85,2,0,0,0,217,217,217,217,255,0,210,85,2,0,0,0,189,189,189,189,255,0,220,85,2,0,0,0,150,150,150,150,255,0,230,85,2,0,0,0,115,115,115,115,255,0,240,85,2,0,0,0,82,82,82,82,255,0,250,85,2,0,0,0,37,37,37,37,255,0,4,86,2,0,0,0,0,0,0,0,255,0,14,86,2,0,21,48,254,254,230,206,255,0,26,86,2,0,19,147,253,253,174,107,255,0,38,86,2,0,14,240,230,230,85,13,255,0,50,86,2,0,19,32,254,254,237,222,255,0,62,86,2,0,20,120,253,253,190,133,255,0,74,86,2,0,17,194,253,253,141,60,255,0,86,86,2,0,13,253,217,217,71,1,255,0,98,86,2,0,19,32,254,254,237,222,255,0,110,86,2,0,20,120,253,253,190,133,255,0,122,86,2,0,17,194,253,253,141,60,255,0,134,86,2,0,14,240,230,230,85,13,255,0,146,86,2,0,13,250,166,166,54,3,255,0,158,86,2,0,19,32,254,254,237,222,255,0,170,86,2,0,21,91,253,253,208,162,255,0,182,86,2,0,19,147,253,253,174,107,255,0,194,86,2,0,17,194,253,253,141,60,255,0,206,86,2,0,14,240,230,230,85,13,255,0,218,86,2,0,13,250,166,166,54,3,255,0,230,86,2,0,19,32,254,254,237,222,255,0,242,86,2,0,21,91,253,253,208,162,255,0,254,86,2,0,19,147,253,253,174,107,255,0,10,87,2,0,17,194,253,253,141,60,255,0,22,87,2,0,16,234,241,241,105,19,255,0,34,87,2,0,13,253,217,217,72,1,255,0,46,87,2,0,12,247,140,140,45,4,255,0,58,87,2,0,21,20,255,255,245,235,255,0,70,87,2,0,21,48,254,254,230,206,255,0,82,87,2,0,21,91,253,253,208,162,255,0,94,87,2,0,19,147,253,253,174,107,255,0,106,87,2,0,17,194,253,253,141,60,255,0,118,87,2,0,16,234,241,241,105,19,255,0,130,87,2,0,13,253,217,217,72,1,255,0,142,87,2,0,12,247,140,140,45,4,255,0,154,87,2,0,21,20,255,255,245,235,255,0,166,87,2,0,21,48,254,254,230,206,255,0,178,87,2,0,21,91,253,253,208,162,255,0,190,87,2,0,19,147,253,253,174,107,255,0,202,87,2,0,17,194,253,253,141,60,255,0,214,87,2,0,16,234,241,241,105,19,255,0,226,87,2,0,13,253,217,217,72,1,255,0,238,87,2,0,13,250,166,166,54,3,255,0,250,87,2,0,12,246,127,127,39,4,255,0,6,88,2,0,25,54,254,254,232,200,255,0,15,88,2,0,19,121,253,253,187,132,255,0,24,88,2,0,5,197,227,227,74,51,255,0,33,88,2,0,26,37,254,254,240,217,255,0,42,88,2,0,24,115,253,253,204,138,255,0,51,88,2,0,13,164,252,252,141,89,255,0,60,88,2,0,3,218,215,215,48,31,255,0,69,88,2,0,26,37,254,254,240,217,255,0,78,88,2,0,24,115,253,253,204,138,255,0,87,88,2,0,13,164,252,252,141,89,255,0,96,88,2,0,5,197,227,227,74,51,255,0,105,88,2,0,0,255,179,179,0,0,255,0,114,88,2,0,26,37,254,254,240,217,255,0,123,88,2,0,24,95,253,253,212,158,255,0,132,88,2,0,19,121,253,253,187,132,255,0,141,88,2,0,13,164,252,252,141,89,255,0,150,88,2,0,5,197,227,227,74,51,255,0,159,88,2,0,0,255,179,179,0,0,255,0,168,88,2,0,26,37,254,254,240,217,255,0,177,88,2,0,24,95,253,253,212,158,255,0,186,88,2,0,19,121,253,253,187,132,255,0,195,88,2,0,13,164,252,252,141,89,255,0,204,88,2,0,7,178,239,239,101,72,255,0,213,88,2,0,3,218,215,215,48,31,255,0,222,88,2,0,0,255,153,153,0,0,255,0,231,88,2,0,24,18,255,255,247,236,255,0,240,88,2,0,25,54,254,254,232,200,255,0,249,88,2,0,24,95,253,253,212,158,255,0,2,89,2,0,19,121,253,253,187,132,255,0,11,89,2,0,13,164,252,252,141,89,255,0,20,89,2,0,7,178,239,239,101,72,255,0,29,89,2,0,3,218,215,215,48,31,255,0,38,89,2,0,0,255,153,153,0,0,255,0,47,89,2,0,24,18,255,255,247,236,255,0,56,89,2,0,25,54,254,254,232,200,255,0,65,89,2,0,24,95,253,253,212,158,255,0,74,89,2,0,19,121,253,253,187,132,255,0,83,89,2,0,13,164,252,252,141,89,255,0,92,89,2,0,7,178,239,239,101,72,255,0,101,89,2,0,3,218,215,215,48,31,255,0,110,89,2,0,0,255,179,179,0,0,255,0,119,89,2,0,0,255,127,127,0,0,255,0,128,89,2,0,142,68,227,166,206,227,255,0,140,89,2,0,190,153,154,106,61,154,255,0,153,89,2,0,144,211,180,31,120,180,255,0,165,89,2,0,65,97,223,178,223,138,255,0,177,89,2,0,82,184,160,51,160,44,255,0,189,89,2,0,0,99,251,251,154,153,255,0,201,89,2,0,254,225,227,227,26,28,255,0,213,89,2,0,23,143,253,253,191,111,255,0,225,89,2,0,21,255,255,255,127,0,255,0,237,89,2,0,198,42,214,202,178,214,255,0,249,89,2,0,142,68,227,166,206,227,255,0,5,90,2,0,190,153,154,106,61,154,255,0,18,90,2,0,42,102,255,255,255,153,255,0,31,90,2,0,144,211,180,31,120,180,255,0,43,90,2,0,65,97,223,178,223,138,255,0,55,90,2,0,82,184,160,51,160,44,255,0,67,90,2,0,0,99,251,251,154,153,255,0,79,90,2,0,254,225,227,227,26,28,255,0,91,90,2,0,23,143,253,253,191,111,255,0,103,90,2,0,21,255,255,255,127,0,255,0,115,90,2,0,198,42,214,202,178,214,255,0,127,90,2,0,142,68,227,166,206,227,255,0,139,90,2,0,190,153,154,106,61,154,255,0,152,90,2,0,42,102,255,255,255,153,255,0,165,90,2,0,15,197,177,177,89,40,255,0,178,90,2,0,144,211,180,31,120,180,255,0,190,90,2,0,65,97,223,178,223,138,255,0,202,90,2,0,82,184,160,51,160,44,255,0,214,90,2,0,0,99,251,251,154,153,255,0,226,90,2,0,254,225,227,227,26,28,255,0,238,90,2,0,23,143,253,253,191,111,255,0,250,90,2,0,21,255,255,255,127,0,255,0,6,91,2,0,198,42,214,202,178,214,255,0,18,91,2,0,142,68,227,166,206,227,255,0,29,91,2,0,144,211,180,31,120,180,255,0,40,91,2,0,65,97,223,178,223,138,255,0,51,91,2,0,142,68,227,166,206,227,255,0,62,91,2,0,144,211,180,31,120,180,255,0,73,91,2,0,65,97,223,178,223,138,255,0,84,91,2,0,82,184,160,51,160,44,255,0,95,91,2,0,142,68,227,166,206,227,255,0,106,91,2,0,144,211,180,31,120,180,255,0,117,91,2,0,65,97,223,178,223,138,255,0,128,91,2,0,82,184,160,51,160,44,255,0,139,91,2,0,0,99,251,251,154,153,255,0,150,91,2,0,142,68,227,166,206,227,255,0,161,91,2,0,144,211,180,31,120,180,255,0,172,91,2,0,65,97,223,178,223,138,255,0,183,91,2,0,82,184,160,51,160,44,255,0,194,91,2,0,0,99,251,251,154,153,255,0,205,91,2,0,254,225,227,227,26,28,255,0,216,91,2,0,142,68,227,166,206,227,255,0,227,91,2,0,144,211,180,31,120,180,255,0,238,91,2,0,65,97,223,178,223,138,255,0,249,91,2,0,82,184,160,51,160,44,255,0,4,92,2,0,0,99,251,251,154,153,255,0,15,92,2,0,254,225,227,227,26,28,255,0,26,92,2,0,23,143,253,253,191,111,255,0,37,92,2,0,142,68,227,166,206,227,255,0,48,92,2,0,144,211,180,31,120,180,255,0,59,92,2,0,65,97,223,178,223,138,255,0,70,92,2,0,82,184,160,51,160,44,255,0,81,92,2,0,0,99,251,251,154,153,255,0,92,92,2,0,254,225,227,227,26,28,255,0,103,92,2,0,23,143,253,253,191,111,255,0,114,92,2,0,21,255,255,255,127,0,255,0,125,92,2,0,142,68,227,166,206,227,255,0,136,92,2,0,144,211,180,31,120,180,255,0,147,92,2,0,65,97,223,178,223,138,255,0,158,92,2,0,82,184,160,51,160,44,255,0,169,92,2,0,0,99,251,251,154,153,255,0,180,92,2,0,254,225,227,227,26,28,255,0,191,92,2,0,23,143,253,253,191,111,255,0,202,92,2,0,21,255,255,255,127,0,255,0,213,92,2,0,198,42,214,202,178,214,255,0,224,92,2,0,3,78,251,251,180,174,255,0,236,92,2,0,146,53,227,179,205,227,255,0,248,92,2,0,77,41,235,204,235,197,255,0,4,93,2,0,3,78,251,251,180,174,255,0,16,93,2,0,146,53,227,179,205,227,255,0,28,93,2,0,77,41,235,204,235,197,255,0,40,93,2,0,202,27,228,222,203,228,255,0,52,93,2,0,3,78,251,251,180,174,255,0,64,93,2,0,146,53,227,179,205,227,255,0,76,93,2,0,77,41,235,204,235,197,255,0,88,93,2,0,202,27,228,222,203,228,255,0,100,93,2,0,24,88,254,254,217,166,255,0,112,93,2,0,3,78,251,251,180,174,255,0,124,93,2,0,146,53,227,179,205,227,255,0,136,93,2,0,77,41,235,204,235,197,255,0,148,93,2,0,202,27,228,222,203,228,255,0,160,93,2,0,24,88,254,254,217,166,255,0,172,93,2,0,42,50,255,255,255,204,255,0,184,93,2,0,3,78,251,251,180,174,255,0,196,93,2,0,146,53,227,179,205,227,255,0,208,93,2,0,77,41,235,204,235,197,255,0,220,93,2,0,202,27,228,222,203,228,255,0,232,93,2,0,24,88,254,254,217,166,255,0,244,93,2,0,42,50,255,255,255,204,255,0,0,94,2,0,28,44,229,229,216,189,255,0,12,94,2,0,3,78,251,251,180,174,255,0,24,94,2,0,146,53,227,179,205,227,255,0,36,94,2,0,77,41,235,204,235,197,255,0,48,94,2,0,202,27,228,222,203,228,255,0,60,94,2,0,24,88,254,254,217,166,255,0,72,94,2,0,42,50,255,255,255,204,255,0,84,94,2,0,28,44,229,229,216,189,255,0,96,94,2,0,233,35,253,253,218,236,255,0,108,94,2,0,3,78,251,251,180,174,255,0,120,94,2,0,146,53,227,179,205,227,255,0,132,94,2,0,77,41,235,204,235,197,255,0,144,94,2,0,202,27,228,222,203,228,255,0,156,94,2,0,24,88,254,254,217,166,255,0,168,94,2,0,42,50,255,255,255,204,255,0,180,94,2,0,28,44,229,229,216,189,255,0,192,94,2,0,233,35,253,253,218,236,255,0,204,94,2,0,0,0,242,242,242,242,255,0,216,94,2,0,108,53,226,179,226,205,255,0,228,94,2,0,17,81,253,253,205,172,255,0,240,94,2,0,155,31,232,203,213,232,255,0,252,94,2,0,108,53,226,179,226,205,255,0,8,95,2,0,17,81,253,253,205,172,255,0,20,95,2,0,155,31,232,203,213,232,255,0,32,95,2,0,228,43,244,244,202,228,255,0,44,95,2,0,108,53,226,179,226,205,255,0,56,95,2,0,17,81,253,253,205,172,255,0,68,95,2,0,155,31,232,203,213,232,255,0,80,95,2,0,228,43,244,244,202,228,255,0,92,95,2,0,56,45,245,230,245,201,255,0,104,95,2,0,108,53,226,179,226,205,255,0,116,95,2,0,17,81,253,253,205,172,255,0,128,95,2,0,155,31,232,203,213,232,255,0,140,95,2,0,228,43,244,244,202,228,255,0,152,95,2,0,56,45,245,230,245,201,255,0,164,95,2,0,35,81,255,255,242,174,255,0,176,95,2,0,108,53,226,179,226,205,255,0,188,95,2,0,17,81,253,253,205,172,255,0,200,95,2,0,155,31,232,203,213,232,255,0,212,95,2,0,228,43,244,244,202,228,255,0,224,95,2,0,56,45,245,230,245,201,255,0,236,95,2,0,35,81,255,255,242,174,255,0,248,95,2,0,25,39,241,241,226,204,255,0,4,96,2,0,108,53,226,179,226,205,255,0,16,96,2,0,17,81,253,253,205,172,255,0,28,96,2,0,155,31,232,203,213,232,255,0,40,96,2,0,228,43,244,244,202,228,255,0,52,96,2,0,56,45,245,230,245,201,255,0,64,96,2,0,35,81,255,255,242,174,255,0,76,96,2,0,25,39,241,241,226,204,255,0,88,96,2,0,0,0,204,204,204,204,255,0,100,96,2,0,230,253,142,142,1,82,255,0,110,96,2,0,77,191,100,39,100,25,255,0,121,96,2,0,230,220,197,197,27,125,255,0,131,96,2,0,232,118,222,222,119,174,255,0,141,96,2,0,229,62,241,241,182,218,255,0,151,96,2,0,233,29,253,253,224,239,255,0,161,96,2,0,59,38,245,230,245,208,255,0,171,96,2,0,61,103,225,184,225,134,255,0,181,96,2,0,63,166,188,127,188,65,255,0,191,96,2,0,68,197,146,77,146,33,255,0,201,96,2,0,230,253,142,142,1,82,255,0,211,96,2,0,68,197,146,77,146,33,255,0,222,96,2,0,77,191,100,39,100,25,255,0,233,96,2,0,230,220,197,197,27,125,255,0,243,96,2,0,232,118,222,222,119,174,255,0,253,96,2,0,229,62,241,241,182,218,255,0,7,97,2,0,233,29,253,253,224,239,255,0,17,97,2,0,0,0,247,247,247,247,255,0,27,97,2,0,59,38,245,230,245,208,255,0,37,97,2,0,61,103,225,184,225,134,255,0,47,97,2,0,63,166,188,127,188,65,255,0,57,97,2,0,231,76,233,233,163,201,255,0,66,97,2,0,0,0,247,247,247,247,255,0,75,97,2,0,63,129,215,161,215,106,255,0,84,97,2,0,228,220,208,208,28,139,255,0,93,97,2,0,229,62,241,241,182,218,255,0,102,97,2,0,61,103,225,184,225,134,255,0,111,97,2,0,72,198,172,77,172,38,255,0,120,97,2,0,228,220,208,208,28,139,255,0,129,97,2,0,229,62,241,241,182,218,255,0,138,97,2,0,0,0,247,247,247,247,255,0,147,97,2,0,61,103,225,184,225,134,255,0,156,97,2,0,72,198,172,77,172,38,255,0,165,97,2,0,230,220,197,197,27,125,255,0,174,97,2,0,231,76,233,233,163,201,255,0,183,97,2,0,233,29,253,253,224,239,255,0,192,97,2,0,59,38,245,230,245,208,255,0,201,97,2,0,63,129,215,161,215,106,255,0,210,97,2,0,68,197,146,77,146,33,255,0,219,97,2,0,230,220,197,197,27,125,255,0,228,97,2,0,231,76,233,233,163,201,255,0,237,97,2,0,233,29,253,253,224,239,255,0,246,97,2,0,0,0,247,247,247,247,255,0,255,97,2,0,59,38,245,230,245,208,255,0,8,98,2,0,63,129,215,161,215,106,255,0,17,98,2,0,68,197,146,77,146,33,255,0,26,98,2,0,230,220,197,197,27,125,255,0,35,98,2,0,232,118,222,222,119,174,255,0,44,98,2,0,229,62,241,241,182,218,255,0,53,98,2,0,233,29,253,253,224,239,255,0,62,98,2,0,59,38,245,230,245,208,255,0,71,98,2,0,61,103,225,184,225,134,255,0,80,98,2,0,63,166,188,127,188,65,255,0,89,98,2,0,68,197,146,77,146,33,255,0,98,98,2,0,230,220,197,197,27,125,255,0,107,98,2,0,232,118,222,222,119,174,255,0,116,98,2,0,229,62,241,241,182,218,255,0,125,98,2,0,233,29,253,253,224,239,255,0,134,98,2,0,0,0,247,247,247,247,255,0,143,98,2,0,59,38,245,230,245,208,255,0,152,98,2,0,61,103,225,184,225,134,255,0,161,98,2,0,63,166,188,127,188,65,255,0,170,98,2,0,68,197,146,77,146,33,255,0,179,98,2,0,206,255,75,64,0,75,255,0,189,98,2,0,101,255,68,0,68,27,255,0,200,98,2,0,206,173,131,118,42,131,255,0,210,98,2,0,199,87,171,153,112,171,255,0,220,98,2,0,199,51,207,194,165,207,255,0,230,98,2,0,210,21,232,231,212,232,255,0,240,98,2,0,76,30,240,217,240,211,255,0,250,98,2,0,80,68,219,166,219,160,255,0,4,99,2,0,88,123,174,90,174,97,255,0,14,99,2,0,97,197,120,27,120,55,255,0,24,99,2,0,206,255,75,64,0,75,255,0,34,99,2,0,97,197,120,27,120,55,255,0,45,99,2,0,101,255,68,0,68,27,255,0,56,99,2,0,206,173,131,118,42,131,255,0,66,99,2,0,199,87,171,153,112,171,255,0,76,99,2,0,199,51,207,194,165,207,255,0,86,99,2,0,210,21,232,231,212,232,255,0,96,99,2,0,0,0,247,247,247,247,255,0,106,99,2,0,76,30,240,217,240,211,255,0,116,99,2,0,80,68,219,166,219,160,255,0,126,99,2,0,88,123,174,90,174,97,255,0,136,99,2,0,196,70,195,175,141,195,255,0,145,99,2,0,0,0,247,247,247,247,255,0,154,99,2,0,82,90,191,127,191,123,255,0,163,99,2,0,201,168,148,123,50,148,255,0,172,99,2,0,199,51,207,194,165,207,255,0,181,99,2,0,80,68,219,166,219,160,255,0,190,99,2,0,102,255,136,0,136,55,255,0,199,99,2,0,201,168,148,123,50,148,255,0,208,99,2,0,199,51,207,194,165,207,255,0,217,99,2,0,0,0,247,247,247,247,255,0,226,99,2,0,80,68,219,166,219,160,255,0,235,99,2,0,102,255,136,0,136,55,255,0,244,99,2,0,206,173,131,118,42,131,255,0,253,99,2,0,196,70,195,175,141,195,255,0,6,100,2,0,210,21,232,231,212,232,255,0,15,100,2,0,76,30,240,217,240,211,255,0,24,100,2,0,82,90,191,127,191,123,255,0,33,100,2,0,97,197,120,27,120,55,255,0,42,100,2,0,206,173,131,118,42,131,255,0,51,100,2,0,196,70,195,175,141,195,255,0,60,100,2,0,210,21,232,231,212,232,255,0,69,100,2,0,0,0,247,247,247,247,255,0,78,100,2,0,76,30,240,217,240,211,255,0,87,100,2,0,82,90,191,127,191,123,255,0,96,100,2,0,97,197,120,27,120,55,255,0,105,100,2,0,206,173,131,118,42,131,255,0,114,100,2,0,199,87,171,153,112,171,255,0,123,100,2,0,199,51,207,194,165,207,255,0,132,100,2,0,210,21,232,231,212,232,255,0,141,100,2,0,76,30,240,217,240,211,255,0,150,100,2,0,80,68,219,166,219,160,255,0,159,100,2,0,88,123,174,90,174,97,255,0,168,100,2,0,97,197,120,27,120,55,255,0,177,100,2,0,206,173,131,118,42,131,255,0,186,100,2,0,199,87,171,153,112,171,255,0,195,100,2,0,199,51,207,194,165,207,255,0,204,100,2,0,210,21,232,231,212,232,255,0,213,100,2,0,0,0,247,247,247,247,255,0,222,100,2,0,76,30,240,217,240,211,255,0,231,100,2,0,80,68,219,166,219,160,255,0,240,100,2,0,88,123,174,90,174,97,255,0,249,100,2,0,97,197,120,27,120,55,255,0,2,101,2,0,189,11,242,236,231,242,255,0,11,101,2,0,151,61,219,166,189,219,255,0,20,101,2,0,141,197,190,43,140,190,255,0,29,101,2,0,185,8,246,241,238,246,255,0,38,101,2,0,155,40,225,189,201,225,255,0,47,101,2,0,145,112,207,116,169,207,255,0,56,101,2,0,143,247,176,5,112,176,255,0,65,101,2,0,185,8,246,241,238,246,255,0,74,101,2,0,155,40,225,189,201,225,255,0,83,101,2,0,145,112,207,116,169,207,255,0,92,101,2,0,141,197,190,43,140,190,255,0,101,101,2,0,143,247,141,4,90,141,255,0,110,101,2,0,185,8,246,241,238,246,255,0,119,101,2,0,168,24,230,208,209,230,255,0,128,101,2,0,151,61,219,166,189,219,255,0,137,101,2,0,145,112,207,116,169,207,255,0,146,101,2,0,141,197,190,43,140,190,255,0,155,101,2,0,143,247,141,4,90,141,255,0,164,101,2,0,185,8,246,241,238,246,255,0,173,101,2,0,168,24,230,208,209,230,255,0,182,101,2,0,151,61,219,166,189,219,255,0,191,101,2,0,145,112,207,116,169,207,255,0,200,101,2,0,142,183,192,54,144,192,255,0,209,101,2,0,143,247,176,5,112,176,255,0,218,101,2,0,143,248,123,3,78,123,255,0,227,101,2,0,233,8,255,255,247,251,255,0,236,101,2,0,189,11,242,236,231,242,255,0,245,101,2,0,168,24,230,208,209,230,255,0,254,101,2,0,151,61,219,166,189,219,255,0,7,102,2,0,145,112,207,116,169,207,255,0,16,102,2,0,142,183,192,54,144,192,255,0,25,102,2,0,143,247,176,5,112,176,255,0,34,102,2,0,143,248,123,3,78,123,255,0,43,102,2,0,233,8,255,255,247,251,255,0,52,102,2,0,189,11,242,236,231,242,255,0,61,102,2,0,168,24,230,208,209,230,255,0,70,102,2,0,151,61,219,166,189,219,255,0,79,102,2,0,145,112,207,116,169,207,255,0,88,102,2,0,142,183,192,54,144,192,255,0,97,102,2,0,143,247,176,5,112,176,255,0,106,102,2,0,143,247,141,4,90,141,255,0,115,102,2,0,143,249,88,2,56,88,255,0,124,102,2,0,200,14,240,236,226,240,255,0,135,102,2,0,151,61,219,166,189,219,255,0,146,102,2,0,130,208,153,28,144,153,255,0,157,102,2,0,207,8,247,246,239,247,255,0,168,102,2,0,155,40,225,189,201,225,255,0,179,102,2,0,143,128,207,103,169,207,255,0,190,102,2,0,130,251,138,2,129,138,255,0,201,102,2,0,207,8,247,246,239,247,255,0,212,102,2,0,155,40,225,189,201,225,255,0,223,102,2,0,143,128,207,103,169,207,255,0,234,102,2,0,130,208,153,28,144,153,255,0,245,102,2,0,119,252,108,1,108,89,255,0,0,103,2,0,207,8,247,246,239,247,255,0,11,103,2,0,168,24,230,208,209,230,255,0,22,103,2,0,151,61,219,166,189,219,255,0,33,103,2,0,143,128,207,103,169,207,255,0,44,103,2,0,130,208,153,28,144,153,255,0,55,103,2,0,119,252,108,1,108,89,255,0,66,103,2,0,207,8,247,246,239,247,255,0,77,103,2,0,168,24,230,208,209,230,255,0,88,103,2,0,151,61,219,166,189,219,255,0,99,103,2,0,143,128,207,103,169,207,255,0,110,103,2,0,142,183,192,54,144,192,255,0,121,103,2,0,130,251,138,2,129,138,255,0,132,103,2,0,118,252,100,1,100,80,255,0,143,103,2,0,233,8,255,255,247,251,255,0,154,103,2,0,200,14,240,236,226,240,255,0,165,103,2,0,168,24,230,208,209,230,255,0,176,103,2,0,151,61,219,166,189,219,255,0,187,103,2,0,143,128,207,103,169,207,255,0,198,103,2,0,142,183,192,54,144,192,255,0,209,103,2,0,130,251,138,2,129,138,255,0,220,103,2,0,118,252,100,1,100,80,255,0,231,103,2,0,233,8,255,255,247,251,255,0,242,103,2,0,200,14,240,236,226,240,255,0,253,103,2,0,168,24,230,208,209,230,255,0,8,104,2,0,151,61,219,166,189,219,255,0,19,104,2,0,143,128,207,103,169,207,255,0,30,104,2,0,142,183,192,54,144,192,255,0,41,104,2,0,130,251,138,2,129,138,255,0,52,104,2,0,119,252,108,1,108,89,255,0,63,104,2,0,117,251,70,1,70,54,255,0,74,104,2,0,18,238,127,127,59,8,255,0,84,104,2,0,195,255,75,45,0,75,255,0,95,104,2,0,20,246,179,179,88,6,255,0,105,104,2,0,22,232,224,224,130,20,255,0,115,104,2,0,23,155,253,253,184,99,255,0,125,104,2,0,24,72,254,254,224,182,255,0,135,104,2,0,165,20,235,216,218,235,255,0,145,104,2,0,177,47,210,178,171,210,255,0,155,104,2,0,179,84,172,128,115,172,255,0,165,104,2,0,189,181,136,84,39,136,255,0,175,104,2,0,18,238,127,127,59,8,255,0,185,104,2,0,189,181,136,84,39,136,255,0,196,104,2,0,195,255,75,45,0,75,255,0,207,104,2,0,20,246,179,179,88,6,255,0,217,104,2,0,22,232,224,224,130,20,255,0,227,104,2,0,23,155,253,253,184,99,255,0,237,104,2,0,24,72,254,254,224,182,255,0,247,104,2,0,0,0,247,247,247,247,255,0,1,105,2,0,165,20,235,216,218,235,255,0,11,105,2,0,177,47,210,178,171,210,255,0,21,105,2,0,179,84,172,128,115,172,255,0,31,105,2,0,23,187,241,241,163,64,255,0,40,105,2,0,0,0,247,247,247,247,255,0,49,105,2,0,178,69,195,153,142,195,255,0,58,105,2,0,17,253,230,230,97,1,255,0,67,105,2,0,23,155,253,253,184,99,255,0,76,105,2,0,177,47,210,178,171,210,255,0,85,105,2,0,185,155,153,94,60,153,255,0,94,105,2,0,17,253,230,230,97,1,255,0,103,105,2,0,23,155,253,253,184,99,255,0,112,105,2,0,0,0,247,247,247,247,255,0,121,105,2,0,177,47,210,178,171,210,255,0,130,105,2,0,185,155,153,94,60,153,255,0,139,105,2,0,20,246,179,179,88,6,255,0,148,105,2,0,23,187,241,241,163,64,255,0,157,105,2,0,24,72,254,254,224,182,255,0,166,105,2,0,165,20,235,216,218,235,255,0,175,105,2,0,178,69,195,153,142,195,255,0,184,105,2,0,189,181,136,84,39,136,255,0,193,105,2,0,20,246,179,179,88,6,255,0,202,105,2,0,23,187,241,241,163,64,255,0,211,105,2,0,24,72,254,254,224,182,255,0,220,105,2,0,0,0,247,247,247,247,255,0,229,105,2,0,165,20,235,216,218,235,255,0,238,105,2,0,178,69,195,153,142,195,255,0,247,105,2,0,189,181,136,84,39,136,255,0,0,106,2,0,20,246,179,179,88,6,255,0,9,106,2,0,22,232,224,224,130,20,255,0,18,106,2,0,23,155,253,253,184,99,255,0,27,106,2,0,24,72,254,254,224,182,255,0,36,106,2,0,165,20,235,216,218,235,255,0,45,106,2,0,177,47,210,178,171,210,255,0,54,106,2,0,179,84,172,128,115,172,255,0,63,106,2,0,189,181,136,84,39,136,255,0,72,106,2,0,20,246,179,179,88,6,255,0,81,106,2,0,22,232,224,224,130,20,255,0,90,106,2,0,23,155,253,253,184,99,255,0,99,106,2,0,24,72,254,254,224,182,255,0,108,106,2,0,0,0,247,247,247,247,255,0,117,106,2,0,165,20,235,216,218,235,255,0,126,106,2,0,177,47,210,178,171,210,255,0,135,106,2,0,179,84,172,128,115,172,255,0,144,106,2,0,189,181,136,84,39,136,255,0,153,106,2,0,188,14,239,231,225,239,255,0,162,106,2,0,214,67,201,201,148,199,255,0,171,106,2,0,234,222,221,221,28,119,255,0,180,106,2,0,185,8,246,241,238,246,255,0,189,106,2,0,211,41,216,215,181,216,255,0,198,106,2,0,228,139,223,223,101,176,255,0,207,106,2,0,239,232,206,206,18,86,255,0,216,106,2,0,185,8,246,241,238,246,255,0,225,106,2,0,211,41,216,215,181,216,255,0,234,106,2,0,228,139,223,223,101,176,255,0,243,106,2,0,234,222,221,221,28,119,255,0,252,106,2,0,236,255,152,152,0,67,255,0,5,107,2,0,185,8,246,241,238,246,255,0,14,107,2,0,204,38,218,212,185,218,255,0,23,107,2,0,214,67,201,201,148,199,255,0,32,107,2,0,228,139,223,223,101,176,255,0,41,107,2,0,234,222,221,221,28,119,255,0,50,107,2,0,236,255,152,152,0,67,255,0,59,107,2,0,185,8,246,241,238,246,255,0,68,107,2,0,204,38,218,212,185,218,255,0,77,107,2,0,214,67,201,201,148,199,255,0,86,107,2,0,228,139,223,223,101,176,255,0,95,107,2,0,233,209,231,231,41,138,255,0,104,107,2,0,239,232,206,206,18,86,255,0,113,107,2,0,236,255,145,145,0,63,255,0,122,107,2,0,195,5,249,247,244,249,255,0,131,107,2,0,188,14,239,231,225,239,255,0,140,107,2,0,204,38,218,212,185,218,255,0,149,107,2,0,214,67,201,201,148,199,255,0,158,107,2,0,228,139,223,223,101,176,255,0,167,107,2,0,233,209,231,231,41,138,255,0,176,107,2,0,239,232,206,206,18,86,255,0,185,107,2,0,236,255,145,145,0,63,255,0,194,107,2,0,195,5,249,247,244,249,255,0,203,107,2,0,188,14,239,231,225,239,255,0,212,107,2,0,204,38,218,212,185,218,255,0,221,107,2,0,214,67,201,201,148,199,255,0,230,107,2,0,228,139,223,223,101,176,255,0,239,107,2,0,233,209,231,231,41,138,255,0,248,107,2,0,239,232,206,206,18,86,255,0,1,108,2,0,236,255,152,152,0,67,255,0,10,108,2,0,242,255,103,103,0,31,255,0,19,108,2,0,180,8,245,239,237,245,255,0,31,108,2,0,168,37,220,188,189,220,255,0,43,108,2,0,176,100,177,117,107,177,255,0,55,108,2,0,182,7,247,242,240,247,255,0,67,108,2,0,173,28,226,203,201,226,255,0,79,108,2,0,173,58,200,158,154,200,255,0,91,108,2,0,182,128,163,106,81,163,255,0,103,108,2,0,182,7,247,242,240,247,255,0,115,108,2,0,173,28,226,203,201,226,255,0,127,108,2,0,173,58,200,158,154,200,255,0,139,108,2,0,176,100,177,117,107,177,255,0,151,108,2,0,188,185,143,84,39,143,255,0,163,108,2,0,182,7,247,242,240,247,255,0,175,108,2,0,170,18,235,218,218,235,255,0,187,108,2,0,168,37,220,188,189,220,255,0,199,108,2,0,173,58,200,158,154,200,255,0,211,108,2,0,176,100,177,117,107,177,255,0,223,108,2,0,188,185,143,84,39,143,255,0,235,108,2,0,182,7,247,242,240,247,255,0,247,108,2,0,170,18,235,218,218,235,255,0,3,109,2,0,168,37,220,188,189,220,255,0,15,109,2,0,173,58,200,158,154,200,255,0,27,109,2,0,172,83,186,128,125,186,255,0,39,109,2,0,182,128,163,106,81,163,255,0,51,109,2,0,190,216,134,74,20,134,255,0,63,109,2,0,191,2,253,252,251,253,255,0,75,109,2,0,180,8,245,239,237,245,255,0,87,109,2,0,170,18,235,218,218,235,255,0,99,109,2,0,168,37,220,188,189,220,255,0,111,109,2,0,173,58,200,158,154,200,255,0,123,109,2,0,172,83,186,128,125,186,255,0,135,109,2,0,182,128,163,106,81,163,255,0,147,109,2,0,190,216,134,74,20,134,255,0,159,109,2,0,191,2,253,252,251,253,255,0,171,109,2,0,180,8,245,239,237,245,255,0,183,109,2,0,170,18,235,218,218,235,255,0,195,109,2,0,168,37,220,188,189,220,255,0,207,109,2,0,173,58,200,158,154,200,255,0,219,109,2,0,172,83,186,128,125,186,255,0,231,109,2,0,182,128,163,106,81,163,255,0,243,109,2,0,188,185,143,84,39,143,255,0,255,109,2,0,191,255,125,63,0,125,255,0,11,110,2,0,242,255,103,103,0,31,255,0,21,110,2,0,150,241,97,5,48,97,255,0,32,110,2,0,249,220,178,178,24,43,255,0,42,110,2,0,5,163,214,214,96,77,255,0,52,110,2,0,13,119,244,244,165,130,255,0,62,110,2,0,15,54,253,253,219,199,255,0,72,110,2,0,142,32,240,209,229,240,255,0,82,110,2,0,141,87,222,146,197,222,255,0,92,110,2,0,143,167,195,67,147,195,255,0,102,110,2,0,148,206,172,33,102,172,255,0,112,110,2,0,242,255,103,103,0,31,255,0,122,110,2,0,148,206,172,33,102,172,255,0,133,110,2,0,150,241,97,5,48,97,255,0,144,110,2,0,249,220,178,178,24,43,255,0,154,110,2,0,5,163,214,214,96,77,255,0,164,110,2,0,13,119,244,244,165,130,255,0,174,110,2,0,15,54,253,253,219,199,255,0,184,110,2,0,0,0,247,247,247,247,255,0,194,110,2,0,142,32,240,209,229,240,255,0,204,110,2,0,141,87,222,146,197,222,255,0,214,110,2,0,143,167,195,67,147,195,255,0,224,110,2,0,12,150,239,239,138,98,255,0,233,110,2,0,0,0,247,247,247,247,255,0,242,110,2,0,143,128,207,103,169,207,255,0,251,110,2,0,248,255,202,202,0,32,255,0,4,111,2,0,13,119,244,244,165,130,255,0,13,111,2,0,141,87,222,146,197,222,255,0,22,111,2,0,143,247,176,5,113,176,255,0,31,111,2,0,248,255,202,202,0,32,255,0,40,111,2,0,13,119,244,244,165,130,255,0,49,111,2,0,0,0,247,247,247,247,255,0,58,111,2,0,141,87,222,146,197,222,255,0,67,111,2,0,143,247,176,5,113,176,255,0,76,111,2,0,249,220,178,178,24,43,255,0,85,111,2,0,12,150,239,239,138,98,255,0,94,111,2,0,15,54,253,253,219,199,255,0,103,111,2,0,142,32,240,209,229,240,255,0,112,111,2,0,143,128,207,103,169,207,255,0,121,111,2,0,148,206,172,33,102,172,255,0,130,111,2,0,249,220,178,178,24,43,255,0,139,111,2,0,12,150,239,239,138,98,255,0,148,111,2,0,15,54,253,253,219,199,255,0,157,111,2,0,0,0,247,247,247,247,255,0,166,111,2,0,142,32,240,209,229,240,255,0,175,111,2,0,143,128,207,103,169,207,255,0,184,111,2,0,148,206,172,33,102,172,255,0,193,111,2,0,249,220,178,178,24,43,255,0,202,111,2,0,5,163,214,214,96,77,255,0,211,111,2,0,13,119,244,244,165,130,255,0,220,111,2,0,15,54,253,253,219,199,255,0,229,111,2,0,142,32,240,209,229,240,255,0,238,111,2,0,141,87,222,146,197,222,255,0,247,111,2,0,143,167,195,67,147,195,255,0,0,112,2,0,148,206,172,33,102,172,255,0,9,112,2,0,249,220,178,178,24,43,255,0,18,112,2,0,5,163,214,214,96,77,255,0,27,112,2,0,13,119,244,244,165,130,255,0,36,112,2,0,15,54,253,253,219,199,255,0,45,112,2,0,0,0,247,247,247,247,255,0,54,112,2,0,142,32,240,209,229,240,255,0,63,112,2,0,141,87,222,146,197,222,255,0,72,112,2,0,143,167,195,67,147,195,255,0,81,112,2,0,148,206,172,33,102,172,255,0,90,112,2,0,242,255,103,103,0,31,255,0,100,112,2,0,0,0,26,26,26,26,255,0,111,112,2,0,249,220,178,178,24,43,255,0,121,112,2,0,5,163,214,214,96,77,255,0,131,112,2,0,13,119,244,244,165,130,255,0,141,112,2,0,15,54,253,253,219,199,255,0,151,112,2,0,0,0,224,224,224,224,255,0,161,112,2,0,0,0,186,186,186,186,255,0,171,112,2,0,0,0,135,135,135,135,255,0,181,112,2,0,0,0,77,77,77,77,255,0,191,112,2,0,242,255,103,103,0,31,255,0,201,112,2,0,0,0,77,77,77,77,255,0,212,112,2,0,0,0,26,26,26,26,255,0,223,112,2,0,249,220,178,178,24,43,255,0,233,112,2,0,5,163,214,214,96,77,255,0,243,112,2,0,13,119,244,244,165,130,255,0,253,112,2,0,15,54,253,253,219,199,255,0,7,113,2,0,0,0,255,255,255,255,255,0,17,113,2,0,0,0,224,224,224,224,255,0,27,113,2,0,0,0,186,186,186,186,255,0,37,113,2,0,0,0,135,135,135,135,255,0,47,113,2,0,12,150,239,239,138,98,255,0,56,113,2,0,0,0,255,255,255,255,255,0,65,113,2,0,0,0,153,153,153,153,255,0,74,113,2,0,248,255,202,202,0,32,255,0,83,113,2,0,13,119,244,244,165,130,255],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+63992);allocate([92,113,2,0,0,0,186,186,186,186,255,0,101,113,2,0,0,0,64,64,64,64,255,0,110,113,2,0,248,255,202,202,0,32,255,0,119,113,2,0,13,119,244,244,165,130,255,0,128,113,2,0,0,0,255,255,255,255,255,0,137,113,2,0,0,0,186,186,186,186,255,0,146,113,2,0,0,0,64,64,64,64,255,0,155,113,2,0,249,220,178,178,24,43,255,0,164,113,2,0,12,150,239,239,138,98,255,0,173,113,2,0,15,54,253,253,219,199,255,0,182,113,2,0,0,0,224,224,224,224,255,0,191,113,2,0,0,0,153,153,153,153,255,0,200,113,2,0,0,0,77,77,77,77,255,0,209,113,2,0,249,220,178,178,24,43,255,0,218,113,2,0,12,150,239,239,138,98,255,0,227,113,2,0,15,54,253,253,219,199,255,0,236,113,2,0,0,0,255,255,255,255,255,0,245,113,2,0,0,0,224,224,224,224,255,0,254,113,2,0,0,0,153,153,153,153,255,0,7,114,2,0,0,0,77,77,77,77,255,0,16,114,2,0,249,220,178,178,24,43,255,0,25,114,2,0,5,163,214,214,96,77,255,0,34,114,2,0,13,119,244,244,165,130,255,0,43,114,2,0,15,54,253,253,219,199,255,0,52,114,2,0,0,0,224,224,224,224,255,0,61,114,2,0,0,0,186,186,186,186,255,0,70,114,2,0,0,0,135,135,135,135,255,0,79,114,2,0,0,0,77,77,77,77,255,0,88,114,2,0,249,220,178,178,24,43,255,0,97,114,2,0,5,163,214,214,96,77,255,0,106,114,2,0,13,119,244,244,165,130,255,0,115,114,2,0,15,54,253,253,219,199,255,0,124,114,2,0,0,0,255,255,255,255,255,0,133,114,2,0,0,0,224,224,224,224,255,0,142,114,2,0,0,0,186,186,186,186,255,0,151,114,2,0,0,0,135,135,135,135,255,0,160,114,2,0,0,0,77,77,77,77,255,0,169,114,2,0,3,32,253,253,224,221,255,0,178,114,2,0,244,92,250,250,159,181,255,0,187,114,2,0,227,220,197,197,27,138,255,0,196,114,2,0,13,28,254,254,235,226,255,0,205,114,2,0,252,72,251,251,180,185,255,0,214,114,2,0,238,147,247,247,104,161,255,0,223,114,2,0,224,253,174,174,1,126,255,0,232,114,2,0,13,28,254,254,235,226,255,0,241,114,2,0,252,72,251,251,180,185,255,0,250,114,2,0,238,147,247,247,104,161,255,0,3,115,2,0,227,220,197,197,27,138,255,0,12,115,2,0,213,252,122,122,1,119,255,0,21,115,2,0,13,28,254,254,235,226,255,0,30,115,2,0,3,60,252,252,197,192,255,0,39,115,2,0,244,92,250,250,159,181,255,0,48,115,2,0,238,147,247,247,104,161,255,0,57,115,2,0,227,220,197,197,27,138,255,0,66,115,2,0,213,252,122,122,1,119,255,0,75,115,2,0,13,28,254,254,235,226,255,0,84,115,2,0,3,60,252,252,197,192,255,0,93,115,2,0,244,92,250,250,159,181,255,0,102,115,2,0,238,147,247,247,104,161,255,0,111,115,2,0,230,195,221,221,52,151,255,0,120,115,2,0,224,253,174,174,1,126,255,0,129,115,2,0,213,252,122,122,1,119,255,0,138,115,2,0,14,12,255,255,247,243,255,0,147,115,2,0,3,32,253,253,224,221,255,0,156,115,2,0,3,60,252,252,197,192,255,0,165,115,2,0,244,92,250,250,159,181,255,0,174,115,2,0,238,147,247,247,104,161,255,0,183,115,2,0,230,195,221,221,52,151,255,0,192,115,2,0,224,253,174,174,1,126,255,0,201,115,2,0,213,252,122,122,1,119,255,0,210,115,2,0,14,12,255,255,247,243,255,0,219,115,2,0,3,32,253,253,224,221,255,0,228,115,2,0,3,60,252,252,197,192,255,0,237,115,2,0,244,92,250,250,159,181,255,0,246,115,2,0,238,147,247,247,104,161,255,0,255,115,2,0,230,195,221,221,52,151,255,0,8,116,2,0,224,253,174,174,1,126,255,0,17,116,2,0,213,252,122,122,1,119,255,0,26,116,2,0,199,255,106,73,0,106,255,0,35,116,2,0,245,255,165,165,0,38,255,0,47,116,2,0,167,171,149,49,54,149,255,0,60,116,2,0,2,208,215,215,48,39,255,0,72,116,2,0,10,184,244,244,109,67,255,0,84,116,2,0,20,157,253,253,174,97,255,0,96,116,2,0,30,110,254,254,224,144,255,0,108,116,2,0,136,24,248,224,243,248,255,0,120,116,2,0,138,67,233,171,217,233,255,0,132,116,2,0,143,113,209,116,173,209,255,0,144,116,2,0,151,157,180,69,117,180,255,0,156,116,2,0,245,255,165,165,0,38,255,0,168,116,2,0,151,157,180,69,117,180,255,0,181,116,2,0,167,171,149,49,54,149,255,0,194,116,2,0,2,208,215,215,48,39,255,0,206,116,2,0,10,184,244,244,109,67,255,0,218,116,2,0,20,157,253,253,174,97,255,0,230,116,2,0,30,110,254,254,224,144,255,0,242,116,2,0,42,64,255,255,255,191,255,0,254,116,2,0,136,24,248,224,243,248,255,0,10,117,2,0,138,67,233,171,217,233,255,0,22,117,2,0,143,113,209,116,173,209,255,0,34,117,2,0,13,164,252,252,141,89,255,0,45,117,2,0,42,64,255,255,255,191,255,0,56,117,2,0,143,86,219,145,191,219,255,0,67,117,2,0,254,225,215,215,25,28,255,0,78,117,2,0,20,157,253,253,174,97,255,0,89,117,2,0,138,67,233,171,217,233,255,0,100,117,2,0,145,193,182,44,123,182,255,0,111,117,2,0,254,225,215,215,25,28,255,0,122,117,2,0,20,157,253,253,174,97,255,0,133,117,2,0,42,64,255,255,255,191,255,0,144,117,2,0,138,67,233,171,217,233,255,0,155,117,2,0,145,193,182,44,123,182,255,0,166,117,2,0,2,208,215,215,48,39,255,0,177,117,2,0,13,164,252,252,141,89,255,0,188,117,2,0,30,110,254,254,224,144,255,0,199,117,2,0,136,24,248,224,243,248,255,0,210,117,2,0,143,86,219,145,191,219,255,0,221,117,2,0,151,157,180,69,117,180,255,0,232,117,2,0,2,208,215,215,48,39,255,0,243,117,2,0,13,164,252,252,141,89,255,0,254,117,2,0,30,110,254,254,224,144,255,0,9,118,2,0,42,64,255,255,255,191,255,0,20,118,2,0,136,24,248,224,243,248,255,0,31,118,2,0,143,86,219,145,191,219,255,0,42,118,2,0,151,157,180,69,117,180,255,0,53,118,2,0,2,208,215,215,48,39,255,0,64,118,2,0,10,184,244,244,109,67,255,0,75,118,2,0,20,157,253,253,174,97,255,0,86,118,2,0,30,110,254,254,224,144,255,0,97,118,2,0,136,24,248,224,243,248,255,0,108,118,2,0,138,67,233,171,217,233,255,0,119,118,2,0,143,113,209,116,173,209,255,0,130,118,2,0,151,157,180,69,117,180,255,0,141,118,2,0,2,208,215,215,48,39,255,0,152,118,2,0,10,184,244,244,109,67,255,0,163,118,2,0,20,157,253,253,174,97,255,0,174,118,2,0,30,110,254,254,224,144,255,0,185,118,2,0,42,64,255,255,255,191,255,0,196,118,2,0,136,24,248,224,243,248,255,0,207,118,2,0,138,67,233,171,217,233,255,0,218,118,2,0,143,113,209,116,173,209,255,0,229,118,2,0,151,157,180,69,117,180,255,0,240,118,2,0,245,255,165,165,0,38,255,0,252,118,2,0,107,255,104,0,104,55,255,0,9,119,2,0,2,208,215,215,48,39,255,0,21,119,2,0,10,184,244,244,109,67,255,0,33,119,2,0,20,157,253,253,174,97,255,0,45,119,2,0,31,115,254,254,224,139,255,0,57,119,2,0,51,106,239,217,239,139,255,0,69,119,2,0,62,130,217,166,217,106,255,0,81,119,2,0,83,121,189,102,189,99,255,0,93,119,2,0,103,211,152,26,152,80,255,0,105,119,2,0,245,255,165,165,0,38,255,0,117,119,2,0,103,211,152,26,152,80,255,0,130,119,2,0,107,255,104,0,104,55,255,0,143,119,2,0,2,208,215,215,48,39,255,0,155,119,2,0,10,184,244,244,109,67,255,0,167,119,2,0,20,157,253,253,174,97,255,0,179,119,2,0,31,115,254,254,224,139,255,0,191,119,2,0,42,64,255,255,255,191,255,0,203,119,2,0,51,106,239,217,239,139,255,0,215,119,2,0,62,130,217,166,217,106,255,0,227,119,2,0,83,121,189,102,189,99,255,0,239,119,2,0,13,164,252,252,141,89,255,0,250,119,2,0,42,64,255,255,255,191,255,0,5,120,2,0,66,136,207,145,207,96,255,0,16,120,2,0,254,225,215,215,25,28,255,0,27,120,2,0,20,157,253,253,174,97,255,0,38,120,2,0,62,130,217,166,217,106,255,0,49,120,2,0,98,210,150,26,150,65,255,0,60,120,2,0,254,225,215,215,25,28,255,0,71,120,2,0,20,157,253,253,174,97,255,0,82,120,2,0,42,64,255,255,255,191,255,0,93,120,2,0,62,130,217,166,217,106,255,0,104,120,2,0,98,210,150,26,150,65,255,0,115,120,2,0,2,208,215,215,48,39,255,0,126,120,2,0,13,164,252,252,141,89,255,0,137,120,2,0,31,115,254,254,224,139,255,0,148,120,2,0,51,106,239,217,239,139,255,0,159,120,2,0,66,136,207,145,207,96,255,0,170,120,2,0,103,211,152,26,152,80,255,0,181,120,2,0,2,208,215,215,48,39,255,0,192,120,2,0,13,164,252,252,141,89,255,0,203,120,2,0,31,115,254,254,224,139,255,0,214,120,2,0,42,64,255,255,255,191,255,0,225,120,2,0,51,106,239,217,239,139,255,0,236,120,2,0,66,136,207,145,207,96,255,0,247,120,2,0,103,211,152,26,152,80,255,0,2,121,2,0,2,208,215,215,48,39,255,0,13,121,2,0,10,184,244,244,109,67,255,0,24,121,2,0,20,157,253,253,174,97,255,0,35,121,2,0,31,115,254,254,224,139,255,0,46,121,2,0,51,106,239,217,239,139,255,0,57,121,2,0,62,130,217,166,217,106,255,0,68,121,2,0,83,121,189,102,189,99,255,0,79,121,2,0,103,211,152,26,152,80,255,0,90,121,2,0,2,208,215,215,48,39,255,0,101,121,2,0,10,184,244,244,109,67,255,0,112,121,2,0,20,157,253,253,174,97,255,0,123,121,2,0,31,115,254,254,224,139,255,0,134,121,2,0,42,64,255,255,255,191,255,0,145,121,2,0,51,106,239,217,239,139,255,0,156,121,2,0,62,130,217,166,217,106,255,0,167,121,2,0,83,121,189,102,189,99,255,0,178,121,2,0,103,211,152,26,152,80,255,0,189,121,2,0,13,44,254,254,224,210,255,0,198,121,2,0,9,139,252,252,146,114,255,0,207,121,2,0,1,211,222,222,45,38,255,0,216,121,2,0,13,37,254,254,229,217,255,0,225,121,2,0,11,108,252,252,174,145,255,0,234,121,2,0,7,179,251,251,106,74,255,0,243,121,2,0,253,224,203,203,24,29,255,0,252,121,2,0,13,37,254,254,229,217,255,0,5,122,2,0,11,108,252,252,174,145,255,0,14,122,2,0,7,179,251,251,106,74,255,0,23,122,2,0,1,211,222,222,45,38,255,0,32,122,2,0,253,231,165,165,15,21,255,0,41,122,2,0,13,37,254,254,229,217,255,0,50,122,2,0,12,92,252,252,187,161,255,0,59,122,2,0,9,139,252,252,146,114,255,0,68,122,2,0,7,179,251,251,106,74,255,0,77,122,2,0,1,211,222,222,45,38,255,0,86,122,2,0,253,231,165,165,15,21,255,0,95,122,2,0,13,37,254,254,229,217,255,0,104,122,2,0,12,92,252,252,187,161,255,0,113,122,2,0,9,139,252,252,146,114,255,0,122,122,2,0,7,179,251,251,106,74,255,0,131,122,2,0,3,208,239,239,59,44,255,0,140,122,2,0,253,224,203,203,24,29,255,0,149,122,2,0,251,255,153,153,0,13,255,0,158,122,2,0,14,15,255,255,245,240,255,0,167,122,2,0,13,44,254,254,224,210,255,0,176,122,2,0,12,92,252,252,187,161,255,0,185,122,2,0,9,139,252,252,146,114,255,0,194,122,2,0,7,179,251,251,106,74,255,0,203,122,2,0,3,208,239,239,59,44,255,0,212,122,2,0,253,224,203,203,24,29,255,0,221,122,2,0,251,255,153,153,0,13,255,0,230,122,2,0,14,15,255,255,245,240,255,0,239,122,2,0,13,44,254,254,224,210,255,0,248,122,2,0,12,92,252,252,187,161,255,0,1,123,2,0,9,139,252,252,146,114,255,0,10,123,2,0,7,179,251,251,106,74,255,0,19,123,2,0,3,208,239,239,59,44,255,0,28,123,2,0,253,224,203,203,24,29,255,0,37,123,2,0,253,231,165,165,15,21,255,0,46,123,2,0,249,255,103,103,0,13,255,0,55,123,2,0,254,225,228,228,26,28,255,0,64,123,2,0,146,178,184,55,126,184,255,0,73,123,2,0,83,147,175,77,175,74,255,0,82,123,2,0,254,225,228,228,26,28,255,0,91,123,2,0,146,178,184,55,126,184,255,0,100,123,2,0,83,147,175,77,175,74,255,0,109,123,2,0,207,132,163,152,78,163,255,0,118,123,2,0,254,225,228,228,26,28,255,0,127,123,2,0,146,178,184,55,126,184,255,0,136,123,2,0,83,147,175,77,175,74,255,0,145,123,2,0,207,132,163,152,78,163,255,0,154,123,2,0,21,255,255,255,127,0,255,0,163,123,2,0,254,225,228,228,26,28,255,0,172,123,2,0,146,178,184,55,126,184,255,0,181,123,2,0,83,147,175,77,175,74,255,0,190,123,2,0,207,132,163,152,78,163,255,0,199,123,2,0,21,255,255,255,127,0,255,0,208,123,2,0,42,204,255,255,255,51,255,0,217,123,2,0,254,225,228,228,26,28,255,0,226,123,2,0,146,178,184,55,126,184,255,0,235,123,2,0,83,147,175,77,175,74,255,0,244,123,2,0,207,132,163,152,78,163,255,0,253,123,2,0,21,255,255,255,127,0,255,0,6,124,2,0,42,204,255,255,255,51,255,0,15,124,2,0,15,193,166,166,86,40,255,0,24,124,2,0,254,225,228,228,26,28,255,0,33,124,2,0,146,178,184,55,126,184,255,0,42,124,2,0,83,147,175,77,175,74,255,0,51,124,2,0,207,132,163,152,78,163,255,0,60,124,2,0,21,255,255,255,127,0,255,0,69,124,2,0,42,204,255,255,255,51,255,0,78,124,2,0,15,193,166,166,86,40,255,0,87,124,2,0,232,121,247,247,129,191,255,0,96,124,2,0,254,225,228,228,26,28,255,0,105,124,2,0,146,178,184,55,126,184,255,0,114,124,2,0,83,147,175,77,175,74,255,0,123,124,2,0,207,132,163,152,78,163,255,0,132,124,2,0,21,255,255,255,127,0,255,0,141,124,2,0,42,204,255,255,255,51,255,0,150,124,2,0,15,193,166,166,86,40,255,0,159,124,2,0,232,121,247,247,129,191,255,0,168,124,2,0,0,0,153,153,153,153,255,0,177,124,2,0,114,120,194,102,194,165,255,0,186,124,2,0,11,155,252,252,141,98,255,0,195,124,2,0,156,77,203,141,160,203,255,0,204,124,2,0,114,120,194,102,194,165,255,0,213,124,2,0,11,155,252,252,141,98,255,0,222,124,2,0,156,77,203,141,160,203,255,0,231,124,2,0,228,102,231,231,138,195,255,0,240,124,2,0,114,120,194,102,194,165,255,0,249,124,2,0,11,155,252,252,141,98,255,0,2,125,2,0,156,77,203,141,160,203,255,0,11,125,2,0,228,102,231,231,138,195,255,0,20,125,2,0,58,155,216,166,216,84,255,0,29,125,2,0,114,120,194,102,194,165,255,0,38,125,2,0,11,155,252,252,141,98,255,0,47,125,2,0,156,77,203,141,160,203,255,0,56,125,2,0,228,102,231,231,138,195,255,0,65,125,2,0,58,155,216,166,216,84,255,0,74,125,2,0,34,208,255,255,217,47,255,0,83,125,2,0,114,120,194,102,194,165,255,0,92,125,2,0,11,155,252,252,141,98,255,0,101,125,2,0,156,77,203,141,160,203,255,0,110,125,2,0,228,102,231,231,138,195,255,0,119,125,2,0,58,155,216,166,216,84,255,0,128,125,2,0,34,208,255,255,217,47,255,0,137,125,2,0,25,90,229,229,196,148,255,0,146,125,2,0,114,120,194,102,194,165,255,0,155,125,2,0,11,155,252,252,141,98,255,0,164,125,2,0,156,77,203,141,160,203,255,0,173,125,2,0,228,102,231,231,138,195,255,0,182,125,2,0,58,155,216,166,216,84,255,0,191,125,2,0,34,208,255,255,217,47,255,0,200,125,2,0,25,90,229,229,196,148,255,0,209,125,2,0,0,0,179,179,179,179,255,0,218,125,2,0,120,84,211,141,211,199,255,0,228,125,2,0,211,82,189,188,128,189,255,0,239,125,2,0,42,76,255,255,255,179,255,0,249,125,2,0,175,37,218,190,186,218,255,0,3,126,2,0,4,139,251,251,128,114,255,0,13,126,2,0,144,100,211,128,177,211,255,0,23,126,2,0,22,156,253,253,180,98,255,0,33,126,2,0,58,134,222,179,222,105,255,0,43,126,2,0,233,47,252,252,205,229,255,0,53,126,2,0,0,0,217,217,217,217,255,0,63,126,2,0,120,84,211,141,211,199,255,0,73,126,2,0,211,82,189,188,128,189,255,0,84,126,2,0,77,41,235,204,235,197,255,0,95,126,2,0,42,76,255,255,255,179,255,0,105,126,2,0,175,37,218,190,186,218,255,0,115,126,2,0,4,139,251,251,128,114,255,0,125,126,2,0,144,100,211,128,177,211,255,0,135,126,2,0,22,156,253,253,180,98,255,0,145,126,2,0,58,134,222,179,222,105,255,0,155,126,2,0,233,47,252,252,205,229,255,0,165,126,2,0,0,0,217,217,217,217,255,0,175,126,2,0,120,84,211,141,211,199,255,0,185,126,2,0,211,82,189,188,128,189,255,0,196,126,2,0,77,41,235,204,235,197,255,0,207,126,2,0,37,144,255,255,237,111,255,0,218,126,2,0,42,76,255,255,255,179,255,0,228,126,2,0,175,37,218,190,186,218,255,0,238,126,2,0,4,139,251,251,128,114,255,0,248,126,2,0,144,100,211,128,177,211,255,0,2,127,2,0,22,156,253,253,180,98,255,0,12,127,2,0,58,134,222,179,222,105,255,0,22,127,2,0,233,47,252,252,205,229,255,0,32,127,2,0,0,0,217,217,217,217,255,0,42,127,2,0,120,84,211,141,211,199,255,0,51,127,2,0,42,76,255,255,255,179,255,0,60,127,2,0,175,37,218,190,186,218,255,0,69,127,2,0,120,84,211,141,211,199,255,0,78,127,2,0,42,76,255,255,255,179,255,0,87,127,2,0,175,37,218,190,186,218,255,0,96,127,2,0,4,139,251,251,128,114,255,0,105,127,2,0,120,84,211,141,211,199,255,0,114,127,2,0,42,76,255,255,255,179,255,0,123,127,2,0,175,37,218,190,186,218,255,0,132,127,2,0,4,139,251,251,128,114,255,0,141,127,2,0,144,100,211,128,177,211,255,0,150,127,2,0,120,84,211,141,211,199,255,0,159,127,2,0,42,76,255,255,255,179,255,0,168,127,2,0,175,37,218,190,186,218,255,0,177,127,2,0,4,139,251,251,128,114,255,0,186,127,2,0,144,100,211,128,177,211,255,0,195,127,2,0,22,156,253,253,180,98,255,0,204,127,2,0,120,84,211,141,211,199,255,0,213,127,2,0,42,76,255,255,255,179,255,0,222,127,2,0,175,37,218,190,186,218,255,0,231,127,2,0,4,139,251,251,128,114,255,0,240,127,2,0,144,100,211,128,177,211,255,0,249,127,2,0,22,156,253,253,180,98,255,0,2,128,2,0,58,134,222,179,222,105,255,0,11,128,2,0,120,84,211,141,211,199,255,0,20,128,2,0,42,76,255,255,255,179,255,0,29,128,2,0,175,37,218,190,186,218,255,0,38,128,2,0,4,139,251,251,128,114,255,0,47,128,2,0,144,100,211,128,177,211,255,0,56,128,2,0,22,156,253,253,180,98,255,0,65,128,2,0,58,134,222,179,222,105,255,0,74,128,2,0,233,47,252,252,205,229,255,0,83,128,2,0,120,84,211,141,211,199,255,0,92,128,2,0,42,76,255,255,255,179,255,0,101,128,2,0,175,37,218,190,186,218,255,0,110,128,2,0,4,139,251,251,128,114,255,0,119,128,2,0,144,100,211,128,177,211,255,0,128,128,2,0,22,156,253,253,180,98,255,0,137,128,2,0,58,134,222,179,222,105,255,0,146,128,2,0,233,47,252,252,205,229,255,0,155,128,2,0,0,0,217,217,217,217,255,0,164,128,2,0,237,253,158,158,1,66,255,0,178,128,2,0,177,130,162,94,79,162,255,0,193,128,2,0,250,180,213,213,62,79,255,0,207,128,2,0,10,184,244,244,109,67,255,0,221,128,2,0,20,157,253,253,174,97,255,0,235,128,2,0,31,115,254,254,224,139,255,0,249,128,2,0,49,96,245,230,245,152,255,0,7,129,2,0,79,65,221,171,221,164,255,0,21,129,2,0,114,120,194,102,194,165,255,0,35,129,2,0,143,187,189,50,136,189,255,0,49,129,2,0,237,253,158,158,1,66,255,0,63,129,2,0,143,187,189,50,136,189,255,0,78,129,2,0,177,130,162,94,79,162,255,0,93,129,2,0,250,180,213,213,62,79,255,0,107,129,2,0,10,184,244,244,109,67,255,0,121,129,2,0,20,157,253,253,174,97,255,0,135,129,2,0,31,115,254,254,224,139,255,0,149,129,2,0,42,64,255,255,255,191,255,0,163,129,2,0,49,96,245,230,245,152,255,0,177,129,2,0,79,65,221,171,221,164,255,0,191,129,2,0,114,120,194,102,194,165,255,0,205,129,2,0,13,164,252,252,141,89,255,0,218,129,2,0,42,64,255,255,255,191,255,0,231,129,2,0,81,77,213,153,213,148,255,0,244,129,2,0,254,225,215,215,25,28,255,0,1,130,2,0,20,157,253,253,174,97,255,0,14,130,2,0,79,65,221,171,221,164,255,0,27,130,2,0,143,196,186,43,131,186,255,0,40,130,2,0,254,225,215,215,25,28,255,0,53,130,2,0,20,157,253,253,174,97,255,0,66,130,2,0,42,64,255,255,255,191,255,0,79,130,2,0,79,65,221,171,221,164,255,0,92,130,2,0,143,196,186,43,131,186,255,0,105,130,2,0,250,180,213,213,62,79,255,0,118,130,2,0,13,164,252,252,141,89,255,0,131,130,2,0,31,115,254,254,224,139,255,0,144,130,2,0,49,96,245,230,245,152,255,0,157,130,2,0,81,77,213,153,213,148,255,0,170,130,2,0,143,187,189,50,136,189,255,0,183,130,2,0,250,180,213,213,62,79,255,0,196,130,2,0,13,164,252,252,141,89,255,0,209,130,2,0,31,115,254,254,224,139,255,0,222,130,2,0,42,64,255,255,255,191,255,0,235,130,2,0,49,96,245,230,245,152,255,0,248,130,2,0,81,77,213,153,213,148,255,0,5,131,2,0,143,187,189,50,136,189,255,0,18,131,2,0,250,180,213,213,62,79,255,0,31,131,2,0,10,184,244,244,109,67,255,0,44,131,2,0,20,157,253,253,174,97,255,0,57,131,2,0,31,115,254,254,224,139,255,0,70,131,2,0,49,96,245,230,245,152,255,0,83,131,2,0,79,65,221,171,221,164,255,0,96,131,2,0,114,120,194,102,194,165,255,0,109,131,2,0,143,187,189,50,136,189,255,0,122,131,2,0,250,180,213,213,62,79,255,0,135,131,2,0,10,184,244,244,109,67,255,0,148,131,2,0,20,157,253,253,174,97,255,0,161,131,2,0,31,115,254,254,224,139,255,0,174,131,2,0,42,64,255,255,255,191,255,0,187,131,2,0,49,96,245,230,245,152,255,0,200,131,2,0,79,65,221,171,221,164,255,0,213,131,2,0,114,120,194,102,194,165,255,0,226,131,2,0,143,187,189,50,136,189,255,0,239,131,2,0,147,15,255,240,248,255,255,0,254,131,2,0,24,35,250,250,235,215,255,0,16,132,2,0,127,255,255,0,255,255,255,0,26,132,2,0,113,128,255,127,255,212,255,0,42,132,2,0,127,15,255,240,255,255,255,0,53,132,2,0,42,26,245,245,245,220,255,0,64,132,2,0,23,58,255,255,228,196,255,0,76,132,2,0,0,0,0,0,0,0,255,0,87,132,2,0,25,49,255,255,235,205,255,0,107,132,2,0,170,255,255,0,0,255,255,0,117,132,2,0,192,206,226,138,43,226,255,0,133,132,2,0,0,190,165,165,42,42,255,0,144,132,2,0,23,99,222,222,184,135,255,0,159,132,2,0,128,103,160,95,158,160,255,0,174,132,2,0,63,255,255,127,255,0,255,0,190,132,2,0,17,218,210,210,105,30,255,0,205,132,2,0,11,175,255,255,127,80,255,0,216,132,2,0,154,147,237,100,149,237,255,0,236,132,2,0,33,34,255,255,248,220,255,0,250,132,2,0,246,231,220,220,20,60,255,0,7,133,2,0,127,255,255,0,255,255,255,0,17,133,2,0,170,255,139,0,0,139,255,0,31,133,2,0,127,255,139,0,139,139,255,0,45,133,2,0,30,239,184,184,134,11,255,0,64,133,2,0,0,0,169,169,169,169,255,0,78,133,2,0,85,255,100,0,100,0,255,0,93,133,2,0,0,0,169,169,169,169,255,0,107,133,2,0,39,110,189,189,183,107,255,0,122,133,2,0,212,255,139,139,0,139,255,0,139,133,2,0,58,142,107,85,107,47,255,0,159,133,2,0,23,255,255,255,140,0,255,0,175,133,2,0,198,192,204,153,50,204,255,0,191,133,2,0,0,255,139,139,0,0,255,0,204,133,2,0,10,121,233,233,150,122,255,0,220,133,2,0,85,61,188,143,188,143,255,0,238,133,2,0,175,143,139,72,61,139,255,0,1,134,2,0,127,103,79,47,79,79,255,0,20,134,2,0,127,103,79,47,79,79,255,0,39,134,2,0,128,255,209,0,206,209,255,0,58,134,2,0,199,255,211,148,0,211,255,0,74,134,2,0,232,235,255,255,20,147,255,0,88,134,2,0,138,255,255,0,191,255,255,0,105,134,2,0,0,0,105,105,105,105,255,0,118,134,2,0,0,0,105,105,105,105,255,0,131,134,2,0,148,225,255,30,144,255,255,0,147,134,2,0,0,206,178,178,34,34,255,0,162,134,2,0,28,15,255,255,250,240,255,0,179,134,2,0,85,192,139,34,139,34,255,0,196,134,2,0,212,255,255,255,0,255,255,0,209,134,2,0,0,0,220,220,220,220,255,0,224,134,2,0,170,7,255,248,248,255,255,0,240,134,2,0,35,255,255,255,215,0,255,0,250,134,2,0,30,217,218,218,165,32,255,0,9,135,2,0,0,0,128,128,128,128,255,0,19,135,2,0,85,255,128,0,128,0,255,0,30,135,2,0,59,208,255,173,255,47,255,0,47,135,2,0,0,0,128,128,128,128,255,0,57,135,2,0,85,15,255,240,255,240,255,0,71,135,2,0,233,150,255,255,105,180,255,0,84,135,2,0,0,140,205,205,92,92,255,0,99,135,2,0,194,255,130,75,0,130,255,0,111,135,2,0,42,15,255,255,255,240,255,0,122,135,2,0,38,106,240,240,230,140,255,0,133,135,2,0,170,20,250,230,230,250,255,0,147,135,2,0,240,15,255,255,240,245,255,0,166,135,2,0,64,255,252,124,252,0,255,0,181,135,2,0,38,49,255,255,250,205,255,0,199,135,2,0,137,63,230,173,216,230,255,0,214,135,2,0,0,119,240,240,128,128,255,0,230,135,2,0,127,31,255,224,255,255,255,0,245,135,2,0,42,40,250,250,250,210,255,0,15,136,2,0,0,0,211,211,211,211,255,0,30,136,2,0,85,100,238,144,238,144,255,0,46,136,2,0,0,0,211,211,211,211,255,0,61,136,2,0,248,73,255,255,182,193,255,0,76,136,2,0,12,132,255,255,160,122,255,0,93,136,2,0,125,209,178,32,178,170,255,0,112,136,2,0,143,117,250,135,206,250,255,0,130,136,2,0,148,56,153,119,136,153,255,0,150,136,2,0,148,56,153,119,136,153,255,0,170,136,2,0,151,52,222,176,196,222,255,0,190,136,2,0,42,31,255,255,255,224,255,0,207,136,2,0,85,255,255,0,255,0,255,0,217,136,2,0,85,192,205,50,205,50,255,0,232,136,2,0,21,20,250,250,240,230,255,0,243,136,2,0,212,255,255,255,0,255,255,0,0,137,2,0,0,255,128,128,0,0,255,0,12,137,2,0,113,128,205,102,205,170,255,0,34,137,2,0,170,255,205,0,0,205,255,0,50,137,2,0,204,152,211,186,85,211,255,0,68,137,2,0,183,124,219,147,112,219,255,0,86,137,2,0,103,169,179,60,179,113,255,0,106,137,2,0,176,143,238,123,104,238,255,0,127,137,2,0,111,255,250,0,250,154,255,0,150,137,2,0,125,167,209,72,209,204,255,0,171,137,2,0,228,228,199,199,21,133,255,0,192,137,2,0,170,198,112,25,25,112,255,0,210,137,2,0,106,9,255,245,255,250,255,0,225,137,2,0,4,30,255,255,228,225,255,0,240,137,2,0,26,73,255,255,228,181,255,0,254,137,2,0,25,81,255,255,222,173,255,0,15,138,2,0,170,255,128,0,0,128,255,0,25,138,2,0,27,23,253,253,245,230,255,0,38,138,2,0,42,255,128,128,128,0,255,0,49,138,2,0,56,192,142,107,142,35,255,0,64,138,2,0,27,255,255,255,165,0,255,0,76,138,2,0,11,255,255,255,69,0,255,0,91,138,2,0,214,123,218,218,112,214,255,0,103,138,2,0,38,72,238,238,232,170,255,0,122,138,2,0,85,100,251,152,251,152,255,0,137,138,2,0,127,67,238,175,238,238,255,0,156,138,2,0,241,124,219,219,112,147,255,0,175,138,2,0,26,41,255,255,239,213,255,0,191,138,2,0,20,70,255,255,218,185,255,0,206,138,2,0,20,176,205,205,133,63,255,0,216,138,2,0,247,63,255,255,192,203,255,0,226,138,2,0,212,70,221,221,160,221,255,0,236,138,2,0,132,59,230,176,224,230,255,0,252,138,2,0,212,255,128,128,0,128,255,0,8,139,2,0,0,255,255,255,0,0,255,0,17,139,2,0,0,61,188,188,143,143,255,0,32,139,2,0,159,181,225,65,105,225,255,0,47,139,2,0,17,220,139,139,69,19,255,0,64,139,2,0,4,138,250,250,128,114,255,0,76,139,2,0,19,154,244,244,164,96,255,0,92,139,2,0,103,170,139,46,139,87,255,0,106,139,2,0,17,16,255,255,245,238,255,0,120,139,2,0,13,183,160,160,82,45,255,0,132,139,2,0,0,0,192,192,192,192,255,0,144,139,2,0,139,108,235,135,206,235,255,0,157,139,2,0,175,143,205,106,90,205,255,0,172,139,2,0,148,56,144,112,128,144,255,0,187,139,2,0,148,56,144,112,128,144,255,0,202,139,2,0,0,5,255,255,250,250,255,0,212,139,2,0,106,255,255,0,255,127,255,0,229,139,2,0,146,155,180,70,130,180,255,0,244,139,2,0,24,84,210,210,180,140,255,0,253,139,2,0,127,255,128,0,128,128,255,0,7,140,2,0,212,29,216,216,191,216,255,0,20,140,2,0,6,184,255,255,99,71,255,0,32,140,2,0,123,182,224,64,224,208,255,0,47,140,2,0,212,115,238,238,130,238,255,0,59,140,2,0,27,68,245,245,222,179,255,0,70,140,2,0,0,0,255,255,255,255,255,0,81,140,2,0,0,0,245,245,245,245,255,0,97,140,2,0,42,255,255,255,255,0,255,0,109,140,2,0,56,192,205,154,205,50,255,0,126,140,2,0,45,67,252,247,252,185,255,0,135,140,2,0,68,91,221,173,221,142,255,0,144,140,2,0,98,178,163,49,163,84,255,0,153,140,2,0,42,50,255,255,255,204,255,0,162,140,2,0,62,85,230,194,230,153,255,0,171,140,2,0,85,100,198,120,198,121,255,0,180,140,2,0,99,187,132,35,132,67,255,0,189,140,2,0,42,50,255,255,255,204,255,0,198,140,2,0,62,85,230,194,230,153,255,0,207,140,2,0,85,100,198,120,198,121,255,0,216,140,2,0,98,178,163,49,163,84,255,0,225,140,2,0,107,255,104,0,104,55,255,0,234,140,2,0,42,50,255,255,255,204,255,0,243,140,2,0,55,81,240,217,240,163,255,0,252,140,2,0,68,91,221,173,221,142,255,0,5,141,2,0,85,100,198,120,198,121,255,0,14,141,2,0,98,178,163,49,163,84,255,0,23,141,2,0,107,255,104,0,104,55,255,0,32,141,2,0,42,50,255,255,255,204,255,0,41,141,2,0,55,81,240,217,240,163,255,0,50,141,2,0,68,91,221,173,221,142,255,0,59,141,2,0,85,100,198,120,198,121,255,0,68,141,2,0,96,158,171,65,171,93,255,0,77,141,2,0,99,187,132,35,132,67,255,0,86,141,2,0,108,255,90,0,90,50,255,0,95,141,2,0,42,25,255,255,255,229,255,0,104,141,2,0,45,67,252,247,252,185,255,0,113,141,2,0,55,81,240,217,240,163,255,0,122,141,2,0,68,91,221,173,221,142,255,0,131,141,2,0,85,100,198,120,198,121,255,0,140,141,2,0,96,158,171,65,171,93,255,0,149,141,2,0,99,187,132,35,132,67,255,0,158,141,2,0,108,255,90,0,90,50,255,0,167,141,2,0,42,25,255,255,255,229,255,0,176,141,2,0,45,67,252,247,252,185,255,0,185,141,2,0,55,81,240,217,240,163,255,0,194,141,2,0,68,91,221,173,221,142,255,0,203,141,2,0,85,100,198,120,198,121,255,0,212,141,2,0,96,158,171,65,171,93,255,0,221,141,2,0,99,187,132,35,132,67,255,0,230,141,2,0,107,255,104,0,104,55,255,0,239,141,2,0,110,255,69,0,69,41,255,0,248,141,2,0,49,73,248,237,248,177,255,0,3,142,2,0,117,97,205,127,205,187,255,0,14,142,2,0,144,194,184,44,127,184,255,0,25,142,2,0,42,50,255,255,255,204,255,0,36,142,2,0,99,66,218,161,218,180,255,0,47,142,2,0,132,170,196,65,182,196,255,0,58,142,2,0,150,203,168,34,94,168,255,0,69,142,2,0,42,50,255,255,255,204,255,0,80,142,2,0,99,66,218,161,218,180,255,0,91,142,2,0,132,170,196,65,182,196,255,0,102,142,2,0,144,194,184,44,127,184,255,0,113,142,2,0,164,191,148,37,52,148,255,0,124,142,2,0,42,50,255,255,255,204,255,0,135,142,2,0,69,58,233,199,233,180,255,0,146,142,2,0,117,97,205,127,205,187,255,0,157,142,2,0,132,170,196,65,182,196,255,0,168,142,2,0,144,194,184,44,127,184,255,0,179,142,2,0,164,191,148,37,52,148,255,0,190,142,2,0,42,50,255,255,255,204,255,0,201,142,2,0,69,58,233,199,233,180,255,0,212,142,2,0,117,97,205,127,205,187,255,0,223,142,2,0,132,170,196,65,182,196,255,0,234,142,2,0,139,216,192,29,145,192,255,0,245,142,2,0,150,203,168,34,94,168,255,0,0,143,2,0,158,231,132,12,44,132,255,0,11,143,2,0,42,38,255,255,255,217,255,0,22,143,2,0,49,73,248,237,248,177,255,0,33,143,2,0,69,58,233,199,233,180,255,0,44,143,2,0,117,97,205,127,205,187,255,0,55,143,2,0,132,170,196,65,182,196,255,0,66,143,2,0,139,216,192,29,145,192,255,0,77,143,2,0,150,203,168,34,94,168,255,0,88,143,2,0,158,231,132,12,44,132,255,0,99,143,2,0,42,38,255,255,255,217,255,0,110,143,2,0,49,73,248,237,248,177,255,0,121,143,2,0,69,58,233,199,233,180,255,0,132,143,2,0,117,97,205,127,205,187,255,0,143,143,2,0,132,170,196,65,182,196,255,0,154,143,2,0,139,216,192,29,145,192,255,0,165,143,2,0,150,203,168,34,94,168,255,0,176,143,2,0,164,191,148,37,52,148,255,0,187,143,2,0,158,231,88,8,29,88,255,0,198,143,2,0,37,66,255,255,247,188,255,0,209,143,2,0,28,175,254,254,196,79,255,0,220,143,2,0,16,238,217,217,95,14,255,0,231,143,2,0,42,42,255,255,255,212,255,0,242,143,2,0,28,112,254,254,217,142,255,0,253,143,2,0,22,213,254,254,153,41,255,0,8,144,2,0,15,252,204,204,76,2,255,0,19,144,2,0,42,42,255,255,255,212,255,0,30,144,2,0,28,112,254,254,217,142,255,0,41,144,2,0,22,213,254,254,153,41,255,0,52,144,2,0,16,238,217,217,95,14,255,0,63,144,2,0,13,248,153,153,52,4,255,0,74,144,2,0,42,42,255,255,255,212,255,0,85,144,2,0,31,109,254,254,227,145,255,0,96,144,2,0,28,175,254,254,196,79,255,0,107,144,2,0,22,213,254,254,153,41,255,0,118,144,2,0,16,238,217,217,95,14,255,0,129,144,2,0,13,248,153,153,52,4,255,0,140,144,2,0,42,42,255,255,255,212,255,0,151,144,2,0,31,109,254,254,227,145,255,0,162,144,2,0,28,175,254,254,196,79,255,0,173,144,2,0,22,213,254,254,153,41,255,0,184,144,2,0,18,233,236,236,112,20,255,0,195,144,2,0,15,252,204,204,76,2,255,0,206,144,2,0,12,247,140,140,45,4,255,0,217,144,2,0,42,25,255,255,255,229,255,0,228,144,2,0,37,66,255,255,247,188,255,0,239,144,2,0,31,109,254,254,227,145,255,0,250,144,2,0,28,175,254,254,196,79,255,0,5,145,2,0,22,213,254,254,153,41,255,0,16,145,2,0,18,233,236,236,112,20,255,0,27,145,2,0,15,252,204,204,76,2,255,0,38,145,2,0,12,247,140,140,45,4,255,0,49,145,2,0,42,25,255,255,255,229,255,0,60,145,2,0,37,66,255,255,247,188,255,0,71,145,2,0,31,109,254,254,227,145,255,0,82,145,2,0,28,175,254,254,196,79,255,0,93,145,2,0,22,213,254,254,153,41,255,0,104,145,2,0,18,233,236,236,112,20,255,0,115,145,2,0,15,252,204,204,76,2,255,0,126,145,2,0,13,248,153,153,52,4,255,0,137,145,2,0,13,240,102,102,37,6,255,0,148,145,2,0,34,95,255,255,237,160,255,0,159,145,2,0,24,178,254,254,178,76,255,0,170,145,2,0,5,221,240,240,59,32,255,0,181,145,2,0,42,77,255,255,255,178,255,0,192,145,2,0,29,162,254,254,204,92,255,0,203,145,2,0,17,194,253,253,141,60,255,0,214,145,2,0,254,225,227,227,26,28,255,0,225,145,2,0,42,77,255,255,255,178,255,0,236,145,2,0,29,162,254,254,204,92,255,0,247,145,2,0,17,194,253,253,141,60,255,0,2,146,2,0,5,221,240,240,59,32,255,0,13,146,2,0,246,255,189,189,0,38,255,0,24,146,2,0,42,77,255,255,255,178,255,0,35,146,2,0,30,136,254,254,217,118,255,0,46,146,2,0,24,178,254,254,178,76,255,0,57,146,2,0,17,194,253,253,141,60,255,0,68,146,2,0,5,221,240,240,59,32,255,0,79,146,2,0,246,255,189,189,0,38,255,0,90,146,2,0,42,77,255,255,255,178,255,0,101,146,2,0,30,136,254,254,217,118,255,0,112,146,2,0,24,178,254,254,178,76,255,0,123,146,2,0,17,194,253,253,141,60,255,0,134,146,2,0,7,212,252,252,78,42,255,0,145,146,2,0,254,225,227,227,26,28,255,0,156,146,2,0,245,255,177,177,0,38,255,0,167,146,2,0,42,50,255,255,255,204,255,0,178,146,2,0,34,95,255,255,237,160,255,0,189,146,2,0,30,136,254,254,217,118,255,0,200,146,2,0,24,178,254,254,178,76,255,0,211,146,2,0,17,194,253,253,141,60,255,0,222,146,2,0,7,212,252,252,78,42,255,0,233,146,2,0,254,225,227,227,26,28,255,0,244,146,2,0,245,255,177,177,0,38,255,0,255,146,2,0,42,50,255,255,255,204,255,0,10,147,2,0,34,95,255,255,237,160,255,0,21,147,2,0,30,136,254,254,217,118,255,0,32,147,2,0,24,178,254,254,178,76,255,0,43,147,2,0,17,194,253,253,141,60,255,0,54,147,2,0,7,212,252,252,78,42,255,0,65,147,2,0,254,225,227,227,26,28,255,0,76,147,2,0,246,255,189,189,0,38,255,0,87,147,2,0,242,255,128,128,0,38,255,0,98,147,2,0,147,15,255,240,248,255,255,0,108,147,2,0,24,35,250,250,235,215,255,0,121,147,2,0,23,36,255,255,239,219,255,0,135,147,2,0,23,36,238,238,223,204,255,0,149,147,2,0,23,36,205,205,192,176,255,0,163,147,2,0,24,34,139,139,131,120,255,0,177,147,2,0,113,128,255,127,255,212,255,0,188,147,2,0,113,128,255,127,255,212,255,0,200,147,2,0,113,128,238,118,238,198,255,0,212,147,2,0,113,128,205,102,205,170,255,0,224,147,2,0,113,128,139,69,139,116,255,0,236,147,2,0,127,15,255,240,255,255,255,0,242,147,2,0,127,15,255,240,255,255,255,0,249,147,2,0,127,15,238,224,238,238,255,0,0,148,2,0,127,14,205,193,205,205,255,0,7,148,2,0,127,14,139,131,139,139,255,0,14,148,2,0,42,26,245,245,245,220,255,0,20,148,2,0,23,58,255,255,228,196,255,0,27,148,2,0,23,58,255,255,228,196,255,0,35,148,2,0,23,58,238,238,213,183,255,0,43,148,2,0,22,58,205,205,183,158,255,0,51,148,2,0,23,58,139,139,125,107,255,0,69,171,2,0,0,0,0,0,0,0,255,0,59,148,2,0,25,49,255,255,235,205,255,0,74,148,2,0,170,255,255,0,0,255,255,0,79,148,2,0,170,255,255,0,0,255,255,0,85,148,2,0,170,255,238,0,0,238,255,0,91,148,2,0,170,255,205,0,0,205,255,0,97,148,2,0,170,255,139,0,0,139,255,0,103,148,2,0,192,206,226,138,43,226,255,0,114,148,2,0,0,190,165,165,42,42,255,0,120,148,2,0,0,191,255,255,64,64,255,0,127,148,2,0,0,191,238,238,59,59,255,0,134,148,2,0,0,191,205,205,51,51,255,0,141,148,2,0,0,190,139,139,35,35,255,0,148,148,2,0,23,99,222,222,184,135,255,0,158,148,2,0,23,100,255,255,211,155,255,0,169,148,2,0,23,99,238,238,197,145,255,0,180,148,2,0,23,99,205,205,170,125,255,0,191,148,2,0,23,99,139,139,115,85,255,0,202,148,2,0,128,103,160,95,158,160,255,0,212,148,2,0,131,103,255,152,245,255,255,0,223,148,2,0,131,102,238,142,229,238,255,0,234,148,2,0,131,103,205,122,197,205,255,0,245,148,2,0,131,102,139,83,134,139,255,0,0,149,2,0,63,255,255,127,255,0,255,0,11,149,2,0,63,255,255,127,255,0,255,0,23,149,2,0,63,255,238,118,238,0,255,0,35,149,2,0,63,255,205,102,205,0,255,0,47,149,2,0,63,255,139,69,139,0,255,0,59,149,2,0,17,218,210,210,105,30,255,0,69,149,2,0,17,219,255,255,127,36,255,0,80,149,2,0,17,219,238,238,118,33,255,0,91,149,2,0,17,218,205,205,102,29,255,0,102,149,2,0,17,220,139,139,69,19,255,0,113,149,2,0,11,175,255,255,127,80,255,0,119,149,2,0,7,169,255,255,114,86,255,0,126,149,2,0,6,169,238,238,106,80,255,0,133,149,2,0,6,169,205,205,91,69,255,0,140,149,2,0,6,168,139,139,62,47,255,0,147,149,2,0,154,147,237,100,149,237,255,0,162,149,2,0,33,34,255,255,248,220,255,0,171,149,2,0,33,34,255,255,248,220,255,0,181,149,2,0,34,35,238,238,232,205,255,0,191,149,2,0,34,34,205,205,200,177,255,0,201,149,2,0,35,34,139,139,136,120,255,0,211,149,2,0,246,231,220,220,20,60,255,0,219,149,2,0,127,255,255,0,255,255,255,0,224,149,2,0,127,255,255,0,255,255,255,0,230,149,2,0,127,255,238,0,238,238,255,0,236,149,2,0,127,255,205,0,205,205,255,0,242,149,2,0,127,255,139,0,139,139,255,0,248,149,2,0,30,239,184,184,134,11,255,0,6,150,2,0,30,240,255,255,185,15,255,0,21,150,2,0,30,240,238,238,173,14,255,0,36,150,2,0,30,240,205,205,149,12,255,0,51,150,2,0,30,240,139,139,101,8,255,0,66,150,2,0,85,255,100,0,100,0,255,0,76,150,2],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+74232);allocate([39,110,189,189,183,107,255,0,86,150,2,0,58,142,107,85,107,47,255,0,101,150,2,0,58,143,255,202,255,112,255,0,117,150,2,0,58,143,238,188,238,104,255,0,133,150,2,0,58,143,205,162,205,90,255,0,149,150,2,0,58,143,139,110,139,61,255,0,165,150,2,0,23,255,255,255,140,0,255,0,176,150,2,0,21,255,255,255,127,0,255,0,188,150,2,0,21,255,238,238,118,0,255,0,200,150,2,0,21,255,205,205,102,0,255,0,212,150,2,0,21,255,139,139,69,0,255,0,224,150,2,0,198,192,204,153,50,204,255,0,235,150,2,0,198,193,255,191,62,255,255,0,247,150,2,0,198,192,238,178,58,238,255,0,3,151,2,0,198,192,205,154,50,205,255,0,15,151,2,0,198,192,139,104,34,139,255,0,27,151,2,0,10,121,233,233,150,122,255,0,38,151,2,0,85,61,188,143,188,143,255,0,51,151,2,0,85,62,255,193,255,193,255,0,65,151,2,0,85,62,238,180,238,180,255,0,79,151,2,0,85,62,205,155,205,155,255,0,93,151,2,0,85,62,139,105,139,105,255,0,107,151,2,0,175,143,139,72,61,139,255,0,121,151,2,0,127,103,79,47,79,79,255,0,135,151,2,0,127,104,255,151,255,255,255,0,150,151,2,0,127,103,238,141,238,238,255,0,165,151,2,0,127,104,205,121,205,205,255,0,180,151,2,0,127,104,139,82,139,139,255,0,195,151,2,0,127,103,79,47,79,79,255,0,209,151,2,0,128,255,209,0,206,209,255,0,223,151,2,0,199,255,211,148,0,211,255,0,234,151,2,0,232,235,255,255,20,147,255,0,243,151,2,0,232,235,255,255,20,147,255,0,253,151,2,0,232,235,238,238,18,137,255,0,7,152,2,0,232,235,205,205,16,118,255,0,17,152,2,0,231,236,139,139,10,80,255,0,27,152,2,0,138,255,255,0,191,255,255,0,39,152,2,0,138,255,255,0,191,255,255,0,52,152,2,0,138,255,238,0,178,238,255,0,65,152,2,0,138,255,205,0,154,205,255,0,78,152,2,0,138,255,139,0,104,139,255,0,91,152,2,0,0,0,105,105,105,105,255,0,99,152,2,0,0,0,105,105,105,105,255,0,107,152,2,0,148,225,255,30,144,255,255,0,118,152,2,0,148,225,255,30,144,255,255,0,130,152,2,0,148,225,238,28,134,238,255,0,142,152,2,0,148,225,205,24,116,205,255,0,154,152,2,0,148,225,139,16,78,139,255,0,166,152,2,0,0,206,178,178,34,34,255,0,176,152,2,0,0,207,255,255,48,48,255,0,187,152,2,0,0,207,238,238,44,44,255,0,198,152,2,0,0,207,205,205,38,38,255,0,209,152,2,0,0,207,139,139,26,26,255,0,220,152,2,0,28,15,255,255,250,240,255,0,232,152,2,0,85,192,139,34,139,34,255,0,244,152,2,0,0,0,220,220,220,220,255,0,254,152,2,0,170,7,255,248,248,255,255,0,9,153,2,0,35,255,255,255,215,0,255,0,14,153,2,0,35,255,255,255,215,0,255,0,20,153,2,0,35,255,238,238,201,0,255,0,26,153,2,0,35,255,205,205,173,0,255,0,32,153,2,0,35,255,139,139,117,0,255,0,38,153,2,0,30,217,218,218,165,32,255,0,48,153,2,0,30,218,255,255,193,37,255,0,59,153,2,0,30,218,238,238,180,34,255,0,70,153,2,0,30,218,205,205,155,29,255,0,81,153,2,0,30,218,139,139,105,20,255,0,92,153,2,0,0,0,192,192,192,192,255,0,97,153,2,0,0,0,0,0,0,0,255,0,103,153,2,0,0,0,3,3,3,3,255,0,109,153,2,0,0,0,26,26,26,26,255,0,116,153,2,0,0,0,255,255,255,255,255,0,124,153,2,0,0,0,28,28,28,28,255,0,131,153,2,0,0,0,31,31,31,31,255,0,138,153,2,0,0,0,33,33,33,33,255,0,145,153,2,0,0,0,36,36,36,36,255,0,152,153,2,0,0,0,38,38,38,38,255,0,159,153,2,0,0,0,41,41,41,41,255,0,166,153,2,0,0,0,43,43,43,43,255,0,173,153,2,0,0,0,46,46,46,46,255,0,180,153,2,0,0,0,48,48,48,48,255,0,187,153,2,0,0,0,5,5,5,5,255,0,193,153,2,0,0,0,51,51,51,51,255,0,200,153,2,0,0,0,54,54,54,54,255,0,207,153,2,0,0,0,56,56,56,56,255,0,214,153,2,0,0,0,59,59,59,59,255,0,221,153,2,0,0,0,61,61,61,61,255,0,228,153,2,0,0,0,64,64,64,64,255,0,235,153,2,0,0,0,66,66,66,66,255,0,242,153,2,0,0,0,69,69,69,69,255,0,249,153,2,0,0,0,71,71,71,71,255,0,0,154,2,0,0,0,74,74,74,74,255,0,7,154,2,0,0,0,8,8,8,8,255,0,13,154,2,0,0,0,77,77,77,77,255,0,20,154,2,0,0,0,79,79,79,79,255,0,27,154,2,0,0,0,82,82,82,82,255,0,34,154,2,0,0,0,84,84,84,84,255,0,41,154,2,0,0,0,87,87,87,87,255,0,48,154,2,0,0,0,89,89,89,89,255,0,55,154,2,0,0,0,92,92,92,92,255,0,62,154,2,0,0,0,94,94,94,94,255,0,69,154,2,0,0,0,97,97,97,97,255,0,76,154,2,0,0,0,99,99,99,99,255,0,83,154,2,0,0,0,10,10,10,10,255,0,89,154,2,0,0,0,102,102,102,102,255,0,96,154,2,0,0,0,105,105,105,105,255,0,103,154,2,0,0,0,107,107,107,107,255,0,110,154,2,0,0,0,110,110,110,110,255,0,117,154,2,0,0,0,112,112,112,112,255,0,124,154,2,0,0,0,115,115,115,115,255,0,131,154,2,0,0,0,117,117,117,117,255,0,138,154,2,0,0,0,120,120,120,120,255,0,145,154,2,0,0,0,122,122,122,122,255,0,152,154,2,0,0,0,125,125,125,125,255,0,159,154,2,0,0,0,13,13,13,13,255,0,165,154,2,0,0,0,127,127,127,127,255,0,172,154,2,0,0,0,130,130,130,130,255,0,179,154,2,0,0,0,133,133,133,133,255,0,186,154,2,0,0,0,135,135,135,135,255,0,193,154,2,0,0,0,138,138,138,138,255,0,200,154,2,0,0,0,140,140,140,140,255,0,207,154,2,0,0,0,143,143,143,143,255,0,214,154,2,0,0,0,145,145,145,145,255,0,221,154,2,0,0,0,148,148,148,148,255,0,228,154,2,0,0,0,150,150,150,150,255,0,235,154,2,0,0,0,15,15,15,15,255,0,241,154,2,0,0,0,153,153,153,153,255,0,248,154,2,0,0,0,156,156,156,156,255,0,255,154,2,0,0,0,158,158,158,158,255,0,6,155,2,0,0,0,161,161,161,161,255,0,13,155,2,0,0,0,163,163,163,163,255,0,20,155,2,0,0,0,166,166,166,166,255,0,27,155,2,0,0,0,168,168,168,168,255,0,34,155,2,0,0,0,171,171,171,171,255,0,41,155,2,0,0,0,173,173,173,173,255,0,48,155,2,0,0,0,176,176,176,176,255,0,55,155,2,0,0,0,18,18,18,18,255,0,61,155,2,0,0,0,179,179,179,179,255,0,68,155,2,0,0,0,181,181,181,181,255,0,75,155,2,0,0,0,184,184,184,184,255,0,82,155,2,0,0,0,186,186,186,186,255,0,89,155,2,0,0,0,189,189,189,189,255,0,96,155,2,0,0,0,191,191,191,191,255,0,103,155,2,0,0,0,194,194,194,194,255,0,110,155,2,0,0,0,196,196,196,196,255,0,117,155,2,0,0,0,199,199,199,199,255,0,124,155,2,0,0,0,201,201,201,201,255,0,131,155,2,0,0,0,20,20,20,20,255,0,137,155,2,0,0,0,204,204,204,204,255,0,144,155,2,0,0,0,207,207,207,207,255,0,151,155,2,0,0,0,209,209,209,209,255,0,158,155,2,0,0,0,212,212,212,212,255,0,165,155,2,0,0,0,214,214,214,214,255,0,172,155,2,0,0,0,217,217,217,217,255,0,179,155,2,0,0,0,219,219,219,219,255,0,186,155,2,0,0,0,222,222,222,222,255,0,193,155,2,0,0,0,224,224,224,224,255,0,200,155,2,0,0,0,227,227,227,227,255,0,207,155,2,0,0,0,23,23,23,23,255,0,213,155,2,0,0,0,229,229,229,229,255,0,220,155,2,0,0,0,232,232,232,232,255,0,227,155,2,0,0,0,235,235,235,235,255,0,234,155,2,0,0,0,237,237,237,237,255,0,241,155,2,0,0,0,240,240,240,240,255,0,248,155,2,0,0,0,242,242,242,242,255,0,255,155,2,0,0,0,245,245,245,245,255,0,6,156,2,0,0,0,247,247,247,247,255,0,13,156,2,0,0,0,250,250,250,250,255,0,20,156,2,0,0,0,252,252,252,252,255,0,27,156,2,0,85,255,255,0,255,0,255,0,33,156,2,0,85,255,255,0,255,0,255,0,40,156,2,0,85,255,238,0,238,0,255,0,47,156,2,0,85,255,205,0,205,0,255,0,54,156,2,0,85,255,139,0,139,0,255,0,61,156,2,0,59,208,255,173,255,47,255,0,73,156,2,0,0,0,192,192,192,192,255,0,78,156,2,0,0,0,0,0,0,0,255,0,84,156,2,0,0,0,3,3,3,3,255,0,90,156,2,0,0,0,26,26,26,26,255,0,97,156,2,0,0,0,255,255,255,255,255,0,105,156,2,0,0,0,28,28,28,28,255,0,112,156,2,0,0,0,31,31,31,31,255,0,119,156,2,0,0,0,33,33,33,33,255,0,126,156,2,0,0,0,36,36,36,36,255,0,133,156,2,0,0,0,38,38,38,38,255,0,140,156,2,0,0,0,41,41,41,41,255,0,147,156,2,0,0,0,43,43,43,43,255,0,154,156,2,0,0,0,46,46,46,46,255,0,161,156,2,0,0,0,48,48,48,48,255,0,168,156,2,0,0,0,5,5,5,5,255,0,174,156,2,0,0,0,51,51,51,51,255,0,181,156,2,0,0,0,54,54,54,54,255,0,188,156,2,0,0,0,56,56,56,56,255,0,195,156,2,0,0,0,59,59,59,59,255,0,202,156,2,0,0,0,61,61,61,61,255,0,209,156,2,0,0,0,64,64,64,64,255,0,216,156,2,0,0,0,66,66,66,66,255,0,223,156,2,0,0,0,69,69,69,69,255,0,230,156,2,0,0,0,71,71,71,71,255,0,237,156,2,0,0,0,74,74,74,74,255,0,244,156,2,0,0,0,8,8,8,8,255,0,250,156,2,0,0,0,77,77,77,77,255,0,1,157,2,0,0,0,79,79,79,79,255,0,8,157,2,0,0,0,82,82,82,82,255,0,15,157,2,0,0,0,84,84,84,84,255,0,22,157,2,0,0,0,87,87,87,87,255,0,29,157,2,0,0,0,89,89,89,89,255,0,36,157,2,0,0,0,92,92,92,92,255,0,43,157,2,0,0,0,94,94,94,94,255,0,50,157,2,0,0,0,97,97,97,97,255,0,57,157,2,0,0,0,99,99,99,99,255,0,64,157,2,0,0,0,10,10,10,10,255,0,70,157,2,0,0,0,102,102,102,102,255,0,77,157,2,0,0,0,105,105,105,105,255,0,84,157,2,0,0,0,107,107,107,107,255,0,91,157,2,0,0,0,110,110,110,110,255,0,98,157,2,0,0,0,112,112,112,112,255,0,105,157,2,0,0,0,115,115,115,115,255,0,112,157,2,0,0,0,117,117,117,117,255,0,119,157,2,0,0,0,120,120,120,120,255,0,126,157,2,0,0,0,122,122,122,122,255,0,133,157,2,0,0,0,125,125,125,125,255,0,140,157,2,0,0,0,13,13,13,13,255,0,146,157,2,0,0,0,127,127,127,127,255,0,153,157,2,0,0,0,130,130,130,130,255,0,160,157,2,0,0,0,133,133,133,133,255,0,167,157,2,0,0,0,135,135,135,135,255,0,174,157,2,0,0,0,138,138,138,138,255,0,181,157,2,0,0,0,140,140,140,140,255,0,188,157,2,0,0,0,143,143,143,143,255,0,195,157,2,0,0,0,145,145,145,145,255,0,202,157,2,0,0,0,148,148,148,148,255,0,209,157,2,0,0,0,150,150,150,150,255,0,216,157,2,0,0,0,15,15,15,15,255,0,222,157,2,0,0,0,153,153,153,153,255,0,229,157,2,0,0,0,156,156,156,156,255,0,236,157,2,0,0,0,158,158,158,158,255,0,243,157,2,0,0,0,161,161,161,161,255,0,250,157,2,0,0,0,163,163,163,163,255,0,1,158,2,0,0,0,166,166,166,166,255,0,8,158,2,0,0,0,168,168,168,168,255,0,15,158,2,0,0,0,171,171,171,171,255,0,22,158,2,0,0,0,173,173,173,173,255,0,29,158,2,0,0,0,176,176,176,176,255,0,36,158,2,0,0,0,18,18,18,18,255,0,42,158,2,0,0,0,179,179,179,179,255,0,49,158,2,0,0,0,181,181,181,181,255,0,56,158,2,0,0,0,184,184,184,184,255,0,63,158,2,0,0,0,186,186,186,186,255,0,70,158,2,0,0,0,189,189,189,189,255,0,77,158,2,0,0,0,191,191,191,191,255,0,84,158,2,0,0,0,194,194,194,194,255,0,91,158,2,0,0,0,196,196,196,196,255,0,98,158,2,0,0,0,199,199,199,199,255,0,105,158,2,0,0,0,201,201,201,201,255,0,112,158,2,0,0,0,20,20,20,20,255,0,118,158,2,0,0,0,204,204,204,204,255,0,125,158,2,0,0,0,207,207,207,207,255,0,132,158,2,0,0,0,209,209,209,209,255,0,139,158,2,0,0,0,212,212,212,212,255,0,146,158,2,0,0,0,214,214,214,214,255,0,153,158,2,0,0,0,217,217,217,217,255,0,160,158,2,0,0,0,219,219,219,219,255,0,167,158,2,0,0,0,222,222,222,222,255,0,174,158,2,0,0,0,224,224,224,224,255,0,181,158,2,0,0,0,227,227,227,227,255,0,188,158,2,0,0,0,23,23,23,23,255,0,194,158,2,0,0,0,229,229,229,229,255,0,201,158,2,0,0,0,232,232,232,232,255,0,208,158,2,0,0,0,235,235,235,235,255,0,215,158,2,0,0,0,237,237,237,237,255,0,222,158,2,0,0,0,240,240,240,240,255,0,229,158,2,0,0,0,242,242,242,242,255,0,236,158,2,0,0,0,245,245,245,245,255,0,243,158,2,0,0,0,247,247,247,247,255,0,250,158,2,0,0,0,250,250,250,250,255,0,1,159,2,0,0,0,252,252,252,252,255,0,8,159,2,0,85,15,255,240,255,240,255,0,17,159,2,0,85,15,255,240,255,240,255,0,27,159,2,0,85,15,238,224,238,224,255,0,37,159,2,0,85,14,205,193,205,193,255,0,47,159,2,0,85,14,139,131,139,131,255,0,57,159,2,0,233,150,255,255,105,180,255,0,65,159,2,0,234,145,255,255,110,180,255,0,74,159,2,0,235,141,238,238,106,167,255,0,83,159,2,0,236,135,205,205,96,144,255,0,92,159,2,0,234,148,139,139,58,98,255,0,101,159,2,0,0,140,205,205,92,92,255,0,111,159,2,0,0,148,255,255,106,106,255,0,122,159,2,0,0,148,238,238,99,99,255,0,133,159,2,0,0,149,205,205,85,85,255,0,144,159,2,0,0,148,139,139,58,58,255,0,155,159,2,0,194,255,130,75,0,130,255,0,162,159,2,0,42,0,255,255,255,254,0,0,168,159,2,0,42,15,255,255,255,240,255,0,174,159,2,0,42,15,255,255,255,240,255,0,181,159,2,0,42,15,238,238,238,224,255,0,188,159,2,0,42,14,205,205,205,193,255,0,195,159,2,0,42,14,139,139,139,131,255,0,202,159,2,0,38,106,240,240,230,140,255,0,208,159,2,0,39,112,255,255,246,143,255,0,215,159,2,0,39,112,238,238,230,133,255,0,222,159,2,0,39,111,205,205,198,115,255,0,229,159,2,0,39,111,139,139,134,78,255,0,236,159,2,0,170,20,250,230,230,250,255,0,245,159,2,0,240,15,255,255,240,245,255,0,3,160,2,0,240,15,255,255,240,245,255,0,18,160,2,0,239,15,238,238,224,229,255,0,33,160,2,0,240,14,205,205,193,197,255,0,48,160,2,0,239,14,139,139,131,134,255,0,63,160,2,0,64,255,252,124,252,0,255,0,73,160,2,0,38,49,255,255,250,205,255,0,86,160,2,0,38,49,255,255,250,205,255,0,100,160,2,0,37,50,238,238,233,191,255,0,114,160,2,0,38,49,205,205,201,165,255,0,128,160,2,0,39,49,139,139,137,112,255,0,142,160,2,0,137,63,230,173,216,230,255,0,152,160,2,0,138,64,255,191,239,255,255,0,163,160,2,0,138,64,238,178,223,238,255,0,174,160,2,0,138,63,205,154,192,205,255,0,185,160,2,0,137,64,139,104,131,139,255,0,196,160,2,0,0,119,240,240,128,128,255,0,207,160,2,0,127,31,255,224,255,255,255,0,217,160,2,0,127,31,255,224,255,255,255,0,228,160,2,0,127,31,238,209,238,238,255,0,239,160,2,0,127,31,205,180,205,205,255,0,250,160,2,0,127,31,139,122,139,139,255,0,5,161,2,0,35,115,238,238,221,130,255,0,20,161,2,0,35,116,255,255,236,139,255,0,36,161,2,0,35,115,238,238,220,130,255,0,52,161,2,0,35,115,205,205,190,112,255,0,68,161,2,0,35,115,139,139,129,76,255,0,84,161,2,0,42,40,250,250,250,210,255,0,105,161,2,0,0,0,211,211,211,211,255,0,115,161,2,0,0,0,211,211,211,211,255,0,125,161,2,0,248,73,255,255,182,193,255,0,135,161,2,0,249,81,255,255,174,185,255,0,146,161,2,0,248,81,238,238,162,173,255,0,157,161,2,0,249,80,205,205,140,149,255,0,168,161,2,0,249,80,139,139,95,101,255,0,179,161,2,0,12,132,255,255,160,122,255,0,191,161,2,0,12,132,255,255,160,122,255,0,204,161,2,0,11,132,238,238,149,114,255,0,217,161,2,0,12,133,205,205,129,98,255,0,230,161,2,0,12,133,139,139,87,66,255,0,243,161,2,0,125,209,178,32,178,170,255,0,1,162,2,0,143,117,250,135,206,250,255,0,14,162,2,0,143,79,255,176,226,255,255,0,28,162,2,0,143,79,238,164,211,238,255,0,42,162,2,0,142,79,205,141,182,205,255,0,56,162,2,0,143,78,139,96,123,139,255,0,70,162,2,0,175,143,255,132,112,255,255,0,85,162,2,0,148,56,153,119,136,153,255,0,100,162,2,0,148,56,153,119,136,153,255,0,115,162,2,0,151,52,222,176,196,222,255,0,130,162,2,0,151,53,255,202,225,255,255,0,146,162,2,0,151,53,238,188,210,238,255,0,162,162,2,0,151,53,205,162,181,205,255,0,178,162,2,0,150,53,139,110,123,139,255,0,194,162,2,0,42,31,255,255,255,224,255,0,206,162,2,0,42,31,255,255,255,224,255,0,219,162,2,0,42,31,238,238,238,209,255,0,232,162,2,0,42,31,205,205,205,180,255,0,245,162,2,0,42,31,139,139,139,122,255,0,2,163,2,0,85,192,205,50,205,50,255,0,12,163,2,0,21,20,250,250,240,230,255,0,18,163,2,0,212,255,255,255,0,255,255,0,26,163,2,0,212,255,255,255,0,255,255,0,35,163,2,0,212,255,238,238,0,238,255,0,44,163,2,0,212,255,205,205,0,205,255,0,53,163,2,0,212,255,139,139,0,139,255,0,62,163,2,0,239,185,176,176,48,96,255,0,69,163,2,0,228,203,255,255,52,179,255,0,77,163,2,0,228,203,238,238,48,167,255,0,85,163,2,0,228,204,205,205,41,144,255,0,93,163,2,0,228,203,139,139,28,98,255,0,101,163,2,0,113,128,205,102,205,170,255,0,118,163,2,0,170,255,205,0,0,205,255,0,129,163,2,0,204,152,211,186,85,211,255,0,142,163,2,0,203,153,255,224,102,255,255,0,156,163,2,0,203,153,238,209,95,238,255,0,170,163,2,0,203,153,205,180,82,205,255,0,184,163,2,0,203,154,139,122,55,139,255,0,198,163,2,0,183,124,219,147,112,219,255,0,211,163,2,0,183,125,255,171,130,255,255,0,225,163,2,0,183,125,238,159,121,238,255,0,239,163,2,0,183,125,205,137,104,205,255,0,253,163,2,0,183,124,139,93,71,139,255,0,11,164,2,0,103,169,179,60,179,113,255,0,26,164,2,0,176,143,238,123,104,238,255,0,42,164,2,0,111,255,250,0,250,154,255,0,60,164,2,0,125,167,209,72,209,204,255,0,76,164,2,0,228,228,199,199,21,133,255,0,92,164,2,0,170,198,112,25,25,112,255,0,105,164,2,0,106,9,255,245,255,250,255,0,115,164,2,0,4,30,255,255,228,225,255,0,125,164,2,0,4,30,255,255,228,225,255,0,136,164,2,0,4,30,238,238,213,210,255,0,147,164,2,0,3,29,205,205,183,181,255,0,158,164,2,0,5,29,139,139,125,123,255,0,169,164,2,0,26,73,255,255,228,181,255,0,178,164,2,0,25,81,255,255,222,173,255,0,190,164,2,0,25,81,255,255,222,173,255,0,203,164,2,0,25,82,238,238,207,161,255,0,216,164,2,0,25,82,205,205,179,139,255,0,229,164,2,0,25,82,139,139,121,94,255,0,242,164,2,0,170,255,128,0,0,128,255,0,247,164,2,0,170,255,128,0,0,128,255,0,0,165,2,0,42,0,255,255,255,254,0,0,5,165,2,0,27,23,253,253,245,230,255,0,13,165,2,0,56,192,142,107,142,35,255,0,23,165,2,0,56,193,255,192,255,62,255,0,34,165,2,0,56,192,238,179,238,58,255,0,45,165,2,0,56,192,205,154,205,50,255,0,56,165,2,0,56,192,139,105,139,34,255,0,67,165,2,0,27,255,255,255,165,0,255,0,74,165,2,0,27,255,255,255,165,0,255,0,82,165,2,0,27,255,238,238,154,0,255,0,90,165,2,0,27,255,205,205,133,0,255,0,98,165,2,0,27,255,139,139,90,0,255,0,106,165,2,0,11,255,255,255,69,0,255,0,116,165,2,0,11,255,255,255,69,0,255,0,127,165,2,0,11,255,238,238,64,0,255,0,138,165,2,0,11,255,205,205,55,0,255,0,149,165,2,0,11,255,139,139,37,0,255,0,160,165,2,0,214,123,218,218,112,214,255,0,167,165,2,0,214,124,255,255,131,250,255,0,175,165,2,0,214,124,238,238,122,233,255,0,183,165,2,0,214,124,205,205,105,201,255,0,191,165,2,0,213,124,139,139,71,137,255,0,199,165,2,0,38,72,238,238,232,170,255,0,213,165,2,0,85,100,251,152,251,152,255,0,223,165,2,0,85,101,255,154,255,154,255,0,234,165,2,0,85,100,238,144,238,144,255,0,245,165,2,0,85,100,205,124,205,124,255,0,0,166,2,0,85,100,139,84,139,84,255,0,11,166,2,0,127,67,238,175,238,238,255,0,25,166,2,0,127,68,255,187,255,255,255,0,40,166,2,0,127,68,238,174,238,238,255,0,55,166,2,0,127,68,205,150,205,205,255,0,70,166,2,0,127,67,139,102,139,139,255,0,85,166,2,0,241,124,219,219,112,147,255,0,99,166,2,0,241,125,255,255,130,171,255,0,114,166,2,0,241,125,238,238,121,159,255,0,129,166,2,0,241,125,205,205,104,137,255,0,144,166,2,0,241,124,139,139,71,93,255,0,159,166,2,0,26,41,255,255,239,213,255,0,170,166,2,0,20,70,255,255,218,185,255,0,180,166,2,0,20,70,255,255,218,185,255,0,191,166,2,0,19,69,238,238,203,173,255,0,202,166,2,0,19,69,205,205,175,149,255,0,213,166,2,0,20,69,139,139,119,101,255,0,224,166,2,0,20,176,205,205,133,63,255,0,229,166,2,0,247,63,255,255,192,203,255,0,234,166,2,0,245,73,255,255,181,197,255,0,240,166,2,0,245,73,238,238,169,184,255,0,246,166,2,0,245,74,205,205,145,158,255,0,252,166,2,0,245,73,139,139,99,108,255,0,2,167,2,0,212,70,221,221,160,221,255,0,7,167,2,0,212,68,255,255,187,255,255,0,13,167,2,0,212,68,238,238,174,238,255,0,19,167,2,0,212,68,205,205,150,205,255,0,25,167,2,0,212,67,139,139,102,139,255,0,31,167,2,0,132,59,230,176,224,230,255,0,42,167,2,0,196,221,240,160,32,240,255,0,49,167,2,0,191,207,255,155,48,255,255,0,57,167,2,0,192,207,238,145,44,238,255,0,65,167,2,0,192,207,205,125,38,205,255,0,73,167,2,0,192,207,139,85,26,139,255,0,81,167,2,0,0,255,255,255,0,0,255,0,85,167,2,0,0,255,255,255,0,0,255,0,90,167,2,0,0,255,238,238,0,0,255,0,95,167,2,0,0,255,205,205,0,0,255,0,100,167,2,0,0,255,139,139,0,0,255,0,105,167,2,0,0,61,188,188,143,143,255,0,115,167,2,0,0,62,255,255,193,193,255,0,126,167,2,0,0,62,238,238,180,180,255,0,137,167,2,0,0,62,205,205,155,155,255,0,148,167,2,0,0,62,139,139,105,105,255,0,159,167,2,0,159,181,225,65,105,225,255,0,169,167,2,0,159,183,255,72,118,255,255,0,180,167,2,0,159,183,238,67,110,238,255,0,191,167,2,0,159,182,205,58,95,205,255,0,202,167,2,0,159,183,139,39,64,139,255,0,213,167,2,0,17,220,139,139,69,19,255,0,225,167,2,0,4,138,250,250,128,114,255,0,232,167,2,0,9,150,255,255,140,105,255,0,240,167,2,0,9,150,238,238,130,98,255,0,248,167,2,0,9,150,205,205,112,84,255,0,0,168,2,0,9,150,139,139,76,57,255,0,8,168,2,0,19,154,244,244,164,96,255,0,19,168,2,0,103,170,139,46,139,87,255,0,28,168,2,0,103,171,255,84,255,159,255,0,38,168,2,0,103,171,238,78,238,148,255,0,48,168,2,0,103,171,205,67,205,128,255,0,58,168,2,0,103,170,139,46,139,87,255,0,68,168,2,0,17,16,255,255,245,238,255,0,77,168,2,0,17,16,255,255,245,238,255,0,87,168,2,0,18,17,238,238,229,222,255,0,97,168,2,0,18,17,205,205,197,191,255,0,107,168,2,0,18,16,139,139,134,130,255,0,117,168,2,0,13,183,160,160,82,45,255,0,124,168,2,0,13,184,255,255,130,71,255,0,132,168,2,0,13,184,238,238,121,66,255,0,140,168,2,0,13,184,205,205,104,57,255,0,148,168,2,0,13,185,139,139,71,38,255,0,156,168,2,0,139,108,235,135,206,235,255,0,164,168,2,0,144,120,255,135,206,255,255,0,173,168,2,0,144,120,238,126,192,238,255,0,182,168,2,0,144,120,205,108,166,205,255,0,191,168,2,0,145,119,139,74,112,139,255,0,200,168,2,0,175,143,205,106,90,205,255,0,210,168,2,0,175,144,255,131,111,255,255,0,221,168,2,0,175,144,238,122,103,238,255,0,232,168,2,0,175,144,205,105,89,205,255,0,243,168,2,0,175,144,139,71,60,139,255,0,254,168,2,0,148,56,144,112,128,144,255,0,8,169,2,0,149,56,255,198,226,255,255,0,19,169,2,0,149,56,238,185,211,238,255,0,30,169,2,0,148,57,205,159,182,205,255,0,41,169,2,0,149,56,139,108,123,139,255,0,52,169,2,0,148,56,144,112,128,144,255,0,62,169,2,0,0,5,255,255,250,250,255,0,67,169,2,0,0,5,255,255,250,250,255,0,73,169,2,0,0,5,238,238,233,233,255,0,79,169,2,0,0,4,205,205,201,201,255,0,85,169,2,0,0,3,139,139,137,137,255,0,91,169,2,0,106,255,255,0,255,127,255,0,103,169,2,0,106,255,255,0,255,127,255,0,116,169,2,0,106,255,238,0,238,118,255,0,129,169,2,0,106,255,205,0,205,102,255,0,142,169,2,0,106,255,139,0,139,69,255,0,155,169,2,0,146,155,180,70,130,180,255,0,165,169,2,0,146,156,255,99,184,255,255,0,176,169,2,0,146,156,238,92,172,238,255,0,187,169,2,0,146,156,205,79,148,205,255,0,198,169,2,0,147,155,139,54,100,139,255,0,209,169,2,0,24,84,210,210,180,140,255,0,213,169,2,0,20,176,255,255,165,79,255,0,218,169,2,0,20,176,238,238,154,73,255,0,223,169,2,0,20,176,205,205,133,63,255,0,228,169,2,0,20,176,139,139,90,43,255,0,233,169,2,0,212,29,216,216,191,216,255,0,241,169,2,0,212,30,255,255,225,255,255,0,250,169,2,0,212,30,238,238,210,238,255,0,3,170,2,0,212,29,205,205,181,205,255,0,12,170,2,0,212,29,139,139,123,139,255,0,21,170,2,0,6,184,255,255,99,71,255,0,28,170,2,0,6,184,255,255,99,71,255,0,36,170,2,0,6,184,238,238,92,66,255,0,44,170,2,0,6,184,205,205,79,57,255,0,52,170,2,0,6,185,139,139,54,38,255,0,70,173,2,0,42,0,255,255,255,254,0,0,60,170,2,0,123,182,224,64,224,208,255,0,70,170,2,0,129,255,255,0,245,255,255,0,81,170,2,0,129,255,238,0,229,238,255,0,92,170,2,0,129,255,205,0,197,205,255,0,103,170,2,0,129,255,139,0,134,139,255,0,114,170,2,0,212,115,238,238,130,238,255,0,121,170,2,0,227,215,208,208,32,144,255,0,131,170,2,0,235,193,255,255,62,150,255,0,142,170,2,0,235,192,238,238,58,140,255,0,153,170,2,0,235,192,205,205,50,120,255,0,164,170,2,0,235,192,139,139,34,82,255,0,175,170,2,0,27,68,245,245,222,179,255,0,181,170,2,0,27,69,255,255,231,186,255,0,188,170,2,0,27,68,238,238,216,174,255,0,195,170,2,0,27,68,205,205,186,150,255,0,202,170,2,0,27,67,139,139,126,102,255,0,209,170,2,0,0,0,255,255,255,255,255,0,215,170,2,0,0,0,245,245,245,245,255,0,226,170,2,0,42,255,255,255,255,0,255,0,233,170,2,0,42,255,255,255,255,0,255,0,241,170,2,0,42,255,238,238,238,0,255,0,249,170,2,0,42,255,205,205,205,0,255,0,1,171,2,0,42,255,139,139,139,0,255,0,9,171,2,0,56,192,205,154,205,50,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,175,2,0,228,172,2,0,230,172,2,0,232,172,2,0,234,172,2,0,236,172,2,0,238,172,2,0,240,172,2,0,242,172,2,0,244,172,2,0,246,172,2,0,249,172,2,0,252,172,2,0,255,172,2,0,2,173,2,0,5,173,2,0,8,173,2,0,11,173,2,0,14,173,2,0,17,173,2,0,20,173,2,0,0,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,13,0,0,0,51,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,115,173,2,0,175,174,2,0,8,0,0,0,16,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,16,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,173,185,2,0,165,185,2,0,63,186,2,0,9,0,0,0,69,186,2,0,10,0,0,0,78,186,2,0,11,0,0,0,144,186,2,0,12,0,0,0,150,186,2,0,13,0,0,0,155,186,2,0,14,0,0,0,78,186,2,0,15,0,0,0,35,187,2,0,16,0,0,0,42,187,2,0,17,0,0,0,50,187,2,0,18,0,0,0,57,187,2,0,19,0,0,0,69,187,2,0,20,0,0,0,144,186,2,0,21,0,0,0,81,187,2,0,22,0,0,0,89,187,2,0,23,0,0,0,99,187,2,0,24,0,0,0,113,187,2,0,25,0,0,0,120,187,2,0,26,0,0,0,125,187,2,0,27,0,0,0,128,187,2,0,28,0,0,0,133,187,2,0,29,0,0,0,141,187,2,0,30,0,0,0,147,187,2,0,31,0,0,0,153,187,2,0,32,0,0,0,160,187,2,0,33,0,0,0,166,187,2,0,33,0,0,0,174,187,2,0,34,0,0,0,181,187,2,0,35,0,0,0,78,186,2,0,36,0,0,0,42,187,2,0,17,0,0,0,50,187,2,0,18,0,0,0,172,189,2,0,37,0,0,0,57,187,2,0,19,0,0,0,69,187,2,0,20,0,0,0,144,186,2,0,21,0,0,0,183,189,2,0,38,0,0,0,89,187,2,0,23,0,0,0,99,187,2,0,24,0,0,0,113,187,2,0,25,0,0,0,120,187,2,0,26,0,0,0,125,187,2,0,27,0,0,0,128,187,2,0,28,0,0,0,191,189,2,0,39,0,0,0,141,187,2,0,30,0,0,0,147,187,2,0,31,0,0,0,153,187,2,0,32,0,0,0,160,187,2,0,33,0,0,0,166,187,2,0,33,0,0,0,174,187,2,0,34,0,0,0,181,187,2,0,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,191,2,0,178,191,2,0,191,191,2,0,208,191,2,0,240,191,2,0,255,191,2,0,17,192,2,0,32,192,2,0,52,192,2,0,80,192,2,0,115,192,2,0,132,192,2,0,159,192,2,0,179,192,2,0,217,192,2,0,244,192,2,0,30,193,2,0,77,193,2,0,94,193,2,0,145,193,2,0,168,193,2,0,214,193,2,0,241,193,2,0,36,194,2,0,72,194,2,0,124,194,2,0,169,194,2,0,184,194,2,0,210,194,2,0,248,194,2,0,24,195,2,0,57,195,2,0,91,195,2,0,108,195,2,0,129,195,2,0,145,195,2,0,162,195,2,0,206,195,2,0,30,196,2,0,89,196,2,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,6,0,0,0,7,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,4,254,255,255,135,254,255,255,7,0,0,0,0,0,0,0,0,255,255,127,255,255,255,127,255,255,255,255,255,255,255,243,127,254,253,255,255,255,255,255,127,255,255,255,255,255,255,255,255,15,224,255,255,255,255,49,252,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,1,0,248,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,215,255,255,251,255,255,255,255,127,127,84,253,255,15,0,254,223,255,255,255,255,255,255,255,255,254,223,255,255,255,255,3,0,255,255,255,255,255,255,159,25,255,255,255,207,63,3,0,0,0,0,0,0,254,255,255,255,127,2,254,255,255,255,127,0,0,0,0,0,0,0,0,0,255,255,255,7,7,0,0,0,0,0,254,255,255,7,254,7,0,0,0,0,254,255,255,255,255,255,255,255,255,124,255,127,47,0,96,0,0,0,224,255,255,255,255,255,255,35,0,0,0,255,3,0,0,0,224,159,249,255,255,253,197,3,0,0,0,176,3,0,3,0,224,135,249,255,255,253,109,3,0,0,0,94,0,0,28,0,224,175,251,255,255,253,237,35,0,0,0,0,1,0,0,0,224,159,249,255,255,253,205,35,0,0,0,176,3,0,0,0,224,199,61,214,24,199,191,3,0,0,0,0,0,0,0,0,224,223,253,255,255,253,239,3,0,0,0,0,3,0,0,0,224,223,253,255,255,253,239,3,0,0,0,64,3,0,0,0,224,223,253,255,255,253,255,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,255,127,13,0,63,0,0,0,0,0,0,0,150,37,240,254,174,108,13,32,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,63,0,255,255,255,255,127,0,237,218,7,0,0,0,0,80,1,80,49,130,171,98,44,0,0,0,0,64,0,201,128,245,7,0,0,0,0,8,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,3,255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31,0,0,0,0,64,76,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,254,3,0,0,254,255,255,255,255,255,255,255,255,255,31,0,254,255,255,255,255,255,255,255,255,255,255,7,224,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,255,7,254,255,255,135,254,255,255,7,0,0,0,0,0,0,128,0,255,255,127,255,255,255,127,255,255,255,255,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,1,0,248,3,0,3,0,0,0,0,0,255,255,255,255,255,255,255,255,63,0,0,0,3,0,0,0,192,215,255,255,251,255,255,255,255,127,127,84,253,255,15,0,254,223,255,255,255,255,255,255,255,255,254,223,255,255,255,255,123,0,255,255,255,255,255,255,159,25,255,255,255,207,63,3,0,0,0,0,0,0,254,255,255,255,127,2,254,255,255,255,127,0,254,255,251,255,255,187,22,0,255,255,255,7,7,0,0,0,0,0,254,255,255,7,255,255,7,0,255,3,255,255,255,255,255,255,255,255,255,124,255,127,239,255,255,61,255,3,238,255,255,255,255,255,255,243,255,63,30,255,207,255,0,0,238,159,249,255,255,253,197,211,159,57,128,176,207,255,3,0,228,135,249,255,255,253,109,211,135,57,0,94,192,255,31,0,238,175,251,255,255,253,237,243,191,59,0,0,193,255,0,0,238,159,249,255,255,253,205,243,143,57,192,176,195,255,0,0,236,199,61,214,24,199,191,195,199,61,128,0,128,255,0,0,238,223,253,255,255,253,239,195,223,61,96,0,195,255,0,0,236,223,253,255,255,253,239,195,223,61,96,64,195,255,0,0,236,223,253,255,255,253,255,195,207,61,128,0,195,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,255,127,255,7,255,127,255,3,0,0,0,0,150,37,240,254,174,108,255,59,95,63,255,3,0,0,0,0,0,0,0,3,255,3,160,194,255,254,255,255,255,3,254,255,223,15,191,254,255,63,254,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,31,2,0,0,0,160,0,0,0,254,255,62,0,254,255,255,255,255,255,255,255,255,255,31,102,254,255,255,255,255,255,255,255,255,255,255,119,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,8,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+84472);allocate([22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,0,0,0,0,0,0,0,0,0,1,1,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,45,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,8,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,23,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,0,0,0,0,0,0,0,0,0,1,1,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,45,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,92,116,1,0,204,117,1,0,60,119,1,0,172,120,1,0,172,120,1,0,28,122,1,0,60,119,1,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,6,0,0,0,7,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,23,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,10,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,23,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,8,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,23,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,0,0,0,0,0,0,0,0,0,1,1,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,45,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,16,0,0,0,38,0,0,0,51,0,0,0,52,0,0,0,39,0,0,0,53,0,0,0,17,0,0,0,24,0,0,0,40,0,0,0,11,0,0,0,12,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,23,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,18,0,0,0,47,0,0,0,54,0,0,0,55,0,0,0,48,0,0,0,56,0,0,0,19,0,0,0,25,0,0,0,49,0,0,0,13,0,0,0,14,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,23,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,106,1,0,168,123,1,0,24,125,1,0,136,126,1,0,136,126,1,0,248,127,1,0,24,125,1,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,10,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,29,0,0,0,40,0,0,0,41,0,0,0,30,0,0,0,42,0,0,0,15,0,0,0,23,0,0,0,31,0,0,0,8,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,0,0,0,0,0,0,0,0,0,1,1,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,45,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,16,0,0,0,38,0,0,0,51,0,0,0,52,0,0,0,39,0,0,0,53,0,0,0,17,0,0,0,24,0,0,0,40,0,0,0,11,0,0,0,12,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,18,0,0,0,47,0,0,0,54,0,0,0,55,0,0,0,48,0,0,0,56,0,0,0,19,0,0,0,25,0,0,0,49,0,0,0,13,0,0,0,14,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,21,10,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,12,19,28,30,3,13,31,32,33,34,35,27,26,17,25,25,25,25,25,25,25,25,25,25,22,18,2,14,11,15,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,28,4,28,22,28,24,24,24,24,24,24,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,36,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,22,28,28,28,28,28,28,28,28,28,28,22,28,26,28,28,22,28,28,28,28,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,28,22,22,22,22,22,22,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,33,2,0,127,199,2,0,8,33,2,0,74,199,2,0,136,199,2,0,145,199,2,0,240,199,2,0,246,199,2,0,249,199,2,0,255,199,2,0,154,199,2,0,6,200,2,0,15,200,2,0,23,200,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,184,132,1,0,40,133,1,0,152,133,1,0,152,133,1,0,32,0,0,0,9,0,0,0,10,0,0,0,13,0,0,0,11,0,0,0,12,0,0,0,133,0,0,0,0,32,0,0,1,32,0,0,2,32,0,0,3,32,0,0,4,32,0,0,5,32,0,0,6,32,0,0,8,32,0,0,9,32,0,0,10,32,0,0,40,32,0,0,41,32,0,0,95,32,0,0,0,48,0,0,0,0,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,3,0,0,0,4,0,0,0,4,0,0,0,6,0,0,0,131,249,162,0,68,78,110,0,252,41,21,0,209,87,39,0,221,52,245,0,98,219,192,0,60,153,149,0,65,144,67,0,99,81,254,0,187,222,171,0,183,97,197,0,58,110,36,0,210,77,66,0,73,6,224,0,9,234,46,0,28,146,209,0,235,29,254,0,41,177,28,0,232,62,167,0,245,53,130,0,68,187,46,0,156,233,132,0,180,38,112,0,65,126,95,0,214,145,57,0,83,131,57,0,156,244,57,0,139,95,132,0,40,249,189,0,248,31,59,0,222,255,151,0,15,152,5,0,17,47,239,0,10,90,139,0,109,31,109,0,207,126,54,0,9,203,39,0,70,79,183,0,158,102,63,0,45,234,95,0,186,39,117,0,229,235,199,0,61,123,241,0,247,57,7,0,146,82,138,0,251,107,234,0,31,177,95,0,8,93,141,0,48,3,86,0,123,252,70,0,240,171,107,0,32,188,207,0,54,244,154,0,227,169,29,0,94,97,145,0,8,27,230,0,133,153,101,0,160,20,95,0,141,64,104,0,128,216,255,0,39,115,77,0,6,6,49,0,202,86,21,0,201,168,115,0,123,226,96,0,107,140,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,22,0,0,0,88,241,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,22,0,0,0,80,237,2,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,22,0,0,0,72,233,2,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,110,243,2,0,110,0,0,0,112,243,2,0,114,0,0,0,114,243,2,0,102,0,0,0,116,243,2,0,97,0,0,0,118,243,2,0,101,0,0,0,120,243,2,0,119,0,0,0,122,243,2,0,87,0,0,0,135,243,2,0,115,0,0,0,149,243,2,0,83,0,0,0,161,243,2,0,100,0,0,0,174,243,2,0,68,0,0,0,186,243,2],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+94712);allocate([4,0,4,0,27,0,27,0,32,0,32,0,35,0,33,0,10,0,2,0,22,0,9,0,33,0,33,0,33,0,21,0,28,0,1,0,20,0,20,0,20,0,20,0,20,0,20,0,20,0,8,0,4,0,5,0,27,0,2,0,23,0,27,0,32,0,31,0,30,0,29,0,9,0,19,0,0,0,21,0,18,0,21,0,3,0,7,0,21,0,21,0,20,0,20,0,20,0,20,0,20,0,20,0,20,0,20,0,8,0,4,0,5,0,5,0,6,0,27,0,26,0,24,0,25,0,32,0,7,0,21,0,20,0,20,0,20,0,20,0,20,0,20,0,11,0,20,0,13,0,20,0,12,0,20,0,20,0,20,0,14,0,20,0,20,0,20,0,16,0,20,0,15,0,20,0,17,0,0,0,0,0,0,0,142,0,46,0,47,0,51,0,53,0,48,0,55,0,146,0,230,0,230,0,230,0,230,0,0,0,61,0,125,0,55,0,55,0,230,0,230,0,0,0,40,0,53,0,46,0,50,0,47,0,81,0,0,0,0,0,71,0,0,0,0,0,230,0,81,0,0,0,230,0,230,0,230,0,0,0,230,0,113,0,85,0,230,0,86,0,230,0,0,0,89,0,230,0,0,0,62,0,66,0,75,0,83,0,77,0,86,0,67,0,0,0,0,0,98,0,99,0,230,0,0,0,230,0,230,0,230,0,0,0,0,0,102,0,83,0,95,0,90,0,98,0,98,0,101,0,0,0,108,0,0,0,103,0,0,0,110,0,102,0,104,0,0,0,104,0,120,0,117,0,0,0,116,0,0,0,121,0,0,0,230,0,158,0,165,0,172,0,179,0,182,0,73,0,188,0,195,0,202,0,209,0,216,0,222,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,4,0,7,0,3,0,4,0,5,0,5,0,6,0,6,0,8,0,7,0,7,0,17,0,22,0,18,0,17,0,18,0,8,0,8,0,15,0,15,0,23,0,15,0,24,0,15,0,25,0,26,0,26,0,30,0,22,0,98,0,30,0,5,0,50,0,6,0,34,0,34,0,51,0,23,0,24,0,52,0,25,0,26,0,26,0,42,0,44,0,42,0,44,0,47,0,50,0,47,0,53,0,55,0,51,0,54,0,59,0,60,0,52,0,59,0,60,0,69,0,68,0,34,0,68,0,70,0,56,0,71,0,72,0,53,0,55,0,54,0,73,0,74,0,76,0,41,0,78,0,69,0,80,0,27,0,81,0,82,0,70,0,71,0,84,0,72,0,85,0,16,0,73,0,74,0,86,0,76,0,78,0,88,0,90,0,80,0,81,0,82,0,9,0,2,0,84,0,0,0,0,0,85,0,0,0,0,0,86,0,0,0,0,0,88,0,90,0,93,0,93,0,93,0,93,0,93,0,93,0,93,0,94,0,94,0,94,0,94,0,94,0,94,0,94,0,95,0,95,0,95,0,95,0,95,0,95,0,95,0,96,0,0,0,96,0,96,0,96,0,96,0,96,0,97,0,97,0,99,0,0,0,99,0,99,0,99,0,99,0,99,0,100,0,0,0,100,0,0,0,100,0,100,0,100,0,101,0,0,0,101,0,101,0,101,0,101,0,101,0,102,0,102,0,0,0,102,0,102,0,102,0,102,0,103,0,0,0,103,0,103,0,103,0,103,0,104,0,0,0,104,0,104,0,104,0,104,0,104,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,0,0,92,0,1,0,93,0,93,0,94,0,94,0,95,0,95,0,92,0,92,0,92,0,92,0,92,0,96,0,92,0,92,0,92,0,97,0,92,0,92,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,99,0,100,0,101,0,102,0,102,0,92,0,92,0,103,0,92,0,92,0,92,0,96,0,92,0,92,0,97,0,92,0,97,0,92,0,104,0,97,0,92,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,99,0,100,0,101,0,101,0,92,0,102,0,92,0,92,0,92,0,103,0,104,0,97,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,98,0,0,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,0,0,10,0,11,0,12,0,13,0,14,0,10,0,15,0,16,0,17,0,18,0,19,0,10,0,20,0,21,0,21,0,21,0,22,0,23,0,21,0,24,0,21,0,21,0,25,0,21,0,21,0,21,0,26,0,21,0,21,0,10,0,21,0,21,0,21,0,22,0,23,0,24,0,21,0,21,0,25,0,21,0,21,0,21,0,26,0,21,0,21,0,21,0,21,0,27,0,12,0,12,0,36,0,30,0,30,0,32,0,33,0,32,0,33,0,36,0,37,0,38,0,45,0,50,0,47,0,46,0,42,0,37,0,38,0,40,0,41,0,51,0,42,0,52,0,43,0,53,0,54,0,55,0,60,0,50,0,49,0,61,0,34,0,69,0,34,0,63,0,64,0,70,0,51,0,52,0,71,0,53,0,54,0,55,0,47,0,92,0,42,0,44,0,92,0,69,0,68,0,72,0,74,0,70,0,73,0,92,0,60,0,71,0,92,0,61,0,76,0,92,0,65,0,68,0,77,0,75,0,78,0,79,0,72,0,74,0,73,0,80,0,81,0,82,0,44,0,83,0,76,0,84,0,56,0,85,0,86,0,77,0,78,0,87,0,79,0,88,0,44,0,80,0,81,0,89,0,82,0,83,0,90,0,91,0,84,0,85,0,86,0,92,0,28,0,87,0,92,0,92,0,88,0,92,0,92,0,89,0,92,0,92,0,90,0,91,0,29,0,29,0,29,0,29,0,29,0,29,0,29,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,35,0,35,0,35,0,35,0,35,0,35,0,35,0,39,0,92,0,39,0,39,0,39,0,39,0,39,0,48,0,48,0,57,0,92,0,57,0,57,0,57,0,57,0,57,0,58,0,92,0,58,0,92,0,58,0,58,0,58,0,59,0,92,0,59,0,59,0,59,0,59,0,59,0,62,0,62,0,92,0,62,0,62,0,62,0,62,0,66,0,92,0,66,0,66,0,66,0,66,0,67,0,92,0,67,0,67,0,67,0,67,0,67,0,9,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,92,0,8,0,174,255,209,0,10,0,174,255,174,255,11,0,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,5,0,209,0,174,255,209,0,209,0,209,0,209,0,209,0,209,0,209,0,209,0,174,255,251,255,174,255,14,0,236,255,174,255,174,255,174,255,174,255,209,0,209,0,209,0,209,0,209,0,13,0,37,0,12,0,66,0,16,0,80,0,19,0,109,0,123,0,20,0,152,0,15,0,166,0,195,0,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,23,0,174,255,119,0,174,255,7,0,46,0,174,255,38,0,174,255,23,0,17,0,35,0,174,255,13,0,174,255,174,255,174,255,174,255,58,0,174,255,174,255,53,0,174,255,174,255,174,255,40,0,174,255,7,0,174,255,59,0,69,0,174,255,72,0,174,255,174,255,174,255,174,255,174,255,174,255,174,255,252,255,232,0,246,255,255,255,26,0,0,0,39,0,1,0,50,0,174,255,174,255,2,0,36,0,3,0,47,0,174,255,174,255,174,255,174,255,174,255,254,255,148,0,174,255,9,0,27,0,174,255,188,255,174,255,174,255,175,255,174,255,174,255,174,255,174,255,174,255,174,255,174,255,0,0,0,0,0,0,109,230,236,222,5,0,11,0,0,0,0,0,0,0,73,0,49,1,83,0,127,1,48,1,105,0,120,1,255,0,129,1,83,2,130,1,131,1,132,1,133,1,134,1,84,2,135,1,136,1,137,1,86,2,138,1,87,2,139,1,140,1,142,1,221,1,143,1,89,2,144,1,91,2,145,1,146,1,147,1,96,2,148,1,99,2,150,1,105,2,151,1,104,2,152,1,153,1,156,1,111,2,157,1,114,2,159,1,117,2,166,1,128,2,167,1,168,1,169,1,131,2,172,1,173,1,174,1,136,2,175,1,176,1,177,1,138,2,178,1,139,2,183,1,146,2,184,1,185,1,188,1,189,1,196,1,198,1,196,1,197,1,197,1,198,1,199,1,201,1,199,1,200,1,200,1,201,1,202,1,204,1,202,1,203,1,203,1,204,1,241,1,243,1,241,1,242,1,242,1,243,1,244,1,245,1,246,1,149,1,247,1,191,1,32,2,158,1,134,3,172,3,136,3,173,3,137,3,174,3,138,3,175,3,140,3,204,3,142,3,205,3,143,3,206,3,153,3,69,3,153,3,190,31,163,3,194,3,247,3,248,3,250,3,251,3,96,30,155,30,223,0,223,0,158,30,223,0,89,31,81,31,91,31,83,31,93,31,85,31,95,31,87,31,188,31,179,31,204,31,195,31,236,31,229,31,252,31,243,31,58,2,101,44,59,2,60,2,61,2,154,1,62,2,102,44,65,2,66,2,67,2,128,1,68,2,137,2,69,2,140,2,244,3,184,3,249,3,242,3,253,3,123,3,254,3,124,3,255,3,125,3,192,4,207,4,38,33,201,3,42,33,107,0,43,33,229,0,50,33,78,33,131,33,132,33,96,44,97,44,98,44,107,2,99,44,125,29,100,44,125,2,109,44,81,2,110,44,113,2,111,44,80,2,112,44,82,2,114,44,115,44,117,44,118,44,126,44,63,2,127,44,64,2,242,44,243,44,125,167,121,29,139,167,140,167,141,167,101,2,170,167,102,2,199,16,39,45,205,16,45,45,118,3,119,3,156,3,181,0,146,3,208,3,152,3,209,3,166,3,213,3,160,3,214,3,154,3,240,3,161,3,241,3,149,3,245,3,207,3,215,3,0,0,0,0,65,0,32,26,192,0,32,31,0,1,1,47,50,1,1,5,57,1,1,15,74,1,1,45,121,1,1,5,112,3,1,3,145,3,32,17,163,3,32,9,0,4,80,16,16,4,32,32,96,4,1,33,138,4,1,53,193,4,1,13,208,4,1,63,20,5,1,19,49,5,48,38,160,1,1,5,179,1,1,3,205,1,1,15,222,1,1,17,248,1,1,39,34,2,1,17,216,3,1,23,0,30,1,149,160,30,1,95,8,31,248,8,24,31,248,6,40,31,248,8,56,31,248,8,72,31,248,6,104,31,248,8,136,31,248,8,152,31,248,8,168,31,248,8,184,31,248,2,186,31,182,2,200,31,170,4,216,31,248,2,218,31,156,2,232,31,248,2,234,31,144,2,248,31,128,2,250,31,130,2,70,2,1,9,16,5,1,3,96,33,16,16,0,44,48,47,103,44,1,5,128,44,1,99,235,44,1,3,64,166,1,45,128,166,1,23,34,167,1,13,50,167,1,61,121,167,1,3,126,167,1,9,144,167,1,3,160,167,1,9,33,255,32,26,0,0,0,0,123,32,97,112,112,101,110,100,69,114,114,111,114,40,36,48,41,59,32,125,0,99,111,114,101,0,73,32,0,120,100,111,116,0,100,111,116,58,100,111,116,0,103,118,58,100,111,116,0,99,97,110,111,110,58,100,111,116,0,112,108,97,105,110,58,100,111,116,0,112,108,97,105,110,45,101,120,116,58,100,111,116,0,120,100,111,116,58,120,100,111,116,0,120,100,111,116,49,46,50,58,120,100,111,116,0,120,100,111,116,49,46,52,58,120,100,111,116,0,32,37,100,32,0,0,0,0,0,0,0,0,0,0,0,35,37,48,50,120,37,48,50,120,37,48,50,120,37,48,50,120,0,115,101,116,108,105,110,101,119,105,100,116,104,40,0,37,46,51,102,0,83,32,0,67,32,0,50,32,0,37,115,37,100,32,45,0,69,32,0,101,32,0,70,32,0,116,32,37,117,32,0,84,32,0,120,100,111,116,118,101,114,115,105,111,110,0,49,46,52,0,49,46,50,0,49,46,55,0,95,108,100,114,97,119,95,0,95,104,100,114,97,119,95,0,95,116,100,114,97,119,95,0,95,104,108,100,114,97,119,95,0,95,116,108,100,114,97,119,95,0,120,100,111,116,32,118,101,114,115,105,111,110,32,34,37,115,34,32,116,111,111,32,108,111,110,103,0,37,46,48,50,102,0,102,105,103,0,102,105,103,58,102,105,103,0,35,32,37,115,10,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,110,32,62,61,32,52,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,102,105,103,46,99,0,102,105,103,95,98,101,122,105,101,114,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,100,32,37,100,32,37,100,32,37,100,10,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,51,102,32,37,100,32,37,46,52,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,37,100,32,37,100,32,35,37,48,50,120,37,48,50,120,37,48,50,120,10,0,102,105,103,95,114,101,115,111,108,118,101,95,99,111,108,111,114,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,46,52,102,32,37,100,32,37,46,49,102,32,37,46,49,102,32,37,100,32,37,100,32,37,115,92,48,48,49,10,0,35,32,101,110,100,32,111,102,32,70,73,71,32,102,105,108,101,10,0,35,70,73,71,32,51,46,50,10,0,35,32,71,101,110,101,114,97,116,101,100,32,98,121,32,37,115,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,10,0,35,32,84,105,116,108,101,58,32,37,115,10,0,35,32,80,97,103,101,115,58,32,37,100,10,0,80,111,114,116,114,97,105,116,10,0,67,101,110,116,101,114,10,0,73,110,99,104,101,115,10,0,76,101,116,116,101,114,10,0,49,48,48,46,48,48,10,0,83,105,110,103,108,101,10,0,45,50,10,0,49,50,48,48,0,32,50,10,0,109,97,112,0,105,115,109,97,112,58,109,97,112,0,99,109,97,112,58,109,97,112,0,105,109,97,112,58,109,97,112,0,99,109,97,112,120,58,109,97,112,0,105,109,97,112,95,110,112,58,109,97,112,0,99,109,97,112,120,95,110,112,58,109,97,112,0,114,101,99,116,32,37,115,32,37,100,44,37,100,32,37,100,44,37,100,10,0,99,105,114,99,108,101,32,37,115,32,37,100,44,37,100,44,37,100,10,0,112,111,108,121,32,37,115,0,32,37,100,44,37,100,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,109,97,112,46,99,0,109,97,112,95,111,117,116,112,117,116,95,115,104,97,112,101,0,114,101,99,116,97,110,103,108,101,32,40,37,100,44,37,100,41,32,40,37,100,44,37,100,41,32,37,115,32,37,115,10,0,60,97,114,101,97,32,115,104,97,112,101,61,34,99,105,114,99,108,101,34,0,60,97,114,101,97,32,115,104,97,112,101,61,34,114,101,99,116,34,0,60,97,114,101,97,32,115,104,97,112,101,61,34,112,111,108,121,34,0,32,105,100,61,34,0,32,104,114,101,102,61,34,0,32,116,105,116,108,101,61,34,0,32,97,108,116,61,34,34,0,32,99,111,111,114,100,115,61,34,0,37,100,44,37,100,44,37,100,0,37,100,44,37,100,44,37,100,44,37,100,0,37,100,44,37,100,0,44,37,100,44,37,100,0,34,62,10,0,60,47,109,97,112,62,10,0,98,97,115,101,32,114,101,102,101,114,101,114,10,0,100,101,102,97,117,108,116,32,0,60,109,97,112,32,105,100,61,34,0,34,32,110,97,109,101,61,34,0,112,115,50,58,112,115,0,32,93,32,32,37,100,32,116,114,117,101,32,37,115,10,0,32,93,32,32,37,100,32,102,97,108,115,101,32,37,115,10,0,32,115,101,116,108,105,110,101,119,105,100,116,104,10,0,37,115,32,0,115,101,116,104,115,98,0,37,46,53,103,32,37,46,53,103,32,37,46,53,103,32,37,115,99,111,108,111,114,10,0,37,32,0,110,101,119,112,97,116,104,32,0,32,109,111,118,101,116,111,10,0,32,108,105,110,101,116,111,10,0,115,116,114,111,107,101,10,0,32,99,117,114,118,101,116,111,10,0,99,108,111,115,101,112,97,116,104,32,102,105,108,108,10,0,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,0,32,101,108,108,105,112,115,101,95,112,97,116,104,32,102,105,108,108,10,0,32,101,108,108,105,112,115,101,95,112,97,116,104,32,115,116,114,111,107,101,10,0,32,47,37,115,32,115,101,116,95,102,111,110,116,10,0,32,109,111,118,101,116,111,32,0,32,37,115,32,97,108,105,103,110,101,100,116,101,120,116,10,0,91,32,47,82,101,99,116,32,91,32,0,32,93,10,0,32,32,47,66,111,114,100,101,114,32,91,32,48,32,48,32,48,32,93,10,32,32,47,65,99,116,105,111,110,32,60,60,32,47,83,117,98,116,121,112,101,32,47,85,82,73,32,47,85,82,73,32,37,115,32,62,62,10,32,32,47,83,117,98,116,121,112,101,32,47,76,105,110,107,10,47,65,78,78,32,112,100,102,109,97,114,107,10,0,103,115,97,118,101,10,0,37,37,32,37,115,10,0,48,32,48,32,48,32,101,100,103,101,99,111,108,111,114,10,0,101,110,100,112,97,103,101,10,115,104,111,119,112,97,103,101,10,103,114,101,115,116,111,114,101,10,0,37,37,80,97,103,101,84,114,97,105,108,101,114,10,0,37,37,37,37,69,110,100,80,97,103,101,58,32,37,100,10,0,37,37,37,37,80,97,103,101,58,32,37,100,32,37,100,10,0,37,37,37,37,80,97,103,101,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,76,97,110,100,115,99,97,112,101,0,80,111,114,116,114,97,105,116,0,37,37,37,37,80,97,103,101,79,114,105,101,110,116,97,116,105,111,110,58,32,37,115,10,0,60,60,32,47,80,97,103,101,83,105,122,101,32,91,37,100,32,37,100,93,32,62,62,32,115,101,116,112,97,103,101,100,101,118,105,99,101,10,0,37,100,32,37,100,32,37,100,32,98,101,103,105,110,112,97,103,101,10,0,103,115,97,118,101,10,37,100,32,37,100,32,37,100,32,37,100,32,98,111,120,112,114,105,109,32,99,108,105,112,32,110,101,119,112,97,116,104,10,0,37,103,32,37,103,32,115,101,116,95,115,99,97,108,101,32,37,100,32,114,111,116,97,116,101,32,37,103,32,37,103,32,116,114,97,110,115,108,97,116,101,10,0,99,97,110,118,97,115,32,115,105,122,101,32,40,37,100,44,37,100,41,32,101,120,99,101,101,100,115,32,80,68,70,32,108,105,109,105,116,32,40,37,100,41,10,9,40,115,117,103,103,101,115,116,32,115,101,116,116,105,110,103,32,97,32,98,111,117,110,100,105,110,103,32,98,111,120,32,115,105,122,101,44,32,115,101,101,32,100,111,116,40,49,41,41,10,0,91,32,47,67,114,111,112,66,111,120,32,91,37,100,32,37,100,32,37,100,32,37,100,93,32,47,80,65,71,69,83,32,112,100,102,109,97,114,107,10,0,37,100,32,37,100,32,115,101,116,108,97,121,101,114,10,0,0,37,37,37,37,84,105,116,108,101,58,32,37,115,10,0,37,37,80,97,103,101,115,58,32,40,97,116,101,110,100,41,10,0,37,37,80,97,103,101,115,58,32,49,10,0,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,40,97,116,101,110,100,41,10,0,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,37,37,69,110,100,67,111,109,109,101,110,116,115,10,115,97,118,101,10,0,115,101,116,117,112,76,97,116,105,110,49,10,0,91,32,123,67,97,116,97,108,111,103,125,32,60,60,32,47,85,82,73,32,60,60,32,47,66,97,115,101,32,37,115,32,62,62,32,62,62,10,47,80,85,84,32,112,100,102,109,97,114,107,10,0,37,37,66,101,103,105,110,80,114,111,108,111,103,0,47,68,111,116,68,105,99,116,32,50,48,48,32,100,105,99,116,32,100,101,102,0,68,111,116,68,105,99,116,32,98,101,103,105,110,0,47,115,101,116,117,112,76,97,116,105,110,49,32,123,0,109,97,114,107,0,47,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,50,53,54,32,97,114,114,97,121,32,100,101,102,0,32,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,48,0,73,83,79,76,97,116,105,110,49,69,110,99,111,100,105,110,103,32,48,32,50,53,53,32,103,101,116,105,110,116,101,114,118,97,108,32,112,117,116,105,110,116,101,114,118,97,108,0,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,52,53,32,47,104,121,112,104,101,110,32,112,117,116,0,37,32,83,101,116,32,117,112,32,73,83,79,32,76,97,116,105,110,32,49,32,99,104,97,114,97,99,116,101,114,32,101,110,99,111,100,105,110,103,0,47,115,116,97,114,110,101,116,73,83,79,32,123,0,32,32,32,32,32,32,32,32,100,117,112,32,100,117,112,32,102,105,110,100,102,111,110,116,32,100,117,112,32,108,101,110,103,116,104,32,100,105,99,116,32,98,101,103,105,110,0,32,32,32,32,32,32,32,32,123,32,49,32,105,110,100,101,120,32,47,70,73,68,32,110,101,32,123,32,100,101,102,32,125,123,32,112,111,112,32,112,111,112,32,125,32,105,102,101,108,115,101,0,32,32,32,32,32,32,32,32,125,32,102,111,114,97,108,108,0,32,32,32,32,32,32,32,32,47,69,110,99,111,100,105,110,103,32,69,110,99,111,100,105,110,103,86,101,99,116,111,114,32,100,101,102,0,32,32,32,32,32,32,32,32,99,117,114,114,101,110,116,100,105,99,116,32,101,110,100,32,100,101,102,105,110,101,102,111,110,116,0,125,32,100,101,102,0,47,84,105,109,101,115,45,82,111,109,97,110,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,84,105,109,101,115,45,73,116,97,108,105,99,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,84,105,109,101,115,45,66,111,108,100,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,84,105,109,101,115,45,66,111,108,100,73,116,97,108,105,99,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,72,101,108,118,101,116,105,99,97,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,72,101,108,118,101,116,105,99,97,45,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,72,101,108,118,101,116,105,99,97,45,66,111,108,100,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,72,101,108,118,101,116,105,99,97,45,66,111,108,100,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,67,111,117,114,105,101,114,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,67,111,117,114,105,101,114,45,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,67,111,117,114,105,101,114,45,66,111,108,100,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,47,67,111,117,114,105,101,114,45,66,111,108,100,79,98,108,105,113,117,101,32,115,116,97,114,110,101,116,73,83,79,32,100,101,102,0,99,108,101,97,114,116,111,109,97,114,107,0,125,32,98,105,110,100,32,100,101,102,0,37,37,66,101,103,105,110,82,101,115,111,117,114,99,101,58,32,112,114,111,99,115,101,116,32,103,114,97,112,104,118,105,122,32,48,32,48,0,47,99,111,111,114,100,45,102,111,110,116,45,102,97,109,105,108,121,32,47,84,105,109,101,115,45,82,111,109,97,110,32,100,101,102,0,47,100,101,102,97,117,108,116,45,102,111,110,116,45,102,97,109,105,108,121,32,47,84,105,109,101,115,45,82,111,109,97,110,32,100,101,102,0,47,99,111,111,114,100,102,111,110,116,32,99,111,111,114,100,45,102,111,110,116,45,102,97,109,105,108,121,32,102,105,110,100,102,111,110,116,32,56,32,115,99,97,108,101,102,111,110,116,32,100,101,102,0,47,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,49,46,48,32,100,101,102,0,47,115,101,116,95,115,99,97,108,101,32,123,0,32,32,32,32,32,32,32,100,117,112,32,49,32,101,120,99,104,32,100,105,118,32,47,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,101,120,99,104,32,100,101,102,0,32,32,32,32,32,32,32,115,99,97,108,101,0,37,32,115,116,121,108,101,115,0,47,115,111,108,105,100,32,123,32,91,93,32,48,32,115,101,116,100,97,115,104,32,125,32,98,105,110,100,32,100,101,102,0,47,100,97,115,104,101,100,32,123,32,91,57,32,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,109,117,108,32,100,117,112,32,93,32,48,32,115,101,116,100,97,115,104,32,125,32,98,105,110,100,32,100,101,102,0,47,100,111,116,116,101,100,32,123,32,91,49,32,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,109,117,108,32,54,32,73,110,118,83,99,97,108,101,70,97,99,116,111,114,32,109,117,108,93,32,48,32,115,101,116,100,97,115,104,32,125,32,98,105,110,100,32,100,101,102,0,47,105,110,118,105,115,32,123,47,102,105,108,108,32,123,110,101,119,112,97,116,104,125,32,100,101,102,32,47,115,116,114,111,107,101,32,123,110,101,119,112,97,116,104,125,32,100,101,102,32,47,115,104,111,119,32,123,112,111,112,32,110,101,119,112,97,116,104,125,32,100,101,102,125,32,98,105,110,100,32,100,101,102,0,47,98,111,108,100,32,123,32,50,32,115,101,116,108,105,110,101,119,105,100,116,104,32,125,32,98,105,110,100,32,100,101,102,0,47,102,105,108,108,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,47,117,110,102,105,108,108,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,47,114,111,117,110,100,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,47,100,105,97,103,111,110,97,108,115,32,123,32,125,32,98,105,110,100,32,100,101,102,0,47,116,97,112,101,114,101,100,32,123,32,125,32,98,105,110,100,32,100,101,102,0,37,32,104,111,111,107,115,32,102,111,114,32,115,101,116,116,105,110,103,32,99,111,108,111,114,32,0,47,110,111,100,101,99,111,108,111,114,32,123,32,115,101,116,104,115,98,99,111,108,111,114,32,125,32,98,105,110,100,32,100,101,102,0,47,101,100,103,101,99,111,108,111,114,32,123,32,115,101,116,104,115,98,99,111,108,111,114,32,125,32,98,105,110,100,32,100,101,102,0,47,103,114,97,112,104,99,111,108,111,114,32,123,32,115,101,116,104,115,98,99,111,108,111,114,32,125,32,98,105,110,100,32,100,101,102,0,47,110,111,112,99,111,108,111,114,32,123,112,111,112,32,112,111,112,32,112,111,112,125,32,98,105,110,100,32,100,101,102,0,47,98,101,103,105,110,112,97,103,101,32,123,9,37,32,105,32,106,32,110,112,97,103,101,115,0,9,47,110,112,97,103,101,115,32,101,120,99,104,32,100,101,102,0,9,47,106,32,101,120,99,104,32,100,101,102,0,9,47,105,32,101,120,99,104,32,100,101,102,0,9,47,115,116,114,32,49,48,32,115,116,114,105,110,103,32,100,101,102,0,9,110,112,97,103,101,115,32,49,32,103,116,32,123,0,9,9,103,115,97,118,101,0,9,9,9,99,111,111,114,100,102,111,110,116,32,115,101,116,102,111,110,116,0,9,9,9,48,32,48,32,109,111,118,101,116,111,0,9,9,9,40,92,40,41,32,115,104,111,119,32,105,32,115,116,114,32,99,118,115,32,115,104,111,119,32,40,44,41,32,115,104,111,119,32,106,32,115,116,114,32,99,118,115,32,115,104,111,119,32,40,92,41,41,32,115,104,111,119,0,9,9,103,114,101,115,116,111,114,101,0,9,125,32,105,102,0,47,115,101,116,95,102,111,110,116,32,123,0,9,102,105,110,100,102,111,110,116,32,101,120,99,104,0,9,115,99,97,108,101,102,111,110,116,32,115,101,116,102,111,110,116,0,37,32,100,114,97,119,32,116,101,120,116,32,102,105,116,116,101,100,32,116,111,32,105,116,115,32,101,120,112,101,99,116,101,100,32,119,105,100,116,104,0,47,97,108,105,103,110,101,100,116,101,120,116,32,123,9,9,9,37,32,119,105,100,116,104,32,116,101,120,116,0,9,47,116,101,120,116,32,101,120,99,104,32,100,101,102,0,9,47,119,105,100,116,104,32,101,120,99,104,32,100,101,102,0,9,103,115,97,118,101,0,9,9,119,105,100,116,104,32,48,32,103,116,32,123,0,9,9,9,91,93,32,48,32,115,101,116,100,97,115,104,0,9,9,9,116,101,120,116,32,115,116,114,105,110,103,119,105,100,116,104,32,112,111,112,32,119,105,100,116,104,32,101,120,99,104,32,115,117,98,32,116,101,120,116,32,108,101,110,103,116,104,32,100,105,118,32,48,32,116,101,120,116,32,97,115,104,111,119,0,9,9,125,32,105,102,0,9,103,114,101,115,116,111,114,101,0,47,98,111,120,112,114,105,109,32,123,9,9,9,9,37,32,120,99,111,114,110,101,114,32,121,99,111,114,110,101,114,32,120,115,105,122,101,32,121,115,105,122,101,0,9,9,52,32,50,32,114,111,108,108,0,9,9,109,111,118,101,116,111,0,9,9,50,32,99,111,112,121,0,9,9,101,120,99,104,32,48,32,114,108,105,110,101,116,111,0,9,9,48,32,101,120,99,104,32,114,108,105,110,101,116,111,0,9,9,112,111,112,32,110,101,103,32,48,32,114,108,105,110,101,116,111,0,9,9,99,108,111,115,101,112,97,116,104,0,47,101,108,108,105,112,115,101,95,112,97,116,104,32,123,0,9,47,114,121,32,101,120,99,104,32,100,101,102,0,9,47,114,120,32,101,120,99,104,32,100,101,102,0,9,47,121,32,101,120,99,104,32,100,101,102,0,9,47,120,32,101,120,99,104,32,100,101,102,0,9,109,97,116,114,105,120,32,99,117,114,114,101,110,116,109,97,116,114,105,120,0,9,110,101,119,112,97,116,104,0,9,120,32,121,32,116,114,97,110,115,108,97,116,101,0,9,114,120,32,114,121,32,115,99,97,108,101,0,9,48,32,48,32,49,32,48,32,51,54,48,32,97,114,99,0,9,115,101,116,109,97,116,114,105,120,0,47,101,110,100,112,97,103,101,32,123,32,115,104,111,119,112,97,103,101,32,125,32,98,105,110,100,32,100,101,102,0,47,115,104,111,119,112,97,103,101,32,123,32,125,32,100,101,102,0,47,108,97,121,101,114,99,111,108,111,114,115,101,113,0,9,91,9,37,32,108,97,121,101,114,32,99,111,108,111,114,32,115,101,113,117,101,110,99,101,32,45,32,100,97,114,107,101,115,116,32,116,111,32,108,105,103,104,116,101,115,116,0,9,9,91,48,32,48,32,48,93,0,9,9,91,46,50,32,46,56,32,46,56,93,0,9,9,91,46,52,32,46,56,32,46,56,93,0,9,9,91,46,54,32,46,56,32,46,56,93,0,9,9,91,46,56,32,46,56,32,46,56,93,0,9,93,0,100,101,102,0,47,108,97,121,101,114,108,101,110,32,108,97,121,101,114,99,111,108,111,114,115,101,113,32,108,101,110,103,116,104,32,100,101,102,0,47,115,101,116,108,97,121,101,114,32,123,47,109,97,120,108,97,121,101,114,32,101,120,99,104,32,100,101,102,32,47,99,117,114,108,97,121,101,114,32,101,120,99,104,32,100,101,102,0,9,108,97,121,101,114,99,111,108,111,114,115,101,113,32,99,117,114,108,97,121,101,114,32,49,32,115,117,98,32,108,97,121,101,114,108,101,110,32,109,111,100,32,103,101,116,0,9,97,108,111,97,100,32,112,111,112,32,115,101,116,104,115,98,99,111,108,111,114,0,9,47,110,111,100,101,99,111,108,111,114,32,123,110,111,112,99,111,108,111,114,125,32,100,101,102,0,9,47,101,100,103,101,99,111,108,111,114,32,123,110,111,112,99,111,108,111,114,125,32,100,101,102,0,9,47,103,114,97,112,104,99,111,108,111,114,32,123,110,111,112,99,111,108,111,114,125,32,100,101,102,0,47,111,110,108,97,121,101,114,32,123,32,99,117,114,108,97,121,101,114,32,110,101,32,123,105,110,118,105,115,125,32,105,102,32,125,32,100,101,102,0,47,111,110,108,97,121,101,114,115,32,123,0,9,47,109,121,117,112,112,101,114,32,101,120,99,104,32,100,101,102,0,9,47,109,121,108,111,119,101,114,32,101,120,99,104,32,100,101,102,0,9,99,117,114,108,97,121,101,114,32,109,121,108,111,119,101,114,32,108,116,0,9,99,117,114,108,97,121,101,114,32,109,121,117,112,112,101,114,32,103,116,0,9,111,114,0,9,123,105,110,118,105,115,125,32,105,102,0,47,99,117,114,108,97,121,101,114,32,48,32,100,101,102,0,37,37,69,110,100,82,101,115,111,117,114,99,101,0,37,37,69,110,100,80,114,111,108,111,103,0,37,37,66,101,103,105,110,83,101,116,117,112,0,49,52,32,100,101,102,97,117,108,116,45,102,111,110,116,45,102,97,109,105,108,121,32,115,101,116,95,102,111,110,116,0,49,32,115,101,116,109,105,116,101,114,108,105,109,105,116,0,37,32,47,97,114,114,111,119,108,101,110,103,116,104,32,49,48,32,100,101,102,0,37,32,47,97,114,114,111,119,119,105,100,116,104,32,53,32,100,101,102,0,37,32,109,97,107,101,32,115,117,114,101,32,112,100,102,109,97,114,107,32,105,115,32,104,97,114,109,108,101,115,115,32,102,111,114,32,80,83,45,105,110,116,101,114,112,114,101,116,101,114,115,32,111,116,104,101,114,32,116,104,97,110,32,68,105,115,116,105,108,108,101,114,0,47,112,100,102,109,97,114,107,32,119,104,101,114,101,32,123,112,111,112,125,32,123,117,115,101,114,100,105,99,116,32,47,112,100,102,109,97,114,107,32,47,99,108,101,97,114,116,111,109,97,114,107,32,108,111,97,100,32,112,117,116,125,32,105,102,101,108,115,101,0,37,32,109,97,107,101,32,39,60,60,39,32,97,110,100,32,39,62,62,39,32,115,97,102,101,32,111,110,32,80,83,32,76,101,118,101,108,32,49,32,100,101,118,105,99,101,115,0,47,108,97,110,103,117,97,103,101,108,101,118,101,108,32,119,104,101,114,101,32,123,112,111,112,32,108,97,110,103,117,97,103,101,108,101,118,101,108,125,123,49,125,32,105,102,101,108,115,101,0,50,32,108,116,32,123,0,32,32,32,32,117,115,101,114,100,105,99,116,32,40,60,60,41,32,99,118,110,32,40,91,41,32,99,118,110,32,108,111,97,100,32,112,117,116,0,32,32,32,32,117,115,101,114,100,105,99,116,32,40,62,62,41,32,99,118,110,32,40,91,41,32,99,118,110,32,108,111,97,100,32,112,117,116,0,125,32,105,102,0,37,37,69,110,100,83,101,116,117,112,0,37,37,84,114,97,105,108,101,114,10,0,37,37,37,37,80,97,103,101,115,58,32,37,100,10,0,101,110,100,10,114,101,115,116,111,114,101,10,0,37,37,69,79,70,10,0,37,33,80,83,45,65,100,111,98,101,45,51,46,48,0,32,69,80,83,70,45,51,46,48,10,0,37,37,37,37,67,114,101,97,116,111,114,58,32,37,115,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,10,0,100,97,114,107,98,108,117,101,0,100,97,114,107,99,121,97,110,0,100,97,114,107,103,114,97,121,0,100,97,114,107,103,114,101,121,0,100,97,114,107,109,97,103,101,110,116,97,0,100,97,114,107,114,101,100,0,108,105,103,104,116,103,114,101,101,110,0,60,33,45,45,32,0,60,112,111,108,121,108,105,110,101,0,32,112,111,105,110,116,115,61,34,0,37,103,44,37,103,32,0,34,47,62,10,0,32,102,105,108,108,61,34,0,117,114,108,40,35,108,95,37,100,41,0,117,114,108,40,35,114,95,37,100,41,0,34,32,102,105,108,108,45,111,112,97,99,105,116,121,61,34,37,102,0,34,32,115,116,114,111,107,101,61,34,0,34,32,115,116,114,111,107,101,45,119,105,100,116,104,61,34,37,103,0,34,32,115,116,114,111,107,101,45,100,97,115,104,97,114,114,97,121,61,34,37,115,0,34,32,115,116,114,111,107,101,45,111,112,97,99,105,116,121,61,34,37,102,0,49,44,53,0,53,44,50,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,115,118,103,46,99,0,115,118,103,95,112,114,105,110,116,95,99,111,108,111,114,0,60,112,97,116,104,0,32,100,61,34,0,37,99,37,103,44,37,103,0,60,100,101,102,115,62,10,60,114,97,100,105,97,108,71,114,97,100,105,101,110,116,32,105,100,61,34,114,95,37,100,34,32,99,120,61,34,53,48,37,37,34,32,99,121,61,34,53,48,37,37,34,32,114,61,34,55,53,37,37,34,32,102,120,61,34,37,100,37,37,34,32,102,121,61,34,37,100,37,37,34,62,10,0,60,115,116,111,112,32,111,102,102,115,101,116,61,34,48,34,32,115,116,121,108,101,61,34,115,116,111,112,45,99,111,108,111,114,58,0,59,115,116,111,112,45,111,112,97,99,105,116,121,58,0,49,46,0,59,34,47,62,10,0,60,115,116,111,112,32,111,102,102,115,101,116,61,34,49,34,32,115,116,121,108,101,61,34,115,116,111,112,45,99,111,108,111,114,58,0,59,34,47,62,10,60,47,114,97,100,105,97,108,71,114,97,100,105,101,110,116,62,10,60,47,100,101,102,115,62,10,0,60,100,101,102,115,62,10,60,108,105,110,101,97,114,71,114,97,100,105,101,110,116,32,105,100,61,34,108,95,37,100,34,32,103,114,97,100,105,101,110,116,85,110,105,116,115,61,34,117,115,101,114,83,112,97,99,101,79,110,85,115,101,34,32,0,120,49,61,34,37,103,34,32,121,49,61,34,37,103,34,32,120,50,61,34,37,103,34,32,121,50,61,34,37,103,34,32,62,10,0,60,115,116,111,112,32,111,102,102,115,101,116,61,34,37,46,48,51,102,34,32,115,116,121,108,101,61,34,115,116,111,112,45,99,111,108,111,114,58,0,59,34,47,62,10,60,47,108,105,110,101,97,114,71,114,97,100,105,101,110,116,62,10,60,47,100,101,102,115,62,10,0,60,112,111,108,121,103,111,110,0,37,103,44,37,103,0,60,101,108,108,105,112,115,101,0,32,99,120,61,34,37,103,34,32,99,121,61,34,37,103,34,0,32,114,120,61,34,37,103,34,32,114,121,61,34,37,103,34,0,60,116,101,120,116,0,32,116,101,120,116,45,97,110,99,104,111,114,61,34,115,116,97,114,116,34,0,32,116,101,120,116,45,97,110,99,104,111,114,61,34,101,110,100,34,0,32,116,101,120,116,45,97,110,99,104,111,114,61,34,109,105,100,100,108,101,34,0,32,120,61,34,37,103,34,32,121,61,34,37,103,34,0,32,102,111,110,116,45,102,97,109,105,108,121,61,34,37,115,0,44,37,115,0,32,102,111,110,116,45,119,101,105,103,104,116,61,34,37,115,34,0,32,102,111,110,116,45,115,116,114,101,116,99,104,61,34,37,115,34,0,32,102,111,110,116,45,115,116,121,108,101,61,34,37,115,34,0,32,102,111,110,116,45,102,97,109,105,108,121,61,34,37,115,34,0,32,102,111,110,116,45,119,101,105,103,104,116,61,34,98,111,108,100,34,0,32,102,111,110,116,45,115,116,121,108,101,61,34,105,116,97,108,105,99,34,0,32,116,101,120,116,45,100,101,99,111,114,97,116,105,111,110,61,34,0,37,115,111,118,101,114,108,105,110,101,0,37,115,108,105,110,101,45,116,104,114,111,117,103,104,0,32,98,97,115,101,108,105,110,101,45,115,104,105,102,116,61,34,115,117,112,101,114,34,0,32,98,97,115,101,108,105,110,101,45,115,104,105,102,116,61,34,115,117,98,34,0,32,102,111,110,116,45,115,105,122,101,61,34,37,46,50,102,34,0,32,102,105,108,108,61,34,37,115,34,0,32,102,105,108,108,61,34,35,37,48,50,120,37,48,50,120,37,48,50,120,34,0,115,118,103,95,116,101,120,116,115,112,97,110,0,62,0,60,47,116,101,120,116,62,10,0,60,47,103,62,10,0,60,103,0,32,105,100,61,34,97,95,0,32,120,108,105,110,107,58,104,114,101,102,61,34,0,32,120,108,105,110,107,58,116,105,116,108,101,61,34,0,32,116,97,114,103,101,116,61,34,0,60,103,32,105,100,61,34,0,34,32,99,108,97,115,115,61,34,101,100,103,101,34,62,0,60,116,105,116,108,101,62,0,60,47,116,105,116,108,101,62,10,0,95,37,115,0,34,32,99,108,97,115,115,61,34,110,111,100,101,34,62,0,34,32,99,108,97,115,115,61,34,99,108,117,115,116,101,114,34,62,0,34,32,99,108,97,115,115,61,34,103,114,97,112,104,34,0,32,116,114,97,110,115,102,111,114,109,61,34,115,99,97,108,101,40,37,103,32,37,103,41,32,114,111,116,97,116,101,40,37,100,41,32,116,114,97,110,115,108,97,116,101,40,37,103,32,37,103,41,34,62,10,0,34,32,99,108,97,115,115,61,34,108,97,121,101,114,34,62,10,0,60,47,115,118,103,62,10,0,60,33,45,45,0,32,80,97,103,101,115,58,32,37,100,32,45,45,62,10,0,60,115,118,103,32,119,105,100,116,104,61,34,37,100,112,116,34,32,104,101,105,103,104,116,61,34,37,100,112,116,34,10,0,32,118,105,101,119,66,111,120,61,34,37,46,50,102,32,37,46,50,102,32,37,46,50,102,32,37,46,50,102,34,0,32,120,109,108,110,115,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,115,118,103,34,0,32,120,109,108,110,115,58,120,108,105,110,107,61,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,120,108,105,110,107,34,0,60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,32,115,116,97,110,100,97,108,111,110,101,61,34,110,111,34,63,62,10,0,115,116,121,108,101,115,104,101,101,116,0,60,63,120,109,108,45,115,116,121,108,101,115,104,101,101,116,32,104,114,101,102,61,34,0,34,32,116,121,112,101,61,34,116,101,120,116,47,99,115,115,34,63,62,10,0,60,33,68,79,67,84,89,80,69,32,115,118,103,32,80,85,66,76,73,67,32,34,45,47,47,87,51,67],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+101982);allocate([47,47,68,84,68,32,83,86,71,32,49,46,49,47,47,69,78,34,10,0,32,34,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,71,114,97,112,104,105,99,115,47,83,86,71,47,49,46,49,47,68,84,68,47,115,118,103,49,49,46,100,116,100,34,62,10,0,60,33,45,45,32,71,101,110,101,114,97,116,101,100,32,98,121,32,0,116,107,0,116,107,58,116,107,0,35,32,0,32,99,114,101,97,116,101,32,108,105,110,101,32,0,32,45,102,105,108,108,32,0,32,45,100,97,115,104,32,53,0,32,45,100,97,115,104,32,50,0,103,114,97,112,104,32,108,97,98,101,108,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,116,107,46,99,0,116,107,103,101,110,95,112,114,105,110,116,95,116,97,103,115,0,32,45,116,97,103,115,32,123,37,100,37,115,37,100,125,0,116,107,103,101,110,95,112,114,105,110,116,95,99,111,108,111,114,0,36,99,0,32,45,119,105,100,116,104,32,0,32,45,115,109,111,111,116,104,32,98,101,122,105,101,114,32,0,32,99,114,101,97,116,101,32,112,111,108,121,103,111,110,32,0,32,45,111,117,116,108,105,110,101,32,0,32,99,114,101,97,116,101,32,111,118,97,108,32,0,32,99,114,101,97,116,101,32,116,101,120,116,32,0,32,45,116,101,120,116,32,123,0,125,0,32,45,102,111,110,116,32,123,0,32,37,100,125,0,32,45,97,110,99,104,111,114,32,119,0,32,45,97,110,99,104,111,114,32,101,0,35,0,32,84,105,116,108,101,58,32,0,32,80,97,103,101,115,58,32,37,100,10,0,35,32,71,101,110,101,114,97,116,101,100,32,98,121,32,0,41,10,0,69,114,114,111,114,32,100,117,114,105,110,103,32,99,111,110,118,101,114,115,105,111,110,32,116,111,32,34,85,84,70,45,56,34,46,32,32,81,117,105,116,105,110,103,46,10,0,118,109,108,0,118,109,108,58,118,109,108,0,97,113,117,97,0,102,117,99,104,115,105,97,0,108,105,109,101,0,111,108,105,118,101,0,116,101,97,108,0,32,32,32,32,32,32,60,33,45,45,32,0,32,45,45,62,10,0,32,60,118,58,115,104,97,112,101,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,0,32,119,105,100,116,104,58,32,37,100,59,32,104,101,105,103,104,116,58,32,37,100,34,32,102,105,108,108,101,100,61,34,102,97,108,115,101,34,62,0,60,118,58,112,97,116,104,32,118,61,34,0,32,109,32,0,37,46,48,102,44,37,46,48,102,32,0,32,108,32,0,32,101,32,0,34,47,62,0,60,47,118,58,115,104,97,112,101,62,10,0,60,118,58,115,116,114,111,107,101,32,99,111,108,111,114,61,34,0,34,32,119,101,105,103,104,116,61,34,37,46,48,102,112,116,0,34,32,100,97,115,104,115,116,121,108,101,61,34,100,97,115,104,0,34,32,100,97,115,104,115,116,121,108,101,61,34,100,111,116,0,34,32,47,62,0,35,37,48,50,120,37,48,50,120,37,48,50,120,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,118,109,108,46,99,0,118,109,108,95,112,114,105,110,116,95,99,111,108,111,114,0,32,119,105,100,116,104,58,32,37,100,59,32,104,101,105,103,104,116,58,32,37,100,34,0,32,62,0,60,118,58,112,97,116,104,32,32,118,61,34,0,47,62,60,47,118,58,115,104,97,112,101,62,10,0,109,32,0,37,115,37,46,48,102,44,37,46,48,102,32,0,99,32,0,32,102,105,108,108,101,100,61,34,116,114,117,101,34,32,102,105,108,108,99,111,108,111,114,61,34,0,34,32,0,32,102,105,108,108,101,100,61,34,102,97,108,115,101,34,32,0,37,46,48,102,32,37,46,48,102,32,0,108,32,0,120,32,101,32,34,47,62,0,32,32,60,118,58,111,118,97,108,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,0,32,108,101,102,116,58,32,37,46,50,102,59,32,116,111,112,58,32,37,46,50,102,59,0,32,119,105,100,116,104,58,32,37,46,50,102,59,32,104,101,105,103,104,116,58,32,37,46,50,102,34,0,60,47,118,58,111,118,97,108,62,10,0,60,118,58,114,101,99,116,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,0,32,115,116,114,111,107,101,100,61,34,102,97,108,115,101,34,32,102,105,108,108,101,100,61,34,102,97,108,115,101,34,62,10,0,60,118,58,116,101,120,116,98,111,120,32,105,110,115,101,116,61,34,48,44,48,44,48,44,48,34,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,118,45,116,101,120,116,45,119,114,97,112,112,105,110,103,58,39,102,97,108,115,101,39,59,112,97,100,100,105,110,103,58,39,48,39,59,0,102,111,110,116,45,102,97,109,105,108,121,58,32,39,37,115,39,59,0,102,111,110,116,45,119,101,105,103,104,116,58,32,37,115,59,0,102,111,110,116,45,115,116,114,101,116,99,104,58,32,37,115,59,0,102,111,110,116,45,115,116,121,108,101,58,32,37,115,59,0,32,102,111,110,116,45,115,105,122,101,58,32,37,46,50,102,112,116,59,0,99,111,108,111,114,58,37,115,59,0,99,111,108,111,114,58,35,37,48,50,120,37,48,50,120,37,48,50,120,59,0,118,109,108,95,116,101,120,116,115,112,97,110,0,34,62,60,99,101,110,116,101,114,62,0,60,47,99,101,110,116,101,114,62,60,47,118,58,116,101,120,116,98,111,120,62,10,0,60,47,118,58,114,101,99,116,62,10,0,60,47,97,62,10,0,60,97,0,32,104,114,101,102,61,34,37,115,34,0,32,116,105,116,108,101,61,34,37,115,34,0,32,116,97,114,103,101,116,61,34,37,115,34,0,62,10,0,60,47,118,58,103,114,111,117,112,62,10,0,60,47,68,73,86,62,10,0,60,68,73,86,32,105,100,61,39,95,86,77,76,50,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,118,105,115,105,98,105,108,105,116,121,58,104,105,100,100,101,110,34,62,10,0,60,33,45,45,32,105,110,115,101,114,116,32,97,110,121,32,111,116,104,101,114,32,104,116,109,108,32,99,111,110,116,101,110,116,32,104,101,114,101,32,45,45,62,10,0,60,68,73,86,32,105,100,61,39,95,110,111,116,86,77,76,49,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,34,62,10,0,60,33,45,45,32,116,104,105,115,32,115,104,111,117,108,100,32,111,110,108,121,32,100,105,115,112,108,97,121,32,111,110,32,78,79,78,45,73,69,32,98,114,111,119,115,101,114,115,32,45,45,62,10,0,60,72,50,62,83,111,114,114,121,44,32,116,104,105,115,32,100,105,97,103,114,97,109,32,119,105,108,108,32,111,110,108,121,32,100,105,115,112,108,97,121,32,99,111,114,114,101,99,116,108,121,32,111,110,32,73,110,116,101,114,110,101,116,32,69,120,112,108,111,114,101,114,32,53,32,40,97,110,100,32,117,112,41,32,98,114,111,119,115,101,114,115,46,60,47,72,50,62,10,0,60,68,73,86,32,105,100,61,39,95,110,111,116,86,77,76,50,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,34,62,10,0,60,33,45,45,32,105,110,115,101,114,116,32,97,110,121,32,111,116,104,101,114,32,78,79,78,45,73,69,32,104,116,109,108,32,99,111,110,116,101,110,116,32,104,101,114,101,32,45,45,62,10,0,60,47,66,79,68,89,62,10,60,47,72,84,77,76,62,10,0,60,72,69,65,68,62,0,60,77,69,84,65,32,104,116,116,112,45,101,113,117,105,118,61,34,67,111,110,116,101,110,116,45,84,121,112,101,34,32,99,111,110,116,101,110,116,61,34,116,101,120,116,47,104,116,109,108,59,32,99,104,97,114,115,101,116,61,85,84,70,45,56,34,62,10,0,60,84,73,84,76,69,62,0,60,47,84,73,84,76,69,62,0,60,33,45,45,32,80,97,103,101,115,58,32,37,100,32,45,45,62,10,0,32,32,32,60,83,67,82,73,80,84,32,76,65,78,71,85,65,71,69,61,39,74,97,118,97,115,99,114,105,112,116,39,62,10,0,32,32,32,102,117,110,99,116,105,111,110,32,98,114,111,119,115,101,114,99,104,101,99,107,40,41,10,0,32,32,32,123,10,0,32,32,32,32,32,32,118,97,114,32,117,97,32,61,32,119,105,110,100,111,119,46,110,97,118,105,103,97,116,111,114,46,117,115,101,114,65,103,101,110,116,10,0,32,32,32,32,32,32,118,97,114,32,109,115,105,101,32,61,32,117,97,46,105,110,100,101,120,79,102,32,40,32,39,77,83,73,69,32,39,32,41,10,0,32,32,32,32,32,32,118,97,114,32,105,101,118,101,114,115,59,10,0,32,32,32,32,32,32,118,97,114,32,105,116,101,109,59,10,0,32,32,32,32,32,32,118,97,114,32,86,77,76,121,101,115,61,110,101,119,32,65,114,114,97,121,40,39,95,86,77,76,49,95,39,44,39,95,86,77,76,50,95,39,41,59,10,0,32,32,32,32,32,32,118,97,114,32,86,77,76,110,111,61,110,101,119,32,65,114,114,97,121,40,39,95,110,111,116,86,77,76,49,95,39,44,39,95,110,111,116,86,77,76,50,95,39,41,59,10,0,32,32,32,32,32,32,105,102,32,40,32,109,115,105,101,32,62,32,48,32,41,123,32,32,32,32,32,32,47,47,32,73,102,32,73,110,116,101,114,110,101,116,32,69,120,112,108,111,114,101,114,44,32,114,101,116,117,114,110,32,118,101,114,115,105,111,110,32,110,117,109,98,101,114,10,0,32,32,32,32,32,32,32,32,32,105,101,118,101,114,115,61,32,112,97,114,115,101,73,110,116,32,40,117,97,46,115,117,98,115,116,114,105,110,103,32,40,109,115,105,101,43,53,44,32,117,97,46,105,110,100,101,120,79,102,32,40,39,46,39,44,32,109,115,105,101,32,41,41,41,10,0,32,32,32,32,32,32,125,10,0,32,32,32,32,32,32,105,102,32,40,105,101,118,101,114,115,62,61,53,41,123,10,0,32,32,32,32,32,32,32,102,111,114,32,40,120,32,105,110,32,86,77,76,121,101,115,41,123,10,0,32,32,32,32,32,32,32,32,32,105,116,101,109,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,86,77,76,121,101,115,91,120,93,41,59,10,0,32,32,32,32,32,32,32,32,32,105,102,32,40,105,116,101,109,41,32,123,10,0,32,32,32,32,32,32,32,32,32,32,32,105,116,101,109,46,115,116,121,108,101,46,118,105,115,105,98,105,108,105,116,121,61,39,118,105,115,105,98,108,101,39,59,10,0,32,32,32,32,32,32,32,32,32,125,10,0,32,32,32,32,32,32,32,125,10,0,32,32,32,32,32,32,32,102,111,114,32,40,120,32,105,110,32,86,77,76,110,111,41,123,10,0,32,32,32,32,32,32,32,32,32,105,116,101,109,32,61,32,100,111,99,117,109,101,110,116,46,103,101,116,69,108,101,109,101,110,116,66,121,73,100,40,86,77,76,110,111,91,120,93,41,59,10,0,32,32,32,32,32,32,32,32,32,32,32,105,116,101,109,46,115,116,121,108,101,46,118,105,115,105,98,105,108,105,116,121,61,39,104,105,100,100,101,110,39,59,10,0,32,32,32,32,32,125,101,108,115,101,123,10,0,32,32,32,32,32,125,10,0,32,32,32,125,10,0,32,32,32,60,47,83,67,82,73,80,84,62,10,0,60,47,72,69,65,68,62,0,60,66,79,68,89,32,111,110,108,111,97,100,61,39,98,114,111,119,115,101,114,99,104,101,99,107,40,41,59,39,62,10,0,60,68,73,86,32,105,100,61,39,95,86,77,76,49,95,39,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,32,100,105,115,112,108,97,121,58,105,110,108,105,110,101,59,32,118,105,115,105,98,105,108,105,116,121,58,104,105,100,100,101,110,0,32,119,105,100,116,104,58,32,37,100,112,116,59,32,104,101,105,103,104,116,58,32,37,100,112,116,34,62,10,0,60,83,84,89,76,69,62,10,0,118,92,58,42,32,123,32,98,101,104,97,118,105,111,114,58,32,117,114,108,40,35,100,101,102,97,117,108,116,35,86,77,76,41,59,100,105,115,112,108,97,121,58,105,110,108,105,110,101,45,98,108,111,99,107,125,10,0,60,47,83,84,89,76,69,62,10,0,60,120,109,108,58,110,97,109,101,115,112,97,99,101,32,110,115,61,34,117,114,110,58,115,99,104,101,109,97,115,45,109,105,99,114,111,115,111,102,116,45,99,111,109,58,118,109,108,34,32,112,114,101,102,105,120,61,34,118,34,32,47,62,10,0,32,60,118,58,103,114,111,117,112,32,115,116,121,108,101,61,34,112,111,115,105,116,105,111,110,58,114,101,108,97,116,105,118,101,59,32,0,32,119,105,100,116,104,58,32,37,100,112,116,59,32,104,101,105,103,104,116,58,32,37,100,112,116,34,0,32,99,111,111,114,100,111,114,105,103,105,110,61,34,48,44,48,34,32,99,111,111,114,100,115,105,122,101,61,34,37,100,44,37,100,34,32,62,0,60,72,84,77,76,62,10,0,10,60,33,45,45,32,71,101,110,101,114,97,116,101,100,32,98,121,32,0,32,118,101,114,115,105,111,110,32,0,32,40,0,41,10,45,45,62,10,0,112,111,118,32,114,101,110,100,101,114,101,114,58,101,108,32,45,32,37,115,10,0,112,111,118,0,112,111,118,58,112,111,118,0,98,97,107,101,114,115,99,104,111,99,0,98,114,97,115,115,0,98,114,105,103,104,116,103,111,108,100,0,98,114,111,110,122,101,0,98,114,111,110,122,101,50,0,99,108,101,97,114,0,99,111,111,108,99,111,112,112,101,114,0,99,111,112,112,101,114,0,100,97,114,107,98,114,111,119,110,0,100,97,114,107,112,117,114,112,108,101,0,100,97,114,107,116,97,110,0,100,97,114,107,119,111,111,100,0,100,107,103,114,101,101,110,99,111,112,112,101,114,0,100,117,115,116,121,114,111,115,101,0,102,101,108,100,115,112,97,114,0,102,108,101,115,104,0,103,114,97,121,48,53,0,103,114,101,101,110,99,111,112,112,101,114,0,104,117,110,116,101,114,115,103,114,101,101,110,0,108,105,103,104,116,95,112,117,114,112,108,101,0,108,105,103,104,116,119,111,111,100,0,109,97,110,100,97,114,105,110,111,114,97,110,103,101,0,109,101,100,105,117,109,102,111,114,101,115,116,103,114,101,101,110,0,109,101,100,105,117,109,103,111,108,100,101,110,114,111,100,0,109,101,100,105,117,109,119,111,111,100,0,109,101,100,95,112,117,114,112,108,101,0,109,105,99,97,0,110,101,111,110,98,108,117,101,0,110,101,111,110,112,105,110,107,0,110,101,119,109,105,100,110,105,103,104,116,98,108,117,101,0,110,101,119,116,97,110,0,111,108,100,103,111,108,100,0,113,117,97,114,116,122,0,114,105,99,104,98,108,117,101,0,115,99,97,114,108,101,116,0,115,101,109,105,83,119,101,101,116,67,104,111,99,0,115,105,108,118,101,114,0,115,112,105,99,121,112,105,110,107,0,115,117,109,109,101,114,115,107,121,0,118,101,114,121,100,97,114,107,98,114,111,119,110,0,118,101,114,121,95,108,105,103,104,116,95,112,117,114,112,108,101,0,47,47,42,42,42,32,99,111,109,109,101,110,116,58,32,37,115,10,0,47,47,42,42,42,32,112,111,108,121,108,105,110,101,10,0,115,99,97,108,101,32,32,32,32,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,10,0,114,111,116,97,116,101,32,32,32,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,10,0,116,114,97,110,115,108,97,116,101,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,10,0,115,112,104,101,114,101,95,115,119,101,101,112,32,123,10,32,32,32,32,37,115,10,32,32,32,32,37,100,44,10,0,108,105,110,101,97,114,95,115,112,108,105,110,101,0,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,44,32,37,46,51,102,10,0,37,115,32,32,32,32,37,115,0,32,32,32,32,116,111,108,101,114,97,110,99,101,32,48,46,48,49,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,37,115,37,115,0,37,115,32,116,114,97,110,115,109,105,116,32,37,46,51,102,0,82,101,100,0,71,114,101,101,110,0,66,108,117,101,0,114,103,98,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,32,116,114,97,110,115,109,105,116,32,37,46,51,102,0,111,111,112,115,44,32,105,110,116,101,114,110,97,108,32,101,114,114,111,114,58,32,117,110,104,97,110,100,108,101,100,32,99,111,108,111,114,32,116,121,112,101,61,37,100,32,37,115,10,0,103,118,114,101,110,100,101,114,95,99,111,114,101,95,112,111,118,46,99,0,112,111,118,95,99,111,108,111,114,95,97,115,95,115,116,114,0,112,105,103,109,101,110,116,32,123,32,99,111,108,111,114,32,37,115,32,125,10,0,47,47,42,42,42,32,98,101,122,105,101,114,10,0,98,95,115,112,108,105,110,101,0,32,32,32,32,32,32,32,32,116,111,108,101,114,97,110,99,101,32,48,46,48,49,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,47,47,42,42,42,32,112,111,108,121,103,111,110,10,0,32,32,32,32,116,111,108,101,114,97,110,99,101,32,48,46,49,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,112,111,108,121,103,111,110,32,123,32,37,100,44,10,0,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,0,37,115,10,32,32,32,32,37,115,0,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,47,47,42,42,42,32,101,108,108,105,112,115,101,10,0,116,111,114,117,115,32,123,32,37,46,51,102,44,32,37,46,51,102,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,115,112,104,101,114,101,32,123,60,37,57,46,51,102,44,32,37,57,46,51,102,44,32,37,57,46,51,102,62,44,32,49,46,48,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,47,47,42,42,42,32,116,101,120,116,115,112,97,110,58,32,37,115,44,32,102,111,110,116,115,105,122,101,32,61,32,37,46,51,102,44,32,102,111,110,116,110,97,109,101,32,61,32,37,115,10,0,115,99,97,108,101,32,37,46,51,102,10,0,116,101,120,116,32,123,10,32,32,32,32,116,116,102,32,34,37,115,34,44,10,32,32,32,32,34,37,115,34,44,32,37,46,51,102,44,32,37,46,51,102,10,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,32,32,32,32,37,115,125,10,0,32,32,32,32,110,111,95,115,104,97,100,111,119,10,0,47,47,42,42,42,32,101,110,100,95,101,100,103,101,10,0,47,47,42,42,42,32,98,101,103,105,110,95,101,100,103,101,10,0,47,47,42,42,42,32,101,110,100,95,110,111,100,101,10,0,47,47,42,42,42,32,98,101,103,105,110,95,110,111,100,101,58,32,37,115,10,0,47,47,42,42,42,32,101,110,100,95,99,108,117,115,116,101,114,10,0,47,47,42,42,42,32,98,101,103,105,110,95,99,108,117,115,116,101,114,10,0,47,47,42,42,42,32,101,110,100,95,112,97,103,101,10,0,47,47,42,42,42,32,98,101,103,105,110,95,112,97,103,101,10,0,47,47,42,42,42,32,101,110,100,95,108,97,121,101,114,10,0,47,47,42,42,42,32,98,101,103,105,110,95,108,97,121,101,114,58,32,37,115,44,32,37,100,47,37,100,10,0,47,47,42,42,42,32,101,110,100,95,103,114,97,112,104,10,0,47,47,42,42,42,32,98,101,103,105,110,95,103,114,97,112,104,32,37,115,10,0,99,97,109,101,114,97,32,123,32,108,111,99,97,116,105,111,110,32,60,37,46,51,102,32,44,32,37,46,51,102,32,44,32,37,46,51,102,62,10,32,32,32,32,32,32,32,32,32,108,111,111,107,95,97,116,32,32,60,37,46,51,102,32,44,32,37,46,51,102,32,44,32,37,46,51,102,62,10,32,32,32,32,32,32,32,32,32,114,105,103,104,116,32,120,32,42,32,105,109,97,103,101,95,119,105,100,116,104,32,47,32,105,109,97,103,101,95,104,101,105,103,104,116,10,32,32,32,32,32,32,32,32,32,97,110,103,108,101,32,37,46,51,102,10,125,10,0,47,47,115,107,121,10,112,108,97,110,101,32,123,32,60,48,44,32,49,44,32,48,62,44,32,49,32,104,111,108,108,111,119,10,32,32,32,32,116,101,120,116,117,114,101,32,123,10,32,32,32,32,32,32,32,32,112,105,103,109,101,110,116,32,123,32,98,111,122,111,32,116,117,114,98,117,108,101,110,99,101,32,48,46,57,53,10,32,32,32,32,32,32,32,32,32,32,32,32,99,111,108,111,114,95,109,97,112,32,123,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,91,48,46,48,48,32,114,103,98,32,60,48,46,48,53,44,32,48,46,50,48,44,32,48,46,53,48,62,93,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,91,48,46,53,48,32,114,103,98,32,60,48,46,48,53,44,32,48,46,50,48,44,32,48,46,53,48,62,93,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,91,48,46,55,53,32,114,103,98,32,60,49,46,48,48,44,32,49,46,48,48,44,32,49,46,48,48,62,93,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,91,48,46,55,53,32,114,103,98,32,60,48,46,50,53,44,32,48,46,50,53,44,32,48,46,50,53,62,93,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,91,49,46,48,48,32,114,103,98,32,60,48,46,53,48,44,32,48,46,53,48,44,32,48,46,53,48,62,93,10,32,32,32,32,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,32,32,32,32,115,99,97,108,101,32,60,49,46,48,48,44,32,49,46,48,48,44,32,49,46,53,48,62,32,42,32,50,46,53,48,10,32,32,32,32,32,32,32,32,32,32,32,32,116,114,97,110,115,108,97,116,101,32,60,48,46,48,48,44,32,48,46,48,48,44,32,48,46,48,48,62,10,32,32,32,32,32,32,32,32,125,10,32,32,32,32,32,32,32,32,102,105,110,105,115,104,32,123,32,97,109,98,105,101,110,116,32,49,32,100,105,102,102,117,115,101,32,48,32,125,10,32,32,32,32,125,10,32,32,32,32,115,99,97,108,101,32,49,48,48,48,48,10,125,10,47,47,109,105,115,116,10,102,111,103,32,123,32,102,111,103,95,116,121,112,101,32,50,10,32,32,32,32,100,105,115,116,97,110,99,101,32,53,48,10,32,32,32,32,99,111,108,111,114,32,114,103,98,32,60,49,46,48,48,44,32,49,46,48,48,44,32,49,46,48,48,62,32,42,32,48,46,55,53,10,32,32,32,32,102,111,103,95,111,102,102,115,101,116,32,48,46,49,48,10,32,32,32,32,102,111,103,95,97,108,116,32,49,46,53,48,10,32,32,32,32,116,117,114,98,117,108,101,110,99,101,32,49,46,55,53,10,125,10,47,47,103,110,100,10,112,108,97,110,101,32,123,32,60,48,46,48,48,44,32,49,46,48,48,44,32,48,46,48,48,62,44,32,48,10,32,32,32,32,116,101,120,116,117,114,101,32,123,10,32,32,32,32,32,32,32,32,112,105,103,109,101,110,116,123,32,99,111,108,111,114,32,114,103,98,32,60,48,46,50,53,44,32,48,46,52,53,44,32,48,46,48,48,62,32,125,10,32,32,32,32,32,32,32,32,110,111,114,109,97,108,32,123,32,98,117,109,112,115,32,48,46,55,53,32,115,99,97,108,101,32,48,46,48,49,32,125,10,32,32,32,32,32,32,32,32,102,105,110,105,115,104,32,123,32,112,104,111,110,103,32,48,46,49,48,32,125,10,32,32,32,32,125,10,125,10,0,108,105,103,104,116,95,115,111,117,114,99,101,32,123,32,60,49,53,48,48,44,51,48,48,48,44,45,50,53,48,48,62,32,99,111,108,111,114,32,87,104,105,116,101,32,125,10,0,35,118,101,114,115,105,111,110,32,51,46,54,59,10,0,103,108,111,98,97,108,95,115,101,116,116,105,110,103,115,32,123,32,97,115,115,117,109,101,100,95,103,97,109,109,97,32,49,46,48,32,125,10,0,35,100,101,102,97,117,108,116,32,123,32,102,105,110,105,115,104,32,123,32,97,109,98,105,101,110,116,32,48,46,49,32,100,105,102,102,117,115,101,32,48,46,57,32,125,32,125,10,0,35,105,110,99,108,117,100,101,32,34,99,111,108,111,114,115,46,105,110,99,34,10,35,105,110,99,108,117,100,101,32,34,116,101,120,116,117,114,101,115,46,105,110,99,34,10,35,105,110,99,108,117,100,101,32,34,115,104,97,112,101,115,46,105,110,99,34,10,0,35,100,101,99,108,97,114,101,32,37,115,32,61,32,37,115,59,10,0,66,108,97,99,107,0,87,104,105,116,101,0,112,105,99,0,112,105,99,58,112,105,99,0,37,115,32,37,115,10,0,46,92,34,32,0,32,37,100,32,37,100,0,32,37,115,10,0,32,37,100,0,102,105,108,108,32,0,101,108,108,105,112,115,101,32,97,116,116,114,115,37,100,32,37,115,119,105,100,32,37,46,53,102,32,104,116,32,37,46,53,102,32,97,116,32,40,37,46,53,102,44,37,46,53,102,41,59,10,0,46,102,116,32,37,115,10,0,46,112,115,32,37,100,42,92,110,40,83,70,117,47,37,46,48,102,117,10,0,34,37,115,34,32,97,116,32,40,37,46,53,102,44,37,46,53,102,41,59,10,0,37,48,51,111,0,37,115,37,115,32,105,115,32,110,111,116,32,97,32,116,114,111,102,102,32,102,111,110,116,10,0,100,111,116,32,112,105,99,32,112,108,117,103,105,110,58,32,0,82,0,93,10,46,80,69,10,0,46,80,83,32,37,46,53,102,32,37,46,53,102,10,0,37,115,32,116,111,32,99,104,97,110,103,101,32,100,114,97,119,105,110,103,32,115,105,122,101,44,32,109,117,108,116,105,112,108,121,32,116,104,101,32,119,105,100,116,104,32,97,110,100,32,104,101,105,103,104,116,32,111,110,32,116,104,101,32,46,80,83,32,108,105,110,101,32,97,98,111,118,101,32,97,110,100,32,116,104,101,32,110,117,109,98,101,114,32,111,110,32,116,104,101,32,116,119,111,32,108,105,110,101,115,32,98,101,108,111,119,32,40,114,111,117,110,100,101,100,32,116,111,32,116,104,101,32,110,101,97,114,101,115,116,32,105,110,116,101,103,101,114,41,32,98,121,32,97,32,115,99,97,108,101,32,102,97,99,116,111,114,10,0,46,110,114,32,83,70,32,37,46,48,102,10,115,99,97,108,101,116,104,105,99,107,110,101,115,115,32,61,32,37,46,48,102,10,0,37,115,32,100,111,110,39,116,32,99,104,97,110,103,101,32,97,110,121,116,104,105,110,103,32,98,101,108,111,119,32,116,104,105,115,32,108,105,110,101,32,105,110,32,116,104,105,115,32,100,114,97,119,105,110,103,10,0,37,115,32,110,111,110,45,102,97,116,97,108,32,114,117,110,45,116,105,109,101,32,112,105,99,32,118,101,114,115,105,111,110,32,100,101,116,101,114,109,105,110,97,116,105,111,110,44,32,118,101,114,115,105,111,110,32,50,10,0,98,111,120,114,97,100,61,50,46,48,32,37,115,32,119,105,108,108,32,98,101,32,114,101,115,101,116,32,116,111,32,48,46,48,32,98,121,32,103,112,105,99,32,111,110,108,121,10,0,115,99,97,108,101,61,49,46,48,32,37,115,32,114,101,113,117,105,114,101,100,32,102,111,114,32,99,111,109,112,97,114,105,115,111,110,115,10,0,37,115,32,98,111,120,114,97,100,32,105,115,32,110,111,119,32,48,46,48,32,105,110,32,103,112,105,99,44,32,101,108,115,101,32,105,116,32,114,101,109,97,105,110,115,32,50,46,48,10,0,37,115,32,100,97,115,104,119,105,100,32,105,115,32,48,46,49,32,105,110,32,49,48,116,104,32,69,100,105,116,105,111,110,44,32,48,46,48,53,32,105,110,32,68,87,66,32,50,32,97,110,100,32,105,110,32,103,112,105,99,10,0,37,115,32,102,105,108,108,118,97,108,32,105,115,32,48,46,51,32,105,110,32,49,48,116,104,32,69,100,105,116,105,111,110,32,40,102,105,108,108,32,48,32,109,101,97,110,115,32,98,108,97,99,107,41,44,32,48,46,53,32,105,110,32,103,112,105,99,32,40,102,105,108,108,32,48,32,109,101,97,110,115,32,119,104,105,116,101,41,44,32,117,110,100,101,102,105,110,101,100,32,105,110,32,68,87,66,32,50,10,0,37,115,32,102,105,108,108,32,104,97,115,32,110,111,32,109,101,97,110,105,110,103,32,105,110,32,68,87,66,32,50,44,32,103,112,105,99,32,99,97,110,32,117,115,101,32,102,105,108,108,32,111,114,32,102,105,108,108,101,100,44,32,49,48,116,104,32,69,100,105,116,105,111,110,32,117,115,101,115,32,102,105,108,108,32,111,110,108,121,10,0,37,115,32,68,87,66,32,50,32,100,111,101,115,110,39,116,32,117,115,101,32,102,105,108,108,32,97,110,100,32,100,111,101,115,110,39,116,32,100,101,102,105,110,101,32,102,105,108,108,118,97,108,10,0,37,115,32,114,101,115,101,116,32,119,111,114,107,115,32,105,110,32,103,112,105,99,32,97,110,100,32,49,48,116,104,32,101,100,105,116,105,111,110,44,32,98,117,116,32,105,115,110,39,116,32,100,101,102,105,110,101,100,32,105,110,32,68,87,66,32,50,10,0,37,115,32,68,87,66,32,50,32,99,111,109,112,97,116,105,98,105,108,105,116,121,32,100,101,102,105,110,105,116,105,111,110,115,10,0,105,102,32,98,111,120,114,97,100,32,62,32,49,46,48,32,38,38,32,100,97,115,104,119,105,100,32,60,32,48,46,48,55,53,32,116,104,101,110,32,88,10,9,102,105,108,108,118,97,108,32,61,32,49,59,10,9,100,101,102,105,110,101,32,102,105,108,108,32,89,32,89,59,10,9,100,101,102,105,110,101,32,115,111,108,105,100,32,89,32,89,59,10,9,100,101,102,105,110,101,32,114,101,115,101,116,32,89,32,115,99,97,108,101,61,49,46,48,32,89,59,10,88,10,0,114,101,115,101,116,32,37,115,32,115,101,116,32,116,111,32,107,110,111,119,110,32,115,116,97,116,101,10,0,37,115,32,71,78,85,32,112,105,99,32,118,115,46,32,49,48,116,104,32,69,100,105,116,105,111,110,32,100,92,40,101,39,116,101,110,116,101,10,0,105,102,32,102,105,108,108,118,97,108,32,62,32,48,46,52,32,116,104,101,110,32,88,10,9,100,101,102,105,110,101,32,115,101,116,102,105,108,108,118,97,108,32,89,32,102,105,108,108,118,97,108,32,61,32,49,32,45,32,89,59,10,9,100,101,102,105,110,101,32,98,111,108,100,32,89,32,116,104,105,99,107,110,101,115,115,32,50,32,89,59,10,0,9,37,115,32,105,102,32,121,111,117,32,117,115,101,32,103,112,105,99,32,97,110,100,32,105,116,32,98,97,114,102,115,32,111,110,32,101,110,99,111,117,110,116,101,114,105,110,103,32,34,115,111,108,105,100,34,44,10,0,9,37,115,9,105,110,115,116,97,108,108,32,97,32,109,111,114,101,32,114,101,99,101,110,116,32,118,101,114,115,105,111,110,32,111,102,32,103,112,105,99,32,111,114,32,115,119,105,116,99,104,32,116,111,32,68,87,66,32,111,114,32,49,48,116,104,32,69,100,105,116,105,111,110,32,112,105,99,59,10,0,9,37,115,9,115,111,114,114,121,44,32,116,104,101,32,103,114,111,102,102,32,102,111,108,107,115,32,99,104,97,110,103,101,100,32,103,112,105,99,59,32,115,101,110,100,32,97,110,121,32,99,111,109,112,108,97,105,110,116,32,116,111,32,116,104,101,109,59,10,0,88,32,101,108,115,101,32,90,10,9,100,101,102,105,110,101,32,115,101,116,102,105,108,108,118,97,108,32,89,32,102,105,108,108,118,97,108,32,61,32,89,59,10,9,100,101,102,105,110,101,32,98,111,108,100,32,89,32,89,59,10,9,100,101,102,105,110,101,32,102,105,108,108,101,100,32,89,32,102,105,108,108,32,89,59,10,90,10,0,37,115,32,97,114,114,111,119,104,101,97,100,32,104,97,115,32,110,111,32,109,101,97,110,105,110,103,32,105,110,32,68,87,66,32,50,44,32,97,114,114,111,119,104,101,97,100,32,61,32,55,32,109,97,107,101,115,32,102,105,108,108,101,100,32,97,114,114,111,119,104,101,97,100,115,32,105,110,32,103,112,105,99,32,97,110,100,32,105,110,32,49,48,116,104,32,69,100,105,116,105,111,110,10,0,37,115,32,97,114,114,111,119,104,101,97,100,32,105,115,32,117,110,100,101,102,105,110,101,100,32,105,110,32,68,87,66,32,50,44,32,105,110,105,116,105,97,108,108,121,32,49,32,105,110,32,103,112,105,99,44,32,50,32,105,110,32,49,48,116,104,32,69,100,105,116,105,111,110,10,0,97,114,114,111,119,104,101,97,100,32,61,32,55,32,37,115,32,110,111,116,32,117,115,101,100,32,98,121,32,103,114,97,112,104,118,105,122,10,0,37,115,32,71,78,85,32,112,105,99,32,115,117,112,112,111,114,116,115,32,97,32,98,111,120,114,97,100,32,118,97,114,105,97,98,108,101,32,116,111,32,100,114,97,119,32,98,111,120,101,115,32,119,105,116,104,32,114,111,117,110,100,101,100,32,99,111,114,110,101,114,115,59,32,68,87,66,32,97,110,100,32,49,48,116,104,32,69,100,46,32,100,111,32,110,111,116,10,0,98,111,120,114,97,100,32,61,32,48,32,37,115,32,110,111,32,114,111,117,110,100,101,100,32,99,111,114,110,101,114,115,32,105,110,32,103,114,97,112,104,118,105,122,10,0,37,115,32,71,78,85,32,112,105,99,32,115,117,112,112,111,114,116,115,32,97,32,108,105,110,101,116,104,105,99,107,32,118,97,114,105,97,98,108,101,32,116,111,32,115,101,116,32,108,105,110,101,32,116,104,105,99,107,110,101,115,115,59,32,68,87,66,32,97,110,100,32,49,48,116,104,32,69,100,46,32,100,111,32,110,111,116,10,0,108,105,110,101,116,104,105,99,107,32,61,32,48,59,32,111,108,100,108,105,110,101,116,104,105,99,107,32,61,32,108,105,110,101,116,104,105,99,107,10,0,37,115,32,46,80,83,32,119,47,111,32,97,114,103,115,32,99,97,117,115,101,115,32,71,78,85,32,112,105,99,32,116,111,32,115,99,97,108,101,32,100,114,97,119,105,110,103,32,116,111,32,102,105,116,32,56,46,53,120,49,49,32,112,97,112,101,114,59,32,68,87,66,32,100,111,101,115,32,110,111,116,10,0,37,115,32,109,97,120,112,115,104,116,32,97,110,100,32,109,97,120,112,115,119,105,100,32,104,97,118,101,32,110,111,32,109,101,97,110,105,110,103,32,105,110,32,68,87,66,32,50,46,48,44,32,115,101,116,32,112,97,103,101,32,98,111,117,110,100,97,114,105,101,115,32,105,110,32,103,112,105,99,32,97,110,100,32,105,110,32,49,48,116,104,32,69,100,105,116,105,111,110,10,0,37,115,32,109,97,120,112,115,104,116,32,97,110,100,32,109,97,120,112,115,119,105,100,32,97,114,101,32,112,114,101,100,101,102,105,110,101,100,32,116,111,32,49,49,46,48,32,97,110,100,32,56,46,53,32,105,110,32,103,112,105,99,10,0,109,97,120,112,115,104,116,32,61,32,37,102,10,109,97,120,112,115,119,105,100,32,61,32,37,102,10,0,68,111,116,58,32,91,10,0,100,101,102,105,110,101,32,97,116,116,114,115,48,32,37,37,32,37,37,59,32,100,101,102,105,110,101,32,117,110,102,105,108,108,101,100,32,37,37,32,37,37,59,32,100,101,102,105,110,101,32,114,111,117,110,100,101,100,32,37,37,32,37,37,59,32,100,101,102,105,110,101,32,100,105,97,103,111,110,97,108,115,32,37,37,32,37,37,10,0,37,115,37,115,32,117,110,115,117,112,112,111,114,116,101,100,10,0,37,115,32,114,101,115,116,111,114,101,32,112,111,105,110,116,32,115,105,122,101,32,97,110,100,32,102,111,110,116,10,46,112,115,32,92,110,40,46,83,10,46,102,116,32,92,110,40,68,70,10,0,37,115,32,67,114,101,97,116,111,114,58,32,37,115,32,118,101,114,115,105,111,110,32,37,115,32,40,37,115,41,10,0,37,115,32,84,105,116,108,101,58,32,37,115,10,0,37,115,32,115,97,118,101,32,112,111,105,110,116,32,115,105,122,101,32,97,110,100,32,102,111,110,116,10,46,110,114,32,46,83,32,92,110,40,46,115,10,46,110,114,32,68,70,32,92,110,40,46,102,10,0,112,110,103,58,115,118,103,0,103,105,102,58,115,118,103,0,106,112,101,103,58,115,118,103,0,106,112,101,58,115,118,103,0,106,112,103,58,115,118,103,0,112,110,103,58,102,105,103,0,103,105,102,58,102,105,103,0,106,112,101,103,58,102,105,103,0,106,112,101,58,102,105,103,0,106,112,103,58,102,105,103,0,112,110,103,58,118,114,109,108,0,103,105,102,58,118,114,109,108,0,106,112,101,103,58,118,114,109,108,0,106,112,101,58,118,114,109,108,0,106,112,103,58,118,114,109,108,0,101,112,115,58,112,115,0,112,115,58,112,115,0,40,108,105,98,41,58,112,115,0,112,110,103,58,109,97,112,0,103,105,102,58,109,97,112,0,106,112,101,103,58,109,97,112,0,106,112,101,58,109,97,112,0,106,112,103,58,109,97,112,0,112,115,58,109,97,112,0,101,112,115,58,109,97,112,0,115,118,103,58,109,97,112,0,112,110,103,58,100,111,116,0,103,105,102,58,100,111,116,0,106,112,101,103,58,100,111,116,0,106,112,101,58,100,111,116,0,106,112,103,58,100,111,116,0,112,115,58,100,111,116,0,101,112,115,58,100,111,116,0,115,118,103,58,100,111,116,0,112,110,103,58,120,100,111,116,0,103,105,102,58,120,100,111,116,0,106,112,101,103,58,120,100,111,116,0,106,112,101,58,120,100,111,116,0,106,112,103,58,120,100,111,116,0,112,115,58,120,100,111,116,0,101,112,115,58,120,100,111,116,0,115,118,103,58,120,100,111,116,0,115,118,103,58,115,118,103,0,112,110,103,58,118,109,108,0,103,105,102,58,118,109,108,0,106,112,101,103,58,118,109,108,0,106,112,101,58,118,109,108,0,106,112,103,58,118,109,108,0,103,105,102,58,116,107,0,105,109,97,103,101,32,99,114,101,97,116,101,32,112,104,111,116,111,32,34,112,104,111,116,111,95,37,115,34,32,45,102,105,108,101,32,34,37,115,34,10,0,36,99,32,99,114,101,97,116,101,32,105,109,97,103,101,32,37,46,50,102,32,37,46,50,102,32,45,105,109,97,103,101,32,34,112,104,111,116,111,95,37,115,34,10,0,60,118,58,105,109,97,103,101,32,115,114,99,61,34,37,115,34,32,115,116,121,108,101,61,34,32,112,111,115,105,116,105,111,110,58,97,98,115,111,108,117,116,101,59,32,119,105,100,116,104,58,37,46,50,102,59,32,104,101,105,103,104,116,58,37,46,50,102,59,32,108,101,102,116,58,37,46,50,102,32,59,32,116,111,112,58,37,46,50,102,34,0,32,47,62,10,0,103,118,108,111,97,100,105,109,97,103,101,95,99,111,114,101,46,99,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,112,115,108,105,98,0,91,32,0,37,103,32,37,103,32,0,93,32,32,37,100,32,116,114,117,101,32,37,115,10,0,93,32,32,37,100,32,102,97,108,115,101,32,37,115,10,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,112,115,0,103,115,97,118,101,32,37,103,32,37,103,32,116,114,97,110,115,108,97,116,101,32,110,101,119,112,97,116,104,10,0,117,115,101,114,95,115,104,97,112,101,95,37,100,10,0,103,114,101,115,116,111,114,101,10,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,118,114,109,108,0,83,104,97,112,101,32,123,10,0,32,32,97,112,112,101,97,114,97,110,99,101,32,65,112,112,101,97,114,97,110,99,101,32,123,10,0,32,32,32,32,109,97,116,101,114,105,97,108,32,77,97,116,101,114,105,97,108,32,123,10,0,32,32,32,32,32,32,97,109,98,105,101,110,116,73,110,116,101,110,115,105,116,121,32,48,46,51,51,10,0,32,32,32,32,32,32,32,32,100,105,102,102,117,115,101,67,111,108,111,114,32,49,32,49,32,49,10,0,32,32,32,32,125,10,0,32,32,32,32,116,101,120,116,117,114,101,32,73,109,97,103,101,84,101,120,116,117,114,101,32,123,32,117,114,108,32,34,37,115,34,32,125,10,0,32,32,125,10,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,102,105,103,0,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,46,49,102,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,32,37,100,32,37,115,10,0,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,32,37,100,10,0,99,111,114,101,95,108,111,97,100,105,109,97,103,101,95,115,118,103,0,60,105,109,97,103,101,32,120,108,105,110,107,58,104,114,101,102,61,34,0,34,32,119,105,100,116,104,61,34,37,103,112,120,34,32,104,101,105,103,104,116,61,34,37,103,112,120,34,32,112,114,101,115,101,114,118,101,65,115,112,101,99,116,82,97,116,105,111,61,34,120,77,105,100,89,77,105,100,32,109,101,101,116,34,32,120,61,34,37,103,34,32,121,61,34,37,103,34,0,32,116,114,97,110,115,102,111,114,109,61,34,114,111,116,97,116,101,40,37,100,32,37,103,32,37,103,41,34,0,34,32,119,105,100,116,104,61,34,37,103,112,120,34,32,104,101,105,103,104,116,61,34,37,103,112,120,34,32,112,114,101,115,101,114,118,101,65,115,112,101,99,116,82,97,116,105,111,61,34,120,77,105,110,89,77,105,110,32,109,101,101,116,34,32,120,61,34,37,103,34,32,121,61,34,37,103,34,0,47,62,10,0,100,111,116,95,108,97,121,111,117,116,0,112,104,97,115,101,0,100,111,116,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,116,104,101,32,97,115,112,101,99,116,32,97,116,116,114,105,98,117,116,101,32,102,111,114,32,100,105,115,99,111,110,110,101,99,116,101,100,32,103,114,97,112,104,115,32,111,114,32,103,114,97,112,104,115,32,119,105,116,104,32,99,108,117,115,116,101,114,115,10,0,99,111,109,112,111,117,110,100,0,118,32,61,61,32,110,0,100,111,116,105,110,105,116,46,99,0,114,101,109,111,118,101,95,102,114,111,109,95,114,97,110,107,0,111,114,100,101,114,0,101,100,103,101,32,108,97,98,101,108,115,32,119,105,116,104,32,115,112,108,105,110,101,115,61,99,117,114,118,101,100,32,110,111,116,32,115],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+112222);allocate([117,112,112,111,114,116,101,100,32,105,110,32,100,111,116,32,45,32,117,115,101,32,120,108,97,98,101,108,115,10,0,69,68,95,108,97,98,101,108,40,102,101,41,0,100,111,116,115,112,108,105,110,101,115,46,99,0,95,100,111,116,95,115,112,108,105,110,101,115,0,120,120,120,0,49,48,48,48,48,0,123,37,115,125,0,97,117,120,103,0,108,97,98,101,108,95,102,108,111,97,116,0,102,105,120,101,100,0,40,108,32,61,32,69,68,95,108,97,98,101,108,40,102,101,41,41,0,115,101,116,69,100,103,101,76,97,98,101,108,80,111,115,0,101,32,33,61,32,78,85,76,76,0,102,97,115,116,103,114,46,99,0,100,101,108,101,116,101,95,102,97,115,116,95,101,100,103,101,0,110,32,33,61,32,78,68,95,110,101,120,116,40,110,41,0,102,97,115,116,95,110,111,100,101,0,117,32,33,61,32,118,0,102,97,115,116,95,110,111,100,101,97,112,112,0,78,68,95,110,101,120,116,40,118,41,32,61,61,32,78,85,76,76,0,102,105,110,100,95,102,97,115,116,95,110,111,100,101,40,103,44,32,110,41,0,100,101,108,101,116,101,95,102,97,115,116,95,110,111,100,101,0,100,101,108,101,116,101,95,102,108,97,116,95,101,100,103,101,0,109,101,114,103,101,95,111,110,101,119,97,121,32,103,108,105,116,99,104,10,0,109,101,114,103,101,95,111,110,101,119,97,121,0,115,97,102,101,95,100,101,108,101,116,101,95,102,97,115,116,95,101,100,103,101,0,114,101,109,105,110,99,114,111,115,115,0,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,44,32,108,105,110,101,32,37,100,58,32,37,115,32,37,115,32,114,97,110,107,32,37,100,32,105,32,61,32,37,100,32,97,110,32,61,32,48,10,0,71,68,95,114,97,110,107,40,103,41,91,114,93,46,110,32,60,61,32,71,68,95,114,97,110,107,40,103,41,91,114,93,46,97,110,0,109,105,110,99,114,111,115,115,46,99,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,44,32,108,105,110,101,32,37,100,58,32,78,68,95,111,114,100,101,114,40,37,115,41,32,91,37,100,93,32,62,32,71,68,95,114,97,110,107,40,82,111,111,116,41,91,37,100,93,46,97,110,32,91,37,100,93,10,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,44,32,108,105,110,101,32,37,100,58,32,114,97,110,107,32,37,100,32,110,111,116,32,105,110,32,114,97,110,107,32,114,97,110,103,101,32,91,37,100,44,37,100,93,10,0,105,110,115,116,97,108,108,95,105,110,95,114,97,110,107,44,32,108,105,110,101,32,37,100,58,32,71,68,95,114,97,110,107,40,103,41,91,37,100,93,46,118,32,43,32,78,68,95,111,114,100,101,114,40,37,115,41,32,91,37,100,93,32,62,32,71,68,95,114,97,110,107,40,103,41,91,37,100,93,46,97,118,32,43,32,71,68,95,114,97,110,107,40,82,111,111,116,41,91,37,100,93,46,97,110,32,91,37,100,93,10,0,115,117,114,112,114,105,115,101,10,0,78,68,95,111,114,100,101,114,40,118,41,32,60,32,78,68,95,111,114,100,101,114,40,119,41,0,116,114,97,110,115,112,111,115,101,95,115,116,101,112,0,118,0,110,101,105,103,104,98,111,114,0,40,114,118,32,61,61,32,48,41,32,124,124,32,40,78,68,95,111,114,100,101,114,40,114,118,41,45,78,68,95,111,114,100,101,114,40,118,41,41,42,100,105,114,32,62,32,48,0,109,105,110,99,114,111,115,115,32,37,115,58,32,37,100,32,99,114,111,115,115,105,110,103,115,44,32,37,46,50,102,32,115,101,99,115,46,10,0,99,111,110,115,116,114,97,105,110,105,110,103,95,102,108,97,116,95,101,100,103,101,40,103,44,118,44,101,41,32,61,61,32,70,65,76,83,69,0,102,108,97,116,95,114,101,111,114,100,101,114,0,78,68,95,114,97,110,107,40,118,41,32,61,61,32,114,0,112,111,115,116,111,114,100,101,114,0,102,108,97,116,105,110,100,101,120,40,97,103,104,101,97,100,40,101,41,41,32,60,32,77,45,62,110,114,111,119,115,0,102,108,97,116,95,115,101,97,114,99,104,0,102,108,97,116,105,110,100,101,120,40,97,103,116,97,105,108,40,101,41,41,32,60,32,77,45,62,110,99,111,108,115,0,111,117,116,0,111,114,100,101,114,105,110,103,32,39,37,115,39,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,46,10,0,111,114,100,101,114,105,110,103,32,39,37,115,39,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,32,102,111,114,32,110,111,100,101,32,39,37,115,39,46,10,0,109,101,114,103,101,50,58,32,103,114,97,112,104,32,37,115,44,32,114,97,110,107,32,37,100,32,104,97,115,32,111,110,108,121,32,37,100,32,60,32,37,100,32,110,111,100,101,115,10,0,109,105,110,99,114,111,115,115,58,32,112,97,115,115,32,37,100,32,105,116,101,114,32,37,100,32,116,114,121,105,110,103,32,37,100,32,99,117,114,95,99,114,111,115,115,32,37,100,32,98,101,115,116,95,99,114,111,115,115,32,37,100,10,0,98,97,108,97,110,99,101,0,95,110,101,119,95,114,97,110,107,0,109,99,108,105,109,105,116,0,114,97,110,107,40,103,44,32,50,44,32,110,115,105,116,101,114,50,40,103,41,41,32,61,61,32,48,0,112,111,115,105,116,105,111,110,46,99,0,100,111,116,95,112,111,115,105,116,105,111,110,0,69,100,103,101,32,108,101,110,103,116,104,32,37,102,32,108,97,114,103,101,114,32,116,104,97,110,32,109,97,120,105,109,117,109,32,37,117,32,97,108,108,111,119,101,100,46,10,67,104,101,99,107,32,102,111,114,32,111,118,101,114,119,105,100,101,32,110,111,100,101,40,115,41,46,10,0,65,82,61,37,48,46,52,108,102,9,32,65,114,101,97,61,32,37,48,46,52,108,102,9,0,68,117,109,109,121,61,37,100,10,0,71,111,105,110,103,32,116,111,32,97,112,112,108,121,32,97,110,111,116,104,101,114,32,101,120,112,97,110,115,105,111,110,46,10,0,110,101,120,116,35,105,116,101,114,61,37,100,10,0,104,112,0,99,111,110,110,101,99,116,71,114,97,112,104,0,110,115,108,105,109,105,116,0,99,111,110,116,97,105,110,95,110,111,100,101,115,32,99,108,117,115,116,32,37,115,32,114,97,110,107,32,37,100,32,109,105,115,115,105,110,103,32,110,111,100,101,10,0,110,115,108,105,109,105,116,49,0,110,101,119,114,97,110,107,0,77,97,120,114,97,110,107,32,61,32,37,100,44,32,109,105,110,114,97,110,107,32,61,32,37,100,10,0,108,101,97,100,101,114,32,33,61,32,78,85,76,76,0,114,97,110,107,46,99,0,99,108,117,115,116,101,114,95,108,101,97,100,101,114,0,40,78,68,95,85,70,95,115,105,122,101,40,110,41,32,60,61,32,49,41,32,124,124,32,40,110,32,61,61,32,108,101,97,100,101,114,41,0,97,103,104,101,97,100,40,101,41,32,61,61,32,85,70,95,102,105,110,100,40,97,103,104,101,97,100,40,101,41,41,0,109,105,110,109,97,120,95,101,100,103,101,115,0,97,103,116,97,105,108,40,101,41,32,61,61,32,85,70,95,102,105,110,100,40,97,103,116,97,105,108,40,101,41,41,0,114,97,110,107,0,115,97,109,101,0,109,105,110,0,115,111,117,114,99,101,0,109,97,120,0,115,105,110,107,0,108,101,118,101,108,32,97,115,115,105,103,110,109,101,110,116,32,99,111,110,115,116,114,97,105,110,116,115,0,108,101,118,101,108,32,103,114,97,112,104,32,114,101,99,0,127,114,111,111,116,0,127,116,111,112,0,127,98,111,116,0,99,111,109,112,97,99,116,0,95,119,101,97,107,95,37,100,0,114,97,110,107,105,110,103,58,32,102,97,105,108,117,114,101,32,116,111,32,99,114,101,97,116,101,32,115,116,114,111,110,103,32,99,111,110,115,116,114,97,105,110,116,32,101,100,103,101,32,98,101,116,119,101,101,110,32,110,111,100,101,115,32,37,115,32,97,110,100,32,37,115,10,0,37,115,32,104,97,115,32,117,110,114,101,99,111,103,110,105,122,101,100,32,114,97,110,107,61,37,115,0,108,101,118,101,108,32,101,100,103,101,32,114,101,99,0,108,101,118,101,108,32,110,111,100,101,32,114,101,99,0,115,97,109,101,104,101,97,100,0,115,97,109,101,116,97,105,108,0,116,111,111,32,109,97,110,121,32,40,62,32,37,100,41,32,115,97,109,101,123,104,101,97,100,44,116,97,105,108,125,32,103,114,111,117,112,115,32,102,111,114,32,110,111,100,101,32,37,115,10,0,99,111,109,98,105,65,82,32,61,32,37,108,102,10,0,37,108,102,44,37,100,0,116,104,101,32,97,115,112,101,99,116,32,97,116,116,114,105,98,117,116,101,32,104,97,115,32,98,101,101,110,32,100,105,115,97,98,108,101,100,32,100,117,101,32,116,111,32,105,109,112,108,101,109,101,110,116,97,116,105,111,110,32,102,108,97,119,115,32,45,32,97,116,116,114,105,98,117,116,101,32,105,103,110,111,114,101,100,46,10,0,69,68,95,116,111,95,118,105,114,116,40,101,41,32,61,61,32,78,85,76,76,0,99,108,97,115,115,50,46,99,0,109,101,114,103,101,95,99,104,97,105,110,0,69,68,95,116,111,95,118,105,114,116,40,111,114,105,103,41,32,61,61,32,78,85,76,76,0,109,97,107,101,95,99,104,97,105,110,0,69,68,95,116,111,95,118,105,114,116,40,111,114,105,103,41,32,33,61,32,78,85,76,76,0,37,115,32,119,97,115,32,97,108,114,101,97,100,121,32,105,110,32,97,32,114,97,110,107,115,101,116,44,32,100,101,108,101,116,101,100,32,102,114,111,109,32,99,108,117,115,116,101,114,32,37,115,10,0,78,68,95,114,97,110,107,40,102,114,111,109,41,32,60,32,78,68,95,114,97,110,107,40,116,111,41,0,99,108,117,115,116,101,114,46,99,0,109,97,112,95,112,97,116,104,0,108,104,101,97,100,0,108,116,97,105,108,0,37,115,32,45,62,32,37,115,58,32,115,112,108,105,110,101,32,115,105,122,101,32,62,32,49,32,110,111,116,32,115,117,112,112,111,114,116,101,100,10,0,37,115,32,45,62,32,37,115,58,32,104,101,97,100,32,110,111,116,32,105,110,115,105,100,101,32,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,10,0,37,115,32,45,62,32,37,115,58,32,116,97,105,108,32,105,115,32,105,110,115,105,100,101,32,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,10,0,98,101,122,45,62,115,102,108,97,103,0,99,111,109,112,111,117,110,100,46,99,0,109,97,107,101,67,111,109,112,111,117,110,100,69,100,103,101,0,98,101,122,45,62,101,102,108,97,103,0,37,115,32,45,62,32,37,115,58,32,116,97,105,108,32,110,111,116,32,105,110,115,105,100,101,32,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,10,0,37,115,32,45,62,32,37,115,58,32,104,101,97,100,32,105,115,32,105,110,115,105,100,101,32,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,10,0,115,101,103,109,101,110,116,32,91,37,115,44,37,115,93,32,100,111,101,115,32,110,111,116,32,105,110,116,101,114,115,101,99,116,32,98,111,120,32,108,108,61,37,115,44,117,114,61,37,115,10,0,98,111,120,73,110,116,101,114,115,101,99,116,102,0,40,37,46,53,103,44,37,46,53,103,41,0,99,108,117,115,116,101,114,32,110,97,109,101,100,32,37,115,32,110,111,116,32,102,111,117,110,100,10,0,99,111,110,99,101,110,116,114,97,116,101,61,116,114,117,101,32,109,97,121,32,110,111,116,32,119,111,114,107,32,99,111,114,114,101,99,116,108,121,46,10,0,114,101,98,117,105,108,116,100,95,118,108,105,115,116,115,58,32,114,97,110,107,32,108,101,97,100,32,37,115,32,110,111,116,32,105,110,32,111,114,100,101,114,32,37,100,32,111,102,32,114,97,110,107,32,37,100,10,0,100,101,103,101,110,101,114,97,116,101,32,99,111,110,99,101,110,116,114,97,116,101,100,32,114,97,110,107,32,37,115,44,37,100,10,0,78,68,95,105,110,40,114,105,103,104,116,41,46,115,105,122,101,32,43,32,78,68,95,111,117,116,40,114,105,103,104,116,41,46,115,105,122,101,32,61,61,32,48,0,99,111,110,99,46,99,0,109,101,114,103,101,118,105,114,116,117,97,108,0,0,78,68,95,111,117,116,40,118,41,46,115,105,122,101,32,61,61,32,50,0,102,108,97,116,46,99,0,115,101,116,98,111,117,110,100,115,0,71,68,95,109,105,110,114,97,110,107,40,103,41,32,61,61,32,48,0,97,98,111,109,105,110,97,116,105,111,110,0,110,101,97,116,111,95,108,97,121,111,117,116,0,110,101,97,116,111,0,102,100,112,0,115,102,100,112,0,116,119,111,112,105,0,99,105,114,99,111,0,112,97,116,99,104,119,111,114,107,0,111,115,97,103,101,0,110,111,112,0,110,111,112,49,0,110,111,112,50,0,37,108,102,44,37,108,102,44,37,108,102,37,99,0,110,111,100,101,32,37,115,44,32,112,111,115,105,116,105,111,110,32,37,115,44,32,101,120,112,101,99,116,101,100,32,116,119,111,32,100,111,117,98,108,101,115,10,0,110,111,100,101,32,37,115,32,105,110,32,103,114,97,112,104,32,37,115,32,104,97,115,32,110,111,32,112,111,115,105,116,105,111,110,10,0,115,116,97,114,116,0,115,101,108,102,0,114,97,110,100,111,109,0,110,111,100,101,32,112,111,115,105,116,105,111,110,115,32,97,114,101,32,105,103,110,111,114,101,100,32,117,110,108,101,115,115,32,115,116,97,114,116,61,114,97,110,100,111,109,10,0,97,115,32,114,101,113,117,105,114,101,100,32,98,121,32,116,104,101,32,45,110,32,102,108,97,103,10,0,103,114,97,112,104,32,37,115,32,105,115,32,100,105,115,99,111,110,110,101,99,116,101,100,46,32,72,101,110,99,101,44,32,116,104,101,32,99,105,114,99,117,105,116,32,109,111,100,101,108,10,0,65,108,116,101,114,110,97,116,105,118,101,108,121,44,32,99,111,110,115,105,100,101,114,32,114,117,110,110,105,110,103,32,110,101,97,116,111,32,117,115,105,110,103,32,45,71,112,97,99,107,61,116,114,117,101,32,111,114,32,100,101,99,111,109,112,111,115,105,110,103,10,0,116,104,101,32,103,114,97,112,104,32,105,110,116,111,32,99,111,110,110,101,99,116,101,100,32,99,111,109,112,111,110,101,110,116,115,46,10,0,83,111,108,118,105,110,103,32,109,111,100,101,108,32,37,100,32,105,116,101,114,97,116,105,111,110,115,32,37,100,32,116,111,108,32,37,102,10,0,78,68,95,105,100,40,110,112,41,32,61,61,32,105,0,110,101,97,116,111,105,110,105,116,46,99,0,109,97,107,101,71,114,97,112,104,68,97,116,97,0,102,32,60,32,103,114,97,112,104,91,106,93,46,110,101,100,103,101,115,0,100,102,115,67,121,99,108,101,0,109,111,100,101,108,32,37,100,32,115,109,97,114,116,95,105,110,105,116,32,37,100,32,115,116,114,101,115,115,119,116,32,37,100,32,105,116,101,114,97,116,105,111,110,115,32,37,100,32,116,111,108,32,37,102,10,0,99,111,110,118,101,114,116,32,103,114,97,112,104,58,32,0,109,97,106,111,114,105,122,97,116,105,111,110,10,0,37,100,32,110,111,100,101,115,32,37,46,50,102,32,115,101,99,10,0,108,101,118,101,108,115,103,97,112,0,108,97,121,111,117,116,32,97,98,111,114,116,101,100,10,0,115,116,114,101,115,115,119,116,0,37,115,32,97,116,116,114,105,98,117,116,101,32,118,97,108,117,101,32,109,117,115,116,32,98,101,32,49,32,111,114,32,50,32,45,32,105,103,110,111,114,105,110,103,10,0,95,110,101,97,116,111,95,99,99,0,109,111,100,101,108,0,99,105,114,99,117,105,116,0,115,117,98,115,101,116,0,115,104,111,114,116,112,97,116,104,0,109,100,115,0,101,100,103,101,115,32,105,110,32,103,114,97,112,104,32,37,115,32,104,97,118,101,32,110,111,32,108,101,110,32,97,116,116,114,105,98,117,116,101,46,32,72,101,110,99,101,44,32,116,104,101,32,109,100,115,32,109,111,100,101,108,10,0,105,115,32,105,110,97,112,112,114,111,112,114,105,97,116,101,46,32,82,101,118,101,114,116,105,110,103,32,116,111,32,116,104,101,32,115,104,111,114,116,101,115,116,32,112,97,116,104,32,109,111,100,101,108,46,10,0,85,110,107,110,111,119,110,32,118,97,108,117,101,32,37,115,32,102,111,114,32,97,116,116,114,105,98,117,116,101,32,34,109,111,100,101,108,34,32,105,110,32,103,114,97,112,104,32,37,115,32,45,32,105,103,110,111,114,101,100,10,0,109,111,100,101,0,75,75,0,109,97,106,111,114,0,104,105,101,114,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,97,116,116,114,105,98,117,116,101,32,34,109,111,100,101,34,32,105,110,32,103,114,97,112,104,32,37,115,32,45,32,105,103,110,111,114,101,100,10,0,115,44,37,108,102,44,37,108,102,37,110,0,32,101,44,37,108,102,44,37,108,102,37,110,0,0,112,111,115,32,97,116,116,114,105,98,117,116,101,32,102,111,114,32,101,100,103,101,32,40,37,115,44,37,115,41,32,100,111,101,115,110,39,116,32,104,97,118,101,32,51,110,43,49,32,112,111,105,110,116,115,10,0,37,108,102,44,37,108,102,37,110,0,115,121,110,116,97,120,32,101,114,114,111,114,32,105,110,32,112,111,115,32,97,116,116,114,105,98,117,116,101,32,102,111,114,32,101,100,103,101,32,40,37,115,44,37,115,41,10,0,37,108,102,44,37,108,102,44,37,108,102,44,37,108,102,0,109,97,107,101,83,112,108,105,110,101,58,32,102,97,105,108,101,100,32,116,111,32,109,97,107,101,32,115,112,108,105,110,101,32,101,100,103,101,32,40,37,115,44,37,115,41,10,0,115,112,108,105,110,101,32,37,115,32,37,115,10,0,116,104,101,32,98,111,117,110,100,105,110,103,32,98,111,120,101,115,32,111,102,32,115,111,109,101,32,110,111,100,101,115,32,116,111,117,99,104,32,45,32,102,97,108,108,105,110,103,32,98,97,99,107,32,116,111,32,115,116,114,97,105,103,104,116,32,108,105,110,101,32,101,100,103,101,115,10,0,115,111,109,101,32,110,111,100,101,115,32,119,105,116,104,32,109,97,114,103,105,110,32,40,37,46,48,50,102,44,37,46,48,50,102,41,32,116,111,117,99,104,32,45,32,102,97,108,108,105,110,103,32,98,97,99,107,32,116,111,32,115,116,114,97,105,103,104,116,32,108,105,110,101,32,101,100,103,101,115,10,0,112,111,108,121,108,105,110,101,115,0,108,105,110,101,32,115,101,103,109,101,110,116,115,0,111,114,116,104,111,103,111,110,97,108,32,108,105,110,101,115,0,67,114,101,97,116,105,110,103,32,101,100,103,101,115,32,117,115,105,110,103,32,37,115,10,0,112,111,108,121,108,105,110,101,32,37,115,32,37,115,10,0,98,32,61,61,32,110,0,110,101,97,116,111,115,112,108,105,110,101,115,46,99,0,109,97,107,101,95,98,97,114,114,105,101,114,115,0,109,100,115,77,111,100,101,108,58,32,100,101,108,116,97,32,61,32,37,102,10,0,83,101,116,116,105,110,103,32,117,112,32,115,116,114,101,115,115,32,102,117,110,99,116,105,111,110,0,83,111,108,118,105,110,103,32,109,111,100,101,108,58,32,0,10,102,105,110,97,108,32,101,32,61,32,37,102,32,37,100,32,105,116,101,114,97,116,105,111,110,115,32,37,46,50,102,32,115,101,99,10,0,83,99,97,110,110,105,110,103,32,103,114,97,112,104,32,37,115,44,32,37,100,32,110,111,100,101,115,10,0,68,97,109,112,105,110,103,0,100,101,102,97,117,108,116,100,105,115,116,0,83,101,116,116,105,110,103,32,105,110,105,116,105,97,108,32,112,111,115,105,116,105,111,110,115,10,0,115,116,97,114,116,61,37,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,105,116,104,32,109,111,100,101,61,115,101,108,102,32,45,32,105,103,110,111,114,101,100,10,0,83,101,116,116,105,110,103,32,117,112,32,115,112,114,105,110,103,32,109,111,100,101,108,58,32,0,37,46,50,102,32,115,101,99,10,0,10,102,105,110,97,108,32,101,32,61,32,37,102,0,33,0,32,37,100,37,115,32,105,116,101,114,97,116,105,111,110,115,32,37,46,50,102,32,115,101,99,10,0,77,97,120,46,32,105,116,101,114,97,116,105,111,110,115,32,40,37,100,41,32,114,101,97,99,104,101,100,32,111,110,32,103,114,97,112,104,32,37,115,10,0,37,46,51,102,32,0,37,115,32,37,46,51,102,10,0,78,68,95,104,101,97,112,105,110,100,101,120,40,118,41,32,60,32,48,0,115,116,117,102,102,46,99,0,110,101,97,116,111,95,101,110,113,117,101,117,101,0,67,97,108,99,117,108,97,116,105,110,103,32,115,104,111,114,116,101,115,116,32,112,97,116,104,115,58,32,0,32,105,110,32,37,115,32,45,32,115,101,116,116,105,110,103,32,116,111,32,37,46,48,50,102,10,0,98,97,100,32,101,100,103,101,32,108,101,110,32,34,37,115,34,0,115,112,101,99,105,102,105,101,100,32,114,111,111,116,32,110,111,100,101,32,34,37,115,34,32,119,97,115,32,110,111,116,32,102,111,117,110,100,46,0,85,115,105,110,103,32,100,101,102,97,117,108,116,32,99,97,108,99,117,108,97,116,105,111,110,32,102,111,114,32,114,111,111,116,32,110,111,100,101,10,0,114,101,112,111,115,105,116,105,111,110,32,37,115,10,0,37,115,32,58,32,37,102,32,37,102,10,0,37,115,32,58,32,37,102,32,37,102,32,37,102,32,37,102,10,0,32,32,0,71,114,97,112,104,32,37,115,32,104,97,115,32,97,114,114,97,121,32,112,97,99,107,105,110,103,32,119,105,116,104,32,117,115,101,114,32,118,97,108,117,101,115,32,98,117,116,32,110,111,32,34,115,111,114,116,118,34,32,97,116,116,114,105,98,117,116,101,115,32,97,114,101,32,100,101,102,105,110,101,100,46,0,112,105,110,0,87,97,114,110,105,110,103,58,32,110,111,100,101,32,37,115,44,32,112,111,115,105,116,105,111,110,32,37,115,44,32,101,120,112,101,99,116,101,100,32,116,119,111,32,102,108,111,97,116,115,10,0,99,111,111,114,100,115,0,115,112,108,105,110,101,115,32,97,110,100,32,99,108,117,115,116,101,114,32,101,100,103,101,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,45,32,117,115,105,110,103,32,108,105,110,101,32,115,101,103,109,101,110,116,115,10,0,108,97,121,111,117,116,32,37,115,10,0,101,110,100,32,37,115,10,0,105,100,120,32,61,61,32,115,122,0,108,97,121,111,117,116,46,99,0,101,120,112,97,110,100,67,108,117,115,116,101,114,0,105,32,61,61,32,100,101,103,0,103,101,116,69,100,103,101,76,105,115,116,0,95,100,103,95,37,100,0,100,101,114,105,118,101,32,103,114,97,112,104,32,37,115,32,111,102,32,37,115,10,0,110,111,100,101,32,34,37,115,34,32,105,115,32,99,111,110,116,97,105,110,101,100,32,105,110,32,116,119,111,32,110,111,110,45,99,111,109,112,97,114,97,98,108,101,32,99,108,117,115,116,101,114,115,32,34,37,115,34,32,97,110,100,32,34,37,115,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,112,111,114,116,95,37,115,95,37,115,95,37,115,95,37,108,100,0,95,112,111,114,116,95,37,115,95,40,37,100,41,95,40,37,100,41,95,37,108,100,0,37,108,102,44,37,108,102,44,37,108,102,44,37,108,102,37,99,0,103,114,97,112,104,32,37,115,44,32,99,111,111,114,100,32,37,115,44,32,101,120,112,101,99,116,101,100,32,102,111,117,114,32,100,111,117,98,108,101,115,10,0,109,97,120,105,116,101,114,0,84,48,0,102,100,112,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,115,116,97,114,116,61,115,101,108,102,32,45,32,105,103,110,111,114,105,110,103,10,0,120,76,97,121,111,117,116,32,0,57,58,112,114,105,115,109,0,116,114,105,101,115,32,61,32,37,100,44,32,109,111,100,101,32,61,32,37,115,10,0,100,101,114,105,118,101,100,0,105,110,102,111,0,101,120,116,114,97,99,116,101,100,32,97,32,37,100,45,110,101,105,103,104,98,111,114,104,111,111,100,32,103,114,97,112,104,32,111,102,32,37,100,32,101,100,103,101,115,32,102,114,111,109,32,97,32,103,114,97,112,104,32,111,102,32,37,100,32,101,100,103,101,115,10,0,115,102,100,112,32,111,110,108,121,32,115,117,112,112,111,114,116,115,32,115,116,97,114,116,61,114,97,110,100,111,109,10,0,75,0,114,101,112,117,108,115,105,118,101,102,111,114,99,101,0,108,101,118,101,108,115,0,115,109,111,111,116,104,105,110,103,0,113,117,97,100,116,114,101,101,0,98,101,97,117,116,105,102,121,0,111,118,101,114,108,97,112,95,115,104,114,105,110,107,0,114,111,116,97,116,105,111,110,0,108,97,98,101,108,95,115,99,104,101,109,101,0,108,97,98,101,108,95,115,99,104,101,109,101,32,61,32,37,100,32,62,32,52,32,58,32,105,103,110,111,114,105,110,103,10,0,102,97,115,116,0,97,118,103,95,100,105,115,116,0,103,114,97,112,104,95,100,105,115,116,0,112,111,119,101,114,95,100,105,115,116,0,115,112,114,105,110,103,0,100,105,109,101,110,0,100,105,109,0,13,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,105,116,101,114,32,61,32,37,100,44,32,115,116,101,112,32,61,32,37,102,32,70,110,111,114,109,32,61,32,37,102,32,110,122,32,61,32,37,100,32,32,75,32,61,32,37,102,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,115,112,114,105,110,103,95,101,108,101,99,116,114,105,99,97,108,95,101,109,98,101,100,100,105,110,103,95,115,108,111,119,0,110,115,117,112,101,114,95,97,118,103,61,37,102,44,32,99,111,117,110,116,115,95,97,118,103,32,61,32,37,102,32,50,42,110,115,117,112,101,114,43,99,111,117,110,116,115,61,37,102,10,0,100,109,101,97,110,32,61,32,37,102,44,32,114,104,111,32,61,32,37,102,10,0,115,101,110,100,32,114,97,110,100,111,109,32,99,111,111,114,100,105,110,97,116,101,115,10,0,81,85,65,68,95,84,82,69,69,95,72,89,66,82,73,68,44,32,115,105,122,101,32,108,97,114,103,101,114,32,116,104,97,110,32,37,100,44,32,115,119,105,116,99,104,32,116,111,32,102,97,115,116,32,113,117,97,100,116,114,101,101,0,99,116,114,108,45,62,111,118,101,114,108,97,112,61,37,100,10,0,120,120,120,32,37,100,32,37,100,10,0,37,100,32,37,100,10,0,115,99,97,108,105,110,103,32,102,97,99,116,111,114,32,61,32,37,102,10,0,117,110,105,102,111,114,109,95,115,116,114,101,115,115,46,99,0,85,110,105,102,111,114,109,83,116,114,101,115,115,83,109,111,111,116,104,101,114,95,110,101,119,0,83,112,97,114,115,101,77,97,116,114,105,120,95,105,115,95,115,121,109,109,101,116,114,105,99,40,66,44,32,70,65,76,83,69,41,0,117,110,105,102,111,114,109,95,115,116,114,101,115,115,0,124,101,100,103,101,108,97,98,101,108,124,0,108,101,110,0,111,118,101,114,108,97,112,0,65,100,106,117,115,116,105,110,103,32,37,115,32,117,115,105,110,103,32,37,115,10,0,85,110,104,97,110,100,108,101,100,32,97,100,106,117,115,116,32,111,112,116,105,111,110,32,37,115,10,0,115,101,112,0,101,115,101,112,0,78,111,100,101,32,115,101,112,97,114,97,116,105,111,110,58,32,97,100,100,61,37,100,32,40,37,102,44,37,102,41,10,0,69,100,103,101,32,115,101,112,97,114,97,116,105,111,110,58,32,97,100,100,61,37,100,32,40,37,102,44,37,102,41,10,0,37,102,44,37,102,0,78,117,109,98,101,114,32,111,102,32,105,116,101,114,97,116,105,111,110,115,32,61,32,37,100,10,0,78,117,109,98,101,114,32,111,102,32,105,110,99,114,101,97,115,101,115,32,61,32,37,100,10,0,111,118,101,114,108,97,112,32,91,37,100,93,32,58,32,37,100,10,0,118,111,114,111,95,109,97,114,103,105,110,0,115,99,97,108,101,32,61,32,40,37,46,48,51,102,44,37,46,48,51,102,41,10,0,79,118,101,114,108,97,112,32,118,97,108,117,101,32,34,37,115,34,32,117,110,115,117,112,112,111,114,116,101,100,32,45,32,105,103,110,111,114,101,100,10,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,118,101,114,108,97,112,32,118,97,108,117,101,32,34,37,115,34,32,45,32,117,115,105,110,103,32,102,97,108,115,101,10,0,111,118,101,114,108,97,112,95,115,99,97,108,105,110,103,0,118,111,114,111,110,111,105,0,86,111,114,111,110,111,105,0,115,99,97,108,105,110,103,0,118,112,115,99,0,105,112,115,101,112,0,111,115,99,97,108,101,0,111,108,100,32,115,99,97,108,105,110,103,0,115,99,97,108,101,120,121,0,120,32,97,110,100,32,121,32,115,99,97,108,105,110,103,0,111,114,116,104,111,0,111,114,116,104,111,103,111,110,97,108,32,99,111,110,115,116,114,97,105,110,116,115,0,111,114,116,104,111,95,121,120,0,111,114,116,104,111,120,121,0,120,121,32,111,114,116,104,111,103,111,110,97,108,32,99,111,110,115,116,114,97,105,110,116,115,0,111,114,116,104,111,121,120,0,121,120,32,111,114,116,104,111,103,111,110,97,108,32,99,111,110,115,116,114,97,105,110,116,115,0,112,111,114,116,104,111,0,112,115,101,117,100,111,45,111,114,116,104,111,103,111,110,97,108,32,99,111,110,115,116,114,97,105,110,116,115,0,112,111,114,116,104,111,95,121,120,0,112,111,114,116,104,111,120,121,0,120,121,32,112,115,101,117,100,111,45,111,114,116,104,111,103,111,110,97,108,32,99,111,110,115,116,114,97,105,110,116,115,0,112,111,114,116,104,111,121,120,0,121,120,32,112,115,101,117,100,111,45,111,114,116,104,111,103,111,110,97,108,32,99,111,110,115,116,114,97,105,110,116,115,0,112,114,105,115,109,0,110,111,114,109,97,108,105,122,101,0,67,97,108,99,117,108,97,116,105,110,103,32,99,105,114,99,117,105,116,32,109,111,100,101,108,0,99,111,110,106,117,103,97,116,101,95,103,114,97,100,105,101,110,116,58,32,117,110,101,120,112,101,99,116,101,100,32,108,101,110,103,116,104,32,48,32,118,101,99,116,111,114,10,0,67,97,108,99,117,108,97,116,105,110,103,32,115,117,98,115,101,116,32,109,111,100,101,108,0,103,114,97,112,104,32,105,115,32,100,105,115,99,111,110,110,101,99,116,101,100,46,32,72,101,110,99,101,44,32,116,104,101,32,99,105,114,99,117,105,116,32,109,111,100,101,108,10,0,105,115,32,117,110,100,101,102,105,110,101,100,46,32,82,101,118,101,114,116,105,110,103,32,116,111,32,116,104,101,32,115,104,111,114,116,101,115,116,32,112,97,116,104,32,109,111,100,101,108,46,10,0,67,97,108,99,117,108,97,116,105,110,103,32,77,68,83,32,109,111,100,101,108,0,67,97,108,99,117,108,97,116,105,110,103,32,115,104,111,114,116,101,115,116,32,112,97,116,104,115,0,58,32,37,46,50,102,32,115,101,99,10,0,83,101,116,116,105,110,103,32,105,110,105,116,105,97,108,32,112,111,115,105,116,105,111,110,115,0,58,32,37,46,50,102,32,115,101,99,0,99,111,109,112,114,101,115,115,32,37,103,32,10,0,115,99,97,108,101,32,98,121,32,37,103,44,37,103,32,10,0,98,101,115,116,99,111,115,116,32,60,32,72,85,71,69,95,86,65,76,0,99,111,110,115,116,114,97,105,110,116,46,99,0,99,111,109,112,117,116,101,83,99,97,108,101,88,89,0,99,103,0,100,101,108,116,97,32,60,61,32,48,120,70,70,70,70,0,109,107,78,67,111,110,115,116,114,97,105,110,116,71,0,118,103,0,100,101,108,97,117,110,97,121,95,116,114,105,97,110,103,117,108,97,116,105,111,110,58,32,37,115,10,0,100,101,108,97,117,110,97,121,95,116,114,105,58,32,37,115,10,0,71,114,97,112,104,118,105,122,32,98,117,105,108,116,32,119,105,116,104,111,117,116,32,97,110,121,32,116,114,105,97,110,103,117,108,97,116,105,111,110,32,108,105,98,114,97,114,121,10,0,116,114,121,105,110,103,32,116,111,32,100,101,108,101,116,101,32,97,32,110,111,110,45,108,105,110,101,10,0,10,105,110,116,101,114,115,101,99,116,105,111,110,32,97,116,32,37,46,51,102,32,37,46,51,102,10,0,115,101,103,35,37,100,32,58,32,40,37,46,51,102,44,32,37,46,51,102,41,32,40,37,46,51,102,44,32,37,46,51,102,41,10,0,114,101,109,111,118,101,95,111,118,101,114,108,97,112,58,32,71,114,97,112,104,118,105,122,32,110,111,116,32,98,117,105,108,116,32,119,105,116,104,32,116,114,105,97,110,103,117,108,97,116,105,111,110,32,108,105,98,114,97,114,121,10,0,109,97,107,101,65,100,100,80,111,108,121,58,32,117,110,107,110,111,119,110,32,115,104,97,112,101,32,116,121,112,101,32,37,115,10,0,109,97,107,101,80,111,108,121,58,32,117,110,107,110,111,119,110,32,115,104,97,112,101,32,116,121,112,101,32,37,115,10,0,120,33,61,78,85,76,76,0,115,109,97,114,116,95,105,110,105,95,120,46,99,0,73,77,68,83,95,103,105,118,101,110,95,100,105,109,0,105,108,108,45,99,111,110,100,105,116,105,111,110,101,100,10,0,116,119,111,112,105,58,32,117,115,101,32,111,102,32,119,101,105,103,104,116,61,48,32,99,114,101,97,116,101,115,32,100,105,115,99,111,110,110,101,99,116,101,100,32,99,111,109,112,111,110,101,110,116,46,10,0,82,97,110,107,32,115,101,112,97,114,97,116,105,111,110,32,61,32,0,37,46,48,51,108,102,32,0,97,114,101,97,0,105,110,115,101,116,0,37,115,32,99,111,111,114,100,32,37,46,53,103,32,37,46,53,103,32,104,116,32,37,102,32,119,105,100,116,104,32,37,102,10,0,37,46,48,51,102,0,114,101,99,32,37,102,32,37,102,32,37,102,32,37,102,10,0,37,102,32,45,32,37,102,32,37,102,32,37,102,32,37,102,32,61,32,37,102,32,40,37,102,32,37,102,32,37,102,32,37,102,41,10,0,116,114,121,105,110,103,32,116,111,32,97,100,100,32,116,111,32,114,101,99,116,32,123,37,102,32,43,47,45,32,37,102,44,32,37,102,32,43,47,45,32,37,102,125,10,0,116,111,116,97,108,32,97,100,100,101,100,32,115,111,32,102,97,114,32,61,32,37,100,10,0,97,100,100,105,110,103,32,37,100,32,105,116,101,109,115,44,32,116,111,116,97,108,32,97,114,101,97,32,61,32,37,102,44,32,119,32,61,32,37,102,44,32,97,114,101,97,47,119,61,37,102,10,0,99,111,109,112,111,117,110,100,69,100,103,101,115,58,32,99,111,117,108,100,32,110,111,116,32,99,111,110,115,116,114,117,99,116,32,111,98,115,116,97,99,108,101,115,32,45,32,102,97,108,108,105,110,103,32,98,97,99,107,32,116,111,32,115,116,114,97,105,103,104,116,32,108,105,110,101,32,101,100,103,101,115,10,0,110,111,100,101,115,32,116,111,117,99,104,32,45,32,102,97,108,108,105,110,103,32,98,97,99,107,32,116,111,32,115,116,114,97,105,103,104,116,32,108,105,110,101,32,101,100,103,101,115,10,0,99,99,37,115,95,37,100,0,99,99,37,115,43,37,100,0,99,95,99,110,116,32,61,61,32,48,0,99,111,109,112,46,99,0,102,105,110,100,67,67,111,109,112,0,103,114,105,100,40,37,100,44,37,100,41,58,32,37,115,10,0,119,105,100,116,104,32,62,32,48,0,81,117,97,100,84,114,101,101,46,99,0,81,117,97,100,84,114,101,101,95,110,101,119,0,33,40,113,45,62,108,41,0,81,117,97,100,84,114,101,101,95,97,100,100,95,105,110,116,101,114,110,97,108,0,105,105,32,60,32,49,60,60,100,105,109,32,38,38,32,105,105,32,62,61,32,48,0,113,45,62,113,116,115,91,105,105,93,0,113,45,62,110,32,61,61,32,49,0,33,40,113,45,62,113,116,115,41,0,113,45,62,108,0,119,103,116,32,62,32,48,0,81,117,97,100,84,114,101,101,95,114,101,112,117,108,115,105,118,101,95,102,111,114,99,101,95,97,99,99,117,109,117,108,97,116,101,0,113,116,50,45,62,110,32,62,32,48,0,113,116,49,45,62,110,32,62,32,48,32,38,38,32,113,116,50,45,62,110,32,62,32,48,0,81,117,97,100,84,114,101,101,95,114,101,112,117,108,115,105,118,101,95,102,111,114,99,101,95,105,110,116,101,114,97,99,116,0,100,105,115,116,32,62,32,48,0,65,45,62,102,111,114,109,97,116,32,61,61,32,70,79,82,77,65,84,95,67,83,82,0,83,112,97,114,115,101,77,97,116,114,105,120,46,99,0,83,112,97,114,115,101,77,97,116,114,105,120,95,116,114,97,110,115,112,111,115,101,0,83,112,97,114,115,101,77,97,116,114,105,120,95,105,115,95,115,121,109,109,101,116,114,105,99,0,65,32,38,38,32,66,0,83,112,97,114,115,101,77,97,116,114,105,120,95,97,100,100,0,65,45,62,102,111,114,109,97,116,32,61,61,32,66,45,62,102,111,114,109,97,116,32,38,38,32,65,45,62,102,111,114,109,97,116,32,61,61,32,70,79,82,77,65,84,95,67,83,82,0,65,45,62,116,121,112,101,32,61,61,32,66,45,62,116,121,112,101,0,65,45,62,102,111,114,109,97,116,32,61,61,32,70,79,82,77,65,84,95,67,79,79,82,68,0,83,112,97,114,115,101,77,97,116,114,105,120,95,102,114,111,109,95,99,111,111,114,100,105,110,97,116,101,95,102,111,114,109,97,116,0,83,112,97,114,115,101,77,97,116,114,105,120,95,109,117,108,116,105,112,108,121,95,118,101,99,116,111,114,0,65,45,62,116,121,112,101,32,61,61,32,77,65,84,82,73,88,95,84,89,80,69,95,82,69,65,76,32,124,124,32,65,45,62,116,121,112,101,32,61,61,32,77,65,84,82,73,88,95,84,89,80,69,95,73,78,84,69,71,69,82,0,65,45,62,116,121,112,101,32,61,61,32,77,65,84,82,73,88,95,84,89,80,69,95,82,69,65,76,0,83,112,97,114,115,101,77,97,116,114,105,120,95,109,117,108,116,105,112,108,121,0,106,99,91,109,97,115,107,91,106,98,91,107,93,93,93,32,61,61,32,106,98,91,107,93,0,83,112,97,114,115,101,77,97,116,114,105,120,95,109,117,108,116,105,112,108,121,51,0,106,100,91,109,97,115,107,91,106,99,91,107,93,93,93,32,61,61,32,106,99,91,107,93,0,106,97,91,109,97,115,107,91,106,97,91,106,93,93,93,32,61,61,32,106,97,91,106,93,0,83,112,97,114,115,101,77,97,116,114,105,120,95,115,117,109,95,114,101,112,101,97,116,95,101,110,116,114,105,101,115,0,105,100,32,60,32,110,42,40,121,109,97,120,45,121,109,105,110,43,49,41,0,106,97,91,109,97,115],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+122462);allocate([107,91,105,100,93,93,32,61,61,32,106,97,91,106,93,0,83,112,97,114,115,101,77,97,116,114,105,120,95,99,111,111,114,100,105,110,97,116,101,95,102,111,114,109,95,97,100,100,95,101,110,116,114,105,101,115,0,83,112,97,114,115,101,77,97,116,114,105,120,95,100,105,118,105,100,101,95,114,111,119,95,98,121,95,100,101,103,114,101,101,0,114,111,111,116,32,62,61,32,48,32,38,38,32,114,111,111,116,32,60,32,109,0,83,112,97,114,115,101,77,97,116,114,105,120,95,108,101,118,101,108,95,115,101,116,115,95,105,110,116,101,114,110,97,108,0,109,32,61,61,32,65,45,62,110,0,83,112,97,114,115,101,77,97,116,114,105,120,95,105,115,95,115,121,109,109,101,116,114,105,99,40,65,44,32,84,82,85,69,41,0,109,32,61,61,32,110,0,83,112,97,114,115,101,77,97,116,114,105,120,95,100,105,115,116,97,110,99,101,95,109,97,116,114,105,120,95,107,104,111,112,115,0,110,108,101,118,101,108,45,49,32,60,61,32,107,104,111,112,115,0,109,97,115,107,91,108,101,118,101,108,115,101,116,91,106,93,93,32,61,61,32,105,43,49,0,68,105,106,107,115,116,114,97,95,105,110,116,101,114,110,97,108,0,104,0,104,101,97,112,95,105,100,115,91,114,111,111,116,93,32,62,61,32,48,0,110,100,97,116,97,45,62,105,100,32,61,61,32,106,106,0,83,112,97,114,115,101,77,97,116,114,105,120,95,109,117,108,116,105,112,108,121,95,100,101,110,115,101,50,0,83,112,97,114,115,101,77,97,116,114,105,120,95,109,117,108,116,105,112,108,121,95,100,101,110,115,101,49,0,109,32,62,32,48,32,38,38,32,110,32,62,32,48,32,38,38,32,110,122,32,62,61,32,48,0,83,112,97,114,115,101,77,97,116,114,105,120,95,102,114,111,109,95,99,111,111,114,100,105,110,97,116,101,95,97,114,114,97,121,115,95,105,110,116,101,114,110,97,108,0,65,0,110,32,62,32,49,0,103,101,110,101,114,97,108,46,99,0,105,114,97,110,100,0,111,110,101,98,108,111,99,107,0,109,105,110,100,105,115,116,0,97,114,116,105,99,117,108,97,116,105,111,110,95,112,111,115,0,114,111,111,116,0,80,114,105,111,114,105,116,121,81,117,101,117,101,46,99,0,80,114,105,111,114,105,116,121,81,117,101,117,101,95,112,117,115,104,0,103,97,105,110,32,60,61,32,113,45,62,110,103,97,105,110,0,83,112,97,114,115,101,77,97,116,114,105,120,95,105,115,95,115,121,109,109,101,116,114,105,99,40,65,44,32,70,65,76,83,69,41,0,112,111,115,116,95,112,114,111,99,101,115,115,46,99,0,105,100,101,97,108,95,100,105,115,116,97,110,99,101,95,109,97,116,114,105,120,0,108,101,110,32,62,32,48,0,83,116,114,101,115,115,77,97,106,111,114,105,122,97,116,105,111,110,83,109,111,111,116,104,101,114,50,95,110,101,119,0,110,122,32,62,32,48,0,105,100,101,97,108,95,100,105,115,116,95,115,99,104,101,109,101,32,118,97,108,117,101,32,119,114,111,110,103,0,83,112,97,114,115,101,77,97,116,114,105,120,95,105,115,95,115,121,109,109,101,116,114,105,99,40,65,44,32,70,65,76,83,69,41,32,38,38,32,65,45,62,116,121,112,101,32,61,61,32,77,65,84,82,73,88,95,84,89,80,69,95,82,69,65,76,0,83,112,97,114,115,101,83,116,114,101,115,115,77,97,106,111,114,105,122,97,116,105,111,110,83,109,111,111,116,104,101,114,95,110,101,119,0,105,100,105,97,103,32,62,61,32,48,0,83,116,114,101,115,115,77,97,106,111,114,105,122,97,116,105,111,110,83,109,111,111,116,104,101,114,95,115,109,111,111,116,104,0,84,114,105,97,110,103,108,101,83,109,111,111,116,104,101,114,95,110,101,119,0,106,100,105,97,103,32,62,61,32,48,0,83,112,114,105,110,103,83,109,111,111,116,104,101,114,95,110,101,119,0,33,102,108,97,103,0,83,112,114,105,110,103,83,109,111,111,116,104,101,114,95,115,109,111,111,116,104,0,40,33,106,99,110,41,32,38,38,32,40,33,118,97,108,41,0,103,101,116,95,101,100,103,101,95,108,97,98,101,108,95,109,97,116,114,105,120,0,110,101,105,103,104,98,61,37,100,10,0,104,45,62,105,100,95,116,111,95,112,111,115,91,105,100,93,32,61,61,32,112,111,115,0,66,105,110,97,114,121,72,101,97,112,46,99,0,66,105,110,97,114,121,72,101,97,112,95,105,110,115,101,114,116,0,104,45,62,112,111,115,95,116,111,95,105,100,91,112,111,115,93,32,61,61,32,105,100,0,112,111,115,32,60,32,104,45,62,108,101,110,0,66,105,110,97,114,121,72,101,97,112,95,101,120,116,114,97,99,116,95,105,116,101,109,0,112,97,114,101,110,116,80,111,115,32,60,32,104,45,62,108,101,110,0,115,119,97,112,0,110,111,100,101,80,111,115,32,60,32,104,45,62,108,101,110,0,114,111,111,116,32,61,32,37,115,10,0,95,98,108,111,99,107,95,37,100,0,115,45,62,115,122,32,62,32,48,0,98,108,111,99,107,116,114,101,101,46,99,0,112,111,112,0,97,99,116,117,97,108,0,110,111,100,101,108,105,115,116,46,99,0,105,110,115,101,114,116,78,111,100,101,108,105,115,116,0,95,115,112,97,110,95,37,100,0,95,99,108,111,110,101,95,37,100,0,105,112,0,100,101,103,108,105,115,116,46,99,0,114,101,109,111,118,101,68,101,103,108,105,115,116,0,10,64,40,35,41,36,73,100,36,0,10,0,69,114,114,111,114,0,87,97,114,110,105,110,103,0,37,115,58,32,0,117,115,101,114,111,117,116,58,32,99,111,117,108,100,32,110,111,116,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,10,0,95,65,71,95,100,97,116,97,100,105,99,116,0,97,103,100,105,99,116,111,102,58,32,117,110,107,110,111,119,110,32,107,105,110,100,32,37,100,10,0,95,65,71,95,115,116,114,100,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,99,37,108,100,0,109,101,109,111,114,121,32,97,108,108,111,99,97,116,105,111,110,32,102,97,105,108,117,114,101,0,97,103,100,101,108,101,116,101,32,111,110,32,119,114,111,110,103,32,103,114,97,112,104,0,95,65,71,95,112,101,110,100,105,110,103,0,97,103,114,101,99,111,114,100,95,99,97,108,108,98,97,99,107,32,111,102,32,97,32,98,97,100,32,111,98,106,101,99,116,0,112,101,110,100,32,100,105,99,116,111,102,32,97,32,98,97,100,32,111,98,106,101,99,116,0,109,111,118,101,32,116,111,32,102,114,111,110,116,32,108,111,99,107,32,105,110,99,111,110,115,105,115,116,101,110,99,121,0,0,92,92,0,102,97,116,97,108,32,102,108,101,120,32,115,99,97,110,110,101,114,32,105,110,116,101,114,110,97,108,32,101,114,114,111,114,45,45,110,111,32,97,99,116,105,111,110,32,102,111,117,110,100,0,111,117,116,32,111,102,32,100,121,110,97,109,105,99,32,109,101,109,111,114,121,32,105,110,32,97,97,103,95,99,114,101,97,116,101,95,98,117,102,102,101,114,40,41,0,58,32,0,32,105,110,32,108,105,110,101,32,37,100,32,110,101,97,114,32,39,0,39,10,0,102,108,101,120,32,115,99,97,110,110,101,114,32,112,117,115,104,45,98,97,99,107,32,111,118,101,114,102,108,111,119,0,37,115,10,0,102,97,116,97,108,32,102,108,101,120,32,115,99,97,110,110,101,114,32,105,110,116,101,114,110,97,108,32,101,114,114,111,114,45,45,101,110,100,32,111,102,32,98,117,102,102,101,114,32,109,105,115,115,101,100,0,102,97,116,97,108,32,101,114,114,111,114,32,45,32,115,99,97,110,110,101,114,32,105,110,112,117,116,32,98,117,102,102,101,114,32,111,118,101,114,102,108,111,119,0,105,110,112,117,116,32,105,110,32,102,108,101,120,32,115,99,97,110,110,101,114,32,102,97,105,108,101,100,0,111,117,116,32,111,102,32,100,121,110,97,109,105,99,32,109,101,109,111,114,121,32,105,110,32,97,97,103,95,103,101,116,95,110,101,120,116,95,98,117,102,102,101,114,40,41,0,105,110,112,117,116,0,115,121,110,116,97,120,32,97,109,98,105,103,117,105,116,121,32,45,32,98,97,100,108,121,32,100,101,108,105,109,105,116,101,100,32,110,117,109,98,101,114,32,39,0,39,32,105,110,32,108,105,110,101,32,37,100,32,111,102,32,0,32,115,112,108,105,116,115,32,105,110,116,111,32,116,119,111,32,116,111,107,101,110,115,10,0,108,105,110,101,0,37,100,32,37,49,91,34,93,37,110,0,111,117,116,32,111,102,32,100,121,110,97,109,105,99,32,109,101,109,111,114,121,32,105,110,32,97,97,103,101,110,115,117,114,101,95,98,117,102,102,101,114,95,115,116,97,99,107,40,41,0,108,105,110,101,108,101,110,103,116,104,0,59,10,0,32,91,107,101,121,61,0,93,0,32,91,0,44,10,0,61,0,95,37,108,100,95,83,85,83,80,69,67,84,0,0,100,105,0,115,116,114,105,99,116,32,0,123,10,0,93,59,10,0,34,34,0,115,116,114,105,99,116,0,18,238,238,20,9,3,238,254,238,238,238,1,238,238,238,1,238,238,10,254,238,19,25,21,238,19,1,238,238,238,238,11,17,238,238,238,238,238,238,238,238,238,1,238,238,22,9,1,1,29,15,23,238,238,26,23,27,238,238,28,238,238,238,238,1,25,251,238,238,238,1,238,16,238,238,30,238,238,238,238,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,23,17,2,2,2,2,2,2,2,2,2,2,2,2,2,18,16,2,19,2,2,22,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,20,2,21,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,14,2,15,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,3,4,5,6,7,8,9,10,11,12,13,11,3,4,5,15,7,3,12,13,6,12,13,14,12,13,26,21,22,0,1,0,3,7,14,6,15,8,12,13,18,19,42,16,17,9,16,47,48,17,50,23,19,13,20,18,46,18,20,65,19,50,19,44,64,42,66,25,44,66,70,34,12,13,14,35,15,9,16,17,10,16,17,201,16,17,45,69,70,252,1,6,246,15,7,246,36,2,16,17,47,48,54,77,78,40,38,59,60,42,54,49,57,61,63,47,58,64,216,68,48,62,37,55,67,53,75,43,56,73,76,0,3,9,0,0,0,1,14,2,11,12,8,35,36,37,54,59,61,0,13,16,18,27,22,28,18,39,50,34,23,51,30,60,6,7,53,5,15,17,20,24,41,0,19,41,0,0,0,0,0,55,21,40,29,30,0,33,38,52,31,48,62,25,44,0,27,0,32,26,42,0,43,58,46,47,0,49,56,57,45,0,2,2,1,0,3,3,1,0,1,0,1,1,1,0,2,1,1,0,2,2,3,1,1,0,0,5,0,1,3,1,3,5,3,1,1,1,1,2,0,1,0,4,2,0,2,1,1,3,2,1,0,3,2,1,0,1,1,0,1,1,1,3,0,24,25,25,25,26,27,28,28,29,29,30,30,31,31,32,32,33,33,34,34,35,36,36,38,39,37,37,40,40,41,41,41,42,42,43,43,43,44,44,45,45,46,47,47,48,49,49,50,51,52,54,53,55,55,55,56,56,56,57,57,58,58,238,238,255,238,238,238,238,238,238,31,32,238,0,239,238,238,238,12,238,238,238,8,13,238,238,238,248,238,238,238,238,238,238,245,238,255,3,8,4,33,5,11,18,19,39,20,21,22,41,50,65,23,24,25,26,44,51,52,66,71,72,27,74,28,29,46,30,79,31,32,0,1,8,25,27,29,0,14,26,3,6,30,3,4,5,7,12,13,31,32,34,35,36,40,41,42,43,50,52,53,55,57,58,28,57,57,15,34,16,33,9,37,17,33,44,57,54,18,19,23,38,45,46,41,57,45,46,19,26,57,57,13,36,20,18,39,47,57,37,21,22,48,49,50,51,57,57,16,17,56,107,101,121,0,97,116,116,114,105,98,117,116,101,32,109,97,99,114,111,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,37,115,58,37,115,0,67,111,117,108,100,32,110,111,116,32,111,112,101,110,32,34,37,115,34,32,102,111,114,32,119,114,105,116,105,110,103,32,58,32,37,115,10,0,78,111,32,108,105,98,122,32,115,117,112,112,111,114,116,46,10,0,103,118,119,114,105,116,101,95,110,111,95,122,32,112,114,111,98,108,101,109,32,37,100,10,0,78,111,32,108,105,98,122,32,115,117,112,112,111,114,116,10,0,103,118,112,114,105,110,116,102,58,32,37,115,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,46,57,57,0,109,101,109,111,114,121,32,97,108,108,111,99,97,116,105,111,110,32,102,97,105,108,117,114,101,10,0,46,37,100,0,110,111,110,97,109,101,46,103,118,0,100,121,110,97,109,105,99,32,108,111,97,100,105,110,103,32,110,111,116,32,97,118,97,105,108,97,98,108,101,10,0,60,98,117,105,108,116,105,110,62,0,65,99,116,105,118,97,116,101,100,32,112,108,117,103,105,110,32,108,105,98,114,97,114,121,58,32,37,115,10,0,85,115,105,110,103,32,37,115,58,32,37,115,58,37,115,10,0,114,101,110,100,101,114,0,108,97,121,111,117,116,0,100,101,118,105,99,101,0,108,111,97,100,105,109,97,103,101,0,103,118,117,115,101,114,115,104,97,112,101,46,99,0,103,118,117,115,101,114,115,104,97,112,101,95,102,105,110,100,0,103,118,117,115,101,114,115,104,97,112,101,95,102,105,108,101,95,97,99,99,101,115,115,0,70,105,108,101,110,97,109,101,32,34,37,115,34,32,105,115,32,117,110,115,97,102,101,10,0,37,115,32,119,104,105,108,101,32,111,112,101,110,105,110,103,32,37,115,10,0,117,115,45,62,102,0,103,118,117,115,101,114,115,104,97,112,101,95,111,112,101,110,0,34,37,115,34,32,119,97,115,32,110,111,116,32,102,111,117,110,100,32,97,115,32,97,32,102,105,108,101,32,111,114,32,97,115,32,97,32,115,104,97,112,101,32,108,105,98,114,97,114,121,32,109,101,109,98,101,114,10,0,47,77,101,100,105,97,66,111,120,0,99,97,110,110,111,116,32,99,111,109,112,105,108,101,32,114,101,103,117,108,97,114,32,101,120,112,114,101,115,115,105,111,110,32,37,115,0,37,108,102,37,50,115,0,112,116,0,118,105,101,119,66,111,120,0,37,108,102,32,37,108,102,32,37,108,102,32,37,108,102,0,105,110,0,112,120,0,112,99,0,34,0,99,109,0,109,109,0,40,91,97,45,122,93,91,97,45,122,65,45,90,93,42,41,61,34,40,91,94,34,93,42,41,34,0,37,37,66,111,117,110,100,105,110,103,66,111,120,58,0,1,208,209,210,211,212,213,214,215,216,217,0,60,115,118,103,0,87,69,66,80,0,119,101,98,112,0,40,108,105,98,41,0,137,80,78,71,13,10,26,10,0,112,110,103,0,37,33,80,83,45,65,100,111,98,101,45,0,66,77,0,98,109,112,0,71,73,70,56,0,103,105,102,0,255,216,255,224,0,106,112,101,103,0,37,80,68,70,45,0,112,100,102,0,197,208,211,198,0,101,112,115,0,60,63,120,109,108,0,120,109,108,0,82,73,70,70,0,114,105,102,102,0,0,0,1,0,0,105,99,111,0,76,97,121,111,117,116,32,116,121,112,101,58,32,34,37,115,34,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,46,32,85,115,101,32,111,110,101,32,111,102,58,37,115,10,0,37,100,32,37,100,32,37,100,32,37,100,0,70,111,114,109,97,116,58,32,34,37,115,34,32,110,111,116,32,114,101,99,111,103,110,105,122,101,100,46,32,85,115,101,32,111,110,101,32,111,102,58,37,115,10,0,76,97,121,111,117,116,32,119,97,115,32,110,111,116,32,100,111,110,101,10,0,102,97,105,108,117,114,101,32,109,97,108,108,111,99,39,105,110,103,32,102,111,114,32,114,101,115,117,108,116,32,115,116,114,105,110,103,0,99,99,103,114,97,112,104,105,110,102,111,0,99,99,103,110,111,100,101,105,110,102,111,0,40,37,52,108,100,41,32,37,55,108,100,32,110,111,100,101,115,32,37,55,108,100,32,101,100,103,101,115,10,0,32,32,32,32,32,32,32,37,55,100,32,110,111,100,101,115,32,37,55,100,32,101,100,103,101,115,32,37,55,108,100,32,99,111,109,112,111,110,101,110,116,115,32,37,115,10,0,100,103,0,69,114,114,111,114,58,32,110,111,100,101,32,34,37,115,34,32,98,101,108,111,110,103,115,32,116,111,32,116,119,111,32,110,111,110,45,110,101,115,116,101,100,32,99,108,117,115,116,101,114,115,32,34,37,115,34,32,97,110,100,32,34,37,115,34,10,0,103,99,58,32,79,117,116,32,111,102,32,109,101,109,111,114,121,10,0,95,99,99,95,0,115,111,114,116,118,0,112,105,110,102,111,0,112,97,99,107,46,99,0,103,101,116,80,97,99,107,73,110,102,111,0,32,32,109,97,114,103,105,110,32,37,100,10,0,112,97,114,115,101,80,97,99,107,77,111,100,101,73,110,102,111,0,97,114,114,97,121,0,97,115,112,101,99,116,0,37,102,0,112,97,99,107,32,105,110,102,111,58,10,0,32,32,109,111,100,101,32,32,32,37,115,10,0,32,32,97,115,112,101,99,116,32,37,102,10,0,32,32,115,105,122,101,32,32,32,37,100,10,0,32,32,102,108,97,103,115,32,32,37,100,10,0,112,97,99,107,109,111,100,101,0,112,97,99,107,0,117,110,100,101,102,105,110,101,100,0,115,116,101,112,32,115,105,122,101,32,61,32,37,100,10,0,112,111,115,91,37,100,93,32,37,100,32,37,100,10,0,99,99,32,40,37,100,32,99,101,108,108,115,41,32,97,116,32,40,37,100,44,37,100,41,32,40,37,100,44,37,100,41,10,0,37,115,32,110,111,46,32,99,101,108,108,115,32,37,100,32,87,32,37,100,32,72,32,37,100,10,0,32,32,37,100,32,37,100,32,99,101,108,108,10,0,108,105,98,112,97,99,107,58,32,100,105,115,99,32,61,32,37,102,32,40,32,60,32,48,41,10,0,80,97,99,107,105,110,103,58,32,99,111,109,112,117,116,101,32,103,114,105,100,32,115,105,122,101,10,0,97,32,37,102,32,98,32,37,102,32,99,32,37,102,32,100,32,37,102,32,114,32,37,102,10,0,114,111,111,116,32,37,100,32,40,37,102,41,32,37,100,32,40,37,102,41,10,0,32,114,49,32,37,102,32,114,50,32,37,102,10,0,114,111,119,32,109,97,106,111,114,0,99,111,108,117,109,110,32,109,97,106,111,114,0,97,114,114,97,121,32,112,97,99,107,105,110,103,58,32,37,115,32,37,100,32,114,111,119,115,32,37,100,32,99,111,108,117,109,110,115,10,0,98,98,91,37,115,93,32,37,46,53,103,32,37,46,53,103,32,37,46,53,103,32,37,46,53,103,10,0,99,99,32,40,37,100,32,99,101,108,108,115,41,32,97,116,32,40,37,100,44,37,100,41,10,0,65,114,114,111,119,32,116,121,112,101,32,34,37,115,34,32,117,110,107,110,111,119,110,32,45,32,105,103,110,111,114,105,110,103,10,0,110,111,114,109,97,108,0,99,114,111,119,0,116,101,101,0,100,111,116,0,105,110,118,0,118,101,101,0,112,101,110,0,109,112,116,121,0,99,117,114,118,101,0,108,0,104,97,108,102,0,105,110,118,101,109,112,116,121,0,95,98,97,99,107,103,114,111,117,110,100,0,95,100,114,97,119,95,0,67,111,117,108,100,32,110,111,116,32,112,97,114,115,101,32,34,95,98,97,99,107,103,114,111,117,110,100,34,32,97,116,116,114,105,98,117,116,101,32,105,110,32,103,114,97,112,104,32,37,115,10,0,32,32,34,37,115,34,10,0,110,111,32,109,101,109,111,114,121,32,102,114,111,109,32,122,109,97,108,108,111,99,40,41,10,0,111,98,106,0,101,109,105,116,46,99,0,112,111,112,95,111,98,106,95,115,116,97,116,101,0,99,108,117,115,116,0,37,108,100,0,108,110,114,99,111,108,111,114,115,99,104,101,109,101,0,105,110,32,99,108,117,115,116,101,114,32,37,115,10,0,77,111,114,101,32,116,104,97,110,32,50,32,99,111,108,111,114,115,32,115,112,101,99,105,102,105,101,100,32,102,111,114,32,97,32,103,114,97,100,105,101,110,116,32,45,32,105,103,110,111,114,105,110,103,32,114,101,109,97,105,110,105,110,103,10,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,101,115,116,105,110,103,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,115,116,121,108,101,58,32,37,115,10,0,117,110,109,97,116,99,104,101,100,32,39,41,39,32,105,110,32,115,116,121,108,101,58,32,37,115,10,0,116,114,117,110,99,97,116,105,110,103,32,115,116,121,108,101,32,39,37,115,39,10,0,117,110,109,97,116,99,104,101,100,32,39,40,39,32,105,110,32,115,116,121,108,101,58,32,37,115,10,0,67,0,76,97,121,111,117,116,32,119,97,115,32,110,111,116,32,100,111,110,101,46,32,32,77,105,115,115,105,110,103,32,108,97,121,111,117,116,32,112,108,117,103,105,110,115,63,32,10,0,103,118,82,101,110,100,101,114,74,111,98,115,32,37,115,58,32,37,46,50,102,32,115,101,99,115,46,10,0,108,97,121,111,117,116,32,119,97,115,32,110,111,116,32,100,111,110,101,10,0,114,101,110,100,101,114,101,114,32,102,111,114,32,37,115,32,105,115,32,117,110,97,118,97,105,108,97,98,108,101,10,0,112,97,103,101,100,105,114,61,37,115,32,105,103,110,111,114,101,100,10,0,118,105,101,119,112,111,114,116,0,37,108,102,44,37,108,102,44,37,108,102,44,39,37,91,94,39,93,39,0,37,108,102,44,37,108,102,44,37,108,102,44,37,91,94,44,93,37,115,0,37,108,102,44,37,108,102,44,37,108,102,44,37,108,102,44,37,108,102,0,111,117,116,112,117,116,111,114,100,101,114,0,111,100,101,115,102,105,114,115,116,0,100,103,101,115,102,105,114,115,116,0,108,97,121,101,114,115,0,108,97,121,101,114,115,101,108,101,99,116,0,84,104,101,32,108,97,121,101,114,115,101,108,101,99,116,32,97,116,116,114,105,98,117,116,101,32,34,37,115,34,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,97,110,121,32,108,97,121,101,114,32,115,112,101,99,105,102,101,100,32,98,121,32,116,104,101,32,108,97,121,101,114,115,32,97,116,116,114,105,98,117,116,101,32,45,32,105,103,110,111,114,101,100,46,10,0,97,108,108,0,108,97,121,101,114,115,101,112,0,58,9,32,0,108,97,121,101,114,108,105,115,116,115,101,112,0,44,0,84,104,101,32,99,104,97,114,97,99,116,101,114,32,39,37,99,39,32,97,112,112,101,97,114,115,32,105,110,32,98,111,116,104,32,116,104,101,32,108,97,121,101,114,115,101,112,32,97,110,100,32,108,97,121,101,114,108,105,115,116,115,101,112,32,97,116,116,114,105,98,117,116,101,115,32,45,32,108,97,121,101,114,108,105,115,116,115,101,112,32,105,103,110,111,114,101,100,46,10,0,112,97,100,0,66,76,0,112,97,103,101,100,105,114,0,115,111,108,105,100,0,0,115,101,116,108,105,110,101,119,105,100,116,104,0,49,0,0,115,112,108,45,62,115,105,122,101,32,62,32,48,0,105,110,105,116,95,115,112,108,105,110,101,115,95,98,98,0,98,122,46,115,105,122,101,32,62,32,48,0,98,101,122,105,101,114,95,98,98,0,98,122,46,115,105,122,101,32,37,32,51,32,61,61,32,49,0,101,109,105,116,95,101,100,103,101,95,108,97,98,101,108,0,37,115,45,37,115,0,102,111,114,119,97,114,100,0,98,97,99,107,0,32,45,62,32,0,32,45,45,32,0,105,110,32,101,100,103,101,32,37,115,37,115,37,115,10,0,101,100,103,101,104,114,101,102,0,101,100,103,101,85,82,76,0,108,97,98,101,108,104,114,101,102,0,108,97,98,101,108,85,82,76,0,116,97,105,108,104,114,101,102,0,116,97,105,108,85,82,76,0,104,101,97,100,104,114,101,102,0,104,101,97,100,85,82,76,0,101,100,103,101,116,97,114,103,101,116,0,108,97,98,101,108,116,97,114,103,101,116,0,116,97,105,108,116,97,114,103,101,116,0,104,101,97,100,116,97,114,103,101,116,0,101,100,103,101,116,111,111,108,116,105,112,0,108,97,98,101,108,116,111,111,108,116,105,112,0,116,97,105,108,116,111,111,108,116,105,112,0,104,101,97,100,116,111,111,108,116,105,112,0,103,114,97,100,105,101,110,116,32,112,101,110,32,99,111,108,111,114,115,32,110,111,116,32,121,101,116,32,115,117,112,112,111,114,116,101,100,46,10,0,73,109,97,103,101,115,32,117,110,115,117,112,112,111,114,116,101,100,32,105,110,32,34,98,97,99,107,103,114,111,117,110,100,34,32,97,116,116,114,105,98,117,116,101,10,0,108,97,121,101,114,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,105,110,32,37,115,32,111,117,116,112,117,116,10,0,84,111,116,97,108,32,115,105,122,101,32,62,32,49,32,105,110,32,34,37,115,34,32,99,111,108,111,114,32,115,112,101,99,32,0,73,108,108,101,103,97,108,32,108,101,110,103,116,104,32,118,97,108,117,101,32,105,110,32,34,37,115,34,32,99,111,108,111,114,32,97,116,116,114,105,98,117,116,101,32,0,112,97,103,101,37,100,44,37,100,95,0,0,0,0,37,108,102,0,102,111,110,116,112,97,116,104,0,68,79,84,70,79,78,84,80,65,84,72,0,71,68,70,79,78,84,80,65,84,72,0,105,109,97,103,101,112,97,116,104,0,113,117,97,110,116,117,109,0,114,97,110,107,100,105,114,0,76,82,0,66,84,0,82,76,0,110,111,100,101,115,101,112,0,114,97,110,107,115,101,112,0,101,113,117,97,108,108,121,0,115,104,111,119,98,111,120,101,115,0,102,111,110,116,110,97,109,101,115,0,115,105,122,101,0,112,97,103,101,0,99,101,110,116,101,114,0,114,111,116,97,116,101,0,111,114,105,101,110,116,97,116,105,111,110,0,108,97,110,100,115,99,97,112,101,0,99,108,117,115,116,101,114,114,97,110,107,0,99,111,110,99,101,110,116,114,97,116,101,0,100,112,105,0,114,101,115,111,108,117,116,105,111,110,0,111,114,100,101,114,105,110,103,0,102,105,108,108,99,111,108,111,114,0,102,111,110,116,115,105,122,101,0,102,111,110,116,110,97,109,101,0,102,111,110,116,99,111,108,111,114,0,120,108,97,98,101,108,0,112,101,110,119,105,100,116,104,0,112,101,114,105,112,104,101,114,105,101,115,0,115,107,101,119,0,100,105,115,116,111,114,116,105,111,110,0,110,111,106,117,115,116,105,102,121,0,108,97,121,101,114,0,103,114,111,117,112,0,99,111,109,109,101,110,116,0,118,101,114,116,105,99,101,115,0,122,0,119,101,105,103,104,116,0,108,97,98,101,108,102,108,111,97,116,0,100,105,114,0,97,114,114,111,119,104,101,97,100,0,97,114,114,111,119,116,97,105,108,0,104,101,97,100,108,97,98,101,108,0,116,97,105,108,108,97,98,101,108,0,108,97,98,101,108,102,111,110,116,115,105,122,101,0,108,97,98,101,108,102,111,110,116,110,97,109,101,0,108,97,98,101,108,102,111,110,116,99,111,108,111,114,0,108,97,98,101,108,100,105,115,116,97,110,99,101,0,108,97,98,101,108,97,110,103,108,101,0,109,105,110,108,101,110,0,100,101,99,111,114,97,116,101,0,97,114,114,111,119,115,105,122,101,0,99,111,110,115,116,114,97,105,110,116,0,116,97,105,108,99,108,105,112,0,104,101,97,100,99,108,105,112,0,108,97,98,101,108,106,117,115,116,0,85,84,70,45,56,0,73,83,79,45,56,56,53,57,45,49,0,66,73,71,45,53,0,85,110,115,117,112,112,111,114,116,101,100,32,99,104,97,114,115,101,116,32,118,97,108,117,101,32,37,100,10,0,108,111,99,97,108,0,103,108,111,98,97,108,0,37,108,102,44,37,108,102,37,99,0,37,108,102,37,99,0,114,97,116,105,111,0,97,117,116,111,0,99,111,109,112,114,101,115,115,0,101,120,112,97,110,100,0,102,105,108,108,0,103,100,0,112,115,0,115,118,103,0,99,104,97,114,115,101,116,0,117,116,102,45,56,0,108,97,116,105,110,45,49,0,108,97,116,105,110,49,0,108,49,0,73,83,79,95,56,56,53,57,45,49,0,73,83,79,56,56,53,57,45,49,0,73,83,79,45,73,82,45,49,48,48,0,98,105,103,45,53,0,98,105,103,53,0,117,116,102,56,0,85,110,115,117,112,112,111,114,116,101,100,32,99,104,97,114,115,101,116,32,34,37,115,34,32,45,32,97,115,115,117,109,105,110,103,32,117,116,102,45,56,10,0,105,110,32,108,97,98,101,108,32,111,102,32,103,114,97,112,104,32,37,115,10,0,105,110,32,108,97,98,101,108,32,111,102,32,110,111,100,101,32,37,115,10,0,105,110,32,108,97,98,101,108,32,111,102,32,101,100,103,101,32,37,115,32,37,115,32,37,115,10,0,107,105,110,100,32,61,61,32,76,84,95,78,79,78,69,0,108,97,98,101,108,115,46,99,0,109,97,107,101,95,108,97,98,101,108,0,38,97,109,112,59,0,38,108,116,59,0,38,103,116,59,0,38,35,52,53,59,0,38,35,49,54,48,59,0,38,113,117,111,116,59,0,38,35,51,57,59,0,92,71,0,92,69,0,92,72,0,92,84,0,92,76,0,110,101,116,119,111,114,107,32,115,105,109,112,108,101,120,58,32,0,37,115,32,37,100,32,110,111,100,101,115,32,37,100,32,101,100,103,101,115,32,109,97,120,105,116,101,114,61,37,100,32,98,97,108,97,110,99,101,61,37,100,10,0,37,100,32,0,37,115,37,100,32,110,111,100,101,115,32,37,100,32,101,100,103,101,115,32,37,100,32,105,116,101,114,32,37,46,50,102,32,115,101,99,10,0,115,101,97,114,99,104,115,105,122,101,0,117,112,100,97,116,101,58,32,109,105,115,109,97,116,99,104,101,100,32,108,99,97,32,105,110,32,116,114,101,101,117,112,100,97,116,101,115,10,0,97,100,100,95,116,114,101,101,95,101,100,103,101,58,32,109,105,115,115,105,110,103,32,116,114,101,101,32,101,100,103,101,10,0,97,100,100,95,116,114,101,101,95,101,100,103,101,58,32,101,109,112,116,121,32,111,117,116,101,100,103,101,32,108,105,115,116,10,0,97,100,100,95,116,114,101,101,95,101,100,103,101,58,32,101,109,112,116,121,32,105,110,101,100,103,101,32,108,105,115,116,10,0,116,114,111,117,98,108,101,32,105,110,32,105,110,105,116,95,114,97,110,107,10,0,9,37,115,32,37,100,10,0,103,114,97,112,104,32,0,32,0,110,111,100,101,32,0,115,116,111,112,10,0,112,111,115,0,114,101,99,116,115,0,120,108,112,0,108,112,0,104,101,97,100,95,108,112,0,116,97,105,108,95,108,112,0,108,119,105,100,116,104,0,108,104,101,105,103,104,116,0,98,98,0,37,46,53,103,44,37,46,53,103,44,37,46,53,103,0,44,37,46,53,103,0,37,46,53,103,44,37,46,53,103,0,37,46,53,103,0,115,97,109,112,108,101,112,111,105,110,116,115,0,37,46,53,103,32,37,46,53,103,0,115,44,37,46,53,103,44,37,46,53,103,32,0,101,44,37,46,53,103,44,37,46,53,103,32,0,37,46,53,103,44,37,46,53,103,44,37,46,53,103,44,37,46,53,103,0,37,46,50,102,0,37,46,53,103,44,37,46,53,103,44,37,46,53,103,44,37,46,53,103,32,0,0,0,0,47,112,97,116,104,98,111,120,32,123,10,32,32,32,32,47,88,32,101,120,99,104,32,110,101,103,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,89,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,120,32,101,120,99,104,32,110,101,103,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,121,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,110,101,119,112,97,116,104,32,120,32,121,32,109,111,118,101,116,111,10,32,32,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,32,32,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,125,32,100,101,102,10,0,47,112,97,116,104,98,111,120,32,123,10,32,32,32,32,47,89,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,88,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,121,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,47,120,32,101,120,99,104,32,37,46,53,103,32,115,117,98,32,100,101,102,10,32,32,32,32,110,101,119,112,97,116,104,32,120,32,121,32,109,111,118,101,116,111,10,32,32,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,32,32,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,32,125,32,100,101,102,10,47,100,98,103,115,116,97,114,116,32,123,32,103,115,97,118,101,32,37,46,53,103,32,37,46,53,103,32,116,114,97,110,115,108,97,116,101,32,125,32,100,101,102,10,47,97,114,114,111,119,108,101,110,103,116,104,32,49,48,32,100,101,102,10,47,97,114,114,111,119,119,105,100,116,104,32,97,114,114,111,119,108,101,110,103,116,104,32,50,32,100,105,118,32,100,101,102,10,47,97,114,114,111,119,104,101,97,100,32,123,10,32,32,32,32,103,115,97,118,101,10,32,32,32,32,114,111,116,97,116,101,10,32,32,32,32,99,117,114,114,101,110,116,112,111,105,110,116,10,32,32,32,32,110,101,119,112,97,116,104,10,32,32,32,32,109,111,118,101,116,111,10,32,32,32,32,97,114,114,111,119,108,101,110,103,116,104,32,97,114,114,111,119,119,105,100,116,104,32,50,32,100,105,118,32,114,108,105,110,101,116,111,10,32,32,32,32,48,32,97,114,114,111,119,119,105,100,116,104,32,110,101,103,32,114,108,105,110,101,116,111,10,32,32,32,32,99,108,111,115,101,112,97,116,104,32,102,105,108,108,10,32,32,32,32,103,114,101,115,116,111,114,101,10,125,32,98,105,110,100,32,100,101,102,10,47,109,97,107,101,97,114,114,111,119,32,123,10,32,32,32,32,99,117,114,114,101,110,116,112,111,105,110,116,32,101,120,99,104,32,112,111,112,32,115,117,98,32,101,120,99,104,32,99,117,114,114,101,110,116,112,111,105,110,116,32,112,111,112,32,115,117,98,32,97,116,97,110,10,32,32,32,32,97,114,114,111,119,104,101,97,100,10,125,32,98,105,110,100,32,100,101,102,10,47,112,111,105,110,116,32,123,32,32,32,32,110,101,119,112,97,116,104,32,32,32,32,50,32,48,32,51,54,48,32,97,114,99,32,102,105,108,108,125,32,100,101,102,47,109,97,107,101,118,101,99,32,123,10,32,32,32,32,47,89,32,101,120,99,104,32,100,101,102,10,32,32,32,32,47,88,32,101,120,99,104,32,100,101,102,10,32,32,32,32,47,121,32,101,120,99,104,32,100,101,102,10,32,32,32,32,47,120,32,101,120,99,104,32,100,101,102,10,32,32,32,32,110,101,119,112,97,116,104,32,120,32,121,32,109,111,118,101,116,111,10,32,32,32,32,88,32,89,32,108,105,110,101,116,111,32,115,116,114,111,107,101,10,32,32,32,32,88,32,89,32,109,111,118,101,116,111,10,32,32,32,32,120,32,121,32,109,97,107,101,97,114,114,111,119,10,125,32,100,101,102,10,0,108,111,115,116,32,37,115,32,37,115,32,101,100,103,101,10,0,110,111,32,112,111,115,105,116,105,111,110,32,102,111,114,32,101,100,103,101,32,119,105,116,104,32,108,97,98,101,108,32,37,115,0,110,111,32,112,111,115,105,116,105,111,110,32,102,111,114,32,101,100,103,101,32,119,105,116,104,32,116,97,105,108,32,108,97,98,101,108,32,37,115,0,110,111,32,112,111,115,105,116,105,111,110,32,102,111,114,32,101,100,103,101,32,119,105,116,104,32,104,101,97,100,32,108,97,98,101,108,32,37,115,0,110,111,32,112,111,115,105,116,105,111,110,32,102,111,114,32,101,100,103,101,32,119,105,116,104,32,120,108,97,98,101,108,32,37,115,0,102,111,114,99,101,108,97,98,101,108,115,0,37,100,32,111,117,116,32,111,102,32,37,100,32,108,97,98,101,108,115,32,112,111,115,105,116,105,111,110,101,100,46,10,0,37,100,32,111,117,116,32,111,102,32,37,100,32,101,120,116,101,114,105,111,114,32,108,97,98,101,108,115,32,112,111,115,105,116,105,111,110,101,100,46,10,0,37,100,32,111,98,106,115,32,37,100,32,120,108,97,98,101,108,115,32,102,111,114,99,101,61,37,100,32,98,98,61,40,37,46,48,50,102,44,37,46,48,50,102,41,32,40,37,46,48,50,102,44,37,46,48,50,102,41,10,0,111,98,106,101,99,116,115,10,0,32,91,37,100,93,32,40,37,46,48,50,102,44,37,46,48,50,102,41,32,40,37,46,48,50,102,44,37,46,48,50,102,41,32,37,112,32,34,37,115,34,10,0,120,108,97,98,101,108,115,10,0,32,91,37,100,93,32,37,112,32,115,101,116,32,37,100,32,40,37,46,48,50,102,44,37,46,48,50,102,41,32,40,37,46,48,50,102,44,37,46,48,50,102,41,32,37,115,10,0,115,104,97,112,101,102,105,108,101,32,110,111,116,32,115,101,116,32,111,114,32,110,111,116,32,102,111,117,110,100,32,102,111,114,32,101,112,115,102,32,110,111,100,101,32,37,115,10,0,99,97,110,39,116,32,102,105,110,100,32,108,105,98,114,97,114,121,32,102,105,108,101,32,37,115,10,0,99,97,110,39,116,32,111,112,101,110,32,108,105,98,114,97,114,121,32,102,105,108,101,32,37,115,10,0,69,79,70,0,66,69,71,73,78,0,69,78,68,0,84,82,65,73,76,69,82,0,47,117,115,101,114,95,115,104,97,112,101,95,37,100,32,123,10,0,37,37,66,101,103,105,110,68,111,99,117,109,101,110,116,58,10,0,37,37,69,110,100,68,111,99,117,109,101,110,116,10,0,125,32,98,105,110,100,32,100,101,102,10,0,85,84,70,45,56,32,105,110,112,117,116,32,117,115,101,115,32,110,111,110,45,76,97,116,105,110,49,32,99,104,97,114,97,99,116,101,114,115,32,119,104,105,99,104,32,99,97,110,110,111,116,32,98,101,32,104,97,110,100,108,101,100,32,98,121,32,116,104,105,115,32,80,111,115,116,83,99,114,105,112,116,32,100,114,105,118,101,114,10,0,99,111,117,108,100,110,39,116,32,111,112,101,110,32,101,112,115,102,32,102,105,108,101,32,37,115,10,0,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,0,114,101,97,100,0,66,111,117,110,100,105,110,103,66,111,120,32,110,111,116,32,102,111,117,110,100,32,105,110,32,101,112,115,102,32,102,105,108,101,32,37,115,10,0,114,111,117,116,101,115,112,108,105,110,101,115,105,110,105,116,58,32,99,97,110,110,111,116,32,97,108,108,111,99,97,116,101,32,112,115,10,0,114,111,117,116,101,115,112,108,105,110,101,115,58,32,37,100,32,101,100,103,101,115,44,32,37,100,32,98,111,120,101,115,32,37,46,50,102,32,115,101,99,10,0,105,110,32,114,111,117,116,101,115,112,108,105,110,101,115,44,32,99,97,110,110,111,116,32,102,105,110,100,32,78,79,82,77,65,76,32,101,100,103,101,10,0,105,110,32,114,111,117,116,101,115,112,108,105,110,101,115,44,32,105,108,108,101,103,97,108,32,118,97,108,117,101,115,32,111,102,32,112,114,101,118,32,37,100,32,97,110,100,32,110,101,120,116,32,37,100,44,32,108,105,110,101,32,37,100,10,0,105,110,32,114,111,117,116,101,115,112,108,105,110,101,115,44,32,101,100,103,101,32,105,115,32,97,32,108,111,111,112,32,97,116,32,37,115,10,0,105,110,32,114,111,117,116,101,115,112,108,105,110,101,115,44,32,80,115,104,111,114,116,101,115,116,112,97,116,104,32,102,97,105,108,101,100,10,0,105,110,32,114,111,117,116,101,115,112,108,105,110,101,115,44,32,80,114,111,117,116,101,115,112,108,105,110,101,32,102,97,105,108,101,100,10,0,85,110,97,98,108,101,32,116,111,32,114,101,99,108,97,105,109,32,98,111,120,32,115,112,97,99,101,32,105,110,32,115,112,108,105,110,101,32,114,111,117,116,105,110,103,32,102,111,114,32,101,100,103,101,32,34,37,115,34,32,45,62,32,34,37,115,34,46,32,83,111,109,101,116,104,105,110,103,32,105,115,32,112,114,111,98,97,98,108,121,32,115,101,114,105,111,117,115,108,121,32,119,114,111,110,103,46,10,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,98,111,120,32,48,32,104,97,115,32,76,76,32,99,111,111,114,100,32,62,32,85,82,32,99,111,111,114,100,10,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,98,111,120,32,37,100,32,104,97,115,32,76,76,32,99,111,111,114,100,32,62,32,85,82,32,99,111,111,114,100,10,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,98,111,120,101,115,32,37,100,32,97,110,100,32,37,100,32,100,111,110,39,116,32,116,111,117,99,104,10,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,115,116,97,114,116,32,112,111,114,116,32,110,111,116,32,105,110,32,102,105,114,115,116,32,98,111,120,10,0,105,110,32,99,104,101,99,107,112,97,116,104,44,32,101,110,100,32,112,111,114,116,32,110,111,116,32,105,110,32,108,97,115,116,32,98,111,120,10,0,37,100,32,98,111,120,101,115,58,10,0,37,100,32,40,37,46,53,103,44,32,37,46,53,103,41,44,32,40,37,46,53,103,44,32,37,46,53,103,41,10,0,99,111,110,115,116,114,97,105,110,101,100,0,110,111,116,32,99,111,110,115,116,114,97,105,110,101,100,0,115,116,97,114],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+132702);allocate([116,32,112,111,114,116,58,32,40,37,46,53,103,44,32,37,46,53,103,41,44,32,116,97,110,103,101,110,116,32,97,110,103,108,101,58,32,37,46,53,103,44,32,37,115,10,0,101,110,100,32,112,111,114,116,58,32,40,37,46,53,103,44,32,37,46,53,103,41,44,32,116,97,110,103,101,110,116,32,97,110,103,108,101,58,32,37,46,53,103,44,32,37,115,10,0,99,97,110,110,111,116,32,114,101,45,97,108,108,111,99,97,116,101,32,112,115,10,0,115,105,100,101,115,32,61,61,32,52,0,115,104,97,112,101,115,46,99,0,114,111,117,110,100,95,99,111,114,110,101,114,115,0,115,104,97,112,101,102,105,108,101,0,101,112,115,102,0,99,117,115,116,111,109,0,115,0,101,0,119,0,117,115,105,110,103,32,37,115,32,102,111,114,32,117,110,107,110,111,119,110,32,115,104,97,112,101,32,37,115,10,0,112,111,108,121,103,111,110,0,111,118,97,108,0,99,105,114,99,108,101,0,112,111,105,110,116,0,101,103,103,0,116,114,105,97,110,103,108,101,0,112,108,97,105,110,116,101,120,116,0,100,105,97,109,111,110,100,0,116,114,97,112,101,122,105,117,109,0,112,97,114,97,108,108,101,108,111,103,114,97,109,0,104,111,117,115,101,0,112,101,110,116,97,103,111,110,0,104,101,120,97,103,111,110,0,115,101,112,116,97,103,111,110,0,111,99,116,97,103,111,110,0,110,111,116,101,0,116,97,98,0,102,111,108,100,101,114,0,98,111,120,51,100,0,99,111,109,112,111,110,101,110,116,0,114,101,99,116,0,114,101,99,116,97,110,103,108,101,0,115,113,117,97,114,101,0,100,111,117,98,108,101,99,105,114,99,108,101,0,100,111,117,98,108,101,111,99,116,97,103,111,110,0,116,114,105,112,108,101,111,99,116,97,103,111,110,0,105,110,118,116,114,105,97,110,103,108,101,0,105,110,118,116,114,97,112,101,122,105,117,109,0,105,110,118,104,111,117,115,101,0,117,110,100,101,114,108,105,110,101,0,77,100,105,97,109,111,110,100,0,77,115,113,117,97,114,101,0,77,99,105,114,99,108,101,0,112,114,111,109,111,116,101,114,0,99,100,115,0,116,101,114,109,105,110,97,116,111,114,0,117,116,114,0,105,110,115,117,108,97,116,111,114,0,114,105,98,111,115,105,116,101,0,114,110,97,115,116,97,98,0,112,114,111,116,101,97,115,101,115,105,116,101,0,112,114,111,116,101,105,110,115,116,97,98,0,112,114,105,109,101,114,115,105,116,101,0,114,101,115,116,114,105,99,116,105,111,110,115,105,116,101,0,102,105,118,101,112,111,118,101,114,104,97,110,103,0,116,104,114,101,101,112,111,118,101,114,104,97,110,103,0,110,111,118,101,114,104,97,110,103,0,97,115,115,101,109,98,108,121,0,115,105,103,110,97,116,117,114,101,0,114,112,114,111,109,111,116,101,114,0,108,97,114,114,111,119,0,114,97,114,114,111,119,0,108,112,114,111,109,111,116,101,114,0,114,101,99,111,114,100,0,77,114,101,99,111,114,100,0,115,116,97,114,0,35,56,48,56,48,56,48,0,35,102,99,102,99,102,99,0,35,51,48,51,48,51,48,0,35,101,56,101,56,101,56,0,35,101,48,101,48,101,48,0,35,102,48,102,48,102,48,0,35,49,48,49,48,49,48,0,35,102,56,102,56,102,56,0,105,110,32,110,111,100,101,32,37,115,10,0,114,111,117,110,100,101,100,0,100,105,97,103,111,110,97,108,115,0,114,97,100,105,97,108,0,115,116,114,105,112,101,100,0,119,101,100,103,101,100,0,95,0,110,111,100,101,32,37,115,44,32,112,111,114,116,32,37,115,44,32,117,110,114,101,99,111,103,110,105,122,101,100,32,99,111,109,112,97,115,115,32,112,111,105,110,116,32,39,37,115,39,32,45,32,105,103,110,111,114,101,100,10,0,110,111,100,101,32,37,115,44,32,112,111,114,116,32,37,115,32,117,110,114,101,99,111,103,110,105,122,101,100,10,0,37,46,53,103,32,37,46,53,103,32,116,114,97,110,115,108,97,116,101,32,110,101,119,112,97,116,104,32,117,115,101,114,95,115,104,97,112,101,95,37,100,10,0,105,110,118,105,115,0,0,102,105,108,108,101,100,0,0,98,97,100,32,108,97,98,101,108,32,102,111,114,109,97,116,32,37,115,10,0,92,78,0,109,97,114,103,105,110,0,37,108,102,44,37,108,102,0,114,101,103,117,108,97,114,0,60,110,105,108,62,0,78,111,32,111,114,32,105,109,112,114,111,112,101,114,32,115,104,97,112,101,102,105,108,101,61,34,37,115,34,32,102,111,114,32,110,111,100,101,32,34,37,115,34,10,0,78,111,32,111,114,32,105,109,112,114,111,112,101,114,32,105,109,97,103,101,61,34,37,115,34,32,102,111,114,32,110,111,100,101,32,34,37,115,34,10,0,108,97,98,101,108,108,111,99,0,110,111,100,101,32,39,37,115,39,44,32,103,114,97,112,104,32,39,37,115,39,32,115,105,122,101,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,108,97,98,101,108,10,0,115,112,108,105,110,101,115,46,99,0,98,101,103,105,110,112,97,116,104,0,80,45,62,101,110,100,46,116,104,101,116,97,32,60,32,50,32,42,32,77,95,80,73,0,101,110,100,112,97,116,104,0,109,97,107,101,83,101,108,102,69,100,103,101,0,103,101,116,115,112,108,105,110,101,112,111,105,110,116,115,58,32,110,111,32,115,112,108,105,110,101,32,112,111,105,110,116,115,32,97,118,97,105,108,97,98,108,101,32,102,111,114,32,101,100,103,101,32,40,37,115,44,37,115,41,10,0,112,111,108,121,108,105,110,101,77,105,100,112,111,105,110,116,0,115,112,97,110,45,62,102,111,110,116,0,116,101,120,116,115,112,97,110,46,99,0,116,101,120,116,115,112,97,110,95,115,105,122,101,0,102,111,110,116,45,62,110,97,109,101,0,102,111,110,116,110,97,109,101,58,32,34,37,115,34,32,114,101,115,111,108,118,101,100,32,116,111,58,32,37,115,10,0,102,111,110,116,110,97,109,101,58,32,117,110,97,98,108,101,32,116,111,32,114,101,115,111,108,118,101,32,34,37,115,34,10,0,99,111,117,114,0,91,105,110,116,101,114,110,97,108,32,99,111,117,114,105,101,114,93,0,97,114,105,97,108,0,104,101,108,118,101,116,105,99,97,0,91,105,110,116,101,114,110,97,108,32,97,114,105,97,108,93,0,91,105,110,116,101,114,110,97,108,32,116,105,109,101,115,93,0,65,118,97,110,116,71,97,114,100,101,45,66,111,111,107,0,85,82,87,32,71,111,116,104,105,99,32,76,0,98,111,111,107,0,115,97,110,115,45,83,101,114,105,102,0,65,118,97,110,116,71,97,114,100,101,45,66,111,111,107,79,98,108,105,113,117,101,0,111,98,108,105,113,117,101,0,105,116,97,108,105,99,0,65,118,97,110,116,71,97,114,100,101,45,68,101,109,105,0,100,101,109,105,0,65,118,97,110,116,71,97,114,100,101,45,68,101,109,105,79,98,108,105,113,117,101,0,66,111,111,107,109,97,110,45,68,101,109,105,0,85,82,87,32,66,111,111,107,109,97,110,32,76,0,115,101,114,105,102,0,66,111,111,107,109,97,110,45,68,101,109,105,73,116,97,108,105,99,0,66,111,111,107,109,97,110,45,76,105,103,104,116,0,108,105,103,104,116,0,66,111,111,107,109,97,110,45,76,105,103,104,116,73,116,97,108,105,99,0,67,111,117,114,105,101,114,0,109,111,110,111,115,112,97,99,101,0,67,111,117,114,105,101,114,45,66,111,108,100,0,67,111,117,114,105,101,114,45,66,111,108,100,79,98,108,105,113,117,101,0,67,111,117,114,105,101,114,45,79,98,108,105,113,117,101,0,72,101,108,118,101,116,105,99,97,0,72,101,108,118,101,116,105,99,97,45,66,111,108,100,0,72,101,108,118,101,116,105,99,97,45,66,111,108,100,79,98,108,105,113,117,101,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,0,99,111,110,100,101,110,115,101,100,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,45,66,111,108,100,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,45,66,111,108,100,79,98,108,105,113,117,101,0,72,101,108,118,101,116,105,99,97,45,78,97,114,114,111,119,45,79,98,108,105,113,117,101,0,72,101,108,118,101,116,105,99,97,45,79,98,108,105,113,117,101,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,66,111,108,100,0,67,101,110,116,117,114,121,32,83,99,104,111,111,108,98,111,111,107,32,76,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,66,111,108,100,73,116,97,108,105,99,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,73,116,97,108,105,99,0,78,101,119,67,101,110,116,117,114,121,83,99,104,108,98,107,45,82,111,109,97,110,0,114,111,109,97,110,0,80,97,108,97,116,105,110,111,45,66,111,108,100,0,80,97,108,97,116,105,110,111,32,76,105,110,111,116,121,112,101,0,80,97,108,97,116,105,110,111,45,66,111,108,100,73,116,97,108,105,99,0,80,97,108,97,116,105,110,111,45,73,116,97,108,105,99,0,80,97,108,97,116,105,110,111,45,82,111,109,97,110,0,83,121,109,98,111,108,0,102,97,110,116,97,115,121,0,84,105,109,101,115,45,66,111,108,100,0,84,105,109,101,115,0,84,105,109,101,115,45,66,111,108,100,73,116,97,108,105,99,0,84,105,109,101,115,45,73,116,97,108,105,99,0,90,97,112,102,67,104,97,110,99,101,114,121,45,77,101,100,105,117,109,73,116,97,108,105,99,0,85,82,87,32,67,104,97,110,99,101,114,121,32,76,0,109,101,100,105,117,109,0,90,97,112,102,68,105,110,103,98,97,116,115,0,68,105,110,103,98,97,116,115,0,105,110,112,117,116,115,99,97,108,101,0,117,116,105,108,115,46,99,0,117,32,61,61,32,85,70,95,102,105,110,100,40,117,41,0,85,70,95,115,101,116,110,97,109,101,0,1,102,105,108,101,32,108,111,97,100,105,110,103,32,105,115,32,100,105,115,97,98,108,101,100,32,98,101,99,97,117,115,101,32,116,104,101,32,101,110,118,105,114,111,110,109,101,110,116,32,99,111,110,116,97,105,110,115,32,83,69,82,86,69,82,95,78,65,77,69,61,34,37,115,34,10,97,110,100,32,116,104,101,32,71,86,95,70,73,76,69,95,80,65,84,72,32,118,97,114,105,97,98,108,101,32,105,115,32,117,110,115,101,116,32,111,114,32,101,109,112,116,121,46,10,0,80,97,116,104,32,112,114,111,118,105,100,101,100,32,116,111,32,102,105,108,101,58,32,34,37,115,34,32,104,97,115,32,98,101,101,110,32,105,103,110,111,114,101,100,32,98,101,99,97,117,115,101,32,102,105,108,101,115,32,97,114,101,32,111,110,108,121,32,112,101,114,109,105,116,116,101,100,32,116,111,32,98,101,32,108,111,97,100,101,100,32,102,114,111,109,32,116,104,101,32,100,105,114,101,99,116,111,114,105,101,115,32,105,110,32,34,37,115,34,32,119,104,101,110,32,114,117,110,110,105,110,103,32,105,110,32,97,110,32,104,116,116,112,32,115,101,114,118,101,114,46,10,0,47,0,110,111,0,116,114,117,101,0,121,101,115,0,101,108,108,105,112,115,101,0,84,105,109,101,115,45,82,111,109,97,110,0,99,108,117,115,116,101,114,0,95,95,99,108,117,115,116,101,114,110,111,100,101,115,0,0,85,84,70,56,32,99,111,100,101,115,32,62,32,52,32,98,121,116,101,115,32,97,114,101,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,101,100,32,40,103,114,97,112,104,32,37,115,41,32,45,32,116,114,101,97,116,101,100,32,97,115,32,76,97,116,105,110,45,49,46,32,80,101,114,104,97,112,115,32,34,45,71,99,104,97,114,115,101,116,61,108,97,116,105,110,49,34,32,105,115,32,110,101,101,100,101,100,63,10,0,73,110,118,97,108,105,100,32,37,100,45,98,121,116,101,32,85,84,70,56,32,102,111,117,110,100,32,105,110,32,105,110,112,117,116,32,111,102,32,103,114,97,112,104,32,37,115,32,45,32,116,114,101,97,116,101,100,32,97,115,32,76,97,116,105,110,45,49,46,32,80,101,114,104,97,112,115,32,34,45,71,99,104,97,114,115,101,116,61,108,97,116,105,110,49,34,32,105,115,32,110,101,101,100,101,100,63,10,0,117,114,118,101,100,0,111,109,112,111,117,110,100,0,97,108,115,101,0,105,110,101,0,111,110,101,0,111,0,114,116,104,111,0,111,108,121,108,105,110,101,0,112,108,105,110,101,0,114,117,101,0,101,115,0,85,110,107,110,111,119,110,32,34,115,112,108,105,110,101,115,34,32,118,97,108,117,101,58,32,34,37,115,34,32,45,32,105,103,110,111,114,101,100,10,0,115,112,108,105,110,101,115,0,98,122,46,115,105,122,101,0,111,118,101,114,108,97,112,95,98,101,122,105,101,114,0,65,69,108,105,103,0,65,97,99,117,116,101,0,65,99,105,114,99,0,65,103,114,97,118,101,0,65,108,112,104,97,0,65,114,105,110,103,0,65,116,105,108,100,101,0,65,117,109,108,0,66,101,116,97,0,67,99,101,100,105,108,0,67,104,105,0,68,97,103,103,101,114,0,68,101,108,116,97,0,69,84,72,0,69,97,99,117,116,101,0,69,99,105,114,99,0,69,103,114,97,118,101,0,69,112,115,105,108,111,110,0,69,116,97,0,69,117,109,108,0,71,97,109,109,97,0,73,97,99,117,116,101,0,73,99,105,114,99,0,73,103,114,97,118,101,0,73,111,116,97,0,73,117,109,108,0,75,97,112,112,97,0,76,97,109,98,100,97,0,77,117,0,78,116,105,108,100,101,0,78,117,0,79,69,108,105,103,0,79,97,99,117,116,101,0,79,99,105,114,99,0,79,103,114,97,118,101,0,79,109,101,103,97,0,79,109,105,99,114,111,110,0,79,115,108,97,115,104,0,79,116,105,108,100,101,0,79,117,109,108,0,80,104,105,0,80,105,0,80,114,105,109,101,0,80,115,105,0,82,104,111,0,83,99,97,114,111,110,0,83,105,103,109,97,0,84,72,79,82,78,0,84,97,117,0,84,104,101,116,97,0,85,97,99,117,116,101,0,85,99,105,114,99,0,85,103,114,97,118,101,0,85,112,115,105,108,111,110,0,85,117,109,108,0,88,105,0,89,97,99,117,116,101,0,89,117,109,108,0,90,101,116,97,0,97,97,99,117,116,101,0,97,99,105,114,99,0,97,99,117,116,101,0,97,101,108,105,103,0,97,103,114,97,118,101,0,97,108,101,102,115,121,109,0,97,108,112,104,97,0,97,109,112,0,97,110,100,0,97,110,103,0,97,114,105,110,103,0,97,115,121,109,112,0,97,116,105,108,100,101,0,97,117,109,108,0,98,100,113,117,111,0,98,101,116,97,0,98,114,118,98,97,114,0,98,117,108,108,0,99,97,112,0,99,99,101,100,105,108,0,99,101,100,105,108,0,99,101,110,116,0,99,104,105,0,99,105,114,99,0,99,108,117,98,115,0,99,111,110,103,0,99,111,112,121,0,99,114,97,114,114,0,99,117,112,0,99,117,114,114,101,110,0,100,65,114,114,0,100,97,103,103,101,114,0,100,97,114,114,0,100,101,103,0,100,101,108,116,97,0,100,105,97,109,115,0,100,105,118,105,100,101,0,101,97,99,117,116,101,0,101,99,105,114,99,0,101,103,114,97,118,101,0,101,109,112,116,121,0,101,109,115,112,0,101,110,115,112,0,101,112,115,105,108,111,110,0,101,113,117,105,118,0,101,116,97,0,101,116,104,0,101,117,109,108,0,101,117,114,111,0,101,120,105,115,116,0,102,110,111,102,0,102,111,114,97,108,108,0,102,114,97,99,49,50,0,102,114,97,99,49,52,0,102,114,97,99,51,52,0,102,114,97,115,108,0,103,97,109,109,97,0,103,101,0,103,116,0,104,65,114,114,0,104,97,114,114,0,104,101,97,114,116,115,0,104,101,108,108,105,112,0,105,97,99,117,116,101,0,105,99,105,114,99,0,105,101,120,99,108,0,105,103,114,97,118,101,0,105,109,97,103,101,0,105,110,102,105,110,0,105,110,116,0,105,111,116,97,0,105,113,117,101,115,116,0,105,115,105,110,0,105,117,109,108,0,107,97,112,112,97,0,108,65,114,114,0,108,97,109,98,100,97,0,108,97,110,103,0,108,97,113,117,111,0,108,97,114,114,0,108,99,101,105,108,0,108,100,113,117,111,0,108,101,0,108,102,108,111,111,114,0,108,111,119,97,115,116,0,108,111,122,0,108,114,109,0,108,115,97,113,117,111,0,108,115,113,117,111,0,108,116,0,109,97,99,114,0,109,100,97,115,104,0,109,105,99,114,111,0,109,105,100,100,111,116,0,109,117,0,110,97,98,108,97,0,110,98,115,112,0,110,100,97,115,104,0,110,101,0,110,105,0,110,111,116,0,110,111,116,105,110,0,110,115,117,98,0,110,116,105,108,100,101,0,110,117,0,111,97,99,117,116,101,0,111,99,105,114,99,0,111,101,108,105,103,0,111,103,114,97,118,101,0,111,108,105,110,101,0,111,109,101,103,97,0,111,109,105,99,114,111,110,0,111,112,108,117,115,0,111,114,0,111,114,100,102,0,111,114,100,109,0,111,115,108,97,115,104,0,111,116,105,108,100,101,0,111,116,105,109,101,115,0,111,117,109,108,0,112,97,114,97,0,112,97,114,116,0,112,101,114,109,105,108,0,112,101,114,112,0,112,104,105,0,112,105,0,112,105,118,0,112,108,117,115,109,110,0,112,111,117,110,100,0,112,114,105,109,101,0,112,114,111,100,0,112,114,111,112,0,112,115,105,0,113,117,111,116,0,114,65,114,114,0,114,97,100,105,99,0,114,97,110,103,0,114,97,113,117,111,0,114,97,114,114,0,114,99,101,105,108,0,114,100,113,117,111,0,114,101,97,108,0,114,101,103,0,114,102,108,111,111,114,0,114,104,111,0,114,108,109,0,114,115,97,113,117,111,0,114,115,113,117,111,0,115,98,113,117,111,0,115,99,97,114,111,110,0,115,100,111,116,0,115,101,99,116,0,115,104,121,0,115,105,103,109,97,0,115,105,103,109,97,102,0,115,105,109,0,115,112,97,100,101,115,0,115,117,98,0,115,117,98,101,0,115,117,109,0,115,117,112,0,115,117,112,49,0,115,117,112,50,0,115,117,112,51,0,115,117,112,101,0,115,122,108,105,103,0,116,97,117,0,116,104,101,114,101,52,0,116,104,101,116,97,0,116,104,101,116,97,115,121,109,0,116,104,105,110,115,112,0,116,104,111,114,110,0,116,105,108,100,101,0,116,105,109,101,115,0,116,114,97,100,101,0,117,65,114,114,0,117,97,99,117,116,101,0,117,97,114,114,0,117,99,105,114,99,0,117,103,114,97,118,101,0,117,109,108,0,117,112,115,105,104,0,117,112,115,105,108,111,110,0,117,117,109,108,0,119,101,105,101,114,112,0,120,105,0,121,97,99,117,116,101,0,121,101,110,0,121,117,109,108,0,122,101,116,97,0,122,119,106,0,122,119,110,106,0,109,97,112,78,0,84,119,111,32,99,108,117,115,116,101,114,115,32,110,97,109,101,100,32,37,115,32,45,32,116,104,101,32,115,101,99,111,110,100,32,119,105,108,108,32,98,101,32,105,103,110,111,114,101,100,10,0,99,108,117,115,116,101,114,32,99,121,99,108,101,32,37,115,32,45,45,32,37,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,10,0,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,32,105,110,115,105,100,101,32,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,10,0,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,32,105,110,115,105,100,101,32,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,10,0,116,97,105,108,32,110,111,100,101,32,37,115,32,105,110,115,105,100,101,32,104,101,97,100,32,99,108,117,115,116,101,114,32,37,115,10,0,104,101,97,100,32,110,111,100,101,32,37,115,32,105,110,115,105,100,101,32,116,97,105,108,32,99,108,117,115,116,101,114,32,37,115,10,0,95,95,0,108,97,98,101,108,0,115,104,97,112,101,0,98,111,120,0,37,115,37,115,37,115,0,111,100,98,0,79,114,116,104,111,103,111,110,97,108,32,101,100,103,101,115,32,100,111,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,104,97,110,100,108,101,32,101,100,103,101,32,108,97,98,101,108,115,46,32,84,114,121,32,117,115,105,110,103,32,120,108,97,98,101,108,115,46,10,0,111,114,116,104,111,32,37,115,32,37,115,10,0,99,104,97,110,105,0,111,114,116,104,111,46,99,0,99,104,97,110,83,101,97,114,99,104,0,99,112,0,37,115,0,37,100,32,37,100,32,116,114,97,110,115,108,97,116,101,10,0,48,46,56,32,48,46,56,32,48,46,56,32,115,101,116,114,103,98,99,111,108,111,114,10,0,115,104,111,119,112,97,103,101,10,37,37,37,37,84,114,97,105,108,101,114,10,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,110,101,119,112,97,116,104,32,37,100,32,37,100,32,109,111,118,101,116,111,10,0,37,100,32,37,100,32,108,105,110,101,116,111,10,0,37,100,32,37,100,32,108,105,110,101,116,111,32,115,116,114,111,107,101,10,0,37,37,33,80,83,45,65,100,111,98,101,45,50,46,48,10,37,37,37,37,66,111,117,110,100,105,110,103,66,111,120,58,32,40,97,116,101,110,100,41,10,47,112,111,105,110,116,32,123,10,32,32,47,89,32,101,120,99,104,32,100,101,102,10,32,32,47,88,32,101,120,99,104,32,100,101,102,10,32,32,110,101,119,112,97,116,104,10,32,32,88,32,89,32,51,32,48,32,51,54,48,32,97,114,99,32,102,105,108,108,10,125,32,100,101,102,10,47,99,101,108,108,32,123,10,32,32,47,89,32,101,120,99,104,32,100,101,102,10,32,32,47,88,32,101,120,99,104,32,100,101,102,10,32,32,47,121,32,101,120,99,104,32,100,101,102,10,32,32,47,120,32,101,120,99,104,32,100,101,102,10,32,32,110,101,119,112,97,116,104,10,32,32,120,32,121,32,109,111,118,101,116,111,10,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,125,32,100,101,102,10,47,110,111,100,101,32,123,10,32,47,117,32,101,120,99,104,32,100,101,102,10,32,47,114,32,101,120,99,104,32,100,101,102,10,32,47,100,32,101,120,99,104,32,100,101,102,10,32,47,108,32,101,120,99,104,32,100,101,102,10,32,110,101,119,112,97,116,104,32,108,32,100,32,109,111,118,101,116,111,10,32,114,32,100,32,108,105,110,101,116,111,32,114,32,117,32,108,105,110,101,116,111,32,108,32,117,32,108,105,110,101,116,111,10,32,99,108,111,115,101,112,97,116,104,32,102,105,108,108,10,125,32,100,101,102,10,10,0,99,104,97,110,110,101,108,32,37,100,32,40,37,102,44,37,102,41,10,0,32,45,62,10,0,32,32,32,32,32,0,40,40,37,102,44,37,102,41,44,40,37,102,44,37,102,41,41,32,37,115,32,37,115,0,66,95,78,79,68,69,0,66,95,85,80,0,66,95,76,69,70,84,0,66,95,68,79,87,78,0,66,95,82,73,71,72,84,0,115,101,103,0,110,101,120,116,95,115,101,103,0,100,101,99,105,100,101,95,112,111,105,110,116,0,105,110,99,111,109,112,97,114,97,98,108,101,32,115,101,103,109,101,110,116,115,32,33,33,32,45,45,32,65,98,111,114,116,105,110,103,10,0,115,49,45,62,99,111,109,109,95,99,111,111,114,100,61,61,115,50,45,62,99,111,109,109,95,99,111,111,114,100,0,105,115,95,112,97,114,97,108,108,101,108,0,103,114,97,112,104,32,71,32,123,10,0,32,110,111,100,101,91,115,104,97,112,101,61,112,111,105,110,116,93,10,0,32,32,37,100,32,91,112,111,115,61,34,37,100,44,37,100,34,93,10,0,32,32,37,100,32,45,45,32,37,100,91,108,101,110,61,34,37,102,34,93,10,0,125,10,0,115,111,108,105,100,0,105,110,118,105,115,105,98,108,101,0,98,111,108,100,0,115,101,116,108,105,110,101,119,105,100,116,104,0,102,105,108,108,101,100,0,117,110,102,105,108,108,101,100,0,116,97,112,101,114,101,100,0,103,118,114,101,110,100,101,114,95,115,101,116,95,115,116,121,108,101,58,32,117,110,115,117,112,112,111,114,116,101,100,32,115,116,121,108,101,32,37,115,32,45,32,105,103,110,111,114,105,110,103,10,0,103,118,114,101,110,100,101,114,46,99,0,103,118,114,101,110,100,101,114,95,117,115,101,114,115,104,97,112,101,0,110,97,109,101,0,110,97,109,101,91,48,93,0,98,111,116,104,0,99,111,108,111,114,32,37,115,0,37,115,32,105,115,32,110,111,116,32,97,32,107,110,111,119,110,32,99,111,108,111,114,46,10,0,101,114,114,111,114,32,105,110,32,99,111,108,120,108,97,116,101,40,41,10,0,106,111,98,0,103,118,108,111,97,100,105,109,97,103,101,46,99,0,103,118,108,111,97,100,105,109,97,103,101,0,117,115,0,117,115,45,62,110,97,109,101,0,117,115,45,62,110,97,109,101,91,48,93,0,58,0,78,111,32,108,111,97,100,105,109,97,103,101,32,112,108,117,103,105,110,32,102,111,114,32,34,37,115,34,10,0,103,114,97,112,104,118,105,122,0,50,46,51,56,46,48,0,50,48,49,52,48,52,49,51,46,50,48,52,49,0,81,0,76,101,102,116,0,75,80,95,76,101,102,116,0,82,105,103,104,116,0,75,80,95,82,105,103,104,116,0,85,112,0,75,80,95,85,112,0,68,111,119,110,0,75,80,95,68,111,119,110,0,112,108,117,115,0,75,80,95,65,100,100,0,109,105,110,117,115,0,75,80,95,83,117,98,116,114,97,99,116,0,70,0,71,0,110,101,119,46,103,118,0,85,82,76,0,107,101,121,0,104,101,97,100,112,111,114,116,0,116,97,105,108,112,111,114,116,0,101,100,103,101,0,110,111,100,101,0,115,117,98,103,114,97,112,104,0,103,114,97,112,104,0,100,105,103,114,97,112,104,0,95,76,84,88,95,108,105,98,114,97,114,121,0,116,101,120,116,108,97,121,111,117,116,0,111,98,106,112,45,62,108,98,108,0,120,108,97,98,101,108,115,46,99,0,120,108,97,100,106,117,115,116,0,120,108,105,110,116,101,114,115,101,99,116,105,111,110,115,0,108,112,32,33,61,32,99,108,112,0,103,101,116,105,110,116,114,115,120,105,0,111,98,106,112,49,45,62,115,122,46,120,32,61,61,32,48,32,38,38,32,111,98,106,112,49,45,62,115,122,46,121,32,61,61,32,48,0,108,98,108,101,110,99,108,111,115,105,110,103,0,118,112,0,120,108,104,100,120,117,110,108,111,97,100,0,115,105,122,101,61,61,102,114,101,101,100,0,114,101,99,116,46,98,111,117,110,100,97,114,121,91,50,93,32,60,32,73,78,84,95,77,65,88,0,111,98,106,112,108,112,109,107,115,0,114,101,99,116,46,98,111,117,110,100,97,114,121,91,51,93,32,60,32,73,78,84,95,77,65,88,0,111,117,116,32,111,102,32,109,101,109,111,114,121,10,0,35,37,50,120,37,50,120,37,50,120,37,50,120,0,37,108,102,37,108,102,37,108,102,0,47,97,99,99,101,110,116,51,47,49,0,47,97,99,99,101,110,116,51,47,50,0,47,97,99,99,101,110,116,51,47,51,0,47,97,99,99,101,110,116,52,47,49,0,47,97,99,99,101,110,116,52,47,50,0,47,97,99,99,101,110,116,52,47,51,0,47,97,99,99,101,110,116,52,47,52,0,47,97,99,99,101,110,116,53,47,49,0,47,97,99,99,101,110,116,53,47,50,0,47,97,99,99,101,110,116,53,47,51,0,47,97,99,99,101,110,116,53,47,52,0,47,97,99,99,101,110,116,53,47,53,0,47,97,99,99,101,110,116,54,47,49,0,47,97,99,99,101,110,116,54,47,50,0,47,97,99,99,101,110,116,54,47,51,0,47,97,99,99,101,110,116,54,47,52,0,47,97,99,99,101,110,116,54,47,53,0,47,97,99,99,101,110,116,54,47,54,0,47,97,99,99,101,110,116,55,47,49,0,47,97,99,99,101,110,116,55,47,50,0,47,97,99,99,101,110,116,55,47,51,0,47,97,99,99,101,110,116,55,47,52,0,47,97,99,99,101,110,116,55,47,53,0,47,97,99,99,101,110,116,55,47,54,0,47,97,99,99,101,110,116,55,47,55,0,47,97,99,99,101,110,116,56,47,49,0,47,97,99,99,101,110,116,56,47,50,0,47,97,99,99,101,110,116,56,47,51,0,47,97,99,99,101,110,116,56,47,52,0,47,97,99,99,101,110,116,56,47,53,0,47,97,99,99,101,110,116,56,47,54,0,47,97,99,99,101,110,116,56,47,55,0,47,97,99,99,101,110,116,56,47,56,0,47,98,108,117,101,115,51,47,49,0,47,98,108,117,101,115,51,47,50,0,47,98,108,117,101,115,51,47,51,0,47,98,108,117,101,115,52,47,49,0,47,98,108,117,101,115,52,47,50,0,47,98,108,117,101,115,52,47,51,0,47,98,108,117,101,115,52,47,52,0,47,98,108,117,101,115,53,47,49,0,47,98,108,117,101,115,53,47,50,0,47,98,108,117,101,115,53,47,51,0,47,98,108,117,101,115,53,47,52,0,47,98,108,117,101,115,53,47,53,0,47,98,108,117,101,115,54,47,49,0,47,98,108,117,101,115,54,47,50,0,47,98,108,117,101,115,54,47,51,0,47,98,108,117,101,115,54,47,52,0,47,98,108,117,101,115,54,47,53,0,47,98,108,117,101,115,54,47,54,0,47,98,108,117,101,115,55,47,49,0,47,98,108,117,101,115,55,47,50,0,47,98,108,117,101,115,55,47,51,0,47,98,108,117,101,115,55,47,52,0,47,98,108,117,101,115,55,47,53,0,47,98,108,117,101,115,55,47,54,0,47,98,108,117,101,115,55,47,55,0,47,98,108,117,101,115,56,47,49,0,47,98,108,117,101,115,56,47,50,0,47,98,108,117,101,115,56,47,51,0,47,98,108,117,101,115,56,47,52,0,47,98,108,117,101,115,56,47,53,0,47,98,108,117,101,115,56,47,54,0,47,98,108,117,101,115,56,47,55,0,47,98,108,117,101,115,56,47,56,0,47,98,108,117,101,115,57,47,49,0,47,98,108,117,101,115,57,47,50,0,47,98,108,117,101,115,57,47,51,0,47,98,108,117,101,115,57,47,52,0,47,98,108,117,101,115,57,47,53,0,47,98,108,117,101,115,57,47,54,0,47,98,108,117,101,115,57,47,55,0,47,98,108,117,101,115,57,47,56,0,47,98,108,117,101,115,57,47,57,0,47,98,114,98,103,49,48,47,49,0,47,98,114,98,103,49,48,47,49,48,0,47,98,114,98,103,49,48,47,50,0,47,98,114,98,103,49,48,47,51,0,47,98,114,98,103,49,48,47,52,0,47,98,114,98,103,49,48,47,53,0,47,98,114,98,103,49,48,47,54,0,47,98,114,98,103,49,48,47,55,0,47,98,114,98,103,49,48,47,56,0,47,98,114,98,103,49,48,47,57,0,47,98,114,98,103,49,49,47,49,0,47,98,114,98,103,49,49,47,49,48,0,47,98,114,98,103,49,49,47,49,49,0,47,98,114,98,103,49,49,47,50,0,47,98,114,98,103,49,49,47,51,0,47,98,114,98,103,49,49,47,52,0,47,98,114,98,103,49,49,47,53,0,47,98,114,98,103,49,49,47,54,0,47,98,114,98,103,49,49,47,55,0,47,98,114,98,103,49,49,47,56,0,47,98,114,98,103,49,49,47,57,0,47,98,114,98,103,51,47,49,0,47,98,114,98,103,51,47,50,0,47,98,114,98,103,51,47,51,0,47,98,114,98,103,52,47,49,0,47,98,114,98,103,52,47,50,0,47,98,114,98,103,52,47,51,0,47,98,114,98,103,52,47,52,0,47,98,114,98,103,53,47,49,0,47,98,114,98,103,53,47,50,0,47,98,114,98,103,53,47,51,0,47,98,114,98,103,53,47,52,0,47,98,114,98,103,53,47,53,0,47,98,114,98,103,54,47,49,0,47,98,114,98,103,54,47,50,0,47,98,114,98,103,54,47,51,0,47,98,114,98,103,54,47,52,0,47,98,114,98,103,54,47,53,0,47,98,114,98,103,54,47,54,0,47,98,114,98,103,55,47,49,0,47,98,114,98,103,55,47,50,0,47,98,114,98,103,55,47,51,0,47,98,114,98,103,55,47,52,0,47,98,114,98,103,55,47,53,0,47,98,114,98,103,55,47,54,0,47,98,114,98,103,55,47,55,0,47,98,114,98,103,56,47,49,0,47,98,114,98,103,56,47,50,0,47,98,114,98,103,56,47,51,0,47,98,114,98,103,56,47,52,0,47,98,114,98,103,56,47,53,0,47,98,114,98,103,56,47,54,0,47,98,114,98,103,56,47,55,0,47,98,114,98,103,56,47,56,0,47,98,114,98,103,57,47,49,0,47,98,114,98,103,57,47,50,0,47,98,114,98,103,57,47,51,0,47,98,114,98,103,57,47,52,0,47,98,114,98,103,57,47,53,0,47,98,114,98,103,57,47,54,0,47,98,114,98,103,57,47,55,0,47,98,114,98,103,57,47,56,0,47,98,114,98,103,57,47,57,0,47,98,117,103,110,51,47,49,0,47,98,117,103,110,51,47,50,0,47,98,117,103,110,51,47,51,0,47,98,117,103,110,52,47,49,0,47,98,117,103,110,52,47,50,0,47,98,117,103,110,52,47,51,0,47,98,117,103,110,52,47,52,0,47,98,117,103,110,53,47,49,0,47,98,117,103,110,53,47,50,0,47,98,117,103,110,53,47,51,0,47,98,117,103,110,53,47,52,0,47,98,117,103,110,53,47,53,0,47,98,117,103,110,54,47,49,0,47,98,117,103,110,54,47,50,0,47,98,117,103,110,54,47,51,0,47,98,117,103,110,54,47,52,0,47,98,117,103,110,54,47,53,0,47,98,117,103,110,54,47,54,0,47,98,117,103,110,55,47,49,0,47,98,117,103,110,55,47,50,0,47,98,117,103,110,55,47,51,0,47,98,117,103,110,55,47,52,0,47,98,117,103,110,55,47,53,0,47,98,117,103,110,55,47,54,0,47,98,117,103,110,55,47,55,0,47,98,117,103,110,56,47,49,0,47,98,117,103,110,56,47,50,0,47,98,117,103,110,56,47,51,0,47,98,117,103,110,56,47,52,0,47,98,117,103,110,56,47,53,0,47,98,117,103,110,56,47,54,0,47,98,117,103,110,56,47,55,0,47,98,117,103,110,56,47,56,0,47,98,117,103,110,57,47,49,0,47,98,117,103,110,57,47,50,0,47,98,117,103,110,57,47,51,0,47,98,117,103,110,57,47,52,0,47,98,117,103,110,57,47,53,0,47,98,117,103,110,57,47,54,0,47,98,117,103,110,57,47,55,0,47,98,117,103,110,57,47,56,0,47,98,117,103,110,57,47,57,0,47,98,117,112,117,51,47,49,0,47,98,117,112,117,51,47,50,0,47,98,117,112,117,51,47,51,0,47,98,117,112,117,52,47,49,0,47,98,117,112,117,52,47,50,0,47,98,117,112,117,52,47,51,0,47,98,117,112,117,52,47,52,0,47,98,117,112,117,53,47,49,0,47,98,117,112,117,53,47,50,0,47,98,117,112,117,53,47,51,0,47,98,117,112,117,53,47,52,0,47,98,117,112,117,53,47,53,0,47,98,117,112,117,54,47,49,0,47,98,117,112,117,54,47,50,0,47,98,117,112,117,54,47,51,0,47,98,117,112,117,54,47,52,0,47,98,117,112,117,54,47,53,0,47,98,117,112,117,54,47,54,0,47,98,117,112,117,55,47,49,0,47,98,117,112,117,55,47,50,0,47,98,117,112,117,55,47,51,0,47,98,117,112,117,55,47,52,0,47,98,117,112,117,55,47,53,0,47,98,117,112,117,55,47,54,0,47,98,117,112,117,55,47,55,0,47,98,117,112,117,56,47,49,0,47,98,117,112,117,56,47,50,0,47,98,117,112,117,56,47,51,0,47,98,117,112,117,56,47,52,0,47,98,117,112,117,56,47,53,0,47,98,117,112,117,56,47,54,0,47,98,117,112,117,56,47,55,0,47,98,117,112,117,56,47,56,0,47,98,117,112,117,57,47,49,0,47,98,117,112,117,57,47,50,0,47,98,117,112,117,57,47,51,0,47,98,117,112,117,57,47,52,0,47,98,117,112,117,57,47,53,0,47,98,117,112,117,57,47,54,0,47,98,117,112,117,57,47,55,0,47,98,117,112,117,57,47,56,0,47,98,117,112,117,57,47,57,0,47,100,97,114,107,50,51,47,49,0,47,100,97,114,107,50,51,47,50,0,47,100,97,114,107,50,51,47,51,0,47,100,97,114,107,50,52,47,49,0,47,100,97,114,107,50,52,47,50,0,47,100,97,114,107,50,52,47,51,0,47,100,97,114,107,50,52,47,52,0,47,100,97,114,107,50,53,47,49,0,47,100,97,114,107,50,53,47,50,0,47,100,97,114,107,50,53,47,51,0,47,100,97,114,107,50,53,47,52,0,47,100,97,114,107,50,53,47,53,0,47,100,97,114,107,50,54,47,49,0,47,100,97,114,107,50,54,47,50,0,47,100,97,114,107,50,54,47,51,0,47,100,97,114,107,50,54,47,52,0,47,100,97,114,107,50,54,47,53,0,47,100,97,114,107,50,54,47,54,0,47,100,97,114,107,50,55,47,49,0,47,100,97,114,107,50,55,47,50,0,47,100,97,114,107,50,55,47,51,0,47,100,97,114,107,50,55,47,52,0,47,100,97,114,107,50,55,47,53,0,47,100,97,114,107,50,55,47,54,0,47,100,97,114,107,50,55,47,55,0,47,100,97,114,107,50,56,47,49,0,47,100,97,114,107,50,56,47,50,0,47,100,97,114,107,50,56,47,51,0,47,100,97,114,107,50,56,47,52,0,47,100,97,114,107,50,56,47,53,0,47,100,97,114,107,50,56,47,54,0,47,100,97,114,107,50,56,47,55,0,47,100,97,114,107,50,56,47,56,0,47,103,110,98,117,51,47,49,0,47,103,110,98,117,51,47,50,0,47,103,110,98,117,51,47,51,0,47,103,110,98,117,52,47,49,0,47,103,110,98,117,52,47,50,0,47,103,110,98,117,52,47,51,0,47,103,110,98,117,52,47,52,0,47,103,110,98,117,53,47,49,0,47,103,110,98,117,53,47,50,0,47,103,110,98,117,53,47,51,0,47,103,110,98,117,53,47,52,0,47,103,110,98,117,53,47,53,0,47,103,110,98,117,54,47,49,0,47,103,110,98,117,54,47,50,0,47,103,110,98,117,54,47,51,0,47,103,110,98,117,54,47,52,0,47,103,110,98,117,54,47,53,0,47,103,110,98,117,54,47,54,0,47,103,110,98,117,55,47,49,0,47,103,110,98,117,55,47,50,0,47,103,110,98,117,55,47,51,0,47,103,110,98,117,55,47,52,0,47,103,110,98,117,55,47,53,0,47,103,110,98,117,55,47,54,0,47,103,110,98,117,55,47,55,0,47,103,110,98,117,56,47,49,0,47,103,110,98,117,56,47,50,0,47,103,110,98,117,56,47,51,0,47,103,110,98,117,56,47,52,0,47,103,110,98,117,56,47,53,0,47,103,110,98,117,56,47,54,0,47,103,110,98,117,56,47,55,0,47,103,110,98,117,56,47,56,0,47,103,110,98,117,57,47,49,0,47,103,110,98,117,57,47,50,0,47,103,110,98,117,57,47,51,0,47,103,110,98,117,57,47,52,0,47,103,110,98,117,57,47,53,0,47,103,110,98,117,57,47,54,0,47,103,110,98,117,57,47,55,0,47,103,110,98,117,57,47,56,0,47,103,110,98,117,57,47,57,0,47,103,114,101,101,110,115,51,47,49,0,47,103,114,101,101,110,115,51,47,50,0,47,103,114,101,101,110,115,51,47,51,0,47,103,114,101,101,110,115,52,47,49,0,47,103,114,101,101,110,115,52,47,50,0,47,103,114,101,101,110,115,52,47,51,0,47,103,114,101,101,110,115,52,47,52,0,47,103,114,101,101,110,115,53,47,49,0,47,103,114,101,101,110,115,53,47,50,0,47,103,114,101,101,110,115,53,47,51,0,47,103,114,101,101,110,115,53,47,52,0,47,103,114,101,101,110,115,53,47,53,0,47,103,114,101,101,110,115,54,47,49,0,47,103,114,101,101,110,115,54,47,50,0,47,103,114,101,101,110,115,54,47,51,0,47,103,114,101,101,110,115,54,47,52,0,47,103,114,101,101,110,115,54,47,53,0,47,103,114,101,101,110,115,54,47,54,0,47,103,114,101,101,110,115,55,47,49,0,47,103,114,101,101,110,115,55,47,50,0,47,103,114,101,101,110,115,55,47,51,0,47,103,114,101,101,110,115,55,47,52,0,47,103,114,101,101,110,115,55,47,53,0,47,103,114,101,101,110,115,55,47,54,0,47,103,114,101,101,110,115,55,47,55,0,47,103,114,101,101,110,115,56,47,49,0,47,103,114,101,101,110,115,56,47,50,0,47,103,114,101,101,110,115,56,47,51,0,47,103,114,101,101,110,115,56,47,52,0,47,103,114,101,101,110,115,56,47,53,0,47,103,114,101,101,110,115,56,47,54,0,47,103,114,101,101,110,115,56,47,55,0,47,103,114,101,101,110,115,56,47,56,0,47,103,114,101,101,110,115,57,47,49,0,47,103,114,101,101,110,115,57,47,50,0,47,103,114,101,101,110,115,57,47,51,0,47,103,114,101,101,110,115,57,47,52,0,47,103,114,101,101,110,115,57,47,53,0,47,103,114,101,101,110,115,57,47,54,0,47,103,114,101,101,110,115,57,47,55,0,47,103,114,101,101,110,115,57,47,56,0,47,103,114,101,101,110,115,57,47,57,0,47,103,114,101,121,115,51,47,49,0,47,103,114,101,121,115,51,47,50,0,47,103,114,101,121,115,51,47,51,0,47,103,114,101,121,115,52,47,49,0,47,103,114,101,121,115,52,47,50,0,47,103,114,101,121,115,52,47,51,0,47,103,114,101,121,115,52,47,52,0,47,103,114,101,121,115,53,47,49,0,47,103,114,101,121,115,53,47,50,0,47,103,114,101,121,115,53,47,51,0,47,103,114,101,121,115,53,47,52,0,47,103,114,101,121,115,53,47,53,0,47,103,114,101,121,115,54,47,49,0,47,103,114,101,121,115,54,47,50,0,47,103,114,101,121,115,54,47,51,0,47,103,114,101,121,115,54,47,52,0,47,103,114,101,121,115,54,47,53,0,47,103,114,101,121,115,54,47,54,0,47,103,114,101,121,115,55,47,49,0,47,103,114,101,121,115,55,47,50,0,47,103,114,101,121,115,55,47,51,0,47,103,114,101,121,115,55,47,52,0,47,103,114,101,121,115,55,47,53,0,47,103,114,101,121,115,55,47,54,0,47,103,114,101,121,115,55,47,55,0,47,103,114,101,121,115,56,47,49,0,47,103,114,101,121,115,56,47,50,0,47,103,114,101,121,115,56,47,51,0,47,103,114,101,121,115,56,47,52,0,47,103,114,101,121,115,56,47,53,0,47,103,114,101,121,115,56,47,54,0,47,103,114,101,121,115,56,47,55,0,47,103,114,101,121,115,56,47,56,0,47,103,114,101,121,115,57,47,49,0,47,103,114,101,121,115,57,47,50,0,47,103,114,101,121,115,57,47,51,0,47,103,114,101,121,115,57,47,52,0,47,103,114,101,121,115,57,47,53,0,47,103,114,101,121,115,57,47,54,0,47,103,114,101,121,115,57,47,55,0,47,103,114,101,121,115,57,47,56,0,47,103,114,101,121,115,57,47,57,0,47,111,114,97,110,103,101,115,51,47,49,0,47,111,114,97,110,103,101,115,51,47,50,0,47,111,114,97,110,103,101,115,51,47,51,0,47,111,114,97,110,103,101,115,52,47,49,0,47,111,114,97,110,103,101,115,52,47,50,0,47,111,114,97,110,103,101,115,52,47,51,0,47,111,114,97,110,103,101,115,52,47,52,0,47,111,114,97],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+142942);allocate([110,103,101,115,53,47,49,0,47,111,114,97,110,103,101,115,53,47,50,0,47,111,114,97,110,103,101,115,53,47,51,0,47,111,114,97,110,103,101,115,53,47,52,0,47,111,114,97,110,103,101,115,53,47,53,0,47,111,114,97,110,103,101,115,54,47,49,0,47,111,114,97,110,103,101,115,54,47,50,0,47,111,114,97,110,103,101,115,54,47,51,0,47,111,114,97,110,103,101,115,54,47,52,0,47,111,114,97,110,103,101,115,54,47,53,0,47,111,114,97,110,103,101,115,54,47,54,0,47,111,114,97,110,103,101,115,55,47,49,0,47,111,114,97,110,103,101,115,55,47,50,0,47,111,114,97,110,103,101,115,55,47,51,0,47,111,114,97,110,103,101,115,55,47,52,0,47,111,114,97,110,103,101,115,55,47,53,0,47,111,114,97,110,103,101,115,55,47,54,0,47,111,114,97,110,103,101,115,55,47,55,0,47,111,114,97,110,103,101,115,56,47,49,0,47,111,114,97,110,103,101,115,56,47,50,0,47,111,114,97,110,103,101,115,56,47,51,0,47,111,114,97,110,103,101,115,56,47,52,0,47,111,114,97,110,103,101,115,56,47,53,0,47,111,114,97,110,103,101,115,56,47,54,0,47,111,114,97,110,103,101,115,56,47,55,0,47,111,114,97,110,103,101,115,56,47,56,0,47,111,114,97,110,103,101,115,57,47,49,0,47,111,114,97,110,103,101,115,57,47,50,0,47,111,114,97,110,103,101,115,57,47,51,0,47,111,114,97,110,103,101,115,57,47,52,0,47,111,114,97,110,103,101,115,57,47,53,0,47,111,114,97,110,103,101,115,57,47,54,0,47,111,114,97,110,103,101,115,57,47,55,0,47,111,114,97,110,103,101,115,57,47,56,0,47,111,114,97,110,103,101,115,57,47,57,0,47,111,114,114,100,51,47,49,0,47,111,114,114,100,51,47,50,0,47,111,114,114,100,51,47,51,0,47,111,114,114,100,52,47,49,0,47,111,114,114,100,52,47,50,0,47,111,114,114,100,52,47,51,0,47,111,114,114,100,52,47,52,0,47,111,114,114,100,53,47,49,0,47,111,114,114,100,53,47,50,0,47,111,114,114,100,53,47,51,0,47,111,114,114,100,53,47,52,0,47,111,114,114,100,53,47,53,0,47,111,114,114,100,54,47,49,0,47,111,114,114,100,54,47,50,0,47,111,114,114,100,54,47,51,0,47,111,114,114,100,54,47,52,0,47,111,114,114,100,54,47,53,0,47,111,114,114,100,54,47,54,0,47,111,114,114,100,55,47,49,0,47,111,114,114,100,55,47,50,0,47,111,114,114,100,55,47,51,0,47,111,114,114,100,55,47,52,0,47,111,114,114,100,55,47,53,0,47,111,114,114,100,55,47,54,0,47,111,114,114,100,55,47,55,0,47,111,114,114,100,56,47,49,0,47,111,114,114,100,56,47,50,0,47,111,114,114,100,56,47,51,0,47,111,114,114,100,56,47,52,0,47,111,114,114,100,56,47,53,0,47,111,114,114,100,56,47,54,0,47,111,114,114,100,56,47,55,0,47,111,114,114,100,56,47,56,0,47,111,114,114,100,57,47,49,0,47,111,114,114,100,57,47,50,0,47,111,114,114,100,57,47,51,0,47,111,114,114,100,57,47,52,0,47,111,114,114,100,57,47,53,0,47,111,114,114,100,57,47,54,0,47,111,114,114,100,57,47,55,0,47,111,114,114,100,57,47,56,0,47,111,114,114,100,57,47,57,0,47,112,97,105,114,101,100,49,48,47,49,0,47,112,97,105,114,101,100,49,48,47,49,48,0,47,112,97,105,114,101,100,49,48,47,50,0,47,112,97,105,114,101,100,49,48,47,51,0,47,112,97,105,114,101,100,49,48,47,52,0,47,112,97,105,114,101,100,49,48,47,53,0,47,112,97,105,114,101,100,49,48,47,54,0,47,112,97,105,114,101,100,49,48,47,55,0,47,112,97,105,114,101,100,49,48,47,56,0,47,112,97,105,114,101,100,49,48,47,57,0,47,112,97,105,114,101,100,49,49,47,49,0,47,112,97,105,114,101,100,49,49,47,49,48,0,47,112,97,105,114,101,100,49,49,47,49,49,0,47,112,97,105,114,101,100,49,49,47,50,0,47,112,97,105,114,101,100,49,49,47,51,0,47,112,97,105,114,101,100,49,49,47,52,0,47,112,97,105,114,101,100,49,49,47,53,0,47,112,97,105,114,101,100,49,49,47,54,0,47,112,97,105,114,101,100,49,49,47,55,0,47,112,97,105,114,101,100,49,49,47,56,0,47,112,97,105,114,101,100,49,49,47,57,0,47,112,97,105,114,101,100,49,50,47,49,0,47,112,97,105,114,101,100,49,50,47,49,48,0,47,112,97,105,114,101,100,49,50,47,49,49,0,47,112,97,105,114,101,100,49,50,47,49,50,0,47,112,97,105,114,101,100,49,50,47,50,0,47,112,97,105,114,101,100,49,50,47,51,0,47,112,97,105,114,101,100,49,50,47,52,0,47,112,97,105,114,101,100,49,50,47,53,0,47,112,97,105,114,101,100,49,50,47,54,0,47,112,97,105,114,101,100,49,50,47,55,0,47,112,97,105,114,101,100,49,50,47,56,0,47,112,97,105,114,101,100,49,50,47,57,0,47,112,97,105,114,101,100,51,47,49,0,47,112,97,105,114,101,100,51,47,50,0,47,112,97,105,114,101,100,51,47,51,0,47,112,97,105,114,101,100,52,47,49,0,47,112,97,105,114,101,100,52,47,50,0,47,112,97,105,114,101,100,52,47,51,0,47,112,97,105,114,101,100,52,47,52,0,47,112,97,105,114,101,100,53,47,49,0,47,112,97,105,114,101,100,53,47,50,0,47,112,97,105,114,101,100,53,47,51,0,47,112,97,105,114,101,100,53,47,52,0,47,112,97,105,114,101,100,53,47,53,0,47,112,97,105,114,101,100,54,47,49,0,47,112,97,105,114,101,100,54,47,50,0,47,112,97,105,114,101,100,54,47,51,0,47,112,97,105,114,101,100,54,47,52,0,47,112,97,105,114,101,100,54,47,53,0,47,112,97,105,114,101,100,54,47,54,0,47,112,97,105,114,101,100,55,47,49,0,47,112,97,105,114,101,100,55,47,50,0,47,112,97,105,114,101,100,55,47,51,0,47,112,97,105,114,101,100,55,47,52,0,47,112,97,105,114,101,100,55,47,53,0,47,112,97,105,114,101,100,55,47,54,0,47,112,97,105,114,101,100,55,47,55,0,47,112,97,105,114,101,100,56,47,49,0,47,112,97,105,114,101,100,56,47,50,0,47,112,97,105,114,101,100,56,47,51,0,47,112,97,105,114,101,100,56,47,52,0,47,112,97,105,114,101,100,56,47,53,0,47,112,97,105,114,101,100,56,47,54,0,47,112,97,105,114,101,100,56,47,55,0,47,112,97,105,114,101,100,56,47,56,0,47,112,97,105,114,101,100,57,47,49,0,47,112,97,105,114,101,100,57,47,50,0,47,112,97,105,114,101,100,57,47,51,0,47,112,97,105,114,101,100,57,47,52,0,47,112,97,105,114,101,100,57,47,53,0,47,112,97,105,114,101,100,57,47,54,0,47,112,97,105,114,101,100,57,47,55,0,47,112,97,105,114,101,100,57,47,56,0,47,112,97,105,114,101,100,57,47,57,0,47,112,97,115,116,101,108,49,51,47,49,0,47,112,97,115,116,101,108,49,51,47,50,0,47,112,97,115,116,101,108,49,51,47,51,0,47,112,97,115,116,101,108,49,52,47,49,0,47,112,97,115,116,101,108,49,52,47,50,0,47,112,97,115,116,101,108,49,52,47,51,0,47,112,97,115,116,101,108,49,52,47,52,0,47,112,97,115,116,101,108,49,53,47,49,0,47,112,97,115,116,101,108,49,53,47,50,0,47,112,97,115,116,101,108,49,53,47,51,0,47,112,97,115,116,101,108,49,53,47,52,0,47,112,97,115,116,101,108,49,53,47,53,0,47,112,97,115,116,101,108,49,54,47,49,0,47,112,97,115,116,101,108,49,54,47,50,0,47,112,97,115,116,101,108,49,54,47,51,0,47,112,97,115,116,101,108,49,54,47,52,0,47,112,97,115,116,101,108,49,54,47,53,0,47,112,97,115,116,101,108,49,54,47,54,0,47,112,97,115,116,101,108,49,55,47,49,0,47,112,97,115,116,101,108,49,55,47,50,0,47,112,97,115,116,101,108,49,55,47,51,0,47,112,97,115,116,101,108,49,55,47,52,0,47,112,97,115,116,101,108,49,55,47,53,0,47,112,97,115,116,101,108,49,55,47,54,0,47,112,97,115,116,101,108,49,55,47,55,0,47,112,97,115,116,101,108,49,56,47,49,0,47,112,97,115,116,101,108,49,56,47,50,0,47,112,97,115,116,101,108,49,56,47,51,0,47,112,97,115,116,101,108,49,56,47,52,0,47,112,97,115,116,101,108,49,56,47,53,0,47,112,97,115,116,101,108,49,56,47,54,0,47,112,97,115,116,101,108,49,56,47,55,0,47,112,97,115,116,101,108,49,56,47,56,0,47,112,97,115,116,101,108,49,57,47,49,0,47,112,97,115,116,101,108,49,57,47,50,0,47,112,97,115,116,101,108,49,57,47,51,0,47,112,97,115,116,101,108,49,57,47,52,0,47,112,97,115,116,101,108,49,57,47,53,0,47,112,97,115,116,101,108,49,57,47,54,0,47,112,97,115,116,101,108,49,57,47,55,0,47,112,97,115,116,101,108,49,57,47,56,0,47,112,97,115,116,101,108,49,57,47,57,0,47,112,97,115,116,101,108,50,51,47,49,0,47,112,97,115,116,101,108,50,51,47,50,0,47,112,97,115,116,101,108,50,51,47,51,0,47,112,97,115,116,101,108,50,52,47,49,0,47,112,97,115,116,101,108,50,52,47,50,0,47,112,97,115,116,101,108,50,52,47,51,0,47,112,97,115,116,101,108,50,52,47,52,0,47,112,97,115,116,101,108,50,53,47,49,0,47,112,97,115,116,101,108,50,53,47,50,0,47,112,97,115,116,101,108,50,53,47,51,0,47,112,97,115,116,101,108,50,53,47,52,0,47,112,97,115,116,101,108,50,53,47,53,0,47,112,97,115,116,101,108,50,54,47,49,0,47,112,97,115,116,101,108,50,54,47,50,0,47,112,97,115,116,101,108,50,54,47,51,0,47,112,97,115,116,101,108,50,54,47,52,0,47,112,97,115,116,101,108,50,54,47,53,0,47,112,97,115,116,101,108,50,54,47,54,0,47,112,97,115,116,101,108,50,55,47,49,0,47,112,97,115,116,101,108,50,55,47,50,0,47,112,97,115,116,101,108,50,55,47,51,0,47,112,97,115,116,101,108,50,55,47,52,0,47,112,97,115,116,101,108,50,55,47,53,0,47,112,97,115,116,101,108,50,55,47,54,0,47,112,97,115,116,101,108,50,55,47,55,0,47,112,97,115,116,101,108,50,56,47,49,0,47,112,97,115,116,101,108,50,56,47,50,0,47,112,97,115,116,101,108,50,56,47,51,0,47,112,97,115,116,101,108,50,56,47,52,0,47,112,97,115,116,101,108,50,56,47,53,0,47,112,97,115,116,101,108,50,56,47,54,0,47,112,97,115,116,101,108,50,56,47,55,0,47,112,97,115,116,101,108,50,56,47,56,0,47,112,105,121,103,49,48,47,49,0,47,112,105,121,103,49,48,47,49,48,0,47,112,105,121,103,49,48,47,50,0,47,112,105,121,103,49,48,47,51,0,47,112,105,121,103,49,48,47,52,0,47,112,105,121,103,49,48,47,53,0,47,112,105,121,103,49,48,47,54,0,47,112,105,121,103,49,48,47,55,0,47,112,105,121,103,49,48,47,56,0,47,112,105,121,103,49,48,47,57,0,47,112,105,121,103,49,49,47,49,0,47,112,105,121,103,49,49,47,49,48,0,47,112,105,121,103,49,49,47,49,49,0,47,112,105,121,103,49,49,47,50,0,47,112,105,121,103,49,49,47,51,0,47,112,105,121,103,49,49,47,52,0,47,112,105,121,103,49,49,47,53,0,47,112,105,121,103,49,49,47,54,0,47,112,105,121,103,49,49,47,55,0,47,112,105,121,103,49,49,47,56,0,47,112,105,121,103,49,49,47,57,0,47,112,105,121,103,51,47,49,0,47,112,105,121,103,51,47,50,0,47,112,105,121,103,51,47,51,0,47,112,105,121,103,52,47,49,0,47,112,105,121,103,52,47,50,0,47,112,105,121,103,52,47,51,0,47,112,105,121,103,52,47,52,0,47,112,105,121,103,53,47,49,0,47,112,105,121,103,53,47,50,0,47,112,105,121,103,53,47,51,0,47,112,105,121,103,53,47,52,0,47,112,105,121,103,53,47,53,0,47,112,105,121,103,54,47,49,0,47,112,105,121,103,54,47,50,0,47,112,105,121,103,54,47,51,0,47,112,105,121,103,54,47,52,0,47,112,105,121,103,54,47,53,0,47,112,105,121,103,54,47,54,0,47,112,105,121,103,55,47,49,0,47,112,105,121,103,55,47,50,0,47,112,105,121,103,55,47,51,0,47,112,105,121,103,55,47,52,0,47,112,105,121,103,55,47,53,0,47,112,105,121,103,55,47,54,0,47,112,105,121,103,55,47,55,0,47,112,105,121,103,56,47,49,0,47,112,105,121,103,56,47,50,0,47,112,105,121,103,56,47,51,0,47,112,105,121,103,56,47,52,0,47,112,105,121,103,56,47,53,0,47,112,105,121,103,56,47,54,0,47,112,105,121,103,56,47,55,0,47,112,105,121,103,56,47,56,0,47,112,105,121,103,57,47,49,0,47,112,105,121,103,57,47,50,0,47,112,105,121,103,57,47,51,0,47,112,105,121,103,57,47,52,0,47,112,105,121,103,57,47,53,0,47,112,105,121,103,57,47,54,0,47,112,105,121,103,57,47,55,0,47,112,105,121,103,57,47,56,0,47,112,105,121,103,57,47,57,0,47,112,114,103,110,49,48,47,49,0,47,112,114,103,110,49,48,47,49,48,0,47,112,114,103,110,49,48,47,50,0,47,112,114,103,110,49,48,47,51,0,47,112,114,103,110,49,48,47,52,0,47,112,114,103,110,49,48,47,53,0,47,112,114,103,110,49,48,47,54,0,47,112,114,103,110,49,48,47,55,0,47,112,114,103,110,49,48,47,56,0,47,112,114,103,110,49,48,47,57,0,47,112,114,103,110,49,49,47,49,0,47,112,114,103,110,49,49,47,49,48,0,47,112,114,103,110,49,49,47,49,49,0,47,112,114,103,110,49,49,47,50,0,47,112,114,103,110,49,49,47,51,0,47,112,114,103,110,49,49,47,52,0,47,112,114,103,110,49,49,47,53,0,47,112,114,103,110,49,49,47,54,0,47,112,114,103,110,49,49,47,55,0,47,112,114,103,110,49,49,47,56,0,47,112,114,103,110,49,49,47,57,0,47,112,114,103,110,51,47,49,0,47,112,114,103,110,51,47,50,0,47,112,114,103,110,51,47,51,0,47,112,114,103,110,52,47,49,0,47,112,114,103,110,52,47,50,0,47,112,114,103,110,52,47,51,0,47,112,114,103,110,52,47,52,0,47,112,114,103,110,53,47,49,0,47,112,114,103,110,53,47,50,0,47,112,114,103,110,53,47,51,0,47,112,114,103,110,53,47,52,0,47,112,114,103,110,53,47,53,0,47,112,114,103,110,54,47,49,0,47,112,114,103,110,54,47,50,0,47,112,114,103,110,54,47,51,0,47,112,114,103,110,54,47,52,0,47,112,114,103,110,54,47,53,0,47,112,114,103,110,54,47,54,0,47,112,114,103,110,55,47,49,0,47,112,114,103,110,55,47,50,0,47,112,114,103,110,55,47,51,0,47,112,114,103,110,55,47,52,0,47,112,114,103,110,55,47,53,0,47,112,114,103,110,55,47,54,0,47,112,114,103,110,55,47,55,0,47,112,114,103,110,56,47,49,0,47,112,114,103,110,56,47,50,0,47,112,114,103,110,56,47,51,0,47,112,114,103,110,56,47,52,0,47,112,114,103,110,56,47,53,0,47,112,114,103,110,56,47,54,0,47,112,114,103,110,56,47,55,0,47,112,114,103,110,56,47,56,0,47,112,114,103,110,57,47,49,0,47,112,114,103,110,57,47,50,0,47,112,114,103,110,57,47,51,0,47,112,114,103,110,57,47,52,0,47,112,114,103,110,57,47,53,0,47,112,114,103,110,57,47,54,0,47,112,114,103,110,57,47,55,0,47,112,114,103,110,57,47,56,0,47,112,114,103,110,57,47,57,0,47,112,117,98,117,51,47,49,0,47,112,117,98,117,51,47,50,0,47,112,117,98,117,51,47,51,0,47,112,117,98,117,52,47,49,0,47,112,117,98,117,52,47,50,0,47,112,117,98,117,52,47,51,0,47,112,117,98,117,52,47,52,0,47,112,117,98,117,53,47,49,0,47,112,117,98,117,53,47,50,0,47,112,117,98,117,53,47,51,0,47,112,117,98,117,53,47,52,0,47,112,117,98,117,53,47,53,0,47,112,117,98,117,54,47,49,0,47,112,117,98,117,54,47,50,0,47,112,117,98,117,54,47,51,0,47,112,117,98,117,54,47,52,0,47,112,117,98,117,54,47,53,0,47,112,117,98,117,54,47,54,0,47,112,117,98,117,55,47,49,0,47,112,117,98,117,55,47,50,0,47,112,117,98,117,55,47,51,0,47,112,117,98,117,55,47,52,0,47,112,117,98,117,55,47,53,0,47,112,117,98,117,55,47,54,0,47,112,117,98,117,55,47,55,0,47,112,117,98,117,56,47,49,0,47,112,117,98,117,56,47,50,0,47,112,117,98,117,56,47,51,0,47,112,117,98,117,56,47,52,0,47,112,117,98,117,56,47,53,0,47,112,117,98,117,56,47,54,0,47,112,117,98,117,56,47,55,0,47,112,117,98,117,56,47,56,0,47,112,117,98,117,57,47,49,0,47,112,117,98,117,57,47,50,0,47,112,117,98,117,57,47,51,0,47,112,117,98,117,57,47,52,0,47,112,117,98,117,57,47,53,0,47,112,117,98,117,57,47,54,0,47,112,117,98,117,57,47,55,0,47,112,117,98,117,57,47,56,0,47,112,117,98,117,57,47,57,0,47,112,117,98,117,103,110,51,47,49,0,47,112,117,98,117,103,110,51,47,50,0,47,112,117,98,117,103,110,51,47,51,0,47,112,117,98,117,103,110,52,47,49,0,47,112,117,98,117,103,110,52,47,50,0,47,112,117,98,117,103,110,52,47,51,0,47,112,117,98,117,103,110,52,47,52,0,47,112,117,98,117,103,110,53,47,49,0,47,112,117,98,117,103,110,53,47,50,0,47,112,117,98,117,103,110,53,47,51,0,47,112,117,98,117,103,110,53,47,52,0,47,112,117,98,117,103,110,53,47,53,0,47,112,117,98,117,103,110,54,47,49,0,47,112,117,98,117,103,110,54,47,50,0,47,112,117,98,117,103,110,54,47,51,0,47,112,117,98,117,103,110,54,47,52,0,47,112,117,98,117,103,110,54,47,53,0,47,112,117,98,117,103,110,54,47,54,0,47,112,117,98,117,103,110,55,47,49,0,47,112,117,98,117,103,110,55,47,50,0,47,112,117,98,117,103,110,55,47,51,0,47,112,117,98,117,103,110,55,47,52,0,47,112,117,98,117,103,110,55,47,53,0,47,112,117,98,117,103,110,55,47,54,0,47,112,117,98,117,103,110,55,47,55,0,47,112,117,98,117,103,110,56,47,49,0,47,112,117,98,117,103,110,56,47,50,0,47,112,117,98,117,103,110,56,47,51,0,47,112,117,98,117,103,110,56,47,52,0,47,112,117,98,117,103,110,56,47,53,0,47,112,117,98,117,103,110,56,47,54,0,47,112,117,98,117,103,110,56,47,55,0,47,112,117,98,117,103,110,56,47,56,0,47,112,117,98,117,103,110,57,47,49,0,47,112,117,98,117,103,110,57,47,50,0,47,112,117,98,117,103,110,57,47,51,0,47,112,117,98,117,103,110,57,47,52,0,47,112,117,98,117,103,110,57,47,53,0,47,112,117,98,117,103,110,57,47,54,0,47,112,117,98,117,103,110,57,47,55,0,47,112,117,98,117,103,110,57,47,56,0,47,112,117,98,117,103,110,57,47,57,0,47,112,117,111,114,49,48,47,49,0,47,112,117,111,114,49,48,47,49,48,0,47,112,117,111,114,49,48,47,50,0,47,112,117,111,114,49,48,47,51,0,47,112,117,111,114,49,48,47,52,0,47,112,117,111,114,49,48,47,53,0,47,112,117,111,114,49,48,47,54,0,47,112,117,111,114,49,48,47,55,0,47,112,117,111,114,49,48,47,56,0,47,112,117,111,114,49,48,47,57,0,47,112,117,111,114,49,49,47,49,0,47,112,117,111,114,49,49,47,49,48,0,47,112,117,111,114,49,49,47,49,49,0,47,112,117,111,114,49,49,47,50,0,47,112,117,111,114,49,49,47,51,0,47,112,117,111,114,49,49,47,52,0,47,112,117,111,114,49,49,47,53,0,47,112,117,111,114,49,49,47,54,0,47,112,117,111,114,49,49,47,55,0,47,112,117,111,114,49,49,47,56,0,47,112,117,111,114,49,49,47,57,0,47,112,117,111,114,51,47,49,0,47,112,117,111,114,51,47,50,0,47,112,117,111,114,51,47,51,0,47,112,117,111,114,52,47,49,0,47,112,117,111,114,52,47,50,0,47,112,117,111,114,52,47,51,0,47,112,117,111,114,52,47,52,0,47,112,117,111,114,53,47,49,0,47,112,117,111,114,53,47,50,0,47,112,117,111,114,53,47,51,0,47,112,117,111,114,53,47,52,0,47,112,117,111,114,53,47,53,0,47,112,117,111,114,54,47,49,0,47,112,117,111,114,54,47,50,0,47,112,117,111,114,54,47,51,0,47,112,117,111,114,54,47,52,0,47,112,117,111,114,54,47,53,0,47,112,117,111,114,54,47,54,0,47,112,117,111,114,55,47,49,0,47,112,117,111,114,55,47,50,0,47,112,117,111,114,55,47,51,0,47,112,117,111,114,55,47,52,0,47,112,117,111,114,55,47,53,0,47,112,117,111,114,55,47,54,0,47,112,117,111,114,55,47,55,0,47,112,117,111,114,56,47,49,0,47,112,117,111,114,56,47,50,0,47,112,117,111,114,56,47,51,0,47,112,117,111,114,56,47,52,0,47,112,117,111,114,56,47,53,0,47,112,117,111,114,56,47,54,0,47,112,117,111,114,56,47,55,0,47,112,117,111,114,56,47,56,0,47,112,117,111,114,57,47,49,0,47,112,117,111,114,57,47,50,0,47,112,117,111,114,57,47,51,0,47,112,117,111,114,57,47,52,0,47,112,117,111,114,57,47,53,0,47,112,117,111,114,57,47,54,0,47,112,117,111,114,57,47,55,0,47,112,117,111,114,57,47,56,0,47,112,117,111,114,57,47,57,0,47,112,117,114,100,51,47,49,0,47,112,117,114,100,51,47,50,0,47,112,117,114,100,51,47,51,0,47,112,117,114,100,52,47,49,0,47,112,117,114,100,52,47,50,0,47,112,117,114,100,52,47,51,0,47,112,117,114,100,52,47,52,0,47,112,117,114,100,53,47,49,0,47,112,117,114,100,53,47,50,0,47,112,117,114,100,53,47,51,0,47,112,117,114,100,53,47,52,0,47,112,117,114,100,53,47,53,0,47,112,117,114,100,54,47,49,0,47,112,117,114,100,54,47,50,0,47,112,117,114,100,54,47,51,0,47,112,117,114,100,54,47,52,0,47,112,117,114,100,54,47,53,0,47,112,117,114,100,54,47,54,0,47,112,117,114,100,55,47,49,0,47,112,117,114,100,55,47,50,0,47,112,117,114,100,55,47,51,0,47,112,117,114,100,55,47,52,0,47,112,117,114,100,55,47,53,0,47,112,117,114,100,55,47,54,0,47,112,117,114,100,55,47,55,0,47,112,117,114,100,56,47,49,0,47,112,117,114,100,56,47,50,0,47,112,117,114,100,56,47,51,0,47,112,117,114,100,56,47,52,0,47,112,117,114,100,56,47,53,0,47,112,117,114,100,56,47,54,0,47,112,117,114,100,56,47,55,0,47,112,117,114,100,56,47,56,0,47,112,117,114,100,57,47,49,0,47,112,117,114,100,57,47,50,0,47,112,117,114,100,57,47,51,0,47,112,117,114,100,57,47,52,0,47,112,117,114,100,57,47,53,0,47,112,117,114,100,57,47,54,0,47,112,117,114,100,57,47,55,0,47,112,117,114,100,57,47,56,0,47,112,117,114,100,57,47,57,0,47,112,117,114,112,108,101,115,51,47,49,0,47,112,117,114,112,108,101,115,51,47,50,0,47,112,117,114,112,108,101,115,51,47,51,0,47,112,117,114,112,108,101,115,52,47,49,0,47,112,117,114,112,108,101,115,52,47,50,0,47,112,117,114,112,108,101,115,52,47,51,0,47,112,117,114,112,108,101,115,52,47,52,0,47,112,117,114,112,108,101,115,53,47,49,0,47,112,117,114,112,108,101,115,53,47,50,0,47,112,117,114,112,108,101,115,53,47,51,0,47,112,117,114,112,108,101,115,53,47,52,0,47,112,117,114,112,108,101,115,53,47,53,0,47,112,117,114,112,108,101,115,54,47,49,0,47,112,117,114,112,108,101,115,54,47,50,0,47,112,117,114,112,108,101,115,54,47,51,0,47,112,117,114,112,108,101,115,54,47,52,0,47,112,117,114,112,108,101,115,54,47,53,0,47,112,117,114,112,108,101,115,54,47,54,0,47,112,117,114,112,108,101,115,55,47,49,0,47,112,117,114,112,108,101,115,55,47,50,0,47,112,117,114,112,108,101,115,55,47,51,0,47,112,117,114,112,108,101,115,55,47,52,0,47,112,117,114,112,108,101,115,55,47,53,0,47,112,117,114,112,108,101,115,55,47,54,0,47,112,117,114,112,108,101,115,55,47,55,0,47,112,117,114,112,108,101,115,56,47,49,0,47,112,117,114,112,108,101,115,56,47,50,0,47,112,117,114,112,108,101,115,56,47,51,0,47,112,117,114,112,108,101,115,56,47,52,0,47,112,117,114,112,108,101,115,56,47,53,0,47,112,117,114,112,108,101,115,56,47,54,0,47,112,117,114,112,108,101,115,56,47,55,0,47,112,117,114,112,108,101,115,56,47,56,0,47,112,117,114,112,108,101,115,57,47,49,0,47,112,117,114,112,108,101,115,57,47,50,0,47,112,117,114,112,108,101,115,57,47,51,0,47,112,117,114,112,108,101,115,57,47,52,0,47,112,117,114,112,108,101,115,57,47,53,0,47,112,117,114,112,108,101,115,57,47,54,0,47,112,117,114,112,108,101,115,57,47,55,0,47,112,117,114,112,108,101,115,57,47,56,0,47,112,117,114,112,108,101,115,57,47,57,0,47,114,100,98,117,49,48,47,49,0,47,114,100,98,117,49,48,47,49,48,0,47,114,100,98,117,49,48,47,50,0,47,114,100,98,117,49,48,47,51,0,47,114,100,98,117,49,48,47,52,0,47,114,100,98,117,49,48,47,53,0,47,114,100,98,117,49,48,47,54,0,47,114,100,98,117,49,48,47,55,0,47,114,100,98,117,49,48,47,56,0,47,114,100,98,117,49,48,47,57,0,47,114,100,98,117,49,49,47,49,0,47,114,100,98,117,49,49,47,49,48,0,47,114,100,98,117,49,49,47,49,49,0,47,114,100,98,117,49,49,47,50,0,47,114,100,98,117,49,49,47,51,0,47,114,100,98,117,49,49,47,52,0,47,114,100,98,117,49,49,47,53,0,47,114,100,98,117,49,49,47,54,0,47,114,100,98,117,49,49,47,55,0,47,114,100,98,117,49,49,47,56,0,47,114,100,98,117,49,49,47,57,0,47,114,100,98,117,51,47,49,0,47,114,100,98,117,51,47,50,0,47,114,100,98,117,51,47,51,0,47,114,100,98,117,52,47,49,0,47,114,100,98,117,52,47,50,0,47,114,100,98,117,52,47,51,0,47,114,100,98,117,52,47,52,0,47,114,100,98,117,53,47,49,0,47,114,100,98,117,53,47,50,0,47,114,100,98,117,53,47,51,0,47,114,100,98,117,53,47,52,0,47,114,100,98,117,53,47,53,0,47,114,100,98,117,54,47,49,0,47,114,100,98,117,54,47,50,0,47,114,100,98,117,54,47,51,0,47,114,100,98,117,54,47,52,0,47,114,100,98,117,54,47,53,0,47,114,100,98,117,54,47,54,0,47,114,100,98,117,55,47,49,0,47,114,100,98,117,55,47,50,0,47,114,100,98,117,55,47,51,0,47,114,100,98,117,55,47,52,0,47,114,100,98,117,55,47,53,0,47,114,100,98,117,55,47,54,0,47,114,100,98,117,55,47,55,0,47,114,100,98,117,56,47,49,0,47,114,100,98,117,56,47,50,0,47,114,100,98,117,56,47,51,0,47,114,100,98,117,56,47,52,0,47,114,100,98,117,56,47,53,0,47,114,100,98,117,56,47,54,0,47,114,100,98,117,56,47,55,0,47,114,100,98,117,56,47,56,0,47,114,100,98,117,57,47,49,0,47,114,100,98,117,57,47,50,0,47,114,100,98,117,57,47,51,0,47,114,100,98,117,57,47,52,0,47,114,100,98,117,57,47,53,0,47,114,100,98,117,57,47,54,0,47,114,100,98,117,57,47,55,0,47,114,100,98,117,57,47,56,0,47,114,100,98,117,57,47,57,0,47,114,100,103,121,49,48,47,49,0,47,114,100,103,121,49,48,47,49,48,0,47,114,100,103,121,49,48,47,50,0,47,114,100,103,121,49,48,47,51,0,47,114,100,103,121,49,48,47,52,0,47,114,100,103,121,49,48,47,53,0,47,114,100,103,121,49,48,47,54,0,47,114,100,103,121,49,48,47,55,0,47,114,100,103,121,49,48,47,56,0,47,114,100,103,121,49,48,47,57,0,47,114,100,103,121,49,49,47,49,0,47,114,100,103,121,49,49,47,49,48,0,47,114,100,103,121,49,49,47,49,49,0,47,114,100,103,121,49,49,47,50,0,47,114,100,103,121,49,49,47,51,0,47,114,100,103,121,49,49,47,52,0,47,114,100,103,121,49,49,47,53,0,47,114,100,103,121,49,49,47,54,0,47,114,100,103,121,49,49,47,55,0,47,114,100,103,121,49,49,47,56,0,47,114,100,103,121,49,49,47,57,0,47,114,100,103,121,51,47,49,0,47,114,100,103,121,51,47,50,0,47,114,100,103,121,51,47,51,0,47,114,100,103,121,52,47,49,0,47,114,100,103,121,52,47,50,0,47,114,100,103,121,52,47,51,0,47,114,100,103,121,52,47,52,0,47,114,100,103,121,53,47,49,0,47,114,100,103,121,53,47,50,0,47,114,100,103,121,53,47,51,0,47,114,100,103,121,53,47,52,0,47,114,100,103,121,53,47,53,0,47,114,100,103,121,54,47,49,0,47,114,100,103,121,54,47,50,0,47,114,100,103,121,54,47,51,0,47,114,100,103,121,54,47,52,0,47,114,100,103,121,54,47,53,0,47,114,100,103,121,54,47,54,0,47,114,100,103,121,55,47,49,0,47,114,100,103,121,55,47,50,0,47,114,100,103,121,55,47,51,0,47,114,100,103,121,55,47,52,0,47,114,100,103,121,55,47,53,0,47,114,100,103,121,55,47,54,0,47,114,100,103,121,55,47,55,0,47,114,100,103,121,56,47,49,0,47,114,100,103,121,56,47,50,0,47,114,100,103,121,56,47,51,0,47,114,100,103,121,56,47,52,0,47,114,100,103,121,56,47,53,0,47,114,100,103,121,56,47,54,0,47,114,100,103,121,56,47,55,0,47,114,100,103,121,56,47,56,0,47,114,100,103,121,57,47,49,0,47,114,100,103,121,57,47,50,0,47,114,100,103,121,57,47,51,0,47,114,100,103,121,57,47,52,0,47,114,100,103,121,57,47,53,0,47,114,100,103,121,57,47,54,0,47,114,100,103,121,57,47,55,0,47,114,100,103,121,57,47,56,0,47,114,100,103,121,57,47,57,0,47,114,100,112,117,51,47,49,0,47,114,100,112,117,51,47,50,0,47,114,100,112,117,51,47,51,0,47,114,100,112,117,52,47,49,0,47,114,100,112,117,52,47,50,0,47,114,100,112,117,52,47,51,0,47,114,100,112,117,52,47,52,0,47,114,100,112,117,53,47,49,0,47,114,100,112,117,53,47,50,0,47,114,100,112,117,53,47,51,0,47,114,100,112,117,53,47,52,0,47,114,100,112,117,53,47,53,0,47,114,100,112,117,54,47,49,0,47,114,100,112,117,54,47,50,0,47,114,100,112,117,54,47,51,0,47,114,100,112,117,54,47,52,0,47,114,100,112,117,54,47,53,0,47,114,100,112,117,54,47,54,0,47,114,100,112,117,55,47,49,0,47,114,100,112,117,55,47,50,0,47,114,100,112,117,55,47,51,0,47,114,100,112,117,55,47,52,0,47,114,100,112,117,55,47,53,0,47,114,100,112,117,55,47,54,0,47,114,100,112,117,55,47,55,0,47,114,100,112,117,56,47,49,0,47,114,100,112,117,56,47,50,0,47,114,100,112,117,56,47,51,0,47,114,100,112,117,56,47,52,0,47,114,100,112,117,56,47,53,0,47,114,100,112,117,56,47,54,0,47,114,100,112,117,56,47,55,0,47,114,100,112,117,56,47,56,0,47,114,100,112,117,57,47,49,0,47,114,100,112,117,57,47,50,0,47,114,100,112,117,57,47,51,0,47,114,100,112,117,57,47,52,0,47,114,100,112,117,57,47,53,0,47,114,100,112,117,57,47,54,0,47,114,100,112,117,57,47,55,0,47,114,100,112,117,57,47,56,0,47,114,100,112,117,57,47,57,0,47,114,100,121,108,98,117,49,48,47,49,0,47,114,100,121,108,98,117,49,48,47,49,48,0,47,114,100,121,108,98,117,49,48,47,50,0,47,114,100,121,108,98,117,49,48,47,51,0,47,114,100,121,108,98,117,49,48,47,52,0,47,114,100,121,108,98,117,49,48,47,53,0,47,114,100,121,108,98,117,49,48,47,54,0,47,114,100,121,108,98,117,49,48,47,55,0,47,114,100,121,108,98,117,49,48,47,56,0,47,114,100,121,108,98,117,49,48,47,57,0,47,114,100,121,108,98,117,49,49,47,49,0,47,114,100,121,108,98,117,49,49,47,49,48,0,47,114,100,121,108,98,117,49,49,47,49,49,0,47,114,100,121,108,98,117,49,49,47,50,0,47,114,100,121,108,98,117,49,49,47,51,0,47,114,100,121,108,98,117,49,49,47,52,0,47,114,100,121,108,98,117,49,49,47,53,0,47,114,100,121,108,98,117,49,49,47,54,0,47,114,100,121,108,98,117,49,49,47,55,0,47,114,100,121,108,98,117,49,49,47,56,0,47,114,100,121,108,98,117,49,49,47,57,0,47,114,100,121,108,98,117,51,47,49,0,47,114,100,121,108,98,117,51,47,50,0,47,114,100,121,108,98,117,51,47,51,0,47,114,100,121,108,98,117,52,47,49,0,47,114,100,121,108,98,117,52,47,50,0,47,114,100,121,108,98,117,52,47,51,0,47,114,100,121,108,98,117,52,47,52,0,47,114,100,121,108,98,117,53,47,49,0,47,114,100,121,108,98,117,53,47,50,0,47,114,100,121,108,98,117,53,47,51,0,47,114,100,121,108,98,117,53,47,52,0,47,114,100,121,108,98,117,53,47,53,0,47,114,100,121,108,98,117,54,47,49,0,47,114,100,121,108,98,117,54,47,50,0,47,114,100,121,108,98,117,54,47,51,0,47,114,100,121,108,98,117,54,47,52,0,47,114,100,121,108,98,117,54,47,53,0,47,114,100,121,108,98,117,54,47,54,0,47,114,100,121,108,98,117,55,47,49,0,47,114,100,121,108,98,117,55,47,50,0,47,114,100,121,108,98,117,55,47,51,0,47,114,100,121,108,98,117,55,47,52,0,47,114,100,121,108,98,117,55,47,53,0,47,114,100,121,108,98,117,55,47,54,0,47,114,100,121,108,98,117,55,47,55,0,47,114,100,121,108,98,117,56,47,49,0,47,114,100,121,108,98,117,56,47,50,0,47,114,100,121,108,98,117,56,47,51,0,47,114,100,121,108,98,117,56,47,52,0,47,114,100,121,108,98,117,56,47,53,0,47,114,100,121,108,98,117,56,47,54,0,47,114,100,121,108,98,117,56,47,55,0,47,114,100,121,108,98,117,56,47,56,0,47,114,100,121,108,98,117,57,47,49,0,47,114,100,121,108,98,117,57,47,50,0,47,114,100,121,108,98,117,57,47,51,0,47,114,100,121,108,98,117,57,47,52,0,47,114,100,121,108,98,117,57,47,53,0,47,114,100,121,108,98,117,57,47,54,0,47,114,100,121,108,98,117,57,47,55,0,47,114,100,121,108,98,117,57,47,56,0,47,114,100,121,108,98,117,57,47,57,0,47,114,100,121,108,103,110,49,48,47,49,0,47,114,100,121,108,103,110,49,48,47,49,48,0,47,114,100,121,108,103,110,49,48,47,50,0,47,114,100,121,108,103,110,49,48,47,51,0,47,114,100,121,108,103,110,49,48,47,52,0,47,114,100,121,108,103,110,49,48,47,53,0,47,114,100,121,108,103,110,49,48,47,54,0,47,114,100,121,108,103,110,49,48,47,55,0,47,114,100,121,108,103,110,49,48,47,56,0,47,114,100,121,108,103,110,49,48,47,57,0,47,114,100,121,108,103,110,49,49,47,49,0,47,114,100,121,108,103,110,49,49,47,49,48,0,47,114,100,121,108,103,110,49,49,47,49,49,0,47,114,100,121,108,103,110,49,49,47,50,0,47,114,100,121,108,103,110,49,49,47,51,0,47,114,100,121,108,103,110,49,49,47,52,0,47,114,100,121,108,103,110,49,49,47,53,0,47,114,100,121,108,103,110,49,49,47,54,0,47,114,100,121,108,103,110,49,49,47,55,0,47,114,100,121,108,103,110,49,49,47,56,0,47,114,100,121,108,103,110,49,49,47,57,0,47,114,100,121,108,103,110,51,47,49,0,47,114,100,121,108,103,110,51,47,50,0,47,114,100,121,108,103,110,51,47,51,0,47,114,100,121,108,103,110,52,47,49,0,47,114,100,121,108,103,110,52,47,50,0,47,114,100,121,108,103,110,52,47,51,0,47,114,100,121,108,103,110,52,47,52,0,47,114,100,121,108,103,110,53,47,49,0,47,114,100,121,108,103,110,53,47,50,0,47,114,100,121,108,103,110,53,47,51,0,47,114,100,121,108,103,110,53,47,52,0,47,114,100,121,108,103,110,53,47,53,0,47,114,100,121,108,103,110,54,47,49,0,47,114,100,121,108,103,110,54,47,50,0,47,114,100,121,108,103,110,54,47,51,0,47,114,100,121,108,103,110,54,47,52,0,47,114,100,121,108,103,110,54,47,53,0,47,114,100,121,108,103,110,54,47,54,0,47,114,100,121,108,103,110,55,47,49,0,47,114,100,121,108,103,110,55,47,50,0,47,114,100,121,108,103,110,55,47,51,0,47,114,100,121,108,103,110,55,47,52,0,47,114,100,121,108,103,110,55,47,53,0,47,114,100,121,108,103,110,55,47,54,0,47,114,100,121,108,103,110,55,47,55,0,47,114,100,121,108,103,110,56,47,49,0,47,114,100,121,108,103,110,56,47,50,0,47,114,100,121,108,103,110,56,47,51,0,47,114,100,121,108,103,110,56,47,52,0,47,114,100,121,108,103,110,56,47,53,0,47,114,100,121,108,103,110,56,47,54,0,47,114,100,121,108,103,110,56,47,55,0,47,114,100,121,108,103,110,56,47,56,0,47,114,100,121,108,103,110,57,47,49,0,47,114,100,121,108,103,110,57,47,50,0,47,114,100,121,108,103,110,57,47,51,0,47,114,100,121,108,103,110,57,47,52,0,47,114,100,121,108,103,110,57,47,53,0,47,114,100,121,108,103,110,57,47,54,0,47,114,100,121,108,103,110,57,47,55,0,47,114,100,121,108,103,110,57,47,56,0,47,114,100,121,108,103,110,57,47,57,0,47,114,101,100,115,51,47,49,0,47,114,101,100,115,51,47,50,0,47,114,101,100,115,51,47,51,0,47,114,101,100,115,52,47,49,0,47,114,101,100,115,52,47,50,0,47,114,101,100,115,52,47,51,0,47,114,101,100,115,52,47,52,0,47,114,101,100,115,53,47,49,0,47,114,101,100,115,53,47,50,0,47,114,101,100,115,53,47,51,0,47,114,101,100,115,53,47,52,0,47,114,101,100,115,53,47,53,0,47,114,101,100,115,54,47,49,0,47,114,101,100,115,54,47,50,0,47,114,101,100,115,54,47,51,0,47,114,101,100,115,54,47,52,0,47,114,101,100,115,54,47,53,0,47,114,101,100,115,54,47,54,0,47,114,101,100,115,55,47,49,0,47,114,101,100,115,55,47,50,0,47,114,101,100,115,55,47,51,0,47,114,101,100,115,55,47,52,0,47,114,101,100,115,55,47,53,0,47,114,101,100,115,55,47,54,0,47,114,101,100,115,55,47,55,0,47,114,101,100,115,56,47,49,0,47,114,101,100,115,56,47,50,0,47,114,101,100,115,56,47,51,0,47,114,101,100,115,56,47,52,0,47,114,101,100,115,56,47,53,0,47,114,101,100,115,56,47,54,0,47,114,101,100,115,56,47,55,0,47,114,101,100,115,56,47,56,0,47,114,101,100,115,57,47,49,0,47,114,101,100,115,57,47,50,0,47,114,101,100,115,57,47,51,0,47,114,101,100,115,57,47,52,0,47,114,101,100,115,57,47,53,0,47,114,101,100,115,57,47,54,0,47,114,101,100,115,57,47,55,0,47,114,101,100,115,57,47,56,0,47,114,101,100,115,57,47,57,0,47,115,101,116,49,51,47,49,0,47,115,101,116,49,51,47,50,0,47,115,101,116,49,51,47,51,0,47,115,101,116,49,52,47,49,0,47,115,101,116,49,52,47,50,0,47,115,101,116,49,52,47,51,0,47,115,101,116,49,52,47,52,0,47,115,101,116,49,53,47,49,0,47,115,101,116,49,53,47,50,0,47,115,101,116,49,53,47,51,0,47,115,101,116,49,53,47,52,0,47,115,101,116,49,53,47,53,0,47,115,101,116,49,54,47,49,0,47,115,101,116,49,54,47,50,0,47,115,101,116,49,54,47,51,0,47,115,101,116,49,54,47,52,0,47,115,101,116,49,54,47,53,0,47,115,101,116,49,54,47,54,0,47,115,101,116,49,55,47,49,0,47,115,101,116,49,55,47,50,0,47,115,101,116,49,55,47,51,0,47,115,101,116,49,55,47,52,0,47,115,101,116,49,55,47,53,0,47,115,101,116,49,55,47,54,0,47,115,101,116,49,55,47,55,0,47,115,101,116,49,56,47,49,0,47,115,101,116,49,56,47,50,0,47,115,101,116,49,56,47,51,0,47,115,101,116,49,56,47,52,0,47,115,101,116,49,56,47,53,0,47,115,101,116,49,56,47,54,0,47,115,101,116,49,56,47,55,0,47,115,101,116,49,56,47,56,0,47,115,101,116,49,57,47,49,0,47,115,101,116,49,57,47,50,0,47,115,101,116,49,57,47,51,0,47,115,101,116,49,57,47,52,0,47,115,101,116,49,57,47,53,0,47,115,101,116,49,57,47,54,0,47,115,101,116,49,57,47,55,0,47,115,101,116,49,57,47,56,0,47,115,101,116,49,57,47,57,0,47,115,101,116,50,51,47,49,0,47,115,101,116,50,51,47,50,0,47,115,101,116,50,51,47,51,0,47,115,101,116,50,52,47,49,0,47,115,101,116,50,52,47,50,0,47,115,101,116,50,52,47,51,0,47,115,101,116,50,52,47,52,0,47,115,101,116,50,53,47,49,0,47,115,101,116,50,53,47,50,0,47,115,101,116,50,53,47,51,0,47,115,101,116,50,53,47,52,0,47,115,101,116,50,53,47,53,0,47,115,101,116,50,54,47,49,0,47,115,101,116,50,54,47,50,0,47,115,101,116,50,54,47,51,0,47,115,101,116,50,54,47,52,0,47,115,101,116,50,54,47,53,0,47,115,101,116,50,54,47,54,0,47,115,101,116,50,55,47,49,0,47,115,101,116,50,55,47,50,0,47,115,101,116,50,55,47,51,0,47,115,101,116,50,55,47,52,0,47,115,101,116,50,55,47,53,0,47,115,101,116,50,55,47,54,0,47,115,101,116,50,55,47,55,0,47,115,101,116,50,56,47,49,0,47,115,101,116,50,56,47,50,0,47,115,101,116,50,56,47,51,0,47,115,101,116,50,56,47,52,0,47,115,101,116,50,56,47,53,0,47,115,101,116,50,56,47,54,0,47,115,101,116,50,56,47,55,0,47,115,101,116,50,56,47,56,0,47,115,101,116,51,49,48,47,49,0,47,115,101,116,51,49,48,47,49,48,0,47,115,101,116,51,49,48,47,50,0,47,115,101,116,51,49,48,47,51,0,47,115,101,116,51,49,48,47,52,0,47,115,101,116,51,49,48,47,53,0,47,115,101,116,51,49,48,47,54,0,47,115,101,116,51,49,48,47,55,0,47,115,101,116,51,49,48,47,56,0,47,115,101,116,51,49,48,47,57,0,47,115,101,116,51,49,49,47,49,0,47,115,101,116,51,49,49,47,49,48,0,47,115,101,116,51,49,49,47,49,49,0,47,115,101,116,51,49,49],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+153182);allocate([47,50,0,47,115,101,116,51,49,49,47,51,0,47,115,101,116,51,49,49,47,52,0,47,115,101,116,51,49,49,47,53,0,47,115,101,116,51,49,49,47,54,0,47,115,101,116,51,49,49,47,55,0,47,115,101,116,51,49,49,47,56,0,47,115,101,116,51,49,49,47,57,0,47,115,101,116,51,49,50,47,49,0,47,115,101,116,51,49,50,47,49,48,0,47,115,101,116,51,49,50,47,49,49,0,47,115,101,116,51,49,50,47,49,50,0,47,115,101,116,51,49,50,47,50,0,47,115,101,116,51,49,50,47,51,0,47,115,101,116,51,49,50,47,52,0,47,115,101,116,51,49,50,47,53,0,47,115,101,116,51,49,50,47,54,0,47,115,101,116,51,49,50,47,55,0,47,115,101,116,51,49,50,47,56,0,47,115,101,116,51,49,50,47,57,0,47,115,101,116,51,51,47,49,0,47,115,101,116,51,51,47,50,0,47,115,101,116,51,51,47,51,0,47,115,101,116,51,52,47,49,0,47,115,101,116,51,52,47,50,0,47,115,101,116,51,52,47,51,0,47,115,101,116,51,52,47,52,0,47,115,101,116,51,53,47,49,0,47,115,101,116,51,53,47,50,0,47,115,101,116,51,53,47,51,0,47,115,101,116,51,53,47,52,0,47,115,101,116,51,53,47,53,0,47,115,101,116,51,54,47,49,0,47,115,101,116,51,54,47,50,0,47,115,101,116,51,54,47,51,0,47,115,101,116,51,54,47,52,0,47,115,101,116,51,54,47,53,0,47,115,101,116,51,54,47,54,0,47,115,101,116,51,55,47,49,0,47,115,101,116,51,55,47,50,0,47,115,101,116,51,55,47,51,0,47,115,101,116,51,55,47,52,0,47,115,101,116,51,55,47,53,0,47,115,101,116,51,55,47,54,0,47,115,101,116,51,55,47,55,0,47,115,101,116,51,56,47,49,0,47,115,101,116,51,56,47,50,0,47,115,101,116,51,56,47,51,0,47,115,101,116,51,56,47,52,0,47,115,101,116,51,56,47,53,0,47,115,101,116,51,56,47,54,0,47,115,101,116,51,56,47,55,0,47,115,101,116,51,56,47,56,0,47,115,101,116,51,57,47,49,0,47,115,101,116,51,57,47,50,0,47,115,101,116,51,57,47,51,0,47,115,101,116,51,57,47,52,0,47,115,101,116,51,57,47,53,0,47,115,101,116,51,57,47,54,0,47,115,101,116,51,57,47,55,0,47,115,101,116,51,57,47,56,0,47,115,101,116,51,57,47,57,0,47,115,112,101,99,116,114,97,108,49,48,47,49,0,47,115,112,101,99,116,114,97,108,49,48,47,49,48,0,47,115,112,101,99,116,114,97,108,49,48,47,50,0,47,115,112,101,99,116,114,97,108,49,48,47,51,0,47,115,112,101,99,116,114,97,108,49,48,47,52,0,47,115,112,101,99,116,114,97,108,49,48,47,53,0,47,115,112,101,99,116,114,97,108,49,48,47,54,0,47,115,112,101,99,116,114,97,108,49,48,47,55,0,47,115,112,101,99,116,114,97,108,49,48,47,56,0,47,115,112,101,99,116,114,97,108,49,48,47,57,0,47,115,112,101,99,116,114,97,108,49,49,47,49,0,47,115,112,101,99,116,114,97,108,49,49,47,49,48,0,47,115,112,101,99,116,114,97,108,49,49,47,49,49,0,47,115,112,101,99,116,114,97,108,49,49,47,50,0,47,115,112,101,99,116,114,97,108,49,49,47,51,0,47,115,112,101,99,116,114,97,108,49,49,47,52,0,47,115,112,101,99,116,114,97,108,49,49,47,53,0,47,115,112,101,99,116,114,97,108,49,49,47,54,0,47,115,112,101,99,116,114,97,108,49,49,47,55,0,47,115,112,101,99,116,114,97,108,49,49,47,56,0,47,115,112,101,99,116,114,97,108,49,49,47,57,0,47,115,112,101,99,116,114,97,108,51,47,49,0,47,115,112,101,99,116,114,97,108,51,47,50,0,47,115,112,101,99,116,114,97,108,51,47,51,0,47,115,112,101,99,116,114,97,108,52,47,49,0,47,115,112,101,99,116,114,97,108,52,47,50,0,47,115,112,101,99,116,114,97,108,52,47,51,0,47,115,112,101,99,116,114,97,108,52,47,52,0,47,115,112,101,99,116,114,97,108,53,47,49,0,47,115,112,101,99,116,114,97,108,53,47,50,0,47,115,112,101,99,116,114,97,108,53,47,51,0,47,115,112,101,99,116,114,97,108,53,47,52,0,47,115,112,101,99,116,114,97,108,53,47,53,0,47,115,112,101,99,116,114,97,108,54,47,49,0,47,115,112,101,99,116,114,97,108,54,47,50,0,47,115,112,101,99,116,114,97,108,54,47,51,0,47,115,112,101,99,116,114,97,108,54,47,52,0,47,115,112,101,99,116,114,97,108,54,47,53,0,47,115,112,101,99,116,114,97,108,54,47,54,0,47,115,112,101,99,116,114,97,108,55,47,49,0,47,115,112,101,99,116,114,97,108,55,47,50,0,47,115,112,101,99,116,114,97,108,55,47,51,0,47,115,112,101,99,116,114,97,108,55,47,52,0,47,115,112,101,99,116,114,97,108,55,47,53,0,47,115,112,101,99,116,114,97,108,55,47,54,0,47,115,112,101,99,116,114,97,108,55,47,55,0,47,115,112,101,99,116,114,97,108,56,47,49,0,47,115,112,101,99,116,114,97,108,56,47,50,0,47,115,112,101,99,116,114,97,108,56,47,51,0,47,115,112,101,99,116,114,97,108,56,47,52,0,47,115,112,101,99,116,114,97,108,56,47,53,0,47,115,112,101,99,116,114,97,108,56,47,54,0,47,115,112,101,99,116,114,97,108,56,47,55,0,47,115,112,101,99,116,114,97,108,56,47,56,0,47,115,112,101,99,116,114,97,108,57,47,49,0,47,115,112,101,99,116,114,97,108,57,47,50,0,47,115,112,101,99,116,114,97,108,57,47,51,0,47,115,112,101,99,116,114,97,108,57,47,52,0,47,115,112,101,99,116,114,97,108,57,47,53,0,47,115,112,101,99,116,114,97,108,57,47,54,0,47,115,112,101,99,116,114,97,108,57,47,55,0,47,115,112,101,99,116,114,97,108,57,47,56,0,47,115,112,101,99,116,114,97,108,57,47,57,0,47,115,118,103,47,97,108,105,99,101,98,108,117,101,0,47,115,118,103,47,97,110,116,105,113,117,101,119,104,105,116,101,0,47,115,118,103,47,97,113,117,97,0,47,115,118,103,47,97,113,117,97,109,97,114,105,110,101,0,47,115,118,103,47,97,122,117,114,101,0,47,115,118,103,47,98,101,105,103,101,0,47,115,118,103,47,98,105,115,113,117,101,0,47,115,118,103,47,98,108,97,99,107,0,47,115,118,103,47,98,108,97,110,99,104,101,100,97,108,109,111,110,100,0,47,115,118,103,47,98,108,117,101,0,47,115,118,103,47,98,108,117,101,118,105,111,108,101,116,0,47,115,118,103,47,98,114,111,119,110,0,47,115,118,103,47,98,117,114,108,121,119,111,111,100,0,47,115,118,103,47,99,97,100,101,116,98,108,117,101,0,47,115,118,103,47,99,104,97,114,116,114,101,117,115,101,0,47,115,118,103,47,99,104,111,99,111,108,97,116,101,0,47,115,118,103,47,99,111,114,97,108,0,47,115,118,103,47,99,111,114,110,102,108,111,119,101,114,98,108,117,101,0,47,115,118,103,47,99,111,114,110,115,105,108,107,0,47,115,118,103,47,99,114,105,109,115,111,110,0,47,115,118,103,47,99,121,97,110,0,47,115,118,103,47,100,97,114,107,98,108,117,101,0,47,115,118,103,47,100,97,114,107,99,121,97,110,0,47,115,118,103,47,100,97,114,107,103,111,108,100,101,110,114,111,100,0,47,115,118,103,47,100,97,114,107,103,114,97,121,0,47,115,118,103,47,100,97,114,107,103,114,101,101,110,0,47,115,118,103,47,100,97,114,107,103,114,101,121,0,47,115,118,103,47,100,97,114,107,107,104,97,107,105,0,47,115,118,103,47,100,97,114,107,109,97,103,101,110,116,97,0,47,115,118,103,47,100,97,114,107,111,108,105,118,101,103,114,101,101,110,0,47,115,118,103,47,100,97,114,107,111,114,97,110,103,101,0,47,115,118,103,47,100,97,114,107,111,114,99,104,105,100,0,47,115,118,103,47,100,97,114,107,114,101,100,0,47,115,118,103,47,100,97,114,107,115,97,108,109,111,110,0,47,115,118,103,47,100,97,114,107,115,101,97,103,114,101,101,110,0,47,115,118,103,47,100,97,114,107,115,108,97,116,101,98,108,117,101,0,47,115,118,103,47,100,97,114,107,115,108,97,116,101,103,114,97,121,0,47,115,118,103,47,100,97,114,107,115,108,97,116,101,103,114,101,121,0,47,115,118,103,47,100,97,114,107,116,117,114,113,117,111,105,115,101,0,47,115,118,103,47,100,97,114,107,118,105,111,108,101,116,0,47,115,118,103,47,100,101,101,112,112,105,110,107,0,47,115,118,103,47,100,101,101,112,115,107,121,98,108,117,101,0,47,115,118,103,47,100,105,109,103,114,97,121,0,47,115,118,103,47,100,105,109,103,114,101,121,0,47,115,118,103,47,100,111,100,103,101,114,98,108,117,101,0,47,115,118,103,47,102,105,114,101,98,114,105,99,107,0,47,115,118,103,47,102,108,111,114,97,108,119,104,105,116,101,0,47,115,118,103,47,102,111,114,101,115,116,103,114,101,101,110,0,47,115,118,103,47,102,117,99,104,115,105,97,0,47,115,118,103,47,103,97,105,110,115,98,111,114,111,0,47,115,118,103,47,103,104,111,115,116,119,104,105,116,101,0,47,115,118,103,47,103,111,108,100,0,47,115,118,103,47,103,111,108,100,101,110,114,111,100,0,47,115,118,103,47,103,114,97,121,0,47,115,118,103,47,103,114,101,101,110,0,47,115,118,103,47,103,114,101,101,110,121,101,108,108,111,119,0,47,115,118,103,47,103,114,101,121,0,47,115,118,103,47,104,111,110,101,121,100,101,119,0,47,115,118,103,47,104,111,116,112,105,110,107,0,47,115,118,103,47,105,110,100,105,97,110,114,101,100,0,47,115,118,103,47,105,110,100,105,103,111,0,47,115,118,103,47,105,118,111,114,121,0,47,115,118,103,47,107,104,97,107,105,0,47,115,118,103,47,108,97,118,101,110,100,101,114,0,47,115,118,103,47,108,97,118,101,110,100,101,114,98,108,117,115,104,0,47,115,118,103,47,108,97,119,110,103,114,101,101,110,0,47,115,118,103,47,108,101,109,111,110,99,104,105,102,102,111,110,0,47,115,118,103,47,108,105,103,104,116,98,108,117,101,0,47,115,118,103,47,108,105,103,104,116,99,111,114,97,108,0,47,115,118,103,47,108,105,103,104,116,99,121,97,110,0,47,115,118,103,47,108,105,103,104,116,103,111,108,100,101,110,114,111,100,121,101,108,108,111,119,0,47,115,118,103,47,108,105,103,104,116,103,114,97,121,0,47,115,118,103,47,108,105,103,104,116,103,114,101,101,110,0,47,115,118,103,47,108,105,103,104,116,103,114,101,121,0,47,115,118,103,47,108,105,103,104,116,112,105,110,107,0,47,115,118,103,47,108,105,103,104,116,115,97,108,109,111,110,0,47,115,118,103,47,108,105,103,104,116,115,101,97,103,114,101,101,110,0,47,115,118,103,47,108,105,103,104,116,115,107,121,98,108,117,101,0,47,115,118,103,47,108,105,103,104,116,115,108,97,116,101,103,114,97,121,0,47,115,118,103,47,108,105,103,104,116,115,108,97,116,101,103,114,101,121,0,47,115,118,103,47,108,105,103,104,116,115,116,101,101,108,98,108,117,101,0,47,115,118,103,47,108,105,103,104,116,121,101,108,108,111,119,0,47,115,118,103,47,108,105,109,101,0,47,115,118,103,47,108,105,109,101,103,114,101,101,110,0,47,115,118,103,47,108,105,110,101,110,0,47,115,118,103,47,109,97,103,101,110,116,97,0,47,115,118,103,47,109,97,114,111,111,110,0,47,115,118,103,47,109,101,100,105,117,109,97,113,117,97,109,97,114,105,110,101,0,47,115,118,103,47,109,101,100,105,117,109,98,108,117,101,0,47,115,118,103,47,109,101,100,105,117,109,111,114,99,104,105,100,0,47,115,118,103,47,109,101,100,105,117,109,112,117,114,112,108,101,0,47,115,118,103,47,109,101,100,105,117,109,115,101,97,103,114,101,101,110,0,47,115,118,103,47,109,101,100,105,117,109,115,108,97,116,101,98,108,117,101,0,47,115,118,103,47,109,101,100,105,117,109,115,112,114,105,110,103,103,114,101,101,110,0,47,115,118,103,47,109,101,100,105,117,109,116,117,114,113,117,111,105,115,101,0,47,115,118,103,47,109,101,100,105,117,109,118,105,111,108,101,116,114,101,100,0,47,115,118,103,47,109,105,100,110,105,103,104,116,98,108,117,101,0,47,115,118,103,47,109,105,110,116,99,114,101,97,109,0,47,115,118,103,47,109,105,115,116,121,114,111,115,101,0,47,115,118,103,47,109,111,99,99,97,115,105,110,0,47,115,118,103,47,110,97,118,97,106,111,119,104,105,116,101,0,47,115,118,103,47,110,97,118,121,0,47,115,118,103,47,111,108,100,108,97,99,101,0,47,115,118,103,47,111,108,105,118,101,0,47,115,118,103,47,111,108,105,118,101,100,114,97,98,0,47,115,118,103,47,111,114,97,110,103,101,0,47,115,118,103,47,111,114,97,110,103,101,114,101,100,0,47,115,118,103,47,111,114,99,104,105,100,0,47,115,118,103,47,112,97,108,101,103,111,108,100,101,110,114,111,100,0,47,115,118,103,47,112,97,108,101,103,114,101,101,110,0,47,115,118,103,47,112,97,108,101,116,117,114,113,117,111,105,115,101,0,47,115,118,103,47,112,97,108,101,118,105,111,108,101,116,114,101,100,0,47,115,118,103,47,112,97,112,97,121,97,119,104,105,112,0,47,115,118,103,47,112,101,97,99,104,112,117,102,102,0,47,115,118,103,47,112,101,114,117,0,47,115,118,103,47,112,105,110,107,0,47,115,118,103,47,112,108,117,109,0,47,115,118,103,47,112,111,119,100,101,114,98,108,117,101,0,47,115,118,103,47,112,117,114,112,108,101,0,47,115,118,103,47,114,101,100,0,47,115,118,103,47,114,111,115,121,98,114,111,119,110,0,47,115,118,103,47,114,111,121,97,108,98,108,117,101,0,47,115,118,103,47,115,97,100,100,108,101,98,114,111,119,110,0,47,115,118,103,47,115,97,108,109,111,110,0,47,115,118,103,47,115,97,110,100,121,98,114,111,119,110,0,47,115,118,103,47,115,101,97,103,114,101,101,110,0,47,115,118,103,47,115,101,97,115,104,101,108,108,0,47,115,118,103,47,115,105,101,110,110,97,0,47,115,118,103,47,115,105,108,118,101,114,0,47,115,118,103,47,115,107,121,98,108,117,101,0,47,115,118,103,47,115,108,97,116,101,98,108,117,101,0,47,115,118,103,47,115,108,97,116,101,103,114,97,121,0,47,115,118,103,47,115,108,97,116,101,103,114,101,121,0,47,115,118,103,47,115,110,111,119,0,47,115,118,103,47,115,112,114,105,110,103,103,114,101,101,110,0,47,115,118,103,47,115,116,101,101,108,98,108,117,101,0,47,115,118,103,47,116,97,110,0,47,115,118,103,47,116,101,97,108,0,47,115,118,103,47,116,104,105,115,116,108,101,0,47,115,118,103,47,116,111,109,97,116,111,0,47,115,118,103,47,116,117,114,113,117,111,105,115,101,0,47,115,118,103,47,118,105,111,108,101,116,0,47,115,118,103,47,119,104,101,97,116,0,47,115,118,103,47,119,104,105,116,101,0,47,115,118,103,47,119,104,105,116,101,115,109,111,107,101,0,47,115,118,103,47,121,101,108,108,111,119,0,47,115,118,103,47,121,101,108,108,111,119,103,114,101,101,110,0,47,121,108,103,110,51,47,49,0,47,121,108,103,110,51,47,50,0,47,121,108,103,110,51,47,51,0,47,121,108,103,110,52,47,49,0,47,121,108,103,110,52,47,50,0,47,121,108,103,110,52,47,51,0,47,121,108,103,110,52,47,52,0,47,121,108,103,110,53,47,49,0,47,121,108,103,110,53,47,50,0,47,121,108,103,110,53,47,51,0,47,121,108,103,110,53,47,52,0,47,121,108,103,110,53,47,53,0,47,121,108,103,110,54,47,49,0,47,121,108,103,110,54,47,50,0,47,121,108,103,110,54,47,51,0,47,121,108,103,110,54,47,52,0,47,121,108,103,110,54,47,53,0,47,121,108,103,110,54,47,54,0,47,121,108,103,110,55,47,49,0,47,121,108,103,110,55,47,50,0,47,121,108,103,110,55,47,51,0,47,121,108,103,110,55,47,52,0,47,121,108,103,110,55,47,53,0,47,121,108,103,110,55,47,54,0,47,121,108,103,110,55,47,55,0,47,121,108,103,110,56,47,49,0,47,121,108,103,110,56,47,50,0,47,121,108,103,110,56,47,51,0,47,121,108,103,110,56,47,52,0,47,121,108,103,110,56,47,53,0,47,121,108,103,110,56,47,54,0,47,121,108,103,110,56,47,55,0,47,121,108,103,110,56,47,56,0,47,121,108,103,110,57,47,49,0,47,121,108,103,110,57,47,50,0,47,121,108,103,110,57,47,51,0,47,121,108,103,110,57,47,52,0,47,121,108,103,110,57,47,53,0,47,121,108,103,110,57,47,54,0,47,121,108,103,110,57,47,55,0,47,121,108,103,110,57,47,56,0,47,121,108,103,110,57,47,57,0,47,121,108,103,110,98,117,51,47,49,0,47,121,108,103,110,98,117,51,47,50,0,47,121,108,103,110,98,117,51,47,51,0,47,121,108,103,110,98,117,52,47,49,0,47,121,108,103,110,98,117,52,47,50,0,47,121,108,103,110,98,117,52,47,51,0,47,121,108,103,110,98,117,52,47,52,0,47,121,108,103,110,98,117,53,47,49,0,47,121,108,103,110,98,117,53,47,50,0,47,121,108,103,110,98,117,53,47,51,0,47,121,108,103,110,98,117,53,47,52,0,47,121,108,103,110,98,117,53,47,53,0,47,121,108,103,110,98,117,54,47,49,0,47,121,108,103,110,98,117,54,47,50,0,47,121,108,103,110,98,117,54,47,51,0,47,121,108,103,110,98,117,54,47,52,0,47,121,108,103,110,98,117,54,47,53,0,47,121,108,103,110,98,117,54,47,54,0,47,121,108,103,110,98,117,55,47,49,0,47,121,108,103,110,98,117,55,47,50,0,47,121,108,103,110,98,117,55,47,51,0,47,121,108,103,110,98,117,55,47,52,0,47,121,108,103,110,98,117,55,47,53,0,47,121,108,103,110,98,117,55,47,54,0,47,121,108,103,110,98,117,55,47,55,0,47,121,108,103,110,98,117,56,47,49,0,47,121,108,103,110,98,117,56,47,50,0,47,121,108,103,110,98,117,56,47,51,0,47,121,108,103,110,98,117,56,47,52,0,47,121,108,103,110,98,117,56,47,53,0,47,121,108,103,110,98,117,56,47,54,0,47,121,108,103,110,98,117,56,47,55,0,47,121,108,103,110,98,117,56,47,56,0,47,121,108,103,110,98,117,57,47,49,0,47,121,108,103,110,98,117,57,47,50,0,47,121,108,103,110,98,117,57,47,51,0,47,121,108,103,110,98,117,57,47,52,0,47,121,108,103,110,98,117,57,47,53,0,47,121,108,103,110,98,117,57,47,54,0,47,121,108,103,110,98,117,57,47,55,0,47,121,108,103,110,98,117,57,47,56,0,47,121,108,103,110,98,117,57,47,57,0,47,121,108,111,114,98,114,51,47,49,0,47,121,108,111,114,98,114,51,47,50,0,47,121,108,111,114,98,114,51,47,51,0,47,121,108,111,114,98,114,52,47,49,0,47,121,108,111,114,98,114,52,47,50,0,47,121,108,111,114,98,114,52,47,51,0,47,121,108,111,114,98,114,52,47,52,0,47,121,108,111,114,98,114,53,47,49,0,47,121,108,111,114,98,114,53,47,50,0,47,121,108,111,114,98,114,53,47,51,0,47,121,108,111,114,98,114,53,47,52,0,47,121,108,111,114,98,114,53,47,53,0,47,121,108,111,114,98,114,54,47,49,0,47,121,108,111,114,98,114,54,47,50,0,47,121,108,111,114,98,114,54,47,51,0,47,121,108,111,114,98,114,54,47,52,0,47,121,108,111,114,98,114,54,47,53,0,47,121,108,111,114,98,114,54,47,54,0,47,121,108,111,114,98,114,55,47,49,0,47,121,108,111,114,98,114,55,47,50,0,47,121,108,111,114,98,114,55,47,51,0,47,121,108,111,114,98,114,55,47,52,0,47,121,108,111,114,98,114,55,47,53,0,47,121,108,111,114,98,114,55,47,54,0,47,121,108,111,114,98,114,55,47,55,0,47,121,108,111,114,98,114,56,47,49,0,47,121,108,111,114,98,114,56,47,50,0,47,121,108,111,114,98,114,56,47,51,0,47,121,108,111,114,98,114,56,47,52,0,47,121,108,111,114,98,114,56,47,53,0,47,121,108,111,114,98,114,56,47,54,0,47,121,108,111,114,98,114,56,47,55,0,47,121,108,111,114,98,114,56,47,56,0,47,121,108,111,114,98,114,57,47,49,0,47,121,108,111,114,98,114,57,47,50,0,47,121,108,111,114,98,114,57,47,51,0,47,121,108,111,114,98,114,57,47,52,0,47,121,108,111,114,98,114,57,47,53,0,47,121,108,111,114,98,114,57,47,54,0,47,121,108,111,114,98,114,57,47,55,0,47,121,108,111,114,98,114,57,47,56,0,47,121,108,111,114,98,114,57,47,57,0,47,121,108,111,114,114,100,51,47,49,0,47,121,108,111,114,114,100,51,47,50,0,47,121,108,111,114,114,100,51,47,51,0,47,121,108,111,114,114,100,52,47,49,0,47,121,108,111,114,114,100,52,47,50,0,47,121,108,111,114,114,100,52,47,51,0,47,121,108,111,114,114,100,52,47,52,0,47,121,108,111,114,114,100,53,47,49,0,47,121,108,111,114,114,100,53,47,50,0,47,121,108,111,114,114,100,53,47,51,0,47,121,108,111,114,114,100,53,47,52,0,47,121,108,111,114,114,100,53,47,53,0,47,121,108,111,114,114,100,54,47,49,0,47,121,108,111,114,114,100,54,47,50,0,47,121,108,111,114,114,100,54,47,51,0,47,121,108,111,114,114,100,54,47,52,0,47,121,108,111,114,114,100,54,47,53,0,47,121,108,111,114,114,100,54,47,54,0,47,121,108,111,114,114,100,55,47,49,0,47,121,108,111,114,114,100,55,47,50,0,47,121,108,111,114,114,100,55,47,51,0,47,121,108,111,114,114,100,55,47,52,0,47,121,108,111,114,114,100,55,47,53,0,47,121,108,111,114,114,100,55,47,54,0,47,121,108,111,114,114,100,55,47,55,0,47,121,108,111,114,114,100,56,47,49,0,47,121,108,111,114,114,100,56,47,50,0,47,121,108,111,114,114,100,56,47,51,0,47,121,108,111,114,114,100,56,47,52,0,47,121,108,111,114,114,100,56,47,53,0,47,121,108,111,114,114,100,56,47,54,0,47,121,108,111,114,114,100,56,47,55,0,47,121,108,111,114,114,100,56,47,56,0,47,121,108,111,114,114,100,57,47,49,0,47,121,108,111,114,114,100,57,47,50,0,47,121,108,111,114,114,100,57,47,51,0,47,121,108,111,114,114,100,57,47,52,0,47,121,108,111,114,114,100,57,47,53,0,47,121,108,111,114,114,100,57,47,54,0,47,121,108,111,114,114,100,57,47,55,0,47,121,108,111,114,114,100,57,47,56,0,47,121,108,111,114,114,100,57,47,57,0,97,108,105,99,101,98,108,117,101,0,97,110,116,105,113,117,101,119,104,105,116,101,0,97,110,116,105,113,117,101,119,104,105,116,101,49,0,97,110,116,105,113,117,101,119,104,105,116,101,50,0,97,110,116,105,113,117,101,119,104,105,116,101,51,0,97,110,116,105,113,117,101,119,104,105,116,101,52,0,97,113,117,97,109,97,114,105,110,101,0,97,113,117,97,109,97,114,105,110,101,49,0,97,113,117,97,109,97,114,105,110,101,50,0,97,113,117,97,109,97,114,105,110,101,51,0,97,113,117,97,109,97,114,105,110,101,52,0,97,122,117,114,101,0,97,122,117,114,101,49,0,97,122,117,114,101,50,0,97,122,117,114,101,51,0,97,122,117,114,101,52,0,98,101,105,103,101,0,98,105,115,113,117,101,0,98,105,115,113,117,101,49,0,98,105,115,113,117,101,50,0,98,105,115,113,117,101,51,0,98,105,115,113,117,101,52,0,98,108,97,110,99,104,101,100,97,108,109,111,110,100,0,98,108,117,101,0,98,108,117,101,49,0,98,108,117,101,50,0,98,108,117,101,51,0,98,108,117,101,52,0,98,108,117,101,118,105,111,108,101,116,0,98,114,111,119,110,0,98,114,111,119,110,49,0,98,114,111,119,110,50,0,98,114,111,119,110,51,0,98,114,111,119,110,52,0,98,117,114,108,121,119,111,111,100,0,98,117,114,108,121,119,111,111,100,49,0,98,117,114,108,121,119,111,111,100,50,0,98,117,114,108,121,119,111,111,100,51,0,98,117,114,108,121,119,111,111,100,52,0,99,97,100,101,116,98,108,117,101,0,99,97,100,101,116,98,108,117,101,49,0,99,97,100,101,116,98,108,117,101,50,0,99,97,100,101,116,98,108,117,101,51,0,99,97,100,101,116,98,108,117,101,52,0,99,104,97,114,116,114,101,117,115,101,0,99,104,97,114,116,114,101,117,115,101,49,0,99,104,97,114,116,114,101,117,115,101,50,0,99,104,97,114,116,114,101,117,115,101,51,0,99,104,97,114,116,114,101,117,115,101,52,0,99,104,111,99,111,108,97,116,101,0,99,104,111,99,111,108,97,116,101,49,0,99,104,111,99,111,108,97,116,101,50,0,99,104,111,99,111,108,97,116,101,51,0,99,104,111,99,111,108,97,116,101,52,0,99,111,114,97,108,0,99,111,114,97,108,49,0,99,111,114,97,108,50,0,99,111,114,97,108,51,0,99,111,114,97,108,52,0,99,111,114,110,102,108,111,119,101,114,98,108,117,101,0,99,111,114,110,115,105,108,107,0,99,111,114,110,115,105,108,107,49,0,99,111,114,110,115,105,108,107,50,0,99,111,114,110,115,105,108,107,51,0,99,111,114,110,115,105,108,107,52,0,99,114,105,109,115,111,110,0,99,121,97,110,0,99,121,97,110,49,0,99,121,97,110,50,0,99,121,97,110,51,0,99,121,97,110,52,0,100,97,114,107,103,111,108,100,101,110,114,111,100,0,100,97,114,107,103,111,108,100,101,110,114,111,100,49,0,100,97,114,107,103,111,108,100,101,110,114,111,100,50,0,100,97,114,107,103,111,108,100,101,110,114,111,100,51,0,100,97,114,107,103,111,108,100,101,110,114,111,100,52,0,100,97,114,107,103,114,101,101,110,0,100,97,114,107,107,104,97,107,105,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,49,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,50,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,51,0,100,97,114,107,111,108,105,118,101,103,114,101,101,110,52,0,100,97,114,107,111,114,97,110,103,101,0,100,97,114,107,111,114,97,110,103,101,49,0,100,97,114,107,111,114,97,110,103,101,50,0,100,97,114,107,111,114,97,110,103,101,51,0,100,97,114,107,111,114,97,110,103,101,52,0,100,97,114,107,111,114,99,104,105,100,0,100,97,114,107,111,114,99,104,105,100,49,0,100,97,114,107,111,114,99,104,105,100,50,0,100,97,114,107,111,114,99,104,105,100,51,0,100,97,114,107,111,114,99,104,105,100,52,0,100,97,114,107,115,97,108,109,111,110,0,100,97,114,107,115,101,97,103,114,101,101,110,0,100,97,114,107,115,101,97,103,114,101,101,110,49,0,100,97,114,107,115,101,97,103,114,101,101,110,50,0,100,97,114,107,115,101,97,103,114,101,101,110,51,0,100,97,114,107,115,101,97,103,114,101,101,110,52,0,100,97,114,107,115,108,97,116,101,98,108,117,101,0,100,97,114,107,115,108,97,116,101,103,114,97,121,0,100,97,114,107,115,108,97,116,101,103,114,97,121,49,0,100,97,114,107,115,108,97,116,101,103,114,97,121,50,0,100,97,114,107,115,108,97,116,101,103,114,97,121,51,0,100,97,114,107,115,108,97,116,101,103,114,97,121,52,0,100,97,114,107,115,108,97,116,101,103,114,101,121,0,100,97,114,107,116,117,114,113,117,111,105,115,101,0,100,97,114,107,118,105,111,108,101,116,0,100,101,101,112,112,105,110,107,0,100,101,101,112,112,105,110,107,49,0,100,101,101,112,112,105,110,107,50,0,100,101,101,112,112,105,110,107,51,0,100,101,101,112,112,105,110,107,52,0,100,101,101,112,115,107,121,98,108,117,101,0,100,101,101,112,115,107,121,98,108,117,101,49,0,100,101,101,112,115,107,121,98,108,117,101,50,0,100,101,101,112,115,107,121,98,108,117,101,51,0,100,101,101,112,115,107,121,98,108,117,101,52,0,100,105,109,103,114,97,121,0,100,105,109,103,114,101,121,0,100,111,100,103,101,114,98,108,117,101,0,100,111,100,103,101,114,98,108,117,101,49,0,100,111,100,103,101,114,98,108,117,101,50,0,100,111,100,103,101,114,98,108,117,101,51,0,100,111,100,103,101,114,98,108,117,101,52,0,102,105,114,101,98,114,105,99,107,0,102,105,114,101,98,114,105,99,107,49,0,102,105,114,101,98,114,105,99,107,50,0,102,105,114,101,98,114,105,99,107,51,0,102,105,114,101,98,114,105,99,107,52,0,102,108,111,114,97,108,119,104,105,116,101,0,102,111,114,101,115,116,103,114,101,101,110,0,103,97,105,110,115,98,111,114,111,0,103,104,111,115,116,119,104,105,116,101,0,103,111,108,100,0,103,111,108,100,49,0,103,111,108,100,50,0,103,111,108,100,51,0,103,111,108,100,52,0,103,111,108,100,101,110,114,111,100,0,103,111,108,100,101,110,114,111,100,49,0,103,111,108,100,101,110,114,111,100,50,0,103,111,108,100,101,110,114,111,100,51,0,103,111,108,100,101,110,114,111,100,52,0,103,114,97,121,0,103,114,97,121,48,0,103,114,97,121,49,0,103,114,97,121,49,48,0,103,114,97,121,49,48,48,0,103,114,97,121,49,49,0,103,114,97,121,49,50,0,103,114,97,121,49,51,0,103,114,97,121,49,52,0,103,114,97,121,49,53,0,103,114,97,121,49,54,0,103,114,97,121,49,55,0,103,114,97,121,49,56,0,103,114,97,121,49,57,0,103,114,97,121,50,0,103,114,97,121,50,48,0,103,114,97,121,50,49,0,103,114,97,121,50,50,0,103,114,97,121,50,51,0,103,114,97,121,50,52,0,103,114,97,121,50,53,0,103,114,97,121,50,54,0,103,114,97,121,50,55,0,103,114,97,121,50,56,0,103,114,97,121,50,57,0,103,114,97,121,51,0,103,114,97,121,51,48,0,103,114,97,121,51,49,0,103,114,97,121,51,50,0,103,114,97,121,51,51,0,103,114,97,121,51,52,0,103,114,97,121,51,53,0,103,114,97,121,51,54,0,103,114,97,121,51,55,0,103,114,97,121,51,56,0,103,114,97,121,51,57,0,103,114,97,121,52,0,103,114,97,121,52,48,0,103,114,97,121,52,49,0,103,114,97,121,52,50,0,103,114,97,121,52,51,0,103,114,97,121,52,52,0,103,114,97,121,52,53,0,103,114,97,121,52,54,0,103,114,97,121,52,55,0,103,114,97,121,52,56,0,103,114,97,121,52,57,0,103,114,97,121,53,0,103,114,97,121,53,48,0,103,114,97,121,53,49,0,103,114,97,121,53,50,0,103,114,97,121,53,51,0,103,114,97,121,53,52,0,103,114,97,121,53,53,0,103,114,97,121,53,54,0,103,114,97,121,53,55,0,103,114,97,121,53,56,0,103,114,97,121,53,57,0,103,114,97,121,54,0,103,114,97,121,54,48,0,103,114,97,121,54,49,0,103,114,97,121,54,50,0,103,114,97,121,54,51,0,103,114,97,121,54,52,0,103,114,97,121,54,53,0,103,114,97,121,54,54,0,103,114,97,121,54,55,0,103,114,97,121,54,56,0,103,114,97,121,54,57,0,103,114,97,121,55,0,103,114,97,121,55,48,0,103,114,97,121,55,49,0,103,114,97,121,55,50,0,103,114,97,121,55,51,0,103,114,97,121,55,52,0,103,114,97,121,55,53,0,103,114,97,121,55,54,0,103,114,97,121,55,55,0,103,114,97,121,55,56,0,103,114,97,121,55,57,0,103,114,97,121,56,0,103,114,97,121,56,48,0,103,114,97,121,56,49,0,103,114,97,121,56,50,0,103,114,97,121,56,51,0,103,114,97,121,56,52,0,103,114,97,121,56,53,0,103,114,97,121,56,54,0,103,114,97,121,56,55,0,103,114,97,121,56,56,0,103,114,97,121,56,57,0,103,114,97,121,57,0,103,114,97,121,57,48,0,103,114,97,121,57,49,0,103,114,97,121,57,50,0,103,114,97,121,57,51,0,103,114,97,121,57,52,0,103,114,97,121,57,53,0,103,114,97,121,57,54,0,103,114,97,121,57,55,0,103,114,97,121,57,56,0,103,114,97,121,57,57,0,103,114,101,101,110,0,103,114,101,101,110,49,0,103,114,101,101,110,50,0,103,114,101,101,110,51,0,103,114,101,101,110,52,0,103,114,101,101,110,121,101,108,108,111,119,0,103,114,101,121,0,103,114,101,121,48,0,103,114,101,121,49,0,103,114,101,121,49,48,0,103,114,101,121,49,48,48,0,103,114,101,121,49,49,0,103,114,101,121,49,50,0,103,114,101,121,49,51,0,103,114,101,121,49,52,0,103,114,101,121,49,53,0,103,114,101,121,49,54,0,103,114,101,121,49,55,0,103,114,101,121,49,56,0,103,114,101,121,49,57,0,103,114,101,121,50,0,103,114,101,121,50,48,0,103,114,101,121,50,49,0,103,114,101,121,50,50,0,103,114,101,121,50,51,0,103,114,101,121,50,52,0,103,114,101,121,50,53,0,103,114,101,121,50,54,0,103,114,101,121,50,55,0,103,114,101,121,50,56,0,103,114,101,121,50,57,0,103,114,101,121,51,0,103,114,101,121,51,48,0,103,114,101,121,51,49,0,103,114,101,121,51,50,0,103,114,101,121,51,51,0,103,114,101,121,51,52,0,103,114,101,121,51,53,0,103,114,101,121,51,54,0,103,114,101,121,51,55,0,103,114,101,121,51,56,0,103,114,101,121,51,57,0,103,114,101,121,52,0,103,114,101,121,52,48,0,103,114,101,121,52,49,0,103,114,101,121,52,50,0,103,114,101,121,52,51,0,103,114,101,121,52,52,0,103,114,101,121,52,53,0,103,114,101,121,52,54,0,103,114,101,121,52,55,0,103,114,101,121,52,56,0,103,114,101,121,52,57,0,103,114,101,121,53,0,103,114,101,121,53,48,0,103,114,101,121,53,49,0,103,114,101,121,53,50,0,103,114,101,121,53,51,0,103,114,101,121,53,52,0,103,114,101,121,53,53,0,103,114,101,121,53,54,0,103,114,101,121,53,55,0,103,114,101,121,53,56,0,103,114,101,121,53,57,0,103,114,101,121,54,0,103,114,101,121,54,48,0,103,114,101,121,54,49,0,103,114,101,121,54,50,0,103,114,101,121,54,51,0,103,114,101,121,54,52,0,103,114,101,121,54,53,0,103,114,101,121,54,54,0,103,114,101,121,54,55,0,103,114,101,121,54,56,0,103,114,101,121,54,57,0,103,114,101,121,55,0,103,114,101,121,55,48,0,103,114,101,121,55,49,0,103,114,101,121,55,50,0,103,114,101,121,55,51,0,103,114,101,121,55,52,0,103,114,101,121,55,53,0,103,114,101,121,55,54,0,103,114,101,121,55,55,0,103,114,101,121,55,56,0,103,114,101,121,55,57,0,103,114,101,121,56,0,103,114,101,121,56,48,0,103,114,101,121,56,49,0,103,114,101,121,56,50,0,103,114,101,121,56,51,0,103,114,101,121,56,52,0,103,114,101,121,56,53,0,103,114,101,121,56,54,0,103,114,101,121,56,55,0,103,114,101,121,56,56,0,103,114,101,121,56,57,0,103,114,101,121,57,0,103,114,101,121,57,48,0,103,114,101,121,57,49,0,103,114,101,121,57,50,0,103,114,101,121,57,51,0,103,114,101,121,57,52,0,103,114,101,121,57,53,0,103,114,101,121,57,54,0,103,114,101,121,57,55,0,103,114,101,121,57,56,0,103,114,101,121,57,57,0,104,111,110,101,121,100,101,119,0,104,111,110,101,121,100,101,119,49,0,104,111,110,101,121,100,101,119,50,0,104,111,110,101,121,100,101,119,51,0,104,111,110,101,121,100,101,119,52,0,104,111,116,112,105,110,107,0,104,111,116,112,105,110,107,49,0,104,111,116,112,105,110,107,50,0,104,111,116,112,105,110,107,51,0,104,111,116,112,105,110,107,52,0,105,110,100,105,97,110,114,101,100,0,105,110,100,105,97,110,114,101,100,49,0,105,110,100,105,97,110,114,101,100,50,0,105,110,100,105,97,110,114,101,100,51,0,105,110,100,105,97,110,114,101,100,52,0,105,110,100,105,103,111,0,105,110,118,105,115,0,105,118,111,114,121,0,105,118,111,114,121,49,0,105,118,111,114,121,50,0,105,118,111,114,121,51,0,105,118,111,114,121,52,0,107,104,97,107,105,0,107,104,97,107,105,49,0,107,104,97,107,105,50,0,107,104,97,107,105,51,0,107,104,97,107,105,52,0,108,97,118,101,110,100,101,114,0,108,97,118,101,110,100,101,114,98,108,117,115,104,0,108,97,118,101,110,100,101,114,98,108,117,115,104,49,0,108,97,118,101,110,100,101,114,98,108,117,115,104,50,0,108,97,118,101,110,100,101,114,98,108,117,115,104,51,0,108,97,118,101,110,100,101,114,98,108,117,115,104,52,0,108,97,119,110,103,114,101,101,110,0,108,101,109,111,110,99,104,105,102,102,111,110,0,108,101,109,111,110,99,104,105,102,102,111,110,49,0,108,101,109,111,110,99,104,105,102,102,111,110,50,0,108,101,109,111,110,99,104,105,102,102,111,110,51,0,108,101,109,111,110,99,104,105,102,102,111,110,52,0,108,105,103,104,116,98,108,117,101,0,108,105,103,104,116,98,108,117,101,49,0,108,105,103,104,116,98,108,117,101,50,0,108,105,103,104,116,98,108,117,101,51,0,108,105,103,104,116,98,108,117,101,52,0,108,105,103,104,116,99,111,114,97,108,0,108,105,103,104,116,99,121,97,110,0,108,105,103,104,116,99,121,97,110,49,0,108,105,103,104,116,99,121,97,110,50,0,108,105,103,104,116,99,121,97,110,51,0,108,105,103,104,116,99,121,97,110,52,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,49,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,50,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,51,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,52,0,108,105,103,104,116,103,111,108,100,101,110,114,111,100,121,101,108,108,111,119,0,108,105,103,104,116,103,114,97,121,0,108,105,103,104,116,103,114,101,121,0,108,105,103,104,116,112,105,110,107,0,108,105,103,104,116,112,105,110,107,49,0,108,105,103,104,116,112,105,110,107,50,0,108,105,103,104,116,112,105,110,107,51,0,108,105,103,104,116,112,105,110,107,52,0,108,105,103,104,116,115,97,108,109,111,110,0,108,105,103,104,116,115,97,108,109,111,110,49,0,108,105,103,104,116,115,97,108,109,111,110,50,0,108,105,103,104,116,115,97,108,109,111,110,51,0,108,105,103,104,116,115,97,108,109,111,110,52,0,108,105,103,104,116,115,101,97,103,114,101,101,110,0,108,105,103,104,116,115,107,121,98,108,117,101,0,108,105,103,104,116,115,107,121,98,108,117,101,49,0,108,105,103,104,116,115,107,121,98,108,117,101,50,0,108,105,103,104,116,115,107,121,98,108,117,101,51,0,108,105,103,104,116,115,107,121,98,108,117,101,52,0,108,105,103,104,116,115,108,97,116,101,98,108,117,101,0,108,105,103,104,116,115,108,97,116,101,103,114,97,121,0,108,105,103,104,116,115,108,97,116,101,103,114,101,121,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,49,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,50,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,51,0,108,105,103,104,116,115,116,101,101,108,98,108,117,101,52,0,108,105,103,104,116,121,101,108,108,111,119,0,108,105,103,104,116,121,101,108,108,111,119,49,0,108,105,103,104,116,121,101,108,108,111,119,50,0,108,105,103,104,116,121,101,108,108,111,119,51,0,108,105,103,104,116,121,101,108,108,111,119,52,0,108,105,109,101,103,114,101,101,110,0,108,105,110,101,110,0,109,97,103,101,110,116,97,0,109,97,103,101,110,116,97,49,0,109,97,103,101,110,116,97,50,0,109,97,103,101,110,116,97,51,0,109,97,103,101,110,116,97,52,0,109,97,114,111,111,110,0,109,97,114,111,111,110,49,0,109,97,114,111,111,110,50,0,109,97,114,111,111,110,51,0,109,97,114,111,111,110,52,0,109,101,100,105,117,109,97,113,117,97,109,97,114,105,110,101,0,109,101,100,105,117,109,98,108,117,101,0,109,101,100,105,117,109,111,114,99,104,105,100,0,109,101,100,105,117,109,111,114,99,104,105,100,49,0,109,101,100,105,117,109,111,114,99,104,105,100,50,0,109,101,100,105,117,109,111,114,99,104,105,100,51,0,109,101,100,105,117,109,111,114,99,104,105,100,52,0,109,101,100,105,117,109,112,117,114,112,108,101,0,109,101,100,105,117,109,112,117,114,112,108,101,49,0,109,101,100,105,117,109,112,117,114,112,108,101,50,0,109,101,100,105,117,109,112,117,114,112,108,101,51,0,109,101,100,105,117,109,112,117,114,112,108,101,52,0,109,101,100,105,117,109,115,101,97,103,114,101,101,110,0,109,101,100,105,117,109,115,108,97,116,101,98,108,117,101,0,109,101,100,105,117,109,115,112,114,105,110,103,103,114,101,101,110,0,109,101,100,105,117,109,116,117,114,113,117,111,105,115,101,0,109,101,100,105,117,109,118,105,111,108,101,116,114,101,100,0,109,105,100,110,105,103,104,116,98,108,117,101,0,109,105,110,116,99,114,101,97,109,0,109,105,115,116,121,114,111,115,101,0,109,105,115,116,121,114,111,115,101,49,0,109,105,115,116,121,114,111,115,101,50,0,109,105,115,116,121,114,111,115,101,51,0,109,105,115,116,121,114,111,115,101,52,0,109,111,99,99,97,115,105,110,0,110,97,118,97,106,111,119,104,105,116,101,0,110,97,118,97,106,111,119,104,105,116,101,49,0,110,97,118,97,106,111,119,104,105,116,101,50,0,110,97,118,97,106,111,119,104,105,116,101,51,0,110,97,118,97,106,111,119,104,105,116,101,52,0,110,97,118,121,0,110,97,118,121,98,108,117,101,0,110,111,110,101,0,111,108,100,108,97,99,101,0,111,108,105,118,101,100,114,97,98,0,111,108,105,118,101,100,114,97,98,49,0,111,108,105,118,101,100,114,97,98,50,0,111,108,105,118,101,100,114,97,98,51,0,111,108,105,118,101,100,114,97,98,52,0,111,114,97,110,103,101,0,111,114,97,110,103,101,49,0,111,114,97,110,103,101,50,0,111,114,97,110,103,101,51,0,111,114,97,110,103,101,52,0,111,114,97,110,103,101,114,101,100,0,111,114,97,110,103,101,114,101,100,49,0,111,114,97,110,103,101,114,101,100,50,0,111,114,97,110,103,101,114,101,100,51,0,111,114,97,110,103,101,114,101,100,52,0,111,114,99,104,105,100,0,111,114,99,104,105,100,49,0,111,114,99,104,105,100,50,0,111,114,99,104,105,100,51,0,111,114,99,104,105,100,52,0,112,97,108,101,103,111,108,100,101,110,114,111,100,0,112,97,108,101,103,114,101,101,110,0,112,97,108,101,103,114,101,101,110,49,0,112,97,108,101,103,114,101,101,110,50,0,112,97,108,101,103,114,101,101,110,51,0,112,97,108,101,103,114,101,101,110,52,0,112,97,108,101,116,117,114,113,117,111,105,115,101,0,112,97,108,101,116,117,114,113,117,111,105,115,101,49,0,112,97,108,101,116,117,114,113,117,111,105,115,101,50,0,112,97,108,101,116,117,114,113,117,111,105,115,101,51,0,112,97,108,101,116,117,114,113,117,111,105,115,101,52,0,112,97,108,101,118,105,111,108,101,116,114,101,100,0,112,97,108],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+163422);allocate([101,118,105,111,108,101,116,114,101,100,49,0,112,97,108,101,118,105,111,108,101,116,114,101,100,50,0,112,97,108,101,118,105,111,108,101,116,114,101,100,51,0,112,97,108,101,118,105,111,108,101,116,114,101,100,52,0,112,97,112,97,121,97,119,104,105,112,0,112,101,97,99,104,112,117,102,102,0,112,101,97,99,104,112,117,102,102,49,0,112,101,97,99,104,112,117,102,102,50,0,112,101,97,99,104,112,117,102,102,51,0,112,101,97,99,104,112,117,102,102,52,0,112,101,114,117,0,112,105,110,107,0,112,105,110,107,49,0,112,105,110,107,50,0,112,105,110,107,51,0,112,105,110,107,52,0,112,108,117,109,0,112,108,117,109,49,0,112,108,117,109,50,0,112,108,117,109,51,0,112,108,117,109,52,0,112,111,119,100,101,114,98,108,117,101,0,112,117,114,112,108,101,0,112,117,114,112,108,101,49,0,112,117,114,112,108,101,50,0,112,117,114,112,108,101,51,0,112,117,114,112,108,101,52,0,114,101,100,0,114,101,100,49,0,114,101,100,50,0,114,101,100,51,0,114,101,100,52,0,114,111,115,121,98,114,111,119,110,0,114,111,115,121,98,114,111,119,110,49,0,114,111,115,121,98,114,111,119,110,50,0,114,111,115,121,98,114,111,119,110,51,0,114,111,115,121,98,114,111,119,110,52,0,114,111,121,97,108,98,108,117,101,0,114,111,121,97,108,98,108,117,101,49,0,114,111,121,97,108,98,108,117,101,50,0,114,111,121,97,108,98,108,117,101,51,0,114,111,121,97,108,98,108,117,101,52,0,115,97,100,100,108,101,98,114,111,119,110,0,115,97,108,109,111,110,0,115,97,108,109,111,110,49,0,115,97,108,109,111,110,50,0,115,97,108,109,111,110,51,0,115,97,108,109,111,110,52,0,115,97,110,100,121,98,114,111,119,110,0,115,101,97,103,114,101,101,110,0,115,101,97,103,114,101,101,110,49,0,115,101,97,103,114,101,101,110,50,0,115,101,97,103,114,101,101,110,51,0,115,101,97,103,114,101,101,110,52,0,115,101,97,115,104,101,108,108,0,115,101,97,115,104,101,108,108,49,0,115,101,97,115,104,101,108,108,50,0,115,101,97,115,104,101,108,108,51,0,115,101,97,115,104,101,108,108,52,0,115,105,101,110,110,97,0,115,105,101,110,110,97,49,0,115,105,101,110,110,97,50,0,115,105,101,110,110,97,51,0,115,105,101,110,110,97,52,0,115,107,121,98,108,117,101,0,115,107,121,98,108,117,101,49,0,115,107,121,98,108,117,101,50,0,115,107,121,98,108,117,101,51,0,115,107,121,98,108,117,101,52,0,115,108,97,116,101,98,108,117,101,0,115,108,97,116,101,98,108,117,101,49,0,115,108,97,116,101,98,108,117,101,50,0,115,108,97,116,101,98,108,117,101,51,0,115,108,97,116,101,98,108,117,101,52,0,115,108,97,116,101,103,114,97,121,0,115,108,97,116,101,103,114,97,121,49,0,115,108,97,116,101,103,114,97,121,50,0,115,108,97,116,101,103,114,97,121,51,0,115,108,97,116,101,103,114,97,121,52,0,115,108,97,116,101,103,114,101,121,0,115,110,111,119,0,115,110,111,119,49,0,115,110,111,119,50,0,115,110,111,119,51,0,115,110,111,119,52,0,115,112,114,105,110,103,103,114,101,101,110,0,115,112,114,105,110,103,103,114,101,101,110,49,0,115,112,114,105,110,103,103,114,101,101,110,50,0,115,112,114,105,110,103,103,114,101,101,110,51,0,115,112,114,105,110,103,103,114,101,101,110,52,0,115,116,101,101,108,98,108,117,101,0,115,116,101,101,108,98,108,117,101,49,0,115,116,101,101,108,98,108,117,101,50,0,115,116,101,101,108,98,108,117,101,51,0,115,116,101,101,108,98,108,117,101,52,0,116,97,110,0,116,97,110,49,0,116,97,110,50,0,116,97,110,51,0,116,97,110,52,0,116,104,105,115,116,108,101,0,116,104,105,115,116,108,101,49,0,116,104,105,115,116,108,101,50,0,116,104,105,115,116,108,101,51,0,116,104,105,115,116,108,101,52,0,116,111,109,97,116,111,0,116,111,109,97,116,111,49,0,116,111,109,97,116,111,50,0,116,111,109,97,116,111,51,0,116,111,109,97,116,111,52,0,116,117,114,113,117,111,105,115,101,0,116,117,114,113,117,111,105,115,101,49,0,116,117,114,113,117,111,105,115,101,50,0,116,117,114,113,117,111,105,115,101,51,0,116,117,114,113,117,111,105,115,101,52,0,118,105,111,108,101,116,0,118,105,111,108,101,116,114,101,100,0,118,105,111,108,101,116,114,101,100,49,0,118,105,111,108,101,116,114,101,100,50,0,118,105,111,108,101,116,114,101,100,51,0,118,105,111,108,101,116,114,101,100,52,0,119,104,101,97,116,0,119,104,101,97,116,49,0,119,104,101,97,116,50,0,119,104,101,97,116,51,0,119,104,101,97,116,52,0,119,104,105,116,101,0,119,104,105,116,101,115,109,111,107,101,0,121,101,108,108,111,119,0,121,101,108,108,111,119,49,0,121,101,108,108,111,119,50,0,121,101,108,108,111,119,51,0,121,101,108,108,111,119,52,0,121,101,108,108,111,119,103,114,101,101,110,0,108,97,99,107,0,104,105,116,101,0,105,103,104,116,103,114,101,121,0,88,49,49,47,0,47,37,115,47,37,115,0,105,109,97,103,101,115,99,97,108,101,0,102,97,108,115,101,0,98,108,97,99,107,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,100,0,65,103,110,111,100,101,105,110,102,111,95,116,0,114,111,119,103,0,99,111,108,103,0,65,103,114,97,112,104,105,110,102,111,95,116,0,100,101,108,120,32,62,61,32,48,0,104,116,109,108,116,97,98,108,101,46,99,0,112,111,115,95,104,116,109,108,95,116,98,108,0,100,101,108,121,32,62,61,32,48,0,116,97,98,108,101,32,115,105,122,101,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,99,111,110,116,101,110,116,10,0,102,105,120,101,100,32,116,97,98,108,101,32,115,105,122,101,32,119,105,116,104,32,117,110,115,112,101,99,105,102,105,101,100,32,119,105,100,116,104,32,111,114,32,104,101,105,103,104,116,10,0,99,101,108,108,32,115,105,122,101,32,116,111,111,32,115,109,97,108,108,32,102,111,114,32,99,111,110,116,101,110,116,10,0,102,105,120,101,100,32,99,101,108,108,32,115,105,122,101,32,119,105,116,104,32,117,110,115,112,101,99,105,102,105,101,100,32,119,105,100,116,104,32,111,114,32,104,101,105,103,104,116,10,0,78,111,32,111,114,32,105,109,112,114,111,112,101,114,32,105,109,97,103,101,32,102,105,108,101,61,34,37,115,34,10,0,112,101,110,99,111,108,111,114,0,45,62,0,65,103,101,100,103,101,105,110,102,111,95,116,0,49,0,50,0,51,0,52,0,53,0,54,0,55,0,56,0,57,0,49,48,0,49,49,0,49,50,0,49,51,0,49,52,0,49,53,0,49,54,0,49,55,0,49,56,0,49,57,0,50,48,0,100,97,115,104,101,100,0,100,111,116,116,101,100,0,99,112,45,62,115,114,99,0,101,109,105,116,95,104,116,109,108,95,105,109,103,0,99,112,45,62,115,114,99,91,48,93,0,116,114,97,110,115,112,97,114,101,110,116,0,95,37,100,0,102,80,81,46,99,0,80,81,99,104,101,99,107,0,72,101,97,112,32,111,118,101,114,102,108,111,119,10,0,37,33,80,83,45,65,100,111,98,101,45,50,46,48,10,47,110,111,100,101,32,123,10,32,32,47,89,32,101,120,99,104,32,100,101,102,10,32,32,47,88,32,101,120,99,104,32,100,101,102,10,32,32,47,121,32,101,120,99,104,32,100,101,102,10,32,32,47,120,32,101,120,99,104,32,100,101,102,10,32,32,110,101,119,112,97,116,104,10,32,32,120,32,121,32,109,111,118,101,116,111,10,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,99,108,111,115,101,112,97,116,104,32,102,105,108,108,10,125,32,100,101,102,10,47,99,101,108,108,32,123,10,32,32,47,89,32,101,120,99,104,32,100,101,102,10,32,32,47,88,32,101,120,99,104,32,100,101,102,10,32,32,47,121,32,101,120,99,104,32,100,101,102,10,32,32,47,120,32,101,120,99,104,32,100,101,102,10,32,32,110,101,119,112,97,116,104,10,32,32,120,32,121,32,109,111,118,101,116,111,10,32,32,120,32,89,32,108,105,110,101,116,111,10,32,32,88,32,89,32,108,105,110,101,116,111,10,32,32,88,32,121,32,108,105,110,101,116,111,10,32,32,99,108,111,115,101,112,97,116,104,32,115,116,114,111,107,101,10,125,32,100,101,102,10,0,115,104,111,119,112,97,103,101,10,0,102,97,105,108,101,100,32,97,116,32,110,111,100,101,32,37,100,91,48,93,10,0,110,112,45,62,99,101,108,108,115,91,48,93,0,109,97,122,101,46,99,0,99,104,107,83,103,114,97,112,104,0,102,97,105,108,101,100,32,97,116,32,110,111,100,101,32,37,100,91,49,93,10,0,110,112,45,62,99,101,108,108,115,91,49,93,0,100,105,116,101,109,115,0,102,105,110,100,83,86,101,114,116,0,37,37,37,37,80,97,103,101,58,32,49,32,49,10,37,37,37,37,80,97,103,101,66,111,117,110,100,105,110,103,66,111,120,58,32,37,100,32,37,100,32,37,100,32,37,100,10,0,37,102,32,37,102,32,116,114,97,110,115,108,97,116,101,10,0,48,32,48,32,49,32,115,101,116,114,103,98,99,111,108,111,114,10,0,37,102,32,37,102,32,37,102,32,37,102,32,110,111,100,101,10,0,48,32,48,32,48,32,115,101,116,114,103,98,99,111,108,111,114,10,0,37,102,32,37,102,32,37,102,32,37,102,32,99,101,108,108,10,0,49,32,48,32,48,32,115,101,116,114,103,98,99,111,108,111,114,10,0,117,110,101,120,112,101,99,116,101,100,32,99,97,115,101,32,105,110,32,108,111,99,97,116,101,95,101,110,100,112,111,105,110,116,10,0,48,0,116,114,97,112,101,122,111,105,100,46,99,0,108,111,99,97,116,101,95,101,110,100,112,111,105,110,116,0,97,100,100,95,115,101,103,109,101,110,116,58,32,101,114,114,111,114,10,0,110,101,119,110,111,100,101,58,32,81,117,101,114,121,45,116,97,98,108,101,32,111,118,101,114,102,108,111,119,10,0,110,101,119,110,111,100,101,0,110,101,119,116,114,97,112,58,32,84,114,97,112,101,122,111,105,100,45,116,97,98,108,101,32,111,118,101,114,102,108,111,119,32,37,100,10,0,110,101,119,116,114,97,112,0,105,110,100,101,120,46,99,0,82,84,114,101,101,83,101,97,114,99,104,0,110,45,62,108,101,118,101,108,32,62,61,32,48,0,82,84,114,101,101,73,110,115,101,114,116,0,108,101,118,101,108,32,62,61,32,48,32,38,38,32,108,101,118,101,108,32,60,61,32,40,42,110,41,45,62,108,101,118,101,108,0,114,45,62,98,111,117,110,100,97,114,121,91,105,93,32,60,61,32,114,45,62,98,111,117,110,100,97,114,121,91,78,85,77,68,73,77,83,32,43,32,105,93,0,114,32,38,38,32,110,32,38,38,32,110,101,119,0,82,84,114,101,101,73,110,115,101,114,116,50,0,108,101,118,101,108,32,62,61,32,48,32,38,38,32,108,101,118,101,108,32,60,61,32,110,45,62,108,101,118,101,108,0,70,65,76,83,69,0,110,111,100,101,46,99,0,78,111,100,101,67,111,118,101,114,0,114,32,38,38,32,110,0,80,105,99,107,66,114,97,110,99,104,0,65,100,100,66,114,97,110,99,104,0,105,32,60,32,78,79,68,69,67,65,82,68,0,110,101,119,0,110,32,38,38,32,105,32,62,61,32,48,32,38,38,32,105,32,60,32,78,79,68,69,67,65,82,68,0,68,105,115,99,111,110,66,114,97,110,99,104,0,114,0,114,101,99,116,97,110,103,108,101,46,99,0,82,101,99,116,65,114,101,97,0,108,97,98,101,108,58,32,97,114,101,97,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,114,116,114,101,101,10,0,114,32,38,38,32,114,114,0,67,111,109,98,105,110,101,82,101,99,116,0,114,32,38,38,32,115,0,79,118,101,114,108,97,112,0,110,0,115,112,108,105,116,46,113,46,99,0,83,112,108,105,116,78,111,100,101,0,98,0,110,45,62,99,111,117,110,116,32,43,32,40,42,110,110,41,45,62,99,111,117,110,116,32,61,61,32,78,79,68,69,67,65,82,68,32,43,32,49,0,76,111,97,100,78,111,100,101,115,0,113,0,112,0,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,112,97,114,116,105,116,105,111,110,91,105,93,32,61,61,32,48,32,124,124,32,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,112,97,114,116,105,116,105,111,110,91,105,93,32,61,61,32,49,0,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,99,111,117,110,116,91,48,93,32,43,32,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,99,111,117,110,116,91,49,93,32,61,61,32,78,79,68,69,67,65,82,68,32,43,32,49,0,77,101,116,104,111,100,90,101,114,111,0,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,99,111,117,110,116,91,48,93,32,62,61,32,114,116,112,45,62,77,105,110,70,105,108,108,32,38,38,32,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,99,111,117,110,116,91,49,93,32,62,61,32,114,116,112,45,62,77,105,110,70,105,108,108,0,33,114,116,112,45,62,115,112,108,105,116,46,80,97,114,116,105,116,105,111,110,115,91,48,93,46,116,97,107,101,110,91,105,93,0,67,108,97,115,115,105,102,121,0,71,101,116,66,114,97,110,99,104,101,115,0,110,45,62,98,114,97,110,99,104,91,105,93,46,99,104,105,108,100,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,2,2,2,2,2,2,16,12,89,1,0,31,80,8,3,7,18,19,20,87,22,23,8,11,105,12,31,10,5,12,14,41,17,43,15,45,16,47,48,32,50,6,52,53,27,28,29,30,11,12,33,34,35,36,37,38,39,40,12,24,25,23,4,10,27,28,26,32,42,10,33,34,35,36,37,38,39,40,12,10,14,83,10,44,88,49,88,88,88,88,88,88,12,27,28,15,46,88,51,33,34,35,36,37,38,39,40,27,28,255,83,255,255,33,34,35,36,37,38,39,40,12,255,255,5,255,255,255,9,20,255,255,255,255,255,12,27,28,255,16,21,22,33,34,35,36,37,38,39,40,27,28,255,255,255,255,33,34,35,36,37,38,39,40,12,255,18,19,20,17,22,23,255,255,255,255,255,255,12,27,28,255,255,255,18,33,34,35,36,37,38,39,40,27,28,255,255,255,255,33,34,35,36,37,38,39,40,12,255,255,255,255,255,255,19,255,255,255,255,255,255,12,27,28,255,255,255,255,33,34,35,36,37,38,39,40,27,28,255,255,255,255,33,34,35,36,37,38,39,40,18,19,20,21,22,23,24,25,255,255,255,255,255,255,255,255,255,35,36,37,38,39,27,18,19,20,22,23,34,54,104,1,31,56,86,33,32,2,27,27,27,94,27,27,55,57,112,54,210,194,79,4,60,34,71,34,63,34,68,34,34,88,34,101,34,34,5,6,95,96,57,4,7,8,9,10,11,12,13,14,4,102,103,93,106,109,5,6,111,88,59,113,7,8,9,10,11,12,13,14,4,114,60,91,115,62,97,70,27,18,19,20,22,23,4,5,6,63,65,98,73,7,8,9,10,11,12,13,14,5,6,0,92,0,0,7,8,9,10,11,12,13,14,4,0,0,79,0,0,0,83,66,0,0,0,0,0,4,5,6,0,68,84,85,7,8,9,10,11,12,13,14,5,6,0,0,0,0,7,8,9,10,11,12,13,14,4,0,42,44,46,71,49,51,0,0,0,0,0,0,4,5,6,0,0,0,74,7,8,9,10,11,12,13,14,5,6,0,0,0,0,7,8,9,10,11,12,13,14,4,0,0,0,0,0,0,76,0,0,0,0,0,0,4,5,6,0,0,0,0,7,8,9,10,11,12,13,14,5,6,0,0,0,0,7,8,9,10,11,12,13,14,41,43,45,47,48,50,52,53,0,0,0,0,0,0,0,0,0,41,43,45,48,50,0,4,47,0,36,35,0,18,20,22,26,28,30,32,24,0,5,7,47,47,47,0,47,47,0,0,9,8,40,0,0,1,34,2,6,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,37,3,38,19,10,41,21,11,42,23,14,45,25,17,27,12,43,29,13,44,31,15,33,16,0,51,0,48,0,47,67,0,49,0,47,0,53,46,39,66,50,65,0,58,56,0,60,52,69,0,54,0,64,0,0,63,0,68,55,59,57,61,0,2,3,3,1,1,2,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,0,6,1,3,3,3,3,3,1,0,1,2,3,0,4,1,2,3,0,4,0,4,0,4,0,3,2,1,2,1,2,1,83,121,110,116,97,120,32,101,114,114,111,114,58,32,110,111,110,45,115,112,97,99,101,32,115,116,114,105,110,103,32,117,115,101,100,32,98,101,102,111,114,101,32,60,84,65,66,76,69,62,0,83,121,110,116,97,120,32,101,114,114,111,114,58,32,110,111,110,45,115,112,97,99,101,32,115,116,114,105,110,103,32,117,115,101,100,32,97,102,116,101,114,32,60,47,84,65,66,76,69,62,0,0,41,42,42,42,43,44,44,45,45,45,45,45,45,45,45,45,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,62,63,63,65,64,66,66,66,66,66,66,67,67,68,68,68,70,69,71,71,71,73,72,74,72,75,72,76,72,77,77,78,78,79,79,255,3,15,16,17,35,58,36,61,37,64,21,67,38,69,39,72,24,75,25,77,26,40,28,78,29,30,80,81,82,89,90,108,107,110,99,100,87,105,69,114,114,111,114,58,32,100,105,115,99,97,114,100,105,110,103,0,0,1,7,42,12,27,28,33,34,35,36,37,38,39,40,43,44,45,46,48,50,52,54,56,58,60,62,63,64,66,67,0,3,8,45,46,48,50,54,56,63,44,64,44,64,44,64,44,44,64,44,64,44,44,12,8,31,11,47,47,14,49,49,15,51,51,20,53,16,55,55,17,57,57,18,59,19,61,65,5,68,69,70,9,21,22,69,78,32,71,72,63,67,23,69,29,30,43,66,76,77,6,24,25,72,79,4,74,73,10,75,26,72,10,10,10,69,114,114,111,114,58,32,112,111,112,112,105,110,103,0,109,101,109,111,114,121,32,101,120,104,97,117,115,116,101,100,0,67,108,101,97,110,117,112,58,32,100,105,115,99,97,114,100,105,110,103,32,108,111,111,107,97,104,101,97,100,0,67,108,101,97,110,117,112,58,32,112,111,112,112,105,110,103,0,68,101,108,101,116,105,110,103,0,0,37,115,32,105,110,32,108,105,110,101,32,37,100,32,10,0,45,45,0,76,97,98,101,108,32,99,108,111,115,101,100,32,98,101,102,111,114,101,32,101,110,100,32,111,102,32,72,84,77,76,32,101,108,101,109,101,110,116,10,0,85,110,99,108,111,115,101,100,32,99,111,109,109,101,110,116,10,0,60,47,72,84,77,76,62,0,60,72,84,77,76,62,0,84,65,66,76,69,0,84,82,0,84,72,0,84,68,0,72,84,77,76,0,70,79,78,84,0,66,0,85,0,79,0,73,0,83,85,80,0,83,85,66,0,83,0,66,82,0,72,82,0,86,82,0,73,77,71,0,85,110,107,110,111,119,110,32,72,84,77,76,32,101,108,101,109,101,110,116,32,60,37,115,62,32,111,110,32,108,105,110,101,32,37,100,32,10,0,60,73,77,71,62,0,73,108,108,101,103,97,108,32,97,116,116,114,105,98,117,116,101,32,37,115,32,105,110,32,37,115,32,45,32,105,103,110,111,114,101,100,10,0,115,99,97,108,101,0,115,114,99,0,60,66,82,62,0,97,108,105,103,110,0,73,71,72,84,0,69,70,84,0,69,78,84,69,82,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,65,76,73,71,78,32,45,32,105,103,110,111,114,101,100,10,0,60,70,79,78,84,62,0,99,111,108,111,114,0,102,97,99,101,0,112,111,105,110,116,45,115,105,122,101,0,80,79,73,78,84,45,83,73,90,69,0,73,109,112,114,111,112,101,114,32,37,115,32,118,97,108,117,101,32,37,115,32,45,32,105,103,110,111,114,101,100,0,37,115,32,118,97,108,117,101,32,37,115,32,62,32,37,100,32,45,32,116,111,111,32,108,97,114,103,101,32,45,32,105,103,110,111,114,101,100,0,37,115,32,118,97,108,117,101,32,37,115,32,60,32,37,100,32,45,32,116,111,111,32,115,109,97,108,108,32,45,32,105,103,110,111,114,101,100,0,60,84,68,62,0,98,97,108,105,103,110,0,98,103,99,111,108,111,114,0,98,111,114,100,101,114,0,99,101,108,108,112,97,100,100,105,110,103,0,99,101,108,108,115,112,97,99,105,110,103,0,99,111,108,115,112,97,110,0,102,105,120,101,100,115,105,122,101,0,103,114,97,100,105,101,110,116,97,110,103,108,101,0,104,101,105,103,104,116,0,104,114,101,102,0,105,100,0,112,111,114,116,0,114,111,119,115,112,97,110,0,115,105,100,101,115,0,115,116,121,108,101,0,116,97,114,103,101,116,0,116,105,116,108,101,0,116,111,111,108,116,105,112,0,118,97,108,105,103,110,0,119,105,100,116,104,0,87,73,68,84,72,0,79,84,84,79,77,0,79,80,0,73,68,68,76,69,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,86,65,76,73,71,78,32,45,32,105,103,110,111,114,101,100,10,0,32,44,0,79,85,78,68,69,68,0,65,68,73,65,76,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,83,84,89,76,69,32,45,32,105,103,110,111,114,101,100,10,0,83,79,76,73,68,0,73,78,86,73,83,73,66,76,69,0,73,78,86,73,83,0,68,79,84,84,69,68,0,68,65,83,72,69,68,0,85,110,114,101,99,111,103,110,105,122,101,100,32,99,104,97,114,97,99,116,101,114,32,39,37,99,39,32,40,37,100,41,32,105,110,32,115,105,100,101,115,32,97,116,116,114,105,98,117,116,101,10,0,82,79,87,83,80,65,78,0,82,79,87,83,80,65,78,32,118,97,108,117,101,32,99,97,110,110,111,116,32,98,101,32,48,32,45,32,105,103,110,111,114,101,100,10,0,72,69,73,71,72,84,0,71,82,65,68,73,69,78,84,65,78,71,76,69,0,82,85,69,0,65,76,83,69,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,70,73,88,69,68,83,73,90,69,32,45,32,105,103,110,111,114,101,100,10,0,67,79,76,83,80,65,78,0,67,79,76,83,80,65,78,32,118,97,108,117,101,32,99,97,110,110,111,116,32,98,101,32,48,32,45,32,105,103,110,111,114,101,100,10,0,67,69,76,76,83,80,65,67,73,78,71,0,67,69,76,76,80,65,68,68,73,78,71,0,66,79,82,68,69,82,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,66,65,76,73,71,78,32,105,110,32,84,68,32,45,32,105,103,110,111,114,101,100,10,0,69,88,84,0,73,108,108,101,103,97,108,32,118,97,108,117,101,32,37,115,32,102,111,114,32,65,76,73,71,78,32,105,110,32,84,68,32,45,32,105,103,110,111,114,101,100,10,0,60,84,65,66,76,69,62,0,99,101,108,108,98,111,114,100,101,114,0,99,111,108,117,109,110,115,0,114,111,119,115,0,85,110,107,110,111,119,110,32,118,97,108,117,101,32,37,115,32,102,111,114,32,82,79,87,83,32,45,32,105,103,110,111,114,101,100,10,0,85,110,107,110,111,119,110,32,118,97,108,117,101,32,37,115,32,102,111,114,32,67,79,76,85,77,78,83,32,45,32,105,103,110,111,114,101,100,10,0,67,69,76,76,83,66,79,82,68,69,82,0,46,46,46,32,37,115,32,46,46,46,10,0,106,32,61,61,32,48,0,99,118,116,46,99,0,80,111,98,115,112,97,116,104,0,114,111,117,116,101,46,99,0,108,105,98,112,97,116,104,47,37,115,58,37,100,58,32,37,115,10,0,115,104,111,114,116,101,115,116,46,99,0,115,111,117,114,99,101,32,112,111,105,110,116,32,110,111,116,32,105,110,32,97,110,121,32,116,114,105,97,110,103,108,101,0,100,101,115,116,105,110,97,116,105,111,110,32,112,111,105,110,116,32,110,111,116,32,105,110,32,97,110,121,32,116,114,105,97,110,103,108,101,0,99,97,110,110,111,116,32,102,105,110,100,32,116,114,105,97,110,103,108,101,32,112,97,116,104,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,111,112,115,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,111,112,115,0,116,114,105,97,110,103,117,108,97,116,105,111,110,32,102,97,105,108,101,100,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,116,114,105,115,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,116,114,105,115,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,100,113,46,112,110,108,115,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,100,113,46,112,110,108,115,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,112,110,108,115,0,99,97,110,110,111,116,32,109,97,108,108,111,99,32,112,110,108,112,115,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,112,110,108,115,0,99,97,110,110,111,116,32,114,101,97,108,108,111,99,32,112,110,108,112,115,0,111,117,116,32,111,102,32,109,101,109,111,114,121,0,115,121,110,116,97,120,32,101,114,114,111,114,0,110,111,32,101,108,101,109,101,110,116,32,102,111,117,110,100,0,110,111,116,32,119,101,108,108,45,102,111,114,109,101,100,32,40,105,110,118,97,108,105,100,32,116,111,107,101,110,41,0,117,110,99,108,111,115,101,100,32,116,111,107,101,110,0,112,97,114,116,105,97,108,32,99,104,97,114,97,99,116,101,114,0,109,105,115,109,97,116,99,104,101,100,32,116,97,103,0,100,117,112,108,105,99,97,116,101,32,97,116,116,114,105,98,117,116,101,0,106,117,110,107,32,97,102,116,101,114,32,100,111,99,117,109,101,110,116,32,101,108,101,109,101,110,116,0,105,108,108,101,103,97,108,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,32,114,101,102,101,114,101,110,99,101,0,117,110,100,101,102,105,110,101,100,32,101,110,116,105,116,121,0,114,101,99,117,114,115,105,118,101,32,101,110,116,105,116,121,32,114,101,102,101,114,101,110,99,101,0,97,115,121,110,99,104,114,111,110,111,117,115,32,101,110,116,105,116,121,0,114,101,102,101,114,101,110,99,101,32,116,111,32,105,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,32,110,117,109,98,101,114,0,114,101,102,101,114,101,110,99,101,32,116,111,32,98,105,110,97,114,121,32,101,110,116,105,116,121,0,114,101,102,101,114,101,110,99,101,32,116,111,32,101,120,116,101,114,110,97,108,32,101,110,116,105,116,121,32,105,110,32,97,116,116,114,105,98,117,116,101,0,88,77,76,32,111,114,32,116,101,120,116,32,100,101,99,108,97,114,97,116,105,111,110,32,110,111,116,32,97,116,32,115,116,97,114,116,32,111,102,32,101,110,116,105,116,121,0,117,110,107,110,111,119,110,32,101,110,99,111,100,105,110,103,0,101,110,99,111,100,105,110,103,32,115,112,101,99,105,102,105,101,100,32,105,110,32,88,77,76,32,100,101,99,108,97,114,97,116,105,111,110,32,105,115,32,105,110,99,111,114,114,101,99,116,0,117,110,99,108,111,115,101,100,32,67,68,65,84,65,32,115,101,99,116,105,111,110,0,101,114,114,111,114,32,105,110,32,112,114,111,99,101,115,115,105,110,103,32,101,120,116,101,114,110,97,108,32,101,110,116,105,116,121,32,114,101,102,101,114,101,110,99,101,0,100,111,99,117,109,101,110,116,32,105,115,32,110,111,116,32,115,116,97,110,100,97,108,111,110,101,0,117,110,101,120,112,101,99,116,101,100,32,112,97,114,115,101,114,32,115,116,97,116,101,32,45,32,112,108,101,97,115,101,32,115,101,110,100,32,97,32,98,117,103,32,114,101,112,111,114,116,0,101,110,116,105,116,121,32,100,101,99,108,97,114,101,100,32,105,110,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,0,114,101,113,117,101,115,116,101,100,32,102,101,97,116,117,114,101,32,114,101,113,117,105,114,101,115,32,88,77,76,95,68,84,68,32,115,117,112,112,111,114,116,32,105,110,32,69,120,112,97,116,0,99,97,110,110,111,116,32,99,104,97,110,103,101,32,115,101,116,116,105,110,103,32,111,110,99,101,32,112,97,114,115,105,110,103,32,104,97,115,32,98,101,103,117,110,0,117,110,98,111,117,110,100,32,112,114,101,102,105,120,0,109,117,115,116,32,110,111,116,32,117,110,100,101,99,108,97,114,101,32,112,114,101,102,105,120,0,105,110,99,111,109,112,108,101,116,101,32,109,97,114,107,117,112,32,105,110,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,0,88,77,76,32,100,101,99,108,97,114,97,116,105,111,110,32,110,111,116,32,119,101,108,108,45,102,111,114,109,101,100,0,116,101,120,116,32,100,101,99,108,97,114,97,116,105,111,110,32,110,111,116,32,119,101,108,108,45,102,111,114,109,101,100,0,105,108,108,101,103,97,108,32,99,104,97,114,97,99,116,101,114,40,115,41,32,105,110,32,112,117,98,108,105,99,32,105,100,0,112,97,114,115,101,114,32,115,117,115,112,101,110,100,101,100,0,112,97,114,115,101,114,32,110,111,116,32,115,117,115,112,101,110,100,101,100,0,112,97,114,115,105,110,103,32,97,98,111,114,116,101,100,0,112,97,114,115,105,110,103,32,102,105,110,105,115,104,101,100,0,99,97,110,110,111,116,32,115,117,115,112,101,110,100,32,105,110,32,101,120,116,101,114,110,97,108,32,112,97,114,97,109,101,116,101,114,32,101,110,116,105,116,121,0,114,101,115,101,114,118,101,100,32,112,114,101,102,105,120,32,40,120,109,108,41,32,109,117,115,116,32,110,111,116,32,98,101,32,117,110,100,101,99,108,97,114,101,100,32,111,114,32,98,111,117,110,100,32,116,111,32,97,110,111,116,104,101,114,32,110,97,109,101,115,112,97,99,101,32,110,97,109,101,0,114,101,115,101,114,118,101,100,32,112,114,101,102,105,120,32,40,120,109,108,110,115,41,32,109,117,115,116,32,110,111,116,32,98,101,32,100,101,99,108,97,114,101,100,32,111,114,32,117,110,100,101,99,108,97,114,101,100,0,112,114,101,102,105,120,32,109,117,115,116,32,110,111,116,32,98,101,32,98,111,117,110,100,32,116,111,32,111,110,101,32,111,102,32,116,104,101,32,114,101,115,101,114,118,101,100,32,110,97,109,101,115,112,97,99,101,32,110,97,109,101,115,0,120,109,108,61,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,88,77,76,47,49,57,57,56,47,110,97,109,101,115,112,97,99,101,0,67,68,65,84,65,0,73,68,0,73,68,82,69,70,0,73,68,82,69,70,83,0,69,78,84,73,84,89,0,69,78,84,73,84,73,69,83,0,78,77,84,79,75,69,78,0,78,77,84,79,75,69,78,83,0,124,0,78,79,84,65,84,73,79,78,40,0,40,0,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,88,77,76,47,49,57,57,56,47,110,97,109,101,115,112,97,99,101,0,104,116,116,112,58,47,47,119,119,119,46,119,51,46,111,114,103,47,50,48,48,48,47,120,109,108,110,115,47,0,2,3,4,5,6,7,8,0,0,9,10,11,12,13,14,15,16,17,0,0,0,0,0,0,0,0,0,0,0,0,18,19,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,23,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,3,26,27,28,29,30,0,0,31,32,33,34,35,36,37,16,17,0,0,0,0,0,0,0,0,0,0,0,0,18,19,38,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,23,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,84,70,45,49,54,0,67,68,65,84,65,91,67,68,65,84,65,91,67,68,65,84,65,91,118,101,114,115,105,111,110,0,101,110,99,111,100,105,110,103,0,115,116,97,110,100,97,108,111,110,101,0,85,83,45,65,83,67,73,73,0,85,84,70,45,49,54,66,69,0,85,84,70,45,49,54,76,69,0,69,78,84,73,84,89,0,65,84,84,76,73,83,84,0,69,76,69,77,69,78,84,0,78,79,84,65,84,73,79,78,0,83,89,83,84,69,77,0,80,85,66,76,73,67,0,69,77,80,84,89,0,65,78,89,0,80,67,68,65,84,65,0,73,77,80,76,73,69,68,0,82,69,81,85,73,82,69,68,0,70,73,88,69,68,0,67,68,65,84,65,0,73,68,0,73,68,82,69,70,0,73,68,82,69,70,83,0,69,78,84,73,84,73,69,83,0,78,77,84,79,75,69,78,0,78,77,84,79,75,69,78,83,0,78,68,65,84,65,0,73,78,67,76,85,68,69,0,73,71,78,79,82,69,0,68,79,67,84,89,80,69,0,18,17,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,17,34,35,36,17,37,38,39,40,41,42,43,44,17,45,46,47,16,16,48,16,16,16,16,16,16,16,49,50,51,16,52,53,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,54,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,55,17,17,17,17,56,17,57,58,59,60,61,62,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,63,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,64,65,17,66,67,68,69,70,71,72,73,16,16,16,74,75,76,77,78,16,16,16,79,80,16,16,16,16,81,16,16,16,16,16,16,16,16,16,17,17,17,82,83,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,84,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,85,16,16,16,16,86,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,87,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,88,89,90,91,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,92,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,254,255,255,7,254,255,255,7,0,0,0,0,0,4,32,4,255,255,127,255,255,255,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,195,255,3,0,31,80,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,223,60,64,215,255,255,251,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,254,255,255,255,127,2,254,255,255,255,255,0,0,0,0,0,255,191,182,0,255,255,255,7,7,0,0,0,255,7,255,255,255,255,255,255,255,254,255,195,255,255,255,255,255,255,255,255,255,255,255,255,239,31,254,225,255,159,0,0,255,255,255,255,255,255,0,224,255,255,255,255,255,255,255,255,255,255,255,255,3,0,255,255,255,255,255,7,48,4,255,255,255,252,255,31,0,0,255,255,255,1,0,0,0,0,0,0,0,0,253,31,0,0,0,0,0,0,240,3,255,127,255,255,255,255,255,255,255,239,255,223,225,255,207,255,254,254,238,159,249,255,255,253,197,227,159,89,128,176,207,255,3,0,238,135,249,255,255,253,109,195,135,25,2,94,192,255,63,0,238,191,251,255,255,253,237,227,191,27,1,0,207,255,0,0,238,159,249,255,255,253,237,227,159,25,192,176,207,255,2,0,236,199,61,214,24,199,255,195,199,29,129,0,192,255,0,0,238,223,253,255,255,253,239,227,223,29,96,3,207,255,0,0,236,223,253,255,255,253,239,227,223,29,96,64,207,255,6,0,236,223,253,255,255,255,255,231,223,93,128,0,207,255,0,252,236,255,127,252,255,255,251,47,127,128,95,255,0,0,12,0,254,255,255,255,255,127,255,7,63,32,255,3,0,0,0,0,150,37,240,254,174,236,255,59,95,32,255,243,0,0,0,0,1,0,0,0,255,3,0,0,255,254,255,255,255,31,254,255,3,255,255,254,255,255,255,31,0,0,0,0,0,0,0,0,255,255,255,255,255,255,127,249,255,3,255,255,231,193,255,255,127,64,255,51,255,255,255,255,191,32,255,255,255,255,255,247,255,255,255,255,255,255,255,255,255,61,127,61,255,255,255,255,255,61,255,255,255,255,61,127,61,255,127,255,255,255,255,255,255,255,61,255,255,255,255,255,255,255,255,135,0,0,0,0,255,255,0,0,255,255,255,255,255,255,255,255,255,255,31,0,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,159,255,255,254,255,255,7,255,255,255,255,255,255,255,255,255,199,1,0,255,223,15,0,255,255,15,0,255,255,15,0,255,223,13,0,255,255,255,255,255,255,207,255,255,1,128,16,255,3,0,0,0,0,255,3,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,7,255,255,255,255,255,255,255,255,63,0,255,255,255,31,255,15,255,1,192,255,255,255,255,63,31,0,255,255,255,255,255,15,255,255,255,3,255,3,0,0,0,0,255,255,255,15,255,255,255,255,255,255,255,127,254,255,31,0,255,3,255,3,128,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,239,255,239,15,255,3,0,0,0,0,255,255,255,255,255,243,255,255,255,255,255,255,191,255,3,0,255,255,255,255,255,255,63,0,255,227,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,222,111,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,255,255,63,63,255,255,255,255,63,63,255,170,255,255,255,63,255,255,255,255,255,255,223,95,220,31,207,15,255,31,220,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,128,0,0,255,31,0,0,0,0,0,0,0,0,0,0,0,0,132,252,47,62,80,189,255,243,224,67,0,0,255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,255,255,3,0,0,255,255,255,255,255,127,255,255,255],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+173662);allocate([255,255,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,120,12,0,255,255,255,255,191,32,255,255,255,255,255,255,255,128,0,0,255,255,127,0,127,127,127,127,127,127,127,127,255,255,255,255,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,254,3,62,31,254,255,255,255,255,255,255,255,255,255,127,224,254,255,255,255,255,255,255,255,255,255,255,247,224,255,255,255,255,63,254,255,255,255,255,255,255,255,255,255,255,127,0,0,255,255,255,7,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,0,0,0,0,0,0,255,255,255,255,255,63,255,31,255,255,255,15,0,0,255,255,255,255,255,127,240,143,255,255,255,128,255,255,255,255,255,255,255,255,255,255,0,0,0,0,128,255,252,255,255,255,255,255,255,255,255,255,255,255,255,121,15,0,255,7,0,0,0,0,0,0,0,0,0,255,187,247,255,255,255,0,0,0,255,255,255,255,255,255,15,0,255,255,255,255,255,255,255,255,15,0,255,3,0,0,252,8,255,255,255,255,255,7,255,255,255,255,7,0,255,255,255,31,255,255,255,255,255,255,247,255,0,128,255,3,0,0,0,0,255,255,255,255,255,255,127,0,255,63,255,3,255,255,127,4,255,255,255,255,255,255,255,127,5,0,0,56,255,255,60,0,126,126,126,0,127,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,7,255,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,255,255,127,248,255,255,255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,255,255,63,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,0,127,0,248,224,255,253,127,95,219,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,248,255,255,255,255,255,255,255,255,255,255,255,255,63,0,0,255,255,255,255,255,255,255,255,252,255,255,255,255,255,255,0,0,0,0,0,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,0,0,255,3,254,255,255,7,254,255,255,7,192,255,255,255,255,255,255,255,255,255,255,127,252,252,252,28,0,0,0,0,255,239,255,255,127,255,255,183,255,63,255,63,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,0,0,0,0,0,0,0,0,255,255,255,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,31,255,255,255,255,255,255,1,0,0,0,0,0,255,255,255,127,0,0,255,255,255,7,0,0,0,0,0,0,255,255,255,63,255,255,255,255,15,255,62,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,255,3,0,0,0,0,0,0,0,0,0,0,63,253,255,255,255,255,191,145,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,63,0,255,255,255,3,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,111,240,239,254,255,255,15,0,0,0,0,0,255,255,255,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,63,0,255,255,63,0,255,255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,63,0,0,0,192,255,0,0,252,255,255,255,255,255,255,1,0,0,255,255,255,1,255,3,255,255,255,255,255,255,199,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,30,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,63,0,255,3,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,31,0,255,255,255,255,255,127,0,0,248,255,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,255,255,255,223,100,222,255,235,239,255,255,255,255,255,255,255,191,231,223,223,255,255,255,123,95,252,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,255,255,255,253,255,255,247,255,255,255,247,255,255,223,255,255,255,223,255,255,127,255,255,255,127,255,255,255,253,255,255,255,253,255,255,247,207,255,255,255,255,255,255,239,255,255,255,150,254,247,10,132,234,150,170,150,247,247,94,255,251,255,15,238,251,255,15,0,0,0,0,0,0,0,0,97,108,110,117,109,0,97,108,112,104,97,0,98,108,97,110,107,0,99,110,116,114,108,0,100,105,103,105,116,0,103,114,97,112,104,0,108,111,119,101,114,0,112,114,105,110,116,0,112,117,110,99,116,0,115,112,97,99,101,0,117,112,112,101,114,0,120,100,105,103,105,116,0,18,16,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,16,16,34,35,16,36,37,38,39,40,41,42,43,16,44,45,46,17,47,48,17,17,49,17,17,17,50,51,52,53,54,55,56,57,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,58,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,59,16,60,61,62,63,64,65,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,66,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,67,16,16,68,16,69,70,71,16,72,16,73,16,16,16,16,74,75,76,77,16,16,78,16,79,80,16,16,16,16,81,16,16,16,16,16,16,16,16,16,16,16,16,16,82,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,83,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,84,85,86,87,16,16,88,89,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,90,16,91,92,93,94,95,96,97,98,16,16,16,16,16,16,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,254,255,0,252,1,0,0,248,1,0,0,120,0,0,0,0,255,251,223,251,0,0,128,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,252,255,224,175,255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,32,64,176,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,0,0,134,254,255,255,255,0,64,73,0,0,0,0,0,24,0,223,255,0,200,0,0,0,0,0,0,0,1,0,60,0,0,0,0,0,0,0,0,0,0,0,0,16,224,1,30,0,96,255,191,0,0,0,0,0,0,255,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,207,3,0,0,0,3,0,32,255,127,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,16,0,32,30,0,48,0,1,0,0,0,0,0,0,0,0,16,0,32,0,0,0,0,252,15,0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,0,0,0,3,0,0,0,0,0,0,0,0,16,0,32,0,0,0,0,253,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,255,7,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,255,0,0,0,0,0,0,0,16,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,63,2,0,0,0,0,0,0,0,0,0,4,0,0,0,0,16,0,0,0,0,0,0,128,0,128,192,223,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,0,0,0,254,255,255,255,0,252,255,255,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,192,255,223,255,7,0,0,0,0,0,0,0,0,0,0,128,6,0,252,0,0,24,62,0,0,128,191,0,204,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,96,255,255,255,31,0,0,255,3,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,1,0,0,24,0,0,0,0,0,0,0,0,0,56,0,0,0,0,16,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,254,127,47,0,0,255,3,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,0,0,0,192,0,0,0,0,0,0,0,0,1,0,224,159,0,0,0,0,127,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,16,0,0,252,255,255,255,31,0,0,0,0,0,12,0,0,0,0,0,0,64,0,12,240,0,0,0,0,0,0,192,248,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,255,0,255,255,255,33,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,127,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,3,224,0,224,0,224,0,96,128,248,255,255,255,252,255,255,255,255,255,127,31,252,241,127,255,127,0,0,255,255,255,3,0,0,255,255,255,255,1,0,123,3,208,193,175,66,0,12,31,188,255,255,0,0,0,0,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,255,255,255,255,127,0,0,0,255,7,0,0,255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,252,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,135,3,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,127,255,15,0,0,0,0,0,0,0,0,255,255,255,251,255,255,255,255,255,255,255,255,255,255,15,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,0,0,255,15,30,255,255,255,1,252,193,224,0,0,0,0,0,0,0,0,0,0,0,30,1,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,255,255,255,255,15,0,0,0,255,255,255,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,127,0,0,0,0,0,0,192,0,224,0,0,0,0,0,0,0,0,0,0,0,128,15,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,255,255,127,0,3,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,8,0,0,0,15,255,3,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,16,192,0,0,255,255,3,7,0,0,0,0,0,248,0,0,0,0,8,128,0,0,0,0,0,0,0,0,0,0,8,0,255,63,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0,128,11,0,0,0,0,0,0,0,128,2,0,0,192,0,0,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,255,255,255,3,127,0,255,255,255,255,247,255,127,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,254,255,0,252,1,0,0,248,1,0,0,248,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,127,0,48,135,255,255,255,255,255,143,255,0,0,0,0,0,0,224,255,255,7,255,15,0,0,0,0,0,0,255,255,255,255,255,63,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,143,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,255,0,255,1,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,0,0,0,255,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,63,252,255,63,0,0,0,3,0,0,0,0,0,0,254,3,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,7,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,255,255,255,255,127,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63,0,0,0,0,255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,127,0,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,8,0,0,0,8,0,0,32,0,0,0,32,0,0,128,0,0,0,128,0,0,0,2,0,0,0,2,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,255,255,255,255,255,15,255,255,255,255,255,255,255,255,255,255,255,255,15,0,255,127,254,127,254,255,254,255,0,0,0,0,255,7,255,255,255,127,255,255,255,255,255,255,255,15,255,255,255,255,255,7,0,0,0,0,0,0,0,0,192,255,255,255,7,0,255,255,255,255,255,7,255,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,1,0,191,255,255,255,255,255,255,255,255,31,255,255,15,0,255,255,255,255,223,7,0,0,255,255,1,0,255,255,255,255,255,255,255,127,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,30,255,255,255,255,255,255,255,63,15,0,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,255,255,255,255,255,255,255,225,255,0,0,0,0,0,0,255,255,255,255,255,255,255,255,63,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,47,112,114,111,99,47,115,101,108,102,47,102,100,47,0,67,46,85,84,70,45,56,0,114,119,97,0,119,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,116,109,112,0,47,116,109,112,47,116,37,120,45,37,120],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+183902);allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0,9,0,10,0,13,0,12,0,7,0,27,0,91,91,58,97,108,110,117,109,58,93,95,93,0,91,94,91,58,97,108,110,117,109,58,93,95,93,0,91,91,58,115,112,97,99,101,58,93,93,0,91,94,91,58,115,112,97,99,101,58,93,93,0,91,91,58,100,105,103,105,116,58,93,93,0,91,94,91,58,100,105,103,105,116,58,93,93,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+192848);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}Module["_i64Subtract"]=_i64Subtract;Module["_i64Add"]=_i64Add;var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var PATH={splitPath:(function(filename){var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)}),normalizeArray:(function(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}),normalize:(function(path){var isAbsolute=path.charAt(0)==="/",trailingSlash=path.substr(-1)==="/";path=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path}),dirname:(function(path){var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return"."}if(dir){dir=dir.substr(0,dir.length-1)}return root+dir}),basename:(function(path){if(path==="/")return"/";var lastSlash=path.lastIndexOf("/");if(lastSlash===-1)return path;return path.substr(lastSlash+1)}),extname:(function(path){return PATH.splitPath(path)[3]}),join:(function(){var paths=Array.prototype.slice.call(arguments,0);return PATH.normalize(paths.join("/"))}),join2:(function(l,r){return PATH.normalize(l+"/"+r)}),resolve:(function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:FS.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter((function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."}),relative:(function(from,to){from=PATH.resolve(from).substr(1);to=PATH.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")})};var TTY={ttys:[],init:(function(){}),shutdown:(function(){}),register:(function(dev,ops){TTY.ttys[dev]={input:[],output:[],ops:ops};FS.registerDevice(dev,TTY.stream_ops)}),stream_ops:{open:(function(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}stream.tty=tty;stream.seekable=false}),close:(function(stream){stream.tty.ops.flush(stream.tty)}),flush:(function(stream){stream.tty.ops.flush(stream.tty)}),read:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(ERRNO_CODES.ENXIO)}for(var i=0;i<length;i++){try{stream.tty.ops.put_char(stream.tty,buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})},default_tty_ops:{get_char:(function(tty){if(!tty.input.length){var result=null;if(ENVIRONMENT_IS_NODE){var BUFSIZE=256;var buf=new Buffer(BUFSIZE);var bytesRead=0;var fd=process.stdin.fd;var usingDevice=false;try{fd=fs.openSync("/dev/stdin","r");usingDevice=true}catch(e){}bytesRead=fs.readSync(fd,buf,0,BUFSIZE,null);if(usingDevice){fs.closeSync(fd)}if(bytesRead>0){result=buf.slice(0,bytesRead).toString("utf-8")}else{result=null}}else if(typeof window!="undefined"&&typeof window.prompt=="function"){result=window.prompt("Input: ");if(result!==null){result+="\n"}}else if(typeof readline=="function"){result=readline();if(result!==null){result+="\n"}}if(!result){return null}tty.input=intArrayFromString(result,true)}return tty.input.shift()}),put_char:(function(tty,val){if(val===null||val===10){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["print"](UTF8ArrayToString(tty.output,0));tty.output=[]}})},default_tty1_ops:{put_char:(function(tty,val){if(val===null||val===10){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}else{if(val!=0)tty.output.push(val)}}),flush:(function(tty){if(tty.output&&tty.output.length>0){Module["printErr"](UTF8ArrayToString(tty.output,0));tty.output=[]}})}};var MEMFS={ops_table:null,mount:(function(mount){return MEMFS.createNode(null,"/",16384|511,0)}),createNode:(function(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(!MEMFS.ops_table){MEMFS.ops_table={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}}}var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.timestamp=Date.now();if(parent){parent.contents[name]=node}return node}),getFileDataAsRegularArray:(function(node){if(node.contents&&node.contents.subarray){var arr=[];for(var i=0;i<node.usedBytes;++i)arr.push(node.contents[i]);return arr}return node.contents}),getFileDataAsTypedArray:(function(node){if(!node.contents)return new Uint8Array;if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);return new Uint8Array(node.contents)}),expandFileStorage:(function(node,newCapacity){if(node.contents&&node.contents.subarray&&newCapacity>node.contents.length){node.contents=MEMFS.getFileDataAsRegularArray(node);node.usedBytes=node.contents.length}if(!node.contents||node.contents.subarray){var prevCapacity=node.contents?node.contents.buffer.byteLength:0;if(prevCapacity>=newCapacity)return;var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125)|0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0);return}if(!node.contents&&newCapacity>0)node.contents=[];while(node.contents.length<newCapacity)node.contents.push(0)}),resizeFileStorage:(function(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;node.usedBytes=0;return}if(!node.contents||node.contents.subarray){var oldContents=node.contents;node.contents=new Uint8Array(new ArrayBuffer(newSize));if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize;return}if(!node.contents)node.contents=[];if(node.contents.length>newSize)node.contents.length=newSize;else while(node.contents.length<newSize)node.contents.push(0);node.usedBytes=newSize}),node_ops:{getattr:(function(node){var attr={};attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.timestamp);attr.mtime=new Date(node.timestamp);attr.ctime=new Date(node.timestamp);attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}}),lookup:(function(parent,name){throw FS.genericErrors[ERRNO_CODES.ENOENT]}),mknod:(function(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)}),rename:(function(old_node,new_dir,new_name){if(FS.isDir(old_node.mode)){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){for(var i in new_node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}}}delete old_node.parent.contents[old_node.name];old_node.name=new_name;new_dir.contents[new_name]=old_node;old_node.parent=new_dir}),unlink:(function(parent,name){delete parent.contents[name]}),rmdir:(function(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}delete parent.contents[name]}),readdir:(function(node){var entries=[".",".."];for(var key in node.contents){if(!node.contents.hasOwnProperty(key)){continue}entries.push(key)}return entries}),symlink:(function(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node}),readlink:(function(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return node.link})},stream_ops:{read:(function(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);assert(size>=0);if(size>8&&contents.subarray){buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size}),write:(function(stream,buffer,offset,length,position,canOwn){if(!length)return 0;var node=stream.node;node.timestamp=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){node.contents=new Uint8Array(buffer.subarray(offset,offset+length));node.usedBytes=length;return length}else if(position+length<=node.usedBytes){node.contents.set(buffer.subarray(offset,offset+length),position);return length}}MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray)node.contents.set(buffer.subarray(offset,offset+length),position);else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position}),allocate:(function(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}var ptr;var allocated;var contents=stream.node.contents;if(!(flags&2)&&(contents.buffer===buffer||contents.buffer===buffer.buffer)){allocated=false;ptr=contents.byteOffset}else{if(position>0||position+length<stream.node.usedBytes){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}allocated=true;ptr=_malloc(length);if(!ptr){throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)}buffer.set(contents,ptr)}return{ptr:ptr,allocated:allocated}}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(mmapFlags&2){return 0}var bytesWritten=MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);return 0})}};var IDBFS={dbs:{},indexedDB:(function(){if(typeof indexedDB!=="undefined")return indexedDB;var ret=null;if(typeof window==="object")ret=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB;assert(ret,"IDBFS used, but indexedDB not supported");return ret}),DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:(function(mount){return MEMFS.mount.apply(null,arguments)}),syncfs:(function(mount,populate,callback){IDBFS.getLocalSet(mount,(function(err,local){if(err)return callback(err);IDBFS.getRemoteSet(mount,(function(err,remote){if(err)return callback(err);var src=populate?remote:local;var dst=populate?local:remote;IDBFS.reconcile(src,dst,callback)}))}))}),getDB:(function(name,callback){var db=IDBFS.dbs[name];if(db){return callback(null,db)}var req;try{req=IDBFS.indexedDB().open(name,IDBFS.DB_VERSION)}catch(e){return callback(e)}req.onupgradeneeded=(function(e){var db=e.target.result;var transaction=e.target.transaction;var fileStore;if(db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)){fileStore=transaction.objectStore(IDBFS.DB_STORE_NAME)}else{fileStore=db.createObjectStore(IDBFS.DB_STORE_NAME)}if(!fileStore.indexNames.contains("timestamp")){fileStore.createIndex("timestamp","timestamp",{unique:false})}});req.onsuccess=(function(){db=req.result;IDBFS.dbs[name]=db;callback(null,db)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),getLocalSet:(function(mount,callback){var entries={};function isRealDir(p){return p!=="."&&p!==".."}function toAbsolute(root){return(function(p){return PATH.join2(root,p)})}var check=FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));while(check.length){var path=check.pop();var stat;try{stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){check.push.apply(check,FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))}entries[path]={timestamp:stat.mtime}}return callback(null,{type:"local",entries:entries})}),getRemoteSet:(function(mount,callback){var entries={};IDBFS.getDB(mount.mountpoint,(function(err,db){if(err)return callback(err);var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readonly");transaction.onerror=(function(e){callback(this.error);e.preventDefault()});var store=transaction.objectStore(IDBFS.DB_STORE_NAME);var index=store.index("timestamp");index.openKeyCursor().onsuccess=(function(event){var cursor=event.target.result;if(!cursor){return callback(null,{type:"remote",db:db,entries:entries})}entries[cursor.primaryKey]={timestamp:cursor.key};cursor.continue()})}))}),loadLocalEntry:(function(path,callback){var stat,node;try{var lookup=FS.lookupPath(path);node=lookup.node;stat=FS.stat(path)}catch(e){return callback(e)}if(FS.isDir(stat.mode)){return callback(null,{timestamp:stat.mtime,mode:stat.mode})}else if(FS.isFile(stat.mode)){node.contents=MEMFS.getFileDataAsTypedArray(node);return callback(null,{timestamp:stat.mtime,mode:stat.mode,contents:node.contents})}else{return callback(new Error("node type not supported"))}}),storeLocalEntry:(function(path,entry,callback){try{if(FS.isDir(entry.mode)){FS.mkdir(path,entry.mode)}else if(FS.isFile(entry.mode)){FS.writeFile(path,entry.contents,{encoding:"binary",canOwn:true})}else{return callback(new Error("node type not supported"))}FS.chmod(path,entry.mode);FS.utime(path,entry.timestamp,entry.timestamp)}catch(e){return callback(e)}callback(null)}),removeLocalEntry:(function(path,callback){try{var lookup=FS.lookupPath(path);var stat=FS.stat(path);if(FS.isDir(stat.mode)){FS.rmdir(path)}else if(FS.isFile(stat.mode)){FS.unlink(path)}}catch(e){return callback(e)}callback(null)}),loadRemoteEntry:(function(store,path,callback){var req=store.get(path);req.onsuccess=(function(event){callback(null,event.target.result)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),storeRemoteEntry:(function(store,path,entry,callback){var req=store.put(entry,path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),removeRemoteEntry:(function(store,path,callback){var req=store.delete(path);req.onsuccess=(function(){callback(null)});req.onerror=(function(e){callback(this.error);e.preventDefault()})}),reconcile:(function(src,dst,callback){var total=0;var create=[];Object.keys(src.entries).forEach((function(key){var e=src.entries[key];var e2=dst.entries[key];if(!e2||e.timestamp>e2.timestamp){create.push(key);total++}}));var remove=[];Object.keys(dst.entries).forEach((function(key){var e=dst.entries[key];var e2=src.entries[key];if(!e2){remove.push(key);total++}}));if(!total){return callback(null)}var errored=false;var completed=0;var db=src.type==="remote"?src.db:dst.db;var transaction=db.transaction([IDBFS.DB_STORE_NAME],"readwrite");var store=transaction.objectStore(IDBFS.DB_STORE_NAME);function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=total){return callback(null)}}transaction.onerror=(function(e){done(this.error);e.preventDefault()});create.sort().forEach((function(path){if(dst.type==="local"){IDBFS.loadRemoteEntry(store,path,(function(err,entry){if(err)return done(err);IDBFS.storeLocalEntry(path,entry,done)}))}else{IDBFS.loadLocalEntry(path,(function(err,entry){if(err)return done(err);IDBFS.storeRemoteEntry(store,path,entry,done)}))}}));remove.sort().reverse().forEach((function(path){if(dst.type==="local"){IDBFS.removeLocalEntry(path,done)}else{IDBFS.removeRemoteEntry(store,path,done)}}))})};var NODEFS={isWindows:false,staticInit:(function(){NODEFS.isWindows=!!process.platform.match(/^win/)}),mount:(function(mount){assert(ENVIRONMENT_IS_NODE);return NODEFS.createNode(null,"/",NODEFS.getMode(mount.opts.root),0)}),createNode:(function(parent,name,mode,dev){if(!FS.isDir(mode)&&!FS.isFile(mode)&&!FS.isLink(mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=FS.createNode(parent,name,mode);node.node_ops=NODEFS.node_ops;node.stream_ops=NODEFS.stream_ops;return node}),getMode:(function(path){var stat;try{stat=fs.lstatSync(path);if(NODEFS.isWindows){stat.mode=stat.mode|(stat.mode&146)>>1}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return stat.mode}),realPath:(function(node){var parts=[];while(node.parent!==node){parts.push(node.name);node=node.parent}parts.push(node.mount.opts.root);parts.reverse();return PATH.join.apply(null,parts)}),flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:(function(flags){flags&=~32768;flags&=~524288;if(flags in NODEFS.flagsToPermissionStringMap){return NODEFS.flagsToPermissionStringMap[flags]}else{throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}}),node_ops:{getattr:(function(node){var path=NODEFS.realPath(node);var stat;try{stat=fs.lstatSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(NODEFS.isWindows&&!stat.blksize){stat.blksize=4096}if(NODEFS.isWindows&&!stat.blocks){stat.blocks=(stat.size+stat.blksize-1)/stat.blksize|0}return{dev:stat.dev,ino:stat.ino,mode:stat.mode,nlink:stat.nlink,uid:stat.uid,gid:stat.gid,rdev:stat.rdev,size:stat.size,atime:stat.atime,mtime:stat.mtime,ctime:stat.ctime,blksize:stat.blksize,blocks:stat.blocks}}),setattr:(function(node,attr){var path=NODEFS.realPath(node);try{if(attr.mode!==undefined){fs.chmodSync(path,attr.mode);node.mode=attr.mode}if(attr.timestamp!==undefined){var date=new Date(attr.timestamp);fs.utimesSync(path,date,date)}if(attr.size!==undefined){fs.truncateSync(path,attr.size)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),lookup:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);var mode=NODEFS.getMode(path);return NODEFS.createNode(parent,name,mode)}),mknod:(function(parent,name,mode,dev){var node=NODEFS.createNode(parent,name,mode,dev);var path=NODEFS.realPath(node);try{if(FS.isDir(node.mode)){fs.mkdirSync(path,node.mode)}else{fs.writeFileSync(path,"",{mode:node.mode})}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}return node}),rename:(function(oldNode,newDir,newName){var oldPath=NODEFS.realPath(oldNode);var newPath=PATH.join2(NODEFS.realPath(newDir),newName);try{fs.renameSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),unlink:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.unlinkSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),rmdir:(function(parent,name){var path=PATH.join2(NODEFS.realPath(parent),name);try{fs.rmdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readdir:(function(node){var path=NODEFS.realPath(node);try{return fs.readdirSync(path)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),symlink:(function(parent,newName,oldPath){var newPath=PATH.join2(NODEFS.realPath(parent),newName);try{fs.symlinkSync(oldPath,newPath)}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),readlink:(function(node){var path=NODEFS.realPath(node);try{path=fs.readlinkSync(path);path=NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root),path);return path}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}})},stream_ops:{open:(function(stream){var path=NODEFS.realPath(stream.node);try{if(FS.isFile(stream.node.mode)){stream.nfd=fs.openSync(path,NODEFS.flagsToPermissionString(stream.flags))}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),close:(function(stream){try{if(FS.isFile(stream.node.mode)&&stream.nfd){fs.closeSync(stream.nfd)}}catch(e){if(!e.code)throw e;throw new FS.ErrnoError(ERRNO_CODES[e.code])}}),read:(function(stream,buffer,offset,length,position){if(length===0)return 0;var nbuffer=new Buffer(length);var res;try{res=fs.readSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}if(res>0){for(var i=0;i<res;i++){buffer[offset+i]=nbuffer[i]}}return res}),write:(function(stream,buffer,offset,length,position){var nbuffer=new Buffer(buffer.subarray(offset,offset+length));var res;try{res=fs.writeSync(stream.nfd,nbuffer,0,length,position)}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}return res}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){try{var stat=fs.fstatSync(stream.nfd);position+=stat.size}catch(e){throw new FS.ErrnoError(ERRNO_CODES[e.code])}}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:(function(mount){assert(ENVIRONMENT_IS_WORKER);if(!WORKERFS.reader)WORKERFS.reader=new FileReaderSync;var root=WORKERFS.createNode(null,"/",WORKERFS.DIR_MODE,0);var createdParents={};function ensureParent(path){var parts=path.split("/");var parent=root;for(var i=0;i<parts.length-1;i++){var curr=parts.slice(0,i+1).join("/");if(!createdParents[curr]){createdParents[curr]=WORKERFS.createNode(parent,curr,WORKERFS.DIR_MODE,0)}parent=createdParents[curr]}return parent}function base(path){var parts=path.split("/");return parts[parts.length-1]}Array.prototype.forEach.call(mount.opts["files"]||[],(function(file){WORKERFS.createNode(ensureParent(file.name),base(file.name),WORKERFS.FILE_MODE,0,file,file.lastModifiedDate)}));(mount.opts["blobs"]||[]).forEach((function(obj){WORKERFS.createNode(ensureParent(obj["name"]),base(obj["name"]),WORKERFS.FILE_MODE,0,obj["data"])}));(mount.opts["packages"]||[]).forEach((function(pack){pack["metadata"].files.forEach((function(file){var name=file.filename.substr(1);WORKERFS.createNode(ensureParent(name),base(name),WORKERFS.FILE_MODE,0,pack["blob"].slice(file.start,file.end))}))}));return root}),createNode:(function(parent,name,mode,dev,contents,mtime){var node=FS.createNode(parent,name,mode);node.mode=mode;node.node_ops=WORKERFS.node_ops;node.stream_ops=WORKERFS.stream_ops;node.timestamp=(mtime||new Date).getTime();assert(WORKERFS.FILE_MODE!==WORKERFS.DIR_MODE);if(mode===WORKERFS.FILE_MODE){node.size=contents.size;node.contents=contents}else{node.size=4096;node.contents={}}if(parent){parent.contents[name]=node}return node}),node_ops:{getattr:(function(node){return{dev:1,ino:undefined,mode:node.mode,nlink:1,uid:0,gid:0,rdev:undefined,size:node.size,atime:new Date(node.timestamp),mtime:new Date(node.timestamp),ctime:new Date(node.timestamp),blksize:4096,blocks:Math.ceil(node.size/4096)}}),setattr:(function(node,attr){if(attr.mode!==undefined){node.mode=attr.mode}if(attr.timestamp!==undefined){node.timestamp=attr.timestamp}}),lookup:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}),mknod:(function(parent,name,mode,dev){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rename:(function(oldNode,newDir,newName){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),unlink:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),rmdir:(function(parent,name){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readdir:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),symlink:(function(parent,newName,oldPath){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}),readlink:(function(node){throw new FS.ErrnoError(ERRNO_CODES.EPERM)})},stream_ops:{read:(function(stream,buffer,offset,length,position){if(position>=stream.node.size)return 0;var chunk=stream.node.contents.slice(position,position+length);var ab=WORKERFS.reader.readAsArrayBuffer(chunk);buffer.set(new Uint8Array(ab),offset);return chunk.size}),write:(function(stream,buffer,offset,length,position){throw new FS.ErrnoError(ERRNO_CODES.EIO)}),llseek:(function(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.size}}if(position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return position})}};var _stdin=allocate(1,"i32*",ALLOC_STATIC);var _stdout=allocate(1,"i32*",ALLOC_STATIC);var _stderr=allocate(1,"i32*",ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:(function(e){if(!(e instanceof FS.ErrnoError))throw e+" : "+stackTrace();return ___setErrNo(e.errno)}),lookupPath:(function(path,opts){path=PATH.resolve(FS.cwd(),path);opts=opts||{};if(!path)return{path:"",node:null};var defaults={follow_mount:true,recurse_count:0};for(var key in defaults){if(opts[key]===undefined){opts[key]=defaults[key]}}if(opts.recurse_count>8){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}var parts=PATH.normalizeArray(path.split("/").filter((function(p){return!!p})),false);var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=i===parts.length-1;if(islast&&opts.parent){break}current=FS.lookupNode(current,parts[i]);current_path=PATH.join2(current_path,parts[i]);if(FS.isMountpoint(current)){if(!islast||islast&&opts.follow_mount){current=current.mounted.root}}if(!islast||opts.follow){var count=0;while(FS.isLink(current.mode)){var link=FS.readlink(current_path);current_path=PATH.resolve(PATH.dirname(current_path),link);var lookup=FS.lookupPath(current_path,{recurse_count:opts.recurse_count});current=lookup.node;if(count++>40){throw new FS.ErrnoError(ERRNO_CODES.ELOOP)}}}}return{path:current_path,node:current}}),getPath:(function(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?mount+"/"+path:mount+path}path=path?node.name+"/"+path:node.name;node=node.parent}}),hashName:(function(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=(hash<<5)-hash+name.charCodeAt(i)|0}return(parentid+hash>>>0)%FS.nameTable.length}),hashAddNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node}),hashRemoveNode:(function(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}}),lookupNode:(function(parent,name){var err=FS.mayLookup(parent);if(err){throw new FS.ErrnoError(err,parent)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}return FS.lookup(parent,name)}),createNode:(function(parent,name,mode,rdev){if(!FS.FSNode){FS.FSNode=(function(parent,name,mode,rdev){if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.mounted=null;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.node_ops={};this.stream_ops={};this.rdev=rdev});FS.FSNode.prototype={};var readMode=292|73;var writeMode=146;Object.defineProperties(FS.FSNode.prototype,{read:{get:(function(){return(this.mode&readMode)===readMode}),set:(function(val){val?this.mode|=readMode:this.mode&=~readMode})},write:{get:(function(){return(this.mode&writeMode)===writeMode}),set:(function(val){val?this.mode|=writeMode:this.mode&=~writeMode})},isFolder:{get:(function(){return FS.isDir(this.mode)})},isDevice:{get:(function(){return FS.isChrdev(this.mode)})}})}var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node}),destroyNode:(function(node){FS.hashRemoveNode(node)}),isRoot:(function(node){return node===node.parent}),isMountpoint:(function(node){return!!node.mounted}),isFile:(function(mode){return(mode&61440)===32768}),isDir:(function(mode){return(mode&61440)===16384}),isLink:(function(mode){return(mode&61440)===40960}),isChrdev:(function(mode){return(mode&61440)===8192}),isBlkdev:(function(mode){return(mode&61440)===24576}),isFIFO:(function(mode){return(mode&61440)===4096}),isSocket:(function(mode){return(mode&49152)===49152}),flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:(function(str){var flags=FS.flagModes[str];if(typeof flags==="undefined"){throw new Error("Unknown file open mode: "+str)}return flags}),flagsToPermissionString:(function(flag){var perms=["r","w","rw"][flag&3];if(flag&512){perms+="w"}return perms}),nodePermissions:(function(node,perms){if(FS.ignorePermissions){return 0}if(perms.indexOf("r")!==-1&&!(node.mode&292)){return ERRNO_CODES.EACCES}else if(perms.indexOf("w")!==-1&&!(node.mode&146)){return ERRNO_CODES.EACCES}else if(perms.indexOf("x")!==-1&&!(node.mode&73)){return ERRNO_CODES.EACCES}return 0}),mayLookup:(function(dir){var err=FS.nodePermissions(dir,"x");if(err)return err;if(!dir.node_ops.lookup)return ERRNO_CODES.EACCES;return 0}),mayCreate:(function(dir,name){try{var node=FS.lookupNode(dir,name);return ERRNO_CODES.EEXIST}catch(e){}return FS.nodePermissions(dir,"wx")}),mayDelete:(function(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var err=FS.nodePermissions(dir,"wx");if(err){return err}if(isdir){if(!FS.isDir(node.mode)){return ERRNO_CODES.ENOTDIR}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return ERRNO_CODES.EBUSY}}else{if(FS.isDir(node.mode)){return ERRNO_CODES.EISDIR}}return 0}),mayOpen:(function(node,flags){if(!node){return ERRNO_CODES.ENOENT}if(FS.isLink(node.mode)){return ERRNO_CODES.ELOOP}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||flags&512){return ERRNO_CODES.EISDIR}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))}),MAX_OPEN_FDS:4096,nextfd:(function(fd_start,fd_end){fd_start=fd_start||0;fd_end=fd_end||FS.MAX_OPEN_FDS;for(var fd=fd_start;fd<=fd_end;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(ERRNO_CODES.EMFILE)}),getStream:(function(fd){return FS.streams[fd]}),createStream:(function(stream,fd_start,fd_end){if(!FS.FSStream){FS.FSStream=(function(){});FS.FSStream.prototype={};Object.defineProperties(FS.FSStream.prototype,{object:{get:(function(){return this.node}),set:(function(val){this.node=val})},isRead:{get:(function(){return(this.flags&2097155)!==1})},isWrite:{get:(function(){return(this.flags&2097155)!==0})},isAppend:{get:(function(){return this.flags&1024})}})}var newStream=new FS.FSStream;for(var p in stream){newStream[p]=stream[p]}stream=newStream;var fd=FS.nextfd(fd_start,fd_end);stream.fd=fd;FS.streams[fd]=stream;return stream}),closeStream:(function(fd){FS.streams[fd]=null}),chrdev_stream_ops:{open:(function(stream){var device=FS.getDevice(stream.node.rdev);stream.stream_ops=device.stream_ops;if(stream.stream_ops.open){stream.stream_ops.open(stream)}}),llseek:(function(){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)})},major:(function(dev){return dev>>8}),minor:(function(dev){return dev&255}),makedev:(function(ma,mi){return ma<<8|mi}),registerDevice:(function(dev,ops){FS.devices[dev]={stream_ops:ops}}),getDevice:(function(dev){return FS.devices[dev]}),getMounts:(function(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push.apply(check,m.mounts)}return mounts}),syncfs:(function(populate,callback){if(typeof populate==="function"){callback=populate;populate=false}var mounts=FS.getMounts(FS.root.mount);var completed=0;function done(err){if(err){if(!done.errored){done.errored=true;return callback(err)}return}if(++completed>=mounts.length){callback(null)}}mounts.forEach((function(mount){if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)}))}),mount:(function(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}}var mount={type:type,opts:opts,mountpoint:mountpoint,mounts:[]};var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){node.mounted=mount;if(node.mount){node.mount.mounts.push(mount)}}return mountRoot}),unmount:(function(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach((function(hash){var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.indexOf(current.mount)!==-1){FS.destroyNode(current)}current=next}}));node.mounted=null;var idx=node.mount.mounts.indexOf(mount);assert(idx!==-1);node.mount.mounts.splice(idx,1)}),lookup:(function(parent,name){return parent.node_ops.lookup(parent,name)}),mknod:(function(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name||name==="."||name===".."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.mayCreate(parent,name);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.mknod(parent,name,mode,dev)}),create:(function(path,mode){mode=mode!==undefined?mode:438;mode&=4095;mode|=32768;return FS.mknod(path,mode,0)}),mkdir:(function(path,mode){mode=mode!==undefined?mode:511;mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)}),mkdev:(function(path,mode,dev){if(typeof dev==="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)}),symlink:(function(oldpath,newpath){if(!PATH.resolve(oldpath)){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}var newname=PATH.basename(newpath);var err=FS.mayCreate(parent,newname);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return parent.node_ops.symlink(parent,newname,oldpath)}),rename:(function(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);var lookup,old_dir,new_dir;try{lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(!old_dir||!new_dir)throw new FS.ErrnoError(ERRNO_CODES.ENOENT);if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(ERRNO_CODES.EXDEV)}var old_node=FS.lookupNode(old_dir,old_name);var relative=PATH.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}relative=PATH.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)}var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(old_node===new_node){return}var isdir=FS.isDir(old_node.mode);var err=FS.mayDelete(old_dir,old_name,isdir);if(err){throw new FS.ErrnoError(err)}err=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(err){throw new FS.ErrnoError(err)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(old_node)||new_node&&FS.isMountpoint(new_node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}if(new_dir!==old_dir){err=FS.nodePermissions(old_dir,"w");if(err){throw new FS.ErrnoError(err)}}try{if(FS.trackingDelegate["willMovePath"]){FS.trackingDelegate["willMovePath"](old_path,new_path)}}catch(e){console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}FS.hashRemoveNode(old_node);try{old_dir.node_ops.rename(old_node,new_dir,new_name)}catch(e){throw e}finally{FS.hashAddNode(old_node)}try{if(FS.trackingDelegate["onMovePath"])FS.trackingDelegate["onMovePath"](old_path,new_path)}catch(e){console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: "+e.message)}}),rmdir:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,true);if(err){throw new FS.ErrnoError(err)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node.node_ops.readdir){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}return node.node_ops.readdir(node)}),unlink:(function(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var err=FS.mayDelete(parent,name,false);if(err){if(err===ERRNO_CODES.EISDIR)err=ERRNO_CODES.EPERM;throw new FS.ErrnoError(err)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(ERRNO_CODES.EBUSY)}try{if(FS.trackingDelegate["willDeletePath"]){FS.trackingDelegate["willDeletePath"](path)}}catch(e){console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: "+e.message)}parent.node_ops.unlink(parent,name);FS.destroyNode(node);try{if(FS.trackingDelegate["onDeletePath"])FS.trackingDelegate["onDeletePath"](path)}catch(e){console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: "+e.message)}}),readlink:(function(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!link.node_ops.readlink){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}return PATH.resolve(FS.getPath(link.parent),link.node_ops.readlink(link))}),stat:(function(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(!node.node_ops.getattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}return node.node_ops.getattr(node)}),lstat:(function(path){return FS.stat(path,true)}),chmod:(function(path,mode,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{mode:mode&4095|node.mode&~4095,timestamp:Date.now()})}),lchmod:(function(path,mode){FS.chmod(path,mode,true)}),fchmod:(function(fd,mode){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chmod(stream.node,mode)}),chown:(function(path,uid,gid,dontFollow){var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}node.node_ops.setattr(node,{timestamp:Date.now()})}),lchown:(function(path,uid,gid){FS.chown(path,uid,gid,true)}),fchown:(function(fd,uid,gid){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}FS.chown(stream.node,uid,gid)}),truncate:(function(path,len){if(len<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var node;if(typeof path==="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}if(!node.node_ops.setattr){throw new FS.ErrnoError(ERRNO_CODES.EPERM)}if(FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var err=FS.nodePermissions(node,"w");if(err){throw new FS.ErrnoError(err)}node.node_ops.setattr(node,{size:len,timestamp:Date.now()})}),ftruncate:(function(fd,len){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}FS.truncate(stream.node,len)}),utime:(function(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;node.node_ops.setattr(node,{timestamp:Math.max(atime,mtime)})}),open:(function(path,flags,mode,fd_start,fd_end){if(path===""){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}flags=typeof flags==="string"?FS.modeStringToFlags(flags):flags;mode=typeof mode==="undefined"?438:mode;if(flags&64){mode=mode&4095|32768}else{mode=0}var node;if(typeof path==="object"){node=path}else{path=PATH.normalize(path);try{var lookup=FS.lookupPath(path,{follow:!(flags&131072)});node=lookup.node}catch(e){}}var created=false;if(flags&64){if(node){if(flags&128){throw new FS.ErrnoError(ERRNO_CODES.EEXIST)}}else{node=FS.mknod(path,mode,0);created=true}}if(!node){throw new FS.ErrnoError(ERRNO_CODES.ENOENT)}if(FS.isChrdev(node.mode)){flags&=~512}if(flags&65536&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}if(!created){var err=FS.mayOpen(node,flags);if(err){throw new FS.ErrnoError(err)}}if(flags&512){FS.truncate(node,0)}flags&=~(128|512);var stream=FS.createStream({node:node,path:FS.getPath(node),flags:flags,seekable:true,position:0,stream_ops:node.stream_ops,ungotten:[],error:false},fd_start,fd_end);if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(Module["logReadFiles"]&&!(flags&1)){if(!FS.readFiles)FS.readFiles={};if(!(path in FS.readFiles)){FS.readFiles[path]=1;Module["printErr"]("read file: "+path)}}try{if(FS.trackingDelegate["onOpenFile"]){var trackingFlags=0;if((flags&2097155)!==1){trackingFlags|=FS.tracking.openFlags.READ}if((flags&2097155)!==0){trackingFlags|=FS.tracking.openFlags.WRITE}FS.trackingDelegate["onOpenFile"](path,trackingFlags)}}catch(e){console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: "+e.message)}return stream}),close:(function(stream){if(stream.getdents)stream.getdents=null;try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}}),llseek:(function(stream,offset,whence){if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position}),read:(function(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.read){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead}),write:(function(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.EISDIR)}if(!stream.stream_ops.write){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if(stream.flags&1024){FS.llseek(stream,0,2)}var seeking=true;if(typeof position==="undefined"){position=stream.position;seeking=false}else if(!stream.seekable){throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;try{if(stream.path&&FS.trackingDelegate["onWriteToFile"])FS.trackingDelegate["onWriteToFile"](stream.path)}catch(e){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+e.message)}return bytesWritten}),allocate:(function(stream,offset,length){if(offset<0||length<=0){throw new FS.ErrnoError(ERRNO_CODES.EINVAL)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(ERRNO_CODES.EBADF)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)}stream.stream_ops.allocate(stream,offset,length)}),mmap:(function(stream,buffer,offset,length,position,prot,flags){if((stream.flags&2097155)===1){throw new FS.ErrnoError(ERRNO_CODES.EACCES)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(ERRNO_CODES.ENODEV)}return stream.stream_ops.mmap(stream,buffer,offset,length,position,prot,flags)}),msync:(function(stream,buffer,offset,length,mmapFlags){if(!stream||!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)}),munmap:(function(stream){return 0}),ioctl:(function(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)}return stream.stream_ops.ioctl(stream,cmd,arg)}),readFile:(function(path,opts){opts=opts||{};opts.flags=opts.flags||"r";opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf,0)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret}),writeFile:(function(path,data,opts){opts=opts||{};opts.flags=opts.flags||"w";opts.encoding=opts.encoding||"utf8";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error('Invalid encoding type "'+opts.encoding+'"')}var stream=FS.open(path,opts.flags,opts.mode);if(opts.encoding==="utf8"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,0,opts.canOwn)}else if(opts.encoding==="binary"){FS.write(stream,data,0,data.length,0,opts.canOwn)}FS.close(stream)}),cwd:(function(){return FS.currentPath}),chdir:(function(path){var lookup=FS.lookupPath(path,{follow:true});if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)}var err=FS.nodePermissions(lookup.node,"x");if(err){throw new FS.ErrnoError(err)}FS.currentPath=lookup.path}),createDefaultDirectories:(function(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")}),createDefaultDevices:(function(){FS.mkdir("/dev");FS.registerDevice(FS.makedev(1,3),{read:(function(){return 0}),write:(function(stream,buffer,offset,length,pos){return length})});FS.mkdev("/dev/null",FS.makedev(1,3));TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));var random_device;if(typeof crypto!=="undefined"){var randomBuffer=new Uint8Array(1);random_device=(function(){crypto.getRandomValues(randomBuffer);return randomBuffer[0]})}else if(ENVIRONMENT_IS_NODE){random_device=(function(){return require("crypto").randomBytes(1)[0]})}else{random_device=(function(){return Math.random()*256|0})}FS.createDevice("/dev","random",random_device);FS.createDevice("/dev","urandom",random_device);FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")}),createSpecialDirectories:(function(){FS.mkdir("/proc");FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount:(function(){var node=FS.createNode("/proc/self","fd",16384|511,73);node.node_ops={lookup:(function(parent,name){var fd=+name;var stream=FS.getStream(fd);if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:(function(){return stream.path})}};ret.parent=ret;return ret})};return node})},{},"/proc/self/fd")}),createStandardStreams:(function(){if(Module["stdin"]){FS.createDevice("/dev","stdin",Module["stdin"])}else{FS.symlink("/dev/tty","/dev/stdin")}if(Module["stdout"]){FS.createDevice("/dev","stdout",null,Module["stdout"])}else{FS.symlink("/dev/tty","/dev/stdout")}if(Module["stderr"]){FS.createDevice("/dev","stderr",null,Module["stderr"])}else{FS.symlink("/dev/tty1","/dev/stderr")}var stdin=FS.open("/dev/stdin","r");assert(stdin.fd===0,"invalid handle for stdin ("+stdin.fd+")");var stdout=FS.open("/dev/stdout","w");assert(stdout.fd===1,"invalid handle for stdout ("+stdout.fd+")");var stderr=FS.open("/dev/stderr","w");assert(stderr.fd===2,"invalid handle for stderr ("+stderr.fd+")")}),ensureErrnoError:(function(){if(FS.ErrnoError)return;FS.ErrnoError=function ErrnoError(errno,node){this.node=node;this.setErrno=(function(errno){this.errno=errno;for(var key in ERRNO_CODES){if(ERRNO_CODES[key]===errno){this.code=key;break}}});this.setErrno(errno);this.message=ERRNO_MESSAGES[errno]};FS.ErrnoError.prototype=new Error;FS.ErrnoError.prototype.constructor=FS.ErrnoError;[ERRNO_CODES.ENOENT].forEach((function(code){FS.genericErrors[code]=new FS.ErrnoError(code);FS.genericErrors[code].stack="<generic error, no stack>"}))}),staticInit:(function(){FS.ensureErrnoError();FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS,"IDBFS":IDBFS,"NODEFS":NODEFS,"WORKERFS":WORKERFS}}),init:(function(input,output,error){assert(!FS.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");FS.init.initialized=true;FS.ensureErrnoError();Module["stdin"]=input||Module["stdin"];Module["stdout"]=output||Module["stdout"];Module["stderr"]=error||Module["stderr"];FS.createStandardStreams()}),quit:(function(){FS.init.initialized=false;var fflush=Module["_fflush"];if(fflush)fflush(0);for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}}),getMode:(function(canRead,canWrite){var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode}),joinPath:(function(parts,forceRelative){var path=PATH.join.apply(null,parts);if(forceRelative&&path[0]=="/")path=path.substr(1);return path}),absolutePath:(function(relative,base){return PATH.resolve(base,relative)}),standardizePath:(function(path){return PATH.normalize(path)}),findObject:(function(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object}else{___setErrNo(ret.error);return null}}),analyzePath:(function(path,dontResolveLastLink){try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret}),createFolder:(function(parent,name,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.mkdir(path,mode)}),createPath:(function(parent,path,canRead,canWrite){parent=typeof parent==="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){}parent=current}return current}),createFile:(function(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(canRead,canWrite);return FS.create(path,mode)}),createDataFile:(function(parent,name,data,canRead,canWrite,canOwn){var path=name?PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name):parent;var mode=FS.getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data==="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}FS.chmod(node,mode|146);var stream=FS.open(node,"w");FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}return node}),createDevice:(function(parent,name,input,output){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);var mode=FS.getMode(!!input,!!output);if(!FS.createDevice.major)FS.createDevice.major=64;var dev=FS.makedev(FS.createDevice.major++,0);FS.registerDevice(dev,{open:(function(stream){stream.seekable=false}),close:(function(stream){if(output&&output.buffer&&output.buffer.length){output(10)}}),read:(function(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.timestamp=Date.now()}return bytesRead}),write:(function(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(ERRNO_CODES.EIO)}}if(length){stream.node.timestamp=Date.now()}return i})});return FS.mkdev(path,mode,dev)}),createLink:(function(parent,name,target,canRead,canWrite){var path=PATH.join2(typeof parent==="string"?parent:FS.getPath(parent),name);return FS.symlink(target,path)}),forceLoadFile:(function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;var success=true;if(typeof XMLHttpRequest!=="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else if(Module["read"]){try{obj.contents=intArrayFromString(Module["read"](obj.url),true);obj.usedBytes=obj.contents.length}catch(e){success=false}}else{throw new Error("Cannot load without read() or XMLHttpRequest.")}if(!success)___setErrNo(ERRNO_CODES.EIO);return success}),createLazyFile:(function(parent,name,url,canRead,canWrite){function LazyUint8Array(){this.lengthKnown=false;this.chunks=[]}LazyUint8Array.prototype.get=function LazyUint8Array_get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=idx/this.chunkSize|0;return this.getter(chunkNum)[chunkOffset]};LazyUint8Array.prototype.setDataGetter=function LazyUint8Array_setDataGetter(getter){this.getter=getter};LazyUint8Array.prototype.cacheLength=function LazyUint8Array_cacheLength(){var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;if(!hasByteServing)chunkSize=datalength;var doXHR=(function(from,to){if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);if(typeof Uint8Array!="undefined")xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(xhr.response||[])}else{return intArrayFromString(xhr.responseText||"",true)}});var lazyArray=this;lazyArray.setDataGetter((function(chunkNum){var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;end=Math.min(end,datalength-1);if(typeof lazyArray.chunks[chunkNum]==="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]==="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]}));if(usesGzip||!datalength){chunkSize=datalength=1;datalength=this.getter(0).length;chunkSize=datalength;console.log("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true};if(typeof XMLHttpRequest!=="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;Object.defineProperties(lazyArray,{length:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._length})},chunkSize:{get:(function(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize})}});var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url:url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}Object.defineProperties(node,{usedBytes:{get:(function(){return this.contents.length})}});var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach((function(key){var fn=node.stream_ops[key];stream_ops[key]=function forceLoadLazyFile(){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}return fn.apply(null,arguments)}}));stream_ops.read=function stream_ops_read(stream,buffer,offset,length,position){if(!FS.forceLoadFile(node)){throw new FS.ErrnoError(ERRNO_CODES.EIO)}var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);assert(size>=0);if(contents.slice){for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){buffer[offset+i]=contents.get(position+i)}}return size};node.stream_ops=stream_ops;return node}),createPreloadedFile:(function(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish){Browser.init();var fullname=name?PATH.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency("cp "+fullname);function processData(byteArray){function finish(byteArray){if(preFinish)preFinish();if(!dontCreateFile){FS.createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}if(onload)onload();removeRunDependency(dep)}var handled=false;Module["preloadPlugins"].forEach((function(plugin){if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,(function(){if(onerror)onerror();removeRunDependency(dep)}));handled=true}}));if(!handled)finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){Browser.asyncLoad(url,(function(byteArray){processData(byteArray)}),onerror)}else{processData(url)}}),indexedDB:(function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB}),DB_NAME:(function(){return"EM_FS_"+window.location.pathname}),DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=function openRequest_onupgradeneeded(){console.log("creating db");var db=openRequest.result;db.createObjectStore(FS.DB_STORE_NAME)};openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;var transaction=db.transaction([FS.DB_STORE_NAME],"readwrite");var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var putRequest=files.put(FS.analyzePath(path).object.contents,path);putRequest.onsuccess=function putRequest_onsuccess(){ok++;if(ok+fail==total)finish()};putRequest.onerror=function putRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror}),loadFilesFromDB:(function(paths,onload,onerror){onload=onload||(function(){});onerror=onerror||(function(){});var indexedDB=FS.indexedDB();try{var openRequest=indexedDB.open(FS.DB_NAME(),FS.DB_VERSION)}catch(e){return onerror(e)}openRequest.onupgradeneeded=onerror;openRequest.onsuccess=function openRequest_onsuccess(){var db=openRequest.result;try{var transaction=db.transaction([FS.DB_STORE_NAME],"readonly")}catch(e){onerror(e);return}var files=transaction.objectStore(FS.DB_STORE_NAME);var ok=0,fail=0,total=paths.length;function finish(){if(fail==0)onload();else onerror()}paths.forEach((function(path){var getRequest=files.get(path);getRequest.onsuccess=function getRequest_onsuccess(){if(FS.analyzePath(path).exists){FS.unlink(path)}FS.createDataFile(PATH.dirname(path),PATH.basename(path),getRequest.result,true,true,true);ok++;if(ok+fail==total)finish()};getRequest.onerror=function getRequest_onerror(){fail++;if(ok+fail==total)finish()}}));transaction.onerror=onerror};openRequest.onerror=onerror})};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:(function(dirfd,path){if(path[0]!=="/"){var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=FS.getStream(dirfd);if(!dirstream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);dir=dirstream.path}path=PATH.join2(dir,path)}return path}),doStat:(function(func,path,buf){try{var stat=func(path)}catch(e){if(e&&e.node&&PATH.normalize(path)!==PATH.normalize(FS.getPath(e.node))){return-ERRNO_CODES.ENOTDIR}throw e}HEAP32[buf>>2]=stat.dev;HEAP32[buf+4>>2]=0;HEAP32[buf+8>>2]=stat.ino;HEAP32[buf+12>>2]=stat.mode;HEAP32[buf+16>>2]=stat.nlink;HEAP32[buf+20>>2]=stat.uid;HEAP32[buf+24>>2]=stat.gid;HEAP32[buf+28>>2]=stat.rdev;HEAP32[buf+32>>2]=0;HEAP32[buf+36>>2]=stat.size;HEAP32[buf+40>>2]=4096;HEAP32[buf+44>>2]=stat.blocks;HEAP32[buf+48>>2]=stat.atime.getTime()/1e3|0;HEAP32[buf+52>>2]=0;HEAP32[buf+56>>2]=stat.mtime.getTime()/1e3|0;HEAP32[buf+60>>2]=0;HEAP32[buf+64>>2]=stat.ctime.getTime()/1e3|0;HEAP32[buf+68>>2]=0;HEAP32[buf+72>>2]=stat.ino;return 0}),doMsync:(function(addr,stream,len,flags){var buffer=new Uint8Array(HEAPU8.subarray(addr,addr+len));FS.msync(stream,buffer,0,len,flags)}),doMkdir:(function(path,mode){path=PATH.normalize(path);if(path[path.length-1]==="/")path=path.substr(0,path.length-1);FS.mkdir(path,mode,0);return 0}),doMknod:(function(path,mode,dev){switch(mode&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ERRNO_CODES.EINVAL}FS.mknod(path,mode,dev);return 0}),doReadlink:(function(path,buf,bufsize){if(bufsize<=0)return-ERRNO_CODES.EINVAL;var ret=FS.readlink(path);ret=ret.slice(0,Math.max(0,bufsize));writeStringToMemory(ret,buf,true);return ret.length}),doAccess:(function(path,amode){if(amode&~7){return-ERRNO_CODES.EINVAL}var node;var lookup=FS.lookupPath(path,{follow:true});node=lookup.node;var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-ERRNO_CODES.EACCES}return 0}),doDup:(function(path,flags,suggestFD){var suggest=FS.getStream(suggestFD);if(suggest)FS.close(suggest);return FS.open(path,flags,0,suggestFD,suggestFD).fd}),doReadv:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break}return ret}),doWritev:(function(stream,iov,iovcnt,offset){var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr}return ret}),varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),getStreamFromFD:(function(){var stream=FS.getStream(SYSCALLS.get());if(!stream)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return stream}),getSocketFromFD:(function(){var socket=SOCKFS.getSocket(SYSCALLS.get());if(!socket)throw new FS.ErrnoError(ERRNO_CODES.EBADF);return socket}),getSocketAddress:(function(allowNull){var addrp=SYSCALLS.get(),addrlen=SYSCALLS.get();if(allowNull&&addrp===0)return null;var info=__read_sockaddr(addrp,addrlen);if(info.errno)throw new FS.ErrnoError(info.errno);info.addr=DNS.lookup_addr(info.addr)||info.addr;return info}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall192(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get(),prot=SYSCALLS.get(),flags=SYSCALLS.get(),fd=SYSCALLS.get(),off=SYSCALLS.get();off<<=12;var ptr;var allocated=false;if(fd===-1){ptr=_malloc(len);if(!ptr)return-ERRNO_CODES.ENOMEM;_memset(ptr,0,len);allocated=true}else{var info=FS.getStream(fd);if(!info)return-ERRNO_CODES.EBADF;var res=FS.mmap(info,HEAPU8,addr,len,off,prot,flags);ptr=res.ptr;allocated=res.allocated}SYSCALLS.mappings[ptr]={malloc:ptr,len:len,allocated:allocated,fd:fd,flags:flags};return ptr}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall195(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall197(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),buf=SYSCALLS.get();return SYSCALLS.doStat(FS.stat,stream.path,buf)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _emscripten_check_longjmp=true;var _emscripten_cleanup_setjmp=true;var _emscripten_postinvoke=true;function _realloc(){throw"bad"}Module["_realloc"]=_realloc;Module["_saveSetjmp"]=_saveSetjmp;var _environ=allocate(1,"i32*",ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(!___buildEnvironment.called){___buildEnvironment.called=true;ENV["USER"]=ENV["LOGNAME"]="web_user";ENV["PATH"]="/";ENV["PWD"]="/";ENV["HOME"]="/home/web_user";ENV["LANG"]="C";ENV["_"]=Module["thisProgram"];poolPtr=allocate(TOTAL_ENV_SIZE,"i8",ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,"i8*",ALLOC_STATIC);HEAP32[envPtr>>2]=poolPtr;HEAP32[_environ>>2]=envPtr}else{envPtr=HEAP32[_environ>>2];poolPtr=HEAP32[envPtr>>2]}var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==="string"){var line=key+"="+env[key];strings.push(line);totalSize+=line.length}}if(totalSize>TOTAL_ENV_SIZE){throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")}var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];writeAsciiToMemory(line,poolPtr);HEAP32[envPtr+i*ptrSize>>2]=poolPtr;poolPtr+=line.length+1}HEAP32[envPtr+strings.length*ptrSize>>2]=0}var ENV={};function _setenv(envname,envval,overwrite){if(envname===0){___setErrNo(ERRNO_CODES.EINVAL);return-1}var name=Pointer_stringify(envname);var val=Pointer_stringify(envval);if(name===""||name.indexOf("=")!==-1){___setErrNo(ERRNO_CODES.EINVAL);return-1}if(ENV.hasOwnProperty(name)&&!overwrite)return 0;ENV[name]=val;___buildEnvironment(ENV);return 0}function ___syscall91(which,varargs){SYSCALLS.varargs=varargs;try{var addr=SYSCALLS.get(),len=SYSCALLS.get();var info=SYSCALLS.mappings[addr];if(!info)return 0;if(len===info.len){var stream=FS.getStream(info.fd);SYSCALLS.doMsync(addr,stream,len,info.flags);FS.munmap(stream);SYSCALLS.mappings[addr]=null;if(info.allocated){_free(info.malloc)}}return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function __exit(status){Module["exit"](status)}function _exit(status){__exit(status)}function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),op=SYSCALLS.get();switch(op){case 21505:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21506:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return 0};case 21519:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;var argp=SYSCALLS.get();HEAP32[argp>>2]=0;return 0};case 21520:{if(!stream.tty)return-ERRNO_CODES.ENOTTY;return-ERRNO_CODES.EINVAL};case 21531:{var argp=SYSCALLS.get();return FS.ioctl(stream,op,argp)};default:abort("bad ioctl syscall "+op)}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}Module["_bitshift64Lshr"]=_bitshift64Lshr;var _emscripten_prep_setjmp=true;function ___syscall33(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr(),amode=SYSCALLS.get();return SYSCALLS.doAccess(path,amode)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _BDtoIHigh=true;function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}Module["_testSetjmp"]=_testSetjmp;function _longjmp(env,value){asm["setThrew"](env,value||1);throw"longjmp"}function _emscripten_longjmp(env,value){_longjmp(env,value)}var _ceil=Math_ceil;function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;var _llvm_pow_f64=Math_pow;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;var _emscripten_preinvoke=true;var _BItoD=true;function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}var PROCINFO={ppid:1,pid:42,sid:42,pgid:42};function ___syscall20(which,varargs){SYSCALLS.varargs=varargs;try{return PROCINFO.pid}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["_memset"]=_memset;var _BDtoILow=true;Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}var _tan=Math_tan;function ___lock(){}function ___unlock(){}var _asin=Math_asin;var _llvm_fabs_f64=Math_abs;var _atanf=Math_atan;var _fabs=Math_abs;var _floor=Math_floor;var _sqrt=Math_sqrt;var _emscripten_asm_const_int=true;var _abs=Math_abs;function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};var _emscripten_get_longjmp_result=true;var _sin=Math_sin;var _exp=Math_exp;var _atan=Math_atan;function ___syscall10(which,varargs){SYSCALLS.varargs=varargs;try{var path=SYSCALLS.getStr();FS.unlink(path);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),"i8",ALLOC_NORMAL);return _getenv.ret}function ___syscall5(which,varargs){SYSCALLS.varargs=varargs;try{var pathname=SYSCALLS.getStr(),flags=SYSCALLS.get(),mode=SYSCALLS.get();var stream=FS.open(pathname,flags,mode);return stream.fd}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _acos=Math_acos;function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var _emscripten_setjmp=true;var _cos=Math_cos;function _times(buffer){if(buffer!==0){_memset(buffer,0,16)}return 0}var _atan2=Math_atan2;function ___syscall265(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doWritev(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall221(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),cmd=SYSCALLS.get();switch(cmd){case 0:{var arg=SYSCALLS.get();if(arg<0){return-ERRNO_CODES.EINVAL}var newStream;newStream=FS.open(stream.path,stream.flags,0,arg);return newStream.fd};case 1:case 2:return 0;case 3:return stream.flags;case 4:{var arg=SYSCALLS.get();stream.flags|=arg;return 0};case 12:case 12:{var arg=SYSCALLS.get();var offset=0;HEAP16[arg+offset>>1]=2;return 0};case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ERRNO_CODES.EINVAL;case 9:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:{return-ERRNO_CODES.EINVAL}}}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}FS.staticInit();__ATINIT__.unshift((function(){if(!Module["noFSInit"]&&!FS.init.initialized)FS.init()}));__ATMAIN__.push((function(){FS.ignorePermissions=false}));__ATEXIT__.push((function(){FS.quit()}));Module["FS_createFolder"]=FS.createFolder;Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createLink"]=FS.createLink;Module["FS_createDevice"]=FS.createDevice;Module["FS_unlink"]=FS.unlink;__ATINIT__.unshift((function(){TTY.init()}));__ATEXIT__.push((function(){TTY.shutdown()}));if(ENVIRONMENT_IS_NODE){var fs=require("fs");var NODEJS_PATH=require("path");NODEFS.staticInit()}___buildEnvironment(ENV);Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiidd(index,a1,a2,a3,a4){try{return Module["dynCall_iiidd"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_dddd(index,a1,a2,a3){try{return Module["dynCall_dddd"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_d(index){try{return Module["dynCall_d"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiddi(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiddi"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_viiiii":invoke_viiiii,"invoke_vi":invoke_vi,"invoke_iiidd":invoke_iiidd,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_iiiiii":invoke_iiiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiii":invoke_viiiiii,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_dddd":invoke_dddd,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_iii":invoke_iii,"invoke_d":invoke_d,"invoke_i":invoke_i,"invoke_viiiddi":invoke_viiiddi,"invoke_iiiii":invoke_iiiii,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viiii":invoke_viiii,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_fabs":_fabs,"_sin":_sin,"_exp":_exp,"_llvm_pow_f64":_llvm_pow_f64,"___syscall265":___syscall265,"___syscall146":___syscall146,"_abort":_abort,"_llvm_fabs_f64":_llvm_fabs_f64,"_atan2":_atan2,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"___syscall20":___syscall20,"___assert_fail":___assert_fail,"_floor":_floor,"_asin":_asin,"___buildEnvironment":___buildEnvironment,"_longjmp":_longjmp,"_cos":_cos,"_times":_times,"___setErrNo":___setErrNo,"_sbrk":_sbrk,"___syscall192":___syscall192,"___syscall197":___syscall197,"___syscall195":___syscall195,"_sysconf":_sysconf,"_ceil":_ceil,"___syscall221":___syscall221,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___syscall91":___syscall91,"_atanf":_atanf,"_atan":_atan,"_pthread_self":_pthread_self,"_acos":_acos,"_getenv":_getenv,"_sqrt":_sqrt,"___syscall33":___syscall33,"___syscall54":___syscall54,"___unlock":___unlock,"_emscripten_set_main_loop":_emscripten_set_main_loop,"___syscall10":___syscall10,"___syscall5":___syscall5,"_tan":_tan,"__exit":__exit,"___lock":___lock,"___syscall6":___syscall6,"_pthread_cleanup_push":_pthread_cleanup_push,"_setenv":_setenv,"_time":_time,"_emscripten_longjmp":_emscripten_longjmp,"_abs":_abs,"___syscall140":___syscall140,"_exit":_exit,"___syscall145":___syscall145,"_emscripten_asm_const_1":_emscripten_asm_const_1,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0.0,y=0,z=0,A=0,B=0.0;var C=0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=global.Math.floor;var N=global.Math.abs;var O=global.Math.sqrt;var P=global.Math.pow;var Q=global.Math.cos;var R=global.Math.sin;var S=global.Math.tan;var T=global.Math.acos;var U=global.Math.asin;var V=global.Math.atan;var W=global.Math.atan2;var X=global.Math.exp;var Y=global.Math.log;var Z=global.Math.ceil;var _=global.Math.imul;var $=global.Math.min;var aa=global.Math.clz32;var ba=env.abort;var ca=env.assert;var da=env.invoke_viiiii;var ea=env.invoke_vi;var fa=env.invoke_iiidd;var ga=env.invoke_vii;var ha=env.invoke_iiiiiiiiiii;var ia=env.invoke_ii;var ja=env.invoke_iiiiii;var ka=env.invoke_iiii;var la=env.invoke_viiiiii;var ma=env.invoke_di;var na=env.invoke_iiiiiii;var oa=env.invoke_dddd;var pa=env.invoke_viiiiiii;var qa=env.invoke_viiiiiiiii;var ra=env.invoke_iii;var sa=env.invoke_d;var ta=env.invoke_i;var ua=env.invoke_viiiddi;var va=env.invoke_iiiii;var wa=env.invoke_viii;var xa=env.invoke_v;var ya=env.invoke_viiii;var za=env._pthread_cleanup_pop;var Aa=env._fabs;var Ba=env._sin;var Ca=env._exp;var Da=env._llvm_pow_f64;var Ea=env.___syscall265;var Fa=env.___syscall146;var Ga=env._abort;var Ha=env._llvm_fabs_f64;var Ia=env._atan2;var Ja=env._emscripten_set_main_loop_timing;var Ka=env.___syscall20;var La=env.___assert_fail;var Ma=env._floor;var Na=env._asin;var Oa=env.___buildEnvironment;var Pa=env._longjmp;var Qa=env._cos;var Ra=env._times;var Sa=env.___setErrNo;var Ta=env._sbrk;var Ua=env.___syscall192;var Va=env.___syscall197;var Wa=env.___syscall195;var Xa=env._sysconf;var Ya=env._ceil;var Za=env.___syscall221;var _a=env._emscripten_memcpy_big;var $a=env.___syscall91;var ab=env._atanf;var bb=env._atan;var cb=env._pthread_self;var db=env._acos;var eb=env._getenv;var fb=env._sqrt;var gb=env.___syscall33;var hb=env.___syscall54;var ib=env.___unlock;var jb=env._emscripten_set_main_loop;var kb=env.___syscall10;var lb=env.___syscall5;var mb=env._tan;var nb=env.__exit;var ob=env.___lock;var pb=env.___syscall6;var qb=env._pthread_cleanup_push;var rb=env._setenv;var sb=env._time;var tb=env._emscripten_longjmp;var ub=env._abs;var vb=env.___syscall140;var wb=env._exit;var xb=env.___syscall145;var yb=env._emscripten_asm_const_1;var zb=0.0;
// EMSCRIPTEN_START_FUNCS
function qz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=(c[(c[(c[g>>2]|0)+8>>2]|0)+112>>2]|0)+4|0;c[d>>2]=c[d>>2]|1;c[j>>2]=TA(c[f>>2]|0,c[g>>2]|0)|0;while(1){if(!(c[j>>2]|0))break;d=c[j>>2]|0;c[k>>2]=c[((c[c[j>>2]>>2]&3|0)==2?d:d+-32|0)+28>>2];if((c[k>>2]|0)==(c[g>>2]|0)){d=c[j>>2]|0;c[k>>2]=c[((c[c[j>>2]>>2]&3|0)==3?d:d+32|0)+28>>2]}if(!(c[(c[(c[(c[k>>2]|0)+8>>2]|0)+112>>2]|0)+4>>2]&1)){YA(c[h>>2]|0,c[j>>2]|0,1)|0;c[(c[(c[(c[k>>2]|0)+8>>2]|0)+112>>2]|0)+16>>2]=c[g>>2];qz(c[f>>2]|0,c[k>>2]|0,c[h>>2]|0)}c[j>>2]=UA(c[f>>2]|0,c[j>>2]|0,c[g>>2]|0)|0}i=e;return}function rz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=i;i=i+176|0;e=d+8|0;f=d;g=d+44|0;h=d+40|0;j=d+36|0;k=d+32|0;l=d+28|0;m=d+24|0;n=d+20|0;o=d+16|0;p=d+12|0;q=d+48|0;c[g>>2]=a;c[h>>2]=b;b=c[12966]|0;c[12966]=b+1;c[f>>2]=b;k3(q,133960,f)|0;c[j>>2]=FD(c[g>>2]|0,q,1)|0;MC(c[j>>2]|0,175049,280,1)|0;f=c[12966]|0;c[12966]=f+1;c[e>>2]=f;k3(q,133960,e)|0;c[e>>2]=c[(c[g>>2]|0)+12>>2];c[k>>2]=gB(q,e,0)|0;c[l>>2]=$B(c[g>>2]|0)|0;while(1){if(!(c[l>>2]|0))break;eC(c[j>>2]|0,c[l>>2]|0,1)|0;e=c[k>>2]|0;c[m>>2]=fC(e,wB(c[l>>2]|0)|0,1)|0;MC(c[m>>2]|0,175026,304,1)|0;c[(c[(c[(c[l>>2]|0)+8>>2]|0)+112>>2]|0)+16>>2]=c[m>>2];c[l>>2]=aC(c[g>>2]|0,c[l>>2]|0)|0}c[l>>2]=$B(c[g>>2]|0)|0;while(1){if(!(c[l>>2]|0))break;c[m>>2]=c[(c[(c[(c[l>>2]|0)+8>>2]|0)+112>>2]|0)+16>>2];c[o>>2]=OA(c[g>>2]|0,c[l>>2]|0)|0;while(1){if(!(c[o>>2]|0))break;YA(c[j>>2]|0,c[o>>2]|0,1)|0;e=c[o>>2]|0;c[n>>2]=c[(c[(c[(c[((c[c[o>>2]>>2]&3|0)==2?e:e+-32|0)+28>>2]|0)+8>>2]|0)+112>>2]|0)+16>>2];c[p>>2]=VA(c[k>>2]|0,c[m>>2]|0,c[n>>2]|0,0,1)|0;MC(c[p>>2]|0,175319,176,1)|0;c[(c[(c[p>>2]|0)+8>>2]|0)+116>>2]=c[o>>2];e=(c[(c[m>>2]|0)+8>>2]|0)+236|0;c[e>>2]=(c[e>>2]|0)+1;e=(c[(c[n>>2]|0)+8>>2]|0)+236|0;c[e>>2]=(c[e>>2]|0)+1;c[o>>2]=QA(c[g>>2]|0,c[o>>2]|0)|0}c[l>>2]=aC(c[g>>2]|0,c[l>>2]|0)|0}c[c[h>>2]>>2]=c[k>>2];i=d;return c[j>>2]|0}function sz(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[e>>2]=uz()|0;c[f>>2]=$B(c[d>>2]|0)|0;while(1){g=c[e>>2]|0;if(!(c[f>>2]|0))break;wz(g,c[f>>2]|0);c[f>>2]=aC(c[d>>2]|0,c[f>>2]|0)|0}i=b;return g|0}function tz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;e=i;i=i+80|0;f=e+72|0;g=e+68|0;h=e+64|0;j=e+60|0;k=e+56|0;l=e+52|0;m=e+48|0;n=e+44|0;o=e+40|0;p=e+36|0;q=e+32|0;r=e+28|0;s=e+24|0;t=e+20|0;u=e+16|0;v=e+12|0;w=e+8|0;x=e+4|0;y=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[s>>2]=0;c[t>>2]=0;c[v>>2]=0;c[u>>2]=c[(c[(c[g>>2]|0)+8>>2]|0)+236>>2];c[j>>2]=cK(c[u>>2]<<2)|0;c[k>>2]=cK(c[u>>2]<<2)|0;c[l>>2]=TA(c[f>>2]|0,c[g>>2]|0)|0;while(1){if(!(c[l>>2]|0))break;d=c[l>>2]|0;c[o>>2]=c[((c[c[l>>2]>>2]&3|0)==2?d:d+-32|0)+28>>2];if((c[o>>2]|0)==(c[g>>2]|0)){d=c[l>>2]|0;c[o>>2]=c[((c[c[l>>2]>>2]&3|0)==3?d:d+32|0)+28>>2]}c[q>>2]=0;c[m>>2]=TA(c[f>>2]|0,c[g>>2]|0)|0;while(1){if(!(c[m>>2]|0))break;if((c[m>>2]|0)!=(c[l>>2]|0)){d=c[m>>2]|0;c[p>>2]=c[((c[c[m>>2]>>2]&3|0)==2?d:d+-32|0)+28>>2];if((c[p>>2]|0)==(c[g>>2]|0)){d=c[m>>2]|0;c[p>>2]=c[((c[c[m>>2]>>2]&3|0)==3?d:d+32|0)+28>>2]}c[n>>2]=VA(c[f>>2]|0,c[o>>2]|0,c[p>>2]|0,0,0)|0;if(((c[n>>2]|0)!=0?(c[q>>2]=1,(c[o>>2]|0)>>>0<(c[p>>2]|0)>>>0):0)?(c[v>>2]=(c[v>>2]|0)+1,(c[(c[(c[n>>2]|0)+8>>2]|0)+116>>2]|0)!=0):0){pC(c[h>>2]|0,c[(c[(c[n>>2]|0)+8>>2]|0)+116>>2]|0)|0;c[(c[(c[n>>2]|0)+8>>2]|0)+116>>2]=0}}c[m>>2]=UA(c[f>>2]|0,c[m>>2]|0,c[g>>2]|0)|0}d=c[o>>2]|0;if(c[q>>2]|0){c[(c[j>>2]|0)+(c[s>>2]<<2)>>2]=d;c[s>>2]=(c[s>>2]|0)+1}else{c[(c[k>>2]|0)+(c[t>>2]<<2)>>2]=d;c[t>>2]=(c[t>>2]|0)+1}c[l>>2]=UA(c[f>>2]|0,c[l>>2]|0,c[g>>2]|0)|0}c[r>>2]=(c[u>>2]|0)-1-(c[v>>2]|0);if((c[r>>2]|0)<=0){z=c[k>>2]|0;O4(z);A=c[j>>2]|0;O4(A);i=e;return}if((c[r>>2]|0)>=(c[t>>2]|0)){if((c[r>>2]|0)!=(c[t>>2]|0)){z=c[k>>2]|0;O4(z);A=c[j>>2]|0;O4(A);i=e;return}c[y>>2]=c[c[j>>2]>>2];c[w>>2]=0;while(1){if((c[w>>2]|0)>=(c[t>>2]|0))break;c[x>>2]=c[(c[k>>2]|0)+(c[w>>2]<<2)>>2];MC(VA(c[f>>2]|0,c[y>>2]|0,c[x>>2]|0,0,1)|0,175319,176,1)|0;v=(c[(c[y>>2]|0)+8>>2]|0)+236|0;c[v>>2]=(c[v>>2]|0)+1;v=(c[(c[x>>2]|0)+8>>2]|0)+236|0;c[v>>2]=(c[v>>2]|0)+1;c[w>>2]=(c[w>>2]|0)+1}z=c[k>>2]|0;O4(z);A=c[j>>2]|0;O4(A);i=e;return}c[w>>2]=0;while(1){if((c[w>>2]|0)>=(c[t>>2]|0))break;if(((c[w>>2]|0)+1|0)>=(c[t>>2]|0))break;c[y>>2]=c[(c[k>>2]|0)+(c[w>>2]<<2)>>2];c[x>>2]=c[(c[k>>2]|0)+((c[w>>2]|0)+1<<2)>>2];MC(VA(c[f>>2]|0,c[y>>2]|0,c[x>>2]|0,0,1)|0,175319,176,1)|0;v=(c[(c[y>>2]|0)+8>>2]|0)+236|0;c[v>>2]=(c[v>>2]|0)+1;v=(c[(c[x>>2]|0)+8>>2]|0)+236|0;c[v>>2]=(c[v>>2]|0)+1;c[r>>2]=(c[r>>2]|0)+-1;c[w>>2]=(c[w>>2]|0)+2}c[w>>2]=2;while(1){if((c[r>>2]|0)<=0)break;c[y>>2]=c[c[k>>2]>>2];c[x>>2]=c[(c[k>>2]|0)+(c[w>>2]<<2)>>2];MC(VA(c[f>>2]|0,c[y>>2]|0,c[x>>2]|0,0,1)|0,175319,176,1)|0;t=(c[(c[y>>2]|0)+8>>2]|0)+236|0;c[t>>2]=(c[t>>2]|0)+1;t=(c[(c[x>>2]|0)+8>>2]|0)+236|0;c[t>>2]=(c[t>>2]|0)+1;c[w>>2]=(c[w>>2]|0)+1;c[r>>2]=(c[r>>2]|0)+-1}z=c[k>>2]|0;O4(z);A=c[j>>2]|0;O4(A);i=e;return}function uz(){var a=0,b=0;a=i;i=i+16|0;b=a;c[b>>2]=Nz(51868,c[12989]|0)|0;i=a;return c[b>>2]|0}function vz(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;Jz(c[d>>2]|0)|0;i=b;return}function wz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+32|0;e=d+28|0;f=d+24|0;g=d+8|0;h=d;c[e>>2]=a;c[f>>2]=b;c[g+8>>2]=c[(c[(c[f>>2]|0)+8>>2]|0)+236>>2];c[h>>2]=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,1)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+164>>2]=c[(c[h>>2]|0)+12>>2];c[(c[h>>2]|0)+12>>2]=c[f>>2];i=d;return}function xz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+48|0;e=d+36|0;f=d+32|0;g=d+16|0;h=d+8|0;j=d+4|0;k=d;c[e>>2]=a;c[f>>2]=b;c[g+8>>2]=c[(c[(c[f>>2]|0)+8>>2]|0)+236>>2];c[h>>2]=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,4)|0;if(!(c[h>>2]|0))La(133970,133973,107,133983);if((c[(c[h>>2]|0)+12>>2]|0)==(c[f>>2]|0)){c[(c[h>>2]|0)+12>>2]=c[(c[(c[f>>2]|0)+8>>2]|0)+164>>2];if(c[(c[h>>2]|0)+12>>2]|0){i=d;return}Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,c[h>>2]|0,2)|0;i=d;return}c[k>>2]=c[(c[h>>2]|0)+12>>2];c[j>>2]=c[(c[(c[k>>2]|0)+8>>2]|0)+164>>2];while(1){if(c[j>>2]|0)l=(c[j>>2]|0)!=(c[f>>2]|0);else l=0;m=c[j>>2]|0;if(!l)break;c[k>>2]=m;c[j>>2]=c[(c[(c[j>>2]|0)+8>>2]|0)+164>>2]}if(!m){i=d;return}c[(c[(c[k>>2]|0)+8>>2]|0)+164>>2]=c[(c[(c[j>>2]|0)+8>>2]|0)+164>>2];i=d;return}function yz(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[e>>2]=a;c[f>>2]=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,0,128)|0;if(!(c[f>>2]|0)){c[d>>2]=0;h=c[d>>2]|0;i=b;return h|0}c[g>>2]=c[(c[f>>2]|0)+12>>2];c[(c[f>>2]|0)+12>>2]=c[(c[(c[g>>2]|0)+8>>2]|0)+164>>2];if(!(c[(c[f>>2]|0)+12>>2]|0))Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,c[f>>2]|0,2)|0;c[d>>2]=c[g>>2];h=c[d>>2]|0;i=b;return h|0}function zz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=cK(16)|0;c[(c[g>>2]|0)+12>>2]=0;c[(c[g>>2]|0)+8>>2]=c[(c[f>>2]|0)+8>>2];i=e;return c[g>>2]|0}function Az(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e+4|0;c[e+8>>2]=a;c[f>>2]=b;c[e>>2]=d;O4(c[f>>2]|0);i=e;return}function Bz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f+16|0;h=f+8|0;j=f+4|0;c[f+12>>2]=a;c[h>>2]=b;c[j>>2]=d;c[f>>2]=e;do if((c[c[h>>2]>>2]|0)>=(c[c[j>>2]>>2]|0))if((c[c[h>>2]>>2]|0)>(c[c[j>>2]>>2]|0)){c[g>>2]=1;break}else{c[g>>2]=0;break}else c[g>>2]=-1;while(0);i=f;return c[g>>2]|0}function Cz(){var a=0,b=0;a=i;i=i+16|0;b=a;c[b>>2]=Nz(51904,c[12989]|0)|0;i=a;return c[b>>2]|0}function Dz(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;Jz(c[d>>2]|0)|0;i=b;return}function Ez(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g+8>>2]=c[f>>2];Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,1)|0;i=d;return}function Fz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g+8>>2]=c[f>>2];Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,2)|0;i=d;return}function Gz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=cK(12)|0;c[(c[g>>2]|0)+8>>2]=c[(c[f>>2]|0)+8>>2];i=e;return c[g>>2]|0}function Hz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e+4|0;c[e+8>>2]=a;c[f>>2]=b;c[e>>2]=d;O4(c[f>>2]|0);i=e;return}function Iz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f+16|0;h=f+8|0;j=f+4|0;c[f+12>>2]=a;c[h>>2]=b;c[j>>2]=d;c[f>>2]=e;do if((c[c[h>>2]>>2]|0)>>>0<=(c[c[j>>2]>>2]|0)>>>0)if((c[c[h>>2]>>2]|0)>>>0<(c[c[j>>2]>>2]|0)>>>0){c[g>>2]=-1;break}else{c[g>>2]=0;break}else c[g>>2]=1;while(0);i=f;return c[g>>2]|0}function Jz(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[e>>2]=a;c[g>>2]=0;if((c[e>>2]|0)!=0?(c[(c[e>>2]|0)+24>>2]|0)<=0:0){c[f>>2]=c[(c[e>>2]|0)+4>>2];if((c[(c[f>>2]|0)+32>>2]|0)!=0?(a=Sb[c[(c[f>>2]|0)+32>>2]&127](c[e>>2]|0,2,0,c[f>>2]|0)|0,c[g>>2]=a,(a|0)<0):0){c[d>>2]=-1;h=c[d>>2]|0;i=b;return h|0}if(c[(c[e>>2]|0)+28>>2]|0)Sz(c[e>>2]|0,0)|0;if(!(c[g>>2]|0)){Hb[c[c[(c[e>>2]|0)+16>>2]>>2]&63](c[e>>2]|0,0,64)|0;if((Pz(c[e>>2]|0)|0)>0){c[d>>2]=-1;h=c[d>>2]|0;i=b;return h|0}if((c[(c[(c[e>>2]|0)+8>>2]|0)+12>>2]|0)>0)Sb[c[(c[e>>2]|0)+12>>2]&127](c[e>>2]|0,c[(c[(c[e>>2]|0)+8>>2]|0)+8>>2]|0,0,c[f>>2]|0)|0;Sb[c[(c[e>>2]|0)+12>>2]&127](c[e>>2]|0,c[(c[e>>2]|0)+8>>2]|0,0,c[f>>2]|0)|0}if(c[(c[e>>2]|0)+20>>2]|0){if((c[g>>2]|0)==0?(c[(c[e>>2]|0)+20>>2]|0)==1:0)Sb[c[(c[e>>2]|0)+12>>2]&127](c[e>>2]|0,c[e>>2]|0,0,c[f>>2]|0)|0}else O4(c[e>>2]|0);if(c[(c[f>>2]|0)+32>>2]|0)Sb[c[(c[f>>2]|0)+32>>2]&127](c[e>>2]|0,6,0,c[f>>2]|0)|0;c[d>>2]=0;h=c[d>>2]|0;i=b;return h|0}c[d>>2]=-1;h=c[d>>2]|0;i=b;return h|0}function Kz(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[d>>2]=a;a=c[(c[d>>2]|0)+8>>2]|0;a:do if(c[c[(c[d>>2]|0)+8>>2]>>2]&12)c[e>>2]=c[a+4>>2];else{h=c[d>>2]|0;if(!(c[a>>2]&3)){c[e>>2]=c[(c[h+8>>2]|0)+8>>2];c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]=0;break}c[e>>2]=Lz(h)|0;h=c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]|0;c[f>>2]=h;c[g>>2]=h+(c[(c[(c[d>>2]|0)+8>>2]|0)+12>>2]<<2);while(1){if((c[f>>2]|0)>>>0>=(c[g>>2]|0)>>>0)break a;c[c[f>>2]>>2]=0;c[f>>2]=(c[f>>2]|0)+4}}while(0);f=c[(c[d>>2]|0)+8>>2]|0;c[f>>2]=c[f>>2]&-4097;c[(c[(c[d>>2]|0)+8>>2]|0)+16>>2]=0;c[(c[(c[d>>2]|0)+8>>2]|0)+4>>2]=0;i=b;return c[e>>2]|0}function Lz(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;b=i;i=i+32|0;d=b+28|0;e=b+24|0;f=b+20|0;g=b+16|0;h=b+12|0;j=b+8|0;k=b+4|0;l=b;c[e>>2]=a;if(c[c[(c[e>>2]|0)+8>>2]>>2]&4096){c[d>>2]=c[(c[(c[e>>2]|0)+8>>2]|0)+4>>2];m=c[d>>2]|0;i=b;return m|0}c[j>>2]=0;c[h>>2]=0;a=c[(c[e>>2]|0)+8>>2]|0;a:do if(!(c[c[(c[e>>2]|0)+8>>2]>>2]&3)){n=c[(c[e>>2]|0)+8>>2]|0;if(c[a>>2]&112){c[h>>2]=c[n+8>>2];break}o=c[n+4>>2]|0;c[g>>2]=o;if(o){while(1){o=c[(c[g>>2]|0)+4>>2]|0;c[f>>2]=o;if(!o)break;c[(c[g>>2]|0)+4>>2]=c[c[f>>2]>>2];c[c[f>>2]>>2]=c[g>>2];c[g>>2]=c[f>>2]}o=c[g>>2]|0;c[j>>2]=o;c[h>>2]=o;c[g>>2]=c[c[g>>2]>>2];while(1){if(!(c[g>>2]|0))break a;o=c[(c[g>>2]|0)+4>>2]|0;c[f>>2]=o;if(o){do{c[(c[g>>2]|0)+4>>2]=c[c[f>>2]>>2];c[c[f>>2]>>2]=c[g>>2];c[g>>2]=c[f>>2];o=c[(c[g>>2]|0)+4>>2]|0;c[f>>2]=o}while((o|0)!=0);c[c[j>>2]>>2]=c[g>>2]}c[j>>2]=c[g>>2];c[g>>2]=c[c[g>>2]>>2]}}}else{o=c[a+8>>2]|0;c[k>>2]=o;c[l>>2]=o+(c[(c[(c[e>>2]|0)+8>>2]|0)+12>>2]<<2);while(1){if((c[k>>2]|0)>>>0>=(c[l>>2]|0)>>>0)break a;o=c[c[k>>2]>>2]|0;c[f>>2]=o;if(o){o=c[f>>2]|0;if(c[j>>2]|0)c[c[j>>2]>>2]=o;else{c[j>>2]=o;c[h>>2]=o}while(1){p=c[j>>2]|0;if(!(c[c[j>>2]>>2]|0))break;c[j>>2]=c[p>>2]}c[c[k>>2]>>2]=p}c[k>>2]=(c[k>>2]|0)+4}}while(0);c[(c[(c[e>>2]|0)+8>>2]|0)+4>>2]=c[h>>2];k=c[(c[e>>2]|0)+8>>2]|0;c[k>>2]=c[k>>2]|4096;c[d>>2]=c[h>>2];m=c[d>>2]|0;i=b;return m|0}function Mz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;e=i;i=i+64|0;f=e+48|0;g=e+44|0;h=e+40|0;j=e+36|0;k=e+32|0;l=e+28|0;m=e+24|0;n=e+20|0;o=e+16|0;p=e+12|0;q=e+8|0;r=e+4|0;s=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if(c[c[(c[g>>2]|0)+8>>2]>>2]&4096)Oz(c[g>>2]|0,0)|0;c[o>>2]=c[(c[g>>2]|0)+4>>2];c[m>>2]=c[c[o>>2]>>2];c[l>>2]=c[(c[o>>2]|0)+4>>2];c[k>>2]=c[(c[o>>2]|0)+8>>2];c[n>>2]=c[(c[o>>2]|0)+20>>2];d=(c[g>>2]|0)+20|0;c[d>>2]=c[d>>2]&-32769;d=c[j>>2]|0;do if(c[h>>2]|0){if(!(d&2049)){if((c[j>>2]&512|0)==0?(b=c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]|0,c[p>>2]=b,(b|0)!=0):0){b=c[p>>2]|0;if((c[k>>2]|0)<0)t=c[b+8>>2]|0;else t=b+(0-(c[k>>2]|0))|0;if((t|0)!=(c[h>>2]|0))u=78}else u=78;a:do if((u|0)==78){if(!(c[j>>2]&512)){b=(c[h>>2]|0)+(c[m>>2]|0)|0;if((c[l>>2]|0)<0)v=c[b>>2]|0;else v=b}else v=c[h>>2]|0;c[r>>2]=v;c[p>>2]=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2];while(1){if(!(c[p>>2]|0))break a;b=c[p>>2]|0;if((c[k>>2]|0)<0)w=c[b+8>>2]|0;else w=b+(0-(c[k>>2]|0))|0;c[s>>2]=w;b=(c[s>>2]|0)+(c[m>>2]|0)|0;if((c[l>>2]|0)<0)x=c[b>>2]|0;else x=b;c[s>>2]=x;do if(!(c[n>>2]|0)){b=c[r>>2]|0;a=c[s>>2]|0;if((c[l>>2]|0)<=0){y=J3(b,a)|0;break}else{y=B3(b,a,c[l>>2]|0)|0;break}}else y=Sb[c[n>>2]&127](c[g>>2]|0,c[r>>2]|0,c[s>>2]|0,c[o>>2]|0)|0;while(0);if(!y)break a;c[p>>2]=c[c[p>>2]>>2]}}while(0);if(!(c[p>>2]|0)){c[f>>2]=0;z=c[f>>2]|0;i=e;return z|0}a=(c[g>>2]|0)+20|0;c[a>>2]=c[a>>2]|32768;if(c[j>>2]&4098)break;if(!(c[j>>2]&8)){if(c[j>>2]&16){if((c[p>>2]|0)==(c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0))A=0;else A=c[(c[p>>2]|0)+4>>2]|0;c[p>>2]=A}}else c[p>>2]=c[c[p>>2]>>2];c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=c[p>>2];do if(c[p>>2]|0){a=c[p>>2]|0;if((c[k>>2]|0)<0){B=c[a+8>>2]|0;break}else{B=a+(0-(c[k>>2]|0))|0;break}}else B=0;while(0);c[f>>2]=B;z=c[f>>2]|0;i=e;return z|0}if(((c[(c[o>>2]|0)+12>>2]|0)!=0?(c[j>>2]&1|0)!=0:0)?(a=Hb[c[(c[o>>2]|0)+12>>2]&63](c[g>>2]|0,c[h>>2]|0,c[o>>2]|0)|0,c[h>>2]=a,(a|0)==0):0){c[f>>2]=0;z=c[f>>2]|0;i=e;return z|0}do if((c[k>>2]|0)>=0)c[p>>2]=(c[h>>2]|0)+(c[k>>2]|0);else{c[p>>2]=Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,0,12,c[o>>2]|0)|0;if(c[p>>2]|0){c[(c[p>>2]|0)+8>>2]=c[h>>2];break}if(((c[(c[o>>2]|0)+12>>2]|0)!=0?(c[(c[o>>2]|0)+16>>2]|0)!=0:0)?(c[j>>2]&1|0)!=0:0)Tb[c[(c[o>>2]|0)+16>>2]&127](c[g>>2]|0,c[h>>2]|0,c[o>>2]|0);c[f>>2]=0;z=c[f>>2]|0;i=e;return z|0}while(0);do if(c[c[(c[g>>2]|0)+8>>2]>>2]&128)if(c[j>>2]&8192)u=62;else u=58;else{if(!(c[c[(c[g>>2]|0)+8>>2]>>2]&16))if(c[c[(c[g>>2]|0)+8>>2]>>2]&32){u=58;break}else{u=62;break}a=(c[j>>2]&8192|0)!=0;b=c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]|0;c[q>>2]=b;C=(b|0)!=0;if(a){if(!C){u=62;break}if(!(c[c[q>>2]>>2]|0)){u=62;break}c[c[p>>2]>>2]=c[c[q>>2]>>2];c[(c[c[p>>2]>>2]|0)+4>>2]=c[p>>2];c[(c[p>>2]|0)+4>>2]=c[q>>2];c[c[(c[p>>2]|0)+4>>2]>>2]=c[p>>2];break}else{if(!C){u=58;break}if((c[q>>2]|0)==(c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0)){u=58;break}c[(c[p>>2]|0)+4>>2]=c[(c[q>>2]|0)+4>>2];c[c[(c[p>>2]|0)+4>>2]>>2]=c[p>>2];c[c[p>>2]>>2]=c[q>>2];c[(c[c[p>>2]>>2]|0)+4>>2]=c[p>>2];break}}while(0);if((u|0)==58){C=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0;c[q>>2]=C;c[c[p>>2]>>2]=C;if(c[q>>2]|0){c[(c[p>>2]|0)+4>>2]=c[(c[q>>2]|0)+4>>2];c[(c[q>>2]|0)+4>>2]=c[p>>2]}else c[(c[p>>2]|0)+4>>2]=c[p>>2];c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]=c[p>>2]}else if((u|0)==62){C=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0;c[q>>2]=C;a=c[p>>2]|0;if(C){c[c[(c[q>>2]|0)+4>>2]>>2]=a;c[(c[p>>2]|0)+4>>2]=c[(c[q>>2]|0)+4>>2];c[(c[q>>2]|0)+4>>2]=c[p>>2]}else{c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]=a;c[(c[p>>2]|0)+4>>2]=c[p>>2]}c[c[p>>2]>>2]=0}if((c[(c[(c[g>>2]|0)+8>>2]|0)+16>>2]|0)>=0){a=(c[(c[g>>2]|0)+8>>2]|0)+16|0;c[a>>2]=(c[a>>2]|0)+1}c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=c[p>>2];a=c[p>>2]|0;if((c[k>>2]|0)<0)D=c[a+8>>2]|0;else D=a+(0-(c[k>>2]|0))|0;c[f>>2]=D;z=c[f>>2]|0;i=e;return z|0}else{if(d&384){a=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0;c[p>>2]=a;if(a){if(c[j>>2]&256)c[p>>2]=c[(c[p>>2]|0)+4>>2];c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=c[p>>2]}do if(c[p>>2]|0){a=c[p>>2]|0;if((c[k>>2]|0)<0){E=c[a+8>>2]|0;break}else{E=a+(0-(c[k>>2]|0))|0;break}}else E=0;while(0);c[f>>2]=E;z=c[f>>2]|0;i=e;return z|0}if(c[j>>2]&4098){if((c[c[(c[g>>2]|0)+8>>2]>>2]&144|0)==0?(a=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0,c[p>>2]=a,(a|0)!=0):0)break;c[f>>2]=0;z=c[f>>2]|0;i=e;return z|0}if(!(c[j>>2]&64)){c[f>>2]=0;z=c[f>>2]|0;i=e;return z|0}if(!((c[(c[o>>2]|0)+16>>2]|0)==0?(c[(c[o>>2]|0)+8>>2]|0)>=0:0))u=21;b:do if((u|0)==21){c[p>>2]=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2];while(1){if(!(c[p>>2]|0))break b;c[q>>2]=c[c[p>>2]>>2];if(c[(c[o>>2]|0)+16>>2]|0){a=c[p>>2]|0;if((c[k>>2]|0)<0)F=c[a+8>>2]|0;else F=a+(0-(c[k>>2]|0))|0;Tb[c[(c[o>>2]|0)+16>>2]&127](c[g>>2]|0,F,c[o>>2]|0)}if((c[(c[o>>2]|0)+8>>2]|0)<0)Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,c[p>>2]|0,0,c[o>>2]|0)|0;c[p>>2]=c[q>>2]}}while(0);c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=0;c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]=0;c[(c[(c[g>>2]|0)+8>>2]|0)+16>>2]=0;c[f>>2]=0;z=c[f>>2]|0;i=e;return z|0}while(0);if(c[c[p>>2]>>2]|0)c[(c[c[p>>2]>>2]|0)+4>>2]=c[(c[p>>2]|0)+4>>2];F=c[p>>2]|0;u=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0;c[q>>2]=u;E=c[c[p>>2]>>2]|0;if((F|0)==(u|0)){c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]=E;if(c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0)c[(c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]=c[(c[q>>2]|0)+4>>2]}else{c[c[(c[p>>2]|0)+4>>2]>>2]=E;if((c[p>>2]|0)==(c[(c[q>>2]|0)+4>>2]|0))c[(c[q>>2]|0)+4>>2]=c[(c[p>>2]|0)+4>>2]}if((c[p>>2]|0)==(c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]|0))G=c[c[p>>2]>>2]|0;else G=0;c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=G;G=(c[(c[g>>2]|0)+8>>2]|0)+16|0;c[G>>2]=(c[G>>2]|0)-1;G=c[p>>2]|0;if((c[k>>2]|0)<0)H=c[G+8>>2]|0;else H=G+(0-(c[k>>2]|0))|0;c[h>>2]=H;if((c[(c[o>>2]|0)+16>>2]|0)!=0?(c[j>>2]&2|0)!=0:0)Tb[c[(c[o>>2]|0)+16>>2]&127](c[g>>2]|0,c[h>>2]|0,c[o>>2]|0);if((c[(c[o>>2]|0)+8>>2]|0)<0)Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,c[p>>2]|0,0,c[o>>2]|0)|0;c[f>>2]=c[h>>2];z=c[f>>2]|0;i=e;return z|0}function Nz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;k=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=c[12988];if(!((c[f>>2]|0)!=0&(c[g>>2]|0)!=0)){c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}b=N4(40)|0;c[h>>2]=b;if(!b){c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}c[c[h>>2]>>2]=0;c[(c[h>>2]|0)+16>>2]=0;c[(c[h>>2]|0)+4>>2]=0;Vz(c[h>>2]|0,c[f>>2]|0,0)|0;c[(c[h>>2]|0)+20>>2]=0;c[(c[h>>2]|0)+24>>2]=0;c[(c[h>>2]|0)+32>>2]=0;c[(c[h>>2]|0)+28>>2]=0;c[(c[h>>2]|0)+36>>2]=0;do if(c[(c[f>>2]|0)+32>>2]|0){c[k>>2]=0;b=Sb[c[(c[f>>2]|0)+32>>2]&127](c[h>>2]|0,1,k,c[f>>2]|0)|0;c[j>>2]=b;if((b|0)>=0)if((c[j>>2]|0)>0){if(c[k>>2]|0)if(c[c[k>>2]>>2]&c[(c[g>>2]|0)+4>>2])break;else{m=15;break}if(c[(c[f>>2]|0)+28>>2]|0){O4(c[h>>2]|0);b=Sb[c[(c[f>>2]|0)+28>>2]&127](0,0,40,c[f>>2]|0)|0;c[h>>2]=b;if(b){c[c[h>>2]>>2]=0;c[(c[h>>2]|0)+16>>2]=0;c[(c[h>>2]|0)+4>>2]=0;Vz(c[h>>2]|0,c[f>>2]|0,0)|0;c[(c[h>>2]|0)+20>>2]=1;c[(c[h>>2]|0)+24>>2]=0;c[(c[h>>2]|0)+32>>2]=0;c[(c[h>>2]|0)+28>>2]=0;m=14;break}c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}else m=15}else m=14;else m=15}else m=14;while(0);if((m|0)==14){j=Sb[c[(c[h>>2]|0)+12>>2]&127](c[h>>2]|0,0,28,c[f>>2]|0)|0;c[k>>2]=j;if(j){c[c[k>>2]>>2]=c[(c[g>>2]|0)+4>>2];c[(c[k>>2]|0)+4>>2]=0;c[(c[k>>2]|0)+8>>2]=0;c[(c[k>>2]|0)+20>>2]=0;c[(c[k>>2]|0)+16>>2]=0;c[(c[k>>2]|0)+12>>2]=0;c[(c[k>>2]|0)+24>>2]=0}else m=15}if((m|0)==15){O4(c[h>>2]|0);c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}c[(c[h>>2]|0)+8>>2]=c[k>>2];c[c[h>>2]>>2]=c[c[g>>2]>>2];c[(c[h>>2]|0)+16>>2]=c[g>>2];if(c[(c[f>>2]|0)+32>>2]|0)Sb[c[(c[f>>2]|0)+32>>2]&127](c[h>>2]|0,5,c[h>>2]|0,c[f>>2]|0)|0;c[e>>2]=c[h>>2];l=c[e>>2]|0;i=d;return l|0}function Oz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;i=i+32|0;e=d+28|0;f=d+24|0;g=d+20|0;h=d+16|0;j=d+12|0;k=d+8|0;l=d+4|0;m=d;c[f>>2]=a;c[g>>2]=b;c[m>>2]=c[c[(c[f>>2]|0)+16>>2]>>2];c[l>>2]=c[c[(c[f>>2]|0)+8>>2]>>2]&4096;do if(c[g>>2]|0){if(!(c[(c[(c[f>>2]|0)+8>>2]|0)+16>>2]|0)){c[l>>2]=0;break}c[e>>2]=-1;n=c[e>>2]|0;i=d;return n|0}else{if(c[l>>2]|0){c[g>>2]=c[(c[(c[f>>2]|0)+8>>2]|0)+4>>2];break}c[e>>2]=-1;n=c[e>>2]|0;i=d;return n|0}while(0);b=c[(c[f>>2]|0)+8>>2]|0;c[b>>2]=c[b>>2]&-4097;b=c[(c[f>>2]|0)+8>>2]|0;a:do if(!(c[c[(c[f>>2]|0)+8>>2]>>2]&3)){if(c[b>>2]&12)c[(c[(c[f>>2]|0)+8>>2]|0)+4>>2]=c[g>>2];else{c[(c[(c[f>>2]|0)+8>>2]|0)+4>>2]=0;c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]=c[g>>2]}if(!(c[l>>2]|0))c[(c[(c[f>>2]|0)+8>>2]|0)+16>>2]=-1}else{c[b+4>>2]=0;a=c[(c[f>>2]|0)+8>>2]|0;if(!(c[l>>2]|0)){c[a+16>>2]=0;while(1){if(!(c[g>>2]|0))break a;c[h>>2]=c[c[g>>2]>>2];Hb[c[m>>2]&63](c[f>>2]|0,c[g>>2]|0,32)|0;c[g>>2]=c[h>>2]}}o=c[a+8>>2]|0;c[j>>2]=o;c[k>>2]=o+(c[(c[(c[f>>2]|0)+8>>2]|0)+12>>2]<<2);while(1){if((c[j>>2]|0)>>>0>=(c[k>>2]|0)>>>0)break a;o=c[c[j>>2]>>2]|0;c[h>>2]=o;if(o){c[c[j>>2]>>2]=c[g>>2];c[g>>2]=c[c[h>>2]>>2];c[c[h>>2]>>2]=0}c[j>>2]=(c[j>>2]|0)+4}}while(0);c[e>>2]=0;n=c[e>>2]|0;i=d;return n|0}function Pz(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;if(c[c[(c[d>>2]|0)+8>>2]>>2]&4096)Oz(c[d>>2]|0,0)|0;do if((c[(c[(c[d>>2]|0)+8>>2]|0)+16>>2]|0)<0){a=c[(c[d>>2]|0)+8>>2]|0;if(c[c[(c[d>>2]|0)+8>>2]>>2]&12){g=Qz(c[a+4>>2]|0)|0;c[(c[(c[d>>2]|0)+8>>2]|0)+16>>2]=g;break}if(c[a>>2]&112){c[f>>2]=0;c[e>>2]=c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2];while(1){h=c[f>>2]|0;if(!(c[e>>2]|0))break;c[f>>2]=h+1;c[e>>2]=c[c[e>>2]>>2]}c[(c[(c[d>>2]|0)+8>>2]|0)+16>>2]=h}}while(0);i=b;return c[(c[(c[d>>2]|0)+8>>2]|0)+16>>2]|0}function Qz(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if(!(c[d>>2]|0)){e=0;i=b;return e|0}a=Qz(c[(c[d>>2]|0)+4>>2]|0)|0;e=a+(Qz(c[c[d>>2]>>2]|0)|0)+1|0;i=b;return e|0}function Rz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0;e=i;i=i+208|0;f=e+204|0;g=e+200|0;h=e+196|0;j=e+192|0;k=e+188|0;l=e+184|0;m=e+180|0;n=e+176|0;o=e+172|0;p=e+168|0;q=e+164|0;r=e+160|0;s=e+156|0;t=e+152|0;u=e+148|0;v=e+144|0;w=e+136|0;x=e+132|0;y=e+128|0;z=e+8|0;A=e+4|0;B=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if(c[c[(c[g>>2]|0)+8>>2]>>2]&4096)Oz(c[g>>2]|0,0)|0;c[B>>2]=c[(c[g>>2]|0)+4>>2];c[p>>2]=c[c[B>>2]>>2];c[o>>2]=c[(c[B>>2]|0)+4>>2];c[n>>2]=c[(c[B>>2]|0)+8>>2];c[A>>2]=c[(c[B>>2]|0)+20>>2];d=(c[g>>2]|0)+20|0;c[d>>2]=c[d>>2]&-32769;c[k>>2]=c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2];if(!(c[h>>2]|0)){if((c[k>>2]|0)!=0?(c[j>>2]&448|0)!=0:0){if(!(c[j>>2]&64)){a:do if(c[j>>2]&256)while(1){d=c[c[k>>2]>>2]|0;c[l>>2]=d;if(!d)break a;c[c[k>>2]>>2]=c[(c[l>>2]|0)+4>>2];c[(c[l>>2]|0)+4>>2]=c[k>>2];c[k>>2]=c[l>>2]}else while(1){d=c[(c[k>>2]|0)+4>>2]|0;c[l>>2]=d;if(!d)break a;c[(c[k>>2]|0)+4>>2]=c[c[l>>2]>>2];c[c[l>>2]>>2]=c[k>>2];c[k>>2]=c[l>>2]}while(0);c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=c[k>>2];d=c[k>>2]|0;if((c[n>>2]|0)<0)C=c[d+8>>2]|0;else C=d+(0-(c[n>>2]|0))|0;c[f>>2]=C;D=c[f>>2]|0;i=e;return D|0}if(!((c[(c[B>>2]|0)+16>>2]|0)==0?(c[(c[B>>2]|0)+8>>2]|0)>=0:0))E=10;if((E|0)==10)while(1){E=0;C=c[(c[k>>2]|0)+4>>2]|0;c[l>>2]=C;if(C){c[(c[k>>2]|0)+4>>2]=c[c[l>>2]>>2];c[c[l>>2]>>2]=c[k>>2];c[k>>2]=c[l>>2];E=10;continue}c[l>>2]=c[c[k>>2]>>2];if(c[(c[B>>2]|0)+16>>2]|0){C=c[k>>2]|0;if((c[n>>2]|0)<0)F=c[C+8>>2]|0;else F=C+(0-(c[n>>2]|0))|0;Tb[c[(c[B>>2]|0)+16>>2]&127](c[g>>2]|0,F,c[B>>2]|0)}if((c[(c[B>>2]|0)+8>>2]|0)<0)Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,c[k>>2]|0,0,c[B>>2]|0)|0;C=c[l>>2]|0;c[k>>2]=C;if(C)E=10;else break}c[(c[(c[g>>2]|0)+8>>2]|0)+16>>2]=0;c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=0;c[f>>2]=0;D=c[f>>2]|0;i=e;return D|0}c[f>>2]=0;D=c[f>>2]|0;i=e;return D|0}c[u>>2]=w;c[t>>2]=w;b:do if((c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]|0)==8?(c[j>>2]&4098|0)!=0:0){F=(c[h>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)G=c[F>>2]|0;else G=F;c[s>>2]=G;c[q>>2]=Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,c[h>>2]|0,4)|0;while(1){if(!(c[q>>2]|0)){E=47;break b}F=(c[q>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)H=c[F>>2]|0;else H=F;c[r>>2]=H;do if(!(c[A>>2]|0)){F=c[s>>2]|0;C=c[r>>2]|0;if((c[o>>2]|0)<=0){I=J3(F,C)|0;break}else{I=B3(F,C,c[o>>2]|0)|0;break}}else I=Sb[c[A>>2]&127](c[g>>2]|0,c[s>>2]|0,c[r>>2]|0,c[B>>2]|0)|0;while(0);if(I){E=47;break b}J=c[g>>2]|0;if((c[q>>2]|0)==(c[h>>2]|0))break;c[q>>2]=Hb[c[J>>2]&63](c[g>>2]|0,c[q>>2]|0,8)|0}c[k>>2]=c[(c[J+8>>2]|0)+4>>2];c[c[t>>2]>>2]=c[(c[k>>2]|0)+4>>2];c[(c[u>>2]|0)+4>>2]=c[c[k>>2]>>2];E=192}else E=47;while(0);c:do if((E|0)==47){J=c[j>>2]|0;do if(c[j>>2]&2565){if(!(J&512)){q=(c[h>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)K=c[q>>2]|0;else K=q}else K=c[h>>2]|0;c[s>>2]=K;if(c[k>>2]|0)E=68}else{if(J&32){c[v>>2]=c[h>>2];q=c[v>>2]|0;if((c[n>>2]|0)<0)L=c[q+8>>2]|0;else L=q+(0-(c[n>>2]|0))|0;c[h>>2]=L;q=(c[h>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)M=c[q>>2]|0;else M=q;c[s>>2]=M;if(c[k>>2]|0){E=68;break}else break}if(c[k>>2]|0){q=c[k>>2]|0;if((c[n>>2]|0)<0)N=c[q+8>>2]|0;else N=q+(0-(c[n>>2]|0))|0;if((N|0)!=(c[h>>2]|0)){q=(c[h>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)O=c[q>>2]|0;else O=q;c[s>>2]=O;E=68}}}while(0);d:do if((E|0)==68){e:do if(((c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]|0)==4?(J=c[(c[(c[g>>2]|0)+8>>2]|0)+24>>2]|0,c[y>>2]=J,(J|0)!=0):0)?(c[j>>2]&516|0)!=0:0){c[l>>2]=c[k>>2];c[x>>2]=0;while(1){if((c[x>>2]|0)>=(c[y>>2]|0)){E=94;break}J=c[l>>2]|0;if((c[n>>2]|0)<0)P=c[J+8>>2]|0;else P=J+(0-(c[n>>2]|0))|0;c[r>>2]=P;J=(c[r>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)Q=c[J>>2]|0;else Q=J;c[r>>2]=Q;do if(!(c[A>>2]|0)){J=c[s>>2]|0;q=c[r>>2]|0;if((c[o>>2]|0)<=0){R=J3(J,q)|0;break}else{R=B3(J,q,c[o>>2]|0)|0;break}}else R=Sb[c[A>>2]&127](c[g>>2]|0,c[s>>2]|0,c[r>>2]|0,c[B>>2]|0)|0;while(0);c[m>>2]=R;if(!R){E=84;break}c[z+(c[x>>2]<<2)>>2]=c[m>>2];q=c[l>>2]|0;if((c[m>>2]|0)<0)S=c[q+4>>2]|0;else S=c[q>>2]|0;c[l>>2]=S;if(!S){E=92;break}c[x>>2]=(c[x>>2]|0)+1}if((E|0)==84){q=c[l>>2]|0;if((c[n>>2]|0)<0)T=c[q+8>>2]|0;else T=q+(0-(c[n>>2]|0))|0;c[f>>2]=T;D=c[f>>2]|0;i=e;return D|0}else if((E|0)==92){c[f>>2]=0;D=c[f>>2]|0;i=e;return D|0}else if((E|0)==94){c[x>>2]=0;while(1){if((c[x>>2]|0)>=(c[y>>2]|0))break e;q=c[k>>2]|0;do if((c[z+(c[x>>2]<<2)>>2]|0)<0){c[l>>2]=c[q+4>>2];J=c[l>>2]|0;if((c[z+((c[x>>2]|0)+1<<2)>>2]|0)<0){c[(c[k>>2]|0)+4>>2]=c[J>>2];c[c[l>>2]>>2]=c[k>>2];I=c[l>>2]|0;c[(c[u>>2]|0)+4>>2]=I;c[u>>2]=I;c[k>>2]=c[(c[l>>2]|0)+4>>2];break}else{c[c[t>>2]>>2]=J;c[t>>2]=J;J=c[k>>2]|0;c[(c[u>>2]|0)+4>>2]=J;c[u>>2]=J;c[k>>2]=c[c[l>>2]>>2];break}}else{c[l>>2]=c[q>>2];J=c[l>>2]|0;if((c[z+((c[x>>2]|0)+1<<2)>>2]|0)>0){c[c[k>>2]>>2]=c[J+4>>2];c[(c[l>>2]|0)+4>>2]=c[k>>2];I=c[l>>2]|0;c[c[t>>2]>>2]=I;c[t>>2]=I;c[k>>2]=c[c[l>>2]>>2];break}else{c[(c[u>>2]|0)+4>>2]=J;c[u>>2]=J;J=c[k>>2]|0;c[c[t>>2]>>2]=J;c[t>>2]=J;c[k>>2]=c[(c[l>>2]|0)+4>>2];break}}while(0);c[x>>2]=(c[x>>2]|0)+2}}}while(0);while(1){q=c[k>>2]|0;if((c[n>>2]|0)<0)U=c[q+8>>2]|0;else U=q+(0-(c[n>>2]|0))|0;c[r>>2]=U;q=(c[r>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)V=c[q>>2]|0;else V=q;c[r>>2]=V;do if(!(c[A>>2]|0)){q=c[s>>2]|0;J=c[r>>2]|0;if((c[o>>2]|0)<=0){W=J3(q,J)|0;break}else{W=B3(q,J,c[o>>2]|0)|0;break}}else W=Sb[c[A>>2]&127](c[g>>2]|0,c[s>>2]|0,c[r>>2]|0,c[B>>2]|0)|0;while(0);c[m>>2]=W;if(!W)break d;J=c[k>>2]|0;if((c[m>>2]|0)<0){q=c[J+4>>2]|0;c[l>>2]=q;if(!q){E=132;break}q=c[l>>2]|0;if((c[n>>2]|0)<0)X=c[q+8>>2]|0;else X=q+(0-(c[n>>2]|0))|0;c[r>>2]=X;q=(c[r>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)Y=c[q>>2]|0;else Y=q;c[r>>2]=Y;do if(!(c[A>>2]|0)){q=c[s>>2]|0;I=c[r>>2]|0;if((c[o>>2]|0)<=0){Z=J3(q,I)|0;break}else{Z=B3(q,I,c[o>>2]|0)|0;break}}else Z=Sb[c[A>>2]&127](c[g>>2]|0,c[s>>2]|0,c[r>>2]|0,c[B>>2]|0)|0;while(0);c[m>>2]=Z;if((Z|0)<0){c[(c[k>>2]|0)+4>>2]=c[c[l>>2]>>2];c[c[l>>2]>>2]=c[k>>2];I=c[l>>2]|0;c[(c[u>>2]|0)+4>>2]=I;c[u>>2]=I;I=c[(c[l>>2]|0)+4>>2]|0;c[k>>2]=I;if(I)continue;else break d}if(!(c[m>>2]|0)){E=130;break}I=c[l>>2]|0;c[c[t>>2]>>2]=I;c[t>>2]=I;I=c[k>>2]|0;c[(c[u>>2]|0)+4>>2]=I;c[u>>2]=I;I=c[c[l>>2]>>2]|0;c[k>>2]=I;if(I)continue;else break d}else{I=c[J>>2]|0;c[l>>2]=I;if(!I){E=149;break}I=c[l>>2]|0;if((c[n>>2]|0)<0)_=c[I+8>>2]|0;else _=I+(0-(c[n>>2]|0))|0;c[r>>2]=_;I=(c[r>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)$=c[I>>2]|0;else $=I;c[r>>2]=$;do if(!(c[A>>2]|0)){I=c[s>>2]|0;q=c[r>>2]|0;if((c[o>>2]|0)<=0){aa=J3(I,q)|0;break}else{aa=B3(I,q,c[o>>2]|0)|0;break}}else aa=Sb[c[A>>2]&127](c[g>>2]|0,c[s>>2]|0,c[r>>2]|0,c[B>>2]|0)|0;while(0);c[m>>2]=aa;if((aa|0)>0){c[c[k>>2]>>2]=c[(c[l>>2]|0)+4>>2];c[(c[l>>2]|0)+4>>2]=c[k>>2];J=c[l>>2]|0;c[c[t>>2]>>2]=J;c[t>>2]=J;J=c[c[l>>2]>>2]|0;c[k>>2]=J;if(J)continue;else break d}if(!(c[m>>2]|0)){E=147;break}J=c[l>>2]|0;c[(c[u>>2]|0)+4>>2]=J;c[u>>2]=J;J=c[k>>2]|0;c[c[t>>2]>>2]=J;c[t>>2]=J;J=c[(c[l>>2]|0)+4>>2]|0;c[k>>2]=J;if(J)continue;else break d}}if((E|0)==130){J=c[k>>2]|0;c[(c[u>>2]|0)+4>>2]=J;c[u>>2]=J;c[k>>2]=c[l>>2];break}else if((E|0)==132){J=c[k>>2]|0;c[(c[u>>2]|0)+4>>2]=J;c[u>>2]=J;c[k>>2]=0;break}else if((E|0)==147){J=c[k>>2]|0;c[c[t>>2]>>2]=J;c[t>>2]=J;c[k>>2]=c[l>>2];break}else if((E|0)==149){J=c[k>>2]|0;c[c[t>>2]>>2]=J;c[t>>2]=J;c[k>>2]=0;break}}while(0);do if(c[k>>2]|0){J=(c[g>>2]|0)+20|0;c[J>>2]=c[J>>2]|32768;c[c[t>>2]>>2]=c[(c[k>>2]|0)+4>>2];c[(c[u>>2]|0)+4>>2]=c[c[k>>2]>>2];if(!(c[j>>2]&516)){if(c[j>>2]&8){c[(c[k>>2]|0)+4>>2]=c[w>>2];c[c[k>>2]>>2]=0;c[w>>2]=c[k>>2];E=181;break}if(c[j>>2]&16){c[c[k>>2]>>2]=c[w+4>>2];c[(c[k>>2]|0)+4>>2]=0;c[w+4>>2]=c[k>>2];E=187;break}if(c[j>>2]&4098){E=192;break c}if(c[j>>2]&2049){if(c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]&4)break;c[(c[k>>2]|0)+4>>2]=0;c[c[k>>2]>>2]=c[w+4>>2];c[w+4>>2]=c[k>>2];E=219;break}if(!(c[j>>2]&32)){c[f>>2]=0;D=c[f>>2]|0;i=e;return D|0}if(!(c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]&4)){c[(c[v>>2]|0)+4>>2]=0;c[c[v>>2]>>2]=c[w+4>>2];c[w+4>>2]=c[v>>2];J=(c[(c[g>>2]|0)+8>>2]|0)+16|0;c[J>>2]=(c[J>>2]|0)+1;break}if(c[(c[B>>2]|0)+16>>2]|0)Tb[c[(c[B>>2]|0)+16>>2]&127](c[g>>2]|0,c[h>>2]|0,c[B>>2]|0);if((c[(c[B>>2]|0)+8>>2]|0)<0)Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,c[v>>2]|0,0,c[B>>2]|0)|0}}else{c[(c[u>>2]|0)+4>>2]=0;c[c[t>>2]>>2]=0;if(!(c[j>>2]&8))if(!(c[j>>2]&16)){if(c[j>>2]&516)break c;if(!(c[j>>2]&2049))if(c[j>>2]&32){c[k>>2]=c[v>>2];J=(c[(c[g>>2]|0)+8>>2]|0)+16|0;c[J>>2]=(c[J>>2]|0)+1;break}else{c[h>>2]=0;break c}else E=219}else E=187;else E=181}while(0);if((E|0)==181){J=c[w+4>>2]|0;c[k>>2]=J;if(!J)break;while(1){J=c[(c[k>>2]|0)+4>>2]|0;c[l>>2]=J;if(!J)break;c[(c[k>>2]|0)+4>>2]=c[c[l>>2]>>2];c[c[l>>2]>>2]=c[k>>2];c[k>>2]=c[l>>2]}c[w+4>>2]=c[c[k>>2]>>2]}else if((E|0)==187){J=c[w>>2]|0;c[k>>2]=J;if(!J)break;while(1){J=c[c[k>>2]>>2]|0;c[l>>2]=J;if(!J)break;c[c[k>>2]>>2]=c[(c[l>>2]|0)+4>>2];c[(c[l>>2]|0)+4>>2]=c[k>>2];c[k>>2]=c[l>>2]}c[w>>2]=c[(c[k>>2]|0)+4>>2]}else if((E|0)==219){if((c[(c[B>>2]|0)+12>>2]|0)!=0?(c[j>>2]&1|0)!=0:0)c[h>>2]=Hb[c[(c[B>>2]|0)+12>>2]&63](c[g>>2]|0,c[h>>2]|0,c[B>>2]|0)|0;do if(c[h>>2]|0){if((c[n>>2]|0)>=0){c[k>>2]=(c[h>>2]|0)+(c[n>>2]|0);break}c[k>>2]=Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,0,12,c[B>>2]|0)|0;if(c[k>>2]|0){c[(c[k>>2]|0)+8>>2]=c[h>>2];break}if(((c[(c[B>>2]|0)+12>>2]|0)!=0?(c[(c[B>>2]|0)+16>>2]|0)!=0:0)?(c[j>>2]&1|0)!=0:0)Tb[c[(c[B>>2]|0)+16>>2]&127](c[g>>2]|0,c[h>>2]|0,c[B>>2]|0)}while(0);if(!(c[k>>2]|0))break;if((c[(c[(c[g>>2]|0)+8>>2]|0)+16>>2]|0)>=0){J=(c[(c[g>>2]|0)+8>>2]|0)+16|0;c[J>>2]=(c[J>>2]|0)+1}}c[(c[k>>2]|0)+4>>2]=c[w>>2];c[c[k>>2]>>2]=c[w+4>>2];f:do if((c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]&8|0)!=0?(c[j>>2]&516|0)!=0:0){J=c[k>>2]|0;if((c[n>>2]|0)<0)ba=c[J+8>>2]|0;else ba=J+(0-(c[n>>2]|0))|0;c[s>>2]=ba;J=(c[s>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)ca=c[J>>2]|0;else ca=J;c[s>>2]=ca;while(1){J=c[(c[k>>2]|0)+4>>2]|0;c[l>>2]=J;if(!J)break f;while(1){J=c[c[l>>2]>>2]|0;c[u>>2]=J;if(!J)break;c[c[l>>2]>>2]=c[(c[u>>2]|0)+4>>2];c[(c[u>>2]|0)+4>>2]=c[l>>2];c[l>>2]=c[u>>2]}c[(c[k>>2]|0)+4>>2]=c[l>>2];J=c[l>>2]|0;if((c[n>>2]|0)<0)da=c[J+8>>2]|0;else da=J+(0-(c[n>>2]|0))|0;c[r>>2]=da;J=(c[r>>2]|0)+(c[p>>2]|0)|0;if((c[o>>2]|0)<0)ea=c[J>>2]|0;else ea=J;c[r>>2]=ea;do if(!(c[A>>2]|0)){J=c[s>>2]|0;q=c[r>>2]|0;if((c[o>>2]|0)<=0){fa=J3(J,q)|0;break}else{fa=B3(J,q,c[o>>2]|0)|0;break}}else fa=Sb[c[A>>2]&127](c[g>>2]|0,c[s>>2]|0,c[r>>2]|0,c[B>>2]|0)|0;while(0);if(fa)break f;c[(c[k>>2]|0)+4>>2]=c[c[l>>2]>>2];c[c[l>>2]>>2]=c[k>>2];c[k>>2]=c[l>>2]}}while(0);c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=c[k>>2];q=c[k>>2]|0;if((c[n>>2]|0)<0)ga=c[q+8>>2]|0;else ga=q+(0-(c[n>>2]|0))|0;c[f>>2]=ga;D=c[f>>2]|0;i=e;return D|0}while(0);if((E|0)==192){E=c[k>>2]|0;if((c[n>>2]|0)<0)ha=c[E+8>>2]|0;else ha=E+(0-(c[n>>2]|0))|0;c[h>>2]=ha;if((c[(c[B>>2]|0)+16>>2]|0)!=0?(c[j>>2]&2|0)!=0:0)Tb[c[(c[B>>2]|0)+16>>2]&127](c[g>>2]|0,c[h>>2]|0,c[B>>2]|0);if((c[(c[B>>2]|0)+8>>2]|0)<0)Sb[c[(c[g>>2]|0)+12>>2]&127](c[g>>2]|0,c[k>>2]|0,0,c[B>>2]|0)|0;B=(c[(c[g>>2]|0)+8>>2]|0)+16|0;k=(c[B>>2]|0)-1|0;c[B>>2]=k;if((k|0)<0)c[(c[(c[g>>2]|0)+8>>2]|0)+16>>2]=-1}while(1){k=c[(c[u>>2]|0)+4>>2]|0;c[l>>2]=k;if(!k)break;c[u>>2]=c[l>>2]}c[(c[u>>2]|0)+4>>2]=c[w>>2];c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=c[w+4>>2];c[f>>2]=(c[j>>2]&2|0)!=0?c[h>>2]|0:0;D=c[f>>2]|0;i=e;return D|0}function Sz(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;if(c[c[(c[f>>2]|0)+8>>2]>>2]&4096)Oz(c[f>>2]|0,0)|0;if(c[g>>2]|0){if(c[c[(c[g>>2]|0)+8>>2]>>2]&4096)Oz(c[g>>2]|0,0)|0;if((c[(c[g>>2]|0)+16>>2]|0)!=(c[(c[f>>2]|0)+16>>2]|0)){c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}}c[h>>2]=c[g>>2];while(1){if(!(c[h>>2]|0))break;if((c[h>>2]|0)==(c[f>>2]|0)){k=11;break}c[h>>2]=c[(c[h>>2]|0)+28>>2]}if((k|0)==11){c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}k=c[(c[f>>2]|0)+28>>2]|0;c[h>>2]=k;if(k){k=(c[h>>2]|0)+24|0;c[k>>2]=(c[k>>2]|0)-1}c[(c[f>>2]|0)+32>>2]=0;c[(c[f>>2]|0)+28>>2]=0;if(c[g>>2]|0){c[(c[f>>2]|0)+28>>2]=c[g>>2];c[c[f>>2]>>2]=33;k=(c[g>>2]|0)+24|0;c[k>>2]=(c[k>>2]|0)+1;c[e>>2]=c[g>>2];j=c[e>>2]|0;i=d;return j|0}else{c[c[f>>2]>>2]=c[c[(c[f>>2]|0)+16>>2]>>2];c[e>>2]=c[h>>2];j=c[e>>2]|0;i=d;return j|0}return 0}function Tz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;e=i;i=i+64|0;f=e+56|0;g=e+52|0;h=e+48|0;j=e+44|0;k=e+40|0;l=e+36|0;m=e+32|0;n=e+28|0;o=e+24|0;p=e+20|0;q=e+16|0;r=e+12|0;s=e+8|0;t=e+4|0;u=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if(c[j>>2]&99){c[f>>2]=Hb[c[c[(c[g>>2]|0)+16>>2]>>2]&63](c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;v=c[f>>2]|0;i=e;return v|0}do if(!(c[j>>2]&516)){if((c[j>>2]&384|0)!=0?(c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]&12|0)==0:0)break;d=c[j>>2]|0;if(c[(c[(c[g>>2]|0)+16>>2]|0)+4>>2]&12){if(!(d&408)){c[f>>2]=0;v=c[f>>2]|0;i=e;return v|0}c[p>>2]=0;c[n>>2]=0;c[l>>2]=0;c[k>>2]=c[g>>2];while(1){if(!(c[k>>2]|0))break;b=Hb[c[c[(c[k>>2]|0)+16>>2]>>2]&63](c[k>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;c[m>>2]=b;do if(b){c[t>>2]=c[c[(c[k>>2]|0)+4>>2]>>2];c[s>>2]=c[(c[(c[k>>2]|0)+4>>2]|0)+4>>2];c[r>>2]=c[(c[(c[k>>2]|0)+4>>2]|0)+8>>2];c[u>>2]=c[(c[(c[k>>2]|0)+4>>2]|0)+20>>2];a=(c[m>>2]|0)+(c[t>>2]|0)|0;if((c[s>>2]|0)<0)w=c[a>>2]|0;else w=a;c[o>>2]=w;if(c[n>>2]|0){do if(!(c[u>>2]|0)){a=c[o>>2]|0;x=c[p>>2]|0;if((c[s>>2]|0)<=0){y=J3(a,x)|0;break}else{y=B3(a,x,c[s>>2]|0)|0;break}}else y=Sb[c[u>>2]&127](c[k>>2]|0,c[o>>2]|0,c[p>>2]|0,c[(c[k>>2]|0)+4>>2]|0)|0;while(0);c[q>>2]=y;if(!((c[j>>2]&136|0)!=0&(c[q>>2]|0)<0)?!((c[j>>2]&272|0)!=0&(c[q>>2]|0)>0):0)break}c[l>>2]=c[k>>2];c[n>>2]=c[m>>2];c[p>>2]=c[o>>2]}while(0);c[k>>2]=c[(c[k>>2]|0)+28>>2]}c[(c[g>>2]|0)+32>>2]=c[l>>2];c[f>>2]=c[n>>2];v=c[f>>2]|0;i=e;return v|0}if(!(d&24)){c[f>>2]=0;v=c[f>>2]|0;i=e;return v|0}if(c[(c[g>>2]|0)+32>>2]|0){b=c[(c[(c[(c[g>>2]|0)+32>>2]|0)+8>>2]|0)+4>>2]|0;if((c[(c[(c[(c[g>>2]|0)+32>>2]|0)+4>>2]|0)+8>>2]|0)<0)z=c[b+8>>2]|0;else z=b+(0-(c[(c[(c[(c[g>>2]|0)+32>>2]|0)+4>>2]|0)+8>>2]|0))|0;if((c[h>>2]|0)!=(z|0))A=37}else A=37;if((A|0)==37){c[k>>2]=c[g>>2];while(1){if(!(c[k>>2]|0))break;b=Hb[c[c[(c[k>>2]|0)+16>>2]>>2]&63](c[k>>2]|0,c[h>>2]|0,4)|0;c[m>>2]=b;if(b)break;c[k>>2]=c[(c[k>>2]|0)+28>>2]}c[(c[g>>2]|0)+32>>2]=c[k>>2];d=c[m>>2]|0;c[h>>2]=d;if(!d){c[f>>2]=0;v=c[f>>2]|0;i=e;return v|0}}c[k>>2]=c[(c[g>>2]|0)+32>>2];c[h>>2]=Hb[c[c[(c[k>>2]|0)+16>>2]>>2]&63](c[k>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;a:while(1){if(!(c[h>>2]|0)){d=c[(c[k>>2]|0)+28>>2]|0;c[(c[g>>2]|0)+32>>2]=d;c[k>>2]=d;if(!d){A=52;break}d=c[c[(c[k>>2]|0)+16>>2]>>2]|0;b=c[k>>2]|0;if(c[j>>2]&8){c[h>>2]=Hb[d&63](b,0,128)|0;continue}else{c[h>>2]=Hb[d&63](b,0,256)|0;continue}}c[l>>2]=c[g>>2];while(1){if((c[l>>2]|0)==(c[k>>2]|0)){A=47;break a}if(Hb[c[c[(c[l>>2]|0)+16>>2]>>2]&63](c[l>>2]|0,c[h>>2]|0,4)|0)break;c[l>>2]=c[(c[l>>2]|0)+28>>2]}c[h>>2]=Hb[c[c[(c[k>>2]|0)+16>>2]>>2]&63](c[k>>2]|0,c[h>>2]|0,c[j>>2]|0)|0}if((A|0)==47){c[f>>2]=c[h>>2];v=c[f>>2]|0;i=e;return v|0}else if((A|0)==52){c[f>>2]=0;v=c[f>>2]|0;i=e;return v|0}}while(0);c[k>>2]=c[g>>2];while(1){if(!(c[k>>2]|0))break;A=Hb[c[c[(c[k>>2]|0)+16>>2]>>2]&63](c[k>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;c[m>>2]=A;if(A)break;c[k>>2]=c[(c[k>>2]|0)+28>>2]}c[(c[g>>2]|0)+32>>2]=c[k>>2];c[f>>2]=c[m>>2];v=c[f>>2]|0;i=e;return v|0}function Uz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=i;i=i+32|0;f=e+28|0;g=e+24|0;h=e+20|0;j=e+16|0;k=e+12|0;l=e+8|0;m=e+4|0;n=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,0,128)|0;while(1){if(!(c[k>>2]|0)){o=8;break}d=c[(c[g>>2]|0)+32>>2]|0;c[m>>2]=d;if(!d)c[m>>2]=c[g>>2];c[l>>2]=Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,c[k>>2]|0,8)|0;d=Hb[c[h>>2]&63](c[m>>2]|0,c[k>>2]|0,c[j>>2]|0)|0;c[n>>2]=d;if((d|0)<0){o=6;break}c[k>>2]=c[l>>2]}if((o|0)==6){c[f>>2]=c[n>>2];p=c[f>>2]|0;i=e;return p|0}else if((o|0)==8){c[f>>2]=0;p=c[f>>2]|0;i=e;return p|0}return 0}function Vz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;e=i;i=i+48|0;f=e+40|0;g=e+36|0;h=e+32|0;j=e+28|0;k=e+24|0;l=e+20|0;m=e+16|0;n=e+12|0;o=e+8|0;p=e+4|0;q=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;d=c[(c[g>>2]|0)+4>>2]|0;c[o>>2]=d;b=c[h>>2]|0;if(!d){c[(c[g>>2]|0)+4>>2]=b;d=c[(c[h>>2]|0)+28>>2]|0;c[(c[g>>2]|0)+12>>2]=d;if(!d)c[(c[g>>2]|0)+12>>2]=51;c[f>>2]=c[h>>2];r=c[f>>2]|0;i=e;return r|0}if(!b){c[f>>2]=c[o>>2];r=c[f>>2]|0;i=e;return r|0}c[k>>2]=c[c[(c[g>>2]|0)+16>>2]>>2];if(c[c[(c[g>>2]|0)+8>>2]>>2]&4096)Oz(c[g>>2]|0,0)|0;if((c[(c[o>>2]|0)+32>>2]|0)!=0?(Sb[c[(c[o>>2]|0)+32>>2]&127](c[g>>2]|0,3,c[h>>2]|0,c[o>>2]|0)|0)<0:0){c[f>>2]=0;r=c[f>>2]|0;i=e;return r|0}c[(c[g>>2]|0)+4>>2]=c[h>>2];b=c[(c[h>>2]|0)+28>>2]|0;c[(c[g>>2]|0)+12>>2]=b;if(!b)c[(c[g>>2]|0)+12>>2]=51;a:do if(!(c[c[(c[g>>2]|0)+8>>2]>>2]&112)){do if(c[c[(c[g>>2]|0)+8>>2]>>2]&2){if(c[j>>2]&2)break a}else{b=c[j>>2]|0;if(!(c[c[(c[g>>2]|0)+8>>2]>>2]&3))if(b&1)break a;else break;if((b&2|0)!=0?(c[j>>2]&1|0)!=0:0)break a}while(0);c[l>>2]=Lz(c[g>>2]|0)|0;b=c[(c[g>>2]|0)+8>>2]|0;c[b>>2]=c[b>>2]&-4097;c[(c[(c[g>>2]|0)+8>>2]|0)+4>>2]=0;c[(c[(c[g>>2]|0)+8>>2]|0)+16>>2]=0;b:do if(c[c[(c[g>>2]|0)+8>>2]>>2]&3){b=c[(c[(c[g>>2]|0)+8>>2]|0)+8>>2]|0;c[p>>2]=b;c[q>>2]=b+(c[(c[(c[g>>2]|0)+8>>2]|0)+12>>2]<<2);while(1){if((c[p>>2]|0)>>>0>=(c[q>>2]|0)>>>0)break b;b=c[p>>2]|0;c[p>>2]=b+4;c[b>>2]=0}}while(0);while(1){if(!(c[l>>2]|0))break a;c[m>>2]=c[c[l>>2]>>2];if(!(c[j>>2]&2)){b=c[l>>2]|0;if((c[(c[h>>2]|0)+8>>2]|0)<0)s=c[b+8>>2]|0;else s=b+(0-(c[(c[h>>2]|0)+8>>2]|0))|0;c[n>>2]=s;b=(c[n>>2]|0)+(c[c[h>>2]>>2]|0)|0;if((c[(c[h>>2]|0)+4>>2]|0)<0)t=c[b>>2]|0;else t=b;c[n>>2]=t;if(c[(c[h>>2]|0)+24>>2]|0)u=Hb[c[(c[h>>2]|0)+24>>2]&63](c[g>>2]|0,c[n>>2]|0,c[h>>2]|0)|0;else u=Xz(0,c[n>>2]|0,c[(c[h>>2]|0)+4>>2]|0)|0;c[(c[l>>2]|0)+4>>2]=u}Hb[c[k>>2]&63](c[g>>2]|0,c[l>>2]|0,32)|0;c[l>>2]=c[m>>2]}}while(0);c[f>>2]=c[o>>2];r=c[f>>2]|0;i=e;return r|0}function Wz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+32|0;g=f+16|0;h=f+8|0;j=f+4|0;c[f+12>>2]=a;c[h>>2]=b;c[j>>2]=d;c[f>>2]=e;e=c[j>>2]|0;do if(c[h>>2]|0){d=c[h>>2]|0;if(!e){O4(d);c[g>>2]=0;break}else{c[g>>2]=Q4(d,c[j>>2]|0)|0;break}}else{if(e>>>0>0)k=N4(c[j>>2]|0)|0;else k=0;c[g>>2]=k}while(0);i=f;return c[g>>2]|0}function Xz(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=e;c[k>>2]=c[h>>2];if((c[j>>2]|0)<=0){while(1){if(!(d[c[k>>2]>>0]|0))break;c[g>>2]=_((c[g>>2]|0)+((d[c[k>>2]>>0]|0)<<8)+(d[(c[k>>2]|0)+1>>0]|0)|0,17109811)|0;c[k>>2]=(c[k>>2]|0)+((d[(c[k>>2]|0)+1>>0]|0|0)!=0?2:1)}c[j>>2]=(c[k>>2]|0)-(c[h>>2]|0);m=c[g>>2]|0;n=c[j>>2]|0;o=m+n|0;p=_(o,17109811)|0;i=f;return p|0}c[l>>2]=(c[k>>2]|0)+(c[j>>2]|0)+-1;while(1){if((c[k>>2]|0)>>>0>=(c[l>>2]|0)>>>0)break;c[g>>2]=_((c[g>>2]|0)+((d[c[k>>2]>>0]|0)<<8)+(d[(c[k>>2]|0)+1>>0]|0)|0,17109811)|0;c[k>>2]=(c[k>>2]|0)+2}if((c[k>>2]|0)>>>0>(c[l>>2]|0)>>>0){m=c[g>>2]|0;n=c[j>>2]|0;o=m+n|0;p=_(o,17109811)|0;i=f;return p|0}c[g>>2]=_((c[g>>2]|0)+((d[c[k>>2]>>0]|0)<<8)|0,17109811)|0;m=c[g>>2]|0;n=c[j>>2]|0;o=m+n|0;p=_(o,17109811)|0;i=f;return p|0}function Yz(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=c[12998];c[12998]=c[d>>2];i=b;return c[e>>2]|0}function Zz(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=c[12999];c[12999]=c[d>>2];i=b;return c[e>>2]|0}function _z(){var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;if(c[13e3]|0){T2(c[13e3]|0)|0;c[e>>2]=f3(c[13e3]|0)|0;c[f>>2]=(c[e>>2]|0)-(c[13001]|0);c[g>>2]=N4((c[f>>2]|0)+1|0)|0;c3(c[13e3]|0,c[13001]|0,0)|0;$2(c[g>>2]|0,1,c[f>>2]|0,c[13e3]|0)|0;a[(c[g>>2]|0)+(c[f>>2]|0)>>0]=0;c3(c[13e3]|0,c[e>>2]|0,0)|0;c[d>>2]=c[g>>2];h=c[d>>2]|0;i=b;return h|0}else{c[d>>2]=0;h=c[d>>2]|0;i=b;return h|0}return 0}function $z(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=bA(c[f>>2]|0,c[g>>2]|0,h)|0;i=e;return d|0}function aA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+32|0;e=d+16|0;f=d;c[e>>2]=a;c[f>>2]=b;bA(1,c[e>>2]|0,f)|0;i=d;return}function bA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+32|0;f=e;g=e+20|0;h=e+16|0;j=e+12|0;k=e+8|0;l=e+4|0;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;if((c[h>>2]|0)==3)m=c[13003]|0;else m=(c[h>>2]|0)==2?1:c[h>>2]|0;c[l>>2]=m;c[13003]=c[l>>2];c[13002]=(c[13002]|0)>>>0>(c[13003]|0)>>>0?c[13002]|0:c[13003]|0;if((c[l>>2]|0)>>>0>=(c[12999]|0)>>>0){l=c[h>>2]|0;if(c[12998]|0)cA(l,c[j>>2]|0,c[k>>2]|0);else{if((l|0)!=3){l=c[24742]|0;c[f>>2]=(c[h>>2]|0)==1?134009:134015;Y2(l,134023,f)|0}o3(c[24742]|0,c[j>>2]|0,c[k>>2]|0)|0}c[g>>2]=0;n=c[g>>2]|0;i=e;return n|0}if((c[13e3]|0)==0?(c[13e3]=m3()|0,(c[13e3]|0)==0):0){c[g>>2]=1;n=c[g>>2]|0;i=e;return n|0}if((c[h>>2]|0)!=3)c[13001]=f3(c[13e3]|0)|0;o3(c[13e3]|0,c[j>>2]|0,c[k>>2]|0)|0;c[g>>2]=0;n=c[g>>2]|0;i=e;return n|0}function cA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if((c[13004]|0)==0?(c[13004]=N4(c[13005]|0)|0,(c[13004]|0)==0):0){_2(134028,c[24742]|0)|0;i=e;return}if((c[f>>2]|0)!=3){Fb[c[12998]&63]((c[f>>2]|0)==1?134009:134015)|0;Fb[c[12998]&63](134408)|0}while(1){c[k>>2]=q3(c[13004]|0,c[13005]|0,c[g>>2]|0,c[h>>2]|0)|0;if((c[k>>2]|0)>-1?(c[k>>2]|0)<(c[13005]|0):0){l=8;break}c[13005]=(c[13005]<<1|0)>((c[k>>2]|0)+1|0)?c[13005]<<1:(c[k>>2]|0)+1|0;f=Q4(c[13004]|0,c[13005]|0)|0;c[j>>2]=f;if(!f){l=10;break}}if((l|0)==8){Fb[c[12998]&63](c[13004]|0)|0;i=e;return}else if((l|0)==10){_2(134028,c[24742]|0)|0;i=e;return}}function dA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+16|0;g=f+8|0;h=f+4|0;j=f;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;if(c[j>>2]|0){c[c[g>>2]>>2]=c[j>>2];c[(c[g>>2]|0)+12>>2]=0}else{if(!(c[h>>2]|0))c[h>>2]=1024;c[(c[g>>2]|0)+12>>2]=1;j=N4(c[h>>2]|0)|0;c[c[g>>2]>>2]=j}c[(c[g>>2]|0)+8>>2]=(c[c[g>>2]>>2]|0)+(c[h>>2]|0);c[(c[g>>2]|0)+4>>2]=c[c[g>>2]>>2];a[c[(c[g>>2]|0)+4>>2]>>0]=0;i=f;return}function eA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;k=d;c[e>>2]=a;c[f>>2]=b;c[h>>2]=(c[(c[e>>2]|0)+8>>2]|0)-(c[c[e>>2]>>2]|0);c[j>>2]=c[h>>2]<<1;if(((c[h>>2]|0)+(c[f>>2]|0)|0)>(c[j>>2]|0))c[j>>2]=(c[h>>2]|0)+(c[f>>2]|0);c[g>>2]=(c[(c[e>>2]|0)+4>>2]|0)-(c[c[e>>2]>>2]|0);if(c[(c[e>>2]|0)+12>>2]|0)c[k>>2]=Q4(c[c[e>>2]>>2]|0,c[j>>2]|0)|0;else{c[k>>2]=N4(c[j>>2]|0)|0;Z4(c[k>>2]|0,c[c[e>>2]>>2]|0,c[g>>2]|0)|0;c[(c[e>>2]|0)+12>>2]=1}c[c[e>>2]>>2]=c[k>>2];c[(c[e>>2]|0)+4>>2]=(c[c[e>>2]>>2]|0)+(c[g>>2]|0);c[(c[e>>2]|0)+8>>2]=(c[c[e>>2]>>2]|0)+(c[j>>2]|0);i=d;return 0}function fA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if(((c[(c[f>>2]|0)+4>>2]|0)+(c[h>>2]|0)|0)>>>0>(c[(c[f>>2]|0)+8>>2]|0)>>>0)eA(c[f>>2]|0,c[h>>2]|0)|0;Z4(c[(c[f>>2]|0)+4>>2]|0,c[g>>2]|0,c[h>>2]|0)|0;g=(c[f>>2]|0)+4|0;c[g>>2]=(c[g>>2]|0)+(c[h>>2]|0);i=e;return c[h>>2]|0}function gA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=N3(c[f>>2]|0)|0;b=fA(c[e>>2]|0,c[f>>2]|0,c[g>>2]|0)|0;i=d;return b|0}function hA(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if(!(c[(c[d>>2]|0)+12>>2]|0)){i=b;return}O4(c[c[d>>2]>>2]|0);i=b;return}function iA(a){a=a|0;var b=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;e=b+8|0;f=b+4|0;g=b;c[f>>2]=a;if((c[(c[f>>2]|0)+4>>2]|0)>>>0>(c[c[f>>2]>>2]|0)>>>0){a=(c[f>>2]|0)+4|0;f=c[a>>2]|0;c[a>>2]=f+-1;c[g>>2]=d[f>>0];c[e>>2]=c[g>>2];h=c[e>>2]|0;i=b;return h|0}else{c[e>>2]=-1;h=c[e>>2]|0;i=b;return h|0}return 0}function jA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=LC(c[f>>2]|0,134064,0)|0;if((c[h>>2]|0)==0&(c[g>>2]|0)!=0){EA(c[f>>2]|0);c[h>>2]=LC(c[f>>2]|0,134064,0)|0;c[e>>2]=c[h>>2];j=c[e>>2]|0;i=d;return j|0}else{c[e>>2]=c[h>>2];j=c[e>>2]|0;i=d;return j|0}return 0}function kA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+32|0;e=d;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;c[f>>2]=a;c[g>>2]=b;c[h>>2]=jA(c[f>>2]|0,0)|0;a:do if(c[h>>2]|0)switch(c[g>>2]|0){case 0:{c[j>>2]=c[(c[h>>2]|0)+8+8>>2];break a;break}case 1:{c[j>>2]=c[(c[h>>2]|0)+8>>2];break a;break}case 2:case 3:{c[j>>2]=c[(c[h>>2]|0)+8+4>>2];break a;break}default:{c[e>>2]=c[g>>2];$z(1,134077,e)|0;c[j>>2]=0;break a}}else c[j>>2]=0;while(0);i=d;return c[j>>2]|0}function lA(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;i=i+32|0;j=h+20|0;k=h+16|0;l=h+12|0;m=h+8|0;n=h+4|0;o=h;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;c[n>>2]=g;c[o>>2]=UB(c[j>>2]|0,24)|0;a[(c[o>>2]|0)+20>>0]=c[n>>2];n=YC(c[j>>2]|0,c[k>>2]|0)|0;c[(c[o>>2]|0)+8>>2]=n;n=YC(c[j>>2]|0,c[l>>2]|0)|0;c[(c[o>>2]|0)+12>>2]=n;c[(c[o>>2]|0)+16>>2]=c[m>>2];i=h;return c[o>>2]|0}function mA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+32|0;e=d+28|0;f=d+24|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g+8>>2]=c[f>>2];f=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,4)|0;i=d;return f|0}function nA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[e>>2]=a;c[f>>2]=b;c[h>>2]=Sz(c[e>>2]|0,0)|0;c[g>>2]=mA(c[e>>2]|0,c[f>>2]|0)|0;Sz(c[e>>2]|0,c[h>>2]|0)|0;i=d;return c[g>>2]|0}function oA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[j>>2]=c[f>>2];c[g>>2]=pA(c[e>>2]|0)|0;if(c[g>>2]|0){c[h>>2]=mA(c[(c[g>>2]|0)+8>>2]|0,c[j>>2]|0)|0;k=c[h>>2]|0;i=d;return k|0}else{c[h>>2]=0;k=c[h>>2]|0;i=d;return k|0}return 0}function pA(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=LC(c[d>>2]|0,c[13015]|0,0)|0;i=b;return a|0}function qA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+12|0;k=f+8|0;l=f+4|0;m=f;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;if(!(c[h>>2]|0)){if(!(c[13016]|0)){c[g>>2]=c[13017];c[13016]=gB(0,g,0)|0}c[h>>2]=c[13016]}g=c[h>>2]|0;h=c[j>>2]|0;j=c[k>>2]|0;if(c[l>>2]|0){c[m>>2]=FA(g,h,j,c[l>>2]|0)|0;n=c[m>>2]|0;i=f;return n|0}else{c[m>>2]=GA(g,h,j)|0;n=c[m>>2]|0;i=f;return n|0}return 0}function rA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=kA(c[f>>2]|0,c[g>>2]|0)|0;c[j>>2]=d;if(!d){c[k>>2]=0;l=c[k>>2]|0;i=e;return l|0}d=c[c[j>>2]>>2]|0;g=c[j>>2]|0;if(c[h>>2]|0){c[k>>2]=Hb[d&63](g,c[h>>2]|0,8)|0;l=c[k>>2]|0;i=e;return l|0}else{c[k>>2]=Hb[d&63](g,0,128)|0;l=c[k>>2]|0;i=e;return l|0}return 0}function sA(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=b;b=(c[e>>2]|0)+12|0;a[b>>0]=a[b>>0]&-65|64;HA(c[e>>2]|0)|0;b=ID(c[e>>2]|0)|0;c[f>>2]=b;if(!b)c[f>>2]=c[e>>2];IA(c[f>>2]|0,c[e>>2]|0)|0;i=d;return}function tA(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[e>>2]=a;c[13072]=c[e>>2];a=pA(c[e>>2]|0)|0;c[g>>2]=a;if(a){JA(c[e>>2]|0,c[g>>2]|0);NC(c[e>>2]|0,c[c[g>>2]>>2]|0)|0}g=jA(c[e>>2]|0,0)|0;c[f>>2]=g;do if(g){if(QD(c[e>>2]|0,c[(c[f>>2]|0)+8>>2]|0)|0){c[d>>2]=1;h=c[d>>2]|0;i=b;return h|0}if(QD(c[e>>2]|0,c[(c[f>>2]|0)+8+4>>2]|0)|0){c[d>>2]=1;h=c[d>>2]|0;i=b;return h|0}if(!(QD(c[e>>2]|0,c[(c[f>>2]|0)+8+8>>2]|0)|0)){NC(c[e>>2]|0,c[c[f>>2]>>2]|0)|0;break}c[d>>2]=1;h=c[d>>2]|0;i=b;return h|0}while(0);c[d>>2]=0;h=c[d>>2]|0;i=b;return h|0}function uA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=pA(c[f>>2]|0)|0;if((c[g>>2]|0)!=0?(c[(c[g>>2]|0)+8>>2]|0)!=0:0){i=d;return}IA(c[e>>2]|0,c[f>>2]|0)|0;i=d;return}function vA(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;a=pA(c[d>>2]|0)|0;c[e>>2]=a;if(!a){i=b;return}JA(c[d>>2]|0,c[e>>2]|0);NC(c[d>>2]|0,c[13015]|0)|0;i=b;return}function wA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=pA(c[f>>2]|0)|0;if((c[g>>2]|0)!=0?(c[(c[g>>2]|0)+8>>2]|0)!=0:0){i=d;return}IA(c[e>>2]|0,c[f>>2]|0)|0;i=d;return}function xA(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;a=pA(c[d>>2]|0)|0;c[e>>2]=a;if(!a){i=b;return}JA(c[d>>2]|0,c[e>>2]|0);NC(c[d>>2]|0,c[13015]|0)|0;i=b;return}function yA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=oA(c[e>>2]|0,c[f>>2]|0)|0;if(!(c[g>>2]|0)){c[j>>2]=0;k=c[j>>2]|0;i=d;return k|0}else{c[h>>2]=pA(c[e>>2]|0)|0;c[j>>2]=c[(c[(c[h>>2]|0)+12>>2]|0)+(c[(c[g>>2]|0)+16>>2]<<2)>>2];k=c[j>>2]|0;i=d;return k|0}return 0}function zA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=pA(c[e>>2]|0)|0;c[h>>2]=c[(c[(c[g>>2]|0)+12>>2]|0)+(c[(c[f>>2]|0)+16>>2]<<2)>>2];i=d;return c[h>>2]|0}function AA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=oA(c[f>>2]|0,c[g>>2]|0)|0;if(!(c[j>>2]|0)){c[k>>2]=-1;l=c[k>>2]|0;i=e;return l|0}else{c[k>>2]=BA(c[f>>2]|0,c[j>>2]|0,c[h>>2]|0)|0;l=c[k>>2]|0;i=e;return l|0}return 0}function BA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+32|0;f=e+28|0;g=e+24|0;h=e+20|0;j=e+16|0;k=e+12|0;l=e+8|0;m=e+4|0;n=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=qC(c[f>>2]|0)|0;c[k>>2]=c[f>>2];c[l>>2]=pA(c[k>>2]|0)|0;_C(c[j>>2]|0,c[(c[(c[l>>2]|0)+12>>2]|0)+(c[(c[g>>2]|0)+16>>2]<<2)>>2]|0)|0;d=YC(c[j>>2]|0,c[h>>2]|0)|0;c[(c[(c[l>>2]|0)+12>>2]|0)+(c[(c[g>>2]|0)+16>>2]<<2)>>2]=d;if(c[c[k>>2]>>2]&3){o=c[j>>2]|0;p=c[f>>2]|0;q=c[g>>2]|0;uC(o,p,q);i=e;return 0}c[n>>2]=c[(jA(c[j>>2]|0,0)|0)+8+8>>2];d=nA(c[n>>2]|0,c[(c[g>>2]|0)+8>>2]|0)|0;c[m>>2]=d;l=c[j>>2]|0;if(d){_C(l,c[(c[m>>2]|0)+12>>2]|0)|0;d=YC(c[j>>2]|0,c[h>>2]|0)|0;c[(c[m>>2]|0)+12>>2]=d;o=c[j>>2]|0;p=c[f>>2]|0;q=c[g>>2]|0;uC(o,p,q);i=e;return 0}else{c[m>>2]=lA(l,c[(c[g>>2]|0)+8>>2]|0,c[h>>2]|0,c[(c[g>>2]|0)+16>>2]|0,c[c[k>>2]>>2]&3)|0;Hb[c[c[n>>2]>>2]&63](c[n>>2]|0,c[m>>2]|0,1)|0;o=c[j>>2]|0;p=c[f>>2]|0;q=c[g>>2]|0;uC(o,p,q);i=e;return 0}return 0}function CA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;e=qC(c[g>>2]|0)|0;c[l>>2]=qA(e,c[c[g>>2]>>2]&3,c[h>>2]|0,0)|0;if(c[l>>2]|0){m=c[g>>2]|0;n=c[l>>2]|0;o=c[j>>2]|0;p=BA(m,n,o)|0;i=f;return p|0}e=qC(c[g>>2]|0)|0;c[l>>2]=qA(e,c[c[g>>2]>>2]&3,c[h>>2]|0,c[k>>2]|0)|0;m=c[g>>2]|0;n=c[l>>2]|0;o=c[j>>2]|0;p=BA(m,n,o)|0;i=f;return p|0}function DA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;i=i+48|0;e=d+32|0;f=d+28|0;g=d+24|0;h=d+20|0;j=d+16|0;k=d+12|0;l=d+8|0;m=d+4|0;n=d;c[f>>2]=a;c[g>>2]=b;c[n>>2]=1;c[h>>2]=qC(c[f>>2]|0)|0;if((c[c[f>>2]>>2]&3|0)!=(c[c[g>>2]>>2]&3|0)){c[e>>2]=1;o=c[e>>2]|0;i=d;return o|0}c[j>>2]=0;while(1){b=rA(c[h>>2]|0,c[c[f>>2]>>2]&3,c[j>>2]|0)|0;c[j>>2]=b;if(!b){p=9;break}c[k>>2]=oA(c[g>>2]|0,c[(c[j>>2]|0)+8>>2]|0)|0;if(!(c[k>>2]|0)){p=6;break}c[l>>2]=zA(c[f>>2]|0,c[j>>2]|0)|0;c[n>>2]=BA(c[g>>2]|0,c[k>>2]|0,c[l>>2]|0)|0;if(!($C(c[l>>2]|0)|0))continue;c[m>>2]=zA(c[g>>2]|0,c[k>>2]|0)|0;aD(c[m>>2]|0)}if((p|0)==6){c[e>>2]=1;o=c[e>>2]|0;i=d;return o|0}else if((p|0)==9){c[e>>2]=c[n>>2];o=c[e>>2]|0;i=d;return o|0}return 0}function EA(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[d>>2]=a;c[e>>2]=rC(c[d>>2]|0)|0;vE(c[e>>2]|0,c[e>>2]|0,98,0,1)|0;c[f>>2]=$B(c[e>>2]|0)|0;while(1){if(!(c[f>>2]|0))break;uA(c[d>>2]|0,c[f>>2]|0);c[g>>2]=OA(c[e>>2]|0,c[f>>2]|0)|0;while(1){if(!(c[g>>2]|0))break;wA(c[d>>2]|0,c[g>>2]|0);c[g>>2]=QA(c[e>>2]|0,c[g>>2]|0)|0}c[f>>2]=aC(c[e>>2]|0,c[f>>2]|0)|0}i=b;return}function FA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;f=i;i=i+64|0;g=f+52|0;h=f+48|0;j=f+44|0;k=f+40|0;l=f+32|0;m=f+28|0;n=f+24|0;o=f+20|0;p=f+16|0;q=f+12|0;r=f+8|0;s=f+4|0;t=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[r>>2]=rC(c[g>>2]|0)|0;c[f+36>>2]=jA(c[g>>2]|0,1)|0;c[l>>2]=kA(c[g>>2]|0,c[h>>2]|0)|0;c[n>>2]=nA(c[l>>2]|0,c[j>>2]|0)|0;do if(c[n>>2]|0){_C(c[g>>2]|0,c[(c[n>>2]|0)+12>>2]|0)|0;e=YC(c[g>>2]|0,c[k>>2]|0)|0;c[(c[n>>2]|0)+12>>2]=e;c[q>>2]=c[n>>2]}else{c[o>>2]=mA(c[l>>2]|0,c[j>>2]|0)|0;if(c[o>>2]|0){c[n>>2]=lA(c[g>>2]|0,c[j>>2]|0,c[k>>2]|0,c[(c[o>>2]|0)+16>>2]|0,c[h>>2]|0)|0;Hb[c[c[l>>2]>>2]&63](c[l>>2]|0,c[n>>2]|0,1)|0;c[q>>2]=c[n>>2];break}c[m>>2]=kA(c[r>>2]|0,c[h>>2]|0)|0;e=c[g>>2]|0;d=c[j>>2]|0;b=c[k>>2]|0;a=Pz(c[m>>2]|0)|0;c[p>>2]=lA(e,d,b,a,c[h>>2]|0)|0;Hb[c[c[m>>2]>>2]&63](c[m>>2]|0,c[p>>2]|0,1)|0;a:do switch(c[h>>2]|0){case 0:{vE(c[r>>2]|0,c[r>>2]|0,54,c[p>>2]|0,1)|0;break}case 1:{c[s>>2]=$B(c[r>>2]|0)|0;while(1){if(!(c[s>>2]|0))break a;NA(c[g>>2]|0,c[s>>2]|0,c[p>>2]|0);c[s>>2]=aC(c[r>>2]|0,c[s>>2]|0)|0}break}case 2:case 3:{c[s>>2]=$B(c[r>>2]|0)|0;while(1){if(!(c[s>>2]|0))break a;c[t>>2]=OA(c[r>>2]|0,c[s>>2]|0)|0;while(1){if(!(c[t>>2]|0))break;NA(c[g>>2]|0,c[t>>2]|0,c[p>>2]|0);c[t>>2]=QA(c[r>>2]|0,c[t>>2]|0)|0}c[s>>2]=aC(c[r>>2]|0,c[s>>2]|0)|0}break}default:{}}while(0);c[q>>2]=c[p>>2]}while(0);if(!((c[q>>2]|0)!=0&(c[h>>2]|0)==0)){u=c[g>>2]|0;v=c[g>>2]|0;w=c[q>>2]|0;uC(u,v,w);x=c[q>>2]|0;i=f;return x|0}BA(c[g>>2]|0,c[q>>2]|0,c[k>>2]|0)|0;u=c[g>>2]|0;v=c[g>>2]|0;w=c[q>>2]|0;uC(u,v,w);x=c[q>>2]|0;i=f;return x|0}function GA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=0;c[k>>2]=kA(c[f>>2]|0,c[g>>2]|0)|0;if(!(c[k>>2]|0)){l=c[j>>2]|0;i=e;return l|0}c[j>>2]=mA(c[k>>2]|0,c[h>>2]|0)|0;l=c[j>>2]|0;i=e;return l|0}function HA(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[d>>2]=a;c[g>>2]=MC(c[d>>2]|0,134064,20,0)|0;a=OD(c[d>>2]|0,52024,c[12993]|0)|0;c[(c[g>>2]|0)+8>>2]=a;a=OD(c[d>>2]|0,52024,c[12993]|0)|0;c[(c[g>>2]|0)+8+4>>2]=a;a=OD(c[d>>2]|0,52024,c[12993]|0)|0;c[(c[g>>2]|0)+8+8>>2]=a;a=ID(c[d>>2]|0)|0;c[e>>2]=a;if(a){c[f>>2]=jA(c[e>>2]|0,0)|0;Sz(c[(c[g>>2]|0)+8>>2]|0,c[(c[f>>2]|0)+8>>2]|0)|0;Sz(c[(c[g>>2]|0)+8+4>>2]|0,c[(c[f>>2]|0)+8+4>>2]|0)|0;Sz(c[(c[g>>2]|0)+8+8>>2]|0,c[(c[f>>2]|0)+8+8>>2]|0)|0;h=c[g>>2]|0;i=b;return h|0}if(!(c[13016]|0)){h=c[g>>2]|0;i=b;return h|0}if((c[d>>2]|0)==(c[13016]|0)){h=c[g>>2]|0;i=b;return h|0}c[f>>2]=jA(c[13016]|0,0)|0;MA(c[(c[f>>2]|0)+8>>2]|0,c[(c[g>>2]|0)+8>>2]|0,c[d>>2]|0,1);MA(c[(c[f>>2]|0)+8+4>>2]|0,c[(c[g>>2]|0)+8+4>>2]|0,c[d>>2]|0,2);MA(c[(c[f>>2]|0)+8+8>>2]|0,c[(c[g>>2]|0)+8+8>>2]|0,c[d>>2]|0,0);h=c[g>>2]|0;i=b;return h|0}function IA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;k=d;c[e>>2]=a;c[f>>2]=b;c[h>>2]=MC(c[f>>2]|0,c[13015]|0,16,0)|0;c[k>>2]=kA(c[e>>2]|0,c[c[f>>2]>>2]&3)|0;if(c[(c[h>>2]|0)+8>>2]|0){l=c[h>>2]|0;i=d;return l|0}b=rC(c[e>>2]|0)|0;e=kA(b,c[c[f>>2]>>2]&3)|0;c[(c[h>>2]|0)+8>>2]=e;e=LA(c[f>>2]|0)|0;c[g>>2]=e;c[g>>2]=(c[g>>2]|0)<4?4:e;e=qC(c[f>>2]|0)|0;b=UB(e,c[g>>2]<<2)|0;c[(c[h>>2]|0)+12>>2]=b;c[j>>2]=Hb[c[c[k>>2]>>2]&63](c[k>>2]|0,0,128)|0;while(1){if(!(c[j>>2]|0))break;b=qC(c[f>>2]|0)|0;g=YC(b,c[(c[j>>2]|0)+12>>2]|0)|0;c[(c[(c[h>>2]|0)+12>>2]|0)+(c[(c[j>>2]|0)+16>>2]<<2)>>2]=g;c[j>>2]=Hb[c[c[k>>2]>>2]&63](c[k>>2]|0,c[j>>2]|0,8)|0}l=c[h>>2]|0;i=d;return l|0}function JA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[j>>2]=qC(c[e>>2]|0)|0;c[h>>2]=LA(c[e>>2]|0)|0;c[g>>2]=0;while(1){k=c[j>>2]|0;if((c[g>>2]|0)>=(c[h>>2]|0))break;_C(k,c[(c[(c[f>>2]|0)+12>>2]|0)+(c[g>>2]<<2)>>2]|0)|0;c[g>>2]=(c[g>>2]|0)+1}VB(k,c[(c[f>>2]|0)+12>>2]|0);i=d;return}function KA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=c[f>>2];_C(c[13072]|0,c[(c[g>>2]|0)+8>>2]|0)|0;_C(c[13072]|0,c[(c[g>>2]|0)+12>>2]|0)|0;VB(c[13072]|0,c[g>>2]|0);i=e;return}function LA(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;a=rC(qC(c[d>>2]|0)|0)|0;c[e>>2]=kA(a,c[c[d>>2]>>2]&3)|0;if(!(c[e>>2]|0)){f=0;i=b;return f|0}f=Pz(c[e>>2]|0)|0;i=b;return f|0}function MA(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;i=i+32|0;h=g+20|0;j=g+16|0;k=g+12|0;l=g+8|0;m=g+4|0;n=g;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=f;c[m>>2]=Hb[c[c[h>>2]>>2]&63](c[h>>2]|0,0,128)|0;while(1){if(!(c[m>>2]|0))break;c[n>>2]=lA(c[k>>2]|0,c[(c[m>>2]|0)+8>>2]|0,c[(c[m>>2]|0)+12>>2]|0,c[(c[m>>2]|0)+16>>2]|0,c[l>>2]|0)|0;a[(c[n>>2]|0)+22>>0]=a[(c[m>>2]|0)+22>>0]|0;a[(c[n>>2]|0)+21>>0]=a[(c[m>>2]|0)+21>>0]|0;Hb[c[c[j>>2]>>2]&63](c[j>>2]|0,c[n>>2]|0,1)|0;c[m>>2]=Hb[c[c[h>>2]>>2]&63](c[h>>2]|0,c[m>>2]|0,8)|0}i=g;return}function NA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=pA(c[g>>2]|0)|0;if((c[(c[h>>2]|0)+16>>2]|0)>=4){g=Sb[c[(c[c[(c[f>>2]|0)+52>>2]>>2]|0)+8>>2]&127](c[(c[(c[f>>2]|0)+52>>2]|0)+12>>2]|0,c[(c[j>>2]|0)+12>>2]|0,c[(c[h>>2]|0)+16>>2]<<2,(c[(c[h>>2]|0)+16>>2]|0)+1<<2)|0;c[(c[j>>2]|0)+12>>2]=g}g=YC(c[f>>2]|0,c[(c[h>>2]|0)+12>>2]|0)|0;c[(c[(c[j>>2]|0)+12>>2]|0)+(c[(c[h>>2]|0)+16>>2]<<2)>>2]=g;i=e;return}function OA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[e>>2]=a;c[f>>2]=b;c[h>>2]=0;c[g>>2]=PA(c[e>>2]|0,c[f>>2]|0)|0;if(!(c[g>>2]|0)){j=c[h>>2]|0;i=d;return j|0}Oz(c[(c[e>>2]|0)+32>>2]|0,c[(c[g>>2]|0)+32>>2]|0)|0;c[h>>2]=Hb[c[c[(c[e>>2]|0)+32>>2]>>2]&63](c[(c[e>>2]|0)+32>>2]|0,0,128)|0;f=Kz(c[(c[e>>2]|0)+32>>2]|0)|0;c[(c[g>>2]|0)+32>>2]=f;j=c[h>>2]|0;i=d;return j|0}function PA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+48|0;e=d+44|0;f=d+40|0;g=d+36|0;h=d;c[e>>2]=a;c[f>>2]=b;b=c[f>>2]|0;if((c[e>>2]|0)==(c[(c[f>>2]|0)+12>>2]|0)){c[g>>2]=b+16;j=c[g>>2]|0;i=d;return j|0}else{c[h+16>>2]=b;c[g>>2]=Hb[c[c[(c[e>>2]|0)+28>>2]>>2]&63](c[(c[e>>2]|0)+28>>2]|0,h,4)|0;j=c[g>>2]|0;i=d;return j|0}return 0}function QA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[j>>2]=0;b=c[f>>2]|0;c[g>>2]=c[((c[c[f>>2]>>2]&3|0)==3?b:b+32|0)+28>>2];c[h>>2]=PA(c[e>>2]|0,c[g>>2]|0)|0;if(!(c[h>>2]|0)){k=c[j>>2]|0;i=d;return k|0}Oz(c[(c[e>>2]|0)+32>>2]|0,c[(c[h>>2]|0)+32>>2]|0)|0;c[j>>2]=Hb[c[c[(c[e>>2]|0)+32>>2]>>2]&63](c[(c[e>>2]|0)+32>>2]|0,c[f>>2]|0,8)|0;f=Kz(c[(c[e>>2]|0)+32>>2]|0)|0;c[(c[h>>2]|0)+32>>2]=f;k=c[j>>2]|0;i=d;return k|0}function RA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[e>>2]=a;c[f>>2]=b;c[h>>2]=0;c[g>>2]=PA(c[e>>2]|0,c[f>>2]|0)|0;if(!(c[g>>2]|0)){j=c[h>>2]|0;i=d;return j|0}Oz(c[(c[e>>2]|0)+32>>2]|0,c[(c[g>>2]|0)+28>>2]|0)|0;c[h>>2]=Hb[c[c[(c[e>>2]|0)+32>>2]>>2]&63](c[(c[e>>2]|0)+32>>2]|0,0,128)|0;f=Kz(c[(c[e>>2]|0)+32>>2]|0)|0;c[(c[g>>2]|0)+28>>2]=f;j=c[h>>2]|0;i=d;return j|0}function SA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[j>>2]=0;b=c[f>>2]|0;c[g>>2]=c[((c[c[f>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2];c[h>>2]=PA(c[e>>2]|0,c[g>>2]|0)|0;if(!(c[h>>2]|0)){k=c[j>>2]|0;i=d;return k|0}Oz(c[(c[e>>2]|0)+32>>2]|0,c[(c[h>>2]|0)+28>>2]|0)|0;c[j>>2]=Hb[c[c[(c[e>>2]|0)+32>>2]>>2]&63](c[(c[e>>2]|0)+32>>2]|0,c[f>>2]|0,8)|0;f=Kz(c[(c[e>>2]|0)+32>>2]|0)|0;c[(c[h>>2]|0)+28>>2]=f;k=c[j>>2]|0;i=d;return k|0}function TA(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=OA(c[e>>2]|0,c[f>>2]|0)|0;if(c[g>>2]|0){h=c[g>>2]|0;i=d;return h|0}c[g>>2]=RA(c[e>>2]|0,c[f>>2]|0)|0;h=c[g>>2]|0;i=d;return h|0}function UA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;a:do if((c[c[g>>2]>>2]&3|0)==2){c[j>>2]=QA(c[f>>2]|0,c[g>>2]|0)|0;if(!(c[j>>2]|0))do{d=c[f>>2]|0;if(c[j>>2]|0)k=SA(d,c[j>>2]|0)|0;else k=RA(d,c[h>>2]|0)|0;c[j>>2]=k;if(!(c[j>>2]|0))break a}while((c[(c[j>>2]|0)+28>>2]|0)==(c[h>>2]|0))}else do{c[j>>2]=SA(c[f>>2]|0,c[g>>2]|0)|0;c[g>>2]=c[j>>2];if(!(c[j>>2]|0))break a}while((c[(c[j>>2]|0)+28>>2]|0)==(c[h>>2]|0));while(0);i=e;return c[j>>2]|0}function VA(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=i;i=i+64|0;h=g+48|0;j=g+40|0;k=g+36|0;l=g+32|0;m=g+28|0;n=g+24|0;o=g+20|0;p=g+16|0;q=g+12|0;r=g+8|0;s=g;c[k>>2]=a;c[l>>2]=b;c[m>>2]=d;c[n>>2]=e;c[o>>2]=f;c[r>>2]=tB(c[k>>2]|0,2,c[n>>2]|0,q,0)|0;if(!(c[r>>2]|0)){if(!(c[n>>2]|0))if(!((c[o>>2]|0)!=0?(pB(c[k>>2]|0)|0)==0:0))t=5}else t=5;if((t|0)==5){c[s>>2]=c[13054];c[s+4>>2]=c[13055];if(c[r>>2]|0){c[s+4>>2]=c[q>>2];c[s>>2]=c[s>>2]&-4|2}else{c[s>>2]=c[s>>2]&-4;c[s+4>>2]=0}r=c[k>>2]|0;t=c[l>>2]|0;f=c[m>>2]|0;c[h>>2]=c[s>>2];c[h+4>>2]=c[s+4>>2];c[p>>2]=cB(r,t,f,h)|0;if((c[p>>2]|0)==0?(oB(c[k>>2]|0)|0)!=0:0){f=c[k>>2]|0;t=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[s>>2];c[h+4>>2]=c[s+4>>2];c[p>>2]=cB(f,t,r,h)|0}if(c[p>>2]|0){c[j>>2]=c[p>>2];u=c[j>>2]|0;i=g;return u|0}if(c[o>>2]|0){r=rC(c[k>>2]|0)|0;t=c[l>>2]|0;f=c[m>>2]|0;c[h>>2]=c[s>>2];c[h+4>>2]=c[s+4>>2];c[p>>2]=cB(r,t,f,h)|0;if((c[p>>2]|0)==0?(oB(c[k>>2]|0)|0)!=0:0){f=rC(c[k>>2]|0)|0;t=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[s>>2];c[h+4>>2]=c[s+4>>2];c[p>>2]=cB(f,t,r,h)|0}if(c[p>>2]|0){aB(c[k>>2]|0,c[p>>2]|0);c[j>>2]=c[p>>2];u=c[j>>2]|0;i=g;return u|0}}}if(((c[o>>2]|0)!=0?($A(c[k>>2]|0,c[l>>2]|0,c[m>>2]|0)|0)!=0:0)?(tB(c[k>>2]|0,2,c[n>>2]|0,q,1)|0)!=0:0){c[p>>2]=bB(c[k>>2]|0,c[l>>2]|0,c[m>>2]|0,c[q>>2]|0)|0;xB(c[k>>2]|0,2,c[p>>2]|0)}else c[p>>2]=0;c[j>>2]=c[p>>2];u=c[j>>2]|0;i=g;return u|0}function WA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+28|0;g=e+24|0;h=e+16|0;j=e+12|0;k=e+8|0;l=e+4|0;m=e;c[f>>2]=a;c[g>>2]=b;c[e+20>>2]=d;d=c[g>>2]|0;if((c[c[g>>2]>>2]&3|0)==3){c[h>>2]=d;c[j>>2]=(c[g>>2]|0)+-32}else{c[j>>2]=d;c[h>>2]=(c[g>>2]|0)+32}c[k>>2]=c[(c[h>>2]|0)+28>>2];c[l>>2]=c[(c[j>>2]|0)+28>>2];c[m>>2]=PA(c[f>>2]|0,c[k>>2]|0)|0;dB(c[(c[f>>2]|0)+32>>2]|0,(c[m>>2]|0)+32|0,c[j>>2]|0);dB(c[(c[f>>2]|0)+36>>2]|0,(c[m>>2]|0)+24|0,c[j>>2]|0);c[m>>2]=PA(c[f>>2]|0,c[l>>2]|0)|0;dB(c[(c[f>>2]|0)+32>>2]|0,(c[m>>2]|0)+28|0,c[h>>2]|0);dB(c[(c[f>>2]|0)+36>>2]|0,(c[m>>2]|0)+20|0,c[h>>2]|0);i=e;return}function XA(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+16|0;g=e+8|0;h=e+4|0;j=e;c[h>>2]=a;c[j>>2]=b;b=c[j>>2]|0;c[j>>2]=(c[c[j>>2]>>2]&3|0)==2?b:b+-32|0;b=c[h>>2]|0;a=c[j>>2]|0;k=c[((c[c[j>>2]>>2]&3|0)==3?a:a+32|0)+28>>2]|0;a=c[j>>2]|0;l=c[((c[c[j>>2]>>2]&3|0)==2?a:a+-32|0)+28>>2]|0;a=c[j>>2]|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];if(!(cB(b,k,l,f)|0)){c[g>>2]=-1;m=c[g>>2]|0;i=e;return m|0}f=c[h>>2]|0;if((f|0)==(rC(c[h>>2]|0)|0)){if((d[(c[h>>2]|0)+12>>0]|0)>>>6&1)xA(c[j>>2]|0);wC(c[h>>2]|0,c[j>>2]|0);QC(c[j>>2]|0);vB(c[h>>2]|0,2,c[(c[j>>2]|0)+4>>2]|0)}if(vE(c[h>>2]|0,c[j>>2]|0,55,0,0)|0){c[g>>2]=-1;m=c[g>>2]|0;i=e;return m|0}f=c[h>>2]|0;if((f|0)==(rC(c[h>>2]|0)|0))VB(c[h>>2]|0,c[j>>2]|0);c[g>>2]=0;m=c[g>>2]|0;i=e;return m|0}function YA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+32|0;f=e+24|0;g=e+20|0;h=e+16|0;j=e+12|0;k=e+8|0;l=e+4|0;m=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[m>>2]=0;d=c[h>>2]|0;c[k>>2]=eC(c[g>>2]|0,c[((c[c[h>>2]>>2]&3|0)==3?d:d+32|0)+28>>2]|0,c[j>>2]|0)|0;d=c[h>>2]|0;c[l>>2]=eC(c[g>>2]|0,c[((c[c[h>>2]>>2]&3|0)==2?d:d+-32|0)+28>>2]|0,c[j>>2]|0)|0;if(!((c[k>>2]|0)!=0&(c[l>>2]|0)!=0)){n=c[m>>2]|0;i=e;return n|0}d=c[g>>2]|0;b=c[k>>2]|0;k=c[l>>2]|0;l=c[h>>2]|0;c[f>>2]=c[l>>2];c[f+4>>2]=c[l+4>>2];c[m>>2]=cB(d,b,k,f)|0;if((c[j>>2]|0)!=0&(c[m>>2]|0)==0){eB(c[g>>2]|0,c[h>>2]|0);c[m>>2]=c[h>>2]}if(!(c[m>>2]|0)){n=c[m>>2]|0;i=e;return n|0}if((c[c[m>>2]>>2]&3|0)==(c[c[h>>2]>>2]&3|0)){n=c[m>>2]|0;i=e;return n|0}h=c[m>>2]|0;c[m>>2]=(c[c[m>>2]>>2]&3|0)==3?h+-32|0:h+32|0;n=c[m>>2]|0;i=e;return n|0}function ZA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+8|0;k=f+4|0;l=f;c[f+24>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+12>>2]=e;c[k>>2]=c[g>>2];c[l>>2]=c[h>>2];c[j>>2]=(c[(c[(c[k>>2]|0)+28>>2]|0)+4>>2]|0)-(c[(c[(c[l>>2]|0)+28>>2]|0)+4>>2]|0);do if(!(c[j>>2]|0)){if((c[c[k>>2]>>2]&3|0)!=0?(c[c[l>>2]>>2]&3|0)!=0:0){c[j>>2]=(c[(c[k>>2]|0)+4>>2]|0)-(c[(c[l>>2]|0)+4>>2]|0);break}c[j>>2]=0}while(0);if(!(c[j>>2]|0)){m=0;i=f;return m|0}m=(c[j>>2]|0)<0?-1:1;i=f;return m|0}function _A(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+8|0;k=f+4|0;l=f;c[f+24>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+12>>2]=e;c[k>>2]=c[g>>2];c[l>>2]=c[h>>2];h=c[k>>2]|0;if((c[(c[k>>2]|0)+28>>2]|0)!=(c[(c[l>>2]|0)+28>>2]|0))c[j>>2]=((c[c[h+28>>2]>>2]|0)>>>4)-((c[c[(c[l>>2]|0)+28>>2]>>2]|0)>>>4);else c[j>>2]=((c[h>>2]|0)>>>4)-((c[c[l>>2]>>2]|0)>>>4);if(!(c[j>>2]|0)){m=0;i=f;return m|0}m=(c[j>>2]|0)<0?-1:1;i=f;return m|0}function $A(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f;c[j>>2]=a;c[k>>2]=b;c[l>>2]=e;if(pB(c[j>>2]|0)|0){if(((d[(c[j>>2]|0)+12>>0]|0)>>>2&1|0)!=0?(c[k>>2]|0)==(c[l>>2]|0):0){c[h>>2]=0;n=c[h>>2]|0;i=f;return n|0};c[m>>2]=c[13054];c[m+4>>2]=c[13055];c[m>>2]=c[m>>2]&-4;e=c[j>>2]|0;j=c[k>>2]|0;k=c[l>>2]|0;c[g>>2]=c[m>>2];c[g+4>>2]=c[m+4>>2];if(cB(e,j,k,g)|0){c[h>>2]=0;n=c[h>>2]|0;i=f;return n|0}}c[h>>2]=1;n=c[h>>2]|0;i=f;return n|0}function aB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;eB(c[e>>2]|0,c[f>>2]|0);i=d;return}function bB(a,b,e,f){a=a|0;b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;i=i+32|0;h=g+28|0;j=g+24|0;k=g+20|0;l=g+16|0;m=g+12|0;n=g+8|0;o=g+4|0;p=g;c[h>>2]=a;c[j>>2]=b;c[k>>2]=e;c[l>>2]=f;eC(c[h>>2]|0,c[j>>2]|0,1)|0;eC(c[h>>2]|0,c[k>>2]|0,1)|0;c[m>>2]=UB(c[h>>2]|0,64)|0;c[n>>2]=(c[m>>2]|0)+32;c[o>>2]=c[m>>2];c[p>>2]=iB(c[h>>2]|0,2)|0;m=c[n>>2]|0;c[m>>2]=c[m>>2]&-4|3;m=c[o>>2]|0;c[m>>2]=c[m>>2]&-4|2;m=c[l>>2]|0;c[(c[o>>2]|0)+4>>2]=m;c[(c[n>>2]|0)+4>>2]=m;m=c[o>>2]|0;l=c[p>>2]&268435455;c[m>>2]=c[m>>2]&15|l<<4;m=c[n>>2]|0;c[m>>2]=c[m>>2]&15|(l&268435455)<<4;c[(c[n>>2]|0)+28>>2]=c[j>>2];c[(c[o>>2]|0)+28>>2]=c[k>>2];eB(c[h>>2]|0,c[o>>2]|0);if(!((d[(c[h>>2]|0)+12>>0]|0)>>>6&1)){q=c[h>>2]|0;r=c[o>>2]|0;sC(q,r);s=c[o>>2]|0;i=g;return s|0}MC(c[o>>2]|0,c[13015]|0,16,0)|0;wA(c[h>>2]|0,c[o>>2]|0);q=c[h>>2]|0;r=c[o>>2]|0;sC(q,r);s=c[o>>2]|0;i=g;return s|0}function cB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+64|0;g=f+56|0;h=f+52|0;j=f+48|0;k=f+44|0;l=f+40|0;m=f+8|0;n=f;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;if((c[j>>2]|0)==0|(c[k>>2]|0)==0){c[g>>2]=0;o=c[g>>2]|0;i=f;return o|0};c[m>>2]=c[e>>2];c[m+4>>2]=c[e+4>>2];c[m+28>>2]=c[j>>2];c[n>>2]=PA(c[h>>2]|0,c[k>>2]|0)|0;if(c[n>>2]|0){Oz(c[(c[h>>2]|0)+36>>2]|0,c[(c[n>>2]|0)+20>>2]|0)|0;c[l>>2]=Hb[c[c[(c[h>>2]|0)+36>>2]>>2]&63](c[(c[h>>2]|0)+36>>2]|0,m,4)|0;m=Kz(c[(c[h>>2]|0)+36>>2]|0)|0;c[(c[n>>2]|0)+20>>2]=m}else c[l>>2]=0;c[g>>2]=c[l>>2];o=c[g>>2]|0;i=f;return o|0}function dB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;Oz(c[f>>2]|0,c[c[g>>2]>>2]|0)|0;c[e>>2]=Hb[c[c[f>>2]>>2]&63](c[f>>2]|0,c[h>>2]|0,2)|0;h=Kz(c[f>>2]|0)|0;c[c[g>>2]>>2]=h;i=e;return}function eB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;i=i+48|0;e=d+32|0;f=d+24|0;g=d+20|0;h=d+16|0;j=d+12|0;k=d+8|0;l=d+4|0;m=d;c[f>>2]=a;c[g>>2]=b;b=c[g>>2]|0;c[k>>2]=(c[c[g>>2]>>2]&3|0)==2?b:b+-32|0;b=c[g>>2]|0;c[l>>2]=(c[c[g>>2]>>2]&3|0)==3?b:b+32|0;b=c[g>>2]|0;c[h>>2]=c[((c[c[g>>2]>>2]&3|0)==3?b:b+32|0)+28>>2];b=c[g>>2]|0;c[j>>2]=c[((c[c[g>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2];while(1){if(!(c[f>>2]|0)){n=5;break}b=c[f>>2]|0;a=c[h>>2]|0;o=c[j>>2]|0;p=c[g>>2]|0;c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];if(cB(b,a,o,e)|0){n=5;break}c[m>>2]=PA(c[f>>2]|0,c[h>>2]|0)|0;fB(c[(c[f>>2]|0)+32>>2]|0,(c[m>>2]|0)+32|0,c[k>>2]|0);fB(c[(c[f>>2]|0)+36>>2]|0,(c[m>>2]|0)+24|0,c[k>>2]|0);c[m>>2]=PA(c[f>>2]|0,c[j>>2]|0)|0;fB(c[(c[f>>2]|0)+32>>2]|0,(c[m>>2]|0)+28|0,c[l>>2]|0);fB(c[(c[f>>2]|0)+36>>2]|0,(c[m>>2]|0)+20|0,c[l>>2]|0);c[f>>2]=ID(c[f>>2]|0)|0}if((n|0)==5){i=d;return}}function fB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;Oz(c[f>>2]|0,c[c[g>>2]>>2]|0)|0;Hb[c[c[f>>2]>>2]&63](c[f>>2]|0,c[h>>2]|0,1)|0;h=Kz(c[f>>2]|0)|0;c[c[g>>2]>>2]=h;i=e;return}function gB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=b;c[h>>2]=e;c[k>>2]=rB(c[h>>2]|0)|0;c[j>>2]=Ob[c[(c[c[k>>2]>>2]|0)+4>>2]&127](c[(c[k>>2]|0)+12>>2]|0,56)|0;e=c[j>>2]|0;c[e>>2]=c[e>>2]&-4;c[(c[j>>2]|0)+52>>2]=c[k>>2];c[(c[j>>2]|0)+12>>2]=c[d>>2];d=(c[j>>2]|0)+12|0;a[d>>0]=a[d>>0]&-9|8;c[(c[j>>2]|0)+48>>2]=c[j>>2];d=Ob[c[c[(c[(c[j>>2]|0)+52>>2]|0)+4>>2]>>2]&127](c[j>>2]|0,c[h>>2]|0)|0;c[(c[(c[j>>2]|0)+52>>2]|0)+12+4>>2]=d;if(!(tB(c[j>>2]|0,0,c[g>>2]|0,l,1)|0)){m=c[j>>2]|0;n=hB(m)|0;c[j>>2]=n;o=c[j>>2]|0;p=c[j>>2]|0;xB(o,0,p);q=c[j>>2]|0;i=f;return q|0}c[(c[j>>2]|0)+4>>2]=c[l>>2];m=c[j>>2]|0;n=hB(m)|0;c[j>>2]=n;o=c[j>>2]|0;p=c[j>>2]|0;xB(o,0,p);q=c[j>>2]|0;i=f;return q|0}function hB(a){a=a|0;var b=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+16|0;e=b+4|0;f=b;c[e>>2]=a;a=OD(c[e>>2]|0,52476,c[12993]|0)|0;c[(c[e>>2]|0)+24>>2]=a;a=OD(c[e>>2]|0,52440,c[12993]|0)|0;c[(c[e>>2]|0)+28>>2]=a;a=c[e>>2]|0;g=c[e>>2]|0;h=(g|0)==(rC(c[e>>2]|0)|0);g=OD(a,h?52072:52108,c[12993]|0)|0;c[(c[e>>2]|0)+32>>2]=g;g=c[e>>2]|0;h=c[e>>2]|0;a=(h|0)==(rC(c[e>>2]|0)|0);h=OD(g,a?52144:52180,c[12993]|0)|0;c[(c[e>>2]|0)+36>>2]=h;h=OD(c[e>>2]|0,52224,c[12993]|0)|0;c[(c[e>>2]|0)+40>>2]=h;c[f>>2]=ID(c[e>>2]|0)|0;if(c[f>>2]|0){h=iB(c[f>>2]|0,0)|0;a=c[e>>2]|0;c[a>>2]=c[a>>2]&15|(h&268435455)<<4;Hb[c[c[(c[f>>2]|0)+40>>2]>>2]&63](c[(c[f>>2]|0)+40>>2]|0,c[e>>2]|0,1)|0}if((c[f>>2]|0)!=0?((d[(c[f>>2]|0)+12>>0]|0)>>>6&1|0)==0:0){j=c[e>>2]|0;k=c[e>>2]|0;sC(j,k);l=c[e>>2]|0;i=b;return l|0}sA(c[e>>2]|0);j=c[e>>2]|0;k=c[e>>2]|0;sC(j,k);l=c[e>>2]|0;i=b;return l|0}function iB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=(c[(c[e>>2]|0)+52>>2]|0)+24+(c[f>>2]<<2)|0;f=(c[b>>2]|0)+1|0;c[b>>2]=f;i=d;return f|0}function jB(a){a=a|0;var b=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;b=i;i=i+48|0;e=b+36|0;f=b+32|0;g=b+28|0;h=b+24|0;j=b+20|0;k=b+16|0;l=b+12|0;m=b+8|0;n=b+4|0;o=b;c[f>>2]=a;c[j>>2]=ID(c[f>>2]|0)|0;if((c[j>>2]|0)==0?(c[(c[c[(c[f>>2]|0)+52>>2]>>2]|0)+16>>2]|0)!=0:0){wC(c[f>>2]|0,c[f>>2]|0);vB(c[f>>2]|0,0,c[(c[f>>2]|0)+4>>2]|0);Bb[c[(c[c[(c[f>>2]|0)+52>>2]>>2]|0)+16>>2]&127](c[(c[(c[f>>2]|0)+52>>2]|0)+12>>2]|0);c[e>>2]=0;p=c[e>>2]|0;i=b;return p|0}c[g>>2]=GD(c[f>>2]|0)|0;while(1){if(!(c[g>>2]|0))break;c[h>>2]=HD(c[g>>2]|0)|0;jB(c[g>>2]|0)|0;c[g>>2]=c[h>>2]}c[k>>2]=$B(c[f>>2]|0)|0;while(1){q=c[f>>2]|0;if(!(c[k>>2]|0))break;c[l>>2]=aC(q,c[k>>2]|0)|0;hC(c[f>>2]|0,c[k>>2]|0)|0;c[k>>2]=c[l>>2]}KB(q);wC(c[f>>2]|0,c[f>>2]|0);if(QD(c[f>>2]|0,c[(c[f>>2]|0)+28>>2]|0)|0){c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}if(QD(c[f>>2]|0,c[(c[f>>2]|0)+24>>2]|0)|0){c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}if(QD(c[f>>2]|0,c[(c[f>>2]|0)+36>>2]|0)|0){c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}if(QD(c[f>>2]|0,c[(c[f>>2]|0)+32>>2]|0)|0){c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}if(QD(c[f>>2]|0,c[(c[f>>2]|0)+40>>2]|0)|0){c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}if(((d[(c[f>>2]|0)+12>>0]|0)>>>6&1|0)!=0?(tA(c[f>>2]|0)|0)!=0:0){c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}QC(c[f>>2]|0);vB(c[f>>2]|0,0,c[(c[f>>2]|0)+4>>2]|0);do if(c[j>>2]|0){JD(c[j>>2]|0,c[f>>2]|0)|0;VB(c[j>>2]|0,c[f>>2]|0)}else{while(1){r=c[f>>2]|0;if(!(c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2]|0))break;zC(r,c[c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2]>>2]|0)|0}Bb[c[(c[(c[r+52>>2]|0)+4>>2]|0)+20>>2]&127](c[(c[(c[f>>2]|0)+52>>2]|0)+12+4>>2]|0);if(!(WC(c[f>>2]|0)|0)){c[m>>2]=c[c[(c[f>>2]|0)+52>>2]>>2];c[n>>2]=c[(c[(c[f>>2]|0)+52>>2]|0)+12>>2];c[o>>2]=c[(c[f>>2]|0)+52>>2];Db[c[(c[m>>2]|0)+12>>2]&31](c[n>>2]|0,c[f>>2]|0);Db[c[(c[m>>2]|0)+12>>2]&31](c[n>>2]|0,c[o>>2]|0);break}c[e>>2]=-1;p=c[e>>2]|0;i=b;return p|0}while(0);c[e>>2]=0;p=c[e>>2]|0;i=b;return p|0}function kB(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=Pz(c[(c[d>>2]|0)+28>>2]|0)|0;i=b;return a|0}function lB(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[f>>2]=0;c[e>>2]=$B(c[d>>2]|0)|0;while(1){if(!(c[e>>2]|0))break;a=mB(c[d>>2]|0,c[e>>2]|0,0,1)|0;c[f>>2]=(c[f>>2]|0)+a;c[e>>2]=aC(c[d>>2]|0,c[e>>2]|0)|0}i=b;return c[f>>2]|0}function mB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+12|0;k=f+8|0;l=f+4|0;m=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[m>>2]=0;c[l>>2]=PA(c[g>>2]|0,c[h>>2]|0)|0;if(!(c[l>>2]|0)){n=c[m>>2]|0;i=f;return n|0}if(c[k>>2]|0){k=sB(c[(c[g>>2]|0)+32>>2]|0,(c[l>>2]|0)+32|0)|0;c[m>>2]=(c[m>>2]|0)+k}if(!(c[j>>2]|0)){n=c[m>>2]|0;i=f;return n|0}j=sB(c[(c[g>>2]|0)+32>>2]|0,(c[l>>2]|0)+28|0)|0;c[m>>2]=(c[m>>2]|0)+j;n=c[m>>2]|0;i=f;return n|0}function nB(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=b;i=d;return a[(c[e>>2]|0)+12>>0]&1|0}function oB(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=((nB(c[d>>2]|0)|0)!=0^1)&1;i=b;return a|0}function pB(a){a=a|0;var b=0,e=0;b=i;i=i+16|0;e=b;c[e>>2]=a;i=b;return (d[(c[e>>2]|0)+12>>0]|0)>>>1&1|0}function qB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+8|0;k=f+4|0;l=f;c[f+24>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+12>>2]=e;c[k>>2]=c[g>>2];c[l>>2]=c[h>>2];c[j>>2]=(c[(c[k>>2]|0)+4>>2]|0)-(c[(c[l>>2]|0)+4>>2]|0);if(!(c[j>>2]|0)){m=0;i=f;return m|0}m=(c[j>>2]|0)<0?-1:1;i=f;return m|0}function rB(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[e>>2]=b;if((c[e>>2]|0)!=0?(c[c[e>>2]>>2]|0)!=0:0)j=c[c[e>>2]>>2]|0;else j=52420;c[f>>2]=j;c[g>>2]=Fb[c[c[f>>2]>>2]&63](c[e>>2]|0)|0;c[h>>2]=Ob[c[(c[f>>2]|0)+4>>2]&127](c[g>>2]|0,68)|0;c[c[h>>2]>>2]=c[f>>2];c[(c[h>>2]|0)+12>>2]=c[g>>2];if((c[e>>2]|0)!=0?(c[(c[e>>2]|0)+4>>2]|0)!=0:0)k=c[(c[e>>2]|0)+4>>2]|0;else k=52292;c[(c[h>>2]|0)+4>>2]=k;if((c[e>>2]|0)!=0?(c[(c[e>>2]|0)+8>>2]|0)!=0:0)l=c[(c[e>>2]|0)+8>>2]|0;else l=52396;c[(c[h>>2]|0)+8>>2]=l;a[(c[h>>2]|0)+40>>0]=1;i=d;return c[h>>2]|0}function sB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;Oz(c[e>>2]|0,c[c[f>>2]>>2]|0)|0;c[g>>2]=Pz(c[e>>2]|0)|0;b=Kz(c[e>>2]|0)|0;c[c[f>>2]>>2]=b;i=d;return c[g>>2]|0}function tB(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+32|0;j=h+24|0;k=h+20|0;l=h+16|0;m=h+12|0;n=h+8|0;o=h+4|0;p=h;c[k>>2]=b;c[l>>2]=d;c[m>>2]=e;c[n>>2]=f;c[o>>2]=g;if(((c[m>>2]|0)!=0?(a[c[m>>2]>>0]|0)!=37:0)?(c[p>>2]=Gb[c[(c[(c[(c[k>>2]|0)+52>>2]|0)+4>>2]|0)+4>>2]&63](c[(c[(c[k>>2]|0)+52>>2]|0)+12+4>>2]|0,c[l>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0)|0,(c[p>>2]|0)!=0):0){c[j>>2]=c[p>>2];q=c[j>>2]|0;i=h;return q|0}if(c[m>>2]|0){c[p>>2]=FB(c[k>>2]|0,c[l>>2]|0,c[m>>2]|0,c[n>>2]|0)|0;if(c[p>>2]|0){c[j>>2]=c[p>>2];q=c[j>>2]|0;i=h;return q|0}}else c[p>>2]=0;if((c[o>>2]|0)!=0?(c[p>>2]=Gb[c[(c[(c[(c[k>>2]|0)+52>>2]|0)+4>>2]|0)+4>>2]&63](c[(c[(c[k>>2]|0)+52>>2]|0)+12+4>>2]|0,c[l>>2]|0,0,c[n>>2]|0,c[o>>2]|0)|0,(c[p>>2]|0)!=0&(c[m>>2]|0)!=0):0)GB(c[k>>2]|0,c[l>>2]|0,c[m>>2]|0,c[c[n>>2]>>2]|0);c[j>>2]=c[p>>2];q=c[j>>2]|0;i=h;return q|0}function uB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=Hb[c[(c[(c[(c[f>>2]|0)+52>>2]|0)+4>>2]|0)+8>>2]&63](c[(c[(c[f>>2]|0)+52>>2]|0)+12+4>>2]|0,c[g>>2]|0,c[h>>2]|0)|0;i=e;return d|0}function vB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;IB(c[f>>2]|0,c[g>>2]|0,c[h>>2]|0)|0;Tb[c[(c[(c[(c[f>>2]|0)+52>>2]|0)+4>>2]|0)+12>>2]&127](c[(c[(c[f>>2]|0)+52>>2]|0)+12+4>>2]|0,c[g>>2]|0,c[h>>2]|0);i=e;return}function wB(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;b=i;i=i+32|0;d=b;e=b+20|0;f=b+16|0;g=b+12|0;h=b+8|0;c[f>>2]=a;c[g>>2]=qC(c[f>>2]|0)|0;a=HB(c[g>>2]|0,c[c[f>>2]>>2]&3,c[(c[f>>2]|0)+4>>2]|0)|0;c[h>>2]=a;if(a){c[e>>2]=c[h>>2];j=c[e>>2]|0;i=b;return j|0}if((c[(c[(c[(c[g>>2]|0)+52>>2]|0)+4>>2]|0)+16>>2]|0)!=0?(a=Hb[c[(c[(c[(c[g>>2]|0)+52>>2]|0)+4>>2]|0)+16>>2]&63](c[(c[(c[g>>2]|0)+52>>2]|0)+12+4>>2]|0,c[c[f>>2]>>2]&3,c[(c[f>>2]|0)+4>>2]|0)|0,c[h>>2]=a,(a|0)!=0):0){c[e>>2]=c[h>>2];j=c[e>>2]|0;i=b;return j|0}if((c[c[f>>2]>>2]&3|0)!=2){a=c[(c[f>>2]|0)+4>>2]|0;c[d>>2]=37;c[d+4>>2]=a;k3(134116,134148,d)|0;c[h>>2]=134116}else c[h>>2]=0;c[e>>2]=c[h>>2];j=c[e>>2]|0;i=b;return j|0}function xB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;Tb[c[(c[(c[(c[f>>2]|0)+52>>2]|0)+4>>2]|0)+24>>2]&127](c[(c[(c[f>>2]|0)+52>>2]|0)+12+4>>2]|0,c[g>>2]|0,c[h>>2]|0);i=e;return}function yB(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d+4|0;c[e>>2]=a;c[d>>2]=b;i=d;return c[e>>2]|0}function zB(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;i=i+32|0;h=g+24|0;j=g+16|0;k=g+12|0;l=g+8|0;m=g+4|0;n=g;c[h>>2]=a;c[g+20>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=f;if(!(c[j>>2]|0)){c[c[k>>2]>>2]=c[13080];c[13080]=(c[13080]|0)+2;i=g;return 1}c[n>>2]=c[h>>2];h=c[n>>2]|0;n=c[j>>2]|0;if(c[l>>2]|0)c[m>>2]=YC(h,n)|0;else c[m>>2]=XC(h,n)|0;c[c[k>>2]>>2]=c[m>>2];i=g;return 1}function AB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e+8>>2]=a;c[e+4>>2]=b;c[e>>2]=d;i=e;return 0}function BB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[f>>2]=a;c[e+4>>2]=b;c[g>>2]=d;if(((c[g>>2]|0)>>>0)%2|0){i=e;return}_C(c[f>>2]|0,c[g>>2]|0)|0;i=e;return}function CB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+12|0;g=e;c[e+8>>2]=a;c[e+4>>2]=b;c[g>>2]=d;if(!(((c[g>>2]|0)>>>0)%2|0)){c[f>>2]=c[g>>2];h=c[f>>2]|0;i=e;return h|0}else{c[f>>2]=0;h=c[f>>2]|0;i=e;return h|0}return 0}function DB(a){a=a|0;var b=0;b=i;i=i+16|0;c[b>>2]=a;i=b;return}function EB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e+8>>2]=a;c[e+4>>2]=b;c[e>>2]=d;i=e;return}function FB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+64|0;g=f+56|0;h=f+52|0;j=f+48|0;k=f+44|0;l=f+40|0;m=f+36|0;n=f+32|0;o=f+8|0;p=f;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;if((c[j>>2]|0)==3)c[j>>2]=2;e=c[(c[(c[h>>2]|0)+52>>2]|0)+44+(c[j>>2]<<2)>>2]|0;c[m>>2]=e;if(((e|0)!=0?(e=XC(c[h>>2]|0,c[k>>2]|0)|0,c[p>>2]=e,(e|0)!=0):0)?(c[o+20>>2]=c[p>>2],c[n>>2]=Hb[c[c[m>>2]>>2]&63](c[m>>2]|0,o,4)|0,(c[n>>2]|0)!=0):0){c[c[l>>2]>>2]=c[(c[n>>2]|0)+16>>2];c[g>>2]=1;q=c[g>>2]|0;i=f;return q|0}c[g>>2]=0;q=c[g>>2]|0;i=f;return q|0}function GB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=UB(c[g>>2]|0,24)|0;c[(c[l>>2]|0)+16>>2]=c[k>>2];k=YC(c[g>>2]|0,c[j>>2]|0)|0;c[(c[l>>2]|0)+20>>2]=k;if((c[h>>2]|0)==3)c[h>>2]=2;k=c[(c[(c[g>>2]|0)+52>>2]|0)+44+(c[h>>2]<<2)>>2]|0;c[m>>2]=k;if(!k){k=OD(c[g>>2]|0,52324,c[12993]|0)|0;c[(c[(c[g>>2]|0)+52>>2]|0)+44+(c[h>>2]<<2)>>2]=k;c[m>>2]=k}k=c[(c[(c[g>>2]|0)+52>>2]|0)+56+(c[h>>2]<<2)>>2]|0;c[n>>2]=k;if(k){o=c[m>>2]|0;p=c[o>>2]|0;q=c[m>>2]|0;r=c[l>>2]|0;Hb[p&63](q,r,1)|0;s=c[n>>2]|0;t=c[s>>2]|0;u=c[n>>2]|0;v=c[l>>2]|0;Hb[t&63](u,v,1)|0;i=f;return}k=OD(c[g>>2]|0,52360,c[12993]|0)|0;c[(c[(c[g>>2]|0)+52>>2]|0)+56+(c[h>>2]<<2)>>2]=k;c[n>>2]=k;o=c[m>>2]|0;p=c[o>>2]|0;q=c[m>>2]|0;r=c[l>>2]|0;Hb[p&63](q,r,1)|0;s=c[n>>2]|0;t=c[s>>2]|0;u=c[n>>2]|0;v=c[l>>2]|0;Hb[t&63](u,v,1)|0;i=f;return}function HB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;d=LB(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;c[k>>2]=d;if(d){c[f>>2]=c[(c[k>>2]|0)+20>>2];l=c[f>>2]|0;i=e;return l|0}else{c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}return 0}function IB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if((c[h>>2]|0)==3)c[h>>2]=2;d=LB(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;c[k>>2]=d;if(d){Hb[c[c[(c[(c[g>>2]|0)+52>>2]|0)+44+(c[h>>2]<<2)>>2]>>2]&63](c[(c[(c[g>>2]|0)+52>>2]|0)+44+(c[h>>2]<<2)>>2]|0,c[k>>2]|0,2)|0;Hb[c[c[(c[(c[g>>2]|0)+52>>2]|0)+56+(c[h>>2]<<2)>>2]>>2]&63](c[(c[(c[g>>2]|0)+52>>2]|0)+56+(c[h>>2]<<2)>>2]|0,c[k>>2]|0,2)|0;_C(c[g>>2]|0,c[(c[k>>2]|0)+20>>2]|0)|0;VB(c[g>>2]|0,c[k>>2]|0);c[f>>2]=1;l=c[f>>2]|0;i=e;return l|0}else{c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}return 0}function JB(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=b;c[13072]=c[e>>2];c[j>>2]=(c[(c[e>>2]|0)+52>>2]|0)+44;c[f>>2]=0;while(1){if((c[f>>2]|0)>=3)break;a:do if(c[(c[j>>2]|0)+(c[f>>2]<<2)>>2]|0){c[g>>2]=Hb[c[c[(c[j>>2]|0)+(c[f>>2]<<2)>>2]>>2]&63](c[(c[j>>2]|0)+(c[f>>2]<<2)>>2]|0,0,128)|0;while(1){if(!(c[g>>2]|0))break a;c[h>>2]=Hb[c[c[(c[j>>2]|0)+(c[f>>2]<<2)>>2]>>2]&63](c[(c[j>>2]|0)+(c[f>>2]<<2)>>2]|0,c[g>>2]|0,8)|0;if((a[c[(c[g>>2]|0)+20>>2]>>0]|0)==37)IB(c[e>>2]|0,c[f>>2]|0,c[(c[g>>2]|0)+16>>2]|0)|0;c[g>>2]=c[h>>2]}}while(0);c[f>>2]=(c[f>>2]|0)+1}i=d;return}function KB(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;c[13072]=c[d>>2];MB((c[(c[d>>2]|0)+52>>2]|0)+44|0);MB((c[(c[d>>2]|0)+52>>2]|0)+56|0);i=b;return}function LB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+48|0;f=e+40|0;g=e+36|0;h=e+32|0;j=e+28|0;k=e+24|0;l=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if((c[g>>2]|0)==3)c[g>>2]=2;d=c[(c[(c[f>>2]|0)+52>>2]|0)+56+(c[g>>2]<<2)>>2]|0;c[j>>2]=d;if(d){c[l+16>>2]=c[h>>2];c[k>>2]=Hb[c[c[j>>2]>>2]&63](c[j>>2]|0,l,4)|0;m=c[k>>2]|0;i=e;return m|0}else{c[k>>2]=0;m=c[k>>2]|0;i=e;return m|0}return 0}function MB(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=0;while(1){if((c[e>>2]|0)>=3)break;if(c[(c[d>>2]|0)+(c[e>>2]<<2)>>2]|0){Jz(c[(c[d>>2]|0)+(c[e>>2]<<2)>>2]|0)|0;c[(c[d>>2]|0)+(c[e>>2]<<2)>>2]=0}c[e>>2]=(c[e>>2]|0)+1}i=b;return}function NB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+4|0;k=f;c[f+20>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+8>>2]=e;c[j>>2]=c[g>>2];c[k>>2]=c[h>>2];i=f;return (c[(c[j>>2]|0)+16>>2]|0)-(c[(c[k>>2]|0)+16>>2]|0)|0}function OB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+4|0;k=f;c[f+20>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+8>>2]=e;c[j>>2]=c[g>>2];c[k>>2]=c[h>>2];i=f;return (c[(c[j>>2]|0)+20>>2]|0)-(c[(c[k>>2]|0)+20>>2]|0)|0}function PB(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+32|0;d=b+28|0;e=b+24|0;f=b+12|0;g=b;c[d>>2]=a;c[13103]=c[13100];c[13104]=c[13101];c[f>>2]=c[d>>2];c[f+4>>2]=N3(c[d>>2]|0)|0;c[f+8>>2]=0;c[g>>2]=52420;c[g+4>>2]=52292;c[g+8>>2]=52408;c[e>>2]=CE(f,g)|0;i=b;return c[e>>2]|0}function QB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if(V2(c[h>>2]|0,c[j>>2]|0,c[g>>2]|0)|0){c[f>>2]=N3(c[h>>2]|0)|0;k=c[f>>2]|0;i=e;return k|0}else{c[f>>2]=0;k=c[f>>2]|0;i=e;return k|0}return 0}function RB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=_2(c[f>>2]|0,c[e>>2]|0)|0;i=d;return b|0}function SB(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=T2(c[d>>2]|0)|0;i=b;return a|0}function TB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+48|0;g=f+28|0;h=f+24|0;j=f+20|0;k=f+16|0;l=f+12|0;m=f+8|0;n=f+32|0;o=f+4|0;p=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;if(!(c[k>>2]|0)){c[g>>2]=0;q=c[g>>2]|0;i=f;return q|0}c[p>>2]=c[h>>2];if((c[(c[p>>2]|0)+8>>2]|0)>=(c[(c[p>>2]|0)+4>>2]|0)){c[g>>2]=0;q=c[g>>2]|0;i=f;return q|0}c[o>>2]=0;c[l>>2]=(c[c[p>>2]>>2]|0)+(c[(c[p>>2]|0)+8>>2]|0);c[m>>2]=c[j>>2];j=c[l>>2]|0;c[l>>2]=j+1;a[n>>0]=a[j>>0]|0;do{j=a[n>>0]|0;h=c[m>>2]|0;c[m>>2]=h+1;a[h>>0]=j;c[o>>2]=(c[o>>2]|0)+1;if((a[n>>0]|0)==10)break;if((c[o>>2]|0)>=(c[k>>2]|0))break;j=c[l>>2]|0;c[l>>2]=j+1;h=a[j>>0]|0;a[n>>0]=h}while((h<<24>>24|0)!=0);n=(c[p>>2]|0)+8|0;c[n>>2]=(c[n>>2]|0)+(c[o>>2]|0);c[g>>2]=c[o>>2];q=c[g>>2]|0;i=f;return q|0}function UB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;c[e>>2]=a;c[f>>2]=b;c[g>>2]=Ob[c[(c[c[(c[e>>2]|0)+52>>2]>>2]|0)+4>>2]&127](c[(c[(c[e>>2]|0)+52>>2]|0)+12>>2]|0,c[f>>2]|0)|0;if(c[g>>2]|0){h=c[g>>2]|0;i=d;return h|0}$z(1,134154,d)|0;h=c[g>>2]|0;i=d;return h|0}function VB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;if(!(c[f>>2]|0)){i=d;return}Db[c[(c[c[(c[e>>2]|0)+52>>2]>>2]|0)+12>>2]&31](c[(c[(c[e>>2]|0)+52>>2]|0)+12>>2]|0,c[f>>2]|0);i=d;return}function WB(a){a=a|0;var b=0;b=i;i=i+16|0;c[b>>2]=a;i=b;return 0}function XB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[d+8>>2]=a;c[e>>2]=b;c[f>>2]=N4(c[e>>2]|0)|0;$4(c[f>>2]|0,0,c[e>>2]|0)|0;i=d;return c[f>>2]|0}function YB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+32|0;g=f+12|0;h=f+8|0;j=f+4|0;k=f;c[f+16>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;c[k>>2]=Q4(c[g>>2]|0,c[j>>2]|0)|0;if((c[j>>2]|0)>>>0<=(c[h>>2]|0)>>>0){l=c[k>>2]|0;i=f;return l|0}$4((c[k>>2]|0)+(c[h>>2]|0)|0,0,(c[j>>2]|0)-(c[h>>2]|0)|0)|0;l=c[k>>2]|0;i=f;return l|0}function ZB(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[d+4>>2]=a;c[e>>2]=b;O4(c[e>>2]|0);i=d;return}function _B(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[13129]=c[f>>2];c[13145]=52512;c[g>>2]=Hb[c[c[(c[e>>2]|0)+28>>2]>>2]&63](c[(c[e>>2]|0)+28>>2]|0,52564,4)|0;if(!(c[g>>2]|0)){h=0;i=d;return h|0}h=c[(c[g>>2]|0)+16>>2]|0;i=d;return h|0}function $B(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=Hb[c[c[(c[d>>2]|0)+24>>2]>>2]&63](c[(c[d>>2]|0)+24>>2]|0,0,128)|0;if(!(c[e>>2]|0)){f=0;i=b;return f|0}f=c[(c[e>>2]|0)+16>>2]|0;i=b;return f|0}function aC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=PA(c[e>>2]|0,c[f>>2]|0)|0;if(c[g>>2]|0)c[g>>2]=Hb[c[c[(c[e>>2]|0)+24>>2]>>2]&63](c[(c[e>>2]|0)+24>>2]|0,c[g>>2]|0,8)|0;if(!(c[g>>2]|0)){h=0;i=d;return h|0}h=c[(c[g>>2]|0)+16>>2]|0;i=d;return h|0}function bC(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=Hb[c[c[(c[d>>2]|0)+24>>2]>>2]&63](c[(c[d>>2]|0)+24>>2]|0,0,256)|0;if(!(c[e>>2]|0)){f=0;i=b;return f|0}f=c[(c[e>>2]|0)+16>>2]|0;i=b;return f|0}function cC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=PA(c[e>>2]|0,c[f>>2]|0)|0;if(c[g>>2]|0)c[g>>2]=Hb[c[c[(c[e>>2]|0)+24>>2]>>2]&63](c[(c[e>>2]|0)+24>>2]|0,c[g>>2]|0,16)|0;if(!(c[g>>2]|0)){h=0;i=d;return h|0}h=c[(c[g>>2]|0)+16>>2]|0;i=d;return h|0}function dC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[k>>2]=_B(c[f>>2]|0,c[g>>2]|0)|0;if(!((c[k>>2]|0)==0&(c[h>>2]|0)!=0)){l=c[k>>2]|0;i=e;return l|0}c[j>>2]=rC(c[f>>2]|0)|0;if((c[f>>2]|0)!=(c[j>>2]|0)?(h=_B(c[j>>2]|0,c[g>>2]|0)|0,c[k>>2]=h,(h|0)!=0):0){eC(c[f>>2]|0,c[k>>2]|0,1)|0;l=c[k>>2]|0;i=e;return l|0}if(uB(c[f>>2]|0,1,c[g>>2]|0)|0){h=c[f>>2]|0;j=c[g>>2]|0;c[k>>2]=kC(h,j,iB(c[f>>2]|0,1)|0)|0;lC(c[f>>2]|0,c[k>>2]|0);mC(c[f>>2]|0,c[k>>2]|0);l=c[k>>2]|0;i=e;return l|0}else{c[k>>2]=0;l=c[k>>2]|0;i=e;return l|0}return 0}function eC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;d=rC(c[g>>2]|0)|0;if((d|0)!=(c[(c[h>>2]|0)+12>>2]|0)){c[f>>2]=0;m=c[f>>2]|0;i=e;return m|0}c[l>>2]=_B(c[g>>2]|0,c[(c[h>>2]|0)+4>>2]|0)|0;if((c[l>>2]|0)==0&(c[j>>2]|0)!=0?(d=ID(c[g>>2]|0)|0,c[k>>2]=d,(d|0)!=0):0){c[l>>2]=eC(c[k>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;nC(c[g>>2]|0,c[l>>2]|0)}c[f>>2]=c[l>>2];m=c[f>>2]|0;i=e;return m|0}function fC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+32|0;f=e+24|0;g=e+20|0;h=e+16|0;j=e+12|0;k=e+8|0;l=e+4|0;m=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=rC(c[g>>2]|0)|0;if(tB(c[g>>2]|0,1,c[h>>2]|0,m,0)|0){d=_B(c[g>>2]|0,c[m>>2]|0)|0;c[l>>2]=d;if(d){c[f>>2]=c[l>>2];n=c[f>>2]|0;i=e;return n|0}if(((c[j>>2]|0)!=0?(c[g>>2]|0)!=(c[k>>2]|0):0)?(d=_B(c[k>>2]|0,c[m>>2]|0)|0,c[l>>2]=d,(d|0)!=0):0){c[f>>2]=eC(c[g>>2]|0,c[l>>2]|0,1)|0;n=c[f>>2]|0;i=e;return n|0}}if((c[j>>2]|0)!=0?(tB(c[g>>2]|0,1,c[h>>2]|0,m,1)|0)!=0:0){h=c[g>>2]|0;j=c[m>>2]|0;c[l>>2]=kC(h,j,iB(c[g>>2]|0,1)|0)|0;lC(c[g>>2]|0,c[l>>2]|0);mC(c[g>>2]|0,c[l>>2]|0);xB(c[g>>2]|0,1,c[l>>2]|0);c[f>>2]=c[l>>2];n=c[f>>2]|0;i=e;return n|0}c[f>>2]=0;n=c[f>>2]|0;i=e;return n|0}function gC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[e+8>>2]=d;c[13154]=c[g>>2];c[h>>2]=TA(c[f>>2]|0,c[g>>2]|0)|0;while(1){k=c[f>>2]|0;if(!(c[h>>2]|0))break;c[j>>2]=UA(k,c[h>>2]|0,c[g>>2]|0)|0;WA(c[f>>2]|0,c[h>>2]|0,0);c[h>>2]=c[j>>2]}Hb[c[c[k+28>>2]>>2]&63](c[(c[f>>2]|0)+28>>2]|0,52600,2)|0;Hb[c[c[(c[f>>2]|0)+24>>2]>>2]&63](c[(c[f>>2]|0)+24>>2]|0,52600,2)|0;i=e;return}function hC(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=a;c[h>>2]=b;if(!(_B(c[g>>2]|0,c[(c[h>>2]|0)+4>>2]|0)|0)){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}b=c[g>>2]|0;if((b|0)==(rC(c[g>>2]|0)|0)){c[j>>2]=TA(c[g>>2]|0,c[h>>2]|0)|0;while(1){m=c[g>>2]|0;if(!(c[j>>2]|0))break;c[k>>2]=UA(m,c[j>>2]|0,c[h>>2]|0)|0;XA(c[g>>2]|0,c[j>>2]|0)|0;c[j>>2]=c[k>>2]}if((d[m+12>>0]|0)>>>6&1)vA(c[h>>2]|0);wC(c[g>>2]|0,c[h>>2]|0);QC(c[h>>2]|0);vB(c[g>>2]|0,1,c[(c[h>>2]|0)+4>>2]|0)}if(vE(c[g>>2]|0,c[h>>2]|0,56,0,0)|0){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}m=c[g>>2]|0;if((m|0)==(rC(c[g>>2]|0)|0))VB(c[g>>2]|0,c[h>>2]|0);c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}function iC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+8|0;k=f+4|0;l=f;c[f+24>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+12>>2]=e;c[k>>2]=c[g>>2];c[l>>2]=c[h>>2];c[j>>2]=(c[(c[(c[k>>2]|0)+16>>2]|0)+4>>2]|0)-(c[(c[(c[l>>2]|0)+16>>2]|0)+4>>2]|0);if(!(c[j>>2]|0)){m=0;i=f;return m|0}m=(c[j>>2]|0)<0?-1:1;i=f;return m|0}function jC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+8|0;k=f+4|0;l=f;c[f+24>>2]=a;c[g>>2]=b;c[h>>2]=d;c[f+12>>2]=e;c[j>>2]=c[g>>2];c[k>>2]=c[h>>2];c[l>>2]=((c[c[(c[j>>2]|0)+16>>2]>>2]|0)>>>4)-((c[c[(c[k>>2]|0)+16>>2]>>2]|0)>>>4);if(!(c[l>>2]|0)){m=0;i=f;return m|0}m=(c[l>>2]|0)<0?-1:1;i=f;return m|0}function kC(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;g=f+12|0;h=f+8|0;j=f+4|0;k=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=e;c[k>>2]=UB(c[g>>2]|0,52)|0;e=c[k>>2]|0;c[e>>2]=c[e>>2]&-4|1;c[(c[k>>2]|0)+4>>2]=c[h>>2];h=c[k>>2]|0;c[h>>2]=c[h>>2]&15|(c[j>>2]&268435455)<<4;j=rC(c[g>>2]|0)|0;c[(c[k>>2]|0)+12>>2]=j;if(!((d[(rC(c[g>>2]|0)|0)+12>>0]|0)>>>6&1)){l=c[k>>2]|0;i=f;return l|0}MC(c[k>>2]|0,c[13015]|0,16,0)|0;l=c[k>>2]|0;i=f;return l|0}function lC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;nC(c[e>>2]|0,c[f>>2]|0);b=ID(c[e>>2]|0)|0;c[g>>2]=b;if(!b){i=d;return}lC(c[g>>2]|0,c[f>>2]|0);i=d;return}function mC(a,b){a=a|0;b=b|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;c[f>>2]=a;c[g>>2]=b;if((d[(rC(c[f>>2]|0)|0)+12>>0]|0)>>>6&1)uA(c[f>>2]|0,c[g>>2]|0);sC(c[f>>2]|0,c[g>>2]|0);i=e;return}function nC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;c[e>>2]=a;c[f>>2]=b;c[d>>2]=Pz(c[(c[e>>2]|0)+28>>2]|0)|0;b=c[e>>2]|0;if((b|0)==(rC(c[e>>2]|0)|0))c[g>>2]=(c[f>>2]|0)+16;else c[g>>2]=UB(c[e>>2]|0,36)|0;c[(c[g>>2]|0)+16>>2]=c[f>>2];Hb[c[c[(c[e>>2]|0)+28>>2]>>2]&63](c[(c[e>>2]|0)+28>>2]|0,c[g>>2]|0,1)|0;Hb[c[c[(c[e>>2]|0)+24>>2]>>2]&63](c[(c[e>>2]|0)+24>>2]|0,c[g>>2]|0,1)|0;i=d;return}function oC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e+4|0;c[e+8>>2]=a;c[f>>2]=b;c[e>>2]=d;if((c[f>>2]|0)==((c[(c[f>>2]|0)+16>>2]|0)+16|0)){i=e;return}VB(c[(c[(c[f>>2]|0)+16>>2]|0)+12>>2]|0,c[f>>2]|0);i=e;return}function pC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d;f=d+12|0;g=d+8|0;h=d+4|0;c[g>>2]=a;c[h>>2]=b;if((c[c[h>>2]>>2]&3|0)==0?(b=c[g>>2]|0,(b|0)!=(ID(c[h>>2]|0)|0)):0){$z(1,134180,e)|0;c[f>>2]=-1}else j=4;a:do if((j|0)==4)switch(c[c[h>>2]>>2]&3|0){case 1:{c[f>>2]=hC(c[g>>2]|0,c[h>>2]|0)|0;break a;break}case 2:case 3:{c[f>>2]=XA(c[g>>2]|0,c[h>>2]|0)|0;break a;break}case 0:{c[f>>2]=jB(c[h>>2]|0)|0;break a;break}default:{}}while(0);i=d;return c[f>>2]|0}function qC(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[e>>2]=a;switch(c[c[e>>2]>>2]&3|0){case 2:case 3:{c[d>>2]=c[(c[(c[e>>2]|0)+28>>2]|0)+12>>2];break}case 1:{c[d>>2]=c[(c[e>>2]|0)+12>>2];break}case 0:{c[d>>2]=c[e>>2];break}default:{}}i=b;return c[d>>2]|0}function rC(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[e>>2]=a;switch(c[c[e>>2]>>2]&3|0){case 2:case 3:{c[d>>2]=c[(c[(c[e>>2]|0)+28>>2]|0)+12>>2];break}case 1:{c[d>>2]=c[(c[e>>2]|0)+12>>2];break}case 0:{c[d>>2]=c[(c[e>>2]|0)+48>>2];break}default:{}}i=b;return c[d>>2]|0}function sC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;c[f>>2]=b;c[g>>2]=d;d=c[f>>2]|0;b=c[g>>2]|0;if(a[(c[(c[f>>2]|0)+52>>2]|0)+40>>0]|0){tC(d,b,c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2]|0);i=e;return}else{CC(d,b,100,0);i=e;return}}function tC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if(!(c[h>>2]|0)){i=e;return}tC(c[f>>2]|0,c[g>>2]|0,c[(c[h>>2]|0)+8>>2]|0);c[j>>2]=0;switch(c[c[g>>2]>>2]&3|0){case 0:{c[j>>2]=c[c[c[h>>2]>>2]>>2];break}case 1:{c[j>>2]=c[(c[c[h>>2]>>2]|0)+12>>2];break}case 2:{c[j>>2]=c[(c[c[h>>2]>>2]|0)+24>>2];break}default:{}}if(!(c[j>>2]|0)){i=e;return}Tb[c[j>>2]&127](c[f>>2]|0,c[g>>2]|0,c[(c[h>>2]|0)+4>>2]|0);i=e;return}function uC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+16|0;g=f+8|0;h=f+4|0;j=f;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;e=c[g>>2]|0;d=c[h>>2]|0;if(a[(c[(c[g>>2]|0)+52>>2]|0)+40>>0]|0){vC(e,d,c[j>>2]|0,c[(c[(c[g>>2]|0)+52>>2]|0)+36>>2]|0);i=f;return}else{CC(e,d,101,c[j>>2]|0);i=f;return}}function vC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;if(!(c[k>>2]|0)){i=f;return}vC(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0,c[(c[k>>2]|0)+8>>2]|0);c[l>>2]=0;switch(c[c[h>>2]>>2]&3|0){case 0:{c[l>>2]=c[(c[c[k>>2]>>2]|0)+4>>2];break}case 1:{c[l>>2]=c[(c[c[k>>2]>>2]|0)+12+4>>2];break}case 2:{c[l>>2]=c[(c[c[k>>2]>>2]|0)+24+4>>2];break}default:{}}if(!(c[l>>2]|0)){i=f;return}Vb[c[l>>2]&31](c[g>>2]|0,c[h>>2]|0,c[(c[k>>2]|0)+4>>2]|0,c[j>>2]|0);i=f;return}function wC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;c[f>>2]=b;c[g>>2]=d;d=c[f>>2]|0;b=c[g>>2]|0;if(a[(c[(c[f>>2]|0)+52>>2]|0)+40>>0]|0){xC(d,b,c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2]|0);i=e;return}else{CC(d,b,102,0);i=e;return}}function xC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if(!(c[h>>2]|0)){i=e;return}xC(c[f>>2]|0,c[g>>2]|0,c[(c[h>>2]|0)+8>>2]|0);c[j>>2]=0;switch(c[c[g>>2]>>2]&3|0){case 0:{c[j>>2]=c[(c[c[h>>2]>>2]|0)+8>>2];break}case 1:{c[j>>2]=c[(c[c[h>>2]>>2]|0)+12+8>>2];break}case 2:{c[j>>2]=c[(c[c[h>>2]>>2]|0)+24+8>>2];break}default:{}}if(!(c[j>>2]|0)){i=e;return}Tb[c[j>>2]&127](c[f>>2]|0,c[g>>2]|0,c[(c[h>>2]|0)+4>>2]|0);i=e;return}function yC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=UB(c[f>>2]|0,12)|0;c[c[j>>2]>>2]=c[g>>2];c[(c[j>>2]|0)+4>>2]=c[h>>2];c[(c[j>>2]|0)+8>>2]=c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2];c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2]=c[j>>2];i=e;return}function zC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2];if(c[h>>2]|0){if((c[c[h>>2]>>2]|0)!=(c[g>>2]|0)){while(1){if(c[h>>2]|0)j=(c[c[(c[h>>2]|0)+8>>2]>>2]|0)!=(c[g>>2]|0);else j=0;k=c[h>>2]|0;if(!j)break;c[h>>2]=c[k+8>>2]}if((k|0)!=0?(c[(c[h>>2]|0)+8>>2]|0)!=0:0)c[(c[h>>2]|0)+8>>2]=c[(c[(c[h>>2]|0)+8>>2]|0)+8>>2]}else c[(c[(c[f>>2]|0)+52>>2]|0)+36>>2]=c[(c[h>>2]|0)+8>>2];if(c[h>>2]|0){VB(c[f>>2]|0,c[h>>2]|0);c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}}c[e>>2]=-1;l=c[e>>2]|0;i=d;return l|0}function AC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;b=rC(c[f>>2]|0)|0;a:do if((b|0)!=(rC(c[g>>2]|0)|0))c[e>>2]=0;else switch(c[c[g>>2]>>2]&3|0){case 0:{c[h>>2]=c[g>>2];while(1){if((c[h>>2]|0)==(c[f>>2]|0)){j=6;break}a=ID(c[h>>2]|0)|0;c[h>>2]=a;if(!a){j=8;break}}if((j|0)==6){c[e>>2]=1;break a}else if((j|0)==8){c[e>>2]=0;break a}break}case 1:{c[e>>2]=(dC(c[f>>2]|0,c[(c[g>>2]|0)+4>>2]|0,0)|0)!=0&1;break a;break}default:{c[e>>2]=(YA(c[f>>2]|0,c[g>>2]|0,0)|0)!=0&1;break a}}while(0);i=d;return c[e>>2]|0}function BC(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;i=b;return c[c[d>>2]>>2]&3|0}function CC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+28|0;h=f+24|0;j=f+20|0;k=f+16|0;l=f+12|0;m=f+8|0;n=f+4|0;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=MC(c[g>>2]|0,134204,44,0)|0;switch(c[j>>2]|0){case 100:{c[m>>2]=DC(c[l>>2]|0,c[h>>2]|0,100)|0;c[n>>2]=EC(c[m>>2]|0,c[h>>2]|0)|0;if(c[n>>2]|0){i=f;return}c[n>>2]=FC(c[m>>2]|0,c[g>>2]|0,c[h>>2]|0,c[k>>2]|0)|0;i=f;return}case 101:{if(EC(DC(c[l>>2]|0,c[h>>2]|0,100)|0,c[h>>2]|0)|0){i=f;return}if(EC(DC(c[l>>2]|0,c[h>>2]|0,102)|0,c[h>>2]|0)|0){i=f;return}c[m>>2]=DC(c[l>>2]|0,c[h>>2]|0,101)|0;c[n>>2]=EC(c[m>>2]|0,c[h>>2]|0)|0;if(!(c[n>>2]|0))c[n>>2]=FC(c[m>>2]|0,c[g>>2]|0,c[h>>2]|0,c[k>>2]|0)|0;GC(c[h>>2]|0,c[n>>2]|0,c[k>>2]|0);i=f;return}case 102:{HC(DC(c[l>>2]|0,c[h>>2]|0,100)|0,c[h>>2]|0);HC(DC(c[l>>2]|0,c[h>>2]|0,101)|0,c[h>>2]|0);c[m>>2]=DC(c[l>>2]|0,c[h>>2]|0,102)|0;c[n>>2]=EC(c[m>>2]|0,c[h>>2]|0)|0;if(c[n>>2]|0){i=f;return}c[n>>2]=FC(c[m>>2]|0,c[g>>2]|0,c[h>>2]|0,c[k>>2]|0)|0;i=f;return}default:{$z(1,134216,f)|0;i=f;return}}}function DC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=0;c[k>>2]=0;a:do switch(c[c[h>>2]>>2]&3|0){case 0:{switch(c[j>>2]|0){case 100:{c[k>>2]=(c[g>>2]|0)+8;break a;break}case 101:{c[k>>2]=(c[g>>2]|0)+20;break a;break}case 102:{c[k>>2]=(c[g>>2]|0)+32;break a;break}default:break a}break}case 1:{switch(c[j>>2]|0){case 100:{c[k>>2]=(c[g>>2]|0)+8+4;break a;break}case 101:{c[k>>2]=(c[g>>2]|0)+20+4;break a;break}case 102:{c[k>>2]=(c[g>>2]|0)+32+4;break a;break}default:break a}break}case 2:{switch(c[j>>2]|0){case 100:{c[k>>2]=(c[g>>2]|0)+8+8;break a;break}case 101:{c[k>>2]=(c[g>>2]|0)+20+8;break a;break}case 102:{c[k>>2]=(c[g>>2]|0)+32+8;break a;break}default:break a}break}default:{}}while(0);if(!(c[k>>2]|0))$z(1,134250,f)|0;if(c[c[k>>2]>>2]|0){l=c[k>>2]|0;m=c[l>>2]|0;i=e;return m|0}f=qC(c[h>>2]|0)|0;h=OD(f,52636,c[12993]|0)|0;c[c[k>>2]>>2]=h;l=c[k>>2]|0;m=c[l>>2]|0;i=e;return m|0}function EC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+48|0;e=d+36|0;f=d+32|0;g=d+8|0;h=d;c[e>>2]=a;c[f>>2]=b;c[g+8>>2]=IC(c[f>>2]|0)|0;c[h>>2]=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,4)|0;i=d;return c[h>>2]|0}function FC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=UB(qC(c[j>>2]|0)|0,24)|0;c[(c[l>>2]|0)+16>>2]=c[j>>2];e=IC(c[j>>2]|0)|0;c[(c[l>>2]|0)+8>>2]=e;c[(c[l>>2]|0)+12>>2]=c[h>>2];if(!(c[k>>2]|0)){m=c[g>>2]|0;n=c[m>>2]|0;o=c[g>>2]|0;p=c[l>>2]|0;Hb[n&63](o,p,1)|0;q=c[l>>2]|0;i=f;return q|0}h=UB(c[(c[l>>2]|0)+12>>2]|0,8)|0;c[(c[l>>2]|0)+20>>2]=h;c[c[(c[l>>2]|0)+20>>2]>>2]=c[k>>2];m=c[g>>2]|0;n=c[m>>2]|0;o=c[g>>2]|0;p=c[l>>2]|0;Hb[n&63](o,p,1)|0;q=c[l>>2]|0;i=f;return q|0}function GC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[l>>2]=0;c[j>>2]=c[(c[g>>2]|0)+20>>2];while(1){if(!(c[j>>2]|0)){m=9;break}if((c[c[j>>2]>>2]|0)==(c[h>>2]|0)){m=9;break}do if(!(c[j>>2]|0)){c[k>>2]=UB(qC(c[f>>2]|0)|0,8)|0;c[c[k>>2]>>2]=c[h>>2];d=c[k>>2]|0;if(c[l>>2]|0){c[(c[l>>2]|0)+4>>2]=d;break}else{c[(c[g>>2]|0)+20>>2]=d;break}}while(0);c[l>>2]=c[j>>2];c[j>>2]=c[(c[j>>2]|0)+4>>2]}if((m|0)==9){i=e;return}}function HC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;b=EC(c[e>>2]|0,c[f>>2]|0)|0;c[g>>2]=b;if(!b){i=d;return}Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,c[g>>2]|0,2)|0;i=d;return}function IC(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;i=b;return c[(c[d>>2]|0)+4>>2]|0}function JC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=c[f>>2];KC(c[g>>2]|0);VB(c[(c[g>>2]|0)+12>>2]|0,c[g>>2]|0);i=e;return}function KC(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[e>>2]=c[(c[d>>2]|0)+20>>2];while(1){if(!(c[e>>2]|0))break;c[f>>2]=c[(c[e>>2]|0)+4>>2];VB(c[(c[d>>2]|0)+12>>2]|0,c[e>>2]|0);c[e>>2]=c[f>>2]}i=b;return}function LC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+32|0;g=f;h=f+24|0;j=f+20|0;k=f+16|0;l=f+12|0;m=f+8|0;n=f+4|0;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=c[h>>2];h=c[(c[l>>2]|0)+8>>2]|0;c[m>>2]=h;c[n>>2]=h;while(1){if(!(c[m>>2]|0))break;if((c[c[m>>2]>>2]|0)==(c[j>>2]|0))break;if((a[c[j>>2]>>0]|0)==(a[c[c[m>>2]>>2]>>0]|0)?(J3(c[j>>2]|0,c[c[m>>2]>>2]|0)|0)==0:0)break;c[m>>2]=c[(c[m>>2]|0)+4>>2];if((c[m>>2]|0)==(c[n>>2]|0)){o=7;break}}if((o|0)==7)c[m>>2]=0;if(!(c[m>>2]|0)){p=c[m>>2]|0;i=f;return p|0}if(!((c[c[l>>2]>>2]|0)>>>2&1)){if((c[m>>2]|0)==(c[n>>2]|0)?(c[k>>2]|0)==((c[c[l>>2]>>2]|0)>>>2&1|0):0){p=c[m>>2]|0;i=f;return p|0}RC(c[l>>2]|0,c[m>>2]|0,c[k>>2]|0);p=c[m>>2]|0;i=f;return p|0}if(!(c[k>>2]|0)){p=c[m>>2]|0;i=f;return p|0}if((c[(c[l>>2]|0)+8>>2]|0)==(c[m>>2]|0)){p=c[m>>2]|0;i=f;return p|0}$z(1,134275,g)|0;p=c[m>>2]|0;i=f;return p|0}function MC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[m>>2]=c[g>>2];c[l>>2]=qC(c[m>>2]|0)|0;c[n>>2]=LC(c[m>>2]|0,c[h>>2]|0,0)|0;a:do if((c[n>>2]|0)==0&(c[j>>2]|0)>>>0>0){c[n>>2]=UB(c[l>>2]|0,c[j>>2]|0)|0;e=YC(c[l>>2]|0,c[h>>2]|0)|0;c[c[n>>2]>>2]=e;switch(c[c[m>>2]>>2]&3|0){case 0:{SC(c[l>>2]|0,c[m>>2]|0,c[n>>2]|0);break a;break}case 1:{SC(c[l>>2]|0,c[m>>2]|0,c[n>>2]|0);break a;break}case 2:case 3:{SC(c[l>>2]|0,c[m>>2]|0,c[n>>2]|0);break a;break}default:{}}}while(0);if(!(c[k>>2]|0)){o=c[n>>2]|0;i=f;return o|0}LC(c[g>>2]|0,c[h>>2]|0,1)|0;o=c[n>>2]|0;i=f;return o|0}function NC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;k=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=c[f>>2];c[k>>2]=qC(c[h>>2]|0)|0;c[j>>2]=LC(c[h>>2]|0,c[g>>2]|0,0)|0;if(!(c[j>>2]|0)){c[e>>2]=-1;l=c[e>>2]|0;i=d;return l|0}TC(c[h>>2]|0,c[j>>2]|0);g=c[k>>2]|0;if((c[c[h>>2]>>2]&3)>>>0<1)UC(g,c[h>>2]|0,c[j>>2]|0);else{f=rC(g)|0;vE(f,c[h>>2]|0,57,c[j>>2]|0,0)|0}_C(c[k>>2]|0,c[c[j>>2]>>2]|0)|0;VB(c[k>>2]|0,c[j>>2]|0);c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}function OC(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=i;i=i+48|0;h=g+36|0;j=g+32|0;k=g+28|0;l=g+24|0;m=g+20|0;n=g+16|0;o=g+12|0;p=g+8|0;q=g+4|0;r=g;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;if((c[l>>2]|0)<0){c[r>>2]=1;c[q>>2]=0-(c[l>>2]|0)}else{c[r>>2]=0;c[q>>2]=c[l>>2]}switch(c[j>>2]|0){case 0:{MC(c[h>>2]|0,c[k>>2]|0,c[q>>2]|0,c[m>>2]|0)|0;if(!(c[r>>2]|0)){i=g;return}c[p>>2]=GD(c[h>>2]|0)|0;while(1){if(!(c[p>>2]|0))break;OC(c[p>>2]|0,c[j>>2]|0,c[k>>2]|0,c[l>>2]|0,c[m>>2]|0);c[p>>2]=HD(c[p>>2]|0)|0}i=g;return}case 3:case 2:case 1:{c[n>>2]=$B(c[h>>2]|0)|0;while(1){if(!(c[n>>2]|0))break;a:do if((c[j>>2]|0)==1)MC(c[n>>2]|0,c[k>>2]|0,c[q>>2]|0,c[m>>2]|0)|0;else{c[o>>2]=OA(c[h>>2]|0,c[n>>2]|0)|0;while(1){if(!(c[o>>2]|0))break a;MC(c[o>>2]|0,c[k>>2]|0,c[q>>2]|0,c[m>>2]|0)|0;c[o>>2]=QA(c[h>>2]|0,c[o>>2]|0)|0}}while(0);c[n>>2]=aC(c[h>>2]|0,c[n>>2]|0)|0}i=g;return}default:{i=g;return}}}function PC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;switch(c[g>>2]|0){case 0:{vE(c[f>>2]|0,c[f>>2]|0,58,c[h>>2]|0,1)|0;i=e;return}case 3:case 2:case 1:{c[j>>2]=$B(c[f>>2]|0)|0;while(1){if(!(c[j>>2]|0))break;a:do if((c[g>>2]|0)==1)NC(c[j>>2]|0,c[h>>2]|0)|0;else{c[k>>2]=OA(c[f>>2]|0,c[j>>2]|0)|0;while(1){if(!(c[k>>2]|0))break a;NC(c[k>>2]|0,c[h>>2]|0)|0;c[k>>2]=QA(c[f>>2]|0,c[k>>2]|0)|0}}while(0);c[j>>2]=aC(c[f>>2]|0,c[j>>2]|0)|0}i=e;return}default:{i=e;return}}}function QC(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[d>>2]=a;c[e>>2]=qC(c[d>>2]|0)|0;a=c[(c[d>>2]|0)+8>>2]|0;c[f>>2]=a;if(!a){h=c[d>>2]|0;j=h+8|0;c[j>>2]=0;i=b;return}do{c[g>>2]=c[(c[f>>2]|0)+4>>2];_C(c[e>>2]|0,c[c[f>>2]>>2]|0)|0;VB(c[e>>2]|0,c[f>>2]|0);c[f>>2]=c[g>>2]}while((c[f>>2]|0)!=(c[(c[d>>2]|0)+8>>2]|0));h=c[d>>2]|0;j=h+8|0;c[j>>2]=0;i=b;return}function RC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[(c[f>>2]|0)+8>>2]=c[g>>2];d=c[f>>2]|0;c[d>>2]=c[d>>2]&-5|(c[h>>2]&1)<<2;if((c[c[f>>2]>>2]&3|0)!=3?(c[c[f>>2]>>2]&3|0)!=2:0){i=e;return}d=c[f>>2]|0;c[j>>2]=(c[c[f>>2]>>2]&3|0)==3?d+-32|0:d+32|0;c[(c[j>>2]|0)+8>>2]=c[g>>2];g=c[j>>2]|0;c[g>>2]=c[g>>2]&-5|(c[h>>2]&1)<<2;i=e;return}function SC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+32|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[e+16>>2]=a;c[f>>2]=b;c[g>>2]=d;c[j>>2]=c[g>>2];c[h>>2]=c[(c[f>>2]|0)+8>>2];do if(c[h>>2]|0)if((c[(c[h>>2]|0)+4>>2]|0)==(c[h>>2]|0)){c[(c[h>>2]|0)+4>>2]=c[j>>2];c[(c[j>>2]|0)+4>>2]=c[h>>2];break}else{c[(c[j>>2]|0)+4>>2]=c[(c[h>>2]|0)+4>>2];c[(c[h>>2]|0)+4>>2]=c[j>>2];break}else c[(c[j>>2]|0)+4>>2]=c[j>>2];while(0);if((c[c[f>>2]>>2]|0)>>>2&1){i=e;return}RC(c[f>>2]|0,c[j>>2]|0,0);i=e;return}function TC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=c[(c[e>>2]|0)+8>>2];while(1){if((c[(c[g>>2]|0)+4>>2]|0)==(c[f>>2]|0))break;c[g>>2]=c[(c[g>>2]|0)+4>>2]}c[(c[g>>2]|0)+4>>2]=c[(c[f>>2]|0)+4>>2];i=d;return}function UC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+32|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[e+16>>2]=a;c[f>>2]=b;c[g>>2]=d;c[h>>2]=c[g>>2];if((c[(c[f>>2]|0)+8>>2]|0)!=(c[h>>2]|0)){i=e;return}if((c[(c[h>>2]|0)+4>>2]|0)==(c[h>>2]|0))c[j>>2]=0;else c[j>>2]=c[(c[h>>2]|0)+4>>2];RC(c[f>>2]|0,c[j>>2]|0,0);i=e;return}function VC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;c[e+8>>2]=a;c[f>>2]=b;c[g>>2]=d;NC(c[f>>2]|0,c[g>>2]|0)|0;i=e;return}function WC(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=c[d>>2]|0;e=QD(a,bD(c[d>>2]|0)|0)|0;i=b;return e|0}function XC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=bD(c[e>>2]|0)|0;e=cD(b,c[f>>2]|0)|0;i=d;return e|0}function YC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;k=d;c[f>>2]=a;c[g>>2]=b;if(!(c[g>>2]|0)){c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}c[j>>2]=bD(c[f>>2]|0)|0;c[h>>2]=dD(c[j>>2]|0,c[g>>2]|0)|0;if(c[h>>2]|0){b=(c[h>>2]|0)+8|0;c[b>>2]=(c[b>>2]|0)+1}else{c[k>>2]=20+(N3(c[g>>2]|0)|0);if(c[f>>2]|0)c[h>>2]=UB(c[f>>2]|0,c[k>>2]|0)|0;else c[h>>2]=N4(c[k>>2]|0)|0;c[(c[h>>2]|0)+8>>2]=1;K3((c[h>>2]|0)+16|0,c[g>>2]|0)|0;c[(c[h>>2]|0)+12>>2]=(c[h>>2]|0)+16;Hb[c[c[j>>2]>>2]&63](c[j>>2]|0,c[h>>2]|0,1)|0}c[e>>2]=c[(c[h>>2]|0)+12>>2];l=c[e>>2]|0;i=d;return l|0}function ZC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;h=d+8|0;j=d+4|0;k=d;c[f>>2]=a;c[g>>2]=b;if(!(c[g>>2]|0)){c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}c[j>>2]=bD(c[f>>2]|0)|0;c[h>>2]=dD(c[j>>2]|0,c[g>>2]|0)|0;if(c[h>>2]|0){b=(c[h>>2]|0)+8|0;c[b>>2]=(c[b>>2]|0)+1}else{c[k>>2]=20+(N3(c[g>>2]|0)|0);if(c[f>>2]|0)c[h>>2]=UB(c[f>>2]|0,c[k>>2]|0)|0;else c[h>>2]=N4(c[k>>2]|0)|0;c[(c[h>>2]|0)+8>>2]=1|c[13168];K3((c[h>>2]|0)+16|0,c[g>>2]|0)|0;c[(c[h>>2]|0)+12>>2]=(c[h>>2]|0)+16;Hb[c[c[j>>2]>>2]&63](c[j>>2]|0,c[h>>2]|0,1)|0}c[e>>2]=c[(c[h>>2]|0)+12>>2];l=c[e>>2]|0;i=d;return l|0}function _C(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[f>>2]=a;c[g>>2]=b;if(!(c[g>>2]|0)){c[e>>2]=-1;k=c[e>>2]|0;i=d;return k|0}c[j>>2]=bD(c[f>>2]|0)|0;c[h>>2]=dD(c[j>>2]|0,c[g>>2]|0)|0;if(((c[h>>2]|0)!=0?(c[(c[h>>2]|0)+12>>2]|0)==(c[g>>2]|0):0)?(g=(c[h>>2]|0)+8|0,c[g>>2]=(c[g>>2]|0)+-1,(((c[(c[h>>2]|0)+8>>2]|0)!=0?(c[13169]|0)!=0:0)&1|0)==0):0)PD(c[f>>2]|0,c[j>>2]|0,c[h>>2]|0)|0;if(!(c[h>>2]|0)){c[e>>2]=-1;k=c[e>>2]|0;i=d;return k|0}else{c[e>>2]=0;k=c[e>>2]|0;i=d;return k|0}return 0}function $C(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[e>>2]=a;if(!(c[e>>2]|0)){c[d>>2]=0;g=c[d>>2]|0;i=b;return g|0}else{c[f>>2]=(c[e>>2]|0)+(0-16);c[d>>2]=c[(c[f>>2]|0)+8>>2]&c[13168];g=c[d>>2]|0;i=b;return g|0}return 0}function aD(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;if(!(c[d>>2]|0)){i=b;return}c[e>>2]=(c[d>>2]|0)+(0-16);d=(c[e>>2]|0)+8|0;c[d>>2]=c[d>>2]|c[13168];i=b;return}function bD(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;if(c[d>>2]|0)c[e>>2]=(c[(c[d>>2]|0)+52>>2]|0)+20;else c[e>>2]=52680;if(c[c[e>>2]>>2]|0){f=c[e>>2]|0;g=c[f>>2]|0;i=b;return g|0}a=OD(c[d>>2]|0,52684,c[12993]|0)|0;c[c[e>>2]>>2]=a;c[13168]=-2147483648;c[13169]=~c[13168];f=c[e>>2]|0;g=c[f>>2]|0;i=b;return g|0}function cD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=dD(c[f>>2]|0,c[g>>2]|0)|0;if(c[h>>2]|0){c[e>>2]=c[(c[h>>2]|0)+12>>2];j=c[e>>2]|0;i=d;return j|0}else{c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}return 0}function dD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+32|0;e=d+28|0;f=d+24|0;g=d+4|0;h=d;c[e>>2]=a;c[f>>2]=b;c[g+12>>2]=c[f>>2];c[h>>2]=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,4)|0;i=d;return c[h>>2]|0}function eD(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;c[13184]=c[d>>2];i=b;return}function fD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;c[13186]=c[e>>2];c[13187]=c[f>>2];c[13188]=0;i=d;return}function gD(){var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;e=i;i=i+48|0;f=e+28|0;g=e+24|0;h=e+20|0;j=e+16|0;k=e+12|0;l=e+32|0;m=e+8|0;n=e+4|0;o=e;if(!(c[13189]|0)){c[13189]=1;if(!(c[13190]|0))c[13190]=1;if(!(c[13180]|0))c[13180]=c[24743];if(!(c[13181]|0))c[13181]=c[24744];if(!((c[13191]|0)!=0?(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)!=0:0)){qD();p=hD(c[13180]|0,16384)|0;c[(c[13191]|0)+(c[13192]<<2)>>2]=p}rD()}a:while(1){c[h>>2]=c[13193];a[c[h>>2]>>0]=a[134308]|0;c[j>>2]=c[h>>2];c[g>>2]=c[13190];c[g>>2]=(c[g>>2]|0)+(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]|0);b:while(1){a[l>>0]=c[52776+(d[c[h>>2]>>0]<<2)>>2];if(b[101984+(c[g>>2]<<1)>>1]|0){c[13450]=c[g>>2];c[13451]=c[h>>2]}while(1){q=c[g>>2]|0;if((b[102380+((b[102170+(c[g>>2]<<1)>>1]|0)+(d[l>>0]|0)<<1)>>1]|0)==(c[g>>2]|0))break;c[g>>2]=b[102938+(q<<1)>>1];if((c[g>>2]|0)<93)continue;a[l>>0]=c[53808+(d[l>>0]<<2)>>2]}c[g>>2]=b[103148+((b[102170+(q<<1)>>1]|0)+(d[l>>0]|0)<<1)>>1];c[h>>2]=(c[h>>2]|0)+1;if((b[102170+(c[g>>2]<<1)>>1]|0)!=230)continue;c:while(1){c[k>>2]=b[101984+(c[g>>2]<<1)>>1];if(!(c[k>>2]|0)){c[h>>2]=c[13451];c[g>>2]=c[13450];c[k>>2]=b[101984+(c[g>>2]<<1)>>1]}c[13182]=c[j>>2];c[13183]=(c[h>>2]|0)-(c[j>>2]|0);a[134308]=a[c[h>>2]>>0]|0;a[c[h>>2]>>0]=0;c[13193]=c[h>>2];d:while(1){switch(c[k>>2]|0){case 1:{r=24;break a;break}case 12:{r=51;break a;break}case 13:{r=54;break a;break}case 14:{r=57;break a;break}case 15:{r=62;break a;break}case 16:{r=67;break a;break}case 17:{r=70;break a;break}case 18:{r=73;break a;break}case 19:{r=78;break a;break}case 20:{r=83;break a;break}case 21:{r=86;break a;break}case 23:{r=94;break a;break}case 33:{r=126;break a;break}case 39:case 38:case 37:case 36:{r=132;break a;break}case 2:{r=27;break b;break}case 3:{r=30;break b;break}case 4:{r=33;break b;break}case 5:{r=35;break b;break}case 6:{r=37;break b;break}case 7:{r=40;break b;break}case 8:{r=42;break b;break}case 9:{r=45;break b;break}case 10:{r=47;break b;break}case 11:{r=49;break b;break}case 22:{r=91;break b;break}case 24:{r=97;break b;break}case 25:{r=100;break b;break}case 26:{r=103;break b;break}case 27:{r=106;break b;break}case 28:{r=109;break b;break}case 29:{r=112;break b;break}case 30:{r=117;break b;break}case 31:{r=120;break b;break}case 32:{r=123;break b;break}case 34:{r=129;break b;break}case 0:{r=23;break d;break}case 35:break;default:{r=146;break b}}c[n>>2]=(c[h>>2]|0)-(c[13182]|0)-1;a[c[h>>2]>>0]=a[134308]|0;if(!(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+44>>2]|0)){c[13502]=c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+16>>2];c[c[(c[13191]|0)+(c[13192]<<2)>>2]>>2]=c[13180];c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+44>>2]=1}if((c[13193]|0)>>>0<=((c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+(c[13502]|0)|0)>>>0){r=136;break}switch(AD()|0){case 0:{r=144;break c;break}case 2:{r=145;break d;break}case 1:break;default:continue a}c[13503]=0;if(!(iD()|0)){r=142;break b}c[13193]=c[13182];c[k>>2]=35+(((c[13190]|0)-1|0)/2|0)+1}if((r|0)==23){r=0;a[c[h>>2]>>0]=a[134308]|0;c[h>>2]=c[13451];c[g>>2]=c[13450];continue}else if((r|0)==136){r=0;c[13193]=(c[13182]|0)+(c[n>>2]|0);c[g>>2]=yD()|0;c[o>>2]=zD(c[g>>2]|0)|0;c[j>>2]=c[13182];s=c[13193]|0;if(c[o>>2]|0){r=137;break}c[h>>2]=s;continue}else if((r|0)==145){r=0;c[13193]=(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+(c[13502]|0);c[g>>2]=yD()|0;c[h>>2]=c[13193];c[j>>2]=c[13182];continue}}if((r|0)==137){r=0;p=s+1|0;c[13193]=p;c[h>>2]=p;c[g>>2]=c[o>>2];continue}else if((r|0)==144){r=0;c[13193]=(c[13182]|0)+(c[n>>2]|0);c[g>>2]=yD()|0;c[h>>2]=c[13193];c[j>>2]=c[13182];continue}}switch(r|0){case 27:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13184]=(c[13184]|0)+1;continue a;break}case 30:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13190]=3;continue a;break}case 33:{r=0;if((c[13183]|0)>>>0<=0)continue a;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;continue a;break}case 35:{r=0;if((c[13183]|0)>>>0<=0)continue a;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;continue a;break}case 37:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13190]=1;continue a;break}case 40:{r=0;if((c[13183]|0)>>>0<=0)continue a;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;continue a;break}case 42:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;sD();continue a;break}case 45:{r=0;if((c[13183]|0)>>>0<=0)continue a;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;continue a;break}case 47:{r=0;if((c[13183]|0)>>>0<=0)continue a;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;continue a;break}case 49:{r=0;if((c[13183]|0)>>>0<=0)continue a;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;continue a;break}case 91:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13190]=5;uD();continue a;break}case 97:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;wD(136329);continue a;break}case 100:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;wD(134309);continue a;break}case 103:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13184]=(c[13184]|0)+1;continue a;break}case 106:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;wD(c[13182]|0);continue a;break}case 109:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13190]=7;c[13501]=1;uD();continue a;break}case 112:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13501]=(c[13501]|0)+-1;if(!(c[13501]|0)){r=116;break a}wD(c[13182]|0);continue a;break}case 117:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13501]=(c[13501]|0)+1;wD(c[13182]|0);continue a;break}case 120:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;wD(c[13182]|0);c[13184]=(c[13184]|0)+1;continue a;break}case 123:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;wD(c[13182]|0);continue a;break}case 129:{r=0;if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;h3(c[13182]|0,c[13183]|0,1,c[13181]|0)|0;continue a;break}case 142:{r=0;if(c[13503]|0)continue a;jD(c[13180]|0);continue a;break}case 146:{r=0;BD(134312);continue a;break}}}switch(r|0){case 24:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[f>>2]=-1;t=c[f>>2]|0;i=e;return t|0}case 51:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[f>>2]=259;t=c[f>>2]|0;i=e;return t|0}case 54:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[f>>2]=260;t=c[f>>2]|0;i=e;return t|0}case 57:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;if(!(c[13188]|0))c[13188]=258;c[f>>2]=258;t=c[f>>2]|0;i=e;return t|0}case 62:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;if(!(c[13188]|0))c[13188]=261;c[f>>2]=261;t=c[f>>2]|0;i=e;return t|0}case 67:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[f>>2]=263;t=c[f>>2]|0;i=e;return t|0}case 70:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[f>>2]=262;t=c[f>>2]|0;i=e;return t|0}case 73:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;if((c[13188]|0)==261){c[f>>2]=264;t=c[f>>2]|0;i=e;return t|0}else{c[f>>2]=45;t=c[f>>2]|0;i=e;return t|0}break}case 78:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;if((c[13188]|0)==258){c[f>>2]=264;t=c[f>>2]|0;i=e;return t|0}else{c[f>>2]=45;t=c[f>>2]|0;i=e;return t|0}break}case 83:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13526]=YC(c[13072]|0,c[13182]|0)|0;c[f>>2]=267;t=c[f>>2]|0;i=e;return t|0}case 86:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;if(tD()|0){c[m>>2]=(c[13183]|0)-1;a[c[h>>2]>>0]=a[134308]|0;r=(c[j>>2]|0)+(c[m>>2]|0)|0;c[h>>2]=r;c[13193]=r;c[13182]=c[j>>2];c[13183]=(c[h>>2]|0)-(c[j>>2]|0);a[134308]=a[c[h>>2]>>0]|0;a[c[h>>2]>>0]=0;c[13193]=c[h>>2]}c[13526]=YC(c[13072]|0,c[13182]|0)|0;c[f>>2]=267;t=c[f>>2]|0;i=e;return t|0}case 94:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[13190]=1;vD();c[f>>2]=268;t=c[f>>2]|0;i=e;return t|0}case 116:{c[13190]=1;xD();c[f>>2]=268;t=c[f>>2]|0;i=e;return t|0}case 126:{if((c[13183]|0)>>>0>0)c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]=(a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0)==10&1;c[f>>2]=a[c[13182]>>0];t=c[f>>2]|0;i=e;return t|0}case 132:{c[f>>2]=0;t=c[f>>2]|0;i=e;return t|0}}return 0}function hD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=kD(48)|0;if(!(c[g>>2]|0))BD(134363);c[(c[g>>2]|0)+12>>2]=c[f>>2];f=kD((c[(c[g>>2]|0)+12>>2]|0)+2|0)|0;c[(c[g>>2]|0)+4>>2]=f;if(!(c[(c[g>>2]|0)+4>>2]|0))BD(134363);c[(c[g>>2]|0)+20>>2]=1;CD(c[g>>2]|0,c[e>>2]|0);i=d;return c[g>>2]|0}function iD(){return 1}function jD(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if(!((c[13191]|0)!=0?(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)!=0:0)){qD();a=hD(c[13180]|0,16384)|0;c[(c[13191]|0)+(c[13192]<<2)>>2]=a}if(!(c[13191]|0)){e=0;f=c[d>>2]|0;CD(e,f);rD();i=b;return}e=c[(c[13191]|0)+(c[13192]<<2)>>2]|0;f=c[d>>2]|0;CD(e,f);rD();i=b;return}function kD(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=N4(c[d>>2]|0)|0;i=b;return a|0}function lD(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d;c[e>>2]=b;if(!(c[e>>2]|0)){i=d;return}c[(c[e>>2]|0)+16>>2]=0;a[c[(c[e>>2]|0)+4>>2]>>0]=0;a[(c[(c[e>>2]|0)+4>>2]|0)+1>>0]=0;c[(c[e>>2]|0)+8>>2]=c[(c[e>>2]|0)+4>>2];c[(c[e>>2]|0)+28>>2]=1;c[(c[e>>2]|0)+44>>2]=0;if(c[13191]|0)f=c[(c[13191]|0)+(c[13192]<<2)>>2]|0;else f=0;if((c[e>>2]|0)!=(f|0)){i=d;return}rD();i=d;return}function mD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=Q4(c[e>>2]|0,c[f>>2]|0)|0;i=d;return b|0}function nD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+2096|0;e=d;f=d+32|0;g=d+40|0;h=d+16|0;c[f>>2]=b;dA(h,1024,d+1064|0);if(c[13185]|0){gA(h,c[13185]|0)|0;gA(h,134408)|0}gA(h,c[f>>2]|0)|0;c[e>>2]=c[13184];k3(g,134411,e)|0;gA(h,g)|0;gA(h,c[13182]|0)|0;gA(h,134430)|0;if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;g=h+4|0;e=c[g>>2]|0;c[g>>2]=e+1;a[e>>0]=0;e=c[h>>2]|0;c[h+4>>2]=e;$z(1,e,d+8|0)|0;hA(h);i=d;return}function oD(){DD(64,c[13182]|0);return}function pD(){var a=0;if(!(c[13191]|0)){a=0;lD(a);return}a=c[(c[13191]|0)+(c[13192]<<2)>>2]|0;lD(a);return}function qD(){var a=0,b=0,d=0;a=i;i=i+16|0;b=a+4|0;d=a;if(!(c[13191]|0)){c[b>>2]=1;c[13191]=kD(c[b>>2]<<2)|0;if(!(c[13191]|0))BD(134753);$4(c[13191]|0,0,c[b>>2]<<2|0)|0;c[13504]=c[b>>2];c[13192]=0;i=a;return}if((c[13192]|0)>>>0<((c[13504]|0)-1|0)>>>0){i=a;return}c[d>>2]=8;c[b>>2]=(c[13504]|0)+(c[d>>2]|0);c[13191]=mD(c[13191]|0,c[b>>2]<<2)|0;if(!(c[13191]|0))BD(134753);$4((c[13191]|0)+(c[13504]<<2)|0,0,c[d>>2]<<2|0)|0;c[13504]=c[b>>2];i=a;return}function rD(){var b=0;c[13502]=c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+16>>2];b=c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+8>>2]|0;c[13193]=b;c[13182]=b;c[13180]=c[c[(c[13191]|0)+(c[13192]<<2)>>2]>>2];a[134308]=a[c[13193]>>0]|0;return}function sD(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+48|0;d=b;e=b+32|0;f=b+28|0;g=b+24|0;h=b+20|0;j=b+16|0;k=b+12|0;c[h>>2]=(c[13182]|0)+1;if(!(P3(c[h>>2]|0,134737,4)|0))c[h>>2]=(c[h>>2]|0)+4;l=c[h>>2]|0;c[d>>2]=g;c[d+4>>2]=b+36;c[d+8>>2]=f;c[e>>2]=l3(l,134742,d)|0;if((c[e>>2]|0)<=0){i=b;return}c[13184]=(c[g>>2]|0)-1;if((c[e>>2]|0)<=1){i=b;return}c[j>>2]=(c[h>>2]|0)+(c[f>>2]|0);c[k>>2]=c[j>>2];while(1){if(a[c[k>>2]>>0]|0)m=(a[c[k>>2]>>0]|0)!=34;else m=0;n=c[k>>2]|0;if(!m)break;c[k>>2]=n+1}if((n|0)==(c[j>>2]|0)){i=b;return}a[c[k>>2]>>0]=0;ED(c[j>>2]|0,(c[k>>2]|0)-(c[j>>2]|0)|0);i=b;return}function tD(){var b=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+2096|0;e=b+8|0;f=b;g=b+32|0;h=b+2088|0;j=b+1064|0;k=b+40|0;l=b+16|0;m=b+12|0;a[h>>0]=a[(c[13182]|0)+((c[13183]|0)-1)>>0]|0;if((p1(d[h>>0]|0)|0)==0?(d[h>>0]|0|0)!=46:0){if(c[13185]|0)c[m>>2]=c[13185];else c[m>>2]=134645;dA(l,1024,j);gA(l,134651)|0;gA(l,c[13182]|0)|0;c[f>>2]=c[13184];k3(k,134695,f)|0;gA(l,k)|0;gA(l,c[m>>2]|0)|0;gA(l,134712)|0;if((c[l+4>>2]|0)>>>0>=(c[l+8>>2]|0)>>>0)eA(l,1)|0;m=l+4|0;k=c[m>>2]|0;c[m>>2]=k+1;a[k>>0]=0;k=c[l>>2]|0;c[l+4>>2]=k;$z(0,k,e)|0;hA(l);c[g>>2]=1;n=c[g>>2]|0;i=b;return n|0}c[g>>2]=0;n=c[g>>2]|0;i=b;return n|0}function uD(){if(!(c[13505]|0)){c[13505]=N4(1024)|0;c[13507]=(c[13505]|0)+1024}c[13506]=c[13505];a[c[13506]>>0]=0;return}function vD(){c[13526]=YC(c[13072]|0,c[13505]|0)|0;return}function wD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+8|0;f=d+12|0;g=d+4|0;h=d;c[e>>2]=b;if((c[13506]|0)>>>0>(c[13505]|0)>>>0)c[13506]=(c[13506]|0)+-1;while(1){b=c[e>>2]|0;c[e>>2]=b+1;j=a[b>>0]|0;b=c[13506]|0;c[13506]=b+1;a[b>>0]=j;a[f>>0]=j;if((a[f>>0]|0)!=0?(c[13506]|0)>>>0<(c[13507]|0)>>>0:0)continue;if(a[f>>0]|0){c[g>>2]=(c[13507]|0)-(c[13505]|0);c[h>>2]=(c[13506]|0)-(c[13505]|0);c[g>>2]=c[g>>2]<<1;c[13505]=Q4(c[13505]|0,c[g>>2]|0)|0;c[13507]=(c[13505]|0)+(c[g>>2]|0);c[13506]=(c[13505]|0)+(c[h>>2]|0)}if(!(a[f>>0]|0))break}i=d;return}function xD(){c[13526]=ZC(c[13072]|0,c[13505]|0)|0;return}function yD(){var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+4|0;g=e;h=e+8|0;c[f>>2]=c[13190];c[f>>2]=(c[f>>2]|0)+(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+28>>2]|0);c[g>>2]=c[13182];while(1){if((c[g>>2]|0)>>>0>=(c[13193]|0)>>>0)break;if(a[c[g>>2]>>0]|0)j=c[52776+(d[c[g>>2]>>0]<<2)>>2]|0;else j=1;a[h>>0]=j;if(b[101984+(c[f>>2]<<1)>>1]|0){c[13450]=c[f>>2];c[13451]=c[g>>2]}while(1){k=c[f>>2]|0;if((b[102380+((b[102170+(c[f>>2]<<1)>>1]|0)+(d[h>>0]|0)<<1)>>1]|0)==(c[f>>2]|0))break;c[f>>2]=b[102938+(k<<1)>>1];if((c[f>>2]|0)<93)continue;a[h>>0]=c[53808+(d[h>>0]<<2)>>2]}c[f>>2]=b[103148+((b[102170+(k<<1)>>1]|0)+(d[h>>0]|0)<<1)>>1];c[g>>2]=(c[g>>2]|0)+1}i=e;return c[f>>2]|0}function zD(e){e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;g=f+8|0;h=f+4|0;j=f;k=f+12|0;c[g>>2]=e;c[j>>2]=c[13193];a[k>>0]=1;if(b[101984+(c[g>>2]<<1)>>1]|0){c[13450]=c[g>>2];c[13451]=c[j>>2]}while(1){l=c[g>>2]|0;if((b[102380+((b[102170+(c[g>>2]<<1)>>1]|0)+(d[k>>0]|0)<<1)>>1]|0)==(c[g>>2]|0))break;c[g>>2]=b[102938+(l<<1)>>1];if((c[g>>2]|0)<93)continue;a[k>>0]=c[53808+(d[k>>0]<<2)>>2]}c[g>>2]=b[103148+((b[102170+(l<<1)>>1]|0)+(d[k>>0]|0)<<1)>>1];c[h>>2]=(c[g>>2]|0)==92&1;i=f;return ((c[h>>2]|0)!=0?0:c[g>>2]|0)|0}function AD(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;b=i;i=i+48|0;d=b+40|0;e=b+36|0;f=b+32|0;g=b+28|0;h=b+24|0;j=b+20|0;k=b+16|0;l=b+12|0;m=b+8|0;n=b+4|0;o=b;c[e>>2]=c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2];c[f>>2]=c[13182];if((c[13193]|0)>>>0>((c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+((c[13502]|0)+1)|0)>>>0)BD(134469);p=(c[13193]|0)-(c[13182]|0)|0;if(!(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+40>>2]|0))if((p-0|0)==1){c[d>>2]=1;q=c[d>>2]|0;i=b;return q|0}else{c[d>>2]=2;q=c[d>>2]|0;i=b;return q|0}c[g>>2]=p-1;c[h>>2]=0;while(1){if((c[h>>2]|0)>=(c[g>>2]|0))break;p=c[f>>2]|0;c[f>>2]=p+1;r=a[p>>0]|0;p=c[e>>2]|0;c[e>>2]=p+1;a[p>>0]=r;c[h>>2]=(c[h>>2]|0)+1}if((c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+44>>2]|0)==2){c[13502]=0;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+16>>2]=0}else{c[k>>2]=(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+12>>2]|0)-(c[g>>2]|0)-1;while(1){if((c[k>>2]|0)>>>0>0)break;c[l>>2]=c[(c[13191]|0)+(c[13192]<<2)>>2];c[m>>2]=(c[13193]|0)-(c[(c[l>>2]|0)+4>>2]|0);h=c[l>>2]|0;if(c[(c[l>>2]|0)+20>>2]|0){c[n>>2]=c[h+12>>2]<<1;e=(c[l>>2]|0)+12|0;f=c[e>>2]|0;if((c[n>>2]|0)>>>0<=0){r=(c[l>>2]|0)+12|0;c[r>>2]=(c[r>>2]|0)+((f>>>0)/8|0)}else c[e>>2]=f<<1;f=mD(c[(c[l>>2]|0)+4>>2]|0,(c[(c[l>>2]|0)+12>>2]|0)+2|0)|0;c[(c[l>>2]|0)+4>>2]=f}else c[h+4>>2]=0;if(!(c[(c[l>>2]|0)+4>>2]|0))BD(134525);c[13193]=(c[(c[l>>2]|0)+4>>2]|0)+(c[m>>2]|0);c[k>>2]=(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+12>>2]|0)-(c[g>>2]|0)-1}if((c[k>>2]|0)>>>0>8192)c[k>>2]=8192;m=Hb[c[c[(c[13186]|0)+8>>2]>>2]&63](c[13187]|0,(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+(c[g>>2]|0)|0,c[k>>2]|0)|0;c[13502]=m;if(m>>>0<0)BD(134569);c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+16>>2]=c[13502]}do if(!(c[13502]|0))if(!(c[g>>2]|0)){c[j>>2]=1;jD(c[13180]|0);break}else{c[j>>2]=2;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+44>>2]=2;break}else c[j>>2]=0;while(0);if(((c[13502]|0)+(c[g>>2]|0)|0)>>>0>(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+12>>2]|0)>>>0?(c[o>>2]=(c[13502]|0)+(c[g>>2]|0)+((c[13502]|0)>>>1),m=mD(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0,c[o>>2]|0)|0,c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]=m,(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)==0):0)BD(134598);c[13502]=(c[13502]|0)+(c[g>>2]|0);a[(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+(c[13502]|0)>>0]=0;a[(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+((c[13502]|0)+1)>>0]=0;c[13182]=c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2];c[d>>2]=c[j>>2];q=c[d>>2]|0;i=b;return q|0}function BD(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;e=b+4|0;c[e>>2]=a;a=c[24742]|0;c[d>>2]=c[e>>2];Y2(a,134465,d)|0;wb(2)}function CD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=c[(L1()|0)>>2];lD(c[e>>2]|0);c[c[e>>2]>>2]=c[f>>2];c[(c[e>>2]|0)+40>>2]=1;if(c[13191]|0)h=c[(c[13191]|0)+(c[13192]<<2)>>2]|0;else h=0;if((c[e>>2]|0)!=(h|0)){c[(c[e>>2]|0)+32>>2]=1;c[(c[e>>2]|0)+36>>2]=0}c[(c[e>>2]|0)+24>>2]=(c[f>>2]|0)!=0?0:0;f=c[g>>2]|0;c[(L1()|0)>>2]=f;i=d;return}function DD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[f>>2]=b;c[g>>2]=d;c[h>>2]=c[13193];a[c[h>>2]>>0]=a[134308]|0;if((c[h>>2]|0)>>>0<((c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+2|0)>>>0){c[j>>2]=(c[13502]|0)+2;c[k>>2]=(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+((c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+12>>2]|0)+2);c[l>>2]=(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+(c[j>>2]|0);while(1){if((c[l>>2]|0)>>>0<=(c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)>>>0)break;j=(c[l>>2]|0)+-1|0;c[l>>2]=j;d=a[j>>0]|0;j=(c[k>>2]|0)+-1|0;c[k>>2]=j;a[j>>0]=d}c[h>>2]=(c[h>>2]|0)+((c[k>>2]|0)-(c[l>>2]|0));c[g>>2]=(c[g>>2]|0)+((c[k>>2]|0)-(c[l>>2]|0));l=c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+12>>2]|0;c[13502]=l;c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+16>>2]=l;if((c[h>>2]|0)>>>0<((c[(c[(c[13191]|0)+(c[13192]<<2)>>2]|0)+4>>2]|0)+2|0)>>>0)BD(134433)}l=c[f>>2]&255;f=(c[h>>2]|0)+-1|0;c[h>>2]=f;a[f>>0]=l;c[13182]=c[g>>2];a[134308]=a[c[h>>2]>>0]|0;c[13193]=c[h>>2];i=e;return}function ED(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;if((c[f>>2]|0)>(c[13508]|0)){if(c[13508]|0)c[13509]=Q4(c[13509]|0,(c[f>>2]|0)+1|0)|0;else c[13509]=N4((c[f>>2]|0)+1|0)|0;c[13508]=c[f>>2]}K3(c[13509]|0,c[e>>2]|0)|0;c[13185]=c[13509];i=d;return}function FD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if(((c[h>>2]|0)!=0?(tB(c[g>>2]|0,0,c[h>>2]|0,k,0)|0)!=0:0)?(d=KD(c[g>>2]|0,c[k>>2]|0)|0,c[l>>2]=d,(d|0)!=0):0){c[f>>2]=c[l>>2];m=c[f>>2]|0;i=e;return m|0}if((c[j>>2]|0)!=0?(tB(c[g>>2]|0,0,c[h>>2]|0,k,1)|0)!=0:0){c[l>>2]=LD(c[g>>2]|0,c[k>>2]|0)|0;xB(c[g>>2]|0,0,c[l>>2]|0);c[f>>2]=c[l>>2];m=c[f>>2]|0;i=e;return m|0}c[f>>2]=0;m=c[f>>2]|0;i=e;return m|0}function GD(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=Hb[c[c[(c[d>>2]|0)+40>>2]>>2]&63](c[(c[d>>2]|0)+40>>2]|0,0,128)|0;i=b;return a|0}function HD(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=ID(c[d>>2]|0)|0;if(!(c[e>>2]|0)){f=0;i=b;return f|0}f=Hb[c[c[(c[e>>2]|0)+40>>2]>>2]&63](c[(c[e>>2]|0)+40>>2]|0,c[d>>2]|0,8)|0;i=b;return f|0}function ID(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;i=b;return c[(c[d>>2]|0)+44>>2]|0}function JD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=Hb[c[c[(c[e>>2]|0)+40>>2]>>2]&63](c[(c[e>>2]|0)+40>>2]|0,c[f>>2]|0,2)|0;i=d;return b|0}function KD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+64|0;e=d+60|0;f=d+56|0;g=d;c[e>>2]=a;c[f>>2]=b;RD(c[e>>2]|0,c[(c[e>>2]|0)+40>>2]|0,52224);c[g+4>>2]=c[f>>2];f=Hb[c[c[(c[e>>2]|0)+40>>2]>>2]&63](c[(c[e>>2]|0)+40>>2]|0,g,4)|0;i=d;return f|0}function LD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=b;c[h>>2]=d;c[j>>2]=KD(c[g>>2]|0,c[h>>2]|0)|0;if(c[j>>2]|0){c[f>>2]=c[j>>2];k=c[f>>2]|0;i=e;return k|0}else{c[j>>2]=UB(c[g>>2]|0,56)|0;c[(c[j>>2]|0)+52>>2]=c[(c[g>>2]|0)+52>>2];c[(c[j>>2]|0)+12>>2]=c[(c[g>>2]|0)+12>>2];d=(c[j>>2]|0)+12|0;a[d>>0]=a[d>>0]&-9;c[(c[j>>2]|0)+44>>2]=c[g>>2];c[(c[j>>2]|0)+48>>2]=c[(c[g>>2]|0)+48>>2];c[(c[j>>2]|0)+4>>2]=c[h>>2];c[f>>2]=hB(c[j>>2]|0)|0;k=c[f>>2]|0;i=e;return k|0}return 0}function MD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+32|0;g=f+20|0;h=f+12|0;j=f+8|0;k=f;c[f+16>>2]=a;c[h>>2]=b;c[j>>2]=d;c[f+4>>2]=e;c[k>>2]=c[13510];e=(c[h>>2]|0)!=0;do if(c[k>>2]|0){d=c[k>>2]|0;if(e){VB(d,c[h>>2]|0);break}c[g>>2]=UB(d,c[j>>2]|0)|0;l=c[g>>2]|0;i=f;return l|0}else{if(e){O4(c[h>>2]|0);break}c[g>>2]=N4(c[j>>2]|0)|0;l=c[g>>2]|0;i=f;return l|0}while(0);c[g>>2]=0;l=c[g>>2]|0;i=f;return l|0}function ND(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=c[13510];if(c[g>>2]|0){VB(c[g>>2]|0,c[f>>2]|0);i=e;return}else{O4(c[f>>2]|0);i=e;return}}function OD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=c[(c[g>>2]|0)+28>>2];c[(c[g>>2]|0)+28>>2]=7;c[13510]=c[f>>2];c[k>>2]=Nz(c[g>>2]|0,c[h>>2]|0)|0;c[(c[g>>2]|0)+28>>2]=c[j>>2];c[13510]=0;i=e;return c[k>>2]|0}function PD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[13510]=c[f>>2];f=Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,c[h>>2]|0,2)|0;i=e;return f|0}function QD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[f>>2]=a;c[g>>2]=b;c[j>>2]=Vz(c[g>>2]|0,0,0)|0;c[h>>2]=c[(c[j>>2]|0)+28>>2];c[(c[j>>2]|0)+28>>2]=7;c[13510]=c[f>>2];if(Jz(c[g>>2]|0)|0){c[e>>2]=1;k=c[e>>2]|0;i=d;return k|0}else{c[(c[j>>2]|0)+28>>2]=c[h>>2];c[13510]=0;c[e>>2]=0;k=c[e>>2]|0;i=d;return k|0}return 0}function RD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+4|0;g=e;c[e+8>>2]=a;c[f>>2]=b;c[g>>2]=d;if(!(c[g>>2]|0)){i=e;return}d=Vz(c[f>>2]|0,0,0)|0;if((d|0)==(c[g>>2]|0)){i=e;return}Vz(c[f>>2]|0,c[g>>2]|0,0)|0;i=e;return}function SD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[f>>2]=a;c[g>>2]=b;b=($C(c[f>>2]|0)|0)!=0;a=c[f>>2]|0;f=c[g>>2]|0;if(b){c[e>>2]=WD(a,f)|0;h=c[e>>2]|0;i=d;return h|0}else{c[e>>2]=XD(a,f)|0;h=c[e>>2]|0;i=d;return h|0}return 0}function TD(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=c[d>>2]|0;e=SD(a,YD(c[d>>2]|0)|0)|0;i=b;return e|0}function UD(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=GD(c[f>>2]|0)|0;while(1){if(!(c[h>>2]|0)){j=7;break}if((ZD(c[h>>2]|0)|0)==0?(eC(c[h>>2]|0,c[g>>2]|0,0)|0)!=0:0){j=5;break}c[h>>2]=HD(c[h>>2]|0)|0}if((j|0)==5){c[e>>2]=1;k=c[e>>2]|0;i=d;return k|0}else if((j|0)==7){c[e>>2]=0;k=c[e>>2]|0;i=d;return k|0}return 0}function VD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=b;c[h>>2]=d;c[13511]=0;d=yA(c[g>>2]|0,134803)|0;c[j>>2]=d;if(((d|0)!=0?(p1(a[c[j>>2]>>0]|0)|0)!=0:0)?(c[k>>2]=z3(c[j>>2]|0,0,10)|0,(c[k>>2]|0)==0|(c[k>>2]|0)>=60):0)c[13512]=c[k>>2];_D(c[g>>2]|0,1,0);if(($D(c[g>>2]|0,c[h>>2]|0,1)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}if((aE(c[g>>2]|0,c[h>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}if((bE(c[g>>2]|0,c[h>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}else{c[13512]=128;c[f>>2]=Fb[c[(c[(c[(c[g>>2]|0)+52>>2]|0)+8>>2]|0)+8>>2]&63](c[h>>2]|0)|0;l=c[f>>2]|0;i=e;return l|0}return 0}function WD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=b;c[g>>2]=d;c[h>>2]=c[f>>2];c[j>>2]=c[g>>2];f=c[j>>2]|0;c[j>>2]=f+1;a[f>>0]=60;while(1){if(!(a[c[h>>2]>>0]|0))break;f=c[h>>2]|0;c[h>>2]=f+1;d=a[f>>0]|0;f=c[j>>2]|0;c[j>>2]=f+1;a[f>>0]=d}h=c[j>>2]|0;c[j>>2]=h+1;a[h>>0]=62;a[c[j>>2]>>0]=0;i=e;return c[g>>2]|0}function XD(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;f=i;i=i+48|0;g=f+40|0;h=f+36|0;j=f+32|0;k=f+28|0;l=f+24|0;m=f+44|0;n=f+20|0;o=f+16|0;p=f+12|0;q=f+8|0;r=f+4|0;s=f;c[h>>2]=b;c[j>>2]=e;c[n>>2]=0;c[o>>2]=0;c[p>>2]=0;c[r>>2]=0;if((c[h>>2]|0)!=0?(a[c[h>>2]>>0]|0)!=0:0){c[k>>2]=c[h>>2];c[l>>2]=c[j>>2];e=c[l>>2]|0;c[l>>2]=e+1;a[e>>0]=34;e=c[k>>2]|0;c[k>>2]=e+1;a[m>>0]=a[e>>0]|0;if((p1(d[m>>0]|0)|0)==0?(d[m>>0]|0)!=46:0)t=(d[m>>0]|0)==45;else t=1;c[q>>2]=t&1;a:while(1){if(!(a[m>>0]|0))break;do if((d[m>>0]|0)!=34){t=d[m>>0]|0;if(!(c[q>>2]|0)){if(l1(t)|0)break;if((d[m>>0]|0)==95)break;if(!(n1(d[m>>0]|0)|0))break;c[p>>2]=1;break}if((t|0)==45){if(!(c[n>>2]|0))break;c[q>>2]=0;c[p>>2]=1;break}if((d[m>>0]|0)==46){t=c[o>>2]|0;c[o>>2]=t+1;if(!t)break;c[q>>2]=0;c[p>>2]=1;break}else{if(p1(d[m>>0]|0)|0)break;c[q>>2]=0;c[p>>2]=1;break}}else{t=c[l>>2]|0;c[l>>2]=t+1;a[t>>0]=92;c[p>>2]=1}while(0);t=a[m>>0]|0;e=c[l>>2]|0;c[l>>2]=e+1;a[e>>0]=t;t=c[k>>2]|0;c[k>>2]=t+1;a[m>>0]=a[t>>0]|0;c[n>>2]=(c[n>>2]|0)+1;if(!(c[13512]|0))continue;do if((((((d[m>>0]|0)!=0&(c[r>>2]|0)!=0?(l1(a[(c[l>>2]|0)+-1>>0]|0)|0)==0:0)?(a[(c[l>>2]|0)+-1>>0]|0)!=46:0)?(a[(c[l>>2]|0)+-1>>0]|0)!=45:0)?(n1(a[(c[l>>2]|0)+-1>>0]|0)|0)!=0:0)?(a[(c[l>>2]|0)+-1>>0]|0)!=92:0){if((((l1(d[m>>0]|0)|0)==0?(d[m>>0]|0)!=46:0)?(d[m>>0]|0)!=45:0)?(n1(d[m>>0]|0)|0)!=0:0)break;t=c[l>>2]|0;c[l>>2]=t+1;a[t>>0]=92;t=c[l>>2]|0;c[l>>2]=t+1;a[t>>0]=10;c[p>>2]=1;c[r>>2]=0;c[n>>2]=0;continue a}while(0);if(!(d[m>>0]|0))continue;if((c[n>>2]|0)<(c[13512]|0))continue;b:do if(((((l1(a[(c[l>>2]|0)+-1>>0]|0)|0)==0?(a[(c[l>>2]|0)+-1>>0]|0)!=46:0)?(a[(c[l>>2]|0)+-1>>0]|0)!=45:0)?(n1(a[(c[l>>2]|0)+-1>>0]|0)|0)!=0:0)?(a[(c[l>>2]|0)+-1>>0]|0)!=92:0){do if((l1(d[m>>0]|0)|0)==0?(d[m>>0]|0)!=46:0){if((d[m>>0]|0)==45)break;if(n1(d[m>>0]|0)|0)break b}while(0);t=c[l>>2]|0;c[l>>2]=t+1;a[t>>0]=92;t=c[l>>2]|0;c[l>>2]=t+1;a[t>>0]=10;c[p>>2]=1;c[n>>2]=0;continue a}while(0);c[r>>2]=1}r=c[l>>2]|0;c[l>>2]=r+1;a[r>>0]=34;a[c[l>>2]>>0]=0;do if(!(c[p>>2]|0)){if((c[n>>2]|0)==1){if((a[c[h>>2]>>0]|0)==46)break;if((a[c[h>>2]>>0]|0)==45)break}c[s>>2]=54068;while(1){if(!(c[c[s>>2]>>2]|0)){u=59;break}if(!(F3(c[c[s>>2]>>2]|0,c[h>>2]|0)|0)){u=57;break}c[s>>2]=(c[s>>2]|0)+4}if((u|0)==57){c[g>>2]=c[j>>2];v=c[g>>2]|0;i=f;return v|0}else if((u|0)==59){c[g>>2]=c[h>>2];v=c[g>>2]|0;i=f;return v|0}}while(0);c[g>>2]=c[j>>2];v=c[g>>2]|0;i=f;return v|0}c[g>>2]=134866;v=c[g>>2]|0;i=f;return v|0}function YD(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;if((((N3(c[d>>2]|0)|0)<<1)+2|0)>>>0>1024)f=((N3(c[d>>2]|0)|0)<<1)+2|0;else f=1024;c[e>>2]=f;if((c[e>>2]|0)<=(c[13515]|0)){g=c[13516]|0;i=b;return g|0}if(c[13516]|0)c[13516]=Q4(c[13516]|0,c[e>>2]|0)|0;else c[13516]=N4(c[e>>2]|0)|0;c[13515]=c[e>>2];g=c[13516]|0;i=b;return g|0}function ZD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;i=i+48|0;e=d+32|0;f=d+28|0;g=d+24|0;h=d+20|0;j=d+16|0;k=d+12|0;l=d+8|0;m=d+4|0;n=d;c[f>>2]=b;c[n>>2]=wB(c[f>>2]|0)|0;if((c[n>>2]|0)!=0?(a[c[n>>2]>>0]|0)!=37:0){c[e>>2]=0;o=c[e>>2]|0;i=d;return o|0}n=pA(c[f>>2]|0)|0;c[j>>2]=n;a:do if((n|0)!=0?(b=pA(ID(c[f>>2]|0)|0)|0,c[k>>2]=b,(b|0)!=0):0){c[l>>2]=pA(rC(c[f>>2]|0)|0)|0;c[h>>2]=Pz(c[(c[l>>2]|0)+8>>2]|0)|0;c[g>>2]=0;while(1){if((c[g>>2]|0)>=(c[h>>2]|0))break a;if(((c[(c[(c[j>>2]|0)+12>>2]|0)+(c[g>>2]<<2)>>2]|0)!=0?(c[(c[(c[k>>2]|0)+12>>2]|0)+(c[g>>2]<<2)>>2]|0)!=0:0)?(J3(c[(c[(c[j>>2]|0)+12>>2]|0)+(c[g>>2]<<2)>>2]|0,c[(c[(c[k>>2]|0)+12>>2]|0)+(c[g>>2]<<2)>>2]|0)|0)!=0:0)break;c[g>>2]=(c[g>>2]|0)+1}c[e>>2]=0;o=c[e>>2]|0;i=d;return o|0}while(0);c[m>>2]=jA(c[f>>2]|0,0)|0;if(!(c[m>>2]|0)){c[e>>2]=1;o=c[e>>2]|0;i=d;return o|0}if((Pz(c[(c[m>>2]|0)+8>>2]|0)|0)<=0?(Pz(c[(c[m>>2]|0)+8+4>>2]|0)|0)<=0:0){c[e>>2]=1;o=c[e>>2]|0;i=d;return o|0}c[e>>2]=0;o=c[e>>2]|0;i=d;return o|0}function _D(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=c[f>>2]|0;c[d>>2]=c[d>>2]&-9|(c[h>>2]&1)<<3;c[j>>2]=GD(c[f>>2]|0)|0;while(1){if(!(c[j>>2]|0))break;_D(c[j>>2]|0,0,c[h>>2]|0);c[j>>2]=HD(c[j>>2]|0)|0}if(!(c[g>>2]|0)){i=e;return}c[k>>2]=$B(c[f>>2]|0)|0;while(1){if(!(c[k>>2]|0))break;g=c[k>>2]|0;c[g>>2]=c[g>>2]&-9|(c[h>>2]&1)<<3;c[l>>2]=OA(c[f>>2]|0,c[k>>2]|0)|0;while(1){if(!(c[l>>2]|0))break;g=c[l>>2]|0;c[g>>2]=c[g>>2]&-9|(c[h>>2]&1)<<3;c[l>>2]=QA(c[f>>2]|0,c[l>>2]|0)|0}c[k>>2]=aC(c[f>>2]|0,c[k>>2]|0)|0}i=e;return}function $D(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+48|0;g=f+32|0;h=f+28|0;j=f+24|0;k=f+20|0;l=f+16|0;m=f+12|0;n=f+8|0;o=f+4|0;p=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[p>>2]=0;a[134847]=(c[c[h>>2]>>2]|0)>>>3&1;c[o>>2]=178518;if((c[k>>2]|0)==0?(ID(c[h>>2]|0)|0)!=0:0)c[n>>2]=147211;else{c[p>>2]=1;if(a[(c[h>>2]|0)+12>>0]&1)c[n>>2]=134848;else c[n>>2]=178518;if(pB(c[h>>2]|0)|0)c[o>>2]=134851;c[13513]=qA(c[h>>2]|0,2,149070,0)|0;c[13514]=qA(c[h>>2]|0,2,149061,0)|0}c[l>>2]=wB(c[h>>2]|0)|0;c[m>>2]=140232;if(!((c[l>>2]|0)!=0?(a[c[l>>2]>>0]|0)!=37:0)){c[l>>2]=178518;c[m>>2]=178518}if((cE(c[h>>2]|0,c[j>>2]|0)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}if((dE(c[h>>2]|0,c[j>>2]|0,c[o>>2]|0)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}if((c[p>>2]|0)!=0?1:(a[c[l>>2]>>0]|0)!=0){if((dE(c[h>>2]|0,c[j>>2]|0,c[n>>2]|0)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}if((dE(c[h>>2]|0,c[j>>2]|0,140225)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}}if((a[c[l>>2]>>0]|0)!=0?(oE(c[h>>2]|0,c[j>>2]|0,c[l>>2]|0)|0)==-1:0){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}if((dE(c[h>>2]|0,c[j>>2]|0,c[m>>2]|0)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}if((dE(c[h>>2]|0,c[j>>2]|0,134859)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}c[13511]=(c[13511]|0)+1;if((tE(c[h>>2]|0,c[j>>2]|0,c[k>>2]|0)|0)==-1){c[g>>2]=-1;q=c[g>>2]|0;i=f;return q|0}else{k=c[h>>2]|0;c[k>>2]=c[k>>2]&-9|8;c[g>>2]=0;q=c[g>>2]|0;i=f;return q|0}return 0}function aE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=i;i=i+32|0;e=d+24|0;f=d+20|0;g=d+16|0;h=d+12|0;j=d+8|0;k=d+4|0;l=d;c[f>>2]=a;c[g>>2]=b;if((eE(c[f>>2]|0,c[g>>2]|0)|0)==-1){c[e>>2]=-1;m=c[e>>2]|0;i=d;return m|0}c[l>>2]=jA(rC(c[f>>2]|0)|0,0)|0;c[h>>2]=$B(c[f>>2]|0)|0;a:while(1){if(!(c[h>>2]|0)){n=26;break}if(fE(c[f>>2]|0,c[h>>2]|0,(c[c[h>>2]>>2]|0)>>>4)|0){if(c[l>>2]|0)o=c[(c[l>>2]|0)+8>>2]|0;else o=0;if((gE(c[h>>2]|0,c[g>>2]|0,o)|0)==-1){n=9;break}}c[j>>2]=c[h>>2];c[k>>2]=OA(c[f>>2]|0,c[h>>2]|0)|0;while(1){if(!(c[k>>2]|0))break;b=c[k>>2]|0;if((c[j>>2]|0)!=(c[((c[c[k>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2]|0)?(b=c[k>>2]|0,(fE(c[f>>2]|0,c[((c[c[k>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2]|0,(c[c[h>>2]>>2]|0)>>>4)|0)!=0):0){b=c[k>>2]|0;if(c[l>>2]|0)p=c[(c[l>>2]|0)+8>>2]|0;else p=0;if((gE(c[((c[c[k>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2]|0,c[g>>2]|0,p)|0)==-1){n=17;break a}b=c[k>>2]|0;c[j>>2]=c[((c[c[k>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2]}if(hE(c[f>>2]|0,c[k>>2]|0)|0){if(c[l>>2]|0)q=c[(c[l>>2]|0)+8+4>>2]|0;else q=0;if((iE(c[k>>2]|0,c[g>>2]|0,q)|0)==-1){n=23;break a}}c[k>>2]=QA(c[f>>2]|0,c[k>>2]|0)|0}c[h>>2]=aC(c[f>>2]|0,c[h>>2]|0)|0}if((n|0)==9){c[e>>2]=-1;m=c[e>>2]|0;i=d;return m|0}else if((n|0)==17){c[e>>2]=-1;m=c[e>>2]|0;i=d;return m|0}else if((n|0)==23){c[e>>2]=-1;m=c[e>>2]|0;i=d;return m|0}else if((n|0)==26){c[e>>2]=0;m=c[e>>2]|0;i=d;return m|0}return 0}function bE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[f>>2]=a;c[g>>2]=b;c[13511]=(c[13511]|0)+-1;do if((cE(c[f>>2]|0,c[g>>2]|0)|0)!=-1)if((dE(c[f>>2]|0,c[g>>2]|0,148626)|0)==-1){c[e>>2]=-1;break}else{c[e>>2]=0;break}else c[e>>2]=-1;while(0);i=d;return c[e>>2]|0}function cE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=c[13511];while(1){if((c[h>>2]|0)<=0){j=6;break}if((dE(c[f>>2]|0,c[g>>2]|0,193390)|0)==-1){j=4;break}c[h>>2]=(c[h>>2]|0)+-1}if((j|0)==4){c[e>>2]=-1;k=c[e>>2]|0;i=d;return k|0}else if((j|0)==6){c[e>>2]=0;k=c[e>>2]|0;i=d;return k|0}return 0}function dE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=Ob[c[(c[(c[(c[f>>2]|0)+52>>2]|0)+8>>2]|0)+4>>2]&127](c[g>>2]|0,c[h>>2]|0)|0;i=e;return d|0}function eE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=GD(c[f>>2]|0)|0;while(1){if(!(c[h>>2]|0)){j=12;break}f=(ZD(c[h>>2]|0)|0)!=0;b=c[h>>2]|0;a=c[g>>2]|0;if(!f){if(($D(b,a,0)|0)==-1){j=6;break}if((aE(c[h>>2]|0,c[g>>2]|0)|0)==-1){j=8;break}if((bE(c[h>>2]|0,c[g>>2]|0)|0)==-1){j=10;break}}else eE(b,a)|0;c[h>>2]=HD(c[h>>2]|0)|0}if((j|0)==6){c[e>>2]=-1;k=c[e>>2]|0;i=d;return k|0}else if((j|0)==8){c[e>>2]=-1;k=c[e>>2]|0;i=d;return k|0}else if((j|0)==10){c[e>>2]=-1;k=c[e>>2]|0;i=d;return k|0}else if((j|0)==12){c[e>>2]=0;k=c[e>>2]|0;i=d;return k|0}return 0}function fE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;do if((UD(c[g>>2]|0,c[h>>2]|0)|0)==0?(qE(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0)!=0:0){if((rE(c[g>>2]|0,c[h>>2]|0)|0)==0?(sE(c[g>>2]|0,c[h>>2]|0)|0)==0:0)break;c[f>>2]=1;k=c[f>>2]|0;i=e;return k|0}while(0);c[f>>2]=0;k=c[f>>2]|0;i=e;return k|0}function gE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=qC(c[g>>2]|0)|0;if((cE(c[k>>2]|0,c[h>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}if((jE(c[g>>2]|0,c[h>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}if((lE(c[g>>2]|0)|0)==0?(mE(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0)==-1:0){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}c[f>>2]=dE(c[k>>2]|0,c[h>>2]|0,134814)|0;l=c[f>>2]|0;i=e;return l|0}function hE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=GD(c[f>>2]|0)|0;while(1){if(!(c[h>>2]|0)){j=7;break}if((ZD(c[h>>2]|0)|0)==0?(YA(c[h>>2]|0,c[g>>2]|0,0)|0)!=0:0){j=5;break}c[h>>2]=HD(c[h>>2]|0)|0}if((j|0)==5){c[e>>2]=0;k=c[e>>2]|0;i=d;return k|0}else if((j|0)==7){c[e>>2]=1;k=c[e>>2]|0;i=d;return k|0}return 0}function iE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+24|0;g=e+20|0;h=e+16|0;j=e+12|0;k=e+8|0;l=e+4|0;m=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;d=c[g>>2]|0;c[k>>2]=c[((c[c[g>>2]>>2]&3|0)==3?d:d+32|0)+28>>2];d=c[g>>2]|0;c[l>>2]=c[((c[c[g>>2]>>2]&3|0)==2?d:d+-32|0)+28>>2];c[m>>2]=qC(c[k>>2]|0)|0;do if((cE(c[m>>2]|0,c[h>>2]|0)|0)==-1)c[f>>2]=-1;else{if((jE(c[k>>2]|0,c[h>>2]|0)|0)==-1){c[f>>2]=-1;break}if((kE(c[g>>2]|0,c[h>>2]|0,c[13513]|0)|0)==-1){c[f>>2]=-1;break}d=c[m>>2]|0;b=c[h>>2]|0;a=(nB(qC(c[k>>2]|0)|0)|0)!=0;if((dE(d,b,a?138595:138600)|0)==-1){c[f>>2]=-1;break}if((jE(c[l>>2]|0,c[h>>2]|0)|0)==-1){c[f>>2]=-1;break}if((kE(c[g>>2]|0,c[h>>2]|0,c[13514]|0)|0)==-1){c[f>>2]=-1;break}a=(lE(c[g>>2]|0)|0)!=0;b=c[g>>2]|0;if(a){if((nE(b,c[h>>2]|0,1)|0)==-1){c[f>>2]=-1;break}}else if((mE(b,c[h>>2]|0,c[j>>2]|0)|0)==-1){c[f>>2]=-1;break}c[f>>2]=dE(c[m>>2]|0,c[h>>2]|0,134814)|0}while(0);i=e;return c[f>>2]|0}function jE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+48|0;e=d;f=d+20|0;g=d+16|0;h=d+12|0;j=d+8|0;k=d+24|0;l=d+4|0;c[g>>2]=a;c[h>>2]=b;c[j>>2]=wB(c[g>>2]|0)|0;c[l>>2]=qC(c[g>>2]|0)|0;if(c[j>>2]|0){if((oE(c[l>>2]|0,c[h>>2]|0,c[j>>2]|0)|0)==-1){c[f>>2]=-1;m=c[f>>2]|0;i=d;return m|0}}else{c[e>>2]=c[(c[g>>2]|0)+4>>2];k3(k,134834,e)|0;if((dE(c[l>>2]|0,c[h>>2]|0,k)|0)==-1){c[f>>2]=-1;m=c[f>>2]|0;i=d;return m|0}}c[f>>2]=0;m=c[f>>2]|0;i=d;return m|0}function kE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;a:do if(c[k>>2]|0){c[m>>2]=qC(c[h>>2]|0)|0;c[l>>2]=zA(c[h>>2]|0,c[k>>2]|0)|0;if(!(a[c[l>>2]>>0]|0)){c[g>>2]=0;break}if((dE(c[m>>2]|0,c[j>>2]|0,148898)|0)==-1){c[g>>2]=-1;break}do if($C(c[l>>2]|0)|0){if((oE(c[m>>2]|0,c[j>>2]|0,c[l>>2]|0)|0)==-1){c[g>>2]=-1;break a}}else{c[n>>2]=H3(c[l>>2]|0,58)|0;if(!(c[n>>2]|0)){if((pE(c[m>>2]|0,c[j>>2]|0,c[l>>2]|0,0)|0)!=-1)break;c[g>>2]=-1;break a}a[c[n>>2]>>0]=0;if((pE(c[m>>2]|0,c[j>>2]|0,c[l>>2]|0,0)|0)==-1){c[g>>2]=-1;break a}if((dE(c[m>>2]|0,c[j>>2]|0,148898)|0)==-1){c[g>>2]=-1;break a}if((pE(c[m>>2]|0,c[j>>2]|0,(c[n>>2]|0)+1|0,0)|0)==-1){c[g>>2]=-1;break a}else{a[c[n>>2]>>0]=58;break}}while(0);c[g>>2]=0}else c[g>>2]=0;while(0);i=f;return c[g>>2]|0}function lE(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;i=b;return (c[c[d>>2]>>2]|0)>>>3&1|0}function mE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+48|0;f=e+32|0;g=e+28|0;h=e+24|0;j=e+20|0;k=e+16|0;l=e+12|0;m=e+8|0;n=e+4|0;o=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[n>>2]=0;if(!((c[c[g>>2]>>2]&3|0)!=3?(c[c[g>>2]>>2]&3|0)!=2:0))p=3;do if((p|0)==3){d=nE(c[g>>2]|0,c[h>>2]|0,0)|0;c[o>>2]=d;if((d|0)==-1){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else{if(!(c[o>>2]|0))break;c[n>>2]=(c[n>>2]|0)+1;break}}while(0);c[k>>2]=pA(c[g>>2]|0)|0;c[m>>2]=qC(c[g>>2]|0)|0;a:do if(c[k>>2]|0){c[l>>2]=Hb[c[c[j>>2]>>2]&63](c[j>>2]|0,0,128)|0;while(1){if(!(c[l>>2]|0))break a;if((c[c[g>>2]>>2]&3|0)!=3?(c[c[g>>2]>>2]&3|0)!=2:0)p=16;else p=12;do if((p|0)==12){p=0;if((c[13513]|0)!=0?(c[(c[l>>2]|0)+16>>2]|0)==(c[(c[13513]|0)+16>>2]|0):0)break;if(!((c[13514]|0)!=0?(c[(c[l>>2]|0)+16>>2]|0)==(c[(c[13514]|0)+16>>2]|0):0))p=16}while(0);if((p|0)==16?(p=0,(c[(c[(c[k>>2]|0)+12>>2]|0)+(c[(c[l>>2]|0)+16>>2]<<2)>>2]|0)!=(c[(c[l>>2]|0)+12>>2]|0)):0){o=c[n>>2]|0;c[n>>2]=o+1;d=c[m>>2]|0;b=c[h>>2]|0;if(o){if((dE(d,b,134829)|0)==-1){p=24;break}if((cE(c[m>>2]|0,c[h>>2]|0)|0)==-1){p=26;break}}else{if((cE(d,b)|0)==-1){p=19;break}if((dE(c[m>>2]|0,c[h>>2]|0,134826)|0)==-1){p=21;break}c[13511]=(c[13511]|0)+1}if((oE(c[m>>2]|0,c[h>>2]|0,c[(c[l>>2]|0)+8>>2]|0)|0)==-1){p=28;break}if((dE(c[m>>2]|0,c[h>>2]|0,134832)|0)==-1){p=30;break}if((oE(c[m>>2]|0,c[h>>2]|0,c[(c[(c[k>>2]|0)+12>>2]|0)+(c[(c[l>>2]|0)+16>>2]<<2)>>2]|0)|0)==-1){p=32;break}}c[l>>2]=Hb[c[c[j>>2]>>2]&63](c[j>>2]|0,c[l>>2]|0,8)|0}if((p|0)==19){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else if((p|0)==21){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else if((p|0)==24){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else if((p|0)==26){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else if((p|0)==28){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else if((p|0)==30){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}else if((p|0)==32){c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}}while(0);do if((c[n>>2]|0)>0){if((dE(c[m>>2]|0,c[h>>2]|0,134824)|0)!=-1){c[13511]=(c[13511]|0)+-1;break}c[f>>2]=-1;q=c[f>>2]|0;i=e;return q|0}while(0);h=c[g>>2]|0;c[h>>2]=c[h>>2]&-9|8;c[f>>2]=0;q=c[f>>2]|0;i=e;return q|0}function nE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[m>>2]=wB(c[h>>2]|0)|0;c[n>>2]=qC(c[h>>2]|0)|0;if((c[m>>2]|0)!=0?(a[c[m>>2]>>0]|0)!=0:0){if((dE(c[n>>2]|0,c[j>>2]|0,134817)|0)==-1){c[g>>2]=-1;o=c[g>>2]|0;i=f;return o|0}if((oE(c[n>>2]|0,c[j>>2]|0,c[m>>2]|0)|0)==-1){c[g>>2]=-1;o=c[g>>2]|0;i=f;return o|0}if((c[k>>2]|0)!=0?(dE(c[n>>2]|0,c[j>>2]|0,134824)|0)==-1:0){c[g>>2]=-1;o=c[g>>2]|0;i=f;return o|0}c[l>>2]=1}else c[l>>2]=0;c[g>>2]=c[l>>2];o=c[g>>2]|0;i=f;return o|0}function oE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=pE(c[f>>2]|0,c[g>>2]|0,c[h>>2]|0,1)|0;i=e;return d|0}function pE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+16|0;g=f+12|0;h=f+8|0;j=f+4|0;k=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;e=c[j>>2]|0;if(c[k>>2]|0)c[j>>2]=TD(e)|0;else c[j>>2]=XD(e,YD(c[j>>2]|0)|0)|0;e=dE(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;i=f;return e|0}function qE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if((c[c[h>>2]>>2]|0)>>>4>>>0<(c[j>>2]|0)>>>0){c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}c[k>>2]=RA(c[g>>2]|0,c[h>>2]|0)|0;while(1){if(!(c[k>>2]|0)){m=8;break}if((c[c[(c[k>>2]|0)+28>>2]>>2]|0)>>>4>>>0<(c[j>>2]|0)>>>0){m=6;break}c[k>>2]=SA(c[g>>2]|0,c[k>>2]|0)|0}if((m|0)==6){c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}else if((m|0)==8){c[f>>2]=1;l=c[f>>2]|0;i=e;return l|0}return 0}function rE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;if(RA(c[e>>2]|0,c[f>>2]|0)|0){g=0;h=g&1;i=d;return h|0}g=(OA(c[e>>2]|0,c[f>>2]|0)|0)==0;h=g&1;i=d;return h|0}function sE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+32|0;e=d+16|0;f=d+8|0;g=d+4|0;h=d;c[d+12>>2]=a;c[f>>2]=b;b=pA(c[f>>2]|0)|0;c[g>>2]=b;a:do if(b){c[h>>2]=Hb[c[c[(c[g>>2]|0)+8>>2]>>2]&63](c[(c[g>>2]|0)+8>>2]|0,0,128)|0;while(1){if(!(c[h>>2]|0))break a;if((c[(c[(c[g>>2]|0)+12>>2]|0)+(c[(c[h>>2]|0)+16>>2]<<2)>>2]|0)!=(c[(c[h>>2]|0)+12>>2]|0))break;c[h>>2]=Hb[c[c[(c[g>>2]|0)+8>>2]>>2]&63](c[(c[g>>2]|0)+8>>2]|0,c[h>>2]|0,8)|0}c[e>>2]=1;j=c[e>>2]|0;i=d;return j|0}while(0);c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}function tE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;d=jA(c[g>>2]|0,0)|0;c[k>>2]=d;if(d){if((uE(c[g>>2]|0,c[h>>2]|0,149098,c[(c[k>>2]|0)+8+8>>2]|0,c[j>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}if((uE(c[g>>2]|0,c[h>>2]|0,149084,c[(c[k>>2]|0)+8>>2]|0,c[j>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}if((uE(c[g>>2]|0,c[h>>2]|0,149079,c[(c[k>>2]|0)+8+4>>2]|0,c[j>>2]|0)|0)==-1){c[f>>2]=-1;l=c[f>>2]|0;i=e;return l|0}}c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}function uE(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;j=i;i=i+48|0;k=j+36|0;l=j+32|0;m=j+28|0;n=j+24|0;o=j+20|0;p=j+16|0;q=j+12|0;r=j+8|0;s=j+4|0;t=j;c[l>>2]=b;c[m>>2]=e;c[n>>2]=f;c[o>>2]=g;c[p>>2]=h;c[q>>2]=0;if(c[p>>2]|0)c[r>>2]=0;else c[r>>2]=Sz(c[o>>2]|0,0)|0;c[s>>2]=Hb[c[c[o>>2]>>2]&63](c[o>>2]|0,0,128)|0;while(1){if(!(c[s>>2]|0)){u=32;break}if((c[(c[s>>2]|0)+12>>2]|0)!=0?(a[c[(c[s>>2]|0)+12>>2]>>0]|0)!=0:0)u=13;else u=8;do if((u|0)==8){u=0;if(!(a[(c[s>>2]|0)+22>>0]|0)){if(c[r>>2]|0){c[t>>2]=Hb[c[c[r>>2]>>2]&63](c[r>>2]|0,c[s>>2]|0,4)|0;if((c[(c[t>>2]|0)+12>>2]|0)!=0?(a[c[(c[t>>2]|0)+12>>2]>>0]|0)!=0:0){u=13;break}if(!(d[(c[t>>2]|0)+22>>0]|0))u=13}}else u=13}while(0);if((u|0)==13){u=0;h=c[q>>2]|0;c[q>>2]=h+1;g=c[l>>2]|0;f=c[m>>2]|0;if(h){if((dE(g,f,134829)|0)==-1){u=22;break}if((cE(c[l>>2]|0,c[m>>2]|0)|0)==-1){u=24;break}}else{if((cE(g,f)|0)==-1){u=15;break}if((dE(c[l>>2]|0,c[m>>2]|0,c[n>>2]|0)|0)==-1){u=17;break}if((dE(c[l>>2]|0,c[m>>2]|0,134826)|0)==-1){u=19;break}c[13511]=(c[13511]|0)+1}if((oE(c[l>>2]|0,c[m>>2]|0,c[(c[s>>2]|0)+8>>2]|0)|0)==-1){u=26;break}if((dE(c[l>>2]|0,c[m>>2]|0,134832)|0)==-1){u=28;break}if((oE(c[l>>2]|0,c[m>>2]|0,c[(c[s>>2]|0)+12>>2]|0)|0)==-1){u=30;break}}c[s>>2]=Hb[c[c[o>>2]>>2]&63](c[o>>2]|0,c[s>>2]|0,8)|0}if((u|0)==15){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==17){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==19){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==22){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==24){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==26){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==28){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==30){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}else if((u|0)==32){if((c[q>>2]|0)>0){c[13511]=(c[13511]|0)+-1;if((c[q>>2]|0)>1){if((dE(c[l>>2]|0,c[m>>2]|0,193392)|0)==-1){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}if((cE(c[l>>2]|0,c[m>>2]|0)|0)==-1){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}}if((dE(c[l>>2]|0,c[m>>2]|0,134862)|0)==-1){c[k>>2]=-1;v=c[k>>2]|0;i=j;return v|0}}if(!(c[p>>2]|0))Sz(c[o>>2]|0,c[r>>2]|0)|0;c[k>>2]=0;v=c[k>>2]|0;i=j;return v|0}return 0}function vE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=i;i=i+32|0;h=g+28|0;j=g+24|0;k=g+20|0;l=g+16|0;m=g+12|0;n=g+8|0;o=g+4|0;p=g;c[j>>2]=a;c[k>>2]=b;c[l>>2]=d;c[m>>2]=e;c[n>>2]=f;switch(c[c[k>>2]>>2]&3|0){case 0:{c[p>>2]=82;break}case 1:{c[p>>2]=83;break}case 3:case 2:{c[p>>2]=84;break}default:{}}f=Ob[c[p>>2]&127](c[j>>2]|0,c[k>>2]|0)|0;c[o>>2]=f;if(f){zE(c[j>>2]|0,c[o>>2]|0,c[l>>2]|0,c[m>>2]|0,c[p>>2]|0,c[n>>2]|0);c[h>>2]=0;q=c[h>>2]|0;i=g;return q|0}else{c[h>>2]=-1;q=c[h>>2]|0;i=g;return q|0}return 0}function wE(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d+4|0;c[e>>2]=a;c[d>>2]=b;i=d;return c[e>>2]|0}function xE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[f>>2]=a;c[g>>2]=b;b=qC(c[g>>2]|0)|0;if((b|0)==(c[f>>2]|0)){c[e>>2]=c[g>>2];h=c[e>>2]|0;i=d;return h|0}else{c[e>>2]=eC(c[f>>2]|0,c[g>>2]|0,0)|0;h=c[e>>2]|0;i=d;return h|0}return 0}function yE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[f>>2]=a;c[g>>2]=b;b=qC(c[g>>2]|0)|0;if((b|0)==(c[f>>2]|0)){c[e>>2]=c[g>>2];h=c[e>>2]|0;i=d;return h|0}else{c[e>>2]=YA(c[f>>2]|0,c[g>>2]|0,0)|0;h=c[e>>2]|0;i=d;return h|0}return 0}function zE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;i=i+32|0;j=h+28|0;k=h+24|0;l=h+20|0;m=h+16|0;n=h+12|0;o=h+8|0;p=h+4|0;q=h;c[j>>2]=a;c[k>>2]=b;c[l>>2]=d;c[m>>2]=e;c[n>>2]=f;c[o>>2]=g;if(c[o>>2]|0)Tb[c[l>>2]&127](c[j>>2]|0,c[k>>2]|0,c[m>>2]|0);c[p>>2]=GD(c[j>>2]|0)|0;while(1){if(!(c[p>>2]|0))break;g=Ob[c[n>>2]&127](c[p>>2]|0,c[k>>2]|0)|0;c[q>>2]=g;if(g)zE(c[p>>2]|0,c[q>>2]|0,c[l>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0);c[p>>2]=HD(c[p>>2]|0)|0}if(c[o>>2]|0){i=h;return}Tb[c[l>>2]&127](c[j>>2]|0,c[k>>2]|0,c[m>>2]|0);i=h;return}function AE(){var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;e=i;i=i+1280|0;f=e+868|0;g=e+864|0;h=e+872|0;j=e+860|0;k=e+856|0;l=e+48|0;m=e+44|0;n=e+40|0;o=e+36|0;p=e+32|0;q=e+28|0;r=e+24|0;s=e+20|0;t=e+16|0;u=e+12|0;v=e+8|0;w=e+4|0;x=e;c[s>>2]=0;c[q>>2]=0;c[j>>2]=h;c[l>>2]=e+56;c[n>>2]=200;c[f>>2]=0;c[g>>2]=0;c[13524]=0;c[13525]=-2;c[k>>2]=c[j>>2];c[m>>2]=c[l>>2];a:while(1){b[c[k>>2]>>1]=c[f>>2];if(((c[j>>2]|0)+(c[n>>2]<<1)+-2|0)>>>0<=(c[k>>2]|0)>>>0){c[t>>2]=(((c[k>>2]|0)-(c[j>>2]|0)|0)/2|0)+1;if(1e4<=(c[n>>2]|0)>>>0){y=88;break}z=c[n>>2]<<1;c[n>>2]=z;c[n>>2]=1e4<(c[n>>2]|0)>>>0?1e4:z;c[u>>2]=c[j>>2];c[v>>2]=N4(((c[n>>2]|0)*6|0)+3|0)|0;if(!(c[v>>2]|0)){y=88;break}Z4(c[v>>2]|0,c[j>>2]|0,c[t>>2]<<1|0)|0;c[j>>2]=c[v>>2];c[w>>2]=(c[n>>2]<<1)+3;c[v>>2]=(c[v>>2]|0)+((((c[w>>2]|0)>>>0)/4|0)<<2);Z4(c[v>>2]|0,c[l>>2]|0,c[t>>2]<<2|0)|0;c[l>>2]=c[v>>2];c[x>>2]=(c[n>>2]<<2)+3;c[v>>2]=(c[v>>2]|0)+((((c[x>>2]|0)>>>0)/4|0)<<2);if((c[u>>2]|0)!=(h|0))O4(c[u>>2]|0);c[k>>2]=(c[j>>2]|0)+(c[t>>2]<<1)+-2;c[m>>2]=(c[l>>2]|0)+(c[t>>2]<<2)+-4;if(((c[j>>2]|0)+(c[n>>2]<<1)+-2|0)>>>0<=(c[k>>2]|0)>>>0){y=87;break}}if((c[f>>2]|0)==6){y=86;break}c[o>>2]=a[134876+(c[f>>2]|0)>>0];do if((c[o>>2]|0)!=-18){if((c[13525]|0)==-2)c[13525]=gD()|0;if((c[13525]|0)<=0){c[q>>2]=0;c[13525]=0}else{if((c[13525]|0)>>>0<=268)A=d[134956+(c[13525]|0)>>0]|0;else A=2;c[q>>2]=A}c[o>>2]=(c[o>>2]|0)+(c[q>>2]|0);if(!((c[o>>2]|0)<0|59<(c[o>>2]|0))?(d[135225+(c[o>>2]|0)>>0]|0)==(c[q>>2]|0):0){c[o>>2]=a[135285+(c[o>>2]|0)>>0];if((c[o>>2]|0)<=0){c[o>>2]=0-(c[o>>2]|0);y=26;break}if(c[g>>2]|0)c[g>>2]=(c[g>>2]|0)+-1;c[13525]=-2;c[f>>2]=c[o>>2];z=(c[m>>2]|0)+4|0;c[m>>2]=z;c[z>>2]=c[13526]}else y=25}else y=25;while(0);if((y|0)==25){y=0;c[o>>2]=d[135345+(c[f>>2]|0)>>0];if(!(c[o>>2]|0)){if((c[13525]|0)!=-2)if((c[13525]|0)>>>0<=268)B=d[134956+(c[13525]|0)>>0]|0;else B=2;else B=-2;c[q>>2]=B;if(!(c[g>>2]|0)){c[13524]=(c[13524]|0)+1;nD(180146)}do if((c[g>>2]|0)==3)if((c[13525]|0)<=0)if(!(c[13525]|0)){y=87;break a}else break;else{OE(178296,c[q>>2]|0,54104);c[13525]=-2;break}while(0);c[g>>2]=3;while(1){c[o>>2]=a[134876+(c[f>>2]|0)>>0];if((((c[o>>2]|0)!=-18?(c[o>>2]=(c[o>>2]|0)+1,0<=(c[o>>2]|0)&(c[o>>2]|0)<=59):0)?(d[135225+(c[o>>2]|0)>>0]|0)==1:0)?(c[o>>2]=a[135285+(c[o>>2]|0)>>0],0<(c[o>>2]|0)):0)break;if((c[k>>2]|0)==(c[j>>2]|0)){y=87;break a}OE(178430,d[135621+(c[f>>2]|0)>>0]|0,c[m>>2]|0);c[m>>2]=(c[m>>2]|0)+-4;c[k>>2]=(c[k>>2]|0)+-2;c[f>>2]=b[c[k>>2]>>1]}z=(c[m>>2]|0)+4|0;c[m>>2]=z;c[z>>2]=c[13526];c[f>>2]=c[o>>2]}else y=26}do if((y|0)==26){y=0;c[s>>2]=d[135425+(c[o>>2]|0)>>0];c[r>>2]=c[(c[m>>2]|0)+(1-(c[s>>2]|0)<<2)>>2];b:do switch(c[o>>2]|0){case 2:{DE();break}case 3:{if(c[13527]|0){jB(c[13527]|0)|0;c[13072]=0;c[13527]=0}break}case 6:{EE(c[c[m>>2]>>2]|0,c[(c[m>>2]|0)+-4>>2]|0,c[(c[m>>2]|0)+-8>>2]|0);break}case 7:{c[r>>2]=c[c[m>>2]>>2];break}case 8:{c[r>>2]=0;break}case 9:{c[r>>2]=1;break}case 10:{c[r>>2]=0;break}case 11:{c[r>>2]=0;break}case 12:{c[r>>2]=1;break}case 21:{if(c[(c[m>>2]|0)+-4>>2]|0){FE();break b}else{GE();break b}break}case 24:{HE(1);break}case 25:{HE(2);break}case 26:{c[r>>2]=1;break}case 27:{c[r>>2]=0;break}case 30:{IE(c[c[m>>2]>>2]|0,0,0);break}case 31:{IE(c[(c[m>>2]|0)+-8>>2]|0,c[c[m>>2]>>2]|0,0);break}case 32:{IE(c[(c[m>>2]|0)+-16>>2]|0,c[(c[m>>2]|0)+-8>>2]|0,c[c[m>>2]>>2]|0);break}case 33:{JE(c[(c[m>>2]|0)+-8>>2]|0,c[(c[m>>2]|0)+-4>>2]|0);break}case 34:{JE(258,0);break}case 35:{c[r>>2]=258;break}case 36:{c[r>>2]=259;break}case 37:{c[r>>2]=260;break}case 38:{c[r>>2]=c[(c[m>>2]|0)+-4>>2];break}case 39:{c[r>>2]=0;break}case 48:{KE(c[(c[m>>2]|0)+-8>>2]|0,c[c[m>>2]>>2]|0);break}case 49:{KE(c[c[m>>2]>>2]|0,0);break}case 51:{LE(c[c[m>>2]>>2]|0);break}case 52:{ME();break}case 53:{c[r>>2]=c[c[m>>2]>>2];break}case 54:{c[r>>2]=0;break}case 55:{c[r>>2]=0;break}case 59:{c[r>>2]=c[c[m>>2]>>2];break}case 60:{c[r>>2]=c[c[m>>2]>>2];break}case 61:{c[r>>2]=c[c[m>>2]>>2];break}case 62:{c[r>>2]=NE(c[(c[m>>2]|0)+-8>>2]|0,c[c[m>>2]>>2]|0)|0;break}default:{}}while(0);c[m>>2]=(c[m>>2]|0)+(0-(c[s>>2]|0)<<2);c[k>>2]=(c[k>>2]|0)+(0-(c[s>>2]|0)<<1);c[s>>2]=0;z=(c[m>>2]|0)+4|0;c[m>>2]=z;c[z>>2]=c[r>>2];c[o>>2]=d[135488+(c[o>>2]|0)>>0];c[f>>2]=(a[135551+((c[o>>2]|0)-24)>>0]|0)+(b[c[k>>2]>>1]|0);if(0<=(c[f>>2]|0)&(c[f>>2]|0)<=59?(d[135225+(c[f>>2]|0)>>0]|0)==(b[c[k>>2]>>1]|0):0){c[f>>2]=a[135285+(c[f>>2]|0)>>0];break}c[f>>2]=a[135586+((c[o>>2]|0)-24)>>0]}while(0);c[k>>2]=(c[k>>2]|0)+2}if((y|0)==86)c[p>>2]=0;else if((y|0)==87)c[p>>2]=1;else if((y|0)==88){nD(178445);c[p>>2]=2}if((c[13525]|0)!=-2){if((c[13525]|0)>>>0<=268)C=d[134956+(c[13525]|0)>>0]|0;else C=2;c[q>>2]=C;OE(178462,c[q>>2]|0,54104)}c[m>>2]=(c[m>>2]|0)+(0-(c[s>>2]|0)<<2);c[k>>2]=(c[k>>2]|0)+(0-(c[s>>2]|0)<<1);while(1){if((c[k>>2]|0)==(c[j>>2]|0))break;OE(178492,d[135621+(b[c[k>>2]>>1]|0)>>0]|0,c[m>>2]|0);c[m>>2]=(c[m>>2]|0)+-4;c[k>>2]=(c[k>>2]|0)+-2}if((c[j>>2]|0)==(h|0)){D=c[p>>2]|0;i=e;return D|0}O4(c[j>>2]|0);D=c[p>>2]|0;i=e;return D|0}function BE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[13180]=c[g>>2];c[13527]=c[f>>2];c[13072]=0;c[13528]=(c[h>>2]|0)!=0?c[h>>2]|0:52276;fD(c[13528]|0,c[g>>2]|0);AE()|0;if(c[13072]|0){j=c[13072]|0;i=e;return j|0}pD();j=c[13072]|0;i=e;return j|0}function CE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=BE(0,c[e>>2]|0,c[f>>2]|0)|0;i=d;return b|0}function DE(){oD();JB(c[13527]|0);return}function EE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+16|0;g=f+12|0;h=f+8|0;j=f+4|0;k=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;if(!(c[13527]|0)){a[54120]=a[54120]&-2|c[j>>2]&1;a[54120]=a[54120]&-3|(c[k>>2]&1)<<1&255;a[54120]=a[54120]&-9|8;k=c[h>>2]|0;j=c[13528]|0;c[g>>2]=c[13530];e=gB(k,g,j)|0;c[13527]=e;c[13072]=e;l=c[13529]|0;m=c[13527]|0;n=QE(l,m)|0;c[13529]=n;o=c[h>>2]|0;_C(0,o)|0;i=f;return}else{c[13072]=c[13527];l=c[13529]|0;m=c[13527]|0;n=QE(l,m)|0;c[13529]=n;o=c[h>>2]|0;_C(0,o)|0;i=f;return}}function FE(){var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;b=i;i=i+32|0;d=b+20|0;e=b+16|0;f=b+12|0;g=b+8|0;h=b+4|0;j=b;VE(2);c[d>>2]=0;c[e>>2]=c[(c[13529]|0)+24>>2];while(1){if(!(c[e>>2]|0))break;if(((c[c[e>>2]>>2]|0)==267?(a[c[(c[e>>2]|0)+4>>2]>>0]|0)==(a[135701]|0):0)?(J3(c[(c[e>>2]|0)+4>>2]|0,135701)|0)==0:0)c[d>>2]=c[(c[e>>2]|0)+8>>2];c[e>>2]=c[(c[e>>2]|0)+12>>2]}c[g>>2]=c[(c[13529]|0)+16>>2];while(1){if(!(c[(c[g>>2]|0)+12>>2]|0))break;e=(c[g>>2]|0)+4|0;a:do if((c[c[g>>2]>>2]|0)==262){c[j>>2]=c[e>>2];c[h>>2]=$B(c[j>>2]|0)|0;while(1){if(!(c[h>>2]|0))break a;k=eC(c[c[13529]>>2]|0,c[h>>2]|0,0)|0;bF(k,0,c[(c[g>>2]|0)+12>>2]|0,c[d>>2]|0);c[h>>2]=aC(c[j>>2]|0,c[h>>2]|0)|0}}else{c[f>>2]=c[e>>2];while(1){if(!(c[f>>2]|0))break a;bF(c[(c[f>>2]|0)+4>>2]|0,c[(c[f>>2]|0)+8>>2]|0,c[(c[g>>2]|0)+12>>2]|0,c[d>>2]|0);c[f>>2]=c[(c[f>>2]|0)+12>>2]}}while(0);c[g>>2]=c[(c[g>>2]|0)+12>>2]}WE((c[13529]|0)+8|0);WE((c[13529]|0)+16|0);WE((c[13529]|0)+24|0);c[(c[13529]|0)+4>>2]=0;i=b;return}function GE(){var a=0,b=0;a=i;i=i+16|0;b=a;VE(1);c[b>>2]=c[(c[13529]|0)+8>>2];while(1){if(!(c[b>>2]|0))break;aF(c[(c[b>>2]|0)+4>>2]|0);c[b>>2]=c[(c[b>>2]|0)+12>>2]}WE((c[13529]|0)+8|0);WE((c[13529]|0)+24|0);WE((c[13529]|0)+16|0);c[(c[13529]|0)+4>>2]=0;i=a;return}function HE(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[b+4>>2]=a;c[d>>2]=0;a=c[13529]|0;if(c[(c[13529]|0)+8>>2]|0){c[d>>2]=_E(c[a+8>>2]|0)|0;c[(c[13529]|0)+8+4>>2]=0;c[(c[13529]|0)+8>>2]=0}else{if(c[a+4>>2]|0)c[d>>2]=$E(c[(c[13529]|0)+4>>2]|0)|0;c[(c[13529]|0)+4>>2]=0}if(!(c[d>>2]|0)){i=b;return}SE((c[13529]|0)+16|0,c[d>>2]|0);i=b;return}function IE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if(c[h>>2]|0)c[g>>2]=YE(c[g>>2]|0,c[h>>2]|0)|0;h=fC(c[c[13529]>>2]|0,c[f>>2]|0,1)|0;c[j>>2]=ZE(h,c[g>>2]|0)|0;SE((c[13529]|0)+8|0,c[j>>2]|0);_C(c[13527]|0,c[f>>2]|0)|0;i=e;return}function JE(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=b;c[g>>2]=d;if(c[g>>2]|0)UE();c[h>>2]=c[(c[13529]|0)+24>>2];while(1){if(!(c[h>>2]|0))break;if(!(c[(c[h>>2]|0)+8>>2]|0))UE();c[h>>2]=c[(c[h>>2]|0)+12>>2]}switch(c[f>>2]|0){case 258:{c[j>>2]=0;break}case 259:{c[j>>2]=1;break}case 260:{c[j>>2]=2;break}default:{}}VE(c[j>>2]|0);c[h>>2]=c[(c[13529]|0)+24>>2];while(1){if(!(c[h>>2]|0))break;if((a[(c[(c[h>>2]|0)+4>>2]|0)+21>>0]|0)!=0?(c[c[13529]>>2]|0)==(c[13527]|0):0)c[k>>2]=c[(c[h>>2]|0)+4>>2];else c[k>>2]=qA(c[c[13529]>>2]|0,c[j>>2]|0,c[(c[(c[h>>2]|0)+4>>2]|0)+8>>2]|0,c[(c[h>>2]|0)+8>>2]|0)|0;if((c[c[13529]>>2]|0)==(c[13527]|0))a[(c[k>>2]|0)+22>>0]=1;c[h>>2]=c[(c[h>>2]|0)+12>>2]}WE((c[13529]|0)+24|0);i=e;return}function KE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=RE(c[e>>2]|0,c[f>>2]|0)|0;SE((c[13529]|0)+24|0,c[g>>2]|0);i=d;return}function LE(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=c[13529]|0;c[13529]=QE(a,FD(c[c[13529]>>2]|0,c[d>>2]|0,1)|0)|0;_C(c[13527]|0,c[d>>2]|0)|0;i=b;return}function ME(){var a=0,b=0;a=i;i=i+16|0;b=a;c[b>>2]=c[c[13529]>>2];c[13529]=PE(c[13529]|0)|0;c[(c[13529]|0)+4>>2]=c[b>>2];i=a;return}function NE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+1056|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+24|0;j=d+4|0;k=d;c[e>>2]=a;c[f>>2]=b;b=N3(c[e>>2]|0)|0;c[k>>2]=b+(N3(c[f>>2]|0)|0)+1;if((c[k>>2]|0)<=1024)c[j>>2]=h;else c[j>>2]=N4(c[k>>2]|0)|0;K3(c[j>>2]|0,c[e>>2]|0)|0;G3(c[j>>2]|0,c[f>>2]|0)|0;c[g>>2]=YC(c[13527]|0,c[j>>2]|0)|0;_C(c[13527]|0,c[e>>2]|0)|0;_C(c[13527]|0,c[f>>2]|0)|0;if((c[j>>2]|0)==(h|0)){l=c[g>>2]|0;i=d;return l|0}O4(c[j>>2]|0);l=c[g>>2]|0;i=d;return l|0}function OE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e+8|0;c[f>>2]=a;c[e+4>>2]=b;c[e>>2]=d;if(c[f>>2]|0){i=e;return}c[f>>2]=178509;i=e;return}function PE(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=c[(c[13529]|0)+32>>2];VB(c[13527]|0,c[d>>2]|0);i=b;return c[e>>2]|0}function QE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=UB(c[13527]|0,36)|0;c[(c[g>>2]|0)+32>>2]=c[e>>2];c[c[g>>2]>>2]=c[f>>2];i=d;return c[g>>2]|0}function RE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=TE(267,c[e>>2]|0,c[f>>2]|0)|0;i=d;return b|0}function SE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;if(c[(c[e>>2]|0)+4>>2]|0)c[(c[(c[e>>2]|0)+4>>2]|0)+12>>2]=c[f>>2];c[(c[e>>2]|0)+4>>2]=c[f>>2];if(c[c[e>>2]>>2]|0){i=d;return}c[c[e>>2]>>2]=c[f>>2];i=d;return}function TE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=UB(c[13527]|0,16)|0;c[c[j>>2]>>2]=c[f>>2];c[(c[j>>2]|0)+4>>2]=c[g>>2];c[(c[j>>2]|0)+8>>2]=c[h>>2];i=e;return c[j>>2]|0}function UE(){var a=0;a=i;i=i+16|0;$z(0,135705,a)|0;i=a;return}function VE(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=b;c[f>>2]=c[(c[13529]|0)+24>>2];while(1){if(!(c[f>>2]|0))break;c[g>>2]=c[(c[f>>2]|0)+4>>2];if(!(((c[e>>2]|0)==2?(a[c[g>>2]>>0]|0)==(a[135701]|0):0)?(J3(c[g>>2]|0,135701)|0)==0:0)){b=qA(c[c[13529]>>2]|0,c[e>>2]|0,c[g>>2]|0,0)|0;c[(c[f>>2]|0)+4>>2]=b;if(!b){b=qA(c[c[13529]>>2]|0,c[e>>2]|0,c[g>>2]|0,178518)|0;c[(c[f>>2]|0)+4>>2]=b}c[c[f>>2]>>2]=266;_C(c[13527]|0,c[g>>2]|0)|0}c[f>>2]=c[(c[f>>2]|0)+12>>2]}i=d;return}function WE(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;XE(c[c[d>>2]>>2]|0);c[(c[d>>2]|0)+4>>2]=0;c[c[d>>2]>>2]=0;i=b;return}function XE(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[e>>2]=c[d>>2];while(1){if(!(c[e>>2]|0))break;c[f>>2]=c[(c[e>>2]|0)+12>>2];switch(c[c[e>>2]>>2]|0){case 265:{XE(c[(c[e>>2]|0)+4>>2]|0);break}case 266:case 267:{_C(c[13527]|0,c[(c[e>>2]|0)+8>>2]|0)|0;break}default:{}}VB(c[13527]|0,c[e>>2]|0);c[e>>2]=c[f>>2]}i=b;return}function YE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+1056|0;e=d;f=d+24|0;g=d+20|0;h=d+16|0;j=d+32|0;k=d+12|0;l=d+8|0;c[f>>2]=a;c[g>>2]=b;b=N3(c[f>>2]|0)|0;c[l>>2]=b+(N3(c[g>>2]|0)|0)+2;if((c[l>>2]|0)<=1024)c[k>>2]=j;else c[k>>2]=N4(c[l>>2]|0)|0;l=c[k>>2]|0;b=c[g>>2]|0;c[e>>2]=c[f>>2];c[e+4>>2]=b;k3(l,135738,e)|0;c[h>>2]=YC(c[13527]|0,c[k>>2]|0)|0;_C(c[13527]|0,c[f>>2]|0)|0;_C(c[13527]|0,c[g>>2]|0)|0;if((c[k>>2]|0)==(j|0)){m=c[h>>2]|0;i=d;return m|0}O4(c[k>>2]|0);m=c[h>>2]|0;i=d;return m|0}function ZE(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=TE(259,c[e>>2]|0,c[f>>2]|0)|0;i=d;return b|0}function _E(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=TE(265,c[d>>2]|0,0)|0;i=b;return a|0}function $E(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=TE(262,c[d>>2]|0,0)|0;i=b;return a|0}function aF(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=c[(c[13529]|0)+24>>2];while(1){if(!(c[e>>2]|0))break;if((c[c[e>>2]>>2]|0)==266?(c[(c[e>>2]|0)+4>>2]|0)!=0:0)BA(c[d>>2]|0,c[(c[e>>2]|0)+4>>2]|0,c[(c[e>>2]|0)+8>>2]|0)|0;c[e>>2]=c[(c[e>>2]|0)+12>>2]}i=b;return}function bF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;e=(c[j>>2]|0)+4|0;if((c[c[j>>2]>>2]|0)==262){c[m>>2]=c[e>>2];c[l>>2]=$B(c[m>>2]|0)|0;while(1){if(!(c[l>>2]|0))break;j=c[g>>2]|0;d=c[h>>2]|0;b=eC(c[c[13529]>>2]|0,c[l>>2]|0,0)|0;cF(j,d,b,0,c[k>>2]|0);c[l>>2]=aC(c[m>>2]|0,c[l>>2]|0)|0}i=f;return}else{c[n>>2]=c[e>>2];while(1){if(!(c[n>>2]|0))break;e=c[g>>2]|0;l=c[h>>2]|0;m=eC(c[c[13529]>>2]|0,c[(c[n>>2]|0)+4>>2]|0,0)|0;cF(e,l,m,c[(c[n>>2]|0)+8>>2]|0,c[k>>2]|0);c[n>>2]=c[(c[n>>2]|0)+12>>2]}i=f;return}}function cF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=i;i=i+48|0;h=g+32|0;j=g+28|0;k=g+24|0;l=g+20|0;m=g+16|0;n=g+12|0;o=g+8|0;p=g+4|0;q=g;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;c[n>>2]=VA(c[c[13529]>>2]|0,c[h>>2]|0,c[k>>2]|0,c[m>>2]|0,1)|0;if(!(c[n>>2]|0)){i=g;return}c[o>>2]=c[j>>2];c[p>>2]=c[l>>2];l=c[n>>2]|0;j=c[n>>2]|0;if((c[((c[c[n>>2]>>2]&3|0)==3?l:l+32|0)+28>>2]|0)!=(c[((c[c[n>>2]>>2]&3|0)==2?j:j+-32|0)+28>>2]|0)?(j=c[n>>2]|0,(c[((c[c[n>>2]>>2]&3|0)==2?j:j+-32|0)+28>>2]|0)==(c[h>>2]|0)):0){c[q>>2]=c[o>>2];c[o>>2]=c[p>>2];c[p>>2]=c[q>>2]}dF(c[n>>2]|0,149070,c[o>>2]|0);dF(c[n>>2]|0,149061,c[p>>2]|0);aF(c[n>>2]|0);i=g;return}function dF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;if(!(c[h>>2]|0)){i=e;return}d=qA(c[c[13529]>>2]|0,2,c[g>>2]|0,0)|0;c[j>>2]=d;if(!d)c[j>>2]=qA(c[c[13529]>>2]|0,2,c[g>>2]|0,178518)|0;BA(c[f>>2]|0,c[j>>2]|0,c[h>>2]|0)|0;i=e;return}function eF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=yF(c[f>>2]|0,1,c[g>>2]|0)|0;if(c[h>>2]|0){c[j>>2]=c[(c[h>>2]|0)+16>>2];c[(c[f>>2]|0)+172+12>>2]=c[(c[j>>2]|0)+4>>2];c[(c[f>>2]|0)+172>>2]=c[(c[j>>2]|0)+12>>2];c[(c[f>>2]|0)+172+4>>2]=c[c[j>>2]>>2];c[(c[f>>2]|0)+172+8>>2]=c[(c[j>>2]|0)+16>>2];c[e>>2]=300;k=c[e>>2]|0;i=d;return k|0}else{c[e>>2]=999;k=c[e>>2]|0;i=d;return k|0}return 0}function fF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+32|0;e=d;f=d+28|0;g=d+24|0;h=d+20|0;j=d+16|0;k=d+12|0;l=d+8|0;c[g>>2]=a;c[h>>2]=b;MC(c[h>>2]|0,175049,280,1)|0;c[(c[(c[h>>2]|0)+8>>2]|0)+144>>2]=c[g>>2];b=c[h>>2]|0;if((b|0)!=(rC(c[h>>2]|0)|0)){b=c[g>>2]|0;c[(c[(rC(c[h>>2]|0)|0)+8>>2]|0)+144>>2]=b}b=yA(c[h>>2]|0,136032)|0;c[k>>2]=b;if((b|0)!=0?(c[(c[g>>2]|0)+172>>2]=0,c[l>>2]=eF(c[g>>2]|0,c[k>>2]|0)|0,(c[l>>2]|0)==999):0){l=c[k>>2]|0;b=zF(c[g>>2]|0,1,c[k>>2]|0)|0;c[e>>2]=l;c[e+4>>2]=b;$z(1,136511,e)|0;c[f>>2]=-1;m=c[f>>2]|0;i=d;return m|0}c[j>>2]=c[(c[g>>2]|0)+172>>2];if(!(c[j>>2]|0)){c[f>>2]=-1;m=c[f>>2]|0;i=d;return m|0}KH(1);KJ(c[h>>2]|0,c[c[(c[g>>2]|0)+172+8>>2]>>2]&1);g=c[(c[(c[h>>2]|0)+8>>2]|0)+8>>2]|0;c[(c[(rC(c[h>>2]|0)|0)+8>>2]|0)+8>>2]=g;if(((c[j>>2]|0)!=0?(c[c[j>>2]>>2]|0)!=0:0)?(Bb[c[c[j>>2]>>2]&127](c[h>>2]|0),(c[(c[j>>2]|0)+4>>2]|0)!=0):0)c[(c[(c[h>>2]|0)+8>>2]|0)+148>>2]=c[(c[j>>2]|0)+4>>2];KH(0);c[f>>2]=0;m=c[f>>2]|0;i=d;return m|0}function gF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d;c[d+4>>2]=a;c[f>>2]=b;if(!(MC(c[f>>2]|0,175049,0,1)|0)){c[e>>2]=0;g=c[e>>2]|0;i=d;return g|0}if(c[(c[(c[f>>2]|0)+8>>2]|0)+148>>2]|0){Bb[c[(c[(c[f>>2]|0)+8>>2]|0)+148>>2]&127](c[f>>2]|0);c[(c[(c[f>>2]|0)+8>>2]|0)+148>>2]=0}if(c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]|0)MJ(c[f>>2]|0);c[e>>2]=0;g=c[e>>2]|0;i=d;return g|0}function hF(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;i=i+32|0;e=d+8|0;f=d;g=d+24|0;h=d+20|0;j=d+16|0;k=d+12|0;c[h>>2]=b;c[j>>2]=c[(c[h>>2]|0)+76>>2];c[k>>2]=c[c[h>>2]>>2];if((c[j>>2]|0)!=0?(c[c[j>>2]>>2]|0)!=0:0)Bb[c[c[j>>2]>>2]&127](c[h>>2]|0);else l=4;do if(((l|0)==4?(c[(c[h>>2]|0)+40>>2]|0)==0:0)?(c[(c[h>>2]|0)+36>>2]|0)==0:0){if(a[(c[k>>2]|0)+13>>0]|0)sF(c[h>>2]|0);if(!(c[(c[h>>2]|0)+32>>2]|0)){c[(c[h>>2]|0)+36>>2]=c[24744];break}j=X2(c[(c[h>>2]|0)+32>>2]|0,143129)|0;c[(c[h>>2]|0)+36>>2]=j;if(!(c[(c[h>>2]|0)+36>>2]|0)){j=c[(c[(c[h>>2]|0)+12>>2]|0)+16>>2]|0;b=c[(c[h>>2]|0)+32>>2]|0;m=M1(c[(L1()|0)>>2]|0)|0;c[f>>2]=b;c[f+4>>2]=m;Db[j&31](135744,f);c[g>>2]=1;n=c[g>>2]|0;i=d;return n|0}}while(0);if(c[(c[h>>2]|0)+152>>2]&1024){Db[c[(c[(c[h>>2]|0)+12>>2]|0)+16>>2]&31](135782,e);c[g>>2]=1;n=c[g>>2]|0;i=d;return n|0}else{c[g>>2]=0;n=c[g>>2]|0;i=d;return n|0}return 0}function iF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+8|0;g=e+28|0;h=e+24|0;j=e+20|0;k=e+16|0;l=e+12|0;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;if(!((c[k>>2]|0)!=0&(c[j>>2]|0)!=0)){c[g>>2]=0;m=c[g>>2]|0;i=e;return m|0}d=c[h>>2]|0;if(c[(c[h>>2]|0)+152>>2]&1024){Db[c[(c[d+12>>2]|0)+16>>2]&31](135782,e);wb(1)}c[l>>2]=tF(d,c[j>>2]|0,c[k>>2]|0)|0;if((c[l>>2]|0)!=(c[k>>2]|0)){l=c[(c[(c[h>>2]|0)+12>>2]|0)+16>>2]|0;c[f>>2]=c[k>>2];Db[l&31](135800,f);wb(1)}c[g>>2]=c[k>>2];m=c[g>>2]|0;i=e;return m|0}function jF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=N3(c[g>>2]|0)|0;b=iF(c[f>>2]|0,c[g>>2]|0,c[h>>2]|0)|0;if((b|0)!=(c[h>>2]|0)){c[e>>2]=-1;j=c[e>>2]|0;i=d;return j|0}else{c[e>>2]=1;j=c[e>>2]|0;i=d;return j|0}return 0}function kF(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;j=e+12|0;c[g>>2]=b;c[h>>2]=d;a[j>>0]=c[h>>2];if((iF(c[g>>2]|0,j,1)|0)!=1){c[f>>2]=-1;k=c[f>>2]|0;i=e;return k|0}else{c[f>>2]=c[h>>2];k=c[f>>2]|0;i=e;return k|0}return 0}function lF(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+4|0;f=d;c[f>>2]=b;if(((c[(c[f>>2]|0)+36>>2]|0)!=0?(a[(c[f>>2]|0)+144>>0]|0)==0:0)?(c[(c[c[f>>2]>>2]|0)+104>>2]|0)==0:0){c[e>>2]=T2(c[(c[f>>2]|0)+36>>2]|0)|0;g=c[e>>2]|0;i=d;return g|0}c[e>>2]=0;g=c[e>>2]|0;i=d;return g|0}function mF(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=c[(c[d>>2]|0)+76>>2];if((c[e>>2]|0)!=0?(c[(c[e>>2]|0)+4>>2]|0)!=0:0)Bb[c[(c[e>>2]|0)+4>>2]&127](c[d>>2]|0);lF(c[d>>2]|0)|0;i=b;return}function nF(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d+12|0;c[e>>2]=b;c[f>>2]=c[(c[e>>2]|0)+76>>2];a[g>>0]=0;if(c[(c[e>>2]|0)+152>>2]&1024){Db[c[(c[(c[e>>2]|0)+12>>2]|0)+16>>2]&31](135825,d);wb(1)}if((c[f>>2]|0)!=0?(c[(c[f>>2]|0)+8>>2]|0)!=0:0){Bb[c[(c[f>>2]|0)+8>>2]&127](c[e>>2]|0);a[g>>0]=1}if(a[g>>0]|0){i=d;return}lF(c[e>>2]|0)|0;uF(c[e>>2]|0);i=d;return}function oF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+1072|0;f=e;g=e+32|0;h=e+28|0;j=e+40|0;k=e+24|0;l=e+8|0;m=e+4|0;c[g>>2]=a;c[h>>2]=b;c[m>>2]=j;c[l>>2]=d;c[k>>2]=q3(j,1024,c[h>>2]|0,l)|0;if((c[k>>2]|0)>>>0<0){c[f>>2]=M1(c[(L1()|0)>>2]|0)|0;$z(1,135842,f)|0;i=e;return}if((c[k>>2]|0)>>>0>=1024){c[m>>2]=cK((c[k>>2]|0)+1|0)|0;c[l>>2]=d;c[k>>2]=r3(c[m>>2]|0,c[h>>2]|0,l)|0}iF(c[g>>2]|0,c[m>>2]|0,c[k>>2]|0)|0;if((c[m>>2]|0)==(j|0)){i=e;return}O4(c[m>>2]|0);i=e;return}function pF(a,b){a=a|0;b=+b;var d=0,e=0,f=0,g=0,j=0;d=i;i=i+32|0;e=d+16|0;f=d;g=d+12|0;j=d+8|0;c[e>>2]=a;h[f>>3]=b;c[g>>2]=vF(j,+h[f>>3])|0;iF(c[e>>2]|0,c[g>>2]|0,c[j>>2]|0)|0;i=d;return}function qF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[e>>2]=a;c[f>>2]=vF(g,+h[b>>3])|0;iF(c[e>>2]|0,c[f>>2]|0,c[g>>2]|0)|0;iF(c[e>>2]|0,140232,1)|0;c[f>>2]=vF(g,+h[b+8>>3])|0;iF(c[e>>2]|0,c[f>>2]|0,c[g>>2]|0)|0;i=d;return}function rF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e;g=e+28|0;h=e+24|0;j=e+20|0;k=e+16|0;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=0;while(1){d=c[g>>2]|0;b=(c[h>>2]|0)+(c[k>>2]<<4)|0;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];qF(d,f);d=(c[k>>2]|0)+1|0;c[k>>2]=d;if((d|0)>=(c[j>>2]|0))break;iF(c[g>>2]|0,140232,1)|0}i=e;return}function sF(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+128|0;e=d;f=d+20|0;g=d+24|0;h=d+16|0;j=d+12|0;k=d+8|0;l=d+4|0;c[f>>2]=b;if(c[(c[f>>2]|0)+24>>2]|0){c[e>>2]=(c[(c[f>>2]|0)+24>>2]|0)+1;k3(g,135923,e)|0}else a[g>>0]=0;e=c[(c[f>>2]|0)+20>>2]|0;c[h>>2]=e;c[h>>2]=(e|0)!=0?e:135927;e=N3(c[h>>2]|0)|0;b=e+(N3(g)|0)+1|0;c[l>>2]=b+(N3(c[(c[f>>2]|0)+52>>2]|0)|0)+1;if((c[13531]|0)>>>0<(c[l>>2]|0)>>>0){c[13531]=(c[l>>2]|0)+10;c[13532]=Q4(c[13532]|0,c[13531]|0)|0}K3(c[13532]|0,c[h>>2]|0)|0;G3(c[13532]|0,g)|0;G3(c[13532]|0,193388)|0;c[j>>2]=M3(c[(c[f>>2]|0)+52>>2]|0)|0;while(1){g=S3(c[j>>2]|0,58)|0;c[k>>2]=g;m=c[13532]|0;if(!g)break;G3(m,(c[k>>2]|0)+1|0)|0;G3(c[13532]|0,193388)|0;a[c[k>>2]>>0]=0}G3(m,c[j>>2]|0)|0;O4(c[j>>2]|0);c[(c[f>>2]|0)+32>>2]=c[13532];i=d;return}function tF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f;h=f+16|0;j=f+12|0;k=f+8|0;l=f+4|0;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;e=c[j>>2]|0;if(c[(c[c[j>>2]>>2]|0)+104>>2]|0){c[h>>2]=Hb[c[(c[e>>2]|0)+104>>2]&63](c[j>>2]|0,c[k>>2]|0,c[l>>2]|0)|0;m=c[h>>2]|0;i=f;return m|0}if(!(c[e+40>>2]|0)){c[h>>2]=h3(c[k>>2]|0,1,c[l>>2]|0,c[(c[j>>2]|0)+36>>2]|0)|0;m=c[h>>2]|0;i=f;return m|0}if((c[l>>2]|0)>>>0>((c[(c[j>>2]|0)+44>>2]|0)-((c[(c[j>>2]|0)+48>>2]|0)+1)|0)>>>0?(c[(c[j>>2]|0)+44>>2]=(c[(c[j>>2]|0)+48>>2]|0)+(c[l>>2]|0)+1+4095&-4096,e=Q4(c[(c[j>>2]|0)+40>>2]|0,c[(c[j>>2]|0)+44>>2]|0)|0,c[(c[j>>2]|0)+40>>2]=e,(c[(c[j>>2]|0)+40>>2]|0)==0):0){Db[c[(c[(c[j>>2]|0)+12>>2]|0)+16>>2]&31](135896,g);wb(1)}Z4((c[(c[j>>2]|0)+40>>2]|0)+(c[(c[j>>2]|0)+48>>2]|0)|0,c[k>>2]|0,c[l>>2]|0)|0;k=(c[j>>2]|0)+48|0;c[k>>2]=(c[k>>2]|0)+(c[l>>2]|0);a[(c[(c[j>>2]|0)+40>>2]|0)+(c[(c[j>>2]|0)+48>>2]|0)>>0]=0;c[h>>2]=c[l>>2];m=c[h>>2]|0;i=f;return m|0}function uF(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=b;if(!(c[(c[e>>2]|0)+32>>2]|0)){i=d;return}if((c[(c[e>>2]|0)+36>>2]|0)==(c[24744]|0)){i=d;return}if(a[(c[e>>2]|0)+144>>0]|0){i=d;return}if(c[(c[e>>2]|0)+36>>2]|0){R2(c[(c[e>>2]|0)+36>>2]|0)|0;c[(c[e>>2]|0)+36>>2]=0}c[(c[e>>2]|0)+32>>2]=0;i=d;return}function vF(b,e){b=b|0;e=+e;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+48|0;g=f+28|0;j=f+24|0;k=f;l=f+20|0;m=f+16|0;n=f+33|0;o=f+32|0;p=f+12|0;q=f+8|0;c[j>>2]=b;h[k>>3]=e;c[l>>2]=135876;if(+h[k>>3]<+h[4216]){c[c[j>>2]>>2]=19;c[g>>2]=135876;r=c[g>>2]|0;i=f;return r|0}if(+h[k>>3]>-+h[4216]){c[c[j>>2]>>2]=18;c[g>>2]=135877;r=c[g>>2]|0;i=f;return r|0}h[k>>3]=+h[k>>3]*100.0;e=+h[k>>3];if(+h[k>>3]<0.0)c[m>>2]=~~(e-.5);else c[m>>2]=~~(e+.5);if(!(c[m>>2]|0)){c[c[j>>2]>>2]=1;c[g>>2]=176099;r=c[g>>2]|0;i=f;return r|0}k=(c[m>>2]|0)<0&255;a[o>>0]=k;if(k<<24>>24)c[m>>2]=0-(c[m>>2]|0);a[n>>0]=0;c[q>>2]=2;while(1){if(!((c[m>>2]|0)!=0?1:(c[q>>2]|0)>0))break;c[p>>2]=(c[m>>2]|0)%10|0;c[m>>2]=(c[m>>2]|0)/10|0;if(!((c[p>>2]|0)==0?(d[n>>0]|0)==0:0)){k=(c[p>>2]|48)&255;b=(c[l>>2]|0)+-1|0;c[l>>2]=b;a[b>>0]=k;a[n>>0]=1}if((c[q>>2]|0)==1){if(a[n>>0]|0){k=(c[l>>2]|0)+-1|0;c[l>>2]=k;a[k>>0]=46}a[n>>0]=1}c[q>>2]=(c[q>>2]|0)+-1}if(a[o>>0]|0){o=(c[l>>2]|0)+-1|0;c[l>>2]=o;a[o>>0]=45}c[c[j>>2]>>2]=135876-(c[l>>2]|0);c[g>>2]=c[l>>2];r=c[g>>2]|0;i=f;return r|0}function wF(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;j=i;i=i+176|0;k=j+32|0;l=j+28|0;m=j+24|0;n=j+20|0;o=j+16|0;p=j+12|0;q=j+8|0;r=j+4|0;s=j;t=j+104|0;u=j+40|0;c[k>>2]=b;c[l>>2]=d;c[m>>2]=e;c[n>>2]=f;c[o>>2]=g;c[p>>2]=h;Q3(t,c[m>>2]|0,63)|0;h=H3(t,58)|0;c[s>>2]=h;if(h)a[c[s>>2]>>0]=0;c[r>>2]=(c[k>>2]|0)+60+(c[l>>2]<<2);while(1){if(!(c[c[r>>2]>>2]|0))break;Q3(u,c[(c[c[r>>2]>>2]|0)+4>>2]|0,63)|0;l=H3(u,58)|0;c[s>>2]=l;if(l)a[c[s>>2]>>0]=0;if((J3(t,u)|0)<=0)break;c[r>>2]=c[c[r>>2]>>2]}while(1){if(!(c[c[r>>2]>>2]|0))break;Q3(u,c[(c[c[r>>2]>>2]|0)+4>>2]|0,63)|0;l=H3(u,58)|0;c[s>>2]=l;if(l)a[c[s>>2]>>0]=0;if(J3(t,u)|0)break;if((c[n>>2]|0)>=(c[(c[c[r>>2]>>2]|0)+8>>2]|0))break;c[r>>2]=c[c[r>>2]>>2]}c[q>>2]=cK(20)|0;c[c[q>>2]>>2]=c[c[r>>2]>>2];c[c[r>>2]>>2]=c[q>>2];c[(c[q>>2]|0)+4>>2]=c[m>>2];c[(c[q>>2]|0)+8>>2]=c[n>>2];c[(c[q>>2]|0)+12>>2]=c[o>>2];c[(c[q>>2]|0)+16>>2]=c[p>>2];i=j;return 1}function xF(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+16|0;c[d+8>>2]=a;c[d+4>>2]=b;$z(1,135937,d)|0;i=d;return 0}function yF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;f=i;i=i+208|0;g=f+8|0;h=f;j=f+68|0;k=f+64|0;l=f+60|0;m=f+56|0;n=f+52|0;o=f+48|0;p=f+44|0;q=f+40|0;r=f+136|0;s=f+72|0;t=f+36|0;u=f+32|0;v=f+28|0;w=f+24|0;x=f+20|0;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[u>>2]=0;if((c[k>>2]|0)==3|(c[k>>2]|0)==4)c[x>>2]=0;else c[x>>2]=c[k>>2];Q3(r,c[l>>2]|0,63)|0;c[t>>2]=H3(r,58)|0;if(c[t>>2]|0){l=c[t>>2]|0;c[t>>2]=l+1;a[l>>0]=0;c[v>>2]=H3(c[t>>2]|0,58)|0;if(c[v>>2]|0){l=c[v>>2]|0;c[v>>2]=l+1;a[l>>0]=0}}else c[v>>2]=0;c[m>>2]=(c[j>>2]|0)+60+(c[k>>2]<<2);a:while(1){if(!(c[c[m>>2]>>2]|0))break;Q3(s,c[(c[c[m>>2]>>2]|0)+4>>2]|0,63)|0;c[u>>2]=H3(s,58)|0;if(c[u>>2]|0){l=c[u>>2]|0;c[u>>2]=l+1;a[l>>0]=0}do if(!(J3(s,r)|0)){if((c[u>>2]|0)!=0&(c[t>>2]|0)!=0?(J3(c[u>>2]|0,c[t>>2]|0)|0)!=0:0)break;if((c[v>>2]|0)!=0?(J3(c[v>>2]|0,c[(c[(c[c[m>>2]>>2]|0)+12>>2]|0)+8>>2]|0)|0)!=0:0)break;if(!(c[u>>2]|0))break a;if((c[x>>2]|0)==(c[k>>2]|0))break a;if(yF(c[j>>2]|0,c[x>>2]|0,c[u>>2]|0)|0)break a}while(0);c[m>>2]=c[c[m>>2]>>2]}c[n>>2]=c[c[m>>2]>>2];if(((c[n>>2]|0)!=0?(c[(c[n>>2]|0)+16>>2]|0)==0:0)?(c[o>>2]=xF(c[j>>2]|0,c[(c[(c[n>>2]|0)+12>>2]|0)+4>>2]|0)|0,(c[o>>2]|0)!=0):0){c[p>>2]=c[(c[o>>2]|0)+4>>2];while(1){m=c[(c[p>>2]|0)+4>>2]|0;c[q>>2]=m;if(!m)break;c[w>>2]=0;while(1){if(!(c[(c[q>>2]|0)+((c[w>>2]|0)*20|0)+4>>2]|0))break;AF(c[j>>2]|0,c[c[p>>2]>>2]|0,c[(c[q>>2]|0)+((c[w>>2]|0)*20|0)+4>>2]|0,c[c[o>>2]>>2]|0,c[(c[(c[n>>2]|0)+12>>2]|0)+4>>2]|0,(c[q>>2]|0)+((c[w>>2]|0)*20|0)|0)|0;c[w>>2]=(c[w>>2]|0)+1}c[p>>2]=(c[p>>2]|0)+8}if((c[(c[j>>2]|0)+8>>2]|0)>=1){p=c[24742]|0;if(c[(c[(c[n>>2]|0)+12>>2]|0)+4>>2]|0)y=c[(c[(c[n>>2]|0)+12>>2]|0)+4>>2]|0;else y=135968;c[h>>2]=y;Y2(p,135978,h)|0}}if((c[n>>2]|0)!=0?(c[(c[n>>2]|0)+16>>2]|0)==0:0)c[n>>2]=0;if(!(c[n>>2]|0)){z=c[n>>2]|0;A=c[k>>2]|0;B=c[j>>2]|0;C=B+80|0;D=C+(A<<2)|0;c[D>>2]=z;E=c[n>>2]|0;i=f;return E|0}if((c[(c[j>>2]|0)+8>>2]|0)<1){z=c[n>>2]|0;A=c[k>>2]|0;B=c[j>>2]|0;C=B+80|0;D=C+(A<<2)|0;c[D>>2]=z;E=c[n>>2]|0;i=f;return E|0}h=c[24742]|0;p=c[(c[n>>2]|0)+4>>2]|0;y=c[(c[(c[n>>2]|0)+12>>2]|0)+8>>2]|0;c[g>>2]=c[54132+(c[k>>2]<<2)>>2];c[g+4>>2]=p;c[g+8>>2]=y;Y2(h,136008,g)|0;z=c[n>>2]|0;A=c[k>>2]|0;B=c[j>>2]|0;C=B+80|0;D=C+(A<<2)|0;c[D>>2]=z;E=c[n>>2]|0;i=f;return E|0}function zF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;f=i;i=i+48|0;g=f+40|0;h=f+36|0;j=f+32|0;k=f+28|0;l=f+24|0;m=f+20|0;n=f+16|0;o=f+12|0;p=f+8|0;q=f+4|0;r=f;s=f+44|0;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;a[s>>0]=1;if(!(c[k>>2]|0)){c[g>>2]=0;t=c[g>>2]|0;i=f;return t|0}if(c[13538]|0){dA(54156,0,0);c[13538]=0}c[o>>2]=M3(c[k>>2]|0)|0;c[p>>2]=H3(c[o>>2]|0,58)|0;if(c[p>>2]|0){k=c[p>>2]|0;c[p>>2]=k+1;a[k>>0]=0}c[m>>2]=(c[h>>2]|0)+60+(c[j>>2]<<2);a:do if(c[p>>2]|0){c[l>>2]=c[m>>2];while(1){if(!(c[c[l>>2]>>2]|0))break a;c[q>>2]=M3(c[(c[c[l>>2]>>2]|0)+4>>2]|0)|0;j=H3(c[q>>2]|0,58)|0;c[p>>2]=j;if(j){j=c[p>>2]|0;c[p>>2]=j+1;a[j>>0]=0}if(!((a[c[o>>2]>>0]|0)!=0?(F3(c[o>>2]|0,c[q>>2]|0)|0)!=0:0)){if((c[13540]|0)>>>0>=(c[13541]|0)>>>0)eA(54156,1)|0;j=c[13540]|0;c[13540]=j+1;a[j>>0]=32;gA(54156,c[(c[c[l>>2]>>2]|0)+4>>2]|0)|0;if((c[13540]|0)>>>0>=(c[13541]|0)>>>0)eA(54156,1)|0;j=c[13540]|0;c[13540]=j+1;a[j>>0]=58;gA(54156,c[(c[(c[c[l>>2]>>2]|0)+12>>2]|0)+8>>2]|0)|0;a[s>>0]=0}O4(c[q>>2]|0);c[l>>2]=c[c[l>>2]>>2]}}while(0);O4(c[o>>2]|0);if(a[s>>0]|0){c[r>>2]=0;c[l>>2]=c[m>>2];while(1){if(!(c[c[l>>2]>>2]|0))break;c[q>>2]=M3(c[(c[c[l>>2]>>2]|0)+4>>2]|0)|0;m=H3(c[q>>2]|0,58)|0;c[p>>2]=m;if(m){m=c[p>>2]|0;c[p>>2]=m+1;a[m>>0]=0}if(!((c[r>>2]|0)!=0?(F3(c[r>>2]|0,c[q>>2]|0)|0)==0:0)){if((c[13540]|0)>>>0>=(c[13541]|0)>>>0)eA(54156,1)|0;m=c[13540]|0;c[13540]=m+1;a[m>>0]=32;gA(54156,c[q>>2]|0)|0;a[s>>0]=0}if(!(c[r>>2]|0))O4(c[r>>2]|0);c[r>>2]=c[q>>2];c[l>>2]=c[c[l>>2]>>2]}if(!(c[r>>2]|0))O4(c[r>>2]|0)}if(a[s>>0]|0)c[n>>2]=178518;else{if((c[13540]|0)>>>0>=(c[13541]|0)>>>0)eA(54156,1)|0;s=c[13540]|0;c[13540]=s+1;a[s>>0]=0;s=c[13539]|0;c[13540]=s;c[n>>2]=s}c[g>>2]=c[n>>2];t=c[g>>2]|0;i=f;return t|0}function AF(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;i=i+32|0;k=j+28|0;l=j+24|0;m=j+20|0;n=j+16|0;o=j+12|0;p=j+8|0;q=j+4|0;r=j;c[l>>2]=b;c[m>>2]=d;c[n>>2]=e;c[o>>2]=f;c[p>>2]=g;c[q>>2]=h;c[r>>2]=(c[l>>2]|0)+60+(c[m>>2]<<2);while(1){if(!(c[c[r>>2]>>2]|0)){s=9;break}if((((F3(c[n>>2]|0,c[(c[c[r>>2]>>2]|0)+4>>2]|0)|0)==0?(F3(c[o>>2]|0,c[(c[(c[c[r>>2]>>2]|0)+12>>2]|0)+8>>2]|0)|0)==0:0)?(c[(c[(c[c[r>>2]>>2]|0)+12>>2]|0)+4>>2]|0)!=0:0)?(F3(c[p>>2]|0,c[(c[(c[c[r>>2]>>2]|0)+12>>2]|0)+4>>2]|0)|0)==0:0){s=7;break}c[r>>2]=c[c[r>>2]>>2]}if((s|0)==7){c[(c[c[r>>2]>>2]|0)+16>>2]=c[q>>2];a[k>>0]=1;t=a[k>>0]|0;i=j;return t|0}else if((s|0)==9){a[k>>0]=0;t=a[k>>0]|0;i=j;return t|0}return 0}function BF(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[f>>2]=b;if(!(c[f>>2]|0))La(148770,136056,577,136070);if(!(a[c[f>>2]>>0]|0))La(148775,136056,578,136070);if(c[13543]|0){c[g>>2]=Hb[c[c[13543]>>2]&63](c[13543]|0,c[f>>2]|0,512)|0;c[e>>2]=c[g>>2];h=c[e>>2]|0;i=d;return h|0}else{c[e>>2]=0;h=c[e>>2]|0;i=d;return h|0}return 0}function CF(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+32|0;e=d+8|0;f=d;g=d+24|0;h=d+20|0;j=d+16|0;c[h>>2]=b;if(!(c[h>>2]|0))La(148874,136056,593,136087);if(!(c[(c[h>>2]|0)+8>>2]|0))La(148877,136056,594,136087);if(!(a[c[(c[h>>2]|0)+8>>2]>>0]|0))La(148886,136056,595,136087);b=c[h>>2]|0;do if(!(c[(c[h>>2]|0)+20>>2]|0)){k=sO(c[b+8>>2]|0)|0;c[j>>2]=k;if(!k){c[f>>2]=c[(c[h>>2]|0)+8>>2];$z(0,136111,f)|0;a[g>>0]=0;l=a[g>>0]|0;i=d;return l|0}k=X2(c[j>>2]|0,176526)|0;c[(c[h>>2]|0)+20>>2]=k;if(!(c[(c[h>>2]|0)+20>>2]|0)){k=M1(c[(L1()|0)>>2]|0)|0;m=c[j>>2]|0;c[e>>2]=k;c[e+4>>2]=m;$z(0,136136,e)|0;a[g>>0]=0;l=a[g>>0]|0;i=d;return l|0}if((c[13544]|0)>=50){a[(c[h>>2]|0)+17>>0]=1;break}else{c[13544]=(c[13544]|0)+1;break}}else c3(c[b+20>>2]|0,0,0)|0;while(0);if(!(c[(c[h>>2]|0)+20>>2]|0))La(136157,136056,618,136087);a[g>>0]=1;l=a[g>>0]|0;i=d;return l|0}function DF(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=b;if(!(a[(c[e>>2]|0)+17>>0]|0)){i=d;return}if(!(c[(c[e>>2]|0)+20>>2]|0)){i=d;return}R2(c[(c[e>>2]|0)+20>>2]|0)|0;c[(c[e>>2]|0)+20>>2]=0;i=d;return}function EF(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0.0;e=i;i=i+16|0;f=e+8|0;g=e;c[f>>2]=b;if(!(c[f>>2]|0)){c[g+4>>2]=-1;c[g>>2]=-1;c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];i=e;return}if(c[(c[f>>2]|0)+48>>2]|0){j=+(c[(c[f>>2]|0)+48>>2]|0);h[d+8>>3]=j;h[d>>3]=j}c[g>>2]=~~(+((c[(c[f>>2]|0)+40>>2]|0)*72|0)/+h[d>>3]);c[g+4>>2]=~~(+((c[(c[f>>2]|0)+44>>2]|0)*72|0)/+h[d+8>>3]);c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];i=e;return}function FF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0;f=i;i=i+64|0;g=f+16|0;j=f+60|0;k=f+56|0;l=f+48|0;m=f;n=f+40|0;o=f+32|0;c[j>>2]=d;c[k>>2]=e;if((c[k>>2]|0)!=0?(a[c[k>>2]>>0]|0)!=0:0){if(((c[13794]|0)==0?(c[13545]|0)!=(c[13793]|0):0)?(c[13545]=c[13793],(c[13543]|0)!=0):0){Jz(c[13543]|0)|0;c[13543]=0}p=+h[(c[(c[(c[j>>2]|0)+8>>2]|0)+8>>2]|0)+24>>3];h[m+8>>3]=p;j=m+8|0;if(p>=1.0)h[m>>3]=+h[j>>3];else{h[j>>3]=96.0;h[m>>3]=96.0}c[n>>2]=GF(c[k>>2]|0)|0;k=c[n>>2]|0;c[g>>2]=c[m>>2];c[g+4>>2]=c[m+4>>2];c[g+8>>2]=c[m+8>>2];c[g+12>>2]=c[m+12>>2];EF(o,k,g);c[l>>2]=c[o>>2];c[l+4>>2]=c[o+4>>2];c[b>>2]=c[l>>2];c[b+4>>2]=c[l+4>>2];i=f;return}c[l+4>>2]=-1;c[l>>2]=-1;c[b>>2]=c[l>>2];c[b+4>>2]=c[l+4>>2];i=f;return}function GF(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b;e=b+12|0;f=b+8|0;g=b+4|0;c[f>>2]=a;if(!(c[f>>2]|0))La(148770,136056,636,136163);if(!(c[13543]|0))c[13543]=Nz(54184,c[12993]|0)|0;a=BF(c[f>>2]|0)|0;c[g>>2]=a;if(a){DF(c[g>>2]|0);c[e>>2]=c[g>>2];h=c[e>>2]|0;i=b;return h|0}a=bK(64)|0;c[g>>2]=a;if(!a){c[e>>2]=0;h=c[e>>2]|0;i=b;return h|0}a=YC(0,c[f>>2]|0)|0;c[(c[g>>2]|0)+8>>2]=a;if(!((CF(c[g>>2]|0)|0)<<24>>24)){c[e>>2]=0;h=c[e>>2]|0;i=b;return h|0}if(!(c[(c[g>>2]|0)+20>>2]|0))La(136157,136056,649,136163);do switch(HF(c[g>>2]|0)|0){case 0:{a=fM(c[(c[g>>2]|0)+8>>2]|0)|0;c[(c[g>>2]|0)+52>>2]=a;if(!a){c[d>>2]=c[(c[g>>2]|0)+8>>2];$z(0,136180,d)|0}O4(c[g>>2]|0);c[e>>2]=0;h=c[e>>2]|0;i=b;return h|0}case 2:{IF(c[g>>2]|0);break}case 3:{JF(c[g>>2]|0);break}case 1:{KF(c[g>>2]|0);break}case 4:{LF(c[g>>2]|0);break}case 6:{MF(c[g>>2]|0);break}case 11:{NF(c[g>>2]|0);break}case 8:{OF(c[g>>2]|0);break}case 5:{PF(c[g>>2]|0);break}case 12:{QF(c[g>>2]|0);break}default:{}}while(0);DF(c[g>>2]|0);Hb[c[c[13543]>>2]&63](c[13543]|0,c[g>>2]|0,1)|0;c[e>>2]=c[g>>2];h=c[e>>2]|0;i=b;return h|0}function HF(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;b=i;i=i+240|0;d=b+8|0;e=b+4|0;f=b+216|0;g=b+16|0;h=b;c[e>>2]=a;a:do if((c[(c[e>>2]|0)+20>>2]|0)!=0?($2(f,1,20,c[(c[e>>2]|0)+20>>2]|0)|0)==20:0){c[h>>2]=0;while(1){if((c[h>>2]|0)>>>0>=10)break a;a=(B3(f,c[54260+(c[h>>2]<<4)>>2]|0,c[54260+(c[h>>2]<<4)+4>>2]|0)|0)!=0;j=c[h>>2]|0;if(!a)break;c[h>>2]=j+1}c[(c[e>>2]|0)+28>>2]=c[54260+(j<<4)+12>>2];c[(c[e>>2]|0)+24>>2]=c[54260+(c[h>>2]<<4)+8>>2];b:do if((c[(c[e>>2]|0)+24>>2]|0)!=9){if((c[(c[e>>2]|0)+24>>2]|0)==10?(B3(f+8|0,136396,4)|0)==0:0){c[(c[e>>2]|0)+28>>2]=136401;c[(c[e>>2]|0)+24>>2]=11;c[d>>2]=11;k=c[d>>2]|0;i=b;return k|0}}else{do if(!(V2(g,200,c[(c[e>>2]|0)+20>>2]|0)|0))break b;while((B3(g,136391,4)|0)!=0);c[(c[e>>2]|0)+28>>2]=139648;c[(c[e>>2]|0)+24>>2]=8;c[d>>2]=8;k=c[d>>2]|0;i=b;return k|0}while(0);c[d>>2]=c[(c[e>>2]|0)+24>>2];k=c[d>>2]|0;i=b;return k|0}while(0);c[(c[e>>2]|0)+28>>2]=136406;c[(c[e>>2]|0)+24>>2]=0;c[d>>2]=0;k=c[d>>2]|0;i=b;return k|0}function IF(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;c3(c[(c[d>>2]|0)+20>>2]|0,6,0)|0;if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,e)|0)&255)){i=b;return}if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,f)|0)&255)){i=b;return}c[(c[d>>2]|0)+40>>2]=c[e>>2];c[(c[d>>2]|0)+44>>2]=c[f>>2];i=b;return}function JF(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;c3(c[(c[d>>2]|0)+20>>2]|0,16,0)|0;if(!((RF(c[(c[d>>2]|0)+20>>2]|0,4,e)|0)&255)){i=b;return}if(!((RF(c[(c[d>>2]|0)+20>>2]|0,4,f)|0)&255)){i=b;return}c[(c[d>>2]|0)+40>>2]=c[e>>2];c[(c[d>>2]|0)+44>>2]=c[f>>2];i=b;return}function KF(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+32|0;d=b+16|0;e=b+12|0;f=b+8|0;g=b+4|0;h=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;c3(c[(c[d>>2]|0)+20>>2]|0,16,0)|0;if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,e)|0)&255)){i=b;return}if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,f)|0)&255)){i=b;return}if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,g)|0)&255)){i=b;return}if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,h)|0)&255)){i=b;return}c[(c[d>>2]|0)+40>>2]=c[e>>2]<<16|c[f>>2];c[(c[d>>2]|0)+44>>2]=c[g>>2]<<16|c[h>>2];i=b;return}function LF(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+32|0;d=b+20|0;e=b+16|0;f=b+12|0;g=b+8|0;h=b+4|0;j=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;while(1){if(!((RF(c[(c[d>>2]|0)+20>>2]|0,1,e)|0)<<24>>24)){k=17;break}if((c[e>>2]|0)==255)continue;if(H3(136379,c[e>>2]|0)|0)continue;if((c[e>>2]|0)==192){k=6;break}l=c[(c[d>>2]|0)+20>>2]|0;if((c[e>>2]|0)==194){k=11;break}if(!((RF(l,2,f)|0)<<24>>24)){k=17;break}c3(c[(c[d>>2]|0)+20>>2]|0,(c[f>>2]|0)-2|0,1)|0}if((k|0)==6){if(!((RF(c[(c[d>>2]|0)+20>>2]|0,3,j)|0)&255)){i=b;return}if(!((RF(c[(c[d>>2]|0)+20>>2]|0,2,g)|0)&255)){i=b;return}if(!((RF(c[(c[d>>2]|0)+20>>2]|0,2,h)|0)&255)){i=b;return}c[(c[d>>2]|0)+44>>2]=c[g>>2];c[(c[d>>2]|0)+40>>2]=c[h>>2];i=b;return}else if((k|0)==11){if(!((RF(l,3,j)|0)<<24>>24)){i=b;return}if(!((RF(c[(c[d>>2]|0)+20>>2]|0,2,g)|0)&255)){i=b;return}if(!((RF(c[(c[d>>2]|0)+20>>2]|0,2,h)|0)&255)){i=b;return}c[(c[d>>2]|0)+44>>2]=c[g>>2];c[(c[d>>2]|0)+40>>2]=c[h>>2];i=b;return}else if((k|0)==17){i=b;return}}function MF(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;i=i+1072|0;e=d;f=d+36|0;g=d+48|0;h=d+40|0;j=d+32|0;k=d+28|0;l=d+24|0;m=d+20|0;n=d+16|0;c[f>>2]=b;c[(c[f>>2]|0)+48>>2]=72;c3(c[(c[f>>2]|0)+20>>2]|0,0,0)|0;a[h>>0]=0;while(1){if(!(V2(g,1024,c[(c[f>>2]|0)+20>>2]|0)|0))break;b=U3(g,136364)|0;c[n>>2]=b;if(!b)continue;b=c[n>>2]|0;c[e>>2]=j;c[e+4>>2]=k;c[e+8>>2]=l;c[e+12>>2]=m;if((l3(b,142173,e)|0)==4){o=5;break}}if((o|0)==5)a[h>>0]=1;if(!(a[h>>0]|0)){i=d;return}c[(c[f>>2]|0)+32>>2]=c[j>>2];c[(c[f>>2]|0)+36>>2]=c[k>>2];c[(c[f>>2]|0)+40>>2]=(c[l>>2]|0)-(c[j>>2]|0);c[(c[f>>2]|0)+44>>2]=(c[m>>2]|0)-(c[k>>2]|0);i=d;return}function NF(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;c3(c[(c[d>>2]|0)+20>>2]|0,15,0)|0;a=(U2(c[(c[d>>2]|0)+20>>2]|0)|0)==88;g=c[(c[d>>2]|0)+20>>2]|0;if(a){c3(g,24,0)|0;if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,4,e)|0)&255)){i=b;return}if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,4,f)|0)&255)){i=b;return}c[(c[d>>2]|0)+40>>2]=c[e>>2];c[(c[d>>2]|0)+44>>2]=c[f>>2];i=b;return}else{c3(g,26,0)|0;if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,e)|0)&255)){i=b;return}if(!((ZF(c[(c[d>>2]|0)+20>>2]|0,2,f)|0)&255)){i=b;return}c[(c[d>>2]|0)+40>>2]=c[e>>2];c[(c[d>>2]|0)+44>>2]=c[f>>2];i=b;return}}function OF(b){b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;d=i;i=i+384|0;e=d+80|0;f=d+72|0;g=d+64|0;j=d+56|0;k=d+48|0;l=d+40|0;m=d+148|0;n=d+144|0;o=d+140|0;p=d+32|0;q=d+24|0;r=d+16|0;s=d+8|0;t=d;u=d+360|0;v=d+136|0;w=d+132|0;x=d+128|0;y=d+160|0;z=d+153|0;A=d+152|0;B=d+96|0;c[m>>2]=b;c[n>>2]=0;c[o>>2]=0;a[z>>0]=0;a[A>>0]=0;if(!(c[13555]|0)){if(w2(54228,c[13556]|0,1)|0){c[l>>2]=c[13556];$z(1,136249,l)|0}c[13555]=54228}c3(c[(c[m>>2]|0)+20>>2]|0,0,0)|0;a:while(1){if(!(V2(y,200,c[(c[m>>2]|0)+20>>2]|0)|0)){C=26;break}if((a[z>>0]|0)!=0?!((a[A>>0]|0)!=0^1):0){C=26;break}c[x>>2]=y;while(1){if(y2(54228,c[x>>2]|0,4,B,0)|0)continue a;a[(c[x>>2]|0)+(c[B+8+4>>2]|0)>>0]=0;a[(c[x>>2]|0)+(c[B+16+4>>2]|0)>>0]=0;c[v>>2]=(c[x>>2]|0)+(c[B+8>>2]|0);c[w>>2]=(c[x>>2]|0)+(c[B+16>>2]|0);c[x>>2]=(c[x>>2]|0)+((c[B+4>>2]|0)+1);if(!(J3(c[v>>2]|0,179125)|0)){l=c[w>>2]|0;c[k>>2]=p;c[k+4>>2]=u;if((l3(l,136286,k)|0)!=2){l=c[w>>2]|0;c[j>>2]=p;if((l3(l,139001,j)|0)==1){c[n>>2]=YF(+h[p>>3],136293)|0;a[z>>0]=1}}else{c[n>>2]=YF(+h[p>>3],u)|0;a[z>>0]=1}if(a[A>>0]|0)continue a;else continue}if(J3(c[v>>2]|0,179057)|0){if(J3(c[v>>2]|0,136296)|0)continue;l=c[w>>2]|0;c[e>>2]=q;c[e+4>>2]=r;c[e+8>>2]=s;c[e+12>>2]=t;if((l3(l,136304,e)|0)==4)break;else continue}l=c[w>>2]|0;c[g>>2]=p;c[g+4>>2]=u;if((l3(l,136286,g)|0)!=2){l=c[w>>2]|0;c[f>>2]=p;if((l3(l,139001,f)|0)==1){c[o>>2]=YF(+h[p>>3],136293)|0;a[A>>0]=1}}else{c[o>>2]=YF(+h[p>>3],u)|0;a[A>>0]=1}if(a[z>>0]|0)continue a}c[n>>2]=~~(+h[s>>3]-+h[q>>3]+1.0)>>>0;c[o>>2]=~~(+h[t>>3]-+h[r>>3]+1.0)>>>0;a[z>>0]=1;a[A>>0]=1}if((C|0)==26){c[(c[m>>2]|0)+48>>2]=0;c[(c[m>>2]|0)+40>>2]=c[n>>2];c[(c[m>>2]|0)+44>>2]=c[o>>2];i=d;return}}function PF(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+48|0;d=b+32|0;e=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;c3(c[(c[d>>2]|0)+20>>2]|0,0,0)|0;if(SF(c[(c[d>>2]|0)+20>>2]|0,e)|0){i=b;return}c[(c[d>>2]|0)+32>>2]=~~+h[e>>3];c[(c[d>>2]|0)+36>>2]=~~+h[e+8>>3];c[(c[d>>2]|0)+40>>2]=~~(+h[e+16>>3]-+h[e>>3]);c[(c[d>>2]|0)+44>>2]=~~(+h[e+16+8>>3]-+h[e+8>>3]);i=b;return}function QF(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[(c[d>>2]|0)+48>>2]=0;c3(c[(c[d>>2]|0)+20>>2]|0,6,0)|0;if(!((RF(c[(c[d>>2]|0)+20>>2]|0,1,e)|0)&255)){i=b;return}if(!((RF(c[(c[d>>2]|0)+20>>2]|0,1,f)|0)&255)){i=b;return}c[(c[d>>2]|0)+40>>2]=c[e>>2];c[(c[d>>2]|0)+44>>2]=c[f>>2];i=b;return}function RF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+12|0;k=f+8|0;l=f+4|0;m=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[c[k>>2]>>2]=0;c[m>>2]=0;while(1){if((c[m>>2]|0)>>>0>=(c[j>>2]|0)>>>0){n=6;break}c[l>>2]=U2(c[h>>2]|0)|0;if(S2(c[h>>2]|0)|0){n=4;break}e=c[k>>2]|0;c[e>>2]=c[e>>2]<<8;e=c[k>>2]|0;c[e>>2]=c[e>>2]|c[l>>2];c[m>>2]=(c[m>>2]|0)+1}if((n|0)==4){a[g>>0]=0;o=a[g>>0]|0;i=f;return o|0}else if((n|0)==6){a[g>>0]=1;o=a[g>>0]|0;i=f;return o|0}return 0}function SF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+1056|0;e=d+24|0;f=d+20|0;g=d+16|0;h=d+4|0;j=d;k=d+32|0;c[f>>2]=a;c[g>>2]=b;while(1){if(!(V2(k,1024,c[f>>2]|0)|0)){l=5;break}b=U3(k,136239)|0;c[j>>2]=b;if(b){l=4;break}}if((l|0)==4){c[h+4>>2]=k;c[h>>2]=(c[j>>2]|0)+9;c[h+8>>2]=c[f>>2];c[e>>2]=TF(h,c[g>>2]|0)|0;m=c[e>>2]|0;i=d;return m|0}else if((l|0)==5){c[e>>2]=1;m=c[e>>2]|0;i=d;return m|0}return 0}function TF(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+1040|0;f=e+8|0;g=e+4|0;h=e;j=e+16|0;c[g>>2]=b;c[h>>2]=d;UF(c[g>>2]|0);d=c[g>>2]|0;if(a[c[c[g>>2]>>2]>>0]|0)k=a[c[d>>2]>>0]|0;else k=(VF(d)|0)&255;do if((k|0)==91){d=c[g>>2]|0;c[d>>2]=(c[d>>2]|0)+1;WF(c[g>>2]|0,j);if(XF(j,c[h>>2]|0)|0){c[f>>2]=1;break}WF(c[g>>2]|0,j);if(XF(j,(c[h>>2]|0)+8|0)|0){c[f>>2]=1;break}WF(c[g>>2]|0,j);if(XF(j,(c[h>>2]|0)+16|0)|0){c[f>>2]=1;break}WF(c[g>>2]|0,j);if(XF(j,(c[h>>2]|0)+16+8|0)|0){c[f>>2]=1;break}else{c[f>>2]=0;break}}else c[f>>2]=1;while(0);i=e;return c[f>>2]|0}function UF(b){b=b|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e;g=e+4|0;c[f>>2]=b;while(1){b=c[f>>2]|0;if(a[c[c[f>>2]>>2]>>0]|0)h=a[c[b>>2]>>0]|0;else h=(VF(b)|0)&255;b=h&255;a[g>>0]=b;if(!(b<<24>>24)){j=8;break}if(!(r1(d[g>>0]|0)|0)){j=8;break}b=c[f>>2]|0;c[b>>2]=(c[b>>2]|0)+1}if((j|0)==8){i=e;return}}function VF(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+4|0;f=d;c[f>>2]=b;if(V2(c[(c[f>>2]|0)+4>>2]|0,1024,c[(c[f>>2]|0)+8>>2]|0)|0){c[c[f>>2]>>2]=c[(c[f>>2]|0)+4>>2];a[e>>0]=a[c[c[f>>2]>>2]>>0]|0;g=a[e>>0]|0;i=d;return g|0}else{a[e>>0]=0;g=a[e>>0]|0;i=d;return g|0}return 0}function WF(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;j=e+12|0;c[f>>2]=b;c[g>>2]=d;c[h>>2]=0;UF(c[f>>2]|0);do{d=c[f>>2]|0;if(a[c[c[f>>2]>>2]>>0]|0)k=a[c[d>>2]>>0]|0;else k=(VF(d)|0)&255;d=k&255;a[j>>0]=d;if(!(d<<24>>24))break;if((p1(a[j>>0]|0)|0)==0?(a[j>>0]|0)!=46:0)break;d=a[j>>0]|0;b=c[h>>2]|0;c[h>>2]=b+1;a[(c[g>>2]|0)+b>>0]=d;d=c[f>>2]|0;c[d>>2]=(c[d>>2]|0)+1}while((c[h>>2]|0)!=1023);a[(c[g>>2]|0)+(c[h>>2]|0)>>0]=0;i=e;return}function XF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0;d=i;i=i+32|0;e=d+20|0;f=d+16|0;g=d+12|0;j=d+8|0;k=d;c[f>>2]=a;c[g>>2]=b;h[k>>3]=+x3(c[f>>2]|0,j);if((c[f>>2]|0)==(c[j>>2]|0)){c[e>>2]=1;l=c[e>>2]|0;i=d;return l|0}else{h[c[g>>2]>>3]=+h[k>>3];c[e>>2]=0;l=c[e>>2]|0;i=d;return l|0}return 0}function YF(a,b){a=+a;b=b|0;var d=0,e=0,f=0,g=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d;g=d+8|0;h[f>>3]=a;c[g>>2]=b;if(!(J3(c[g>>2]|0,136320)|0)){a=+h[f>>3]*72.0;c[e>>2]=~~(+h[f>>3]*72.0>=0.0?a+.5:a-.5);j=c[e>>2]|0;i=d;return j|0}if(!(J3(c[g>>2]|0,136323)|0)){a=+h[f>>3]*72.0/96.0;c[e>>2]=~~(+h[f>>3]*72.0/96.0>=0.0?a+.5:a-.5);j=c[e>>2]|0;i=d;return j|0}if(!(J3(c[g>>2]|0,136326)|0)){a=+h[f>>3]*72.0/6.0;c[e>>2]=~~(+h[f>>3]*72.0/6.0>=0.0?a+.5:a-.5);j=c[e>>2]|0;i=d;return j|0}if((J3(c[g>>2]|0,136293)|0)!=0?(J3(c[g>>2]|0,136329)|0)!=0:0){if(!(J3(c[g>>2]|0,136331)|0)){a=+h[f>>3]*28.346456664;c[e>>2]=~~(+h[f>>3]*28.346456664>=0.0?a+.5:a-.5);j=c[e>>2]|0;i=d;return j|0}if(!(J3(c[g>>2]|0,136334)|0)){a=+h[f>>3]*2.8346456663999997;c[e>>2]=~~(+h[f>>3]*2.8346456663999997>=0.0?a+.5:a-.5);j=c[e>>2]|0;i=d;return j|0}else{c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}}a=+h[f>>3];c[e>>2]=~~(+h[f>>3]>=0.0?a+.5:a-.5);j=c[e>>2]|0;i=d;return j|0}function ZF(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+12|0;k=f+8|0;l=f+4|0;m=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[c[k>>2]>>2]=0;c[m>>2]=0;while(1){if((c[m>>2]|0)>>>0>=(c[j>>2]|0)>>>0){n=6;break}c[l>>2]=U2(c[h>>2]|0)|0;if(S2(c[h>>2]|0)|0){n=4;break}e=c[k>>2]|0;c[e>>2]=c[e>>2]|c[l>>2]<<(c[m>>2]<<3);c[m>>2]=(c[m>>2]|0)+1}if((n|0)==4){a[g>>0]=0;o=a[g>>0]|0;i=f;return o|0}else if((n|0)==6){a[g>>0]=1;o=a[g>>0]|0;i=f;return o|0}return 0}function _F(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=c[f>>2];if(c[(c[g>>2]|0)+20>>2]|0)R2(c[(c[g>>2]|0)+20>>2]|0)|0;if(!(c[(c[g>>2]|0)+52>>2]|0)){h=c[g>>2]|0;O4(h);i=e;return}if(!(c[(c[g>>2]|0)+60>>2]|0)){h=c[g>>2]|0;O4(h);i=e;return}Bb[c[(c[g>>2]|0)+60>>2]&127](c[g>>2]|0);h=c[g>>2]|0;O4(h);i=e;return}function $F(){var a=0,b=0;a=i;i=i+16|0;b=a;qA(0,1,147656,143955)|0;c[b>>2]=FR(0,1)|0;nS(c[b>>2]|0,0);i=a;return c[b>>2]|0}function aG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0;f=i;i=i+320|0;g=f+24|0;j=f+8|0;k=f;l=f+56|0;m=f+52|0;n=f+48|0;o=f+44|0;p=f+64|0;q=f+40|0;c[m>>2]=b;c[n>>2]=d;c[o>>2]=e;c[q>>2]=eF(c[m>>2]|0,c[o>>2]|0)|0;if((c[q>>2]|0)==999){q=c[o>>2]|0;e=zF(c[m>>2]|0,1,c[o>>2]|0)|0;c[k>>2]=q;c[k+4>>2]=e;$z(1,136511,k)|0;c[l>>2]=-1;r=c[l>>2]|0;i=f;return r|0}if((fF(c[m>>2]|0,c[n>>2]|0)|0)==-1){c[l>>2]=-1;r=c[l>>2]|0;i=f;return r|0}m=(c[(c[n>>2]|0)+8>>2]|0)+16|0;if(a[(c[(c[(c[n>>2]|0)+8>>2]|0)+8>>2]|0)+81>>0]|0){s=+h[(c[(c[n>>2]|0)+8>>2]|0)+16+8>>3];t=+h[(c[(c[n>>2]|0)+8>>2]|0)+16>>3];k=~~(+h[(c[(c[n>>2]|0)+8>>2]|0)+16>>3]>=0.0?t+.5:t-.5);t=+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16+8>>3];e=~~(+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16+8>>3]>=0.0?t+.5:t-.5);t=+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16>>3];q=~~(+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16>>3]>=0.0?t+.5:t-.5);c[j>>2]=~~(+h[m+8>>3]>=0.0?s+.5:s-.5);c[j+4>>2]=k;c[j+8>>2]=e;c[j+12>>2]=q;k3(p,136560,j)|0}else{s=+h[(c[(c[n>>2]|0)+8>>2]|0)+16>>3];t=+h[(c[(c[n>>2]|0)+8>>2]|0)+16+8>>3];j=~~(+h[(c[(c[n>>2]|0)+8>>2]|0)+16+8>>3]>=0.0?t+.5:t-.5);t=+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16>>3];q=~~(+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16>>3]>=0.0?t+.5:t-.5);t=+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16+8>>3];e=~~(+h[(c[(c[n>>2]|0)+8>>2]|0)+16+16+8>>3]>=0.0?t+.5:t-.5);c[g>>2]=~~(+h[m>>3]>=0.0?s+.5:s-.5);c[g+4>>2]=j;c[g+8>>2]=q;c[g+12>>2]=e;k3(p,136560,g)|0}CA(c[n>>2]|0,140294,p,178518)|0;c[l>>2]=0;r=c[l>>2]|0;i=f;return r|0}function bG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+48|0;g=f+8|0;h=f;j=f+36|0;k=f+32|0;l=f+28|0;m=f+24|0;n=f+20|0;o=f+16|0;p=f+12|0;c[k>>2]=a;c[l>>2]=b;c[m>>2]=d;c[n>>2]=e;c[l>>2]=c[(c[l>>2]|0)+48>>2];c[o>>2]=(HR(c[k>>2]|0,c[m>>2]|0)|0)&255;c[p>>2]=c[(c[k>>2]|0)+164>>2];if((c[o>>2]|0)==999){e=c[m>>2]|0;d=zF(c[k>>2]|0,3,c[m>>2]|0)|0;c[h>>2]=e;c[h+4>>2]=d;$z(1,136572,h)|0;c[j>>2]=-1;q=c[j>>2]|0;i=f;return q|0}h=QQ(c[p>>2]|0,c[(c[p>>2]|0)+52>>2]|0)|0;c[(c[p>>2]|0)+56>>2]=h;if(!((MC(c[l>>2]|0,175049,0,1)|0)!=0?(c[(c[(c[l>>2]|0)+8>>2]|0)+8>>2]|0)!=0:0))r=5;if((r|0)==5?(c[(c[p>>2]|0)+152>>2]&67108864|0)==0:0){aA(136616,g);c[j>>2]=-1;q=c[j>>2]|0;i=f;return q|0}GR(c[k>>2]|0,c[n>>2]|0);c[o>>2]=LH(c[k>>2]|0,c[l>>2]|0)|0;SQ(c[p>>2]|0);nF(c[p>>2]|0);MR(c[k>>2]|0);c[j>>2]=c[o>>2];q=c[j>>2]|0;i=f;return q|0}function cG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=i;i=i+64|0;h=g+16|0;j=g+8|0;k=g;l=g+48|0;m=g+44|0;n=g+40|0;o=g+36|0;p=g+32|0;q=g+28|0;r=g+24|0;s=g+20|0;c[m>>2]=a;c[n>>2]=b;c[o>>2]=d;c[p>>2]=e;c[q>>2]=f;c[n>>2]=c[(c[n>>2]|0)+48>>2];c[r>>2]=(HR(c[m>>2]|0,c[o>>2]|0)|0)&255;c[s>>2]=c[(c[m>>2]|0)+164>>2];if((c[r>>2]|0)==999){f=c[o>>2]|0;e=zF(c[m>>2]|0,3,c[o>>2]|0)|0;c[k>>2]=f;c[k+4>>2]=e;$z(1,136572,k)|0;c[l>>2]=-1;t=c[l>>2]|0;i=g;return t|0}k=QQ(c[s>>2]|0,c[(c[s>>2]|0)+52>>2]|0)|0;c[(c[s>>2]|0)+56>>2]=k;if(!((MC(c[n>>2]|0,175049,0,1)|0)!=0?(c[(c[(c[n>>2]|0)+8>>2]|0)+8>>2]|0)!=0:0))u=5;if((u|0)==5?(c[(c[s>>2]|0)+152>>2]&67108864|0)==0:0){aA(136616,j);c[l>>2]=-1;t=c[l>>2]|0;i=g;return t|0}if((c[p>>2]|0)!=0?(j=N4(4096)|0,c[c[p>>2]>>2]=j,(j|0)!=0):0){c[(c[s>>2]|0)+40>>2]=c[c[p>>2]>>2];c[(c[s>>2]|0)+44>>2]=4096;c[(c[s>>2]|0)+48>>2]=0;c[r>>2]=LH(c[m>>2]|0,c[n>>2]|0)|0;SQ(c[s>>2]|0);if(!(c[r>>2]|0)){c[c[p>>2]>>2]=c[(c[s>>2]|0)+40>>2];c[c[q>>2]>>2]=c[(c[s>>2]|0)+48>>2]}MR(c[m>>2]|0);c[l>>2]=c[r>>2];t=c[l>>2]|0;i=g;return t|0}$z(1,136637,h)|0;c[l>>2]=-1;t=c[l>>2]|0;i=g;return t|0}function dG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;mS(c[e>>2]|0,0,c[f>>2]|0);i=d;return}function eG(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,fa=0,ga=0,ha=0,ja=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,sa=0,ta=0,ua=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0;h=i;i=i+4288|0;j=h+8|0;k=h;l=4;m=N4(40)|0;c[m>>2]=0;p=h+4152|0;q=h+4148|0;r=h+4128|0;s=h+4112|0;t=h+16|0;n=0;u=ia(24,b|0)|0;v=n;n=0;if((v|0)!=0&(o|0)!=0){w=Y4(c[v>>2]|0,m|0,l|0)|0;if(!w)Pa(v|0,o|0);C=o}else w=-1;a:do if((w|0)!=1){if(!u){c[e>>2]=0;x=0;O4(m|0);i=h;return x|0}n=0;v=va(52,f|0,q|0,p|0,128)|0;y=n;n=0;if((y|0)!=0&(o|0)!=0){z=Y4(c[y>>2]|0,m|0,l|0)|0;if(!z)Pa(y|0,o|0);C=o}else z=-1;if((z|0)!=1){n=0;y=ia(23,4*10|0)|0;A=n;n=0;if((A|0)!=0&(o|0)!=0){B=Y4(c[A>>2]|0,m|0,l|0)|0;if(!B)Pa(A|0,o|0);C=o}else B=-1;if((B|0)!=1){n=0;da(16,r|0,s|0,t|0,19,85);A=n;n=0;if((A|0)!=0&(o|0)!=0){D=Y4(c[A>>2]|0,m|0,l|0)|0;if(!D)Pa(A|0,o|0);C=o}else D=-1;if((D|0)!=1){n=0;A=ia(25,b|0)|0;E=n;n=0;if((E|0)!=0&(o|0)!=0){F=Y4(c[E>>2]|0,m|0,l|0)|0;if(!F)Pa(E|0,o|0);C=o}else F=-1;if((F|0)!=1){E=A;while(1){if(!E)break;n=0;ra(c[r+16>>2]|0,E|0,0)|0;A=n;n=0;if((A|0)!=0&(o|0)!=0){G=Y4(c[A>>2]|0,m|0,l|0)|0;if(!G)Pa(A|0,o|0);C=o}else G=-1;if((G|0)==1){H=C;I=10;J=0;K=y;L=0;M=v;N=0;O=0;break a}n=0;A=ra(86,b|0,E|0)|0;P=n;n=0;if((P|0)!=0&(o|0)!=0){Q=Y4(c[P>>2]|0,m|0,l|0)|0;if(!Q)Pa(P|0,o|0);C=o}else Q=-1;if((Q|0)==1){H=C;I=10;J=0;K=y;L=0;M=v;N=0;O=0;break a}E=A}m=W4(54420,1,m|0,l|0)|0;l=C;n=0;E=n;n=0;if((E|0)!=0&(o|0)!=0){R=Y4(c[E>>2]|0,m|0,l|0)|0;if(!R)Pa(E|0,o|0);C=o}else R=-1;if((R|0)!=1){H=0;I=10;J=0;K=y;L=0;M=v;N=0;O=0}else{H=C;I=10;J=0;K=y;L=0;M=v;N=0;O=0}}else{H=C;I=10;J=0;K=y;L=0;M=v;N=0;O=0}}else{H=C;I=10;J=0;K=y;L=0;M=v;N=0;O=0}}else{H=C;I=10;J=0;K=0;L=0;M=v;N=0;O=0}}else{H=C;I=10;J=0;K=0;L=0;M=0;N=0;O=0}}else{H=C;I=10;J=0;K=0;L=0;M=0;N=0;O=0}while(0);b:while(1){c:do if(H){S=I;T=J;U=K;V=1;W=N;X=O}else{n=0;R=ia(25,b|0)|0;Q=n;n=0;if((Q|0)!=0&(o|0)!=0){Y=Y4(c[Q>>2]|0,m|0,l|0)|0;if(!Y)Pa(Q|0,o|0);C=o}else Y=-1;if((Y|0)==1){Z=M;_=L;$=K;aa=I;H=C;M=Z;L=_;K=$;I=aa;continue b}Q=J;G=R;R=N;F=O;while(1){if(!G)break;n=0;D=ra(c[r+16>>2]|0,G|0,-1)|0;t=n;n=0;if((t|0)!=0&(o|0)!=0){ba=Y4(c[t>>2]|0,m|0,l|0)|0;if(!ba)Pa(t|0,o|0);C=o}else ba=-1;if((ba|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=Q;N=R;O=F;M=Z;L=_;K=$;I=aa;continue b}if((D|0)==0?(d[(c[G+8>>2]|0)+119>>0]|0|0)==3:0){if(R){ca=Q;fa=R;ga=F}else{D=M+(c[q>>2]|0)|0;n=0;c[k>>2]=Q;ka(34,D|0,175023,k|0)|0;D=n;n=0;if((D|0)!=0&(o|0)!=0){ha=Y4(c[D>>2]|0,m|0,l|0)|0;if(!ha)Pa(D|0,o|0);C=o}else ha=-1;if((ha|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=Q;N=R;O=F;M=Z;L=_;K=$;I=aa;continue b}n=0;D=ka(35,b|0,M|0,1)|0;t=n;n=0;if((t|0)!=0&(o|0)!=0){ja=Y4(c[t>>2]|0,m|0,l|0)|0;if(!ja)Pa(t|0,o|0);C=o}else ja=-1;if((ja|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=Q;N=R;O=F;M=Z;L=_;K=$;I=aa;continue b}n=0;va(53,D|0,175049,280,1)|0;t=n;n=0;if((t|0)!=0&(o|0)!=0){la=Y4(c[t>>2]|0,m|0,l|0)|0;if(!la)Pa(t|0,o|0);C=o}else la=-1;if((la|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=Q;N=D;O=F;M=Z;L=_;K=$;I=aa;continue b}c[K+(Q<<2)>>2]=D;ca=Q+1|0;fa=D;ga=1}n=0;va(54,b|0,G|0,fa|0,r|0)|0;D=n;n=0;if((D|0)!=0&(o|0)!=0){ma=Y4(c[D>>2]|0,m|0,l|0)|0;if(!ma)Pa(D|0,o|0);C=o}else ma=-1;if((ma|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=ca;N=fa;O=ga;M=Z;L=_;K=$;I=aa;continue b}na=ca;oa=fa;pa=ga}else{na=Q;oa=R;pa=F}n=0;D=ra(86,b|0,G|0)|0;t=n;n=0;if((t|0)!=0&(o|0)!=0){qa=Y4(c[t>>2]|0,m|0,l|0)|0;if(!qa)Pa(t|0,o|0);C=o}else qa=-1;if((qa|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=na;N=oa;O=pa;M=Z;L=_;K=$;I=aa;continue b}Q=na;G=D;R=oa;F=pa}n=0;G=ia(25,b|0)|0;D=n;n=0;if((D|0)!=0&(o|0)!=0){sa=Y4(c[D>>2]|0,m|0,l|0)|0;if(!sa)Pa(D|0,o|0);C=o}else sa=-1;if((sa|0)==1){Z=M;_=L;$=K;aa=I;H=C;J=Q;N=R;O=F;M=Z;L=_;K=$;I=aa;continue b}D=I;t=Q;s=K;B=G;G=R;while(1){if(!B){S=D;T=t;U=s;V=L;W=G;X=F;break c}n=0;z=ra(c[r+16>>2]|0,B|0,-1)|0;f=n;n=0;if((f|0)!=0&(o|0)!=0){ta=Y4(c[f>>2]|0,m|0,l|0)|0;if(!ta)Pa(f|0,o|0);C=o}else ta=-1;if((ta|0)==1){Z=M;_=L;H=C;I=D;J=t;K=s;N=G;O=F;M=Z;L=_;continue b}if(z){ua=D;wa=t;xa=s;ya=G}else{z=M+(c[q>>2]|0)|0;n=0;c[j>>2]=t;ka(34,z|0,175023,j|0)|0;z=n;n=0;if((z|0)!=0&(o|0)!=0){za=Y4(c[z>>2]|0,m|0,l|0)|0;if(!za)Pa(z|0,o|0);C=o}else za=-1;if((za|0)==1){Z=M;_=L;H=C;I=D;J=t;K=s;N=G;O=F;M=Z;L=_;continue b}n=0;z=ka(35,b|0,M|0,1)|0;f=n;n=0;if((f|0)!=0&(o|0)!=0){Aa=Y4(c[f>>2]|0,m|0,l|0)|0;if(!Aa)Pa(f|0,o|0);C=o}else Aa=-1;if((Aa|0)==1){Z=M;_=L;H=C;I=D;J=t;K=s;N=G;O=F;M=Z;L=_;continue b}n=0;va(53,z|0,175049,280,1)|0;f=n;n=0;if((f|0)!=0&(o|0)!=0){Ba=Y4(c[f>>2]|0,m|0,l|0)|0;if(!Ba)Pa(f|0,o|0);C=o}else Ba=-1;if((Ba|0)==1){Z=M;_=L;H=C;I=D;J=t;K=s;N=z;O=F;M=Z;L=_;continue b}n=0;va(54,b|0,B|0,z|0,r|0)|0;f=n;n=0;if((f|0)!=0&(o|0)!=0){Ca=Y4(c[f>>2]|0,m|0,l|0)|0;if(!Ca)Pa(f|0,o|0);C=o}else Ca=-1;if((Ca|0)==1){Z=M;_=L;H=C;I=D;J=t;K=s;N=z;O=F;M=Z;L=_;continue b}if((t|0)==(D|0)){f=D<<1;n=0;u=ra(87,s|0,f<<2|0)|0;w=n;n=0;if((w|0)!=0&(o|0)!=0){Da=Y4(c[w>>2]|0,m|0,l|0)|0;if(!Da)Pa(w|0,o|0);C=o}else Da=-1;if((Da|0)==1){Z=M;_=L;H=C;I=f;J=t;K=s;N=z;O=F;M=Z;L=_;continue b}Ea=f;Fa=u}else{Ea=D;Fa=s}c[Fa+(t<<2)>>2]=z;ua=Ea;wa=t+1|0;xa=Fa;ya=z}n=0;z=ra(86,b|0,B|0)|0;u=n;n=0;if((u|0)!=0&(o|0)!=0){Ga=Y4(c[u>>2]|0,m|0,l|0)|0;if(!Ga)Pa(u|0,o|0);C=o}else Ga=-1;if((Ga|0)==1){Z=M;_=L;H=C;I=ua;J=wa;K=xa;N=ya;O=F;M=Z;L=_;continue b}D=ua;t=wa;s=xa;B=z;G=ya}}while(0);n=0;ea(99,r|0);v=n;n=0;if((v|0)!=0&(o|0)!=0){Ha=Y4(c[v>>2]|0,m|0,l|0)|0;if(!Ha)Pa(v|0,o|0);C=o}else Ha=-1;if((Ha|0)==1){Z=M;H=C;I=S;J=T;K=U;L=V;N=W;O=X;M=Z;continue}if((M|0)!=(p|0)){n=0;ea(96,M|0);v=n;n=0;if((v|0)!=0&(o|0)!=0){Ia=Y4(c[v>>2]|0,m|0,l|0)|0;if(!Ia)Pa(v|0,o|0);C=o}else Ia=-1;if((Ia|0)==1){Z=M;H=C;I=S;J=T;K=U;L=V;N=W;O=X;M=Z;continue}}if(!V){n=0;Ja=ra(87,U|0,T<<2|0)|0;v=n;n=0;if((v|0)!=0&(o|0)!=0){Ka=Y4(c[v>>2]|0,m|0,l|0)|0;if(!Ka)Pa(v|0,o|0);C=o}else Ka=-1;if((Ka|0)==1){Z=M;H=C;I=S;J=T;K=U;L=V;N=W;O=X;M=Z;continue}else{La=59;break}}c[e>>2]=0;v=0;while(1){if((v|0)>=(T|0))break;n=0;ia(26,c[U+(v<<2)>>2]|0)|0;y=n;n=0;if((y|0)!=0&(o|0)!=0){Ma=Y4(c[y>>2]|0,m|0,l|0)|0;if(!Ma)Pa(y|0,o|0);C=o}else Ma=-1;if((Ma|0)==1){Z=M;H=C;I=S;J=T;K=U;L=V;N=W;O=X;M=Z;continue b}v=v+1|0}n=0;ea(96,U|0);v=n;n=0;if((v|0)!=0&(o|0)!=0){Na=Y4(c[v>>2]|0,m|0,l|0)|0;if(!Na)Pa(v|0,o|0);C=o}else Na=-1;if((Na|0)==1){Z=M;H=C;I=S;J=T;K=U;L=V;N=W;O=X;M=Z}else{La=57;break}}if((La|0)==57)Oa=0;else if((La|0)==59){c[e>>2]=T;a[g>>0]=X;Oa=Ja}x=Oa;O4(m|0);i=h;return x|0}function fG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,fa=0,ga=0,ha=0,ja=0,la=0;e=i;i=i+4272|0;f=e;g=4;h=N4(40)|0;c[h>>2]=0;j=e+4144|0;k=e+4140|0;l=e+4120|0;m=e+4104|0;p=e+8|0;n=0;q=ia(24,a|0)|0;r=n;n=0;if((r|0)!=0&(o|0)!=0){s=Y4(c[r>>2]|0,h|0,g|0)|0;if(!s)Pa(r|0,o|0);C=o}else s=-1;a:do if((s|0)!=1){if(!q){c[b>>2]=0;t=0;O4(h|0);i=e;return t|0}n=0;r=va(52,d|0,k|0,j|0,128)|0;u=n;n=0;if((u|0)!=0&(o|0)!=0){v=Y4(c[u>>2]|0,h|0,g|0)|0;if(!v)Pa(u|0,o|0);C=o}else v=-1;if((v|0)!=1){n=0;u=ia(23,4*10|0)|0;w=n;n=0;if((w|0)!=0&(o|0)!=0){x=Y4(c[w>>2]|0,h|0,g|0)|0;if(!x)Pa(w|0,o|0);C=o}else x=-1;if((x|0)!=1){n=0;da(16,l|0,m|0,p|0,19,85);w=n;n=0;if((w|0)!=0&(o|0)!=0){y=Y4(c[w>>2]|0,h|0,g|0)|0;if(!y)Pa(w|0,o|0);C=o}else y=-1;if((y|0)!=1){n=0;w=ia(25,a|0)|0;z=n;n=0;if((z|0)!=0&(o|0)!=0){A=Y4(c[z>>2]|0,h|0,g|0)|0;if(!A)Pa(z|0,o|0);C=o}else A=-1;if((A|0)!=1){z=w;while(1){if(!z)break;n=0;ra(c[l+16>>2]|0,z|0,0)|0;w=n;n=0;if((w|0)!=0&(o|0)!=0){B=Y4(c[w>>2]|0,h|0,g|0)|0;if(!B)Pa(w|0,o|0);C=o}else B=-1;if((B|0)==1){D=C;E=10;F=0;G=u;H=r;break a}n=0;w=ra(86,a|0,z|0)|0;I=n;n=0;if((I|0)!=0&(o|0)!=0){J=Y4(c[I>>2]|0,h|0,g|0)|0;if(!J)Pa(I|0,o|0);C=o}else J=-1;if((J|0)==1){D=C;E=10;F=0;G=u;H=r;break a}z=w}h=W4(54420,1,h|0,g|0)|0;g=C;n=0;z=n;n=0;if((z|0)!=0&(o|0)!=0){K=Y4(c[z>>2]|0,h|0,g|0)|0;if(!K)Pa(z|0,o|0);C=o}else K=-1;if((K|0)!=1){D=0;E=10;F=0;G=u;H=r}else{D=C;E=10;F=0;G=u;H=r}}else{D=C;E=10;F=0;G=u;H=r}}else{D=C;E=10;F=0;G=u;H=r}}else{D=C;E=10;F=0;G=0;H=r}}else{D=C;E=10;F=0;G=0;H=0}}else{D=C;E=10;F=0;G=0;H=0}while(0);b:while(1){if(D){n=0;ea(99,l|0);K=n;n=0;if((K|0)!=0&(o|0)!=0){L=Y4(c[K>>2]|0,h|0,g|0)|0;if(!L)Pa(K|0,o|0);C=o}else L=-1;if((L|0)==1){M=H;N=G;O=F;P=E;D=C;H=M;G=N;F=O;E=P;continue}n=0;ea(96,G|0);K=n;n=0;if((K|0)!=0&(o|0)!=0){Q=Y4(c[K>>2]|0,h|0,g|0)|0;if(!Q)Pa(K|0,o|0);C=o}else Q=-1;if((Q|0)==1){M=H;N=G;O=F;P=E;D=C;H=M;G=N;F=O;E=P;continue}if((H|0)==(j|0)){R=21;break}n=0;ea(96,H|0);K=n;n=0;if((K|0)!=0&(o|0)!=0){S=Y4(c[K>>2]|0,h|0,g|0)|0;if(!S)Pa(K|0,o|0);C=o}else S=-1;if((S|0)==1){M=H;N=G;O=F;P=E;D=C;H=M;G=N;F=O;E=P;continue}else{R=20;break}}n=0;K=ia(25,a|0)|0;J=n;n=0;if((J|0)!=0&(o|0)!=0){T=Y4(c[J>>2]|0,h|0,g|0)|0;if(!T)Pa(J|0,o|0);C=o}else T=-1;if((T|0)==1){M=H;N=G;O=F;P=E;D=C;H=M;G=N;F=O;E=P;continue}J=E;U=F;B=G;A=K;while(1){if(!A)break;n=0;K=ra(c[l+16>>2]|0,A|0,-1)|0;y=n;n=0;if((y|0)!=0&(o|0)!=0){V=Y4(c[y>>2]|0,h|0,g|0)|0;if(!V)Pa(y|0,o|0);C=o}else V=-1;if((V|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue b}if(K){W=J;X=U;Y=B}else{K=H+(c[k>>2]|0)|0;n=0;c[f>>2]=U;ka(34,K|0,175023,f|0)|0;K=n;n=0;if((K|0)!=0&(o|0)!=0){Z=Y4(c[K>>2]|0,h|0,g|0)|0;if(!Z)Pa(K|0,o|0);C=o}else Z=-1;if((Z|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue b}n=0;K=ka(35,a|0,H|0,1)|0;y=n;n=0;if((y|0)!=0&(o|0)!=0){_=Y4(c[y>>2]|0,h|0,g|0)|0;if(!_)Pa(y|0,o|0);C=o}else _=-1;if((_|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue b}n=0;va(53,K|0,175049,280,1)|0;y=n;n=0;if((y|0)!=0&(o|0)!=0){$=Y4(c[y>>2]|0,h|0,g|0)|0;if(!$)Pa(y|0,o|0);C=o}else $=-1;if(($|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue b}n=0;va(54,a|0,A|0,K|0,l|0)|0;y=n;n=0;if((y|0)!=0&(o|0)!=0){aa=Y4(c[y>>2]|0,h|0,g|0)|0;if(!aa)Pa(y|0,o|0);C=o}else aa=-1;if((aa|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue b}if((U|0)==(J|0)){y=J<<1;n=0;p=ra(87,B|0,y<<2|0)|0;m=n;n=0;if((m|0)!=0&(o|0)!=0){ba=Y4(c[m>>2]|0,h|0,g|0)|0;if(!ba)Pa(m|0,o|0);C=o}else ba=-1;if((ba|0)==1){M=H;D=C;E=y;F=U;G=B;H=M;continue b}ca=y;fa=p}else{ca=J;fa=B}c[fa+(U<<2)>>2]=K;W=ca;X=U+1|0;Y=fa}n=0;K=ra(86,a|0,A|0)|0;p=n;n=0;if((p|0)!=0&(o|0)!=0){ga=Y4(c[p>>2]|0,h|0,g|0)|0;if(!ga)Pa(p|0,o|0);C=o}else ga=-1;if((ga|0)==1){M=H;D=C;E=W;F=X;G=Y;H=M;continue b}J=W;U=X;B=Y;A=K}n=0;ea(99,l|0);A=n;n=0;if((A|0)!=0&(o|0)!=0){ha=Y4(c[A>>2]|0,h|0,g|0)|0;if(!ha)Pa(A|0,o|0);C=o}else ha=-1;if((ha|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue}n=0;A=G;G=ra(87,B|0,U<<2|0)|0;A=n;n=0;if((A|0)!=0&(o|0)!=0){ja=Y4(c[A>>2]|0,h|0,g|0)|0;if(!ja)Pa(A|0,o|0);C=o}else ja=-1;if((ja|0)==1){M=H;D=C;E=J;F=U;G=B;H=M;continue}if((H|0)==(j|0)){R=42;break}n=0;ea(96,H|0);A=n;n=0;if((A|0)!=0&(o|0)!=0){la=Y4(c[A>>2]|0,h|0,g|0)|0;if(!la)Pa(A|0,o|0);C=o}else la=-1;if((la|0)!=1){R=41;break}else{M=H;D=C;E=J;F=U;H=M}}if((R|0)==20)R=21;else if((R|0)==41)R=42;if((R|0)==21){c[b>>2]=0;t=0;O4(h|0);i=e;return t|0}else if((R|0)==42){c[b>>2]=U;t=G;O4(h|0);i=e;return t|0}return 0}function gG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[j>>2]=0;c[g>>2]=$B(c[e>>2]|0)|0;while(1){if(!(c[g>>2]|0))break;c[h>>2]=OA(c[f>>2]|0,c[g>>2]|0)|0;while(1){k=c[e>>2]|0;if(!(c[h>>2]|0))break;b=c[h>>2]|0;if(eC(k,c[((c[c[h>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2]|0,0)|0){YA(c[e>>2]|0,c[h>>2]|0,1)|0;c[j>>2]=(c[j>>2]|0)+1}c[h>>2]=QA(c[f>>2]|0,c[h>>2]|0)|0}c[g>>2]=aC(k,c[g>>2]|0)|0}i=d;return c[j>>2]|0}function hG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;f=i;i=i+4368|0;g=f+24|0;h=f+8|0;j=f;k=f+4228|0;l=f+4224|0;m=f+4220|0;n=f+4216|0;o=f+4212|0;p=f+4208|0;q=f+4204|0;r=f+4200|0;s=f+4196|0;t=f+4192|0;u=f+4188|0;v=f+4184|0;w=f+4232|0;x=f+4180|0;y=f+4160|0;z=f+44|0;A=f+40|0;c[l>>2]=b;c[m>>2]=d;c[n>>2]=e;c[A>>2]=12;if(!(kB(c[l>>2]|0)|0)){c[c[m>>2]>>2]=0;c[k>>2]=0;B=c[k>>2]|0;i=f;return B|0}OC(c[l>>2]|0,0,136674,0-(c[A>>2]|0)|0,0);OC(c[l>>2]|0,1,136686,16,0);c[s>>2]=jG(c[n>>2]|0,z,w,128)|0;c[o>>2]=pG(c[l>>2]|0)|0;c[x>>2]=cK((kB(c[o>>2]|0)|0)<<2)|0;mG(y,f+4144|0,f+48|0,19,88);c[q>>2]=0;c[v>>2]=$B(c[o>>2]|0)|0;while(1){if(!(c[v>>2]|0))break;if(!(Ob[c[y+16>>2]&127](c[v>>2]|0,-1)|0)){n=(c[s>>2]|0)+(c[z>>2]|0)|0;c[j>>2]=c[q>>2];k3(n,137605,j)|0;c[u>>2]=FD(c[o>>2]|0,c[s>>2]|0,1)|0;c[t>>2]=FD(c[l>>2]|0,c[s>>2]|0,1)|0;MC(c[t>>2]|0,136674,12,0)|0;a[(LC(c[t>>2]|0,136674,0)|0)+8>>0]=1;c[p>>2]=nG(c[o>>2]|0,c[v>>2]|0,c[u>>2]|0,y)|0;rG(c[u>>2]|0,c[t>>2]|0);c[r>>2]=iG(c[t>>2]|0)|0;sG(c[l>>2]|0,c[t>>2]|0);c[(c[x>>2]|0)+(c[q>>2]<<2)>>2]=c[t>>2];pC(c[o>>2]|0,c[u>>2]|0)|0;if(a[138998]|0){n=c[24742]|0;A=c[p>>2]|0;e=c[r>>2]|0;c[h>>2]=c[q>>2];c[h+4>>2]=A;c[h+8>>2]=e;Y2(n,136698,h)|0}c[q>>2]=(c[q>>2]|0)+1}c[v>>2]=aC(c[o>>2]|0,c[v>>2]|0)|0}if(a[138998]|0){v=c[24742]|0;h=kB(c[l>>2]|0)|0;r=lB(c[l>>2]|0)|0;p=c[q>>2]|0;u=wB(c[l>>2]|0)|0;c[g>>2]=h;c[g+4>>2]=r;c[g+8>>2]=p;c[g+12>>2]=u;Y2(v,136728,g)|0}jB(c[o>>2]|0)|0;PC(c[l>>2]|0,0,136674);PC(c[l>>2]|0,1,136686);oG(y);c[x>>2]=eK(c[x>>2]|0,c[q>>2]<<2)|0;if((c[s>>2]|0)!=(w|0))O4(c[s>>2]|0);c[c[m>>2]>>2]=c[q>>2];c[k>>2]=c[x>>2];B=c[k>>2]|0;i=f;return B|0}function iG(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=gG(c[d>>2]|0,c[(c[d>>2]|0)+48>>2]|0)|0;i=b;return a|0}function jG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;if(!((c[h>>2]|0)!=0?(zG(c[h>>2]|0)|0)!=0:0))c[h>>2]=136864;c[m>>2]=N3(c[h>>2]|0)|0;if(((c[m>>2]|0)+25|0)>(c[l>>2]|0)){l=cK((c[m>>2]|0)+25|0)|0;c[n>>2]=l;if(!l){c[g>>2]=0;o=c[g>>2]|0;i=f;return o|0}}else c[n>>2]=c[k>>2];K3(c[n>>2]|0,c[h>>2]|0)|0;c[c[j>>2]>>2]=c[m>>2];c[g>>2]=c[n>>2];o=c[g>>2]|0;i=f;return o|0}function kG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;eC(c[f>>2]|0,c[e>>2]|0,1)|0;i=d;return}function lG(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=b;c[h>>2]=d;d=a[(c[(c[g>>2]|0)+8>>2]|0)+157>>0]|0;if((c[h>>2]|0)<0){c[f>>2]=d;k=c[f>>2]|0;i=e;return k|0}else{c[j>>2]=d;a[(c[(c[g>>2]|0)+8>>2]|0)+157>>0]=c[h>>2];c[f>>2]=c[j>>2];k=c[f>>2]|0;i=e;return k|0}return 0}function mG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;g=i;i=i+32|0;h=g+16|0;j=g+12|0;k=g+8|0;l=g+4|0;m=g;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;c[c[j>>2]>>2]=c[k>>2];c[(c[j>>2]|0)+4>>2]=(c[c[j>>2]>>2]|0)+4096;c[(c[j>>2]|0)+12>>2]=0;c[(c[j>>2]|0)+8>>2]=0;k=c[j>>2]|0;c[c[h>>2]>>2]=k;c[(c[h>>2]|0)+4>>2]=k;c[(c[h>>2]|0)+8>>2]=c[c[(c[h>>2]|0)+4>>2]>>2];c[(c[h>>2]|0)+12>>2]=c[l>>2];c[(c[h>>2]|0)+16>>2]=c[m>>2];i=g;return}function nG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[n>>2]=0;xG(c[k>>2]|0,c[h>>2]|0);a:while(1){e=yG(c[k>>2]|0)|0;c[h>>2]=e;o=c[n>>2]|0;if(!e)break;c[n>>2]=o+1;if(c[(c[k>>2]|0)+12>>2]|0)Db[c[(c[k>>2]|0)+12>>2]&31](c[h>>2]|0,c[j>>2]|0);c[l>>2]=TA(c[g>>2]|0,c[h>>2]|0)|0;while(1){if(!(c[l>>2]|0))continue a;e=c[l>>2]|0;d=c[((c[c[l>>2]>>2]&3|0)==3?e:e+32|0)+28>>2]|0;c[m>>2]=d;if((d|0)==(c[h>>2]|0)){d=c[l>>2]|0;c[m>>2]=c[((c[c[l>>2]>>2]&3|0)==2?d:d+-32|0)+28>>2]}if(!(Ob[c[(c[k>>2]|0)+16>>2]&127](c[m>>2]|0,-1)|0))xG(c[k>>2]|0,c[m>>2]|0);c[l>>2]=UA(c[g>>2]|0,c[l>>2]|0,c[h>>2]|0)|0}}i=f;return o|0}function oG(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+8|0;e=b+4|0;f=b;c[d>>2]=a;c[e>>2]=c[(c[c[d>>2]>>2]|0)+12>>2];while(1){if(!(c[e>>2]|0))break;c[f>>2]=c[(c[e>>2]|0)+12>>2];wG(c[e>>2]|0);c[e>>2]=c[f>>2]}i=b;return}function pG(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+32|0;d=b+28|0;e=b+24|0;f=b+20|0;g=b+16|0;h=b+12|0;j=b+8|0;k=b+4|0;l=b;c[e>>2]=a;c[d>>2]=c[13068];c[f>>2]=gB(136775,d,0)|0;vG(c[f>>2]|0,c[e>>2]|0);c[h>>2]=$B(c[e>>2]|0)|0;while(1){if(!(c[h>>2]|0))break;if(!(c[(LC(c[h>>2]|0,136686,0)|0)+12>>2]|0)){d=c[f>>2]|0;c[g>>2]=fC(d,wB(c[h>>2]|0)|0,1)|0;MC(c[g>>2]|0,136686,16,1)|0;c[(c[(c[g>>2]|0)+8>>2]|0)+12>>2]=c[h>>2];d=c[g>>2]|0;c[(LC(c[h>>2]|0,136686,0)|0)+12>>2]=d}c[h>>2]=aC(c[e>>2]|0,c[h>>2]|0)|0}c[h>>2]=$B(c[e>>2]|0)|0;while(1){if(!(c[h>>2]|0))break;c[l>>2]=c[(LC(c[h>>2]|0,136686,0)|0)+12>>2];c[j>>2]=OA(c[e>>2]|0,c[h>>2]|0)|0;while(1){if(!(c[j>>2]|0))break;g=c[j>>2]|0;c[k>>2]=c[((c[c[j>>2]>>2]&3|0)==2?g:g+-32|0)+28>>2];c[k>>2]=c[(LC(c[k>>2]|0,136686,0)|0)+12>>2];do if((c[k>>2]|0)!=(c[l>>2]|0)){g=c[f>>2]|0;if((c[k>>2]|0)>>>0>(c[l>>2]|0)>>>0){VA(g,c[l>>2]|0,c[k>>2]|0,0,1)|0;break}else{VA(g,c[k>>2]|0,c[l>>2]|0,0,1)|0;break}}while(0);c[j>>2]=QA(c[e>>2]|0,c[j>>2]|0)|0}c[h>>2]=aC(c[e>>2]|0,c[h>>2]|0)|0}i=b;return c[f>>2]|0}function qG(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=b;c[h>>2]=d;d=a[(c[(c[g>>2]|0)+8>>2]|0)+8>>0]|0;if((c[h>>2]|0)<0){c[f>>2]=d;k=c[f>>2]|0;i=e;return k|0}else{c[j>>2]=d;a[(c[(c[g>>2]|0)+8>>2]|0)+8>>0]=c[h>>2];c[f>>2]=c[j>>2];k=c[f>>2]|0;i=e;return k|0}return 0}function rG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+32|0;e=d+16|0;f=d+12|0;g=d+8|0;h=d+4|0;j=d;c[e>>2]=a;c[f>>2]=b;c[h>>2]=$B(c[e>>2]|0)|0;while(1){if(!(c[h>>2]|0))break;a:do if((c[c[(c[(c[h>>2]|0)+8>>2]|0)+12>>2]>>2]&3|0)==1)eC(c[f>>2]|0,c[(c[(c[h>>2]|0)+8>>2]|0)+12>>2]|0,1)|0;else{c[j>>2]=c[(c[(c[h>>2]|0)+8>>2]|0)+12>>2];c[g>>2]=$B(c[j>>2]|0)|0;while(1){if(!(c[g>>2]|0))break a;eC(c[f>>2]|0,c[g>>2]|0,1)|0;c[g>>2]=aC(c[j>>2]|0,c[g>>2]|0)|0}}while(0);c[h>>2]=aC(c[e>>2]|0,c[h>>2]|0)|0}i=d;return}function sG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;tG(c[e>>2]|0,c[f>>2]|0,0);i=d;return}function tG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+20|0;h=f+16|0;j=f+12|0;k=f+8|0;l=f+4|0;m=f;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;c[k>>2]=GD(c[g>>2]|0)|0;while(1){if(!(c[k>>2]|0))break;if((a[(LC(c[k>>2]|0,136674,0)|0)+8>>0]|0)==0?(g=uG(c[k>>2]|0,c[h>>2]|0,c[j>>2]|0)|0,c[l>>2]=g,(g|0)!=0):0){if(c[j>>2]|0)n=1;else n=(P3(wB(c[k>>2]|0)|0,145613,7)|0)==0;c[m>>2]=n&1;tG(c[k>>2]|0,c[l>>2]|0,c[m>>2]|0)}c[k>>2]=HD(c[k>>2]|0)|0}i=f;return}function uG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=0;c[k>>2]=$B(c[f>>2]|0)|0;while(1){if(!(c[k>>2]|0))break;d=c[g>>2]|0;b=fC(d,wB(c[k>>2]|0)|0,0)|0;c[l>>2]=b;if(b){if(!(c[j>>2]|0)){b=c[g>>2]|0;c[j>>2]=FD(b,wB(c[f>>2]|0)|0,1)|0}eC(c[j>>2]|0,c[l>>2]|0,1)|0}c[k>>2]=aC(c[f>>2]|0,c[k>>2]|0)|0}if((c[j>>2]|0)==0&(c[h>>2]|0)!=0){h=c[g>>2]|0;c[j>>2]=FD(h,wB(c[f>>2]|0)|0,1)|0}if(!(c[j>>2]|0)){m=c[j>>2]|0;i=e;return m|0}gG(c[j>>2]|0,c[f>>2]|0)|0;DA(c[f>>2]|0,c[j>>2]|0)|0;m=c[j>>2]|0;i=e;return m|0}function vG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;d=i;i=i+32|0;e=d;f=d+28|0;g=d+24|0;h=d+20|0;j=d+16|0;k=d+12|0;c[f>>2]=a;c[g>>2]=b;c[h>>2]=GD(c[g>>2]|0)|0;while(1){if(!(c[h>>2]|0))break;g=(P3(wB(c[h>>2]|0)|0,145613,7)|0)==0;b=c[f>>2]|0;a=c[h>>2]|0;a:do if(g){c[j>>2]=fC(b,wB(a)|0,1)|0;MC(c[j>>2]|0,136686,16,1)|0;c[(c[(c[j>>2]|0)+8>>2]|0)+12>>2]=c[h>>2];c[k>>2]=$B(c[h>>2]|0)|0;while(1){if(!(c[k>>2]|0))break a;if(c[(LC(c[k>>2]|0,136686,0)|0)+12>>2]|0){l=c[24742]|0;m=wB(c[k>>2]|0)|0;n=wB(c[h>>2]|0)|0;o=wB(c[(LC(c[k>>2]|0,136686,0)|0)+12>>2]|0)|0;c[e>>2]=m;c[e+4>>2]=n;c[e+8>>2]=o;Y2(l,136778,e)|0}l=c[j>>2]|0;c[(LC(c[k>>2]|0,136686,0)|0)+12>>2]=l;c[k>>2]=aC(c[h>>2]|0,c[k>>2]|0)|0}}else vG(b,a);while(0);c[h>>2]=HD(c[h>>2]|0)|0}i=d;return}function wG(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;O4(c[c[d>>2]>>2]|0);O4(c[d>>2]|0);i=b;return}function xG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;d=i;i=i+32|0;e=d+8|0;f=d;g=d+20|0;h=d+16|0;j=d+12|0;c[g>>2]=a;c[h>>2]=b;if((c[(c[g>>2]|0)+8>>2]|0)!=(c[(c[(c[g>>2]|0)+4>>2]|0)+4>>2]|0)){k=c[g>>2]|0;l=k+16|0;m=c[l>>2]|0;n=c[h>>2]|0;Ob[m&127](n,1)|0;o=c[h>>2]|0;p=c[g>>2]|0;q=p+8|0;r=c[q>>2]|0;s=r+4|0;c[q>>2]=s;c[r>>2]=o;i=d;return}do if(!(c[(c[(c[g>>2]|0)+4>>2]|0)+12>>2]|0)){c[j>>2]=cK(16)|0;if(!(c[j>>2]|0)){$z(1,136845,f)|0;Pa(54420,1)}c[(c[j>>2]|0)+8>>2]=c[(c[g>>2]|0)+4>>2];c[(c[j>>2]|0)+12>>2]=0;b=cK(4e6)|0;c[c[j>>2]>>2]=b;if(!(c[c[j>>2]>>2]|0)){$z(1,136845,e)|0;Pa(54420,1)}else{c[(c[j>>2]|0)+4>>2]=(c[c[j>>2]>>2]|0)+4e6;c[(c[(c[g>>2]|0)+4>>2]|0)+12>>2]=c[j>>2];break}}while(0);c[(c[g>>2]|0)+4>>2]=c[(c[(c[g>>2]|0)+4>>2]|0)+12>>2];c[(c[g>>2]|0)+8>>2]=c[c[(c[g>>2]|0)+4>>2]>>2];k=c[g>>2]|0;l=k+16|0;m=c[l>>2]|0;n=c[h>>2]|0;Ob[m&127](n,1)|0;o=c[h>>2]|0;p=c[g>>2]|0;q=p+8|0;r=c[q>>2]|0;s=r+4|0;c[q>>2]=s;c[r>>2]=o;i=d;return}function yG(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b+4|0;e=b;c[e>>2]=a;do if((c[(c[e>>2]|0)+8>>2]|0)==(c[c[(c[e>>2]|0)+4>>2]>>2]|0)){if((c[(c[e>>2]|0)+4>>2]|0)!=(c[c[e>>2]>>2]|0)){c[(c[e>>2]|0)+4>>2]=c[(c[(c[e>>2]|0)+4>>2]|0)+8>>2];c[(c[e>>2]|0)+8>>2]=c[(c[(c[e>>2]|0)+4>>2]|0)+4>>2];break}c[d>>2]=0;f=c[d>>2]|0;i=b;return f|0}while(0);a=(c[e>>2]|0)+8|0;c[a>>2]=(c[a>>2]|0)+-4;c[d>>2]=c[c[(c[e>>2]|0)+8>>2]>>2];f=c[d>>2]|0;i=b;return f|0}function zG(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+16|0;f=e+4|0;g=e;h=e+8|0;c[g>>2]=b;while(1){b=c[g>>2]|0;c[g>>2]=b+1;j=a[b>>0]|0;a[h>>0]=j;if(!(j<<24>>24)){k=6;break}if((d[h>>0]|0|0)==95)continue;if(!(l1(d[h>>0]|0)|0)){k=5;break}}if((k|0)==5){c[f>>2]=0;l=c[f>>2]|0;i=e;return l|0}else if((k|0)==6){c[f>>2]=1;l=c[f>>2]|0;i=e;return l|0}return 0}function AG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0;e=i;i=i+64|0;f=e+52|0;g=e+48|0;j=e+44|0;k=e+40|0;l=e+36|0;m=e+32|0;n=e+28|0;o=e+24|0;p=e+20|0;q=e+16|0;r=e+12|0;s=e+8|0;t=e+4|0;u=e;c[f>>2]=d;v=+h[a>>3];c[g>>2]=~~(+h[a>>3]>=0.0?v+.5:v-.5);v=+h[a+8>>3];c[j>>2]=~~(+h[a+8>>3]>=0.0?v+.5:v-.5);v=+h[b>>3];c[k>>2]=~~(+h[b>>3]>=0.0?v+.5:v-.5);v=+h[b+8>>3];c[l>>2]=~~(+h[b+8>>3]>=0.0?v+.5:v-.5);c[t>>2]=(c[k>>2]|0)-(c[g>>2]|0);b=c[t>>2]|0;c[p>>2]=((c[t>>2]|0)>=0?b:0-b|0)<<1;c[r>>2]=(c[t>>2]|0)<0?-1:1;c[u>>2]=(c[l>>2]|0)-(c[j>>2]|0);t=c[u>>2]|0;c[q>>2]=((c[u>>2]|0)>=0?t:0-t|0)<<1;c[s>>2]=(c[u>>2]|0)<0?-1:1;c[n>>2]=c[g>>2];c[o>>2]=c[j>>2];if((c[p>>2]|0)>(c[q>>2]|0)){c[m>>2]=(c[q>>2]|0)-(c[p>>2]>>1);while(1){YK(c[f>>2]|0,c[n>>2]|0,c[o>>2]|0);if((c[n>>2]|0)==(c[k>>2]|0))break;if((c[m>>2]|0)>=0){c[o>>2]=(c[o>>2]|0)+(c[s>>2]|0);c[m>>2]=(c[m>>2]|0)-(c[p>>2]|0)}c[n>>2]=(c[n>>2]|0)+(c[r>>2]|0);c[m>>2]=(c[m>>2]|0)+(c[q>>2]|0)}i=e;return}else{c[m>>2]=(c[p>>2]|0)-(c[q>>2]>>1);while(1){YK(c[f>>2]|0,c[n>>2]|0,c[o>>2]|0);if((c[o>>2]|0)==(c[l>>2]|0))break;if((c[m>>2]|0)>=0){c[n>>2]=(c[n>>2]|0)+(c[r>>2]|0);c[m>>2]=(c[m>>2]|0)-(c[q>>2]|0)}c[o>>2]=(c[o>>2]|0)+(c[s>>2]|0);c[m>>2]=(c[m>>2]|0)+(c[p>>2]|0)}i=e;return}}function BG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;f=i;i=i+48|0;g=f;h=f+44|0;j=f+40|0;k=f+36|0;l=f+32|0;m=f+28|0;n=f+24|0;o=f+20|0;p=f+16|0;q=f+12|0;r=f+8|0;s=f+4|0;c[j>>2]=a;c[k>>2]=b;c[l>>2]=d;c[m>>2]=e;if((c[j>>2]|0)<=0){c[h>>2]=0;t=c[h>>2]|0;i=f;return t|0}e=c[j>>2]|0;if((c[(c[m>>2]|0)+16>>2]|0)>>>0<=3){c[h>>2]=KG(e,c[k>>2]|0,c[l>>2]|0,c[m>>2]|0)|0;t=c[h>>2]|0;i=f;return t|0}c[p>>2]=cK(e<<5)|0;c[n>>2]=0;while(1){if((c[n>>2]|0)>=(c[j>>2]|0))break;c[q>>2]=c[(c[k>>2]|0)+(c[n>>2]<<2)>>2];BO(c[q>>2]|0);e=(c[p>>2]|0)+(c[n>>2]<<5)|0;l=(c[(c[q>>2]|0)+8>>2]|0)+16|0;c[e>>2]=c[l>>2];c[e+4>>2]=c[l+4>>2];c[e+8>>2]=c[l+8>>2];c[e+12>>2]=c[l+12>>2];c[e+16>>2]=c[l+16>>2];c[e+20>>2]=c[l+20>>2];c[e+24>>2]=c[l+24>>2];c[e+28>>2]=c[l+28>>2];c[n>>2]=(c[n>>2]|0)+1}if((c[(c[m>>2]|0)+16>>2]|0)==4){a:do if(c[(c[m>>2]|0)+28>>2]&2){q=bK(c[j>>2]<<2)|0;c[(c[m>>2]|0)+24>>2]=q;c[n>>2]=0;while(1){if((c[n>>2]|0)>=(c[j>>2]|0))break a;c[s>>2]=yA(c[(c[k>>2]|0)+(c[n>>2]<<2)>>2]|0,136869)|0;if((c[s>>2]|0)!=0?(q=c[s>>2]|0,c[g>>2]=o,l=(l3(q,175023,g)|0)>0,l&(c[o>>2]|0)>=0):0)c[(c[(c[m>>2]|0)+24>>2]|0)+(c[n>>2]<<2)>>2]=c[o>>2];c[n>>2]=(c[n>>2]|0)+1}}while(0);c[r>>2]=LG(c[j>>2]|0,c[p>>2]|0,c[m>>2]|0)|0;if(c[(c[m>>2]|0)+28>>2]&2)O4(c[(c[m>>2]|0)+24>>2]|0)}O4(c[p>>2]|0);c[h>>2]=c[r>>2];t=c[h>>2]|0;i=f;return t|0}function CG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;do if((c[g>>2]|0)<=0)c[f>>2]=0;else{if((c[(c[j>>2]|0)+16>>2]|0)!=2?(c[(c[j>>2]|0)+16>>2]|0)!=1:0){if((c[(c[j>>2]|0)+16>>2]|0)==3){c[f>>2]=MG(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;break}if((c[(c[j>>2]|0)+16>>2]|0)==4){c[f>>2]=LG(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;break}else{c[f>>2]=0;break}}c[f>>2]=0}while(0);i=e;return c[f>>2]|0}function DG(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;g=i;i=i+80|0;j=g+72|0;k=g+68|0;l=g+64|0;m=g+60|0;n=g+56|0;o=g+52|0;p=g+48|0;q=g+44|0;r=g+40|0;s=g+8|0;t=g;u=g+32|0;v=g+28|0;w=g+24|0;x=g+20|0;y=g+16|0;c[k>>2]=a;c[l>>2]=b;c[m>>2]=d;c[n>>2]=e;c[o>>2]=f;if((c[k>>2]|0)<=0){c[j>>2]=N(c[k>>2]|0)|0;z=c[j>>2]|0;i=g;return z|0}c[p>>2]=0;while(1){if((c[p>>2]|0)>=(c[k>>2]|0))break;c[v>>2]=c[(c[l>>2]|0)+(c[p>>2]<<2)>>2];if(c[n>>2]|0)c[w>>2]=c[n>>2];else c[w>>2]=c[v>>2];f=(c[m>>2]|0)+(c[p>>2]<<3)|0;c[u>>2]=c[f>>2];c[u+4>>2]=c[f+4>>2];c[q>>2]=c[u>>2];c[r>>2]=c[u+4>>2];h[s>>3]=+(c[q>>2]|0)/72.0;h[t>>3]=+(c[r>>2]|0)/72.0;c[x>>2]=$B(c[v>>2]|0)|0;while(1){if(!(c[x>>2]|0))break;f=c[(c[(c[x>>2]|0)+8>>2]|0)+132>>2]|0;h[f>>3]=+h[f>>3]+ +h[s>>3];f=(c[(c[(c[x>>2]|0)+8>>2]|0)+132>>2]|0)+8|0;h[f>>3]=+h[f>>3]+ +h[t>>3];f=(c[(c[x>>2]|0)+8>>2]|0)+16|0;h[f>>3]=+h[f>>3]+ +(c[q>>2]|0);f=(c[(c[x>>2]|0)+8>>2]|0)+16+8|0;h[f>>3]=+h[f>>3]+ +(c[r>>2]|0);if(c[(c[(c[x>>2]|0)+8>>2]|0)+108>>2]|0){f=(c[(c[(c[x>>2]|0)+8>>2]|0)+108>>2]|0)+56|0;h[f>>3]=+h[f>>3]+ +(c[q>>2]|0);f=(c[(c[(c[x>>2]|0)+8>>2]|0)+108>>2]|0)+56+8|0;h[f>>3]=+h[f>>3]+ +(c[r>>2]|0)}a:do if(c[o>>2]|0){c[y>>2]=OA(c[w>>2]|0,c[x>>2]|0)|0;while(1){if(!(c[y>>2]|0))break a;NG(c[y>>2]|0,c[q>>2]|0,c[r>>2]|0);c[y>>2]=QA(c[w>>2]|0,c[y>>2]|0)|0}}while(0);c[x>>2]=aC(c[v>>2]|0,c[x>>2]|0)|0}OG(c[v>>2]|0,c[q>>2]|0,c[r>>2]|0);c[p>>2]=(c[p>>2]|0)+1}c[j>>2]=0;z=c[j>>2]|0;i=g;return z|0}function EG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+24|0;h=f+20|0;j=f+16|0;k=f+12|0;l=f+8|0;m=f+4|0;n=f;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[n>>2]=BG(c[h>>2]|0,c[j>>2]|0,c[k>>2]|0,c[l>>2]|0)|0;if(c[n>>2]|0){c[m>>2]=DG(c[h>>2]|0,c[j>>2]|0,c[n>>2]|0,c[k>>2]|0,c[(c[l>>2]|0)+12>>2]|0)|0;O4(c[n>>2]|0);c[g>>2]=c[m>>2];o=c[g>>2]|0;i=f;return o|0}else{c[g>>2]=1;o=c[g>>2]|0;i=f;return o|0}return 0}function FG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0;f=i;i=i+64|0;g=f+60|0;j=f+56|0;k=f+52|0;l=f+48|0;m=f+44|0;n=f+40|0;o=f+36|0;p=f;q=f+32|0;c[g>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=EG(c[g>>2]|0,c[j>>2]|0,c[k>>2]|0,c[l>>2]|0)|0;if(c[m>>2]|0){r=c[m>>2]|0;i=f;return r|0}BO(c[k>>2]|0);l=(c[(c[k>>2]|0)+8>>2]|0)+16|0;c[p>>2]=c[l>>2];c[p+4>>2]=c[l+4>>2];c[p+8>>2]=c[l+8>>2];c[p+12>>2]=c[l+12>>2];c[p+16>>2]=c[l+16>>2];c[p+20>>2]=c[l+20>>2];c[p+24>>2]=c[l+24>>2];c[p+28>>2]=c[l+28>>2];c[n>>2]=0;while(1){if((c[n>>2]|0)>=(c[g>>2]|0))break;c[q>>2]=c[(c[j>>2]|0)+(c[n>>2]<<2)>>2];c[o>>2]=1;while(1){if((c[o>>2]|0)>(c[(c[(c[q>>2]|0)+8>>2]|0)+180>>2]|0))break;if(+h[p>>3]<+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16>>3])s=+h[p>>3];else s=+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16>>3];h[p>>3]=s;if(+h[p+8>>3]<+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16+8>>3])t=+h[p+8>>3];else t=+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16+8>>3];h[p+8>>3]=t;if(+h[p+16>>3]>+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16+16>>3])u=+h[p+16>>3];else u=+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16+16>>3];h[p+16>>3]=u;if(+h[p+16+8>>3]>+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16+16+8>>3])v=+h[p+16+8>>3];else v=+h[(c[(c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[o>>2]<<2)>>2]|0)+8>>2]|0)+16+16+8>>3];h[p+16+8>>3]=v;c[o>>2]=(c[o>>2]|0)+1}c[n>>2]=(c[n>>2]|0)+1}n=(c[(c[k>>2]|0)+8>>2]|0)+16|0;c[n>>2]=c[p>>2];c[n+4>>2]=c[p+4>>2];c[n+8>>2]=c[p+8>>2];c[n+12>>2]=c[p+12>>2];c[n+16>>2]=c[p+16>>2];c[n+20>>2]=c[p+20>>2];c[n+24>>2]=c[p+24>>2];c[n+28>>2]=c[p+28>>2];r=c[m>>2]|0;i=f;return r|0}function GG(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;g=i;i=i+32|0;h=g;j=g+16|0;k=g+12|0;l=g+8|0;m=g+4|0;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;if(!(c[m>>2]|0))La(136875,136881,1400,136888);f=JG(c[j>>2]|0,c[l>>2]|0,c[l>>2]|0)|0;c[(c[m>>2]|0)+8>>2]=f;if(a[138998]|0){f=c[24742]|0;c[h>>2]=c[(c[m>>2]|0)+8>>2];Y2(f,136900,h)|0}c[(c[m>>2]|0)+12>>2]=0;c[(c[m>>2]|0)+20>>2]=0;IG(c[j>>2]|0,c[k>>2]|0,c[m>>2]|0)|0;i=g;return c[(c[m>>2]|0)+16>>2]|0}function HG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;f=i;i=i+80|0;j=f+48|0;k=f+40|0;l=f+32|0;m=f+24|0;n=f+16|0;o=f+8|0;p=f;q=f+68|0;r=f+64|0;s=f+60|0;t=f+56|0;u=f+52|0;c[q>>2]=b;c[r>>2]=d;c[s>>2]=e;if(!(c[s>>2]|0))La(136875,136881,1292,136913);c[(c[s>>2]|0)+28>>2]=0;c[(c[s>>2]|0)+16>>2]=c[r>>2];c[(c[s>>2]|0)+4>>2]=0;c[(c[s>>2]|0)+24>>2]=0;a:do if((c[q>>2]|0)!=0?(a[c[q>>2]>>0]|0)!=0:0)switch(a[c[q>>2]>>0]|0){case 97:{if(!(P3(c[q>>2]|0,136931,5)|0)){c[(c[s>>2]|0)+16>>2]=4;c[q>>2]=(c[q>>2]|0)+5;c[q>>2]=PG(c[q>>2]|0,c[s>>2]|0)|0;r=c[q>>2]|0;c[p>>2]=u;e=(l3(r,175023,p)|0)>0;if(!(e&(c[u>>2]|0)>0))break a;c[(c[s>>2]|0)+4>>2]=c[u>>2];break a}if(P3(c[q>>2]|0,136937,6)|0)break a;c[(c[s>>2]|0)+16>>2]=5;e=(c[q>>2]|0)+5|0;c[o>>2]=t;if((l3(e,136944,o)|0)>0&+g[t>>2]>0.0){g[c[s>>2]>>2]=+g[t>>2];break a}else{g[c[s>>2]>>2]=1.0;break a}break}case 99:{if((a[c[q>>2]>>0]|0)!=(a[145613]|0))break a;if(J3(c[q>>2]|0,145613)|0)break a;c[(c[s>>2]|0)+16>>2]=1;break a;break}case 103:{if((a[c[q>>2]>>0]|0)!=(a[149098]|0))break a;if(J3(c[q>>2]|0,149098)|0)break a;c[(c[s>>2]|0)+16>>2]=3;break a;break}case 110:{if((a[c[q>>2]>>0]|0)!=(a[149084]|0))break a;if(J3(c[q>>2]|0,149084)|0)break a;c[(c[s>>2]|0)+16>>2]=2;break a;break}default:break a}while(0);if(!(a[138998]|0)){v=c[s>>2]|0;w=v+16|0;x=c[w>>2]|0;i=f;return x|0}Y2(c[24742]|0,136947,n)|0;n=c[24742]|0;c[m>>2]=QG(c[(c[s>>2]|0)+16>>2]|0)|0;Y2(n,136959,m)|0;if((c[(c[s>>2]|0)+16>>2]|0)==5){m=c[24742]|0;h[l>>3]=+g[c[s>>2]>>2];Y2(m,136972,l)|0}l=c[24742]|0;c[k>>2]=c[(c[s>>2]|0)+4>>2];Y2(l,136985,k)|0;k=c[24742]|0;c[j>>2]=c[(c[s>>2]|0)+28>>2];Y2(k,136998,j)|0;v=c[s>>2]|0;w=v+16|0;x=c[w>>2]|0;i=f;return x|0}function IG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;d=yA(c[f>>2]|0,137011)|0;f=HG(d,c[g>>2]|0,c[h>>2]|0)|0;i=e;return f|0}function JG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f;h=f+24|0;j=f+20|0;k=f+16|0;l=f+12|0;m=f+8|0;n=f+4|0;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[n>>2]=c[j>>2];j=yA(c[h>>2]|0,137020)|0;c[l>>2]=j;if(!j){o=c[n>>2]|0;i=f;return o|0}j=c[l>>2]|0;c[g>>2]=m;h=(l3(j,175023,g)|0)==1;if(h&(c[m>>2]|0)>=0){c[n>>2]=c[m>>2];o=c[n>>2]|0;i=f;return o|0}if((a[c[l>>2]>>0]|0)!=116?(a[c[l>>2]>>0]|0)!=84:0){o=c[n>>2]|0;i=f;return o|0}c[n>>2]=c[k>>2];o=c[n>>2]|0;i=f;return o|0}function KG(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0;j=i;i=i+224|0;k=j+208|0;l=j+64|0;m=j+48|0;n=j+40|0;o=j;p=j+200|0;q=j+196|0;r=j+192|0;s=j+188|0;t=j+184|0;u=j+180|0;v=j+176|0;w=j+172|0;x=j+168|0;y=j+164|0;z=j+160|0;A=j+156|0;B=j+152|0;C=j+136|0;D=j+120|0;E=j+112|0;F=j+104|0;G=j+100|0;H=j+96|0;c[q>>2]=b;c[r>>2]=e;c[s>>2]=f;c[t>>2]=g;c[A>>2]=c[(c[t>>2]|0)+20>>2];c[B>>2]=0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;c[D+12>>2]=0;if((c[q>>2]|0)<=0){c[p>>2]=0;I=c[p>>2]|0;i=j;return I|0}c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break;c[G>>2]=c[(c[r>>2]|0)+(c[z>>2]<<2)>>2];BO(c[G>>2]|0);if((c[A>>2]|0)!=0?(d[(c[A>>2]|0)+(c[z>>2]|0)>>0]|0)!=0:0){J=+h[(c[(c[G>>2]|0)+8>>2]|0)+16>>3];c[C>>2]=~~(+h[(c[(c[G>>2]|0)+8>>2]|0)+16>>3]>=0.0?J+.5:J-.5);J=+h[(c[(c[G>>2]|0)+8>>2]|0)+16+8>>3];c[C+4>>2]=~~(+h[(c[(c[G>>2]|0)+8>>2]|0)+16+8>>3]>=0.0?J+.5:J-.5);J=+h[(c[(c[G>>2]|0)+8>>2]|0)+16+16>>3];c[C+8>>2]=~~(+h[(c[(c[G>>2]|0)+8>>2]|0)+16+16>>3]>=0.0?J+.5:J-.5);J=+h[(c[(c[G>>2]|0)+8>>2]|0)+16+16+8>>3];c[C+8+4>>2]=~~(+h[(c[(c[G>>2]|0)+8>>2]|0)+16+16+8>>3]>=0.0?J+.5:J-.5);if(c[B>>2]|0){c[D>>2]=(c[C>>2]|0)<(c[D>>2]|0)?c[C>>2]|0:c[D>>2]|0;c[D+4>>2]=(c[C+4>>2]|0)<(c[D+4>>2]|0)?c[C+4>>2]|0:c[D+4>>2]|0;c[D+8>>2]=(c[C+8>>2]|0)>(c[D+8>>2]|0)?c[C+8>>2]|0:c[D+8>>2]|0;if((c[C+8+4>>2]|0)>(c[D+8+4>>2]|0))K=c[C+8+4>>2]|0;else K=c[D+8+4>>2]|0;c[D+8+4>>2]=K}else{c[D>>2]=c[C>>2];c[D+4>>2]=c[C+4>>2];c[D+8>>2]=c[C+8>>2];c[D+12>>2]=c[C+12>>2]}c[B>>2]=(c[B>>2]|0)+1}if((d[138998]|0)>2){g=c[24742]|0;f=wB(c[G>>2]|0)|0;J=+h[(c[(c[G>>2]|0)+8>>2]|0)+16>>3];L=+h[(c[(c[G>>2]|0)+8>>2]|0)+16+8>>3];M=+h[(c[(c[G>>2]|0)+8>>2]|0)+16+16>>3];N=+h[(c[(c[G>>2]|0)+8>>2]|0)+16+16+8>>3];c[o>>2]=f;h[o+8>>3]=J;h[o+16>>3]=L;h[o+24>>3]=M;h[o+32>>3]=N;Y2(g,137319,o)|0}c[z>>2]=(c[z>>2]|0)+1}c[F>>2]=cK(c[q>>2]<<5)|0;c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break;o=(c[F>>2]|0)+(c[z>>2]<<5)|0;G=(c[(c[(c[r>>2]|0)+(c[z>>2]<<2)>>2]|0)+8>>2]|0)+16|0;c[o>>2]=c[G>>2];c[o+4>>2]=c[G+4>>2];c[o+8>>2]=c[G+8>>2];c[o+12>>2]=c[G+12>>2];c[o+16>>2]=c[G+16>>2];c[o+20>>2]=c[G+20>>2];c[o+24>>2]=c[G+24>>2];c[o+28>>2]=c[G+28>>2];c[z>>2]=(c[z>>2]|0)+1}c[u>>2]=RG(c[q>>2]|0,c[F>>2]|0,c[(c[t>>2]|0)+8>>2]|0)|0;if(a[138998]|0){G=c[24742]|0;c[n>>2]=c[u>>2];Y2(G,137035,n)|0}if((c[u>>2]|0)<=0){c[p>>2]=0;I=c[p>>2]|0;i=j;return I|0}if(c[A>>2]|0){c[E>>2]=((c[D>>2]|0)+(c[D+8>>2]|0)|0)/2|0;c[E+4>>2]=((c[D+4>>2]|0)+(c[D+8+4>>2]|0)|0)/2|0}else{c[E+4>>2]=0;c[E>>2]=0}c[v>>2]=bK(c[q>>2]<<4)|0;c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break;c[H>>2]=c[(c[r>>2]|0)+(c[z>>2]<<2)>>2];c[(c[v>>2]|0)+(c[z>>2]<<4)+12>>2]=c[z>>2];if((c[(c[t>>2]|0)+16>>2]|0)!=3){D=c[s>>2]|0;n=c[(c[r>>2]|0)+(c[z>>2]<<2)>>2]|0;G=(c[v>>2]|0)+(c[z>>2]<<4)|0;o=c[u>>2]|0;B=c[t>>2]|0;c[k>>2]=c[E>>2];c[k+4>>2]=c[E+4>>2];if(YG(D,n,G,o,B,k)|0){O=32;break}}else{B=(c[(c[H>>2]|0)+8>>2]|0)+16|0;o=(c[v>>2]|0)+(c[z>>2]<<4)|0;G=c[u>>2]|0;n=c[(c[t>>2]|0)+8>>2]|0;D=wB(c[H>>2]|0)|0;c[l>>2]=c[B>>2];c[l+4>>2]=c[B+4>>2];c[l+8>>2]=c[B+8>>2];c[l+12>>2]=c[B+12>>2];c[l+16>>2]=c[B+16>>2];c[l+20>>2]=c[B+20>>2];c[l+24>>2]=c[B+24>>2];c[l+28>>2]=c[B+28>>2];c[k>>2]=c[E>>2];c[k+4>>2]=c[E+4>>2];SG(l,o,G,n,k,D)}c[z>>2]=(c[z>>2]|0)+1}if((O|0)==32){c[p>>2]=0;I=c[p>>2]|0;i=j;return I|0}c[w>>2]=bK(c[q>>2]<<2)|0;c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break;c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]=(c[v>>2]|0)+(c[z>>2]<<4);c[z>>2]=(c[z>>2]|0)+1}w3(c[w>>2]|0,c[q>>2]|0,4,89);c[y>>2]=VK()|0;c[x>>2]=bK(c[q>>2]<<3)|0;O=(c[A>>2]|0)!=0;c[z>>2]=0;a:do if(O){while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break;if(a[(c[A>>2]|0)+(c[z>>2]|0)>>0]|0){l=c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]|0;H=c[y>>2]|0;r=(c[x>>2]|0)+(c[(c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]|0)+12>>2]<<3)|0;c[k>>2]=c[E>>2];c[k+4>>2]=c[E+4>>2];ZG(l,H,r,k)}c[z>>2]=(c[z>>2]|0)+1}c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break a;if(!(a[(c[A>>2]|0)+(c[z>>2]|0)>>0]|0))UG(c[z>>2]|0,c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]|0,c[y>>2]|0,(c[x>>2]|0)+(c[(c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]|0)+12>>2]<<3)|0,c[u>>2]|0,c[(c[t>>2]|0)+8>>2]|0,c[F>>2]|0);c[z>>2]=(c[z>>2]|0)+1}}else while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break a;UG(c[z>>2]|0,c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]|0,c[y>>2]|0,(c[x>>2]|0)+(c[(c[(c[w>>2]|0)+(c[z>>2]<<2)>>2]|0)+12>>2]<<3)|0,c[u>>2]|0,c[(c[t>>2]|0)+8>>2]|0,c[F>>2]|0);c[z>>2]=(c[z>>2]|0)+1}while(0);O4(c[w>>2]|0);c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break;O4(c[(c[v>>2]|0)+(c[z>>2]<<4)+4>>2]|0);c[z>>2]=(c[z>>2]|0)+1}O4(c[v>>2]|0);WK(c[y>>2]|0);O4(c[F>>2]|0);b:do if((d[138998]|0)>1){c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[q>>2]|0))break b;F=c[24742]|0;y=c[(c[x>>2]|0)+(c[z>>2]<<3)>>2]|0;v=c[(c[x>>2]|0)+(c[z>>2]<<3)+4>>2]|0;c[m>>2]=c[z>>2];c[m+4>>2]=y;c[m+8>>2]=v;Y2(F,137051,m)|0;c[z>>2]=(c[z>>2]|0)+1}}while(0);c[p>>2]=c[x>>2];I=c[p>>2]|0;i=j;return I|0}function LG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0;f=i;i=i+144|0;g=f+56|0;j=f+132|0;k=f+128|0;l=f+124|0;m=f+120|0;n=f+116|0;o=f+112|0;p=f+108|0;q=f+104|0;r=f+100|0;s=f+96|0;t=f+92|0;u=f+88|0;v=f+84|0;w=f+48|0;x=f+40|0;y=f+32|0;z=f+80|0;A=f;B=f+76|0;C=f+72|0;D=f+68|0;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[n>>2]=0;c[z>>2]=bK(c[j>>2]<<3)|0;c[B>>2]=c[(c[l>>2]|0)+4>>2];do if(c[(c[l>>2]|0)+28>>2]&1){c[C>>2]=0;if((c[B>>2]|0)>0){c[n>>2]=c[B>>2];c[o>>2]=((c[j>>2]|0)+((c[n>>2]|0)-1)|0)/(c[n>>2]|0)|0;break}else{c[n>>2]=~~+Z(+(+O(+(+(c[j>>2]|0)))));c[o>>2]=((c[j>>2]|0)+((c[n>>2]|0)-1)|0)/(c[n>>2]|0)|0;break}}else{c[C>>2]=1;if((c[B>>2]|0)>0){c[o>>2]=c[B>>2];c[n>>2]=((c[j>>2]|0)+((c[o>>2]|0)-1)|0)/(c[o>>2]|0)|0;break}else{c[o>>2]=~~+Z(+(+O(+(+(c[j>>2]|0)))));c[n>>2]=((c[j>>2]|0)+((c[o>>2]|0)-1)|0)/(c[o>>2]|0)|0;break}}while(0);if(a[138998]|0){B=c[24742]|0;e=c[n>>2]|0;d=c[o>>2]|0;c[g>>2]=(c[C>>2]|0)!=0?137258:137268;c[g+4>>2]=e;c[g+8>>2]=d;Y2(B,137281,g)|0}c[u>>2]=bK((c[o>>2]|0)+1<<3)|0;c[v>>2]=bK((c[n>>2]|0)+1<<3)|0;g=bK((c[j>>2]|0)*24|0)|0;c[r>>2]=g;c[s>>2]=g;c[m>>2]=0;while(1){if((c[m>>2]|0)>=(c[j>>2]|0))break;g=(c[k>>2]|0)+(c[m>>2]<<5)|0;c[A>>2]=c[g>>2];c[A+4>>2]=c[g+4>>2];c[A+8>>2]=c[g+8>>2];c[A+12>>2]=c[g+12>>2];c[A+16>>2]=c[g+16>>2];c[A+20>>2]=c[g+20>>2];c[A+24>>2]=c[g+24>>2];c[A+28>>2]=c[g+28>>2];h[c[s>>2]>>3]=+h[A+16>>3]-+h[A>>3]+ +((c[(c[l>>2]|0)+8>>2]|0)>>>0);h[(c[s>>2]|0)+8>>3]=+h[A+16+8>>3]-+h[A+8>>3]+ +((c[(c[l>>2]|0)+8>>2]|0)>>>0);c[(c[s>>2]|0)+16>>2]=c[m>>2];c[m>>2]=(c[m>>2]|0)+1;c[s>>2]=(c[s>>2]|0)+24}c[t>>2]=bK(c[j>>2]<<2)|0;c[m>>2]=0;while(1){if((c[m>>2]|0)>=(c[j>>2]|0))break;c[(c[t>>2]|0)+(c[m>>2]<<2)>>2]=(c[r>>2]|0)+((c[m>>2]|0)*24|0);c[m>>2]=(c[m>>2]|0)+1}g=c[l>>2]|0;if(!(c[(c[l>>2]|0)+24>>2]|0)){if(!(c[g+28>>2]&64))w3(c[t>>2]|0,c[j>>2]|0,4,91)}else{c[13644]=c[g+24>>2];w3(c[t>>2]|0,c[j>>2]|0,4,90)}c[q>>2]=0;c[p>>2]=0;c[m>>2]=0;while(1){if((c[m>>2]|0)>=(c[j>>2]|0))break;c[s>>2]=c[(c[t>>2]|0)+(c[m>>2]<<2)>>2];if(+h[(c[u>>2]|0)+(c[q>>2]<<3)>>3]>+h[c[s>>2]>>3])E=+h[(c[u>>2]|0)+(c[q>>2]<<3)>>3];else E=+h[c[s>>2]>>3];h[(c[u>>2]|0)+(c[q>>2]<<3)>>3]=E;if(+h[(c[v>>2]|0)+(c[p>>2]<<3)>>3]>+h[(c[s>>2]|0)+8>>3])F=+h[(c[v>>2]|0)+(c[p>>2]<<3)>>3];else F=+h[(c[s>>2]|0)+8>>3];h[(c[v>>2]|0)+(c[p>>2]<<3)>>3]=F;if(c[C>>2]|0){c[q>>2]=(c[q>>2]|0)+1;if((c[q>>2]|0)==(c[o>>2]|0)){c[q>>2]=0;c[p>>2]=(c[p>>2]|0)+1}}else{c[p>>2]=(c[p>>2]|0)+1;if((c[p>>2]|0)==(c[n>>2]|0)){c[p>>2]=0;c[q>>2]=(c[q>>2]|0)+1}}c[m>>2]=(c[m>>2]|0)+1;c[s>>2]=(c[s>>2]|0)+24}h[x>>3]=0.0;c[m>>2]=0;while(1){if((c[m>>2]|0)>(c[o>>2]|0))break;h[w>>3]=+h[(c[u>>2]|0)+(c[m>>2]<<3)>>3];h[(c[u>>2]|0)+(c[m>>2]<<3)>>3]=+h[x>>3];h[x>>3]=+h[x>>3]+ +h[w>>3];c[m>>2]=(c[m>>2]|0)+1}h[y>>3]=0.0;c[m>>2]=c[n>>2];while(1){if(0>=(c[m>>2]|0))break;h[w>>3]=+h[(c[v>>2]|0)+((c[m>>2]|0)-1<<3)>>3];h[(c[v>>2]|0)+(c[m>>2]<<3)>>3]=+h[y>>3];h[y>>3]=+h[y>>3]+ +h[w>>3];c[m>>2]=(c[m>>2]|0)+-1}h[c[v>>2]>>3]=+h[y>>3];c[q>>2]=0;c[p>>2]=0;c[m>>2]=0;while(1){if((c[m>>2]|0)>=(c[j>>2]|0))break;c[s>>2]=c[(c[t>>2]|0)+(c[m>>2]<<2)>>2];c[D>>2]=c[(c[s>>2]|0)+16>>2];y=(c[k>>2]|0)+(c[D>>2]<<5)|0;c[A>>2]=c[y>>2];c[A+4>>2]=c[y+4>>2];c[A+8>>2]=c[y+8>>2];c[A+12>>2]=c[y+12>>2];c[A+16>>2]=c[y+16>>2];c[A+20>>2]=c[y+20>>2];c[A+24>>2]=c[y+24>>2];c[A+28>>2]=c[y+28>>2];do if(!(c[(c[l>>2]|0)+28>>2]&4)){y=c[q>>2]|0;if(c[(c[l>>2]|0)+28>>2]&8){c[(c[z>>2]|0)+(c[D>>2]<<3)>>2]=~~(+h[(c[u>>2]|0)+(y+1<<3)>>3]-(+h[A+16>>3]-+h[A>>3]));break}else{c[(c[z>>2]|0)+(c[D>>2]<<3)>>2]=~~((+h[(c[u>>2]|0)+(y<<3)>>3]+ +h[(c[u>>2]|0)+((c[q>>2]|0)+1<<3)>>3]-+h[A+16>>3]-+h[A>>3])/2.0);break}}else c[(c[z>>2]|0)+(c[D>>2]<<3)>>2]=~~+h[(c[u>>2]|0)+(c[q>>2]<<3)>>3];while(0);do if(!(c[(c[l>>2]|0)+28>>2]&16)){y=c[p>>2]|0;if(c[(c[l>>2]|0)+28>>2]&32){c[(c[z>>2]|0)+(c[D>>2]<<3)+4>>2]=~~+h[(c[v>>2]|0)+(y+1<<3)>>3];break}else{c[(c[z>>2]|0)+(c[D>>2]<<3)+4>>2]=~~((+h[(c[v>>2]|0)+(y<<3)>>3]+ +h[(c[v>>2]|0)+((c[p>>2]|0)+1<<3)>>3]-+h[A+16+8>>3]-+h[A+8>>3])/2.0);break}}else c[(c[z>>2]|0)+(c[D>>2]<<3)+4>>2]=~~(+h[(c[v>>2]|0)+(c[p>>2]<<3)>>3]-(+h[A+16+8>>3]-+h[A+8>>3]));while(0);if(c[C>>2]|0){c[q>>2]=(c[q>>2]|0)+1;if((c[q>>2]|0)==(c[o>>2]|0)){c[q>>2]=0;c[p>>2]=(c[p>>2]|0)+1}}else{c[p>>2]=(c[p>>2]|0)+1;if((c[p>>2]|0)==(c[n>>2]|0)){c[p>>2]=0;c[q>>2]=(c[q>>2]|0)+1}}c[m>>2]=(c[m>>2]|0)+1;c[s>>2]=(c[s>>2]|0)+24}O4(c[r>>2]|0);O4(c[t>>2]|0);O4(c[u>>2]|0);O4(c[v>>2]|0);i=f;return c[z>>2]|0}function MG(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;g=i;i=i+112|0;h=g+104|0;j=g+24|0;k=g+8|0;l=g;m=g+100|0;n=g+96|0;o=g+92|0;p=g+88|0;q=g+84|0;r=g+80|0;s=g+76|0;t=g+72|0;u=g+68|0;v=g+64|0;w=g+56|0;c[n>>2]=b;c[o>>2]=e;c[p>>2]=f;c[q>>2]=RG(c[n>>2]|0,c[o>>2]|0,c[(c[p>>2]|0)+8>>2]|0)|0;if(a[138998]|0){f=c[24742]|0;c[l>>2]=c[q>>2];Y2(f,137035,l)|0}if((c[q>>2]|0)<=0){c[m>>2]=0;x=c[m>>2]|0;i=g;return x|0}c[w+4>>2]=0;c[w>>2]=0;c[r>>2]=bK(c[n>>2]<<4)|0;c[v>>2]=0;while(1){if((c[v>>2]|0)>=(c[n>>2]|0))break;c[(c[r>>2]|0)+(c[v>>2]<<4)+12>>2]=c[v>>2];l=(c[o>>2]|0)+(c[v>>2]<<5)|0;f=(c[r>>2]|0)+(c[v>>2]<<4)|0;e=c[q>>2]|0;b=c[(c[p>>2]|0)+8>>2]|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];c[j+16>>2]=c[l+16>>2];c[j+20>>2]=c[l+20>>2];c[j+24>>2]=c[l+24>>2];c[j+28>>2]=c[l+28>>2];c[h>>2]=c[w>>2];c[h+4>>2]=c[w+4>>2];SG(j,f,e,b,h,178518);c[v>>2]=(c[v>>2]|0)+1}c[s>>2]=bK(c[n>>2]<<2)|0;c[v>>2]=0;while(1){if((c[v>>2]|0)>=(c[n>>2]|0))break;c[(c[s>>2]|0)+(c[v>>2]<<2)>>2]=(c[r>>2]|0)+(c[v>>2]<<4);c[v>>2]=(c[v>>2]|0)+1}w3(c[s>>2]|0,c[n>>2]|0,4,89);c[u>>2]=VK()|0;c[t>>2]=bK(c[n>>2]<<3)|0;c[v>>2]=0;while(1){if((c[v>>2]|0)>=(c[n>>2]|0))break;UG(c[v>>2]|0,c[(c[s>>2]|0)+(c[v>>2]<<2)>>2]|0,c[u>>2]|0,(c[t>>2]|0)+(c[(c[(c[s>>2]|0)+(c[v>>2]<<2)>>2]|0)+12>>2]<<3)|0,c[q>>2]|0,c[(c[p>>2]|0)+8>>2]|0,c[o>>2]|0);c[v>>2]=(c[v>>2]|0)+1}O4(c[s>>2]|0);c[v>>2]=0;while(1){if((c[v>>2]|0)>=(c[n>>2]|0))break;O4(c[(c[r>>2]|0)+(c[v>>2]<<4)+4>>2]|0);c[v>>2]=(c[v>>2]|0)+1}O4(c[r>>2]|0);WK(c[u>>2]|0);a:do if((d[138998]|0)>1){c[v>>2]=0;while(1){if((c[v>>2]|0)>=(c[n>>2]|0))break a;u=c[24742]|0;r=c[(c[t>>2]|0)+(c[v>>2]<<3)>>2]|0;s=c[(c[t>>2]|0)+(c[v>>2]<<3)+4>>2]|0;c[k>>2]=c[v>>2];c[k+4>>2]=r;c[k+8>>2]=s;Y2(u,137051,k)|0;c[v>>2]=(c[v>>2]|0)+1}}while(0);c[m>>2]=c[t>>2];x=c[m>>2]|0;i=g;return x|0}function NG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0;e=i;i=i+80|0;f=e+64|0;g=e+60|0;j=e+56|0;k=e+52|0;l=e+48|0;m=e;c[f>>2]=a;c[g>>2]=b;c[j>>2]=d;if(c[(c[(c[f>>2]|0)+8>>2]|0)+96>>2]|0){d=(c[(c[(c[f>>2]|0)+8>>2]|0)+96>>2]|0)+56|0;h[d>>3]=+h[d>>3]+ +(c[g>>2]|0);d=(c[(c[(c[f>>2]|0)+8>>2]|0)+96>>2]|0)+56+8|0;h[d>>3]=+h[d>>3]+ +(c[j>>2]|0)}if(c[(c[(c[f>>2]|0)+8>>2]|0)+108>>2]|0){d=(c[(c[(c[f>>2]|0)+8>>2]|0)+108>>2]|0)+56|0;h[d>>3]=+h[d>>3]+ +(c[g>>2]|0);d=(c[(c[(c[f>>2]|0)+8>>2]|0)+108>>2]|0)+56+8|0;h[d>>3]=+h[d>>3]+ +(c[j>>2]|0)}if(c[(c[(c[f>>2]|0)+8>>2]|0)+100>>2]|0){d=(c[(c[(c[f>>2]|0)+8>>2]|0)+100>>2]|0)+56|0;h[d>>3]=+h[d>>3]+ +(c[g>>2]|0);d=(c[(c[(c[f>>2]|0)+8>>2]|0)+100>>2]|0)+56+8|0;h[d>>3]=+h[d>>3]+ +(c[j>>2]|0)}if(c[(c[(c[f>>2]|0)+8>>2]|0)+104>>2]|0){d=(c[(c[(c[f>>2]|0)+8>>2]|0)+104>>2]|0)+56|0;h[d>>3]=+h[d>>3]+ +(c[g>>2]|0);d=(c[(c[(c[f>>2]|0)+8>>2]|0)+104>>2]|0)+56+8|0;h[d>>3]=+h[d>>3]+ +(c[j>>2]|0)}if(!(c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]|0)){i=e;return}c[k>>2]=0;while(1){if((c[k>>2]|0)>=(c[(c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0))break;d=m;b=(c[c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[k>>2]|0)*48|0)|0;a=d+48|0;do{c[d>>2]=c[b>>2];d=d+4|0;b=b+4|0}while((d|0)<(a|0));c[l>>2]=0;while(1){if((c[l>>2]|0)>=(c[m+4>>2]|0))break;b=(c[m>>2]|0)+(c[l>>2]<<4)|0;h[b>>3]=+h[b>>3]+ +(c[g>>2]|0);b=(c[m>>2]|0)+(c[l>>2]<<4)+8|0;h[b>>3]=+h[b>>3]+ +(c[j>>2]|0);c[l>>2]=(c[l>>2]|0)+1}if(c[m+8>>2]|0){b=(c[c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[k>>2]|0)*48|0)+16|0;h[b>>3]=+h[b>>3]+ +(c[g>>2]|0);b=(c[c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[k>>2]|0)*48|0)+16+8|0;h[b>>3]=+h[b>>3]+ +(c[j>>2]|0)}if(c[m+12>>2]|0){b=(c[c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[k>>2]|0)*48|0)+32|0;h[b>>3]=+h[b>>3]+ +(c[g>>2]|0);b=(c[c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[k>>2]|0)*48|0)+32+8|0;h[b>>3]=+h[b>>3]+ +(c[j>>2]|0)}c[k>>2]=(c[k>>2]|0)+1}i=e;return}function OG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0;e=i;i=i+64|0;f=e+48|0;g=e+44|0;j=e+40|0;k=e+36|0;l=e;m=e+32|0;c[f>>2]=a;c[g>>2]=b;c[j>>2]=d;d=(c[(c[f>>2]|0)+8>>2]|0)+16|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];c[l+16>>2]=c[d+16>>2];c[l+20>>2]=c[d+20>>2];c[l+24>>2]=c[d+24>>2];c[l+28>>2]=c[d+28>>2];d=(c[(c[f>>2]|0)+8>>2]|0)+16|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];c[l+16>>2]=c[d+16>>2];c[l+20>>2]=c[d+20>>2];c[l+24>>2]=c[d+24>>2];c[l+28>>2]=c[d+28>>2];h[l>>3]=+h[l>>3]+ +(c[g>>2]|0);d=l+16|0;h[d>>3]=+h[d>>3]+ +(c[g>>2]|0);d=l+8|0;h[d>>3]=+h[d>>3]+ +(c[j>>2]|0);d=l+16+8|0;h[d>>3]=+h[d>>3]+ +(c[j>>2]|0);d=(c[(c[f>>2]|0)+8>>2]|0)+16|0;c[d>>2]=c[l>>2];c[d+4>>2]=c[l+4>>2];c[d+8>>2]=c[l+8>>2];c[d+12>>2]=c[l+12>>2];c[d+16>>2]=c[l+16>>2];c[d+20>>2]=c[l+20>>2];c[d+24>>2]=c[l+24>>2];c[d+28>>2]=c[l+28>>2];if(c[(c[(c[f>>2]|0)+8>>2]|0)+12>>2]|0){l=(c[(c[(c[f>>2]|0)+8>>2]|0)+12>>2]|0)+56|0;h[l>>3]=+h[l>>3]+ +(c[g>>2]|0);l=(c[(c[(c[f>>2]|0)+8>>2]|0)+12>>2]|0)+56+8|0;h[l>>3]=+h[l>>3]+ +(c[j>>2]|0)}c[m>>2]=1;while(1){if((c[m>>2]|0)>(c[(c[(c[f>>2]|0)+8>>2]|0)+180>>2]|0))break;c[k>>2]=c[(c[(c[(c[f>>2]|0)+8>>2]|0)+184>>2]|0)+(c[m>>2]<<2)>>2];OG(c[k>>2]|0,c[g>>2]|0,c[j>>2]|0);c[m>>2]=(c[m>>2]|0)+1}i=e;return}function PG(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[g>>2]=b;c[h>>2]=d;d=c[g>>2]|0;if((a[c[g>>2]>>0]|0)!=95){c[f>>2]=d;l=c[f>>2]|0;i=e;return l|0}c[g>>2]=d+1;c[k>>2]=1;a:while(1){if(!(c[k>>2]|0))break;d=a[c[g>>2]>>0]|0;c[j>>2]=d;if(!d)break;switch(c[j>>2]|0){case 99:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|1;c[g>>2]=(c[g>>2]|0)+1;continue a;break}case 105:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|64;c[g>>2]=(c[g>>2]|0)+1;continue a;break}case 117:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|2;c[g>>2]=(c[g>>2]|0)+1;continue a;break}case 116:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|16;c[g>>2]=(c[g>>2]|0)+1;continue a;break}case 98:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|32;c[g>>2]=(c[g>>2]|0)+1;continue a;break}case 108:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|4;c[g>>2]=(c[g>>2]|0)+1;continue a;break}case 114:{d=(c[h>>2]|0)+28|0;c[d>>2]=c[d>>2]|8;c[g>>2]=(c[g>>2]|0)+1;continue a;break}default:{c[k>>2]=0;continue a}}}c[f>>2]=c[g>>2];l=c[f>>2]|0;i=e;return l|0}function QG(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;switch(c[d>>2]|0){case 1:{c[e>>2]=145613;break}case 2:{c[e>>2]=149084;break}case 3:{c[e>>2]=149098;break}case 4:{c[e>>2]=136931;break}case 5:{c[e>>2]=136937;break}default:c[e>>2]=137025}i=b;return c[e>>2]|0}function RG(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0.0,G=0.0,H=0.0;f=i;i=i+240|0;g=f+192|0;j=f+160|0;k=f+120|0;l=f+112|0;m=f+104|0;n=f+228|0;o=f+224|0;p=f+220|0;q=f+216|0;r=f+96|0;s=f+88|0;t=f+80|0;u=f+72|0;v=f+64|0;w=f+56|0;x=f+48|0;y=f+40|0;z=f+32|0;A=f+212|0;B=f+208|0;C=f;c[o>>2]=a;c[p>>2]=b;c[q>>2]=e;h[t>>3]=+(((c[o>>2]|0)*100|0)-1|0);h[v>>3]=0.0;h[u>>3]=0.0;c[A>>2]=0;while(1){if((c[A>>2]|0)>=(c[o>>2]|0))break;e=(c[p>>2]|0)+(c[A>>2]<<5)|0;c[C>>2]=c[e>>2];c[C+4>>2]=c[e+4>>2];c[C+8>>2]=c[e+8>>2];c[C+12>>2]=c[e+12>>2];c[C+16>>2]=c[e+16>>2];c[C+20>>2]=c[e+20>>2];c[C+24>>2]=c[e+24>>2];c[C+28>>2]=c[e+28>>2];h[y>>3]=+h[C+16>>3]-+h[C>>3]+ +(c[q>>2]<<1|0);h[z>>3]=+h[C+16+8>>3]-+h[C+8>>3]+ +(c[q>>2]<<1|0);h[u>>3]=+h[u>>3]-(+h[y>>3]+ +h[z>>3]);h[v>>3]=+h[v>>3]-+h[y>>3]*+h[z>>3];c[A>>2]=(c[A>>2]|0)+1}h[w>>3]=+h[u>>3]*+h[u>>3]-+h[t>>3]*4.0*+h[v>>3];D=+h[w>>3];if(+h[w>>3]<0.0){h[m>>3]=D;$z(1,137141,m)|0;c[n>>2]=-1;E=c[n>>2]|0;i=f;return E|0}h[x>>3]=+O(+D);h[r>>3]=(-+h[u>>3]+ +h[x>>3])/(+h[t>>3]*2.0);h[s>>3]=(-+h[u>>3]-+h[x>>3])/(+h[t>>3]*2.0);m=~~+h[r>>3];c[B>>2]=m;c[B>>2]=(c[B>>2]|0)==0?1:m;if((d[138998]|0|0)>2){Y2(c[24742]|0,137168,l)|0;l=c[24742]|0;D=+h[u>>3];F=+h[v>>3];G=+h[w>>3];H=+h[x>>3];h[k>>3]=+h[t>>3];h[k+8>>3]=D;h[k+16>>3]=F;h[k+24>>3]=G;h[k+32>>3]=H;Y2(l,137196,k)|0;k=c[24742]|0;H=+h[r>>3];l=~~+h[s>>3];G=+h[s>>3];c[j>>2]=c[B>>2];h[j+8>>3]=H;c[j+16>>2]=l;h[j+24>>3]=G;Y2(k,137222,j)|0;j=c[24742]|0;G=+h[t>>3]*+h[s>>3]*+h[s>>3]+ +h[u>>3]*+h[s>>3]+ +h[v>>3];h[g>>3]=+h[t>>3]*+h[r>>3]*+h[r>>3]+ +h[u>>3]*+h[r>>3]+ +h[v>>3];h[g+8>>3]=G;Y2(j,137244,g)|0}c[n>>2]=c[B>>2];E=c[n>>2]|0;i=f;return E|0}function SG(a,b,e,f,g,j){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0;k=i;i=i+112|0;l=k+16|0;m=k;n=k+96|0;o=k+92|0;p=k+88|0;q=k+84|0;r=k+80|0;s=k+76|0;t=k+72|0;u=k+64|0;v=k+56|0;w=k+40|0;x=k+32|0;y=k+28|0;z=k+24|0;c[n>>2]=b;c[o>>2]=e;c[p>>2]=f;c[q>>2]=j;A=+h[a>>3];c[w>>2]=~~(+h[a>>3]>=0.0?A+.5:A-.5);A=+h[a+8>>3];c[w+4>>2]=~~(+h[a+8>>3]>=0.0?A+.5:A-.5);A=+h[a+16>>3];c[w+8>>2]=~~(+h[a+16>>3]>=0.0?A+.5:A-.5);A=+h[a+16+8>>3];c[w+8+4>>2]=~~(+h[a+16+8>>3]>=0.0?A+.5:A-.5);c[r>>2]=VK()|0;c[v>>2]=(c[g>>2]|0)-(c[p>>2]|0);c[v+4>>2]=(c[g+4>>2]|0)-(c[p>>2]|0);c[u>>2]=(c[g>>2]|0)+(c[w+8>>2]|0)-(c[w>>2]|0)+(c[p>>2]|0);c[u+4>>2]=(c[g+4>>2]|0)+(c[w+8+4>>2]|0)-(c[w+4>>2]|0)+(c[p>>2]|0);w=c[v>>2]|0;if((c[v>>2]|0)>=0)B=(w|0)/(c[o>>2]|0)|0;else B=((w+1|0)/(c[o>>2]|0)|0)-1|0;c[v>>2]=B;B=c[v+4>>2]|0;if((c[v+4>>2]|0)>=0)C=(B|0)/(c[o>>2]|0)|0;else C=((B+1|0)/(c[o>>2]|0)|0)-1|0;c[v+4>>2]=C;C=c[u>>2]|0;if((c[u>>2]|0)>=0)D=(C|0)/(c[o>>2]|0)|0;else D=((C+1|0)/(c[o>>2]|0)|0)-1|0;c[u>>2]=D;D=c[u+4>>2]|0;if((c[u+4>>2]|0)>=0)E=(D|0)/(c[o>>2]|0)|0;else E=((D+1|0)/(c[o>>2]|0)|0)-1|0;c[u+4>>2]=E;c[x>>2]=c[v>>2];while(1){if((c[x>>2]|0)>(c[u>>2]|0))break;c[y>>2]=c[v+4>>2];while(1){if((c[y>>2]|0)>(c[u+4>>2]|0))break;YK(c[r>>2]|0,c[x>>2]|0,c[y>>2]|0);c[y>>2]=(c[y>>2]|0)+1}c[x>>2]=(c[x>>2]|0)+1}x=aL(c[r>>2]|0)|0;c[(c[n>>2]|0)+4>>2]=x;x=$K(c[r>>2]|0)|0;c[(c[n>>2]|0)+8>>2]=x;c[s>>2]=~~+Z(+((+h[a+16>>3]-+h[a>>3]+ +(c[p>>2]<<1|0))/+(c[o>>2]|0)));c[t>>2]=~~+Z(+((+h[a+16+8>>3]-+h[a+8>>3]+ +(c[p>>2]<<1|0))/+(c[o>>2]|0)));c[c[n>>2]>>2]=(c[s>>2]|0)+(c[t>>2]|0);if((d[138998]|0|0)<=2){F=c[r>>2]|0;WK(F);i=k;return}o=c[24742]|0;p=c[(c[n>>2]|0)+8>>2]|0;a=c[s>>2]|0;s=c[t>>2]|0;c[m>>2]=c[q>>2];c[m+4>>2]=p;c[m+8>>2]=a;c[m+12>>2]=s;Y2(o,137100,m)|0;c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[(c[n>>2]|0)+8>>2]|0))break;m=c[24742]|0;o=c[(c[(c[n>>2]|0)+4>>2]|0)+(c[z>>2]<<3)+4>>2]|0;c[l>>2]=c[(c[(c[n>>2]|0)+4>>2]|0)+(c[z>>2]<<3)>>2];c[l+4>>2]=o;Y2(m,137127,l)|0;c[z>>2]=(c[z>>2]|0)+1}F=c[r>>2]|0;WK(F);i=k;return}function TG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=c[c[e>>2]>>2];c[h>>2]=c[c[f>>2]>>2];i=d;return (c[c[h>>2]>>2]|0)-(c[c[g>>2]>>2]|0)|0}function UG(a,b,d,e,f,g,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;k=i;i=i+80|0;l=k+76|0;m=k+72|0;n=k+68|0;o=k+64|0;p=k+60|0;q=k+56|0;r=k+52|0;s=k+48|0;t=k+44|0;u=k+40|0;v=k+36|0;w=k+32|0;x=k;c[l>>2]=a;c[m>>2]=b;c[n>>2]=d;c[o>>2]=e;c[p>>2]=f;c[q>>2]=g;c[r>>2]=j;j=(c[r>>2]|0)+(c[(c[m>>2]|0)+12>>2]<<5)|0;c[x>>2]=c[j>>2];c[x+4>>2]=c[j+4>>2];c[x+8>>2]=c[j+8>>2];c[x+12>>2]=c[j+12>>2];c[x+16>>2]=c[j+16>>2];c[x+20>>2]=c[j+20>>2];c[x+24>>2]=c[j+24>>2];c[x+28>>2]=c[j+28>>2];if((c[l>>2]|0)==0?(c[u>>2]=~~+Z(+((+h[x+16>>3]-+h[x>>3]+ +(c[q>>2]<<1|0))/+(c[p>>2]|0))),c[v>>2]=~~+Z(+((+h[x+16+8>>3]-+h[x+8>>3]+ +(c[q>>2]<<1|0))/+(c[p>>2]|0))),(VG((0-(c[u>>2]|0)|0)/2|0,(0-(c[v>>2]|0)|0)/2|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0)!=0):0){i=k;return}if(VG(0,0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){i=k;return}c[u>>2]=~~+Z(+(+h[x+16>>3]-+h[x>>3]));c[v>>2]=~~+Z(+(+h[x+16+8>>3]-+h[x+8>>3]));x=(c[u>>2]|0)>=(c[v>>2]|0);c[w>>2]=1;if(x){a:while(1){c[s>>2]=0;c[t>>2]=0-(c[w>>2]|0);while(1){if((c[s>>2]|0)>=(c[w>>2]|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break a}c[s>>2]=(c[s>>2]|0)+1}while(1){if((c[t>>2]|0)>=(c[w>>2]|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break a}c[t>>2]=(c[t>>2]|0)+1}while(1){if((c[s>>2]|0)<=(0-(c[w>>2]|0)|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break a}c[s>>2]=(c[s>>2]|0)+-1}while(1){if((c[t>>2]|0)<=(0-(c[w>>2]|0)|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break a}c[t>>2]=(c[t>>2]|0)+-1}while(1){if((c[s>>2]|0)>=0)break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break a}c[s>>2]=(c[s>>2]|0)+1}c[w>>2]=(c[w>>2]|0)+1}if((y|0)==39){i=k;return}}else{b:while(1){c[t>>2]=0;c[s>>2]=0-(c[w>>2]|0);while(1){if((c[t>>2]|0)<=(0-(c[w>>2]|0)|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break b}c[t>>2]=(c[t>>2]|0)+-1}while(1){if((c[s>>2]|0)>=(c[w>>2]|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break b}c[s>>2]=(c[s>>2]|0)+1}while(1){if((c[t>>2]|0)>=(c[w>>2]|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break b}c[t>>2]=(c[t>>2]|0)+1}while(1){if((c[s>>2]|0)<=(0-(c[w>>2]|0)|0))break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break b}c[s>>2]=(c[s>>2]|0)+-1}while(1){if((c[t>>2]|0)<=0)break;if(VG(c[s>>2]|0,c[t>>2]|0,c[m>>2]|0,c[n>>2]|0,c[o>>2]|0,c[p>>2]|0,c[r>>2]|0)|0){y=39;break b}c[t>>2]=(c[t>>2]|0)+-1}c[w>>2]=(c[w>>2]|0)+1}if((y|0)==39){i=k;return}}}function VG(a,b,e,f,g,j,k){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0;l=i;i=i+96|0;m=l+88|0;n=l;o=l+84|0;p=l+80|0;q=l+76|0;r=l+72|0;s=l+68|0;t=l+64|0;u=l+60|0;v=l+56|0;w=l+52|0;x=l+48|0;y=l+40|0;z=l+32|0;A=l+24|0;c[p>>2]=a;c[q>>2]=b;c[r>>2]=e;c[s>>2]=f;c[t>>2]=g;c[u>>2]=j;c[v>>2]=k;c[w>>2]=c[(c[r>>2]|0)+4>>2];c[x>>2]=c[(c[r>>2]|0)+8>>2];c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[x>>2]|0))break;k=c[w>>2]|0;c[y>>2]=c[k>>2];c[y+4>>2]=c[k+4>>2];c[y>>2]=(c[y>>2]|0)+(c[p>>2]|0);k=y+4|0;c[k>>2]=(c[k>>2]|0)+(c[q>>2]|0);k=c[s>>2]|0;c[m>>2]=c[y>>2];c[m+4>>2]=c[y+4>>2];if(ZK(k,m)|0){B=4;break}c[w>>2]=(c[w>>2]|0)+8;c[z>>2]=(c[z>>2]|0)+1}if((B|0)==4){c[o>>2]=0;C=c[o>>2]|0;i=l;return C|0}D=+h[(c[v>>2]|0)+(c[(c[r>>2]|0)+12>>2]<<5)>>3];c[A>>2]=~~(+h[(c[v>>2]|0)+(c[(c[r>>2]|0)+12>>2]<<5)>>3]>=0.0?D+.5:D-.5);D=+h[(c[v>>2]|0)+(c[(c[r>>2]|0)+12>>2]<<5)+8>>3];c[A+4>>2]=~~(+h[(c[v>>2]|0)+(c[(c[r>>2]|0)+12>>2]<<5)+8>>3]>=0.0?D+.5:D-.5);v=_(c[u>>2]|0,c[p>>2]|0)|0;c[c[t>>2]>>2]=v-(c[A>>2]|0);v=_(c[u>>2]|0,c[q>>2]|0)|0;c[(c[t>>2]|0)+4>>2]=v-(c[A+4>>2]|0);c[w>>2]=c[(c[r>>2]|0)+4>>2];c[z>>2]=0;while(1){if((c[z>>2]|0)>=(c[x>>2]|0))break;r=c[w>>2]|0;c[y>>2]=c[r>>2];c[y+4>>2]=c[r+4>>2];c[y>>2]=(c[y>>2]|0)+(c[p>>2]|0);r=y+4|0;c[r>>2]=(c[r>>2]|0)+(c[q>>2]|0);r=c[s>>2]|0;c[m>>2]=c[y>>2];c[m+4>>2]=c[y+4>>2];XK(r,m);c[w>>2]=(c[w>>2]|0)+8;c[z>>2]=(c[z>>2]|0)+1}if((d[138998]|0|0)>=2){z=c[24742]|0;w=c[p>>2]|0;p=c[q>>2]|0;q=c[c[t>>2]>>2]|0;m=c[(c[t>>2]|0)+4>>2]|0;c[n>>2]=c[x>>2];c[n+4>>2]=w;c[n+8>>2]=p;c[n+12>>2]=q;c[n+16>>2]=m;Y2(z,137066,n)|0}c[o>>2]=1;C=c[o>>2]|0;i=l;return C|0}function WG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+32|0;e=d+24|0;f=d+20|0;g=d+16|0;h=d+12|0;j=d+8|0;k=d+4|0;l=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=c[c[f>>2]>>2];c[j>>2]=c[c[g>>2]>>2];c[k>>2]=c[(c[13644]|0)+(c[(c[h>>2]|0)+16>>2]<<2)>>2];c[l>>2]=c[(c[13644]|0)+(c[(c[j>>2]|0)+16>>2]<<2)>>2];if((c[k>>2]|0)>(c[l>>2]|0)){c[e>>2]=1;m=c[e>>2]|0;i=d;return m|0}if((c[k>>2]|0)<(c[l>>2]|0)){c[e>>2]=-1;m=c[e>>2]|0;i=d;return m|0}else{c[e>>2]=0;m=c[e>>2]|0;i=d;return m|0}return 0}function XG(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0;d=i;i=i+48|0;e=d+32|0;f=d+28|0;g=d+24|0;j=d+20|0;k=d+16|0;l=d+8|0;m=d;c[f>>2]=a;c[g>>2]=b;c[j>>2]=c[c[f>>2]>>2];c[k>>2]=c[c[g>>2]>>2];h[l>>3]=+h[(c[j>>2]|0)+8>>3]+ +h[c[j>>2]>>3];h[m>>3]=+h[(c[k>>2]|0)+8>>3]+ +h[c[k>>2]>>3];if(+h[l>>3]<+h[m>>3]){c[e>>2]=1;n=c[e>>2]|0;i=d;return n|0}if(+h[l>>3]>+h[m>>3]){c[e>>2]=-1;n=c[e>>2]|0;i=d;return n|0}else{c[e>>2]=0;n=c[e>>2]|0;i=d;return n|0}return 0}function YG(a,b,e,f,g,j){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0.0,X=0,Y=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0;k=i;i=i+256|0;l=k+248|0;m=k+240|0;n=k+64|0;o=k+48|0;p=k+236|0;q=k+232|0;r=k+228|0;s=k+224|0;t=k+220|0;u=k+216|0;v=k+212|0;w=k+208|0;x=k+200|0;y=k+192|0;z=k+184|0;A=k+176|0;B=k+32|0;C=k+172|0;D=k+168|0;E=k+164|0;F=k+160|0;G=k+156|0;H=k+152|0;I=k+148|0;J=k+144|0;K=k+140|0;L=k+136|0;M=k+120|0;N=k+116|0;O=k+112|0;P=k+16|0;Q=k+104|0;R=k+96|0;S=k;T=k+88|0;U=k+80|0;V=k+72|0;c[p>>2]=a;c[q>>2]=b;c[r>>2]=e;c[s>>2]=f;c[t>>2]=g;c[K>>2]=c[(c[t>>2]|0)+8>>2];c[L>>2]=c[(c[t>>2]|0)+12>>2];if(c[p>>2]|0)c[C>>2]=c[p>>2];else c[C>>2]=c[q>>2];c[u>>2]=VK()|0;W=+h[(c[(c[q>>2]|0)+8>>2]|0)+16>>3];c[H>>2]=(c[j>>2]|0)-~~(+h[(c[(c[q>>2]|0)+8>>2]|0)+16>>3]>=0.0?W+.5:W-.5);W=+h[(c[(c[q>>2]|0)+8>>2]|0)+16+8>>3];c[I>>2]=(c[j+4>>2]|0)-~~(+h[(c[(c[q>>2]|0)+8>>2]|0)+16+8>>3]>=0.0?W+.5:W-.5);j=c[q>>2]|0;a:do if((c[(c[t>>2]|0)+16>>2]|0)==1){c[O>>2]=cK((kB(j)|0)<<2)|0;c[N>>2]=0;c[D>>2]=$B(c[q>>2]|0)|0;while(1){if(!(c[D>>2]|0))break;p=c[(c[(c[D>>2]|0)+8>>2]|0)+112>>2]|0;g=c[N>>2]|0;c[N>>2]=g+1;c[(c[O>>2]|0)+(g<<2)>>2]=p;c[(c[(c[D>>2]|0)+8>>2]|0)+112>>2]=0;c[D>>2]=aC(c[q>>2]|0,c[D>>2]|0)|0}c[N>>2]=1;while(1){if((c[N>>2]|0)>(c[(c[(c[q>>2]|0)+8>>2]|0)+180>>2]|0))break;c[J>>2]=c[(c[(c[(c[q>>2]|0)+8>>2]|0)+184>>2]|0)+(c[N>>2]<<2)>>2];W=+h[(c[(c[J>>2]|0)+8>>2]|0)+16>>3];c[M>>2]=~~(+h[(c[(c[J>>2]|0)+8>>2]|0)+16>>3]>=0.0?W+.5:W-.5);W=+h[(c[(c[J>>2]|0)+8>>2]|0)+16+8>>3];c[M+4>>2]=~~(+h[(c[(c[J>>2]|0)+8>>2]|0)+16+8>>3]>=0.0?W+.5:W-.5);W=+h[(c[(c[J>>2]|0)+8>>2]|0)+16+16>>3];c[M+8>>2]=~~(+h[(c[(c[J>>2]|0)+8>>2]|0)+16+16>>3]>=0.0?W+.5:W-.5);W=+h[(c[(c[J>>2]|0)+8>>2]|0)+16+16+8>>3];c[M+8+4>>2]=~~(+h[(c[(c[J>>2]|0)+8>>2]|0)+16+16+8>>3]>=0.0?W+.5:W-.5);b:do if((c[M+8>>2]|0)>(c[M>>2]|0)?(c[M+8+4>>2]|0)>(c[M+4>>2]|0):0){c[M>>2]=(c[M>>2]|0)+(c[H>>2]|0);p=M+4|0;c[p>>2]=(c[p>>2]|0)+(c[I>>2]|0);p=M+8|0;c[p>>2]=(c[p>>2]|0)+(c[H>>2]|0);p=M+8+4|0;c[p>>2]=(c[p>>2]|0)+(c[I>>2]|0);c[M>>2]=(c[M>>2]|0)-(c[K>>2]|0);p=M+4|0;c[p>>2]=(c[p>>2]|0)-(c[K>>2]|0);p=M+8|0;c[p>>2]=(c[p>>2]|0)+(c[K>>2]|0);p=M+8+4|0;c[p>>2]=(c[p>>2]|0)+(c[K>>2]|0);p=c[M>>2]|0;if((c[M>>2]|0)>=0)X=(p|0)/(c[s>>2]|0)|0;else X=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[M>>2]=X;p=c[M+4>>2]|0;if((c[M+4>>2]|0)>=0)Y=(p|0)/(c[s>>2]|0)|0;else Y=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[M+4>>2]=Y;p=c[M+8>>2]|0;if((c[M+8>>2]|0)>=0)_=(p|0)/(c[s>>2]|0)|0;else _=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[M+8>>2]=_;p=c[M+8+4>>2]|0;if((c[M+8+4>>2]|0)>=0)$=(p|0)/(c[s>>2]|0)|0;else $=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[M+8+4>>2]=$;c[F>>2]=c[M>>2];while(1){if((c[F>>2]|0)>(c[M+8>>2]|0))break;c[G>>2]=c[M+4>>2];while(1){if((c[G>>2]|0)>(c[M+8+4>>2]|0))break;YK(c[u>>2]|0,c[F>>2]|0,c[G>>2]|0);c[G>>2]=(c[G>>2]|0)+1}c[F>>2]=(c[F>>2]|0)+1}c[D>>2]=$B(c[J>>2]|0)|0;while(1){if(!(c[D>>2]|0))break b;c[(c[(c[D>>2]|0)+8>>2]|0)+212>>2]=c[J>>2];c[D>>2]=aC(c[J>>2]|0,c[D>>2]|0)|0}}while(0);c[N>>2]=(c[N>>2]|0)+1}c[D>>2]=$B(c[q>>2]|0)|0;while(1){if(!(c[D>>2]|0))break;pO(P,c[D>>2]|0);c[B>>2]=c[P>>2];c[B+4>>2]=c[P+4>>2];c[B+8>>2]=c[P+8>>2];c[B+12>>2]=c[P+12>>2];W=+h[B>>3];c[z>>2]=~~(+h[B>>3]>=0.0?W+.5:W-.5);W=+h[B+8>>3];c[z+4>>2]=~~(+h[B+8>>3]>=0.0?W+.5:W-.5);c[z>>2]=(c[z>>2]|0)+(c[H>>2]|0);p=z+4|0;c[p>>2]=(c[p>>2]|0)+(c[I>>2]|0);c:do if(c[(c[(c[D>>2]|0)+8>>2]|0)+212>>2]|0){p=c[z>>2]|0;if((c[z>>2]|0)>=0)aa=(p|0)/(c[s>>2]|0)|0;else aa=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[z>>2]=aa;p=c[z+4>>2]|0;if((c[z+4>>2]|0)>=0)ba=(p|0)/(c[s>>2]|0)|0;else ba=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[z+4>>2]=ba;c[E>>2]=OA(c[C>>2]|0,c[D>>2]|0)|0;while(1){if(!(c[E>>2]|0))break c;p=c[E>>2]|0;if((c[(c[(c[D>>2]|0)+8>>2]|0)+212>>2]|0)!=(c[(c[(c[((c[c[E>>2]>>2]&3|0)==2?p:p+-32|0)+28>>2]|0)+8>>2]|0)+212>>2]|0)){p=c[E>>2]|0;g=c[u>>2]|0;f=c[H>>2]|0;e=c[I>>2]|0;b=c[s>>2]|0;a=c[L>>2]|0;c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];aH(p,l,g,f,e,b,a)}c[E>>2]=QA(c[C>>2]|0,c[E>>2]|0)|0}}else{c[A>>2]=~~(+(c[K>>2]|0)+(+h[(c[(c[D>>2]|0)+8>>2]|0)+88>>3]+ +h[(c[(c[D>>2]|0)+8>>2]|0)+96>>3])/2.0);c[A+4>>2]=~~(+(c[K>>2]|0)+ +h[(c[(c[D>>2]|0)+8>>2]|0)+80>>3]/2.0);c[m>>2]=c[z>>2];c[m+4>>2]=c[z+4>>2];c[l>>2]=c[A>>2];c[l+4>>2]=c[A+4>>2];_G(Q,m,l);c[x>>2]=c[Q>>2];c[x+4>>2]=c[Q+4>>2];c[m>>2]=c[z>>2];c[m+4>>2]=c[z+4>>2];c[l>>2]=c[A>>2];c[l+4>>2]=c[A+4>>2];$G(R,m,l);c[y>>2]=c[R>>2];c[y+4>>2]=c[R+4>>2];a=c[x>>2]|0;if((c[x>>2]|0)>=0)ca=(a|0)/(c[s>>2]|0)|0;else ca=((a+1|0)/(c[s>>2]|0)|0)-1|0;c[x>>2]=ca;a=c[x+4>>2]|0;if((c[x+4>>2]|0)>=0)da=(a|0)/(c[s>>2]|0)|0;else da=((a+1|0)/(c[s>>2]|0)|0)-1|0;c[x+4>>2]=da;a=c[y>>2]|0;if((c[y>>2]|0)>=0)ea=(a|0)/(c[s>>2]|0)|0;else ea=((a+1|0)/(c[s>>2]|0)|0)-1|0;c[y>>2]=ea;a=c[y+4>>2]|0;if((c[y+4>>2]|0)>=0)fa=(a|0)/(c[s>>2]|0)|0;else fa=((a+1|0)/(c[s>>2]|0)|0)-1|0;c[y+4>>2]=fa;c[F>>2]=c[x>>2];while(1){if((c[F>>2]|0)>(c[y>>2]|0))break;c[G>>2]=c[x+4>>2];while(1){if((c[G>>2]|0)>(c[y+4>>2]|0))break;YK(c[u>>2]|0,c[F>>2]|0,c[G>>2]|0);c[G>>2]=(c[G>>2]|0)+1}c[F>>2]=(c[F>>2]|0)+1}a=c[z>>2]|0;if((c[z>>2]|0)>=0)ga=(a|0)/(c[s>>2]|0)|0;else ga=((a+1|0)/(c[s>>2]|0)|0)-1|0;c[z>>2]=ga;a=c[z+4>>2]|0;if((c[z+4>>2]|0)>=0)ha=(a|0)/(c[s>>2]|0)|0;else ha=((a+1|0)/(c[s>>2]|0)|0)-1|0;c[z+4>>2]=ha;c[E>>2]=OA(c[C>>2]|0,c[D>>2]|0)|0;while(1){if(!(c[E>>2]|0))break c;a=c[E>>2]|0;b=c[u>>2]|0;e=c[H>>2]|0;f=c[I>>2]|0;g=c[s>>2]|0;p=c[L>>2]|0;c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];aH(a,l,b,e,f,g,p);c[E>>2]=QA(c[C>>2]|0,c[E>>2]|0)|0}}while(0);c[D>>2]=aC(c[q>>2]|0,c[D>>2]|0)|0}c[N>>2]=0;c[D>>2]=$B(c[q>>2]|0)|0;while(1){if(!(c[D>>2]|0))break;p=c[N>>2]|0;c[N>>2]=p+1;c[(c[(c[D>>2]|0)+8>>2]|0)+112>>2]=c[(c[O>>2]|0)+(p<<2)>>2];c[D>>2]=aC(c[q>>2]|0,c[D>>2]|0)|0}O4(c[O>>2]|0)}else{c[D>>2]=$B(j)|0;while(1){if(!(c[D>>2]|0))break a;pO(S,c[D>>2]|0);c[B>>2]=c[S>>2];c[B+4>>2]=c[S+4>>2];c[B+8>>2]=c[S+8>>2];c[B+12>>2]=c[S+12>>2];W=+h[B>>3];c[z>>2]=~~(+h[B>>3]>=0.0?W+.5:W-.5);W=+h[B+8>>3];c[z+4>>2]=~~(+h[B+8>>3]>=0.0?W+.5:W-.5);c[z>>2]=(c[z>>2]|0)+(c[H>>2]|0);p=z+4|0;c[p>>2]=(c[p>>2]|0)+(c[I>>2]|0);c[A>>2]=~~(+(c[K>>2]|0)+(+h[(c[(c[D>>2]|0)+8>>2]|0)+88>>3]+ +h[(c[(c[D>>2]|0)+8>>2]|0)+96>>3])/2.0);c[A+4>>2]=~~(+(c[K>>2]|0)+ +h[(c[(c[D>>2]|0)+8>>2]|0)+80>>3]/2.0);c[m>>2]=c[z>>2];c[m+4>>2]=c[z+4>>2];c[l>>2]=c[A>>2];c[l+4>>2]=c[A+4>>2];_G(T,m,l);c[x>>2]=c[T>>2];c[x+4>>2]=c[T+4>>2];c[m>>2]=c[z>>2];c[m+4>>2]=c[z+4>>2];c[l>>2]=c[A>>2];c[l+4>>2]=c[A+4>>2];$G(U,m,l);c[y>>2]=c[U>>2];c[y+4>>2]=c[U+4>>2];p=c[x>>2]|0;if((c[x>>2]|0)>=0)ia=(p|0)/(c[s>>2]|0)|0;else ia=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[x>>2]=ia;p=c[x+4>>2]|0;if((c[x+4>>2]|0)>=0)ja=(p|0)/(c[s>>2]|0)|0;else ja=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[x+4>>2]=ja;p=c[y>>2]|0;if((c[y>>2]|0)>=0)ka=(p|0)/(c[s>>2]|0)|0;else ka=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[y>>2]=ka;p=c[y+4>>2]|0;if((c[y+4>>2]|0)>=0)la=(p|0)/(c[s>>2]|0)|0;else la=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[y+4>>2]=la;c[F>>2]=c[x>>2];while(1){if((c[F>>2]|0)>(c[y>>2]|0))break;c[G>>2]=c[x+4>>2];while(1){if((c[G>>2]|0)>(c[y+4>>2]|0))break;YK(c[u>>2]|0,c[F>>2]|0,c[G>>2]|0);c[G>>2]=(c[G>>2]|0)+1}c[F>>2]=(c[F>>2]|0)+1}p=c[z>>2]|0;if((c[z>>2]|0)>=0)ma=(p|0)/(c[s>>2]|0)|0;else ma=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[z>>2]=ma;p=c[z+4>>2]|0;if((c[z+4>>2]|0)>=0)na=(p|0)/(c[s>>2]|0)|0;else na=((p+1|0)/(c[s>>2]|0)|0)-1|0;c[z+4>>2]=na;c[E>>2]=OA(c[C>>2]|0,c[D>>2]|0)|0;while(1){if(!(c[E>>2]|0))break;p=c[E>>2]|0;g=c[u>>2]|0;f=c[H>>2]|0;e=c[I>>2]|0;b=c[s>>2]|0;a=c[L>>2]|0;c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];aH(p,l,g,f,e,b,a);c[E>>2]=QA(c[C>>2]|0,c[E>>2]|0)|0}c[D>>2]=aC(c[q>>2]|0,c[D>>2]|0)|0}}while(0);D=aL(c[u>>2]|0)|0;c[(c[r>>2]|0)+4>>2]=D;D=$K(c[u>>2]|0)|0;c[(c[r>>2]|0)+8>>2]=D;c[v>>2]=~~+Z(+((+h[(c[(c[q>>2]|0)+8>>2]|0)+16+16>>3]-+h[(c[(c[q>>2]|0)+8>>2]|0)+16>>3]+ +(c[K>>2]<<1|0))/+(c[s>>2]|0)));c[w>>2]=~~+Z(+((+h[(c[(c[q>>2]|0)+8>>2]|0)+16+16+8>>3]-+h[(c[(c[q>>2]|0)+8>>2]|0)+16+8>>3]+ +(c[K>>2]<<1|0))/+(c[s>>2]|0)));c[c[r>>2]>>2]=(c[v>>2]|0)+(c[w>>2]|0);if((d[138998]|0|0)<=2){oa=c[u>>2]|0;WK(oa);i=k;return 0}s=c[24742]|0;K=wB(c[q>>2]|0)|0;q=c[(c[r>>2]|0)+8>>2]|0;D=c[v>>2]|0;v=c[w>>2]|0;c[o>>2]=K;c[o+4>>2]=q;c[o+8>>2]=D;c[o+12>>2]=v;Y2(s,137100,o)|0;c[V>>2]=0;while(1){if((c[V>>2]|0)>=(c[(c[r>>2]|0)+8>>2]|0))break;o=c[24742]|0;s=c[(c[(c[r>>2]|0)+4>>2]|0)+(c[V>>2]<<3)+4>>2]|0;c[n>>2]=c[(c[(c[r>>2]|0)+4>>2]|0)+(c[V>>2]<<3)>>2];c[n+4>>2]=s;Y2(o,137127,n)|0;c[V>>2]=(c[V>>2]|0)+1}oa=c[u>>2]|0;WK(oa);i=k;return 0}function ZG(a,b,e,f){a=a|0;b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=i;i=i+48|0;h=g+40|0;j=g;k=g+32|0;l=g+28|0;m=g+24|0;n=g+20|0;o=g+16|0;p=g+12|0;c[k>>2]=a;c[l>>2]=b;c[m>>2]=e;c[n>>2]=c[(c[k>>2]|0)+4>>2];c[o>>2]=c[(c[k>>2]|0)+8>>2];c[c[m>>2]>>2]=0-(c[f>>2]|0);c[(c[m>>2]|0)+4>>2]=0-(c[f+4>>2]|0);c[p>>2]=0;while(1){if((c[p>>2]|0)>=(c[o>>2]|0))break;f=c[l>>2]|0;k=c[n>>2]|0;c[n>>2]=k+8;c[h>>2]=c[k>>2];c[h+4>>2]=c[k+4>>2];XK(f,h);c[p>>2]=(c[p>>2]|0)+1}if((d[138998]|0|0)<2){i=g;return}p=c[24742]|0;h=c[c[m>>2]>>2]|0;n=c[(c[m>>2]|0)+4>>2]|0;c[j>>2]=c[o>>2];c[j+4>>2]=h;c[j+8>>2]=n;Y2(p,137347,j)|0;i=g;return}function _G(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=(c[b>>2]|0)-(c[d>>2]|0);c[f+4>>2]=(c[b+4>>2]|0)-(c[d+4>>2]|0);c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];i=e;return}function $G(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=(c[b>>2]|0)+(c[d>>2]|0);c[f+4>>2]=(c[b+4>>2]|0)+(c[d+4>>2]|0);c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];i=e;return}function aH(a,b,d,e,f,g,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;k=i;i=i+176|0;l=k+112|0;m=k+96|0;n=k+160|0;o=k+156|0;p=k+152|0;q=k+148|0;r=k+144|0;s=k+140|0;t=k+136|0;u=k+132|0;v=k+48|0;w=k+32|0;x=k+16|0;y=k+128|0;z=k;c[n>>2]=a;c[o>>2]=d;c[p>>2]=e;c[q>>2]=f;c[r>>2]=g;c[s>>2]=j;h[w>>3]=+(c[b>>2]|0);h[w+8>>3]=+(c[b+4>>2]|0);if((c[s>>2]|0)!=0?(c[(c[(c[n>>2]|0)+8>>2]|0)+8>>2]|0)!=0:0){c[t>>2]=0;while(1){if((c[t>>2]|0)>=(c[(c[(c[(c[n>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0))break;s=v;b=(c[c[(c[(c[n>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[t>>2]|0)*48|0)|0;j=s+48|0;do{c[s>>2]=c[b>>2];s=s+4|0;b=b+4|0}while((s|0)<(j|0));if(c[v+8>>2]|0){b=v+16|0;c[w>>2]=c[b>>2];c[w+4>>2]=c[b+4>>2];c[w+8>>2]=c[b+8>>2];c[w+12>>2]=c[b+12>>2];b=c[v>>2]|0;c[x>>2]=c[b>>2];c[x+4>>2]=c[b+4>>2];c[x+8>>2]=c[b+8>>2];c[x+12>>2]=c[b+12>>2];c[u>>2]=1}else{b=c[v>>2]|0;c[w>>2]=c[b>>2];c[w+4>>2]=c[b+4>>2];c[w+8>>2]=c[b+8>>2];c[w+12>>2]=c[b+12>>2];b=(c[v>>2]|0)+16|0;c[x>>2]=c[b>>2];c[x+4>>2]=c[b+4>>2];c[x+8>>2]=c[b+8>>2];c[x+12>>2]=c[b+12>>2];c[u>>2]=2}h[w>>3]=+h[w>>3]+ +(c[p>>2]|0);b=w+8|0;h[b>>3]=+h[b>>3]+ +(c[q>>2]|0);A=+h[w>>3];if(+h[w>>3]>=0.0)B=A/+(c[r>>2]|0);else B=(A+1.0)/+(c[r>>2]|0)-1.0;h[w>>3]=B;A=+h[w+8>>3];if(+h[w+8>>3]>=0.0)C=A/+(c[r>>2]|0);else C=(A+1.0)/+(c[r>>2]|0)-1.0;h[w+8>>3]=C;h[x>>3]=+h[x>>3]+ +(c[p>>2]|0);b=x+8|0;h[b>>3]=+h[b>>3]+ +(c[q>>2]|0);A=+h[x>>3];if(+h[x>>3]>=0.0)D=A/+(c[r>>2]|0);else D=(A+1.0)/+(c[r>>2]|0)-1.0;h[x>>3]=D;A=+h[x+8>>3];if(+h[x+8>>3]>=0.0)E=A/+(c[r>>2]|0);else E=(A+1.0)/+(c[r>>2]|0)-1.0;h[x+8>>3]=E;b=c[o>>2]|0;c[m>>2]=c[w>>2];c[m+4>>2]=c[w+4>>2];c[m+8>>2]=c[w+8>>2];c[m+12>>2]=c[w+12>>2];c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[l+12>>2]=c[x+12>>2];AG(m,l,b);while(1){if((c[u>>2]|0)>=(c[v+4>>2]|0))break;c[w>>2]=c[x>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];b=(c[v>>2]|0)+(c[u>>2]<<4)|0;c[x>>2]=c[b>>2];c[x+4>>2]=c[b+4>>2];c[x+8>>2]=c[b+8>>2];c[x+12>>2]=c[b+12>>2];h[x>>3]=+h[x>>3]+ +(c[p>>2]|0);b=x+8|0;h[b>>3]=+h[b>>3]+ +(c[q>>2]|0);A=+h[x>>3];if(+h[x>>3]>=0.0)F=A/+(c[r>>2]|0);else F=(A+1.0)/+(c[r>>2]|0)-1.0;h[x>>3]=F;A=+h[x+8>>3];if(+h[x+8>>3]>=0.0)G=A/+(c[r>>2]|0);else G=(A+1.0)/+(c[r>>2]|0)-1.0;h[x+8>>3]=G;b=c[o>>2]|0;c[m>>2]=c[w>>2];c[m+4>>2]=c[w+4>>2];c[m+8>>2]=c[w+8>>2];c[m+12>>2]=c[w+12>>2];c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[l+12>>2]=c[x+12>>2];AG(m,l,b);c[u>>2]=(c[u>>2]|0)+1}if(c[v+12>>2]|0){c[w>>2]=c[x>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];b=v+32|0;c[x>>2]=c[b>>2];c[x+4>>2]=c[b+4>>2];c[x+8>>2]=c[b+8>>2];c[x+12>>2]=c[b+12>>2];h[x>>3]=+h[x>>3]+ +(c[p>>2]|0);b=x+8|0;h[b>>3]=+h[b>>3]+ +(c[q>>2]|0);A=+h[x>>3];if(+h[x>>3]>=0.0)H=A/+(c[r>>2]|0);else H=(A+1.0)/+(c[r>>2]|0)-1.0;h[x>>3]=H;A=+h[x+8>>3];if(+h[x+8>>3]>=0.0)I=A/+(c[r>>2]|0);else I=(A+1.0)/+(c[r>>2]|0)-1.0;h[x+8>>3]=I;b=c[o>>2]|0;c[m>>2]=c[w>>2];c[m+4>>2]=c[w+4>>2];c[m+8>>2]=c[w+8>>2];c[m+12>>2]=c[w+12>>2];c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[l+12>>2]=c[x+12>>2];AG(m,l,b)}c[t>>2]=(c[t>>2]|0)+1}i=k;return}t=c[n>>2]|0;c[y>>2]=c[((c[c[n>>2]>>2]&3|0)==2?t:t+-32|0)+28>>2];pO(z,c[y>>2]|0);c[x>>2]=c[z>>2];c[x+4>>2]=c[z+4>>2];c[x+8>>2]=c[z+8>>2];c[x+12>>2]=c[z+12>>2];h[x>>3]=+h[x>>3]+ +(c[p>>2]|0);p=x+8|0;h[p>>3]=+h[p>>3]+ +(c[q>>2]|0);I=+h[x>>3];if(+h[x>>3]>=0.0)J=I/+(c[r>>2]|0);else J=(I+1.0)/+(c[r>>2]|0)-1.0;h[x>>3]=J;J=+h[x+8>>3];if(+h[x+8>>3]>=0.0)K=J/+(c[r>>2]|0);else K=(J+1.0)/+(c[r>>2]|0)-1.0;h[x+8>>3]=K;r=c[o>>2]|0;c[m>>2]=c[w>>2];c[m+4>>2]=c[w+4>>2];c[m+8>>2]=c[w+8>>2];c[m+12>>2]=c[w+12>>2];c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[l+12>>2]=c[x+12>>2];AG(m,l,r);i=k;return}function bH(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+28|0;h=f+24|0;j=f+20|0;k=f+16|0;l=f+12|0;m=f+8|0;n=f+4|0;o=f;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;c[c[h>>2]>>2]=0;e=(nB(qC(c[g>>2]|0)|0)|0)!=0;c[c[j>>2]>>2]=e?1:0;a:do if((c[13868]|0)!=0?(e=zA(c[g>>2]|0,c[13868]|0)|0,c[k>>2]=e,(a[e>>0]|0)!=0):0){c[l>>2]=54580;while(1){if(!(c[c[l>>2]>>2]|0))break a;if((a[c[k>>2]>>0]|0)==(a[c[c[l>>2]>>2]>>0]|0)?(J3(c[k>>2]|0,c[c[l>>2]>>2]|0)|0)==0:0)break;c[l>>2]=(c[l>>2]|0)+12}c[c[h>>2]>>2]=c[(c[l>>2]|0)+4>>2];c[c[j>>2]>>2]=c[(c[l>>2]|0)+8>>2]}while(0);if(((c[13879]|0)!=0?(c[c[j>>2]>>2]|0)==1:0)?(l=zA(c[g>>2]|0,c[13879]|0)|0,c[k>>2]=l,(a[l>>0]|0)!=0):0)iH(c[k>>2]|0,c[j>>2]|0);if(((c[13880]|0)!=0?(c[c[h>>2]>>2]|0)==1:0)?(l=zA(c[g>>2]|0,c[13880]|0)|0,c[k>>2]=l,(a[l>>0]|0)!=0):0)iH(c[k>>2]|0,c[h>>2]|0);if(!(a[(c[(c[g>>2]|0)+8>>2]|0)+153>>0]|0)){i=f;return}k=c[g>>2]|0;l=qC(c[((c[c[g>>2]>>2]&3|0)==2?k:k+-32|0)+28>>2]|0)|0;k=c[g>>2]|0;e=c[g>>2]|0;c[m>>2]=VA(l,c[((c[c[g>>2]>>2]&3|0)==2?k:k+-32|0)+28>>2]|0,c[((c[c[g>>2]>>2]&3|0)==3?e:e+32|0)+28>>2]|0,0,0)|0;bH(c[m>>2]|0,n,o);c[c[j>>2]>>2]=c[c[j>>2]>>2]|c[n>>2];c[c[h>>2]>>2]=c[c[h>>2]>>2]|c[o>>2];i=f;return}function cH(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0;d=i;i=i+32|0;e=d+24|0;f=d+20|0;g=d+16|0;j=d;k=d+12|0;l=d+8|0;c[e>>2]=a;c[f>>2]=b;h[j>>3]=0.0;c[l>>2]=0;while(1){if((c[l>>2]|0)>=4)break;c[k>>2]=c[f>>2]>>(c[l>>2]<<3)&15;c[g>>2]=33736;while(1){if(!(c[(c[g>>2]|0)+16>>2]|0))break;m=c[g>>2]|0;if((c[k>>2]|0)==(c[c[g>>2]>>2]|0)){n=6;break}c[g>>2]=m+24}if((n|0)==6){n=0;h[j>>3]=+h[j>>3]+ +h[m+8>>3]}c[l>>2]=(c[l>>2]|0)+1}o=+h[j>>3]*10.0;p=o*+fO(c[e>>2]|0,c[13872]|0,1.0,0.0);i=d;return +p}function dH(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;i=i+112|0;k=j+108|0;l=j+104|0;m=j+100|0;n=j+96|0;o=j+92|0;p=j+88|0;q=j+80|0;r=j+16|0;s=j+8|0;t=j;c[k>>2]=a;c[l>>2]=b;c[m>>2]=d;c[n>>2]=e;c[o>>2]=f;c[p>>2]=g;h[s>>3]=+cH(c[k>>2]|0,c[p>>2]|0);h[t>>3]=+h[s>>3]*+h[s>>3];c[(c[o>>2]|0)+12>>2]=c[p>>2];p=(c[o>>2]|0)+32|0;s=(c[l>>2]|0)+((c[n>>2]|0)+3<<4)|0;c[p>>2]=c[s>>2];c[p+4>>2]=c[s+4>>2];c[p+8>>2]=c[s+8>>2];c[p+12>>2]=c[s+12>>2];if((c[n>>2]|0)>(c[m>>2]|0)?(+h[(c[l>>2]|0)+(c[n>>2]<<4)>>3]-+h[(c[l>>2]|0)+((c[n>>2]|0)+3<<4)>>3])*(+h[(c[l>>2]|0)+(c[n>>2]<<4)>>3]-+h[(c[l>>2]|0)+((c[n>>2]|0)+3<<4)>>3])+(+h[(c[l>>2]|0)+(c[n>>2]<<4)+8>>3]-+h[(c[l>>2]|0)+((c[n>>2]|0)+3<<4)+8>>3])*(+h[(c[l>>2]|0)+(c[n>>2]<<4)+8>>3]-+h[(c[l>>2]|0)+((c[n>>2]|0)+3<<4)+8>>3])<+h[t>>3]:0)c[n>>2]=(c[n>>2]|0)-3;m=r+48|0;s=(c[l>>2]|0)+(c[n>>2]<<4)|0;c[m>>2]=c[s>>2];c[m+4>>2]=c[s+4>>2];c[m+8>>2]=c[s+8>>2];c[m+12>>2]=c[s+12>>2];s=r+32|0;m=(c[l>>2]|0)+((c[n>>2]|0)+1<<4)|0;c[s>>2]=c[m>>2];c[s+4>>2]=c[m+4>>2];c[s+8>>2]=c[m+8>>2];c[s+12>>2]=c[m+12>>2];m=r+16|0;s=(c[l>>2]|0)+((c[n>>2]|0)+2<<4)|0;c[m>>2]=c[s>>2];c[m+4>>2]=c[s+4>>2];c[m+8>>2]=c[s+8>>2];c[m+12>>2]=c[s+12>>2];s=(c[o>>2]|0)+32|0;c[r>>2]=c[s>>2];c[r+4>>2]=c[s+4>>2];c[r+8>>2]=c[s+8>>2];c[r+12>>2]=c[s+12>>2];c[q>>2]=r;c[q+4>>2]=t;gN(q,92,r,1);q=(c[l>>2]|0)+(c[n>>2]<<4)|0;t=r+48|0;c[q>>2]=c[t>>2];c[q+4>>2]=c[t+4>>2];c[q+8>>2]=c[t+8>>2];c[q+12>>2]=c[t+12>>2];t=(c[l>>2]|0)+((c[n>>2]|0)+1<<4)|0;q=r+32|0;c[t>>2]=c[q>>2];c[t+4>>2]=c[q+4>>2];c[t+8>>2]=c[q+8>>2];c[t+12>>2]=c[q+12>>2];q=(c[l>>2]|0)+((c[n>>2]|0)+2<<4)|0;t=r+16|0;c[q>>2]=c[t>>2];c[q+4>>2]=c[t+4>>2];c[q+8>>2]=c[t+8>>2];c[q+12>>2]=c[t+12>>2];t=(c[l>>2]|0)+((c[n>>2]|0)+3<<4)|0;c[t>>2]=c[r>>2];c[t+4>>2]=c[r+4>>2];c[t+8>>2]=c[r+8>>2];c[t+12>>2]=c[r+12>>2];i=j;return c[n>>2]|0}
function PN(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[f>>2]=a;h[g>>3]=d;if((c[(c[f>>2]|0)+4>>2]|0)>=(c[(c[f>>2]|0)+8>>2]|0)){a=(c[f>>2]|0)+8|0;c[a>>2]=c[a>>2]<<1;a=eK(c[c[f>>2]>>2]|0,c[(c[f>>2]|0)+8>>2]<<6)|0;c[c[f>>2]>>2]=a}h[(c[c[f>>2]>>2]|0)+(c[(c[f>>2]|0)+4>>2]<<6)>>3]=+h[b>>3];h[(c[c[f>>2]>>2]|0)+(c[(c[f>>2]|0)+4>>2]<<6)+8>>3]=+h[b+8>>3];d=+h[g>>3];g=(c[f>>2]|0)+4|0;b=c[g>>2]|0;c[g>>2]=b+1;h[(c[c[f>>2]>>2]|0)+(b<<6)+16>>3]=d;i=e;return}function QN(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0.0;c=i;i=i+16|0;d=c+8|0;e=c;h[d>>3]=+h[a>>3]-+h[b>>3];h[e>>3]=+h[a+8>>3]-+h[b+8>>3];f=+O(+(+h[d>>3]*+h[d>>3]+ +h[e>>3]*+h[e>>3]));i=c;return +f}function RN(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if((c[(c[d>>2]|0)+8>>2]|0)<=(c[(c[d>>2]|0)+4>>2]|0)){i=b;return}a=eK(c[c[d>>2]>>2]|0,c[(c[d>>2]|0)+4>>2]<<6)|0;c[c[d>>2]>>2]=a;i=b;return}function SN(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+32|0;g=f+8|0;h=f;j=f+28|0;k=f+24|0;l=f+20|0;m=f+16|0;n=f+12|0;c[j>>2]=b;c[k>>2]=e;c[l>>2]=0;c[m>>2]=0;if(!(c[(c[k>>2]|0)+4>>2]|0))La(144274,144285,202,144296);c[n>>2]=c[(c[k>>2]|0)+4>>2];if(!(c[c[n>>2]>>2]|0))La(144310,144285,205,144296);if(!(c[(c[n>>2]|0)+8>>2]|0)){e=UN(c[c[n>>2]>>2]|0)|0;c[(c[n>>2]|0)+8>>2]=e}if((d[138998]|0|0)!=0?(GH(c[c[n>>2]>>2]|0)|0)!=0:0)c[l>>2]=m;if(!((rS(c[j>>2]|0,c[k>>2]|0,c[l>>2]|0)|0)<<24>>24))VN(c[k>>2]|0,c[l>>2]|0);do if(c[l>>2]|0){j=c[24742]|0;e=c[c[n>>2]>>2]|0;if(c[m>>2]|0){b=c[m>>2]|0;c[h>>2]=e;c[h+4>>2]=b;Y2(j,144321,h)|0;break}else{c[g>>2]=e;Y2(j,144353,g)|0;break}}while(0);g=(c[k>>2]|0)+32|0;c[a>>2]=c[g>>2];c[a+4>>2]=c[g+4>>2];c[a+8>>2]=c[g+8>>2];c[a+12>>2]=c[g+12>>2];i=f;return}function TN(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;c[(c[d>>2]|0)+108>>2]=0;c[(c[d>>2]|0)+108+4>>2]=32;c[(c[d>>2]|0)+108+8>>2]=-1;c[(c[d>>2]|0)+108+12>>2]=37;c[(c[d>>2]|0)+108+16>>2]=60;c[(c[d>>2]|0)+108+20>>2]=55;c[(c[d>>2]|0)+108+24>>2]=0;c[(c[d>>2]|0)+108+28>>2]=0;c[(c[d>>2]|0)+108+32>>2]=0;a=Nz((c[d>>2]|0)+108|0,c[12989]|0)|0;c[(c[d>>2]|0)+144>>2]=a;i=b;return c[(c[d>>2]|0)+144>>2]|0}function UN(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if((c[14384]|0)!=0?(F3(c[14384]|0,c[d>>2]|0)|0)==0:0){e=c[14708]|0;i=b;return e|0}c[14384]=c[d>>2];c[14708]=v3(57536,57572,35,36,95)|0;e=c[14708]|0;i=b;return e|0}function VN(b,e){b=b|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+48|0;g=f+28|0;j=f+24|0;k=f+20|0;l=f;m=f+32|0;n=f+16|0;o=f+12|0;p=f+8|0;c[g>>2]=b;c[j>>2]=e;c[p>>2]=c[c[(c[g>>2]|0)+4>>2]>>2];h[l>>3]=+h[(c[(c[g>>2]|0)+4>>2]|0)+16>>3];h[(c[g>>2]|0)+32>>3]=0.0;h[(c[g>>2]|0)+32+8>>3]=+h[l>>3]*1.2;h[(c[g>>2]|0)+16>>3]=0.0;h[(c[g>>2]|0)+24>>3]=+h[l>>3]*.1;c[(c[g>>2]|0)+8>>2]=0;c[(c[g>>2]|0)+12>>2]=0;do if(O3(c[p>>2]|0,144387,4)|0){if((O3(c[p>>2]|0,144411,5)|0)!=0?(O3(c[p>>2]|0,144417,9)|0)!=0:0){c[o>>2]=144444;c[k>>2]=40856;break}c[o>>2]=144427;c[k>>2]=38808}else{c[o>>2]=144392;c[k>>2]=36760}while(0);if(c[j>>2]|0)c[c[j>>2]>>2]=c[o>>2];o=c[c[g>>2]>>2]|0;c[n>>2]=o;if(!o){i=f;return}while(1){o=c[n>>2]|0;c[n>>2]=o+1;j=a[o>>0]|0;a[m>>0]=j;if(!(j<<24>>24))break;j=(c[g>>2]|0)+32|0;h[j>>3]=+h[j>>3]+ +h[(c[k>>2]|0)+((d[m>>0]|0)<<3)>>3]}m=(c[g>>2]|0)+32|0;h[m>>3]=+h[m>>3]*+h[l>>3];i=f;return}function WN(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0;e=i;i=i+32|0;f=e+12|0;g=e+4|0;j=e;c[e+16>>2]=a;c[f>>2]=b;c[e+8>>2]=d;c[g>>2]=c[f>>2];c[j>>2]=P4(1,32)|0;if(c[c[g>>2]>>2]|0){f=M3(c[c[g>>2]>>2]|0)|0;c[c[j>>2]>>2]=f}if(c[(c[g>>2]|0)+4>>2]|0){f=M3(c[(c[g>>2]|0)+4>>2]|0)|0;c[(c[j>>2]|0)+4>>2]=f}f=(c[j>>2]|0)+24|0;c[f>>2]=c[f>>2]&-128|c[(c[g>>2]|0)+24>>2]&127;h[(c[j>>2]|0)+16>>3]=+h[(c[g>>2]|0)+16>>3];c[(c[j>>2]|0)+8>>2]=c[(c[g>>2]|0)+8>>2];i=e;return c[j>>2]|0}function XN(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=c[f>>2];if(c[c[g>>2]>>2]|0)O4(c[c[g>>2]>>2]|0);if(!(c[(c[g>>2]|0)+4>>2]|0)){h=c[g>>2]|0;O4(h);i=e;return}O4(c[(c[g>>2]|0)+4>>2]|0);h=c[g>>2]|0;O4(h);i=e;return}function YN(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;i=i+32|0;g=f+28|0;j=f+20|0;k=f+16|0;l=f+8|0;m=f+4|0;n=f;c[f+24>>2]=a;c[j>>2]=b;c[k>>2]=d;c[f+12>>2]=e;c[m>>2]=c[j>>2];c[n>>2]=c[k>>2];if((c[c[m>>2]>>2]|0)==0?(c[c[n>>2]>>2]|0)==0:0)o=9;else o=3;do if((o|0)==3){if(!(c[c[m>>2]>>2]|0)){c[g>>2]=-1;break}if(!(c[c[n>>2]>>2]|0)){c[g>>2]=1;break}c[l>>2]=J3(c[c[m>>2]>>2]|0,c[c[n>>2]>>2]|0)|0;if(c[l>>2]|0)c[g>>2]=c[l>>2];else o=9}while(0);do if((o|0)==9){if(!((c[(c[m>>2]|0)+4>>2]|0)==0?(c[(c[n>>2]|0)+4>>2]|0)==0:0)){if(!(c[(c[m>>2]|0)+4>>2]|0)){c[g>>2]=-1;break}if(!(c[(c[n>>2]|0)+4>>2]|0)){c[g>>2]=1;break}c[l>>2]=J3(c[(c[m>>2]|0)+4>>2]|0,c[(c[n>>2]|0)+4>>2]|0)|0;if(c[l>>2]|0){c[g>>2]=c[l>>2];break}}c[l>>2]=(c[(c[m>>2]|0)+24>>2]&127)-(c[(c[n>>2]|0)+24>>2]&127);if(c[l>>2]|0){c[g>>2]=c[l>>2];break}if(+h[(c[m>>2]|0)+16>>3]<+h[(c[n>>2]|0)+16>>3]){c[g>>2]=-1;break}if(+h[(c[m>>2]|0)+16>>3]>+h[(c[n>>2]|0)+16>>3]){c[g>>2]=1;break}else{c[g>>2]=0;break}}while(0);i=f;return c[g>>2]|0}function ZN(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=F3(c[c[e>>2]>>2]|0,c[c[f>>2]>>2]|0)|0;i=d;return b|0}function _N(){Ra(58836)|0;return}function $N(){var a=0,b=0,d=0;a=i;i=i+32|0;b=a+8|0;d=a;Ra(b|0)|0;h[d>>3]=+((c[b>>2]|0)+(c[b+4>>2]|0)-(c[14709]|0)-(c[14710]|0)|0)/60.0;i=a;return +(+h[d>>3])}function aO(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=bK(16)|0;if((c[d>>2]|0)<=1)c[d>>2]=2;a=bK(c[d>>2]<<2)|0;c[c[e>>2]>>2]=a;c[(c[e>>2]|0)+12>>2]=a;c[(c[e>>2]|0)+8>>2]=a;c[(c[e>>2]|0)+4>>2]=(c[c[e>>2]>>2]|0)+(c[d>>2]<<2);i=b;return c[e>>2]|0}function bO(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;O4(c[c[d>>2]>>2]|0);O4(c[d>>2]|0);i=b;return}function cO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=c[f>>2]|0;f=(c[e>>2]|0)+12|0;a=c[f>>2]|0;c[f>>2]=a+4;c[a>>2]=b;if((c[(c[e>>2]|0)+12>>2]|0)>>>0<(c[(c[e>>2]|0)+4>>2]|0)>>>0){i=d;return}c[(c[e>>2]|0)+12>>2]=c[c[e>>2]>>2];i=d;return}function dO(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;if((c[(c[d>>2]|0)+8>>2]|0)==(c[(c[d>>2]|0)+12>>2]|0)){c[e>>2]=0;f=c[e>>2]|0;i=b;return f|0}a=(c[d>>2]|0)+8|0;g=c[a>>2]|0;c[a>>2]=g+4;c[e>>2]=c[g>>2];if((c[(c[d>>2]|0)+8>>2]|0)>>>0<(c[(c[d>>2]|0)+4>>2]|0)>>>0){f=c[e>>2]|0;i=b;return f|0}c[(c[d>>2]|0)+8>>2]=c[c[d>>2]>>2];f=c[e>>2]|0;i=b;return f|0}function eO(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=i;i=i+32|0;h=g+28|0;j=g+24|0;k=g+20|0;l=g+16|0;m=g+12|0;n=g+8|0;o=g+4|0;p=g;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;do if(!(c[k>>2]|0))c[h>>2]=c[l>>2];else{c[n>>2]=zA(c[j>>2]|0,c[k>>2]|0)|0;if((c[n>>2]|0)!=0?(a[c[n>>2]>>0]|0)!=0:0){c[p>>2]=z3(c[n>>2]|0,o,10)|0;if((c[n>>2]|0)==(c[o>>2]|0)){c[h>>2]=c[l>>2];break}if((c[p>>2]|0)<(c[m>>2]|0)){c[h>>2]=c[m>>2];break}else{c[h>>2]=c[p>>2];break}}c[h>>2]=c[l>>2]}while(0);i=g;return c[h>>2]|0}function fO(b,d,e,f){b=b|0;d=d|0;e=+e;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=i;i=i+48|0;j=g+24|0;k=g+44|0;l=g+40|0;m=g+16|0;n=g+8|0;o=g+36|0;p=g+32|0;q=g;c[k>>2]=b;c[l>>2]=d;h[m>>3]=e;h[n>>3]=f;do if((c[l>>2]|0)!=0&(c[k>>2]|0)!=0){c[o>>2]=zA(c[k>>2]|0,c[l>>2]|0)|0;if((c[o>>2]|0)!=0?(a[c[o>>2]>>0]|0)!=0:0){h[q>>3]=+x3(c[o>>2]|0,p);if((c[o>>2]|0)==(c[p>>2]|0)){h[j>>3]=+h[m>>3];break}if(+h[q>>3]<+h[n>>3]){h[j>>3]=+h[n>>3];break}else{h[j>>3]=+h[q>>3];break}}h[j>>3]=+h[m>>3]}else h[j>>3]=+h[m>>3];while(0);i=g;return +(+h[j>>3])}function gO(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+32|0;d=b+8|0;e=b+16|0;f=b;c[e>>2]=a;do if(!(+h[4246]>0.0)){a=c[e>>2]|0;h[f>>3]=+fO(a,qA(c[e>>2]|0,0,145254,0)|0,-1.0,0.0);if(+h[f>>3]==0.0){h[d>>3]=72.0;break}else{h[d>>3]=+h[f>>3];break}}else h[d>>3]=+h[4246];while(0);i=b;return +(+h[d>>3])}function hO(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+12|0;g=e+8|0;h=e+4|0;j=e;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;if((c[h>>2]|0)!=0&(c[g>>2]|0)!=0){c[f>>2]=zA(c[g>>2]|0,c[h>>2]|0)|0;k=c[f>>2]|0;i=e;return k|0}else{c[f>>2]=c[j>>2];k=c[f>>2]|0;i=e;return k|0}return 0}function iO(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;g=f+12|0;h=f+8|0;j=f+4|0;k=f;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;c[k>>2]=hO(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0)|0;if((c[k>>2]|0)!=0?(a[c[k>>2]>>0]|0)!=0:0){l=c[k>>2]|0;i=f;return l|0}c[k>>2]=c[j>>2];l=c[k>>2]|0;i=f;return l|0}function jO(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;g=f+12|0;h=f+8|0;j=f+4|0;k=f;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;if(!(c[j>>2]|0)){a[g>>0]=c[k>>2];l=a[g>>0]|0;i=f;return l|0}else{a[g>>0]=kO(zA(c[h>>2]|0,c[j>>2]|0)|0)|0;l=a[g>>0]|0;i=f;return l|0}return 0}function kO(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;a=uO(c[d>>2]|0,0)|0;i=b;return a|0}function lO(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b;c[d>>2]=a;while(1){if(c[(c[(c[d>>2]|0)+8>>2]|0)+220>>2]|0)e=(c[(c[(c[d>>2]|0)+8>>2]|0)+220>>2]|0)!=(c[d>>2]|0);else e=0;f=c[d>>2]|0;if(!e)break;if(c[(c[(c[(c[f+8>>2]|0)+220>>2]|0)+8>>2]|0)+220>>2]|0)c[(c[(c[d>>2]|0)+8>>2]|0)+220>>2]=c[(c[(c[(c[(c[d>>2]|0)+8>>2]|0)+220>>2]|0)+8>>2]|0)+220>>2];c[d>>2]=c[(c[(c[d>>2]|0)+8>>2]|0)+220>>2]}i=b;return f|0}function mO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d+8|0;f=d+4|0;g=d;c[f>>2]=a;c[g>>2]=b;b=c[f>>2]|0;if((c[f>>2]|0)==(c[g>>2]|0)){c[e>>2]=b;h=c[e>>2]|0;i=d;return h|0}a=c[f>>2]|0;if(!(c[(c[b+8>>2]|0)+220>>2]|0)){c[(c[(c[f>>2]|0)+8>>2]|0)+220>>2]=a;c[(c[(c[f>>2]|0)+8>>2]|0)+216>>2]=1}else c[f>>2]=lO(a)|0;a=c[g>>2]|0;if(!(c[(c[(c[g>>2]|0)+8>>2]|0)+220>>2]|0)){c[(c[(c[g>>2]|0)+8>>2]|0)+220>>2]=a;c[(c[(c[g>>2]|0)+8>>2]|0)+216>>2]=1}else c[g>>2]=lO(a)|0;if((c[(c[(c[f>>2]|0)+8>>2]|0)+120>>2]|0)>(c[(c[(c[g>>2]|0)+8>>2]|0)+120>>2]|0)){c[(c[(c[f>>2]|0)+8>>2]|0)+220>>2]=c[g>>2];a=(c[(c[g>>2]|0)+8>>2]|0)+216|0;c[a>>2]=(c[a>>2]|0)+(c[(c[(c[f>>2]|0)+8>>2]|0)+216>>2]|0)}else{c[(c[(c[g>>2]|0)+8>>2]|0)+220>>2]=c[f>>2];a=(c[(c[f>>2]|0)+8>>2]|0)+216|0;c[a>>2]=(c[a>>2]|0)+(c[(c[(c[g>>2]|0)+8>>2]|0)+216>>2]|0);c[g>>2]=c[f>>2]}c[e>>2]=c[g>>2];h=c[e>>2]|0;i=d;return h|0}function nO(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;c[e>>2]=b;c[(c[(c[e>>2]|0)+8>>2]|0)+216>>2]=1;c[(c[(c[e>>2]|0)+8>>2]|0)+220>>2]=0;a[(c[(c[e>>2]|0)+8>>2]|0)+159>>0]=0;i=d;return}function oO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=c[e>>2]|0;if((b|0)==(lO(c[e>>2]|0)|0)){c[(c[(c[e>>2]|0)+8>>2]|0)+220>>2]=c[f>>2];b=(c[(c[f>>2]|0)+8>>2]|0)+216|0;c[b>>2]=(c[b>>2]|0)+(c[(c[(c[e>>2]|0)+8>>2]|0)+216>>2]|0);i=d;return}else La(145273,145265,195,145289)}function pO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+32|0;e=d+16|0;f=d;c[e>>2]=b;h[f>>3]=+h[c[(c[(c[e>>2]|0)+8>>2]|0)+132>>2]>>3]*72.0;h[f+8>>3]=+h[(c[(c[(c[e>>2]|0)+8>>2]|0)+132>>2]|0)+8>>3]*72.0;c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];i=d;return}function qO(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;g=g|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=i;i=i+608|0;k=j+604|0;l=j+600|0;m=j+576|0;n=j+596|0;o=j+592|0;p=j+588|0;q=j+584|0;r=j;c[k>>2]=b;c[l>>2]=d;h[m>>3]=e;c[n>>2]=f;c[o>>2]=g;c[q>>2]=0;while(1){if((c[q>>2]|0)>(c[l>>2]|0))break;g=r+(c[q>>2]<<4)|0;f=(c[k>>2]|0)+(c[q>>2]<<4)|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];c[q>>2]=(c[q>>2]|0)+1}c[p>>2]=1;while(1){if((c[p>>2]|0)>(c[l>>2]|0))break;c[q>>2]=0;while(1){if((c[q>>2]|0)>((c[l>>2]|0)-(c[p>>2]|0)|0))break;h[r+((c[p>>2]|0)*96|0)+(c[q>>2]<<4)>>3]=(1.0-+h[m>>3])*+h[r+(((c[p>>2]|0)-1|0)*96|0)+(c[q>>2]<<4)>>3]+ +h[m>>3]*+h[r+(((c[p>>2]|0)-1|0)*96|0)+((c[q>>2]|0)+1<<4)>>3];h[r+((c[p>>2]|0)*96|0)+(c[q>>2]<<4)+8>>3]=(1.0-+h[m>>3])*+h[r+(((c[p>>2]|0)-1|0)*96|0)+(c[q>>2]<<4)+8>>3]+ +h[m>>3]*+h[r+(((c[p>>2]|0)-1|0)*96|0)+((c[q>>2]|0)+1<<4)+8>>3];c[q>>2]=(c[q>>2]|0)+1}c[p>>2]=(c[p>>2]|0)+1}a:do if(c[n>>2]|0){c[q>>2]=0;while(1){if((c[q>>2]|0)>(c[l>>2]|0))break a;p=(c[n>>2]|0)+(c[q>>2]<<4)|0;m=r+((c[q>>2]|0)*96|0)|0;c[p>>2]=c[m>>2];c[p+4>>2]=c[m+4>>2];c[p+8>>2]=c[m+8>>2];c[p+12>>2]=c[m+12>>2];c[q>>2]=(c[q>>2]|0)+1}}while(0);if(!(c[o>>2]|0)){s=c[l>>2]|0;t=r+(s*96|0)|0;c[a>>2]=c[t>>2];c[a+4>>2]=c[t+4>>2];c[a+8>>2]=c[t+8>>2];c[a+12>>2]=c[t+12>>2];i=j;return}c[q>>2]=0;while(1){if((c[q>>2]|0)>(c[l>>2]|0))break;n=(c[o>>2]|0)+(c[q>>2]<<4)|0;m=r+(((c[l>>2]|0)-(c[q>>2]|0)|0)*96|0)+(c[q>>2]<<4)|0;c[n>>2]=c[m>>2];c[n+4>>2]=c[m+4>>2];c[n+8>>2]=c[m+8>>2];c[n+12>>2]=c[m+12>>2];c[q>>2]=(c[q>>2]|0)+1}s=c[l>>2]|0;t=r+(s*96|0)|0;c[a>>2]=c[t>>2];c[a+4>>2]=c[t+4>>2];c[a+8>>2]=c[t+8>>2];c[a+12>>2]=c[t+12>>2];i=j;return}function rO(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=b;c[h>>2]=0;do{if(((c[14713]|0)-(c[h>>2]|0)|0)<1024){c[14713]=(c[14713]|0)+1024;c[14714]=eK(c[14714]|0,c[14713]|0)|0}c[g>>2]=V2((c[14714]|0)+(c[h>>2]|0)|0,(c[14713]|0)-(c[h>>2]|0)|0,c[f>>2]|0)|0;if(!(c[g>>2]|0))break;b=N3(c[g>>2]|0)|0;c[h>>2]=(c[h>>2]|0)+b}while((a[(c[14714]|0)+((c[h>>2]|0)-1)>>0]|0)!=10);if((c[h>>2]|0)>0){c[e>>2]=c[14714];j=c[e>>2]|0;i=d;return j|0}else{c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}return 0}function sO(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;i=i+32|0;f=e+8|0;g=e;h=e+28|0;j=e+24|0;k=e+20|0;l=e+16|0;c[j>>2]=b;if((c[j>>2]|0)!=0?(a[c[j>>2]>>0]|0)!=0:0){if(!(c[13794]|0)){if((c[14715]|0)!=(c[13793]|0)){if(c[14717]|0){O4(c[c[14717]>>2]|0);O4(c[14717]|0);c[14717]=0}c[14715]=c[13793];if((c[14715]|0)!=0?(a[c[14715]>>0]|0)!=0:0)c[14717]=XO(c[14715]|0,58864)|0}if((c[14717]|0)!=0?(a[c[j>>2]>>0]|0)!=(a[145579]|0):0){c[h>>2]=YO(c[14717]|0,c[14716]|0,c[j>>2]|0)|0;m=c[h>>2]|0;i=e;return m|0}else{c[h>>2]=c[j>>2];m=c[h>>2]|0;i=e;return m|0}}if((c[13792]|0)!=0?(a[c[13792]>>0]|0)!=0:0){if(!(c[14715]|0)){c[14717]=XO(c[13792]|0,58864)|0;c[14715]=c[13792]}c[k>>2]=c[j>>2];b=S3(c[k>>2]|0,47)|0;c[l>>2]=b;if(b){b=(c[l>>2]|0)+1|0;c[l>>2]=b;c[k>>2]=b}b=S3(c[k>>2]|0,92)|0;c[l>>2]=b;if(b){b=(c[l>>2]|0)+1|0;c[l>>2]=b;c[k>>2]=b}b=S3(c[k>>2]|0,58)|0;c[l>>2]=b;if(b){b=(c[l>>2]|0)+1|0;c[l>>2]=b;c[k>>2]=b}if((d[145300]|0)!=0?(c[k>>2]|0)!=(c[j>>2]|0):0){b=c[13792]|0;c[f>>2]=c[j>>2];c[f+4>>2]=b;$z(0,145426,f)|0;a[145300]=0}c[h>>2]=YO(c[14717]|0,c[14716]|0,c[k>>2]|0)|0;m=c[h>>2]|0;i=e;return m|0}if(a[145300]|0){c[g>>2]=c[13794];$z(0,145301,g)|0;a[145300]=0}c[h>>2]=0;m=c[h>>2]|0;i=e;return m|0}c[h>>2]=0;m=c[h>>2]|0;i=e;return m|0}function tO(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=b;c[h>>2]=d;c[j>>2]=e;c[k>>2]=0;while(1){e=c[(c[h>>2]|0)+(c[k>>2]<<2)>>2]|0;c[l>>2]=e;if(!e){m=7;break}if(((c[g>>2]|0)!=0?(a[c[g>>2]>>0]|0)==(a[c[l>>2]>>0]|0):0)?(J3(c[g>>2]|0,c[l>>2]|0)|0)==0:0){m=7;break}c[k>>2]=(c[k>>2]|0)+1}if((m|0)==7){i=f;return c[(c[j>>2]|0)+(c[k>>2]<<2)>>2]|0}return 0}function uO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+5|0;g=e;h=e+4|0;c[g>>2]=b;a[h>>0]=d;do if((c[g>>2]|0)!=0?(a[c[g>>2]>>0]|0)!=0:0){if(!(F3(c[g>>2]|0,174911)|0)){a[f>>0]=0;break}if(!(F3(c[g>>2]|0,145581)|0)){a[f>>0]=0;break}if(!(F3(c[g>>2]|0,145584)|0)){a[f>>0]=1;break}if(!(F3(c[g>>2]|0,145589)|0)){a[f>>0]=1;break}if(p1(a[c[g>>2]>>0]|0)|0){a[f>>0]=u3(c[g>>2]|0)|0;break}else{a[f>>0]=a[h>>0]|0;break}}else j=3;while(0);if((j|0)==3)a[f>>0]=a[h>>0]|0;i=e;return a[f>>0]|0}function vO(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0;e=i;i=i+240|0;f=e+236|0;g=e+232|0;j=e+228|0;k=e+224|0;l=e+220|0;m=e+216|0;n=e+208|0;o=e+200|0;p=e+192|0;q=e+184|0;r=e+176|0;s=e+168|0;t=e+160|0;u=e+96|0;v=e+80|0;w=e+32|0;x=e+16|0;y=e;c[f>>2]=b;c[m>>2]=-1;c[l>>2]=-1;h[n>>3]=1.e+38;c[g>>2]=0;while(1){if((c[g>>2]|0)>=(c[(c[f>>2]|0)+4>>2]|0))break;z=w;A=(c[c[f>>2]>>2]|0)+((c[g>>2]|0)*48|0)|0;B=z+48|0;do{c[z>>2]=c[A>>2];z=z+4|0;A=A+4|0}while((z|0)<(B|0));c[j>>2]=0;while(1){if((c[j>>2]|0)>=(c[w+4>>2]|0))break;h[x>>3]=+h[(c[w>>2]|0)+(c[j>>2]<<4)>>3];h[x+8>>3]=+h[(c[w>>2]|0)+(c[j>>2]<<4)+8>>3];h[o>>3]=(+h[x>>3]-+h[d>>3])*(+h[x>>3]-+h[d>>3])+(+h[x+8>>3]-+h[d+8>>3])*(+h[x+8>>3]-+h[d+8>>3]);if(!((c[m>>2]|0)!=-1?!(+h[o>>3]<+h[n>>3]):0)){c[l>>2]=c[g>>2];c[m>>2]=c[j>>2];h[n>>3]=+h[o>>3]}c[j>>2]=(c[j>>2]|0)+1}c[g>>2]=(c[g>>2]|0)+1}z=w;A=(c[c[f>>2]>>2]|0)+((c[l>>2]|0)*48|0)|0;B=z+48|0;do{c[z>>2]=c[A>>2];z=z+4|0;A=A+4|0}while((z|0)<(B|0));if((c[m>>2]|0)==((c[w+4>>2]|0)-1|0))c[m>>2]=(c[m>>2]|0)+-1;c[j>>2]=((c[m>>2]|0)/3|0)*3;c[k>>2]=0;while(1){if((c[k>>2]|0)>=4)break;h[u+(c[k>>2]<<4)>>3]=+h[(c[w>>2]|0)+((c[j>>2]|0)+(c[k>>2]|0)<<4)>>3];h[u+(c[k>>2]<<4)+8>>3]=+h[(c[w>>2]|0)+((c[j>>2]|0)+(c[k>>2]|0)<<4)+8>>3];c[k>>2]=(c[k>>2]|0)+1}h[r>>3]=0.0;h[s>>3]=1.0;h[p>>3]=(+h[u>>3]-+h[d>>3])*(+h[u>>3]-+h[d>>3])+(+h[u+8>>3]-+h[d+8>>3])*(+h[u+8>>3]-+h[d+8>>3]);h[q>>3]=(+h[u+48>>3]-+h[d>>3])*(+h[u+48>>3]-+h[d>>3])+(+h[u+48+8>>3]-+h[d+8>>3])*(+h[u+48+8>>3]-+h[d+8>>3]);while(1){h[t>>3]=(+h[r>>3]+ +h[s>>3])/2.0;qO(y,u,3,+h[t>>3],0,0);c[v>>2]=c[y>>2];c[v+4>>2]=c[y+4>>2];c[v+8>>2]=c[y+8>>2];c[v+12>>2]=c[y+12>>2];if(+N(+(+h[p>>3]-+h[q>>3]))<1.0){C=21;break}if(+N(+(+h[s>>3]-+h[r>>3]))<1.0e-05){C=21;break}D=+h[t>>3];if(+h[p>>3]<+h[q>>3]){h[s>>3]=D;h[q>>3]=(+h[v>>3]-+h[d>>3])*(+h[v>>3]-+h[d>>3])+(+h[v+8>>3]-+h[d+8>>3])*(+h[v+8>>3]-+h[d+8>>3]);continue}else{h[r>>3]=D;h[p>>3]=(+h[v>>3]-+h[d>>3])*(+h[v>>3]-+h[d>>3])+(+h[v+8>>3]-+h[d+8>>3])*(+h[v+8>>3]-+h[d+8>>3]);continue}}if((C|0)==21){c[a>>2]=c[v>>2];c[a+4>>2]=c[v+4>>2];c[a+8>>2]=c[v+8>>2];c[a+12>>2]=c[v+12>>2];i=e;return}}function wO(){return c[14718]|0}function xO(b){b=b|0;var e=0,f=0,g=0,j=0,k=0.0,l=0,m=0,n=0,o=0;e=i;i=i+32|0;f=e+20|0;g=e;j=e+16|0;c[f>>2]=b;k=+fO(c[f>>2]|0,c[13815]|0,.75,.01);h[(c[(c[f>>2]|0)+8>>2]|0)+32>>3]=k;k=+fO(c[f>>2]|0,c[13814]|0,.5,.02);h[(c[(c[f>>2]|0)+8>>2]|0)+40>>3]=k;b=iO(c[f>>2]|0,c[13816]|0,145593)|0;l=gM(b,c[f>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]=l;c[j>>2]=zA(c[f>>2]|0,c[13831]|0)|0;h[g>>3]=+fO(c[f>>2]|0,c[13827]|0,14.0,1.0);c[g+8>>2]=iO(c[f>>2]|0,c[13828]|0,145601)|0;c[g+12>>2]=iO(c[f>>2]|0,c[13829]|0,174917)|0;l=c[f>>2]|0;b=c[j>>2]|0;m=($C(c[j>>2]|0)|0)!=0;n=(dM(c[f>>2]|0)|0)==2;o=SJ(l,b,(m?2:0)|(n?4:0),+h[g>>3],c[g+8>>2]|0,c[g+12>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+104>>2]=o;if(((c[13832]|0)!=0?(o=zA(c[f>>2]|0,c[13832]|0)|0,c[j>>2]=o,(o|0)!=0):0)?(a[c[j>>2]>>0]|0)!=0:0){o=c[f>>2]|0;n=c[j>>2]|0;m=($C(c[j>>2]|0)|0)!=0;j=SJ(o,n,m?2:0,+h[g>>3],c[g+8>>2]|0,c[g+12>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+108>>2]=j;j=(c[(qC(c[f>>2]|0)|0)+8>>2]|0)+113|0;a[j>>0]=d[j>>0]|16}j=(eO(c[f>>2]|0,c[13835]|0,0,0)|0)&255;a[(c[(c[f>>2]|0)+8>>2]|0)+144>>0]=j;Bb[c[c[(c[(c[(c[f>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]>>2]&127](c[f>>2]|0);i=e;return}function yO(b){b=b|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=i;i=i+128|0;f=e+124|0;g=e+120|0;j=e+116|0;k=e+96|0;l=e+80|0;m=e+112|0;n=e+40|0;o=e;c[f>>2]=b;c[j>>2]=0;b=c[f>>2]|0;c[m>>2]=qC(c[((c[c[f>>2]>>2]&3|0)==3?b:b+32|0)+28>>2]|0)|0;c[k+8>>2]=0;c[l+8>>2]=0;if(((c[13866]|0)!=0?(b=zA(c[f>>2]|0,c[13866]|0)|0,c[g>>2]=b,(b|0)!=0):0)?(a[c[g>>2]>>0]|0)!=0:0){c[j>>2]=1;ZO(c[f>>2]|0,k);b=c[f>>2]|0;p=c[g>>2]|0;q=($C(c[g>>2]|0)|0)!=0;r=SJ(b,p,q?2:0,+h[k>>3],c[k+8>>2]|0,c[k+12>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+96>>2]=r;r=(c[(c[m>>2]|0)+8>>2]|0)+113|0;a[r>>0]=d[r>>0]|1;r=kO(hO(c[f>>2]|0,c[13876]|0,174911)|0)|0;a[(c[(c[f>>2]|0)+8>>2]|0)+114>>0]=r}if(((c[13867]|0)!=0?(r=zA(c[f>>2]|0,c[13867]|0)|0,c[g>>2]=r,(r|0)!=0):0)?(a[c[g>>2]>>0]|0)!=0:0){if(!(c[k+8>>2]|0))ZO(c[f>>2]|0,k);r=c[f>>2]|0;q=c[g>>2]|0;p=($C(c[g>>2]|0)|0)!=0;b=SJ(r,q,p?2:0,+h[k>>3],c[k+8>>2]|0,c[k+12>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+108>>2]=b;b=(c[(c[m>>2]|0)+8>>2]|0)+113|0;a[b>>0]=d[b>>0]|32}if(((c[13881]|0)!=0?(b=zA(c[f>>2]|0,c[13881]|0)|0,c[g>>2]=b,(b|0)!=0):0)?(a[c[g>>2]>>0]|0)!=0:0){_O(c[f>>2]|0,k,l);b=c[f>>2]|0;p=c[g>>2]|0;q=($C(c[g>>2]|0)|0)!=0;r=SJ(b,p,q?2:0,+h[l>>3],c[l+8>>2]|0,c[l+12>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+100>>2]=r;r=(c[(c[m>>2]|0)+8>>2]|0)+113|0;a[r>>0]=d[r>>0]|2}if(((c[13882]|0)!=0?(r=zA(c[f>>2]|0,c[13882]|0)|0,c[g>>2]=r,(r|0)!=0):0)?(a[c[g>>2]>>0]|0)!=0:0){if(!(c[l+8>>2]|0))_O(c[f>>2]|0,k,l);k=c[f>>2]|0;r=c[g>>2]|0;q=($C(c[g>>2]|0)|0)!=0;p=SJ(k,r,q?2:0,+h[l>>3],c[l+8>>2]|0,c[l+12>>2]|0)|0;c[(c[(c[f>>2]|0)+8>>2]|0)+104>>2]=p;p=(c[(c[m>>2]|0)+8>>2]|0)+113|0;a[p>>0]=d[p>>0]|4}p=yA(c[f>>2]|0,149070)|0;c[g>>2]=p;c[g>>2]=(c[g>>2]|0)!=0?p:178518;if((c[g>>2]|0)!=0?(a[c[g>>2]>>0]|0)!=0:0){p=c[f>>2]|0;a[(c[(c[((c[c[f>>2]>>2]&3|0)==3?p:p+32|0)+28>>2]|0)+8>>2]|0)+145>>0]=1}p=(c[(c[f>>2]|0)+8>>2]|0)+16|0;m=c[f>>2]|0;l=c[f>>2]|0;$O(n,c[(c[(c[(c[(c[((c[c[f>>2]>>2]&3|0)==3?m:m+32|0)+28>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0)+8>>2]|0,c[((c[c[f>>2]>>2]&3|0)==3?l:l+32|0)+28>>2]|0,c[g>>2]|0);l=p;p=n;n=l+40|0;do{c[l>>2]=c[p>>2];l=l+4|0;p=p+4|0}while((l|0)<(n|0));if((aP(c[f>>2]|0,c[13888]|0)|0)<<24>>24)a[(c[(c[f>>2]|0)+8>>2]|0)+16+30>>0]=0;m=yA(c[f>>2]|0,149061)|0;c[g>>2]=m;c[g>>2]=(c[g>>2]|0)!=0?m:178518;if((c[g>>2]|0)!=0?(a[c[g>>2]>>0]|0)!=0:0){m=c[f>>2]|0;a[(c[(c[((c[c[f>>2]>>2]&3|0)==2?m:m+-32|0)+28>>2]|0)+8>>2]|0)+145>>0]=1}m=(c[(c[f>>2]|0)+8>>2]|0)+56|0;q=c[f>>2]|0;r=c[f>>2]|0;$O(o,c[(c[(c[(c[(c[((c[c[f>>2]>>2]&3|0)==2?q:q+-32|0)+28>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0)+8>>2]|0,c[((c[c[f>>2]>>2]&3|0)==2?r:r+-32|0)+28>>2]|0,c[g>>2]|0);l=m;p=o;n=l+40|0;do{c[l>>2]=c[p>>2];l=l+4|0;p=p+4|0}while((l|0)<(n|0));if(!((aP(c[f>>2]|0,c[13889]|0)|0)<<24>>24)){s=c[j>>2]|0;i=e;return s|0}a[(c[(c[f>>2]|0)+8>>2]|0)+56+30>>0]=0;s=c[j>>2]|0;i=e;return s|0}function zO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;d=i;i=i+64|0;e=d+48|0;f=d+44|0;g=d+40|0;j=d+36|0;k=d+32|0;l=d;c[e>>2]=b;c[g>>2]=c[(c[e>>2]|0)+8>>2];if((c[(c[e>>2]|0)+4>>2]|0)>1)m=c[(c[e>>2]|0)+4>>2]|0;else m=1;c[j>>2]=m;c[k>>2]=(c[(c[e>>2]|0)+44>>2]|0)+((_((c[j>>2]|0)-1|0,c[g>>2]|0)|0)<<4);j=l+16|0;e=c[k>>2]|0;c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];c[f>>2]=1;while(1){if((c[f>>2]|0)>=(c[g>>2]|0))break;if(+h[l>>3]<+h[(c[k>>2]|0)+(c[f>>2]<<4)>>3])n=+h[l>>3];else n=+h[(c[k>>2]|0)+(c[f>>2]<<4)>>3];h[l>>3]=n;if(+h[l+8>>3]<+h[(c[k>>2]|0)+(c[f>>2]<<4)+8>>3])o=+h[l+8>>3];else o=+h[(c[k>>2]|0)+(c[f>>2]<<4)+8>>3];h[l+8>>3]=o;if(+h[l+16>>3]>+h[(c[k>>2]|0)+(c[f>>2]<<4)>>3])p=+h[l+16>>3];else p=+h[(c[k>>2]|0)+(c[f>>2]<<4)>>3];h[l+16>>3]=p;if(+h[l+16+8>>3]>+h[(c[k>>2]|0)+(c[f>>2]<<4)+8>>3])q=+h[l+16+8>>3];else q=+h[(c[k>>2]|0)+(c[f>>2]<<4)+8>>3];h[l+16+8>>3]=q;c[f>>2]=(c[f>>2]|0)+1}c[a>>2]=c[l>>2];c[a+4>>2]=c[l+4>>2];c[a+8>>2]=c[l+8>>2];c[a+12>>2]=c[l+12>>2];c[a+16>>2]=c[l+16>>2];c[a+20>>2]=c[l+20>>2];c[a+24>>2]=c[l+24>>2];c[a+28>>2]=c[l+28>>2];i=d;return}function AO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+80|0;e=d+32|0;f=d+68|0;g=d+64|0;h=d;c[f>>2]=a;c[g>>2]=b;b=(c[(c[f>>2]|0)+8>>2]|0)+16|0;a=(c[(c[f>>2]|0)+8>>2]|0)+16|0;j=c[g>>2]|0;g=c[(c[(c[f>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];c[e+16>>2]=c[a+16>>2];c[e+20>>2]=c[a+20>>2];c[e+24>>2]=c[a+24>>2];c[e+28>>2]=c[a+28>>2];bP(h,e,j,g);c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];c[b+16>>2]=c[h+16>>2];c[b+20>>2]=c[h+20>>2];c[b+24>>2]=c[h+24>>2];c[b+28>>2]=c[h+28>>2];i=d;return}function BO(a){a=a|0;var b=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0;b=i;i=i+512|0;e=b+448|0;f=b+336|0;g=b+496|0;j=b+492|0;k=b+488|0;l=b+416|0;m=b+384|0;n=b+352|0;o=b+320|0;p=b+304|0;q=b+484|0;r=b+480|0;s=b+288|0;t=b+272|0;u=b+256|0;v=b+240|0;w=b+224|0;x=b+208|0;y=b+192|0;z=b+160|0;A=b+128|0;B=b+96|0;C=b+64|0;D=b+32|0;E=b;c[g>>2]=a;if((kB(c[g>>2]|0)|0)==0?(c[(c[(c[g>>2]|0)+8>>2]|0)+180>>2]|0)==0:0){cP(s,0.0,0.0);c[m>>2]=c[s>>2];c[m+4>>2]=c[s+4>>2];c[m+8>>2]=c[s+8>>2];c[m+12>>2]=c[s+12>>2];s=m+16|0;cP(t,0.0,0.0);c[s>>2]=c[t>>2];c[s+4>>2]=c[t+4>>2];c[s+8>>2]=c[t+8>>2];c[s+12>>2]=c[t+12>>2];i=b;return}cP(u,2147483647.0,2147483647.0);c[m>>2]=c[u>>2];c[m+4>>2]=c[u+4>>2];c[m+8>>2]=c[u+8>>2];c[m+12>>2]=c[u+12>>2];u=m+16|0;cP(v,-2147483647.0,-2147483647.0);c[u>>2]=c[v>>2];c[u+4>>2]=c[v+4>>2];c[u+8>>2]=c[v+8>>2];c[u+12>>2]=c[v+12>>2];c[j>>2]=$B(c[g>>2]|0)|0;while(1){if(!(c[j>>2]|0))break;pO(w,c[j>>2]|0);c[o>>2]=c[w>>2];c[o+4>>2]=c[w+4>>2];c[o+8>>2]=c[w+8>>2];c[o+12>>2]=c[w+12>>2];h[p>>3]=(+h[(c[(c[j>>2]|0)+8>>2]|0)+88>>3]+ +h[(c[(c[j>>2]|0)+8>>2]|0)+96>>3])/2.0;h[p+8>>3]=+h[(c[(c[j>>2]|0)+8>>2]|0)+80>>3]/2.0;c[f>>2]=c[o>>2];c[f+4>>2]=c[o+4>>2];c[f+8>>2]=c[o+8>>2];c[f+12>>2]=c[o+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];dP(x,f,e);c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[l+12>>2]=c[x+12>>2];v=l+16|0;c[f>>2]=c[o>>2];c[f+4>>2]=c[o+4>>2];c[f+8>>2]=c[o+8>>2];c[f+12>>2]=c[o+12>>2];c[e>>2]=c[p>>2];c[e+4>>2]=c[p+4>>2];c[e+8>>2]=c[p+8>>2];c[e+12>>2]=c[p+12>>2];eP(y,f,e);c[v>>2]=c[y>>2];c[v+4>>2]=c[y+4>>2];c[v+8>>2]=c[y+8>>2];c[v+12>>2]=c[y+12>>2];h[m>>3]=+h[m>>3]<+h[l>>3]?+h[m>>3]:+h[l>>3];h[m+8>>3]=+h[m+8>>3]<+h[l+8>>3]?+h[m+8>>3]:+h[l+8>>3];h[m+16>>3]=+h[m+16>>3]>+h[l+16>>3]?+h[m+16>>3]:+h[l+16>>3];if(+h[m+16+8>>3]>+h[l+16+8>>3])F=+h[m+16+8>>3];else F=+h[l+16+8>>3];h[m+16+8>>3]=F;if((c[(c[(c[j>>2]|0)+8>>2]|0)+108>>2]|0)!=0?(d[(c[(c[(c[j>>2]|0)+8>>2]|0)+108>>2]|0)+81>>0]|0|0)!=0:0){v=c[(c[(c[j>>2]|0)+8>>2]|0)+108>>2]|0;u=c[(c[(c[g>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];c[e+16>>2]=c[m+16>>2];c[e+20>>2]=c[m+20>>2];c[e+24>>2]=c[m+24>>2];c[e+28>>2]=c[m+28>>2];bP(z,e,v,u);c[m>>2]=c[z>>2];c[m+4>>2]=c[z+4>>2];c[m+8>>2]=c[z+8>>2];c[m+12>>2]=c[z+12>>2];c[m+16>>2]=c[z+16>>2];c[m+20>>2]=c[z+20>>2];c[m+24>>2]=c[z+24>>2];c[m+28>>2]=c[z+28>>2]}c[k>>2]=OA(c[g>>2]|0,c[j>>2]|0)|0;while(1){if(!(c[k>>2]|0))break;if(c[(c[(c[k>>2]|0)+8>>2]|0)+8>>2]|0){c[q>>2]=0;while(1){if((c[q>>2]|0)>=(c[(c[(c[(c[k>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0))break;c[r>>2]=0;while(1){if((c[r>>2]|0)>=(c[(c[c[(c[(c[k>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[q>>2]|0)*48|0)+4>>2]|0))break;u=(c[(c[c[(c[(c[k>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[q>>2]|0)*48|0)>>2]|0)+(c[r>>2]<<4)|0;c[o>>2]=c[u>>2];c[o+4>>2]=c[u+4>>2];c[o+8>>2]=c[u+8>>2];c[o+12>>2]=c[u+12>>2];h[m>>3]=+h[m>>3]<+h[o>>3]?+h[m>>3]:+h[o>>3];h[m+8>>3]=+h[m+8>>3]<+h[o+8>>3]?+h[m+8>>3]:+h[o+8>>3];h[m+16>>3]=+h[m+16>>3]>+h[o>>3]?+h[m+16>>3]:+h[o>>3];if(+h[m+16+8>>3]>+h[o+8>>3])G=+h[m+16+8>>3];else G=+h[o+8>>3];h[m+16+8>>3]=G;c[r>>2]=(c[r>>2]|0)+1}c[q>>2]=(c[q>>2]|0)+1}if((c[(c[(c[k>>2]|0)+8>>2]|0)+96>>2]|0)!=0?(d[(c[(c[(c[k>>2]|0)+8>>2]|0)+96>>2]|0)+81>>0]|0|0)!=0:0){u=c[(c[(c[k>>2]|0)+8>>2]|0)+96>>2]|0;v=c[(c[(c[g>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];c[e+16>>2]=c[m+16>>2];c[e+20>>2]=c[m+20>>2];c[e+24>>2]=c[m+24>>2];c[e+28>>2]=c[m+28>>2];bP(A,e,u,v);c[m>>2]=c[A>>2];c[m+4>>2]=c[A+4>>2];c[m+8>>2]=c[A+8>>2];c[m+12>>2]=c[A+12>>2];c[m+16>>2]=c[A+16>>2];c[m+20>>2]=c[A+20>>2];c[m+24>>2]=c[A+24>>2];c[m+28>>2]=c[A+28>>2]}if((c[(c[(c[k>>2]|0)+8>>2]|0)+100>>2]|0)!=0?(d[(c[(c[(c[k>>2]|0)+8>>2]|0)+100>>2]|0)+81>>0]|0|0)!=0:0){v=c[(c[(c[k>>2]|0)+8>>2]|0)+100>>2]|0;u=c[(c[(c[g>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];c[e+16>>2]=c[m+16>>2];c[e+20>>2]=c[m+20>>2];c[e+24>>2]=c[m+24>>2];c[e+28>>2]=c[m+28>>2];bP(B,e,v,u);c[m>>2]=c[B>>2];c[m+4>>2]=c[B+4>>2];c[m+8>>2]=c[B+8>>2];c[m+12>>2]=c[B+12>>2];c[m+16>>2]=c[B+16>>2];c[m+20>>2]=c[B+20>>2];c[m+24>>2]=c[B+24>>2];c[m+28>>2]=c[B+28>>2]}if((c[(c[(c[k>>2]|0)+8>>2]|0)+104>>2]|0)!=0?(d[(c[(c[(c[k>>2]|0)+8>>2]|0)+104>>2]|0)+81>>0]|0|0)!=0:0){u=c[(c[(c[k>>2]|0)+8>>2]|0)+104>>2]|0;v=c[(c[(c[g>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];c[e+16>>2]=c[m+16>>2];c[e+20>>2]=c[m+20>>2];c[e+24>>2]=c[m+24>>2];c[e+28>>2]=c[m+28>>2];bP(C,e,u,v);c[m>>2]=c[C>>2];c[m+4>>2]=c[C+4>>2];c[m+8>>2]=c[C+8>>2];c[m+12>>2]=c[C+12>>2];c[m+16>>2]=c[C+16>>2];c[m+20>>2]=c[C+20>>2];c[m+24>>2]=c[C+24>>2];c[m+28>>2]=c[C+28>>2]}if((c[(c[(c[k>>2]|0)+8>>2]|0)+108>>2]|0)!=0?(d[(c[(c[(c[k>>2]|0)+8>>2]|0)+108>>2]|0)+81>>0]|0|0)!=0:0){v=c[(c[(c[k>>2]|0)+8>>2]|0)+108>>2]|0;u=c[(c[(c[g>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];c[e+16>>2]=c[m+16>>2];c[e+20>>2]=c[m+20>>2];c[e+24>>2]=c[m+24>>2];c[e+28>>2]=c[m+28>>2];bP(D,e,v,u);c[m>>2]=c[D>>2];c[m+4>>2]=c[D+4>>2];c[m+8>>2]=c[D+8>>2];c[m+12>>2]=c[D+12>>2];c[m+16>>2]=c[D+16>>2];c[m+20>>2]=c[D+20>>2];c[m+24>>2]=c[D+24>>2];c[m+28>>2]=c[D+28>>2]}}c[k>>2]=QA(c[g>>2]|0,c[k>>2]|0)|0}c[j>>2]=aC(c[g>>2]|0,c[j>>2]|0)|0}c[q>>2]=1;while(1){if((c[q>>2]|0)>(c[(c[(c[g>>2]|0)+8>>2]|0)+180>>2]|0))break;h[n>>3]=+h[(c[(c[(c[(c[(c[g>>2]|0)+8>>2]|0)+184>>2]|0)+(c[q>>2]<<2)>>2]|0)+8>>2]|0)+16>>3];h[n+8>>3]=+h[(c[(c[(c[(c[(c[g>>2]|0)+8>>2]|0)+184>>2]|0)+(c[q>>2]<<2)>>2]|0)+8>>2]|0)+16+8>>3];h[n+16>>3]=+h[(c[(c[(c[(c[(c[g>>2]|0)+8>>2]|0)+184>>2]|0)+(c[q>>2]<<2)>>2]|0)+8>>2]|0)+16+16>>3];h[n+16+8>>3]=+h[(c[(c[(c[(c[(c[g>>2]|0)+8>>2]|0)+184>>2]|0)+(c[q>>2]<<2)>>2]|0)+8>>2]|0)+16+16+8>>3];h[m>>3]=+h[m>>3]<+h[n>>3]?+h[m>>3]:+h[n>>3];h[m+8>>3]=+h[m+8>>3]<+h[n+8>>3]?+h[m+8>>3]:+h[n+8>>3];h[m+16>>3]=+h[m+16>>3]>+h[n+16>>3]?+h[m+16>>3]:+h[n+16>>3];if(+h[m+16+8>>3]>+h[n+16+8>>3])H=+h[m+16+8>>3];else H=+h[n+16+8>>3];h[m+16+8>>3]=H;c[q>>2]=(c[q>>2]|0)+1}if((c[(c[(c[g>>2]|0)+8>>2]|0)+12>>2]|0)!=0?(d[(c[(c[(c[g>>2]|0)+8>>2]|0)+12>>2]|0)+81>>0]|0|0)!=0:0){q=c[(c[(c[g>>2]|0)+8>>2]|0)+12>>2]|0;n=c[(c[(c[g>>2]|0)+8>>2]|0)+116>>2]&1;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];c[e+16>>2]=c[m+16>>2];c[e+20>>2]=c[m+20>>2];c[e+24>>2]=c[m+24>>2];c[e+28>>2]=c[m+28>>2];bP(E,e,q,n);c[m>>2]=c[E>>2];c[m+4>>2]=c[E+4>>2];c[m+8>>2]=c[E+8>>2];c[m+12>>2]=c[E+12>>2];c[m+16>>2]=c[E+16>>2];c[m+20>>2]=c[E+20>>2];c[m+24>>2]=c[E+24>>2];c[m+28>>2]=c[E+28>>2]}E=(c[(c[g>>2]|0)+8>>2]|0)+16|0;c[E>>2]=c[m>>2];c[E+4>>2]=c[m+4>>2];c[E+8>>2]=c[m+8>>2];c[E+12>>2]=c[m+12>>2];c[E+16>>2]=c[m+16>>2];c[E+20>>2]=c[m+20>>2];c[E+24>>2]=c[m+24>>2];c[E+28>>2]=c[m+28>>2];i=b;return}function CO(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if((c[d>>2]|0)==(c[(c[d>>2]|0)+48>>2]|0)){e=1;f=e&1;i=b;return f|0}e=(O3(wB(c[d>>2]|0)|0,145613,7)|0)!=0^1;f=e&1;i=b;return f|0}function DO(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;g=i;i=i+32|0;h=g+16|0;j=g+12|0;k=g+8|0;l=g+4|0;m=g;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;a:do if(!(c[m>>2]|0))switch(BC(c[j>>2]|0)|0){case 0:{c[m>>2]=qA(c[h>>2]|0,0,c[k>>2]|0,178518)|0;break a;break}case 1:{c[m>>2]=qA(c[h>>2]|0,1,c[k>>2]|0,178518)|0;break a;break}case 2:{c[m>>2]=qA(c[h>>2]|0,2,c[k>>2]|0,178518)|0;break a;break}default:break a}while(0);BA(c[j>>2]|0,c[m>>2]|0,c[l>>2]|0)|0;i=g;return c[m>>2]|0}function EO(d){d=d|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=i;i=i+176|0;g=f+44|0;h=f+40|0;j=f+36|0;k=f+32|0;l=f+28|0;m=f+24|0;n=f+8|0;o=f+4|0;p=f;c[g>>2]=d;c[p>>2]=FO(c[g>>2]|0)|0;c[o>>2]=Nz(58876,c[12989]|0)|0;c[m>>2]=FD(c[g>>2]|0,145621,1)|0;MC(c[m>>2]|0,175049,280,1)|0;dA(n,128,f+48|0);c[j>>2]=$B(c[g>>2]|0)|0;while(1){if(!(c[j>>2]|0))break;a:do if(!(a[(c[(c[j>>2]|0)+8>>2]|0)+118>>0]|0)){c[l>>2]=OA(c[g>>2]|0,c[j>>2]|0)|0;while(1){if(!(c[l>>2]|0))break a;fP(c[l>>2]|0,c[m>>2]|0,n,c[o>>2]|0,c[p>>2]|0);c[l>>2]=QA(c[g>>2]|0,c[l>>2]|0)|0}}while(0);c[j>>2]=aC(c[g>>2]|0,c[j>>2]|0)|0}hA(n);Jz(c[o>>2]|0)|0;c[h>>2]=kB(c[m>>2]|0)|0;c[j>>2]=$B(c[m>>2]|0)|0;while(1){q=c[m>>2]|0;if(!(c[j>>2]|0))break;c[k>>2]=aC(q,c[j>>2]|0)|0;pC(c[g>>2]|0,c[j>>2]|0)|0;c[j>>2]=c[k>>2]}jB(q)|0;if(!(c[h>>2]|0)){r=c[p>>2]|0;Jz(r)|0;s=c[h>>2]|0;i=f;return s|0}q=(c[(c[g>>2]|0)+8>>2]|0)+136|0;b[q>>1]=e[q>>1]|1;r=c[p>>2]|0;Jz(r)|0;s=c[h>>2]|0;i=f;return s|0}function FO(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;c[e>>2]=Nz(58912,c[12989]|0)|0;gP(c[d>>2]|0,c[e>>2]|0);i=b;return c[e>>2]|0}function GO(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+16|0;d=b+12|0;e=b+8|0;f=b+4|0;g=b;c[d>>2]=a;c[g>>2]=FD(c[d>>2]|0,145621,1)|0;MC(c[g>>2]|0,175049,280,1)|0;c[e>>2]=$B(c[d>>2]|0)|0;while(1){if(!(c[e>>2]|0))break;c[f>>2]=OA(c[d>>2]|0,c[e>>2]|0)|0;while(1){if(!(c[f>>2]|0))break;hP(c[f>>2]|0,c[g>>2]|0);c[f>>2]=QA(c[d>>2]|0,c[f>>2]|0)|0}c[e>>2]=aC(c[d>>2]|0,c[e>>2]|0)|0}c[e>>2]=$B(c[g>>2]|0)|0;while(1){if(!(c[e>>2]|0))break;pC(c[d>>2]|0,c[e>>2]|0)|0;c[e>>2]=aC(c[g>>2]|0,c[e>>2]|0)|0}jB(c[g>>2]|0)|0;i=b;return}function HO(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=f+16|0;h=f+12|0;j=f+8|0;k=f+4|0;l=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l>>2]=qA(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0,0)|0;if(c[l>>2]|0){m=c[l>>2]|0;i=f;return m|0}c[l>>2]=qA(c[g>>2]|0,c[h>>2]|0,c[j>>2]|0,c[k>>2]|0)|0;m=c[l>>2]|0;i=f;return m|0}function IO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=i;i=i+64|0;f=e;g=e+36|0;h=e+32|0;j=e+28|0;k=e+24|0;l=e+16|0;m=e+8|0;n=e+4|0;o=e+40|0;c[h>>2]=b;c[j>>2]=d;c[k>>2]=H3(c[h>>2]|0,59)|0;if((c[(c[j>>2]|0)+4>>2]|0)>>>0>=(c[(c[j>>2]|0)+8>>2]|0)>>>0)eA(c[j>>2]|0,1)|0;d=(c[j>>2]|0)+4|0;b=c[d>>2]|0;c[d>>2]=b+1;a[b>>0]=38;if(!(c[k>>2]|0)){c[g>>2]=c[h>>2];p=c[g>>2]|0;i=e;return p|0}b=(c[k>>2]|0)-(c[h>>2]|0)|0;c[n>>2]=b;if((b|0)>8|(c[n>>2]|0)<2){c[g>>2]=c[h>>2];p=c[g>>2]|0;i=e;return p|0}Q3(o,c[h>>2]|0,c[n>>2]|0)|0;a[o+(c[n>>2]|0)>>0]=0;c[l>>2]=o;c[m>>2]=v3(l,58948,252,8,96)|0;if(!(c[m>>2]|0)){c[g>>2]=c[h>>2];p=c[g>>2]|0;i=e;return p|0}c[f>>2]=c[(c[m>>2]|0)+4>>2];k3(o,175023,f)|0;if((c[(c[j>>2]|0)+4>>2]|0)>>>0>=(c[(c[j>>2]|0)+8>>2]|0)>>>0)eA(c[j>>2]|0,1)|0;f=(c[j>>2]|0)+4|0;m=c[f>>2]|0;c[f>>2]=m+1;a[m>>0]=35;gA(c[j>>2]|0,o)|0;if((c[(c[j>>2]|0)+4>>2]|0)>>>0>=(c[(c[j>>2]|0)+8>>2]|0)>>>0)eA(c[j>>2]|0,1)|0;o=(c[j>>2]|0)+4|0;j=c[o>>2]|0;c[o>>2]=j+1;a[j>>0]=59;c[g>>2]=(c[k>>2]|0)+1;p=c[g>>2]|0;i=e;return p|0}function JO(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;f=i;i=i+1088|0;g=f+8|0;h=f;j=f+56|0;k=f+52|0;l=f+48|0;m=f+32|0;n=f+60|0;o=f+28|0;p=f+24|0;q=f+20|0;r=f+16|0;c[j>>2]=b;c[k>>2]=e;if((c[15241]|0)!=(c[k>>2]|0)){c[15241]=c[k>>2];a[145636]=0}dA(m,1024,f+64|0);while(1){e=c[j>>2]|0;c[j>>2]=e+1;b=a[e>>0]|0;a[n>>0]=b;if(!(b<<24>>24))break;do if((d[n>>0]|0)<192)c[q>>2]=0;else{if((d[n>>0]|0)<224){c[q>>2]=1;break}if((d[n>>0]|0)<240){c[q>>2]=2;break}if((d[n>>0]|0)<248){c[q>>2]=3;break}c[q>>2]=-1;if(!(a[145636]|0)){c[h>>2]=wB(c[k>>2]|0)|0;$z(0,145637,h)|0;a[145636]=1}a[n>>0]=jP(a[n>>0]|0,m)|0}while(0);do if((c[q>>2]|0)==0?(d[n>>0]|0)==38:0){c[o>>2]=kP(j)|0;if(c[o>>2]|0){b=c[o>>2]|0;if((c[o>>2]|0)>>>0<127){a[n>>0]=b;break}e=(c[m+4>>2]|0)>>>0>=(c[m+8>>2]|0)>>>0;if(b>>>0<2047){if(e)eA(m,1)|0;b=((c[o>>2]|0)>>>6&255|192)&255;s=m+4|0;t=c[s>>2]|0;c[s>>2]=t+1;a[t>>0]=b;c[p>>2]=b&255;a[n>>0]=c[o>>2]&63|128;break}if(e)eA(m,1)|0;e=((c[o>>2]|0)>>>12&255|224)&255;b=m+4|0;t=c[b>>2]|0;c[b>>2]=t+1;a[t>>0]=e;c[p>>2]=e&255;if((c[m+4>>2]|0)>>>0>=(c[m+8>>2]|0)>>>0)eA(m,1)|0;e=((c[o>>2]|0)>>>6&63|128)&255;t=m+4|0;b=c[t>>2]|0;c[t>>2]=b+1;a[b>>0]=e;c[p>>2]=e&255;a[n>>0]=c[o>>2]&63|128}}else u=30;while(0);a:do if((u|0)==30){u=0;c[r>>2]=0;while(1){if((c[r>>2]|0)>=(c[q>>2]|0))break a;if((a[c[j>>2]>>0]&192|0)!=128)break;if((c[m+4>>2]|0)>>>0>=(c[m+8>>2]|0)>>>0)eA(m,1)|0;e=a[n>>0]|0;b=m+4|0;t=c[b>>2]|0;c[b>>2]=t+1;a[t>>0]=e;c[p>>2]=e&255;e=c[j>>2]|0;c[j>>2]=e+1;a[n>>0]=a[e>>0]|0;c[r>>2]=(c[r>>2]|0)+1}if(!(a[145636]|0)){e=(c[q>>2]|0)+1|0;t=wB(c[k>>2]|0)|0;c[g>>2]=e;c[g+4>>2]=t;$z(0,145758,g)|0;a[145636]=1}a[n>>0]=jP(a[n>>0]|0,m)|0}while(0);if((c[m+4>>2]|0)>>>0>=(c[m+8>>2]|0)>>>0)eA(m,1)|0;t=a[n>>0]|0;e=m+4|0;b=c[e>>2]|0;c[e>>2]=b+1;a[b>>0]=t;c[p>>2]=t&255}if((c[m+4>>2]|0)>>>0<(c[m+8>>2]|0)>>>0){v=m+4|0;w=c[v>>2]|0;x=w+1|0;c[v>>2]=x;a[w>>0]=0;y=c[m>>2]|0;z=m+4|0;c[z>>2]=y;A=M3(y)|0;c[l>>2]=A;hA(m);B=c[l>>2]|0;i=f;return B|0}eA(m,1)|0;v=m+4|0;w=c[v>>2]|0;x=w+1|0;c[v>>2]=x;a[w>>0]=0;y=c[m>>2]|0;z=m+4|0;c[z>>2]=y;A=M3(y)|0;c[l>>2]=A;hA(m);B=c[l>>2]|0;i=f;return B|0}function KO(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;e=i;i=i+1056|0;f=e+28|0;g=e+24|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=b;dA(h,1024,e+32|0);while(1){b=c[f>>2]|0;c[f>>2]=b+1;l=d[b>>0]|0;c[j>>2]=l;if(!l)break;if((c[j>>2]|0)==38){l=kP(f)|0;c[j>>2]=l;c[j>>2]=(c[j>>2]|0)!=0?l:38}if((c[j>>2]|0)>>>0<127){if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;l=c[j>>2]&255;b=h+4|0;m=c[b>>2]|0;c[b>>2]=m+1;a[m>>0]=l;c[k>>2]=l&255;continue}l=(c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0;if((c[j>>2]|0)>>>0<2047){if(l)eA(h,1)|0;m=((c[j>>2]|0)>>>6&255|192)&255;b=h+4|0;n=c[b>>2]|0;c[b>>2]=n+1;a[n>>0]=m;c[k>>2]=m&255;if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;m=(c[j>>2]&63|128)&255;n=h+4|0;b=c[n>>2]|0;c[n>>2]=b+1;a[b>>0]=m;c[k>>2]=m&255;continue}if(l)eA(h,1)|0;l=((c[j>>2]|0)>>>12&255|224)&255;m=h+4|0;b=c[m>>2]|0;c[m>>2]=b+1;a[b>>0]=l;c[k>>2]=l&255;if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;l=((c[j>>2]|0)>>>6&63|128)&255;b=h+4|0;m=c[b>>2]|0;c[b>>2]=m+1;a[m>>0]=l;c[k>>2]=l&255;if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;l=(c[j>>2]&63|128)&255;m=h+4|0;b=c[m>>2]|0;c[m>>2]=b+1;a[b>>0]=l;c[k>>2]=l&255}if((c[h+4>>2]|0)>>>0<(c[h+8>>2]|0)>>>0){o=h+4|0;p=c[o>>2]|0;q=p+1|0;c[o>>2]=q;a[p>>0]=0;r=c[h>>2]|0;s=h+4|0;c[s>>2]=r;t=M3(r)|0;c[g>>2]=t;hA(h);u=c[g>>2]|0;i=e;return u|0}eA(h,1)|0;o=h+4|0;p=c[o>>2]|0;q=p+1|0;c[o>>2]=q;a[p>>0]=0;r=c[h>>2]|0;s=h+4|0;c[s>>2]=r;t=M3(r)|0;c[g>>2]=t;hA(h);u=c[g>>2]|0;i=e;return u|0}function LO(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;e=i;i=i+1072|0;f=e+28|0;g=e+24|0;h=e+8|0;j=e+33|0;k=e+32|0;l=e;c[f>>2]=b;dA(h,1024,e+40|0);while(1){b=c[f>>2]|0;c[f>>2]=b+1;m=a[b>>0]|0;a[j>>0]=m;if(!(m<<24>>24))break;if((d[j>>0]|0|0)<127){if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;m=a[j>>0]|0;b=h+4|0;n=c[b>>2]|0;c[b>>2]=n+1;a[n>>0]=m;c[l>>2]=m&255;continue}else{a[k>>0]=((d[j>>0]|0)&3)<<6;m=c[f>>2]|0;c[f>>2]=m+1;a[j>>0]=a[m>>0]|0;a[k>>0]=d[k>>0]|0|(d[j>>0]|0)&63;if((c[h+4>>2]|0)>>>0>=(c[h+8>>2]|0)>>>0)eA(h,1)|0;m=a[k>>0]|0;n=h+4|0;b=c[n>>2]|0;c[n>>2]=b+1;a[b>>0]=m;c[l>>2]=m&255;continue}}if((c[h+4>>2]|0)>>>0<(c[h+8>>2]|0)>>>0){o=h+4|0;p=c[o>>2]|0;q=p+1|0;c[o>>2]=q;a[p>>0]=0;r=c[h>>2]|0;s=h+4|0;c[s>>2]=r;t=M3(r)|0;c[g>>2]=t;hA(h);u=c[g>>2]|0;i=e;return u|0}eA(h,1)|0;o=h+4|0;p=c[o>>2]|0;q=p+1|0;c[o>>2]=q;a[p>>0]=0;r=c[h>>2]|0;s=h+4|0;c[s>>2]=r;t=M3(r)|0;c[g>>2]=t;hA(h);u=c[g>>2]|0;i=e;return u|0}function MO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+96|0;f=e+64|0;g=e+48|0;j=e+92|0;k=e+88|0;l=e+80|0;m=e+32|0;n=e+16|0;o=e;c[k>>2]=b;if(((+h[d+16>>3]>=+h[(c[(c[k>>2]|0)+8>>2]|0)+48>>3]?+h[(c[(c[k>>2]|0)+8>>2]|0)+48+16>>3]>=+h[d>>3]:0)?+h[d+16+8>>3]>=+h[(c[(c[k>>2]|0)+8>>2]|0)+48+8>>3]:0)?+h[(c[(c[k>>2]|0)+8>>2]|0)+48+16+8>>3]>=+h[d+8>>3]:0){b=(c[(c[k>>2]|0)+8>>2]|0)+16|0;p=d+16|0;c[g>>2]=c[p>>2];c[g+4>>2]=c[p+4>>2];c[g+8>>2]=c[p+8>>2];c[g+12>>2]=c[p+12>>2];c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];lP(n,g,f);c[g>>2]=c[b>>2];c[g+4>>2]=c[b+4>>2];c[g+8>>2]=c[b+8>>2];c[g+12>>2]=c[b+12>>2];c[f>>2]=c[n>>2];c[f+4>>2]=c[n+4>>2];c[f+8>>2]=c[n+8>>2];c[f+12>>2]=c[n+12>>2];dP(o,g,f);c[m>>2]=c[o>>2];c[m+4>>2]=c[o+4>>2];c[m+8>>2]=c[o+8>>2];c[m+12>>2]=c[o+12>>2];c[l>>2]=c[k>>2];c[l+4>>2]=0;o=c[(c[(c[(c[(c[k>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0)+12>>2]|0;c[f>>2]=c[m>>2];c[f+4>>2]=c[m+4>>2];c[f+8>>2]=c[m+8>>2];c[f+12>>2]=c[m+12>>2];a[j>>0]=Ob[o&127](l,f)|0;q=a[j>>0]|0;i=e;return q|0}a[j>>0]=0;q=a[j>>0]|0;i=e;return q|0}function NO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;i=i+128|0;e=d+96|0;f=d+80|0;g=d+112|0;j=d+64|0;k=d+32|0;l=d+16|0;m=d;c[g>>2]=a;h[j>>3]=+h[(c[g>>2]|0)+24>>3]/2.0;h[j+8>>3]=+h[(c[g>>2]|0)+24+8>>3]/2.0;a=(c[g>>2]|0)+56|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];dP(l,f,e);c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];l=k+16|0;a=(c[g>>2]|0)+56|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];eP(m,f,e);c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];if(!(+h[b+16>>3]>=+h[k>>3])){n=0;o=n&1;p=o&255;i=d;return p|0}if(!(+h[k+16>>3]>=+h[b>>3])){n=0;o=n&1;p=o&255;i=d;return p|0}if(!(+h[b+16+8>>3]>=+h[k+8>>3])){n=0;o=n&1;p=o&255;i=d;return p|0}n=+h[k+16+8>>3]>=+h[b+8>>3];o=n&1;p=o&255;i=d;return p|0}function OO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=i;i=i+112|0;f=e+48|0;g=e;h=e+96|0;j=e+92|0;k=e+88|0;l=e+84|0;m=e+80|0;c[j>>2]=b;c[l>>2]=c[(c[(c[j>>2]|0)+8>>2]|0)+8>>2];a:do if((c[l>>2]|0)!=0?(b=(c[l>>2]|0)+8|0,c[g>>2]=c[b>>2],c[g+4>>2]=c[b+4>>2],c[g+8>>2]=c[b+8>>2],c[g+12>>2]=c[b+12>>2],c[g+16>>2]=c[b+16>>2],c[g+20>>2]=c[b+20>>2],c[g+24>>2]=c[b+24>>2],c[g+28>>2]=c[b+28>>2],c[f>>2]=c[d>>2],c[f+4>>2]=c[d+4>>2],c[f+8>>2]=c[d+8>>2],c[f+12>>2]=c[d+12>>2],c[f+16>>2]=c[d+16>>2],c[f+20>>2]=c[d+20>>2],c[f+24>>2]=c[d+24>>2],c[f+28>>2]=c[d+28>>2],(mP(g,f)|0)!=0):0){c[k>>2]=0;while(1){if((c[k>>2]|0)>=(c[(c[l>>2]|0)+4>>2]|0))break a;b=g;n=(c[c[l>>2]>>2]|0)+((c[k>>2]|0)*48|0)|0;o=b+48|0;do{c[b>>2]=c[n>>2];b=b+4|0;n=n+4|0}while((b|0)<(o|0));c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];if((nP(g,f)|0)<<24>>24)break;c[k>>2]=(c[k>>2]|0)+1}a[h>>0]=1;p=a[h>>0]|0;i=e;return p|0}while(0);c[m>>2]=c[(c[(c[j>>2]|0)+8>>2]|0)+96>>2];if((c[m>>2]|0)!=0?(j=c[m>>2]|0,c[f>>2]=c[d>>2],c[f+4>>2]=c[d+4>>2],c[f+8>>2]=c[d+8>>2],c[f+12>>2]=c[d+12>>2],c[f+16>>2]=c[d+16>>2],c[f+20>>2]=c[d+20>>2],c[f+24>>2]=c[d+24>>2],c[f+28>>2]=c[d+28>>2],((NO(j,f)|0)&255|0)!=0):0){a[h>>0]=1;p=a[h>>0]|0;i=e;return p|0}a[h>>0]=0;p=a[h>>0]|0;i=e;return p|0}function PO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;c[h>>2]=b;c[j>>2]=d;if((c[h>>2]|0)!=0?(a[c[h>>2]>>0]|0)!=0:0){c[k>>2]=0;a:do switch(a[c[h>>2]>>0]|0){case 48:{c[k>>2]=2;break}case 57:case 56:case 55:case 54:case 53:case 52:case 51:case 50:case 49:{c[k>>2]=10;break}case 67:case 99:{if(!(F3((c[h>>2]|0)+1|0,145867)|0)){c[k>>2]=4;break a}if(!(F3((c[h>>2]|0)+1|0,145873)|0))c[k>>2]=12;break}case 70:case 102:{if(!(F3((c[h>>2]|0)+1|0,145881)|0))c[k>>2]=2;break}case 76:case 108:{if(!(F3((c[h>>2]|0)+1|0,145886)|0))c[k>>2]=2;break}case 78:case 110:{if(!(F3((c[h>>2]|0)+1|0,145890)|0)){c[g>>2]=c[k>>2];l=c[g>>2]|0;i=e;return l|0}if(!(F3((c[h>>2]|0)+1|0,145894)|0)){c[g>>2]=2;l=c[g>>2]|0;i=e;return l|0}break}case 79:case 111:{if(!(F3((c[h>>2]|0)+1|0,145896)|0))c[k>>2]=8;break}case 80:case 112:{if(!(F3((c[h>>2]|0)+1|0,145901)|0))c[k>>2]=6;break}case 83:case 115:{if(!(F3((c[h>>2]|0)+1|0,145909)|0))c[k>>2]=10;break}case 84:case 116:{if(!(F3((c[h>>2]|0)+1|0,145915)|0))c[k>>2]=10;break}case 89:case 121:{if(!(F3((c[h>>2]|0)+1|0,145919)|0))c[k>>2]=10;break}default:{}}while(0);if(!(c[k>>2]|0)){c[f>>2]=c[h>>2];$z(0,145922,f)|0;c[k>>2]=c[j>>2]}c[g>>2]=c[k>>2];l=c[g>>2]|0;i=e;return l|0}c[g>>2]=c[j>>2];l=c[g>>2]|0;i=e;return l|0}function QO(d,f){d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;g=i;i=i+16|0;h=g+12|0;j=g+8|0;k=g+4|0;l=g;c[h>>2]=d;c[j>>2]=f;c[k>>2]=yA(c[h>>2]|0,145963)|0;do if(c[k>>2]|0)if(!(a[c[k>>2]>>0]|0)){c[l>>2]=0;break}else{c[l>>2]=PO(c[k>>2]|0,c[j>>2]|0)|0;break}else c[l>>2]=c[j>>2];while(0);j=(c[(c[h>>2]|0)+8>>2]|0)+136|0;b[j>>1]=e[j>>1]|c[l>>2];i=g;return}function RO(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0;j=i;i=i+144|0;k=j+140|0;l=j+136|0;m=j+132|0;n=j+128|0;o=j+124|0;p=j+120|0;q=j+104|0;r=j+96|0;s=j+80|0;t=j+64|0;u=j+48|0;v=j+116|0;w=j+112|0;x=j+40|0;y=j+32|0;z=j+24|0;A=j+16|0;B=j+8|0;C=j;c[k>>2]=a;c[l>>2]=b;c[m>>2]=d;g[n>>2]=e;c[o>>2]=f;c[v>>2]=c[o>>2]&1;c[w>>2]=c[o>>2]&2;o=c[k>>2]|0;a:do if((c[m>>2]|0)==2){h[q>>3]=+h[o+16>>3]-+h[c[k>>2]>>3];h[r>>3]=+h[(c[k>>2]|0)+16+8>>3]-+h[(c[k>>2]|0)+8>>3];h[s>>3]=+h[c[k>>2]>>3]-+h[q>>3];h[t>>3]=+h[c[k>>2]>>3]+ +h[q>>3];h[s+8>>3]=+h[(c[k>>2]|0)+8>>3]-+h[r>>3];h[t+8>>3]=+h[(c[k>>2]|0)+8>>3]+ +h[r>>3]}else{e=+h[o>>3];h[t>>3]=e;h[s>>3]=e;e=+h[(c[k>>2]|0)+8>>3];h[t+8>>3]=e;h[s+8>>3]=e;c[p>>2]=0;while(1){if((c[p>>2]|0)>=(c[m>>2]|0))break a;if(+h[(c[k>>2]|0)+(c[p>>2]<<4)>>3]<+h[s>>3])D=+h[(c[k>>2]|0)+(c[p>>2]<<4)>>3];else D=+h[s>>3];h[s>>3]=D;if(+h[(c[k>>2]|0)+(c[p>>2]<<4)+8>>3]<+h[s+8>>3])E=+h[(c[k>>2]|0)+(c[p>>2]<<4)+8>>3];else E=+h[s+8>>3];h[s+8>>3]=E;if(+h[(c[k>>2]|0)+(c[p>>2]<<4)>>3]>+h[t>>3])F=+h[(c[k>>2]|0)+(c[p>>2]<<4)>>3];else F=+h[t>>3];h[t>>3]=F;if(+h[(c[k>>2]|0)+(c[p>>2]<<4)+8>>3]>+h[t+8>>3])G=+h[(c[k>>2]|0)+(c[p>>2]<<4)+8>>3];else G=+h[t+8>>3];h[t+8>>3]=G;c[p>>2]=(c[p>>2]|0)+1}}while(0);h[u>>3]=+h[s>>3]+(+h[t>>3]-+h[s>>3])/2.0;h[u+8>>3]=+h[s+8>>3]+(+h[t+8>>3]-+h[s+8>>3])/2.0;if(c[v>>2]|0){h[y>>3]=+O(+((+h[u>>3]-+h[s>>3])*(+h[u>>3]-+h[s>>3])+(+h[u+8>>3]-+h[s+8>>3])*(+h[u+8>>3]-+h[s+8>>3])));h[x>>3]=+h[y>>3]/4.0;G=+h[u+8>>3];if(c[w>>2]|0)h[(c[l>>2]|0)+8>>3]=G;else h[(c[l>>2]|0)+8>>3]=-G;h[c[l>>2]>>3]=+h[u>>3];h[(c[l>>2]|0)+16>>3]=+h[x>>3];h[(c[l>>2]|0)+16+8>>3]=+h[y>>3];i=j;return}else{h[z>>3]=+h[t>>3]-+h[u>>3];h[A>>3]=+h[t+8>>3]-+h[u+8>>3];h[B>>3]=+R(+(+g[n>>2]));h[C>>3]=+Q(+(+g[n>>2]));G=+h[u+8>>3];if(c[w>>2]|0){h[(c[l>>2]|0)+8>>3]=G-+h[A>>3]*+h[B>>3];h[(c[l>>2]|0)+16+8>>3]=+h[u+8>>3]+ +h[A>>3]*+h[B>>3]}else{F=-G+(+h[t+8>>3]-+h[u+8>>3])*+R(+(+g[n>>2]));h[(c[l>>2]|0)+8>>3]=F;F=-+h[u+8>>3]-(+h[u+8>>3]-+h[s+8>>3])*+R(+(+g[n>>2]));h[(c[l>>2]|0)+16+8>>3]=F}h[c[l>>2]>>3]=+h[u>>3]-+h[z>>3]*+h[C>>3];h[(c[l>>2]|0)+16>>3]=+h[u>>3]+ +h[z>>3]*+h[C>>3];i=j;return}}function SO(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;b=i;i=i+16|0;d=b+4|0;e=b;c[d>>2]=a;if(!(c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]|0)){f=c[d>>2]|0;g=f+8|0;h=c[g>>2]|0;j=h+8|0;c[j>>2]=0;i=b;return}c[e>>2]=0;while(1){if((c[e>>2]|0)>=(c[(c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0))break;O4(c[(c[c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]>>2]|0)+((c[e>>2]|0)*48|0)>>2]|0);c[e>>2]=(c[e>>2]|0)+1}O4(c[c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]>>2]|0);O4(c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]|0);f=c[d>>2]|0;g=f+8|0;h=c[g>>2]|0;j=h+8|0;c[j>>2]=0;i=b;return}function TO(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;O4(c[(c[(c[d>>2]|0)+8>>2]|0)+144>>2]|0);SO(c[d>>2]|0);UJ(c[(c[(c[d>>2]|0)+8>>2]|0)+96>>2]|0);UJ(c[(c[(c[d>>2]|0)+8>>2]|0)+108>>2]|0);UJ(c[(c[(c[d>>2]|0)+8>>2]|0)+100>>2]|0);UJ(c[(c[(c[d>>2]|0)+8>>2]|0)+104>>2]|0);NC(c[d>>2]|0,175319)|0;i=b;return}function UO(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;c[d>>2]=a;if(c[(c[(c[d>>2]|0)+8>>2]|0)+132>>2]|0)O4(c[(c[(c[d>>2]|0)+8>>2]|0)+132>>2]|0);if(c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]|0)Bb[c[(c[(c[(c[(c[d>>2]|0)+8>>2]|0)+8>>2]|0)+4>>2]|0)+4>>2]&127](c[d>>2]|0);UJ(c[(c[(c[d>>2]|0)+8>>2]|0)+104>>2]|0);UJ(c[(c[(c[d>>2]|0)+8>>2]|0)+108>>2]|0);NC(c[d>>2]|0,175026)|0;i=b;return}function VO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0.0;e=i;i=i+16|0;f=e+8|0;g=e+12|0;j=e;c[f>>2]=b;a[g>>0]=d;d=c[(c[f>>2]|0)+8>>2]|0;if(a[g>>0]|0){h[j>>3]=+h[d+40>>3]*72.0;k=+h[j>>3]/2.0;h[(c[(c[f>>2]|0)+8>>2]|0)+96>>3]=k;h[(c[(c[f>>2]|0)+8>>2]|0)+88>>3]=k;h[(c[(c[f>>2]|0)+8>>2]|0)+80>>3]=+h[(c[(c[f>>2]|0)+8>>2]|0)+32>>3]*72.0;i=e;return}else{h[j>>3]=+h[d+32>>3]*72.0;k=+h[j>>3]/2.0;h[(c[(c[f>>2]|0)+8>>2]|0)+96>>3]=k;h[(c[(c[f>>2]|0)+8>>2]|0)+88>>3]=k;h[(c[(c[f>>2]|0)+8>>2]|0)+80>>3]=+h[(c[(c[f>>2]|0)+8>>2]|0)+40>>3]*72.0;i=e;return}}function WO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d+4|0;h=d;c[f>>2]=a;c[g>>2]=b;c[h>>2]=Hb[c[c[f>>2]>>2]&63](c[f>>2]|0,c[g>>2]|0,512)|0;if(c[h>>2]|0){c[e>>2]=c[(c[h>>2]|0)+12>>2];j=c[e>>2]|0;i=d;return j|0}else{c[e>>2]=0;j=c[e>>2]|0;i=d;return j|0}return 0}function XO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;i=i+32|0;e=d+24|0;f=d+20|0;g=d+16|0;h=d+12|0;j=d+8|0;k=d+4|0;l=d;c[e>>2]=a;c[f>>2]=b;c[g>>2]=0;c[h>>2]=M3(c[e>>2]|0)|0;c[k>>2]=0;c[l>>2]=0;c[j>>2]=V3(c[h>>2]|0,148898)|0;while(1){if(!(c[j>>2]|0))break;if(c[k>>2]|0)m=eK(c[k>>2]|0,(c[g>>2]|0)+2<<2)|0;else m=cK((c[g>>2]|0)+2<<2)|0;c[k>>2]=m;h=c[j>>2]|0;e=c[g>>2]|0;c[g>>2]=e+1;c[(c[k>>2]|0)+(e<<2)>>2]=h;h=c[l>>2]|0;if(h>>>0>(N3(c[j>>2]|0)|0)>>>0)n=c[l>>2]|0;else n=N3(c[j>>2]|0)|0;c[l>>2]=n;c[j>>2]=V3(0,148898)|0}c[(c[k>>2]|0)+(c[g>>2]<<2)>>2]=0;c[c[f>>2]>>2]=c[l>>2];i=d;return c[k>>2]|0}function YO(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+32|0;f=e;g=e+28|0;h=e+24|0;j=e+20|0;k=e+16|0;l=e+12|0;c[h>>2]=a;c[j>>2]=b;c[k>>2]=d;d=c[15243]|0;b=c[j>>2]|0;c[15243]=Q4(d,b+(N3(c[k>>2]|0)|0)+2|0)|0;c[l>>2]=c[h>>2];while(1){if(!(c[c[l>>2]>>2]|0)){m=6;break}h=c[15243]|0;b=c[k>>2]|0;c[f>>2]=c[c[l>>2]>>2];c[f+4>>2]=145579;c[f+8>>2]=b;k3(h,147672,f)|0;if(!(Z3(c[15243]|0,4)|0)){m=4;break}c[l>>2]=(c[l>>2]|0)+4}if((m|0)==4){c[g>>2]=c[15243];n=c[g>>2]|0;i=e;return n|0}else if((m|0)==6){c[g>>2]=0;n=c[g>>2]|0;i=e;return n|0}return 0}function ZO(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0.0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;g=+fO(c[e>>2]|0,c[13863]|0,14.0,1.0);h[c[f>>2]>>3]=g;b=iO(c[e>>2]|0,c[13864]|0,145601)|0;c[(c[f>>2]|0)+8>>2]=b;b=iO(c[e>>2]|0,c[13865]|0,174917)|0;c[(c[f>>2]|0)+12>>2]=b;i=d;return}function _O(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0.0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;j=e;c[f>>2]=a;c[g>>2]=b;c[j>>2]=d;if(!(c[(c[g>>2]|0)+8>>2]|0))ZO(c[f>>2]|0,c[g>>2]|0);k=+fO(c[f>>2]|0,c[13883]|0,+h[c[g>>2]>>3],1.0);h[c[j>>2]>>3]=k;d=iO(c[f>>2]|0,c[13884]|0,c[(c[g>>2]|0)+8>>2]|0)|0;c[(c[j>>2]|0)+8>>2]=d;d=iO(c[f>>2]|0,c[13885]|0,c[(c[g>>2]|0)+12>>2]|0)|0;c[(c[j>>2]|0)+12>>2]=d;i=e;return}function $O(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=i;i=i+144|0;h=g+132|0;j=g+128|0;k=g+124|0;l=g+80|0;m=g+120|0;n=g+40|0;o=g;c[h>>2]=d;c[j>>2]=e;c[k>>2]=f;c[m>>2]=0;if(c[k>>2]|0)c[m>>2]=H3(c[k>>2]|0,58)|0;if(c[m>>2]|0){a[c[m>>2]>>0]=0;Vb[c[h>>2]&31](n,c[j>>2]|0,c[k>>2]|0,(c[m>>2]|0)+1|0);p=l;q=n;r=p+40|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));a[c[m>>2]>>0]=58;c[l+36>>2]=(c[m>>2]|0)+1;s=c[k>>2]|0;t=l+36|0;c[t>>2]=s;p=b;q=l;r=p+40|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));i=g;return}else{Vb[c[h>>2]&31](o,c[j>>2]|0,c[k>>2]|0,0);p=l;q=o;r=p+40|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));s=c[k>>2]|0;t=l+36|0;c[t>>2]=s;p=b;q=l;r=p+40|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));i=g;return}}function aP(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;f=e+8|0;g=e+4|0;h=e;j=e+12|0;c[f>>2]=b;c[g>>2]=d;a[j>>0]=0;if(!(c[g>>2]|0)){k=a[j>>0]|0;i=e;return k|0}c[h>>2]=zA(c[f>>2]|0,c[g>>2]|0)|0;if((c[h>>2]|0)!=0?(a[c[h>>2]>>0]|0)!=0:0){a[j>>0]=((kO(c[h>>2]|0)|0)<<24>>24!=0^1)&1;k=a[j>>0]|0;i=e;return k|0}a[j>>0]=0;k=a[j>>0]|0;i=e;return k|0}function bP(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0;g=i;i=i+64|0;j=g+48|0;k=g+52|0;l=g+40|0;m=g+32|0;n=g+16|0;o=g+8|0;p=g;c[j>>2]=e;a[k>>0]=f;f=(c[j>>2]|0)+56|0;c[n>>2]=c[f>>2];c[n+4>>2]=c[f+4>>2];c[n+8>>2]=c[f+8>>2];c[n+12>>2]=c[f+12>>2];q=+h[(c[j>>2]|0)+24>>3];if(a[k>>0]|0){h[m>>3]=q;h[l>>3]=+h[(c[j>>2]|0)+24+8>>3]}else{h[l>>3]=q;h[m>>3]=+h[(c[j>>2]|0)+24+8>>3]}h[o>>3]=+h[n>>3]-+h[l>>3]/2.0;h[p>>3]=+h[n>>3]+ +h[l>>3]/2.0;if(+h[o>>3]<+h[d>>3])h[d>>3]=+h[o>>3];if(+h[p>>3]>+h[d+16>>3])h[d+16>>3]=+h[p>>3];h[o>>3]=+h[n+8>>3]-+h[m>>3]/2.0;h[p>>3]=+h[n+8>>3]+ +h[m>>3]/2.0;if(+h[o>>3]<+h[d+8>>3])h[d+8>>3]=+h[o>>3];if(!(+h[p>>3]>+h[d+16+8>>3])){c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[b+16>>2]=c[d+16>>2];c[b+20>>2]=c[d+20>>2];c[b+24>>2]=c[d+24>>2];c[b+28>>2]=c[d+28>>2];i=g;return}h[d+16+8>>3]=+h[p>>3];c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[b+16>>2]=c[d+16>>2];c[b+20>>2]=c[d+20>>2];c[b+24>>2]=c[d+24>>2];c[b+28>>2]=c[d+28>>2];i=g;return}function cP(a,b,d){a=a|0;b=+b;d=+d;var e=0,f=0,g=0,j=0;e=i;i=i+32|0;f=e+24|0;g=e+16|0;j=e;h[f>>3]=b;h[g>>3]=d;h[j>>3]=+h[f>>3];h[j+8>>3]=+h[g>>3];c[a>>2]=c[j>>2];c[a+4>>2]=c[j+4>>2];c[a+8>>2]=c[j+8>>2];c[a+12>>2]=c[j+12>>2];i=e;return}function dP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;h[f>>3]=+h[b>>3]-+h[d>>3];h[f+8>>3]=+h[b+8>>3]-+h[d+8>>3];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];i=e;return}function eP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;h[f>>3]=+h[b>>3]+ +h[d>>3];h[f+8>>3]=+h[b+8>>3]+ +h[d+8>>3];c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];i=e;return}function fP(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;h=i;i=i+96|0;j=h+32|0;k=h+24|0;l=h+16|0;m=h+8|0;n=h;o=h+88|0;p=h+84|0;q=h+80|0;r=h+76|0;s=h+72|0;t=h+68|0;u=h+64|0;v=h+60|0;w=h+56|0;x=h+52|0;y=h+48|0;z=h+44|0;A=h+40|0;c[o>>2]=b;c[p>>2]=d;c[q>>2]=e;c[r>>2]=f;c[s>>2]=g;g=c[o>>2]|0;c[x>>2]=c[((c[c[o>>2]>>2]&3|0)==3?g:g+32|0)+28>>2];g=c[o>>2]|0;c[y>>2]=c[((c[c[o>>2]>>2]&3|0)==2?g:g+-32|0)+28>>2];if(a[(c[(c[y>>2]|0)+8>>2]|0)+118>>0]|0){i=h;return}if(P3(wB(c[x>>2]|0)|0,145613,7)|0)B=0;else{g=c[s>>2]|0;B=WO(g,wB(c[x>>2]|0)|0)|0}c[t>>2]=B;if(P3(wB(c[y>>2]|0)|0,145613,7)|0)C=0;else{B=c[s>>2]|0;C=WO(B,wB(c[y>>2]|0)|0)|0}c[u>>2]=C;if(!((c[t>>2]|0)!=0|(c[u>>2]|0)!=0)){i=h;return}if((c[t>>2]|0)==(c[u>>2]|0)){C=wB(c[x>>2]|0)|0;B=wB(c[x>>2]|0)|0;c[n>>2]=C;c[n+4>>2]=B;$z(0,147461,n)|0;i=h;return}c[A>>2]=sP(c[r>>2]|0,c[o>>2]|0)|0;if(c[A>>2]|0){qP(c[o>>2]|0,c[(c[A>>2]|0)+16>>2]|0,c[(c[A>>2]|0)+20>>2]|0)|0;i=h;return}A=c[t>>2]|0;if(!(c[u>>2]|0))if(AC(A,c[y>>2]|0)|0){n=wB(c[y>>2]|0)|0;B=wB(c[t>>2]|0)|0;c[j>>2]=n;c[j+4>>2]=B;$z(0,147616,j)|0;i=h;return}else{c[v>>2]=tP(c[x>>2]|0,c[t>>2]|0,c[q>>2]|0,c[p>>2]|0)|0;c[z>>2]=qP(c[o>>2]|0,c[v>>2]|0,c[y>>2]|0)|0;uP(c[r>>2]|0,c[x>>2]|0,c[y>>2]|0,c[z>>2]|0);i=h;return}j=c[u>>2]|0;if(!A)if(AC(j,c[x>>2]|0)|0){A=wB(c[x>>2]|0)|0;B=wB(c[u>>2]|0)|0;c[k>>2]=A;c[k+4>>2]=B;$z(0,147579,k)|0;i=h;return}else{c[v>>2]=tP(c[y>>2]|0,c[u>>2]|0,c[q>>2]|0,c[p>>2]|0)|0;c[z>>2]=qP(c[o>>2]|0,c[x>>2]|0,c[v>>2]|0)|0;uP(c[r>>2]|0,c[x>>2]|0,c[y>>2]|0,c[z>>2]|0);i=h;return}k=(AC(j,c[t>>2]|0)|0)!=0;j=c[t>>2]|0;if(k){k=wB(j)|0;B=wB(c[u>>2]|0)|0;c[m>>2]=k;c[m+4>>2]=B;$z(0,147499,m)|0;i=h;return}if(AC(j,c[u>>2]|0)|0){j=wB(c[u>>2]|0)|0;m=wB(c[t>>2]|0)|0;c[l>>2]=j;c[l+4>>2]=m;$z(0,147539,l)|0;i=h;return}else{c[v>>2]=tP(c[x>>2]|0,c[t>>2]|0,c[q>>2]|0,c[p>>2]|0)|0;c[w>>2]=tP(c[y>>2]|0,c[u>>2]|0,c[q>>2]|0,c[p>>2]|0)|0;c[z>>2]=qP(c[o>>2]|0,c[v>>2]|0,c[w>>2]|0)|0;uP(c[r>>2]|0,c[x>>2]|0,c[y>>2]|0,c[z>>2]|0);i=h;return}}function gP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;i=i+32|0;e=d;f=d+24|0;g=d+20|0;h=d+16|0;j=d+12|0;k=d+8|0;l=d+4|0;c[f>>2]=a;c[g>>2]=b;c[j>>2]=1;while(1){if((c[j>>2]|0)>(c[(c[(c[f>>2]|0)+8>>2]|0)+180>>2]|0))break;c[h>>2]=c[(c[(c[(c[f>>2]|0)+8>>2]|0)+184>>2]|0)+(c[j>>2]<<2)>>2];c[k>>2]=wB(c[h>>2]|0)|0;if(Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,c[k>>2]|0,512)|0){c[e>>2]=c[k>>2];$z(0,147409,e)|0}else{c[l>>2]=bK(16)|0;c[(c[l>>2]|0)+8>>2]=c[k>>2];c[(c[l>>2]|0)+12>>2]=c[h>>2];Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,c[l>>2]|0,1)|0}gP(c[h>>2]|0,c[g>>2]|0);c[j>>2]=(c[j>>2]|0)+1}i=d;return}function hP(a,b){a=a|0;b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+20|0;g=e+16|0;h=e+12|0;j=e+8|0;k=e+4|0;l=e;c[f>>2]=a;c[g>>2]=b;b=c[f>>2]|0;c[h>>2]=c[((c[c[f>>2]>>2]&3|0)==3?b:b+32|0)+28>>2];b=c[f>>2]|0;c[j>>2]=c[((c[c[f>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2];if((d[(c[(c[h>>2]|0)+8>>2]|0)+118>>0]|0|0)==0?(d[(c[(c[j>>2]|0)+8>>2]|0)+118>>0]|0|0)==0:0){i=e;return}c[k>>2]=pP(c[h>>2]|0,c[g>>2]|0)|0;c[l>>2]=pP(c[j>>2]|0,c[g>>2]|0)|0;qP(c[f>>2]|0,c[k>>2]|0,c[l>>2]|0)|0;i=e;return}function iP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;b=J3(c[c[e>>2]>>2]|0,c[c[f>>2]>>2]|0)|0;i=d;return b|0}function jP(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+32|0;f=e+18|0;g=e+12|0;h=e+16|0;j=e+8|0;k=e+4|0;l=e;a[f>>0]=b;c[g>>2]=d;a[h>>0]=a[f>>0]|0;a[h+1>>0]=0;d=KO(h)|0;c[j>>2]=d;c[k>>2]=d;c[l>>2]=N3(c[j>>2]|0)|0;while(1){d=c[l>>2]|0;c[l>>2]=d+-1;if((d|0)<=1)break;if((c[(c[g>>2]|0)+4>>2]|0)>>>0>=(c[(c[g>>2]|0)+8>>2]|0)>>>0)eA(c[g>>2]|0,1)|0;d=c[k>>2]|0;c[k>>2]=d+1;h=a[d>>0]|0;d=(c[g>>2]|0)+4|0;b=c[d>>2]|0;c[d>>2]=b+1;a[b>>0]=h}a[f>>0]=a[c[k>>2]>>0]|0;O4(c[j>>2]|0);i=e;return a[f>>0]|0}function kP(b){b=b|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=i;i=i+64|0;f=e+36|0;g=e+32|0;h=e+24|0;j=e+16|0;k=e+40|0;l=e+12|0;m=e+8|0;n=e+4|0;o=e;c[f>>2]=b;c[l>>2]=c[c[f>>2]>>2];c[o>>2]=0;c[m>>2]=d[c[l>>2]>>0];if((c[m>>2]|0)!=35){c[g>>2]=k;c[h>>2]=k;c[n>>2]=0;while(1){if((c[n>>2]|0)>=8){p=26;break}c[m>>2]=d[(c[l>>2]|0)+(c[n>>2]|0)>>0];if(!(c[m>>2]|0)){p=26;break}if((c[m>>2]|0)==59){p=23;break}k=c[m>>2]&255;b=c[g>>2]|0;c[g>>2]=b+1;a[b>>0]=k;c[n>>2]=(c[n>>2]|0)+1}if((p|0)==23){k=c[g>>2]|0;c[g>>2]=k+1;a[k>>0]=0;c[j>>2]=v3(h,58948,252,8,96)|0;if(!(c[j>>2]|0)){q=c[l>>2]|0;r=c[f>>2]|0;c[r>>2]=q;s=c[o>>2]|0;i=e;return s|0}c[o>>2]=c[(c[j>>2]|0)+4>>2];c[l>>2]=(c[l>>2]|0)+((c[n>>2]|0)+1);q=c[l>>2]|0;r=c[f>>2]|0;c[r>>2]=q;s=c[o>>2]|0;i=e;return s|0}else if((p|0)==26){q=c[l>>2]|0;r=c[f>>2]|0;c[r>>2]=q;s=c[o>>2]|0;i=e;return s|0}}c[m>>2]=d[(c[l>>2]|0)+1>>0];a:do if((c[m>>2]|0)==120|(c[m>>2]|0)==88){c[n>>2]=2;while(1){if((c[n>>2]|0)>=8)break a;c[m>>2]=d[(c[l>>2]|0)+(c[n>>2]|0)>>0];p=c[m>>2]|0;do if((c[m>>2]|0)>>>0>=65&(c[m>>2]|0)>>>0<=70)c[m>>2]=p-65+10;else{j=c[m>>2]|0;if(p>>>0>=97&(c[m>>2]|0)>>>0<=102){c[m>>2]=j-97+10;break}if(!(j>>>0>=48&(c[m>>2]|0)>>>0<=57))break a;c[m>>2]=(c[m>>2]|0)-48}while(0);c[o>>2]=(c[o>>2]<<4)+(c[m>>2]|0);c[n>>2]=(c[n>>2]|0)+1}}else{c[n>>2]=1;while(1){if((c[n>>2]|0)>=8)break a;c[m>>2]=d[(c[l>>2]|0)+(c[n>>2]|0)>>0];if(!((c[m>>2]|0)>>>0>=48&(c[m>>2]|0)>>>0<=57))break a;c[o>>2]=((c[o>>2]|0)*10|0)+((c[m>>2]|0)-48);c[n>>2]=(c[n>>2]|0)+1}}while(0);if((c[m>>2]|0)==59){c[l>>2]=(c[l>>2]|0)+((c[n>>2]|0)+1);q=c[l>>2]|0;r=c[f>>2]|0;c[r>>2]=q;s=c[o>>2]|0;i=e;return s|0}else{c[o>>2]=0;q=c[l>>2]|0;r=c[f>>2]|0;c[r>>2]=q;s=c[o>>2]|0;i=e;return s|0}return 0}function lP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;h[f>>3]=(+h[b>>3]+ +h[d>>3])/2.0;h[f+8>>3]=(+h[b+8>>3]+ +h[d+8>>3])/2.0;c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];i=e;return}function mP(a,b){a=a|0;b=b|0;var c=0,d=0;if(!(+h[a+16>>3]>=+h[b>>3])){c=0;d=c&1;return d|0}if(!(+h[b+16>>3]>=+h[a>>3])){c=0;d=c&1;return d|0}if(!(+h[a+16+8>>3]>=+h[b+8>>3])){c=0;d=c&1;return d|0}c=+h[b+16+8>>3]>=+h[a+8>>3];d=c&1;return d|0}function nP(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=i;i=i+112|0;f=e+64|0;g=e+48|0;h=e+32|0;j=e+100|0;k=e+96|0;l=e+16|0;m=e;if(!(c[b+4>>2]|0))La(145971,145265,1629,145979);n=c[b>>2]|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];c[k>>2]=1;while(1){if((c[k>>2]|0)>=(c[b+4>>2]|0))break;n=(c[b>>2]|0)+(c[k>>2]<<4)|0;c[l>>2]=c[n>>2];c[l+4>>2]=c[n+4>>2];c[l+8>>2]=c[n+8>>2];c[l+12>>2]=c[n+12>>2];c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];c[g>>2]=c[m>>2];c[g+4>>2]=c[m+4>>2];c[g+8>>2]=c[m+8>>2];c[g+12>>2]=c[m+12>>2];c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];if((CJ(h,g,f)|0)!=-1){o=6;break};c[m>>2]=c[l>>2];c[m+4>>2]=c[l+4>>2];c[m+8>>2]=c[l+8>>2];c[m+12>>2]=c[l+12>>2];c[k>>2]=(c[k>>2]|0)+1}if((o|0)==6){a[j>>0]=1;p=a[j>>0]|0;i=e;return p|0}if((c[b+8>>2]|0)!=0?(o=b+16|0,k=c[b>>2]|0,l=c[b+8>>2]|0,c[h>>2]=c[o>>2],c[h+4>>2]=c[o+4>>2],c[h+8>>2]=c[o+8>>2],c[h+12>>2]=c[o+12>>2],c[g>>2]=c[k>>2],c[g+4>>2]=c[k+4>>2],c[g+8>>2]=c[k+8>>2],c[g+12>>2]=c[k+12>>2],c[f>>2]=c[d>>2],c[f+4>>2]=c[d+4>>2],c[f+8>>2]=c[d+8>>2],c[f+12>>2]=c[d+12>>2],c[f+16>>2]=c[d+16>>2],c[f+20>>2]=c[d+20>>2],c[f+24>>2]=c[d+24>>2],c[f+28>>2]=c[d+28>>2],(oP(h,g,1.0,l,f)|0)<<24>>24!=0):0){a[j>>0]=1;p=a[j>>0]|0;i=e;return p|0}if((c[b+12>>2]|0)!=0?(l=b+32|0,k=(c[b>>2]|0)+((c[b+4>>2]|0)-1<<4)|0,o=c[b+12>>2]|0,c[h>>2]=c[l>>2],c[h+4>>2]=c[l+4>>2],c[h+8>>2]=c[l+8>>2],c[h+12>>2]=c[l+12>>2],c[g>>2]=c[k>>2],c[g+4>>2]=c[k+4>>2],c[g+8>>2]=c[k+8>>2],c[g+12>>2]=c[k+12>>2],c[f>>2]=c[d>>2],c[f+4>>2]=c[d+4>>2],c[f+8>>2]=c[d+8>>2],c[f+12>>2]=c[d+12>>2],c[f+16>>2]=c[d+16>>2],c[f+20>>2]=c[d+20>>2],c[f+24>>2]=c[d+24>>2],c[f+28>>2]=c[d+28>>2],(oP(h,g,1.0,o,f)|0)<<24>>24!=0):0){a[j>>0]=1;p=a[j>>0]|0;i=e;return p|0}a[j>>0]=0;p=a[j>>0]|0;i=e;return p|0}function oP(b,d,e,f,g){b=b|0;d=d|0;e=+e;f=f|0;g=g|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0;j=i;i=i+176|0;k=j+152|0;l=j+136|0;m=j+172|0;n=j+128|0;o=j+168|0;p=j+96|0;q=j+64|0;r=j+32|0;s=j;h[n>>3]=e;c[o>>2]=f;e=+h[g+16>>3];t=+h[n>>3];f=c[o>>2]|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2];c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];gH(p,l,k,t,f);if(((e>=+h[p>>3]?(e=+h[n>>3],p=c[o>>2]|0,c[l>>2]=c[b>>2],c[l+4>>2]=c[b+4>>2],c[l+8>>2]=c[b+8>>2],c[l+12>>2]=c[b+12>>2],c[k>>2]=c[d>>2],c[k+4>>2]=c[d+4>>2],c[k+8>>2]=c[d+8>>2],c[k+12>>2]=c[d+12>>2],gH(q,l,k,e,p),+h[q+16>>3]>=+h[g>>3]):0)?(e=+h[g+16+8>>3],t=+h[n>>3],q=c[o>>2]|0,c[l>>2]=c[b>>2],c[l+4>>2]=c[b+4>>2],c[l+8>>2]=c[b+8>>2],c[l+12>>2]=c[b+12>>2],c[k>>2]=c[d>>2],c[k+4>>2]=c[d+4>>2],c[k+8>>2]=c[d+8>>2],c[k+12>>2]=c[d+12>>2],gH(r,l,k,t,q),e>=+h[r+8>>3]):0)?(e=+h[n>>3],n=c[o>>2]|0,c[l>>2]=c[b>>2],c[l+4>>2]=c[b+4>>2],c[l+8>>2]=c[b+8>>2],c[l+12>>2]=c[b+12>>2],c[k>>2]=c[d>>2],c[k+4>>2]=c[d+4>>2],c[k+8>>2]=c[d+8>>2],c[k+12>>2]=c[d+12>>2],gH(s,l,k,e,n),+h[s+16+8>>3]>=+h[g+8>>3]):0){a[m>>0]=1;u=a[m>>0]|0;i=j;return u|0}a[m>>0]=0;u=a[m>>0]|0;i=j;return u|0}function pP(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;i=i+32|0;f=e+24|0;g=e+20|0;h=e+16|0;j=e+12|0;k=e+8|0;l=e+4|0;m=e;c[g>>2]=b;c[h>>2]=d;c[l>>2]=qC(c[g>>2]|0)|0;if(!(a[(c[(c[g>>2]|0)+8>>2]|0)+118>>0]|0)){c[f>>2]=c[g>>2];n=c[f>>2]|0;i=e;return n|0}eC(c[h>>2]|0,c[g>>2]|0,1)|0;c[k>>2]=H3(wB(c[g>>2]|0)|0,58)|0;if(!(c[k>>2]|0))La(148770,145265,1225,147404);c[k>>2]=(c[k>>2]|0)+1;g=fC(c[l>>2]|0,c[k>>2]|0,0)|0;c[j>>2]=g;if(g){c[f>>2]=c[j>>2];n=c[f>>2]|0;i=e;return n|0}c[j>>2]=fC(c[l>>2]|0,c[k>>2]|0,1)|0;MC(c[j>>2]|0,175026,304,1)|0;c[m>>2]=rA(c[l>>2]|0,1,0)|0;while(1){o=c[j>>2]|0;if(!(c[m>>2]|0))break;k=zA(o,c[m>>2]|0)|0;if((k|0)!=(c[(c[m>>2]|0)+12>>2]|0))BA(c[j>>2]|0,c[m>>2]|0,c[(c[m>>2]|0)+12>>2]|0)|0;c[m>>2]=rA(c[l>>2]|0,1,c[m>>2]|0)|0}c[f>>2]=o;n=c[f>>2]|0;i=e;return n|0}function qP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e+16|0;g=e+12|0;h=e+8|0;j=e+4|0;k=e;c[f>>2]=a;c[g>>2]=b;c[h>>2]=d;c[j>>2]=qC(c[g>>2]|0)|0;c[k>>2]=VA(c[j>>2]|0,c[g>>2]|0,c[h>>2]|0,0,1)|0;MC(c[k>>2]|0,175319,176,1)|0;DA(c[f>>2]|0,c[k>>2]|0)|0;i=e;return c[k>>2]|0}function rP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e+4|0;c[e+8>>2]=a;c[f>>2]=b;c[e>>2]=d;O4(c[f>>2]|0);i=e;return}function sP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;i=i+16|0;e=d+12|0;f=d+8|0;g=d;c[e>>2]=a;c[f>>2]=b;b=c[f>>2]|0;c[g>>2]=c[((c[c[f>>2]>>2]&3|0)==3?b:b+32|0)+28>>2];b=c[f>>2]|0;c[g+4>>2]=c[((c[c[f>>2]>>2]&3|0)==2?b:b+-32|0)+28>>2];b=Hb[c[c[e>>2]>>2]&63](c[e>>2]|0,g,512)|0;i=d;return b|0}function tP(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;i=i+128|0;h=g;j=g+20|0;k=g+16|0;l=g+12|0;m=g+8|0;n=g+4|0;o=g+24|0;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;gA(c[l>>2]|0,147653)|0;f=c[15242]|0;c[15242]=f+1;c[h>>2]=f;k3(o,175023,h)|0;gA(c[l>>2]|0,o)|0;if((c[(c[l>>2]|0)+4>>2]|0)>>>0>=(c[(c[l>>2]|0)+8>>2]|0)>>>0)eA(c[l>>2]|0,1)|0;o=(c[l>>2]|0)+4|0;h=c[o>>2]|0;c[o>>2]=h+1;a[h>>0]=58;h=c[l>>2]|0;gA(h,wB(c[k>>2]|0)|0)|0;h=rC(c[k>>2]|0)|0;if((c[(c[l>>2]|0)+4>>2]|0)>>>0>=(c[(c[l>>2]|0)+8>>2]|0)>>>0)eA(c[l>>2]|0,1)|0;o=(c[l>>2]|0)+4|0;f=c[o>>2]|0;c[o>>2]=f+1;a[f>>0]=0;f=c[c[l>>2]>>2]|0;c[(c[l>>2]|0)+4>>2]=f;c[n>>2]=fC(h,f,1)|0;MC(c[n>>2]|0,175026,304,1)|0;a[(c[(c[n>>2]|0)+8>>2]|0)+118>>0]=1;eC(c[k>>2]|0,c[n>>2]|0,1)|0;eC(c[m>>2]|0,c[j>>2]|0,1)|0;j=qC(c[n>>2]|0)|0;c[13831]=DO(j,c[n>>2]|0,147656,178518,c[13831]|0)|0;j=qC(c[n>>2]|0)|0;c[13834]=DO(j,c[n>>2]|0,179091,171938,c[13834]|0)|0;j=qC(c[n>>2]|0)|0;c[13816]=DO(j,c[n>>2]|0,147662,147668,c[13816]|0)|0;i=g;return c[n>>2]|0}function uP(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+48|0;g=f+36|0;h=f+32|0;j=f+28|0;k=f+24|0;l=f;c[g>>2]=a;c[h>>2]=b;c[j>>2]=d;c[k>>2]=e;c[l+8>>2]=c[h>>2];c[l+8+4>>2]=c[j>>2];e=c[k>>2]|0;c[l+16>>2]=c[((c[c[k>>2]>>2]&3|0)==3?e:e+32|0)+28>>2];e=c[k>>2]|0;c[l+20>>2]=c[((c[c[k>>2]>>2]&3|0)==2?e:e+-32|0)+28>>2];Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,l,1)|0;c[l+8>>2]=c[j>>2];c[l+8+4>>2]=c[h>>2];h=c[k>>2]|0;c[l+16>>2]=c[((c[c[k>>2]>>2]&3|0)==2?h:h+-32|0)+28>>2];h=c[k>>2]|0;c[l+20>>2]=c[((c[c[k>>2]>>2]&3|0)==3?h:h+32|0)+28>>2];Hb[c[c[g>>2]>>2]&63](c[g>>2]|0,l,1)|0;i=f;return}function vP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e+8|0;g=e;c[e+12>>2]=a;c[f>>2]=b;c[e+4>>2]=d;c[g>>2]=bK(24)|0;c[(c[g>>2]|0)+8>>2]=c[(c[f>>2]|0)+8>>2];c[(c[g>>2]|0)+8+4>>2]=c[(c[f>>2]|0)+8+4>>2];c[(c[g>>2]|0)+16>>2]=c[(c[f>>2]|0)+16>>2];c[(c[g>>2]|0)+20>>2]=c[(c[f>>2]|0)+20>>2];i=e;return c[g>>2]|0}function wP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e+4|0;c[e+8>>2]=a;c[f>>2]=b;c[e>>2]=d;O4(c[f>>2]|0);i=e;return}function xP(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f+16|0;h=f+8|0;j=f+4|0;c[f+12>>2]=a;c[h>>2]=b;c[j>>2]=d;c[f>>2]=e;do if((c[c[h>>2]>>2]|0)>>>0>=(c[c[j>>2]>>2]|0)>>>0){if((c[c[h>>2]>>2]|0)>>>0>(c[c[j>>2]>>2]|0)>>>0){c[g>>2]=1;break}if((c[(c[h>>2]|0)+4>>2]|0)>>>0<(c[(c[j>>2]|0)+4>>2]|0)>>>0){c[g>>2]=-1;break}if((c[(c[h>>2]|0)+4>>2]|0)>>>0>(c[(c[j>>2]|0)+4>>2]|0)>>>0){c[g>>2]=1;break}else{c[g>>2]=0;break}}else c[g>>2]=-1;while(0);i=f;return c[g>>2]|0}function yP(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,fa=0,ha=0,ja=0,la=0,ma=0,na=0,oa=0,qa=0,sa=0,ua=0,va=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0;f=i;i=i+16|0;g=f;h=4;j=N4(40)|0;c[j>>2]=0;k=f+8|0;n=0;l=ia(29,b|0)|0;m=n;n=0;if((m|0)!=0&(o|0)!=0){p=Y4(c[m>>2]|0,j|0,h|0)|0;if(!p)Pa(m|0,o|0);C=o}else p=-1;a:do if((p|0)!=1){n=0;m=ia(23,l<<3|0)|0;q=n;n=0;if((q|0)!=0&(o|0)!=0){r=Y4(c[q>>2]|0,j|0,h|0)|0;if(!r)Pa(q|0,o|0);C=o}else r=-1;if((r|0)!=1){if(a[139e3]|0){n=0;q=ta(4)|0;s=n;n=0;if((s|0)!=0&(o|0)!=0){t=Y4(c[s>>2]|0,j|0,h|0)|0;if(!t)Pa(s|0,o|0);C=o}else t=-1;if((t|0)==1){u=e;v=C;w=m;x=0;y=0;z=0;A=0;B=76;break}D=q}else D=0;n=0;q=ra(97,b|0,147679)|0;s=n;n=0;if((s|0)!=0&(o|0)!=0){E=Y4(c[s>>2]|0,j|0,h|0)|0;if(!E)Pa(s|0,o|0);C=o}else E=-1;if((E|0)!=1){c[15244]=0;b:do if((q|0)!=0?(a[q>>0]|0)!=0:0){s=q;c:while(1){F=s+1|0;G=a[s>>0]|0;if(!(G<<24>>24))break b;switch(G<<24>>24|0){case 99:{c[15244]=c[15244]|8;s=F;continue c;break}case 105:{c[15244]=c[15244]|18;s=F;continue c;break}case 109:{c[15244]=c[15244]|1;s=F;continue c;break}case 114:{c[15244]=c[15244]|4;s=F;continue c;break}case 115:{c[15244]=c[15244]|2;s=F;continue c;break}default:{s=F;continue c}}}}while(0);if(e){n=0;ka(25,0,147683,g|0)|0;q=n;n=0;if((q|0)!=0&(o|0)!=0){H=Y4(c[q>>2]|0,j|0,h|0)|0;if(!H)Pa(q|0,o|0);C=o}else H=-1;if((H|0)==1){u=e;v=C;w=m;x=0;y=0;z=D;A=0;B=76;break}I=0}else I=e;n=0;q=ra(98,b|0,I|0)|0;s=n;n=0;if((s|0)!=0&(o|0)!=0){J=Y4(c[s>>2]|0,j|0,h|0)|0;if(!J)Pa(s|0,o|0);C=o}else J=-1;if((J|0)!=1){s=c[q+16>>2]|0;if(c[15244]&2){n=0;ga(21,c[24742]|0,s|0);F=n;n=0;if((F|0)!=0&(o|0)!=0){K=Y4(c[F>>2]|0,j|0,h|0)|0;if(!K)Pa(F|0,o|0);C=o}else K=-1;if((K|0)==1){u=I;v=C;w=m;x=q;y=0;z=D;A=0;B=76;break}}n=0;F=ia(25,b|0)|0;G=n;n=0;if((G|0)!=0&(o|0)!=0){L=Y4(c[G>>2]|0,j|0,h|0)|0;if(!L)Pa(G|0,o|0);C=o}else L=-1;if((L|0)!=1){G=F;F=0;while(1){if(!G)break;n=0;M=ra(99,b|0,G|0)|0;N=n;n=0;if((N|0)!=0&(o|0)!=0){O=Y4(c[N>>2]|0,j|0,h|0)|0;if(!O)Pa(N|0,o|0);C=o}else O=-1;if((O|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=0;B=76;break a}N=M;M=F;while(1){if(!N)break;if((c[13795]|0)==2?(c[(c[N+8>>2]|0)+8>>2]|0)!=0:0)P=M;else B=31;d:do if((B|0)==31){B=0;do if(a[139e3]|0){Q=(c[c[((c[N>>2]&3|0)==3?N:N+32|0)+28>>2]>>2]|0)>>>4;R=(c[c[((c[N>>2]&3|0)==2?N:N+-32|0)+28>>2]>>2]|0)>>>4;if((Q|0)<=(R|0)){n=0;S=ka(38,D|0,Q|0,R|0)|0;T=n;n=0;if((T|0)!=0&(o|0)!=0){U=Y4(c[T>>2]|0,j|0,h|0)|0;if(!U)Pa(T|0,o|0);C=o}else U=-1;if((U|0)==1){u=I;v=C;w=m;x=q;y=M;z=D;A=0;B=76;break a}if(S){P=M;break d}n=0;wa(61,D|0,Q|0,R|0);S=n;n=0;if((S|0)!=0&(o|0)!=0){V=Y4(c[S>>2]|0,j|0,h|0)|0;if(!V)Pa(S|0,o|0);C=o}else V=-1;if((V|0)==1){u=I;v=C;w=m;x=q;y=M;z=D;A=0;B=76;break a}break}else{n=0;S=ka(38,D|0,R|0,Q|0)|0;T=n;n=0;if((T|0)!=0&(o|0)!=0){W=Y4(c[T>>2]|0,j|0,h|0)|0;if(!W)Pa(T|0,o|0);C=o}else W=-1;if((W|0)==1){u=I;v=C;w=m;x=q;y=M;z=D;A=0;B=76;break a}if(S){P=M;break d}n=0;wa(61,D|0,R|0,Q|0);Q=n;n=0;if((Q|0)!=0&(o|0)!=0){X=Y4(c[Q>>2]|0,j|0,h|0)|0;if(!X)Pa(Q|0,o|0);C=o}else X=-1;if((X|0)==1){u=I;v=C;w=m;x=q;y=M;z=D;A=0;B=76;break a}break}}while(0);c[m+(M<<3)+4>>2]=N;n=0;Q=ia(30,N|0)|0;R=n;n=0;if((R|0)!=0&(o|0)!=0){Y=Y4(c[R>>2]|0,j|0,h|0)|0;if(!Y)Pa(R|0,o|0);C=o}else Y=-1;if((Y|0)==1){u=I;v=C;w=m;x=q;y=M;z=D;A=0;B=76;break a}c[m+(M<<3)>>2]=Q;P=M+1|0}while(0);n=0;Q=ra(100,b|0,N|0)|0;R=n;n=0;if((R|0)!=0&(o|0)!=0){Z=Y4(c[R>>2]|0,j|0,h|0)|0;if(!Z)Pa(R|0,o|0);C=o}else Z=-1;if((Z|0)==1){u=I;v=C;w=m;x=q;y=P;z=D;A=0;B=76;break a}N=Q;M=P}n=0;N=ra(86,b|0,G|0)|0;Q=n;n=0;if((Q|0)!=0&(o|0)!=0){_=Y4(c[Q>>2]|0,j|0,h|0)|0;if(!_)Pa(Q|0,o|0);C=o}else _=-1;if((_|0)==1){u=I;v=C;w=m;x=q;y=M;z=D;A=0;B=76;break a}G=N;F=M}n=0;G=ia(31,F<<3|0)|0;N=n;n=0;if((N|0)!=0&(o|0)!=0){$=Y4(c[N>>2]|0,j|0,h|0)|0;if(!$)Pa(N|0,o|0);C=o}else $=-1;if(($|0)!=1){n=0;ya(26,m|0,F|0,8,101);N=n;n=0;if((N|0)!=0&(o|0)!=0){aa=Y4(c[N>>2]|0,j|0,h|0)|0;if(!aa)Pa(N|0,o|0);C=o}else aa=-1;if((aa|0)!=1){N=c[s>>2]|0;n=0;ea(102,(c[s>>2]|0)+2|0);Q=n;n=0;if((Q|0)!=0&(o|0)!=0){ba=Y4(c[Q>>2]|0,j|0,h|0)|0;if(!ba)Pa(Q|0,o|0);C=o}else ba=-1;if((ba|0)!=1){Q=(c[s+16>>2]|0)+(N*40|0)|0;R=(c[s+16>>2]|0)+((N+1|0)*40|0)|0;N=0;while(1){if((N|0)>=(F|0))break;if((N|0)>0?(c[15244]&16|0)!=0:0){n=0;ga(21,c[24742]|0,s|0);S=n;n=0;if((S|0)!=0&(o|0)!=0){ca=Y4(c[S>>2]|0,j|0,h|0)|0;if(!ca)Pa(S|0,o|0);C=o}else ca=-1;if((ca|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a}}S=c[m+(N<<3)+4>>2]|0;T=c[(c[(c[((c[S>>2]&3|0)==3?S:S+32|0)+28>>2]|0)+8>>2]|0)+112>>2]|0;fa=c[(c[(c[((c[S>>2]&3|0)==2?S:S+-32|0)+28>>2]|0)+8>>2]|0)+112>>2]|0;if(!(((I|0)!=0?(ha=c[(c[S+8>>2]|0)+96>>2]|0,(ha|0)!=0):0)?(d[ha+81>>0]|0)!=0:0)){if((T|0)==(fa|0)){n=0;ya(27,s|0,T|0,R|0,Q|0);ha=n;n=0;if((ha|0)!=0&(o|0)!=0){ja=Y4(c[ha>>2]|0,j|0,h|0)|0;if(!ja)Pa(ha|0,o|0);C=o}else ja=-1;if((ja|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a}}else{n=0;wa(62,s|0,fa|0,R|0);fa=n;n=0;if((fa|0)!=0&(o|0)!=0){la=Y4(c[fa>>2]|0,j|0,h|0)|0;if(!la)Pa(fa|0,o|0);C=o}else la=-1;if((la|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a}n=0;wa(62,s|0,T|0,Q|0);T=n;n=0;if((T|0)!=0&(o|0)!=0){ma=Y4(c[T>>2]|0,j|0,h|0)|0;if(!ma)Pa(T|0,o|0);C=o}else ma=-1;if((ma|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a}}n=0;T=ka(39,s|0,R|0,Q|0)|0;fa=n;n=0;if((fa|0)!=0&(o|0)!=0){na=Y4(c[fa>>2]|0,j|0,h|0)|0;if(!na)Pa(fa|0,o|0);C=o}else na=-1;if((na|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a}if(T){oa=I;qa=m;sa=q;ua=F;va=D;za=G;break a}}T=G+(N<<3)|0;n=0;ya(28,k|0,s|0,Q|0,R|0);fa=n;n=0;if((fa|0)!=0&(o|0)!=0){Aa=Y4(c[fa>>2]|0,j|0,h|0)|0;if(!Aa)Pa(fa|0,o|0);C=o}else Aa=-1;if((Aa|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a};c[T>>2]=c[k>>2];c[T+4>>2]=c[k+4>>2];n=0;ea(103,s|0);T=n;n=0;if((T|0)!=0&(o|0)!=0){Ba=Y4(c[T>>2]|0,j|0,h|0)|0;if(!Ba)Pa(T|0,o|0);C=o}else Ba=-1;if((Ba|0)==1){u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76;break a}N=N+1|0}n=0;xa(6);N=n;n=0;if((N|0)!=0&(o|0)!=0){Ca=Y4(c[N>>2]|0,j|0,h|0)|0;if(!Ca)Pa(N|0,o|0);C=o}else Ca=-1;if((Ca|0)!=1){n=0;N=ia(32,q|0)|0;s=n;n=0;if((s|0)!=0&(o|0)!=0){Da=Y4(c[s>>2]|0,j|0,h|0)|0;if(!Da)Pa(s|0,o|0);C=o}else Da=-1;if((Da|0)!=1){c[q+20>>2]=N;n=0;N=ia(33,q|0)|0;s=n;n=0;if((s|0)!=0&(o|0)!=0){Ea=Y4(c[s>>2]|0,j|0,h|0)|0;if(!Ea)Pa(s|0,o|0);C=o}else Ea=-1;if((Ea|0)!=1){c[q+24>>2]=N;n=0;wa(63,F|0,G|0,q|0);N=n;n=0;if((N|0)!=0&(o|0)!=0){Fa=Y4(c[N>>2]|0,j|0,h|0)|0;if(!Fa)Pa(N|0,o|0);C=o}else Fa=-1;if((Fa|0)!=1){j=W4(60980,1,j|0,h|0)|0;h=C;n=0;N=n;n=0;if((N|0)!=0&(o|0)!=0){Ga=Y4(c[N>>2]|0,j|0,h|0)|0;if(!Ga)Pa(N|0,o|0);C=o}else Ga=-1;if((Ga|0)!=1){u=I;v=0;w=m;x=q;y=F;z=D;A=G;B=76}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=G;B=76}}else{u=I;v=C;w=m;x=q;y=F;z=D;A=0;B=76}}else{u=I;v=C;w=m;x=q;y=0;z=D;A=0;B=76}}else{u=I;v=C;w=m;x=0;y=0;z=D;A=0;B=76}}else{u=e;v=C;w=m;x=0;y=0;z=D;A=0;B=76}}else{u=e;v=C;w=0;x=0;y=0;z=0;A=0;B=76}}else{u=e;v=C;w=0;x=0;y=0;z=0;A=0;B=76}while(0);e:while(1){if((B|0)==76){B=0;if(v){oa=u;qa=w;sa=x;ua=y;va=z;za=A;continue}n=0;wa(64,y|0,A|0,x|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Ha=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Ha)Pa(e|0,o|0);C=o}else Ha=-1;if((Ha|0)==1){Ia=A;Ja=z;Ka=y;La=x;Ma=w;Na=u;v=C;A=Ia;z=Ja;y=Ka;x=La;w=Ma;u=Na;B=76;continue}if(c[15244]&4){n=0;da(17,c[24742]|0,x|0,y|0,A|0,w|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Oa=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Oa)Pa(e|0,o|0);C=o}else Oa=-1;if((Oa|0)==1){Ia=A;Ja=z;Ka=y;La=x;Ma=w;Na=u;v=C;A=Ia;z=Ja;y=Ka;x=La;w=Ma;u=Na;B=76;continue}}n=0;pa(1,b|0,x|0,y|0,A|0,61136,w|0,u|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Qa=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Qa)Pa(e|0,o|0);C=o}else Qa=-1;if((Qa|0)==1){Ia=A;Ja=z;Ka=y;La=x;Ma=w;Na=u;v=C;A=Ia;z=Ja;y=Ka;x=La;w=Ma;u=Na;B=76;continue}oa=u;qa=w;sa=x;ua=y;va=z;za=A}if(a[139e3]|0){n=0;ea(104,va|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Ra=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Ra)Pa(e|0,o|0);C=o}else Ra=-1;if((Ra|0)==1){u=oa;v=C;w=qa;x=sa;y=ua;z=va;A=za;B=76;continue}}e=0;while(1){if((e|0)>=(ua|0))break;n=0;ea(96,c[za+(e<<3)+4>>2]|0);D=n;n=0;if((D|0)!=0&(o|0)!=0){Sa=Y4(c[D>>2]|0,j|0,h|0)|0;if(!Sa)Pa(D|0,o|0);C=o}else Sa=-1;if((Sa|0)==1){u=oa;v=C;w=qa;x=sa;y=ua;z=va;A=za;B=76;continue e}e=e+1|0}n=0;ea(96,za|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Ta=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Ta)Pa(e|0,o|0);C=o}else Ta=-1;if((Ta|0)==1){u=oa;v=C;w=qa;x=sa;y=ua;z=va;A=za;B=76;continue}n=0;ea(105,sa|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Ua=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Ua)Pa(e|0,o|0);C=o}else Ua=-1;if((Ua|0)==1){u=oa;v=C;w=qa;x=sa;y=ua;z=va;A=za;B=76;continue}n=0;ea(96,qa|0);e=n;n=0;if((e|0)!=0&(o|0)!=0){Va=Y4(c[e>>2]|0,j|0,h|0)|0;if(!Va)Pa(e|0,o|0);C=o}else Va=-1;if((Va|0)==1){u=oa;v=C;w=qa;x=sa;y=ua;z=va;A=za;B=76}else break}O4(j|0);i=f;return}function zP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0;d=i;i=i+96|0;e=d+32|0;f=d+16|0;g=d+88|0;j=d+84|0;k=d+80|0;l=d+76|0;m=d+72|0;n=d+64|0;o=d+56|0;p=d;q=d+48|0;c[g>>2]=a;c[j>>2]=b;_2(148553,c[g>>2]|0)|0;_2(148564,c[g>>2]|0)|0;c[o>>2]=0;while(1){if((c[o>>2]|0)>=(c[c[j>>2]>>2]|0))break;c[l>>2]=(c[(c[j>>2]|0)+16>>2]|0)+((c[o>>2]|0)*40|0);c[k>>2]=c[(c[l>>2]|0)+20>>2];b=c[k>>2]|0;if((c[k>>2]|0)==(c[(c[l>>2]|0)+20+4>>2]|0)){sQ(p,b);c[n>>2]=~~+h[p>>3];c[n+4>>2]=~~+h[p+8>>3]}else{if(c[b>>2]&1)c[k>>2]=c[(c[l>>2]|0)+20+4>>2];uQ(q,c[k>>2]|0,c[l>>2]|0);c[n>>2]=c[q>>2];c[n+4>>2]=c[q+4>>2]}b=c[g>>2]|0;a=c[n>>2]|0;r=c[n+4>>2]|0;c[f>>2]=c[o>>2];c[f+4>>2]=a;c[f+8>>2]=r;Y2(b,148584,f)|0;c[o>>2]=(c[o>>2]|0)+1}c[o>>2]=0;while(1){if((c[o>>2]|0)>=(c[(c[j>>2]|0)+4>>2]|0))break;c[m>>2]=(c[(c[j>>2]|0)+20>>2]|0)+((c[o>>2]|0)*24|0);f=c[g>>2]|0;n=c[(c[m>>2]|0)+16>>2]|0;s=+h[c[m>>2]>>3];c[e>>2]=c[(c[m>>2]|0)+12>>2];c[e+4>>2]=n;h[e+8>>3]=s;Y2(f,148604,e)|0;c[o>>2]=(c[o>>2]|0)+1}_2(148626,c[g>>2]|0)|0;i=d;return}function AP(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=i;i=i+48|0;d=b+32|0;e=b+16|0;f=b;c[d>>2]=a;a=c[d>>2]|0;g=(c[(c[((c[c[d>>2]>>2]&3|0)==3?a:a+32|0)+28>>2]|0)+8>>2]|0)+16|0;c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];g=c[d>>2]|0;a=(c[(c[((c[c[d>>2]>>2]&3|0)==2?g:g+-32|0)+28>>2]|0)+8>>2]|0)+16|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];i=b;return ~~((+h[e>>3]-+h[f>>3])*(+h[e>>3]-+h[f>>3])+(+h[e+8>>3]-+h[f+8>>3])*(+h[e+8>>3]-+h[f+8>>3]))|0}function BP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d+4|0;f=d;c[e>>2]=a;c[f>>2]=b;i=d;return (c[c[e>>2]>>2]|0)-(c[c[f>>2]>>2]|0)|0}function CP(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=i;i=i+96|0;j=g+84|0;k=g+80|0;l=g+76|0;m=g+72|0;n=g+68|0;o=g+64|0;p=g+40|0;q=g+60|0;r=g+24|0;s=g+16|0;t=g+56|0;u=g;c[j>>2]=b;c[k>>2]=d;c[l>>2]=e;c[m>>2]=f;sQ(p,c[k>>2]|0);c[n>>2]=0;while(1){if((c[n>>2]|0)>=(c[(c[k>>2]|0)+32>>2]|0))break;c[t>>2]=c[(c[(c[k>>2]|0)+36>>2]|0)+(c[n>>2]<<2)>>2];do if(!(a[(c[t>>2]|0)+36>>0]|0)){if((c[(c[t>>2]|0)+20>>2]|0)==(c[k>>2]|0)){c[o>>2]=1;c[q>>2]=c[(c[t>>2]|0)+20+4>>2]}else{c[o>>2]=0;c[q>>2]=c[(c[t>>2]|0)+20>>2]}qQ(u,c[t>>2]|0,c[q>>2]|0);c[r>>2]=c[u>>2];c[r+4>>2]=c[u+4>>2];c[r+8>>2]=c[u+8>>2];c[r+12>>2]=c[u+12>>2];f=N(~~(+h[r>>3]-+h[p>>3])|0)|0;h[s>>3]=+(f+(N(~~(+h[r+8>>3]-+h[p+8>>3])|0)|0)|0);f=c[j>>2]|0;if(c[o>>2]|0){LQ(f,c[m>>2]|0,c[t>>2]|0,0.0)|0;break}else{LQ(f,c[l>>2]|0,c[t>>2]|0,0.0)|0;break}}while(0);c[n>>2]=(c[n>>2]|0)+1}n=c[j>>2]|0;c[n>>2]=(c[n>>2]|0)+2;i=g;return}function DP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+80|0;f=e+76|0;g=e+72|0;j=e+68|0;k=e+64|0;l=e+40|0;m=e+60|0;n=e+56|0;o=e+24|0;p=e+16|0;q=e;c[f>>2]=a;c[g>>2]=b;c[j>>2]=d;sQ(l,c[g>>2]|0);c[k>>2]=0;while(1){if((c[k>>2]|0)>=(c[(c[g>>2]|0)+32>>2]|0))break;c[m>>2]=c[(c[(c[g>>2]|0)+36>>2]|0)+(c[k>>2]<<2)>>2];d=(c[m>>2]|0)+20|0;if((c[(c[m>>2]|0)+20>>2]|0)==(c[g>>2]|0))c[n>>2]=c[d+4>>2];else c[n>>2]=c[d>>2];qQ(q,c[m>>2]|0,c[n>>2]|0);c[o>>2]=c[q>>2];c[o+4>>2]=c[q+4>>2];c[o+8>>2]=c[q+8>>2];c[o+12>>2]=c[q+12>>2];d=N(~~(+h[o>>3]-+h[l>>3])|0)|0;h[p>>3]=+(d+(N(~~(+h[o+8>>3]-+h[l+8>>3])|0)|0)|0);LQ(c[f>>2]|0,c[j>>2]|0,c[m>>2]|0,0.0)|0;c[k>>2]=(c[k>>2]|0)+1}k=c[f>>2]|0;c[k>>2]=(c[k>>2]|0)+1;k=c[g>>2]|0;c[(c[j>>2]|0)+20+4>>2]=k;c[(c[j>>2]|0)+20>>2]=k;i=e;return}function EP(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;j=i;i=i+256|0;k=j+248|0;l=j+244|0;m=j+240|0;n=j+232|0;o=j+224|0;p=j+220|0;q=j+216|0;r=j+212|0;s=j+208|0;t=j+204|0;u=j+200|0;v=j+136|0;w=j+128|0;x=j+120|0;y=j+112|0;z=j+196|0;A=j+192|0;B=j+96|0;C=j+80|0;D=j+64|0;E=j+48|0;F=j+32|0;G=j+16|0;H=j;c[k>>2]=e;c[l>>2]=f;c[m>>2]=g;c[s>>2]=0;c[o>>2]=c[l>>2];while(1){if(!(c[o>>2]|0))break;c[s>>2]=(c[s>>2]|0)+1;c[o>>2]=c[(c[o>>2]|0)+8>>2]}c[n>>2]=0;c[n+4>>2]=bK(((c[s>>2]|0)-2|0)*56|0)|0;c[v+52>>2]=0;c[v+48>>2]=0;s=c[(c[l>>2]|0)+8>>2]|0;c[q>>2]=s;c[o>>2]=s;c[p>>2]=c[(c[o>>2]|0)+8>>2];s=(c[o>>2]|0)+20|0;if(c[c[(c[o>>2]|0)+20>>2]>>2]&1)c[t>>2]=c[s+4>>2];else c[t>>2]=c[s>>2];qQ(E,c[o>>2]|0,c[t>>2]|0);c[B>>2]=c[E>>2];c[B+4>>2]=c[E+4>>2];c[B+8>>2]=c[E+8>>2];c[B+12>>2]=c[E+12>>2];while(1){if(!(c[(c[p>>2]|0)+8>>2]|0))break;c[u>>2]=rQ(c[q>>2]|0,c[p>>2]|0)|0;GU(c[k>>2]|0,c[u>>2]|0,c[(c[o>>2]|0)+12>>2]|0);if(!((d[(c[o>>2]|0)+36>>0]|0)==(d[(c[p>>2]|0)+36>>0]|0)?(c[(c[p>>2]|0)+8>>2]|0)!=(c[m>>2]|0):0)){if((d[(c[o>>2]|0)+36>>0]|0)!=(d[(c[p>>2]|0)+36>>0]|0)){sQ(F,c[u>>2]|0);c[C>>2]=c[F>>2];c[C+4>>2]=c[F+4>>2];c[C+8>>2]=c[F+8>>2];c[C+12>>2]=c[F+12>>2]}else{qQ(G,c[p>>2]|0,c[u>>2]|0);c[C>>2]=c[G>>2];c[C+4>>2]=c[G+4>>2];c[C+8>>2]=c[G+8>>2];c[C+12>>2]=c[G+12>>2]}E=(c[o>>2]|0)==(c[(c[l>>2]|0)+8>>2]|0);if(a[(c[o>>2]|0)+36>>0]|0){do if(!E)if(+h[D+8>>3]>+h[B+8>>3]){c[z>>2]=1;break}else{c[z>>2]=3;break}else c[z>>2]=0;while(0);do if((d[(c[o>>2]|0)+36>>0]|0)!=(d[(c[p>>2]|0)+36>>0]|0))if((c[(c[p>>2]|0)+20>>2]|0)==(c[u>>2]|0)){c[A>>2]=1;break}else{c[A>>2]=3;break}else c[A>>2]=0;while(0);h[w>>3]=+h[(c[t>>2]|0)+40+8>>3];h[x>>3]=+h[(c[t>>2]|0)+40>>3];h[y>>3]=+h[(c[u>>2]|0)+40>>3]}else{do if(!E)if(+h[D>>3]>+h[B>>3]){c[z>>2]=4;break}else{c[z>>2]=2;break}else c[z>>2]=0;while(0);do if((d[(c[o>>2]|0)+36>>0]|0)!=(d[(c[p>>2]|0)+36>>0]|0))if((c[(c[p>>2]|0)+20>>2]|0)==(c[u>>2]|0)){c[A>>2]=4;break}else{c[A>>2]=2;break}else c[A>>2]=0;while(0);h[w>>3]=+h[(c[t>>2]|0)+40>>3];h[x>>3]=+h[(c[t>>2]|0)+40+8>>3];h[y>>3]=+h[(c[u>>2]|0)+40+8>>3]}tQ(v,((a[(c[o>>2]|0)+36>>0]|0)!=0^1)&1,+h[w>>3],+h[x>>3],+h[y>>3],c[z>>2]|0,c[A>>2]|0);E=c[n>>2]|0;c[n>>2]=E+1;s=(c[n+4>>2]|0)+(E*56|0)|0;E=v;g=s+56|0;do{c[s>>2]=c[E>>2];s=s+4|0;E=E+4|0}while((s|0)<(g|0));c[t>>2]=c[u>>2];c[D>>2]=c[B>>2];c[D+4>>2]=c[B+4>>2];c[D+8>>2]=c[B+8>>2];c[D+12>>2]=c[B+12>>2];c[B>>2]=c[C>>2];c[B+4>>2]=c[C+4>>2];c[B+8>>2]=c[C+8>>2];c[B+12>>2]=c[C+12>>2];if((d[(c[o>>2]|0)+36>>0]|0)!=(d[(c[p>>2]|0)+36>>0]|0)?(c[(c[p>>2]|0)+8>>2]|0)==(c[m>>2]|0):0){qQ(H,c[p>>2]|0,c[u>>2]|0);c[C>>2]=c[H>>2];c[C+4>>2]=c[H+4>>2];c[C+8>>2]=c[H+8>>2];c[C+12>>2]=c[H+12>>2];c[A>>2]=0;if(a[(c[p>>2]|0)+36>>0]|0){if(+h[D+8>>3]>+h[B+8>>3])c[z>>2]=1;else c[z>>2]=3;h[w>>3]=+h[(c[t>>2]|0)+40+8>>3];h[x>>3]=+h[(c[t>>2]|0)+40>>3];h[y>>3]=+h[(c[u>>2]|0)+40>>3]}else{if(+h[D>>3]>+h[B>>3])c[z>>2]=4;else c[z>>2]=2;h[w>>3]=+h[(c[t>>2]|0)+40>>3];h[x>>3]=+h[(c[t>>2]|0)+40+8>>3];h[y>>3]=+h[(c[u>>2]|0)+40+8>>3]}tQ(v,((a[(c[p>>2]|0)+36>>0]|0)!=0^1)&1,+h[w>>3],+h[x>>3],+h[y>>3],c[z>>2]|0,c[A>>2]|0);f=c[n>>2]|0;c[n>>2]=f+1;s=(c[n+4>>2]|0)+(f*56|0)|0;E=v;g=s+56|0;do{c[s>>2]=c[E>>2];s=s+4|0;E=E+4|0}while((s|0)<(g|0))}c[o>>2]=c[p>>2]}c[q>>2]=c[p>>2];c[p>>2]=c[(c[p>>2]|0)+8>>2]}c[n+4>>2]=Q4(c[n+4>>2]|0,(c[n>>2]|0)*56|0)|0;c[r>>2]=0;while(1){if((c[r>>2]|0)>=(c[n>>2]|0))break;if((c[r>>2]|0)>0)c[(c[n+4>>2]|0)+((c[r>>2]|0)*56|0)+48>>2]=(c[n+4>>2]|0)+(((c[r>>2]|0)-1|0)*56|0);if((c[r>>2]|0)<((c[n>>2]|0)-1|0))c[(c[n+4>>2]|0)+((c[r>>2]|0)*56|0)+52>>2]=(c[n+4>>2]|0)+(((c[r>>2]|0)+1|0)*56|0);c[r>>2]=(c[r>>2]|0)+1}c[b>>2]=c[n>>2];c[b+4>>2]=c[n+4>>2];i=j;return}function FP(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,j=0,k=0,l=0;b=i;i=i+32|0;d=b+24|0;e=b+20|0;f=b+16|0;g=b+12|0;j=b+8|0;k=b+4|0;l=b;c[d>>2]=a;c[g>>2]=Nz(61156,c[12989]|0)|0;c[e>>2]=0;while(1){if((c[e>>2]|0)>=(c[c[d>>2]>>2]|0))break;c[k>>2]=(c[(c[d>>2]|0)+8>>2]|0)+((c[e>>2]|0)*72|0);if(!(c[c[k>>2]>>2]&4)){while(1){a=c[(c[(c[k>>2]|0)+36>>2]|0)+8>>2]|0;c[f>>2]=a;if(!a)break;a=c[(c[f>>2]|0)+20>>2]|0;c[l>>2]=a;if(!a)break;if(!((c[c[l>>2]>>2]&1|0)!=0^1))break;c[k>>2]=c[l>>2]}c[j>>2]=bK(40)|0;c[(c[j>>2]|0)+36>>2]=c[k>>2];h[(c[j>>2]|0)+8>>3]=+h[(c[k>>2]|0)+40>>3];a=c[k>>2]|0;c[a>>2]=c[a>>2]|4;while(1){a=c[c[(c[k>>2]|0)+36>>2]>>2]|0;c[f>>2]=a;if(!a)break;a=c[(c[f>>2]|0)+20+4>>2]|0;c[l>>2]=a;if(!a)break;if(!((c[c[l>>2]>>2]&1|0)!=0^1))break;c[k>>2]=c[l>>2];a=c[k>>2]|0;c[a>>2]=c[a>>2]|4}h[(c[j>>2]|0)+8+8>>3]=+h[(c[k>>2]|0)+40+16>>3];lQ(c[g>>2]|0,c[j>>2]|0,+h[(c[(c[j>>2]|0)+36>>2]|0)+40+8>>3])}c[e>>2]=(c[e>>2]|0)+1}i=b;return c[g>>2]|0}function GP(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,j=0,k=0,l=0;b=i;i=i+32|0;d=b+24|0;e=b+20|0;f=b+16|0;g=b+12|0;j=b+8|0;k=b+4|0;l=b;c[d>>2]=a;c[g>>2]=Nz(61156,c[12989]|0)|0;c[e>>2]=0;while(1){if((c[e>>2]|0)>=(c[c[d>>2]>>2]|0))break;c[k>>2]=(c[(c[d>>2]|0)+8>>2]|0)+((c[e>>2]|0)*72|0);if(!(c[c[k>>2]>>2]&2)){while(1){a=c[(c[(c[k>>2]|0)+36>>2]|0)+12>>2]|0;c[f>>2]=a;if(!a)break;a=c[(c[f>>2]|0)+20>>2]|0;c[l>>2]=a;if(!a)break;if(!((c[c[l>>2]>>2]&1|0)!=0^1))break;c[k>>2]=c[l>>2]}c[j>>2]=bK(40)|0;c[(c[j>>2]|0)+36>>2]=c[k>>2];h[(c[j>>2]|0)+8>>3]=+h[(c[k>>2]|0)+40+8>>3];a=c[k>>2]|0;c[a>>2]=c[a>>2]|2;while(1){a=c[(c[(c[k>>2]|0)+36>>2]|0)+4>>2]|0;c[f>>2]=a;if(!a)break;a=c[(c[f>>2]|0)+20+4>>2]|0;c[l>>2]=a;if(!a)break;if(!((c[c[l>>2]>>2]&