/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import java.util.logging.Logger;

public class ScaleOperator
extends AbstractAdaptableOperator {
    private final boolean REJECT_IF_OUT_OF_BOUNDS = true;
    private Parameter indicator;
    private double indicatorOnProb;
    private Variable<Double> variable = null;
    private boolean scaleAll = false;
    private boolean scaleAllIndependently = false;
    private int degreesOfFreedom = 0;
    private double scaleFactor = 0.5;

    public ScaleOperator(Variable variable, double d) {
        this(variable, d, AdaptationMode.ADAPTATION_ON, 1.0);
    }

    public ScaleOperator(Variable<Double> variable, double d, AdaptationMode adaptationMode, double d2) {
        this(variable, false, 0, d, adaptationMode, d2, null, 1.0, false);
    }

    public ScaleOperator(Variable<Double> variable, boolean bl, int n, double d, AdaptationMode adaptationMode, double d2, Parameter parameter, double d3, boolean bl2) {
        super(adaptationMode);
        this.setWeight(d2);
        this.variable = variable;
        this.indicator = parameter;
        this.indicatorOnProb = d3;
        this.scaleAll = bl;
        this.scaleAllIndependently = bl2;
        this.scaleFactor = d;
        this.degreesOfFreedom = n;
    }

    public Variable getVariable() {
        return this.variable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final double doOperation() {
        double d;
        double d2 = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        Bounds<Double> bounds = this.variable.getBounds();
        int n = this.variable.getSize();
        if (this.scaleAllIndependently) {
            d = 0.0;
            for (int i = 0; i < n; ++i) {
                double d3 = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
                double d4 = bounds.getLowerLimit(i);
                double d5 = (this.variable.getValue(i) - d4) * d3 + d4;
                d -= Math.log(d3);
                if (d5 > bounds.getUpperLimit(i)) {
                    throw new RuntimeException("proposed value greater than upper bound");
                }
                this.variable.setValue(i, d5);
            }
            return d;
        } else if (this.scaleAll) {
            int n2;
            d = this.degreesOfFreedom > 0 ? (double)(-this.degreesOfFreedom) * Math.log(d2) : (double)(n - 2) * Math.log(d2);
            for (n2 = 0; n2 < n; ++n2) {
                this.variable.setValue(n2, this.variable.getValue(n2) * d2);
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!(this.variable.getValue(n2) > this.variable.getBounds().getUpperLimit(n2)) && !(this.variable.getValue(n2) < this.variable.getBounds().getLowerLimit(n2))) continue;
                return Double.NEGATIVE_INFINITY;
            }
            return d;
        } else {
            double d6;
            int n3;
            d = -Math.log(d2);
            if (this.indicator != null) {
                int n4;
                boolean bl;
                int n5 = this.indicator.getDimension();
                boolean bl2 = n5 == n - 1;
                int[] nArray = new int[n5 + 1];
                int n6 = 0;
                boolean bl3 = bl = this.indicatorOnProb >= 1.0 || MathUtils.nextDouble() < this.indicatorOnProb;
                if (bl2 && bl) {
                    nArray[n6] = 0;
                    ++n6;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    double d7 = this.indicator.getStatisticValue(n4);
                    if (bl != d7 > 0.0) continue;
                    nArray[n6] = n4 + (bl2 ? 1 : 0);
                    ++n6;
                }
                if (n6 <= 0) return Double.NEGATIVE_INFINITY;
                n4 = MathUtils.nextInt(n6);
                n3 = nArray[n4];
            } else {
                n3 = MathUtils.nextInt(n);
            }
            double d8 = this.variable.getValue(n3);
            double d9 = bounds.getLowerLimit(n3);
            if (d9 == Double.NEGATIVE_INFINITY) {
                d9 = -bounds.getUpperLimit(n3).doubleValue();
            }
            if (d8 == 0.0) {
                Logger.getLogger("dr.inference").severe("The scaleOperator for " + this.variable.getVariableName() + " has failed since the parameter has a value of 0.0.\nTo fix this problem, initalize the value of " + this.variable.getVariableName() + " to be a positive real number");
            }
            if ((d6 = (d8 - d9) * d2 + d9) > bounds.getUpperLimit(n3)) {
                throw new RuntimeException("proposed value greater than upper bound: " + d6 + " (" + this.variable.getId() + ")");
            }
            this.variable.setValue(n3, d6);
            this.cleanupOperation(d6, d8);
        }
        return d;
    }

    void cleanupOperation(double d, double d2) {
    }

    @Override
    public final String getOperatorName() {
        return "scale(" + this.variable.getVariableName() + ")";
    }

    @Override
    public double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
        assert (this.scaleFactor > 0.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    public String toString() {
        return "scaleOperator(" + this.variable.getVariableName() + " [" + this.scaleFactor + ", " + 1.0 / this.scaleFactor + "]";
    }
}

