/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;

public class DirichletProcessLikelihood
extends AbstractModelLikelihood {
    public static final String DIRICHLET_PROCESS_LIKELIHOOD = "dirichletProcessLikelihood";
    private final Statistic etaParameter;
    private final Parameter chiParameter;
    private final int N;
    private final int K;
    private final double[] logFactorials;

    public DirichletProcessLikelihood(Statistic statistic, Parameter parameter) {
        super(DIRICHLET_PROCESS_LIKELIHOOD);
        int n;
        this.etaParameter = statistic;
        this.chiParameter = parameter;
        this.addVariable(parameter);
        this.K = statistic.getDimension();
        int n2 = 0;
        for (n = 0; n < this.K; ++n) {
            n2 += (int)statistic.getStatisticValue(n);
        }
        this.N = n2;
        this.logFactorials = new double[this.N];
        this.logFactorials[0] = 0.0;
        for (n = 1; n < this.N; ++n) {
            this.logFactorials[n] = this.logFactorials[n - 1] + Math.log(n);
        }
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = this.chiParameter.getParameterValue(0);
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.K; ++i) {
            int n2 = (int)this.etaParameter.getStatisticValue(i);
            if (n2 > this.N) {
                throw new RuntimeException("Illegal eta value");
            }
            if (n2 <= 0) continue;
            double d3 = this.logFactorials[n2 - 1];
            d2 += d3;
            ++n;
        }
        double d4 = 0.0;
        for (int i = 1; i <= this.N; ++i) {
            d4 += Math.log(d + (double)i - 1.0);
        }
        double d5 = (double)n * Math.log(d) + d2 - d4;
        return d5;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void storeState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public Statistic getEtaParameter() {
        return this.etaParameter;
    }

    public Parameter getChiParameter() {
        return this.chiParameter;
    }

    public int getN() {
        return this.N;
    }
}

