/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.MultivariateNormalDistribution;

public class CompoundSymmetryNormalDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider {
    private final int dim;
    private final Parameter marginal;
    private final Parameter rho;
    private MultivariateNormalDistribution distribution;
    private MultivariateNormalDistribution storedDistribution;
    private double[][] storedPrecision;
    private boolean distributionKnown;
    private boolean storedDistributionKnown;

    public CompoundSymmetryNormalDistributionModel(int n, Parameter parameter, Parameter parameter2) {
        super("multivariateNormalDistributionModel");
        this.dim = n;
        this.marginal = parameter;
        this.addVariable(parameter);
        this.rho = parameter2;
        this.addVariable(parameter2);
        this.storedPrecision = this.getPrecisionMatrix();
        this.distribution = this.createNewDistribution();
        this.distributionKnown = true;
    }

    private MultivariateNormalDistribution createNewDistribution() {
        return new MultivariateNormalDistribution(new double[this.getDimension()], this.storedPrecision);
    }

    @Override
    public double[] nextRandom() {
        this.checkDistribution();
        throw new RuntimeException("Not yet implemented");
    }

    private void checkDistribution() {
        if (!this.distributionKnown) {
            this.distribution = this.createNewDistribution();
            this.distributionKnown = true;
        }
    }

    @Override
    public double logPdf(Object object) {
        this.checkDistribution();
        return this.distribution.logPdf(object);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return null;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedDistribution = this.distribution;
        this.storedDistributionKnown = this.distributionKnown;
    }

    @Override
    protected void restoreState() {
        this.distributionKnown = this.storedDistributionKnown;
        this.distribution = this.storedDistribution;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    public double[] getPrecisionVectorProduct(double[] dArray) {
        this.checkDistribution();
        double[] dArray2 = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.dim; ++j) {
                d += this.storedPrecision[i][j] * dArray[j];
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public double[] getDiagonal() {
        this.checkDistribution();
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.storedPrecision[i][i];
        }
        return dArray;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.distribution.getGradientLogDensity(object);
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[][] getPrecisionMatrix() {
        double[][] dArray = new double[this.dim][this.dim];
        double d = this.rho.getParameterValue(0);
        double d2 = this.marginal.getParameterValue(0);
        if (d2 != 1.0) {
            throw new RuntimeException("not yet implemented!");
        }
        double d3 = (1.0 - d) * (1.0 - d + d * (double)this.dim);
        double d4 = (1.0 - 2.0 * d + (double)this.dim * d) / d3;
        double d5 = -d / d3;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[i][j] = i != j ? d5 : d4;
            }
        }
        return dArray;
    }

    @Override
    public double logPdf(double[] dArray) {
        this.checkDistribution();
        return this.distribution.logPdf(dArray);
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    public double[] getPrecisionColumn(int n) {
        this.checkDistribution();
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.storedPrecision[i][n];
        }
        return dArray;
    }

    @Override
    public double[] getMean() {
        return new double[this.dim];
    }

    @Override
    public String getType() {
        return this.distribution.getType();
    }
}

