/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.distribution.shrinkage.BayesianBridgeDistributionModel;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.GradientProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.PriorPreconditioningProvider;
import dr.inference.model.Variable;
import dr.util.InverseFirstOrderFiniteDifferenceTransform;
import dr.xml.Reportable;

public class BayesianBridgeMarkovRandomFieldLikelihood
extends AbstractModelLikelihood
implements BayesianBridgeStatisticsProvider,
PriorPreconditioningProvider,
GradientWrtParameterProvider,
HessianWrtParameterProvider,
Reportable {
    private final Parameter variables;
    private final BayesianBridgeDistributionModel bridge;
    private final ParametricDistributionModel firstElementDistribution;
    private final int dim;
    private final InverseFirstOrderFiniteDifferenceTransform transform;

    public BayesianBridgeMarkovRandomFieldLikelihood(Parameter parameter, BayesianBridgeDistributionModel bayesianBridgeDistributionModel, ParametricDistributionModel parametricDistributionModel, InverseFirstOrderFiniteDifferenceTransform inverseFirstOrderFiniteDifferenceTransform) {
        super("bayesianBridge");
        this.variables = parameter;
        this.bridge = bayesianBridgeDistributionModel;
        this.firstElementDistribution = parametricDistributionModel;
        this.transform = inverseFirstOrderFiniteDifferenceTransform;
        this.dim = parameter.getDimension();
        this.addModel(bayesianBridgeDistributionModel);
        this.addModel(parametricDistributionModel);
        this.addVariable(parameter);
    }

    private double[][] getUnconstrainedValues() {
        double[] dArray = this.transform.inverse(this.variables.getParameterValues(), 0, this.dim);
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = new double[1];
        dArrayArray[0][0] = dArray[0];
        dArrayArray[1] = new double[this.dim - 1];
        System.arraycopy(dArray, 1, dArrayArray[1], 0, this.dim - 1);
        return dArrayArray;
    }

    @Override
    public double getLogLikelihood() {
        double[][] dArray = this.getUnconstrainedValues();
        double d = 0.0;
        d += this.firstElementDistribution.logPdf(dArray[0]);
        d += this.bridge.logPdf(dArray[1]);
        return d -= this.transform.getLogJacobian(this.transform.inverse(this.variables.getParameterValues(), 0, this.dim));
    }

    @Override
    public double[] getGradientLogDensity() {
        double[][] dArray = this.getUnconstrainedValues();
        double[] dArray2 = new double[this.dim];
        dArray2[0] = ((GradientProvider)((Object)this.firstElementDistribution)).getGradientLogDensity(dArray[0])[0];
        double[] dArray3 = this.bridge.getGradientLogDensity(dArray[1]);
        System.arraycopy(dArray3, 0, dArray2, 1, this.dim - 1);
        return this.transform.updateGradientLogDensity(dArray2, this.transform.inverse(this.variables.getParameterValues(), 0, this.dim), 0, this.dim);
    }

    @Override
    public double[] getDiagonalHessianLogDensity() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getHessianLogDensity() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getCoefficient(int n) {
        return this.transform.inverse(this.variables.getParameterValues(), 0, this.dim)[n];
    }

    @Override
    public Parameter getGlobalScale() {
        return this.bridge.getGlobalScale();
    }

    @Override
    public Parameter getLocalScale() {
        return this.bridge.getLocalScale();
    }

    @Override
    public Parameter getExponent() {
        return this.bridge.getExponent();
    }

    @Override
    public Parameter getSlabWidth() {
        return this.bridge.getSlabWidth();
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.variables;
    }

    @Override
    public final void makeDirty() {
    }

    @Override
    public final void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void storeState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public double getStandardDeviation(int n) {
        if (this.bridge instanceof PriorPreconditioningProvider && this.firstElementDistribution instanceof PriorPreconditioningProvider) {
            if (n == 0) {
                return ((PriorPreconditioningProvider)((Object)this.firstElementDistribution)).getStandardDeviation(n);
            }
            return ((PriorPreconditioningProvider)((Object)this.bridge)).getStandardDeviation(n - 1);
        }
        throw new RuntimeException("Not a prior conditioner");
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, 1.0E-6, 0.001);
    }
}

