/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class BitFlipInSubstitutionModelOperator
extends AbstractAdaptableOperator {
    public static final String BIT_FLIP_OPERATOR = "bitFlipInSubstitutionModelOperator";
    public static final String SCALE_FACTOR = "scaleFactor";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("scaleFactor"), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule(Parameter.class, true), new ElementRule(BayesianStochasticSearchVariableSelection.class)};

        @Override
        public String getParserName() {
            return BitFlipInSubstitutionModelOperator.BIT_FLIP_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            double d2 = xMLObject.getDoubleAttribute(BitFlipInSubstitutionModelOperator.SCALE_FACTOR);
            if (d2 <= 0.0 || d2 >= 1.0) {
                throw new XMLParseException("scaleFactor must be between 0.0 and 1.0");
            }
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            BayesianStochasticSearchVariableSelection bayesianStochasticSearchVariableSelection = (BayesianStochasticSearchVariableSelection)xMLObject.getChild(BayesianStochasticSearchVariableSelection.class);
            return new BitFlipInSubstitutionModelOperator(bayesianStochasticSearchVariableSelection, parameter, d, d2, adaptationMode);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a bit-flip operator on a given indicatorParameter.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter indicatorParameter = null;
    private Parameter rateParameter = null;
    private BayesianStochasticSearchVariableSelection model;
    private double scaleFactor;

    public BitFlipInSubstitutionModelOperator(BayesianStochasticSearchVariableSelection bayesianStochasticSearchVariableSelection, Parameter parameter, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.model = bayesianStochasticSearchVariableSelection;
        this.indicatorParameter = bayesianStochasticSearchVariableSelection.getIndicators();
        this.rateParameter = parameter;
        this.scaleFactor = d2;
        this.setWeight(d);
    }

    public Parameter getIndicatorParameter() {
        return this.indicatorParameter;
    }

    @Override
    public final double doOperation() {
        double d;
        int n;
        int n2 = this.indicatorParameter.getDimension();
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            d2 += this.indicatorParameter.getParameterValue(n);
        }
        n = MathUtils.nextInt(n2);
        int n3 = (int)this.indicatorParameter.getParameterValue(n);
        double d3 = 0.0;
        if (this.rateParameter != null) {
            d3 = MathUtils.nextDouble();
        }
        if (n3 == 0) {
            this.indicatorParameter.setParameterValue(n, 1.0);
            d = -Math.log(((double)n2 - d2) / (d2 + 1.0));
        } else if (n3 == 1) {
            this.indicatorParameter.setParameterValue(n, 0.0);
            d = -Math.log(d2 / ((double)n2 - d2 + 1.0));
            d3 *= -1.0;
        } else {
            throw new RuntimeException("expected 1 or 0");
        }
        if (this.rateParameter != null) {
            double d4 = Math.exp(d3 * this.scaleFactor);
            d += Math.log(d4);
            double d5 = this.rateParameter.getParameterValue(0);
            double d6 = d4 * d5;
            this.rateParameter.setParameterValue(0, d6);
        }
        return d;
    }

    @Override
    public final String getOperatorName() {
        return "bitflip(" + this.indicatorParameter.getParameterName() + ")";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.scaleFactor);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return SCALE_FACTOR;
    }

    public String toString() {
        return this.getOperatorName();
    }
}

