/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evolution.colouring.DefaultTreeColouring;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.coalescent.structure.ColourSamplerModel;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.inference.model.Likelihood;

public class OldTreeLogger
extends MCLogger {
    public static final String LOG_TREE = "logTree";
    public static final String NEXUS_FORMAT = "nexusFormat";
    public static final String USING_RATES = "usingRates";
    public static final String BRANCH_LENGTHS = "branchLengths";
    public static final String TIME = "time";
    public static final String SUBSTITUTIONS = "substitutions";
    public static final String LOG = "log";
    public static final String ECHO = "echo";
    public static final String ECHO_EVERY = "echoEvery";
    public static final String TITLE = "title";
    public static final String FILE_NAME = "fileName";
    public static final String FORMAT = "format";
    public static final String TAB = "tab";
    public static final String HTML = "html";
    public static final String PRETTY = "pretty";
    public static final String LOG_EVERY = "logEvery";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String LABEL = "label";
    public static final String SIGNIFICANT_FIGURES = "sf";
    public static final String DECIMAL_PLACES = "dp";
    public static final String WIDTH = "width";
    private Tree tree;
    private BranchRateModel branchRateModel = null;
    private String rateLabel;
    private ColourSamplerModel colourSamplerModel = null;
    private String colouringLabel;
    private Likelihood likelihood = null;
    private String likelihoodLabel;
    private boolean nexusFormat = false;
    public boolean usingRates = false;
    public boolean substitutions = false;

    public OldTreeLogger(Tree tree, BranchRateModel branchRateModel, String string, ColourSamplerModel colourSamplerModel, String string2, Likelihood likelihood, String string3, LogFormatter logFormatter, int n, boolean bl, boolean bl2) {
        super(logFormatter, n, false);
        this.nexusFormat = bl;
        this.branchRateModel = branchRateModel;
        this.rateLabel = string;
        this.colourSamplerModel = colourSamplerModel;
        this.colouringLabel = string2;
        this.likelihood = likelihood;
        this.likelihoodLabel = string3;
        if (branchRateModel != null) {
            this.substitutions = bl2;
        }
        this.tree = tree;
    }

    @Override
    public void startLogging() {
        if (this.nexusFormat) {
            int n;
            int n2 = this.tree.getTaxonCount();
            this.logLine("#NEXUS");
            this.logLine("");
            this.logLine("Begin taxa;");
            this.logLine("\tDimensions ntax=" + n2 + ";");
            this.logLine("\tTaxlabels");
            for (n = 0; n < n2; ++n) {
                this.logLine("\t\t" + this.tree.getTaxon(n).getId());
            }
            this.logLine("\t\t;");
            this.logLine("End;");
            this.logLine("");
            this.logLine("Begin trees;");
            if (!this.useTaxonLabels()) {
                this.logLine("\tTranslate");
                for (n = 0; n < n2; ++n) {
                    int n3 = n + 1;
                    if (n3 < n2) {
                        this.logLine("\t\t" + n3 + " " + this.tree.getTaxonId(n) + ",");
                        continue;
                    }
                    this.logLine("\t\t" + n3 + " " + this.tree.getTaxonId(n));
                }
                this.logLine("\t\t;");
            }
        }
    }

    @Override
    public void log(long l) {
        if (this.logEvery <= 0L || l % this.logEvery == 0L) {
            StringBuffer stringBuffer = new StringBuffer("tree STATE_");
            stringBuffer.append(l);
            if (this.likelihood != null) {
                stringBuffer.append(" [&");
                stringBuffer.append(this.likelihoodLabel);
                stringBuffer.append("=");
                stringBuffer.append(this.likelihood.getLogLikelihood());
                stringBuffer.append("]");
            }
            stringBuffer.append(this.additionalInfo());
            stringBuffer.append(" = [&R] ");
            DefaultTreeColouring defaultTreeColouring = null;
            if (this.colourSamplerModel != null) {
                defaultTreeColouring = this.colourSamplerModel.getTreeColouring();
            }
            Tree tree = this.getPrintTree();
            if (this.substitutions) {
                TreeUtils.newick(tree, tree.getRoot(), this.useTaxonLabels(), TreeUtils.BranchLengthType.LENGTHS_AS_SUBSTITUTIONS, null, this.branchRateModel, null, null, stringBuffer);
            } else {
                TreeUtils.newick(tree, tree.getRoot(), this.useTaxonLabels(), TreeUtils.BranchLengthType.LENGTHS_AS_TIME, null, this.branchRateModel, null, null, stringBuffer);
            }
            stringBuffer.append(";");
            this.logLine(stringBuffer.toString());
        }
    }

    protected String additionalInfo() {
        return "";
    }

    protected Tree getPrintTree() {
        return this.tree;
    }

    protected Tree getTree() {
        return this.tree;
    }

    protected boolean useTaxonLabels() {
        return false;
    }

    @Override
    public void stopLogging() {
        this.logLine("End;");
        super.stopLogging();
    }
}

