/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import java.util.ArrayList;
import java.util.Arrays;
import moa.classifiers.core.attributeclassobservers.GaussianNumericAttributeClassObserver;
import moa.classifiers.trees.iadem.IademCommonProcedures;
import moa.classifiers.trees.iadem.IademNumericAttributeObserver;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.GaussianEstimator;
import weka.core.Utils;

public class IademGaussianNumericAttributeClassObserver
extends GaussianNumericAttributeClassObserver
implements IademNumericAttributeObserver {
    private static final long serialVersionUID = 1L;
    private int valueCount = 0;
    protected DoubleVector classDist = new DoubleVector();

    public IademGaussianNumericAttributeClassObserver() {
    }

    public IademGaussianNumericAttributeClassObserver(int maxTuples) {
        this.numBinsOption.setValue(maxTuples);
    }

    @Override
    public void addValue(double attValue, int classValue, double weight) {
        if (!Utils.isMissingValue((double)attValue)) {
            this.valueCount = (int)((double)this.valueCount + weight);
            this.classDist.addToValue(classValue, weight);
            this.observeAttributeClass(attValue, classValue, weight);
        }
    }

    @Override
    public long getValueCount() {
        return this.valueCount;
    }

    @Override
    public long[] getClassDist() {
        long[] classDistCopy = new long[this.classDist.numValues()];
        for (int i = 0; i < this.classDist.numValues(); ++i) {
            classDistCopy[i] = (long)this.classDist.getValue(i);
        }
        return classDistCopy;
    }

    @Override
    public long getNumberOfCutPoints() {
        return this.getSplitPointSuggestions().length;
    }

    @Override
    public long[] getLeftClassDist(double cutValue) {
        long[] lhsDist = new long[this.classDist.numValues()];
        Arrays.fill(lhsDist, 0L);
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GaussianEstimator estimator = (GaussianEstimator)this.attValDistPerClass.get(i);
            if (estimator == null || cutValue < this.minValueObservedPerClass.getValue(i)) continue;
            if (cutValue >= this.maxValueObservedPerClass.getValue(i)) {
                lhsDist[i] = (long)estimator.getTotalWeightObserved();
                continue;
            }
            double[] weightDist = estimator.estimatedWeight_LessThan_EqualTo_GreaterThan_Value(cutValue);
            lhsDist[i] = (long)(weightDist[0] + weightDist[1]);
        }
        return lhsDist;
    }

    @Override
    public double getCut(int index) {
        return this.getSplitPointSuggestions()[index];
    }

    @Override
    public void computeClassDistProbabilities(double[][][] cut_value_classDist_lower, double[][][] cut_value_classDist_upper, double[][] counts_cut_value, boolean withIntervalEstimates) {
        ArrayList<Double> cuts = this.cutPointSuggestion(-1);
        long[] totalDist = this.getClassDist();
        for (int i = 0; i < cuts.size(); ++i) {
            long[] lDist = this.getLeftClassDist(cuts.get(i));
            long[] rDist = new long[lDist.length];
            long leftTotal = this.sum(lDist);
            long total = this.sum(totalDist);
            counts_cut_value[i][0] = leftTotal;
            counts_cut_value[i][1] = total - leftTotal;
            for (int j = 0; j < totalDist.length; ++j) {
                rDist[j] = totalDist[j] - lDist[j];
                double leftEst = 0.0;
                if (counts_cut_value[i][0] != 0.0) {
                    leftEst = (double)lDist[j] / counts_cut_value[i][0];
                }
                double leftError = 0.0;
                if (withIntervalEstimates) {
                    leftError = IademCommonProcedures.getIADEM_HoeffdingBound(leftEst, counts_cut_value[i][0]);
                }
                cut_value_classDist_lower[i][0][j] = Math.max(0.0, leftEst - leftError);
                cut_value_classDist_upper[i][0][j] = Math.min(1.0, leftEst + leftError);
                double rightEst = 0.0;
                if (counts_cut_value[i][1] != 0.0) {
                    rightEst = (double)rDist[j] / counts_cut_value[i][1];
                }
                double rightError = 0.0;
                if (withIntervalEstimates) {
                    rightError = IademCommonProcedures.getIADEM_HoeffdingBound(rightEst, counts_cut_value[i][1]);
                }
                cut_value_classDist_lower[i][1][j] = Math.max(0.0, rightEst - rightError);
                cut_value_classDist_upper[i][1][j] = Math.min(1.0, rightEst + rightError);
            }
        }
    }

    protected long sum(long[] arr) {
        long count = 0L;
        for (int i = 0; i < arr.length; ++i) {
            count += arr[i];
        }
        return count;
    }

    @Override
    public ArrayList<Double> cutPointSuggestion(int total) {
        ArrayList<Double> cuts = new ArrayList<Double>();
        double[] arr = this.getSplitPointSuggestions();
        for (int i = 0; i < arr.length; ++i) {
            cuts.add(arr[i]);
        }
        return cuts;
    }

    @Override
    public ArrayList<Double[]> computeConditionalProbPerBin(ArrayList<Double> cuts) {
        ArrayList<Double[]> probClassDistPerCut = new ArrayList<Double[]>();
        long total = this.getValueCount();
        for (Double currentCut : cuts) {
            long[] numInstances = this.getLeftClassDist(currentCut);
            Double[] prob = new Double[numInstances.length];
            for (int j = 0; j < prob.length; ++j) {
                prob[j] = (double)numInstances[j] / (double)total;
            }
            probClassDistPerCut.add(prob);
        }
        return probClassDistPerCut;
    }

    @Override
    public double[] computeConditionalProb(ArrayList<Double> cuts, double cutValue) {
        double[] conditionalProbability = new double[this.attValDistPerClass.size()];
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            conditionalProbability[i] = this.probabilityOfAttributeValueGivenClass(cutValue, i);
        }
        return conditionalProbability;
    }

    @Override
    public void reset() {
        this.minValueObservedPerClass = new DoubleVector();
        this.maxValueObservedPerClass = new DoubleVector();
        this.attValDistPerClass = new AutoExpandVector();
        this.valueCount = 0;
        this.classDist = new DoubleVector();
    }

    @Override
    public long getMaxOfValues() {
        return this.numBinsOption.getValue();
    }

    @Override
    public IademNumericAttributeObserver getCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMaxBins(int numberOfBins) {
        this.numBinsOption.setValue(numberOfBins);
    }

    @Override
    public void computeClassDist(double[][][] cutClassDist) {
        ArrayList<Double> cuts = this.cutPointSuggestion(-1);
        long[] totalDist = this.getClassDist();
        for (int i = 0; i < cuts.size(); ++i) {
            long[] lDist = this.getLeftClassDist(cuts.get(i));
            long[] rDist = new long[lDist.length];
            for (int j = 0; j < totalDist.length; ++j) {
                rDist[j] = totalDist[j] - lDist[j];
                cutClassDist[i][0][j] = lDist[j];
                cutClassDist[i][1][j] = rDist[j];
            }
        }
    }
}

