/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.ByLongDataBuilder;
import internal.toolkit.base.api.timeseries.util.ByObjDataBuilder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.util.ObsCharacteristics;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public interface TsDataBuilder<DATE> {
    @NonNull
    public TsDataBuilder<DATE> clear();

    @NonNull
    public TsDataBuilder<DATE> add(@Nullable DATE var1, @Nullable Number var2);

    @NonNull
    default public <X> TsDataBuilder<DATE> add(@Nullable X obs, @NonNull Function<? super X, ? extends DATE> dateFunc, @NonNull Function<? super X, ? extends Number> valueFunc) {
        DATE date;
        if (dateFunc == null) {
            throw new NullPointerException("dateFunc is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        return this.add(date, (date = dateFunc.apply(obs)) != null ? (Number)valueFunc.apply(obs) : (Number)null);
    }

    @NonNull
    default public <X> TsDataBuilder<DATE> addAll(@NonNull Stream<X> stream, @NonNull Function<? super X, ? extends DATE> dateFunc, @NonNull Function<? super X, ? extends Number> valueFunc) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (dateFunc == null) {
            throw new NullPointerException("dateFunc is marked non-null but is null");
        }
        if (valueFunc == null) {
            throw new NullPointerException("valueFunc is marked non-null but is null");
        }
        stream.forEach(o -> this.add(o, dateFunc, valueFunc));
        return this;
    }

    @NonNull
    public TsData build();

    @NonNull
    public static TsDataBuilder<Date> byCalendar(@NonNull Calendar resource, @NonNull ObsGathering gathering, ObsCharacteristics ... characteristics) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (gathering == null) {
            throw new NullPointerException("gathering is marked non-null but is null");
        }
        if (characteristics == null) {
            throw new NullPointerException("characteristics is marked non-null but is null");
        }
        return ByLongDataBuilder.fromCalendar(resource, gathering, characteristics);
    }

    @NonNull
    public static TsDataBuilder<LocalDate> byDate(@NonNull ObsGathering gathering, ObsCharacteristics ... characteristics) {
        if (gathering == null) {
            throw new NullPointerException("gathering is marked non-null but is null");
        }
        if (characteristics == null) {
            throw new NullPointerException("characteristics is marked non-null but is null");
        }
        return ByLongDataBuilder.fromDate(gathering, characteristics);
    }

    @NonNull
    public static TsDataBuilder<LocalDateTime> byDateTime(@NonNull ObsGathering gathering, ObsCharacteristics ... characteristics) {
        if (gathering == null) {
            throw new NullPointerException("gathering is marked non-null but is null");
        }
        if (characteristics == null) {
            throw new NullPointerException("characteristics is marked non-null but is null");
        }
        return ByObjDataBuilder.fromDateTime(gathering, characteristics);
    }
}

