/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import internal.toolkit.base.api.timeseries.DefaultTsFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.MainFactory;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsProvider;
import jdplus.toolkit.base.api.timeseries.TsProviderLoader;
import lombok.NonNull;

public interface TsFactory {
    public static final String DESCRIPTION = "@description";
    public static final String OWNER = "@owner";
    public static final String SOURCE = "@source";
    public static final String ID = "@id";
    public static final String DATE = "@timestamp";
    public static final String DOCUMENT = "@document";
    public static final String SUMMARY = "@summary";
    public static final String NOTE = "@note";
    public static final String TODO = "@todo";
    public static final String ALGORITHM = "@algorithm";
    public static final String QUALITY = "@quality";
    public static final String PROVIDER_NOT_FOUND = "Provider not found";

    @NonNull
    public static TsFactory ofServiceLoader() {
        return TsFactory.of(TsProviderLoader.load());
    }

    @NonNull
    public static TsFactory of(@NonNull Iterable<? extends TsProvider> providers) {
        if (providers == null) {
            throw new NullPointerException("providers is marked non-null but is null");
        }
        DefaultTsFactory.Builder result = DefaultTsFactory.builder();
        providers.forEach(result::provider);
        return result.build();
    }

    @NonNull
    public static TsFactory getDefault() {
        return MainFactory.DEFAULT.get();
    }

    public static void setDefault(@NonNull TsFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        MainFactory.DEFAULT.set(factory);
    }

    @NonNull
    public Optional<TsProvider> getProvider(@NonNull String var1);

    @NonNull
    public Stream<TsProvider> getProviders();

    @NonNull
    default public Ts makeTs(@NonNull TsMoniker moniker, @NonNull TsInformationType info) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        Optional<TsProvider> provider = this.getProvider(moniker.getSource());
        if (provider.isPresent()) {
            try {
                return provider.orElseThrow().getTs(moniker, info);
            }
            catch (IOException ex) {
                return this.makeTs(moniker, ex);
            }
        }
        Objects.requireNonNull(info);
        return DefaultTsFactory.fallbackTs(moniker, TsData.empty(PROVIDER_NOT_FOUND));
    }

    @NonNull
    default public Ts makeTs(@NonNull TsMoniker moniker, @NonNull IOException ex) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        return DefaultTsFactory.fallbackTs(moniker, TsData.empty(ex.getMessage()));
    }

    @NonNull
    default public TsCollection makeTsCollection(@NonNull TsMoniker moniker, @NonNull TsInformationType info) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        Optional<TsProvider> provider = this.getProvider(moniker.getSource());
        if (provider.isPresent()) {
            try {
                return provider.orElseThrow().getTsCollection(moniker, info);
            }
            catch (IOException ex) {
                return this.makeTsCollection(moniker, ex);
            }
        }
        Objects.requireNonNull(info);
        return DefaultTsFactory.fallbackTsCollection(moniker, PROVIDER_NOT_FOUND);
    }

    @NonNull
    default public TsCollection makeTsCollection(@NonNull TsMoniker moniker, @NonNull IOException ex) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        return DefaultTsFactory.fallbackTsCollection(moniker, ex.getMessage());
    }
}

