/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.composite.CompositeDynamics;
import jdplus.toolkit.base.core.ssf.composite.CompositeInitialization;

public class CompositeState {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<StateComponent> components = new ArrayList<StateComponent>();
        private int[] dim;
        private int[] pos;

        public Builder add(StateComponent cmp) {
            this.components.add(cmp);
            return this;
        }

        public StateComponent build() {
            if (this.components.isEmpty()) {
                return null;
            }
            int n = this.components.size();
            this.dim = new int[n];
            this.pos = new int[n];
            ISsfInitialization[] i = new ISsfInitialization[n];
            ISsfDynamics[] d = new ISsfDynamics[n];
            int cpos = 0;
            for (int j = 0; j < n; ++j) {
                StateComponent cur = this.components.get(j);
                i[j] = cur.initialization();
                d[j] = cur.dynamics();
                this.pos[j] = cpos;
                this.dim[j] = i[j].getStateDim();
                cpos += this.dim[j];
            }
            return new StateComponent(new CompositeInitialization(this.dim, i), new CompositeDynamics(this.dim, d));
        }

        public int[] getComponentsDimension() {
            return this.dim;
        }

        public int[] getComponentsPosition() {
            return this.pos;
        }
    }
}

