/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima.estimation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.util.SubArrayOfInt;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class FastKalmanFilter {
    private IArimaModel arma;
    private double[] phi;
    private int dim;
    private double h0;
    private double[] c0;
    private double eps = 1.0E-12;
    private boolean fast;

    public FastKalmanFilter(IArimaModel arma) {
        this.initmodel(arma, 0);
    }

    public DataBlock fastFilter(DoubleSeq y) {
        double[] C = (double[])this.c0.clone();
        double h = this.h0;
        double var = this.arma.getInnovationVariance();
        if (var != 1.0) {
            h /= var;
            int i = 0;
            while (i < C.length) {
                int n = i++;
                C[n] = C[n] / var;
            }
        }
        double[] L = (double[])C.clone();
        double[] a = new double[this.dim];
        int n = y.length();
        double[] yl = new double[n];
        int ilast = this.dim - 1;
        int np = this.phi.length - 1;
        double[] theta = this.arma.getMa().asPolynomial().toArray();
        int nq = theta.length - 1;
        int im = np > nq ? np : nq;
        boolean steady = false;
        for (int pos = 0; pos < im; ++pos) {
            int k;
            double zlv;
            double e;
            double s = Math.sqrt(h);
            yl[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
            double zl = L[0];
            if ((h -= zl * (zlv = zl / h)) < 1.0) {
                h = 1.0;
            }
            if (Double.isNaN(h)) {
                throw new ArimaException();
            }
            if (steady) continue;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n2 = i;
                    C[n2] = C[n2] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n3 = ilast;
            C[n3] = C[n3] - zlv * llast;
            for (k = 0; k < L.length && !(Math.abs(L[k]) > this.eps); ++k) {
            }
            if (k != L.length) continue;
            steady = true;
        }
        for (int i = im; i < n; ++i) {
            double x = y.get(i);
            for (int p = 1; p <= np; ++p) {
                x += y.get(i - p) * this.phi[p];
            }
            for (int q = 1; q <= nq; ++q) {
                x -= yl[i - q] * theta[q];
            }
            yl[i] = x;
        }
        return DataBlock.of(yl);
    }

    public double fastProcessing(DoubleSeq y, int nparams) {
        DataBlock yl = this.fastFilter(y);
        int n = yl.length();
        double ssqerr = yl.ssq();
        return Math.log(ssqerr / (double)n) + (double)nparams * Math.log(n) / (double)n;
    }

    private void initmodel(IArimaModel arma, int statedim) {
        if (!arma.isStationary()) {
            throw new ArimaException("acgf of non stationary model");
        }
        this.arma = arma;
        this.phi = this.arma.getAr().asPolynomial().toArray();
        if (statedim == 0) {
            statedim = Math.max(arma.getArOrder(), arma.getMaOrder() + 1);
        }
        this.dim = statedim;
        this.c0 = this.arma.getAutoCovarianceFunction().values(this.dim);
        this.h0 = this.c0[0];
        this.tx(this.c0);
    }

    public boolean process(DoubleSeq y, DataBlock res, DataBlock stde) {
        this.fast = false;
        DeterminantalTerm det = new DeterminantalTerm();
        double[] C = (double[])this.c0.clone();
        double[] L = (double[])C.clone();
        double h = this.h0;
        double var = this.arma.getInnovationVariance();
        double[] a = new double[this.dim];
        int n = y.length();
        int pos = 0;
        int ilast = this.dim - 1;
        do {
            if (Double.isNaN(h) || h < 0.0) {
                return false;
            }
            det.add(h);
            double s = Math.sqrt(h);
            double e = (y.get(pos) - a[0]) / s;
            res.set(pos, e);
            stde.set(pos, s);
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
            double zl = L[0];
            double zlv = zl / h;
            if (this.fast) continue;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n2 = i;
                    C[n2] = C[n2] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n3 = ilast;
            C[n3] = C[n3] - zlv * llast;
            if ((h -= zl * zlv) < var) {
                h = var;
            }
            if (!(h - var <= this.eps)) continue;
            this.fast = true;
        } while (++pos < n);
        return true;
    }

    public Likelihood process(DoubleSeq y) {
        this.fast = false;
        DeterminantalTerm det = new DeterminantalTerm();
        double[] C = (double[])this.c0.clone();
        double[] L = (double[])C.clone();
        double h = this.h0;
        double var = this.arma.getInnovationVariance();
        double[] a = new double[this.dim];
        int n = y.length();
        double[] yl = new double[n];
        int pos = 0;
        int ilast = this.dim - 1;
        do {
            double e;
            if (Double.isNaN(h) || h < 0.0) {
                return null;
            }
            det.add(h);
            double s = Math.sqrt(h);
            yl[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
            double zl = L[0];
            double zlv = zl / h;
            if (this.fast) continue;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n2 = i;
                    C[n2] = C[n2] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n3 = ilast;
            C[n3] = C[n3] - zlv * llast;
            if ((h -= zl * zlv) < var) {
                h = var;
            }
            if (!(h - var <= this.eps)) continue;
            this.fast = true;
        } while (++pos < n);
        DoubleSeq dy = DoubleSeq.of((double[])yl);
        return Likelihood.builder(n).ssqErr(dy.ssq()).residuals(dy).logDeterminant(det.getLogDeterminant()).build();
    }

    public ConcentratedLikelihoodWithMissing process(DoubleSeq y, SubArrayOfInt ao, FastMatrix x) {
        this.fast = false;
        DeterminantalTerm det = new DeterminantalTerm();
        double[] c = (double[])this.c0.clone();
        double[] l = (double[])c.clone();
        double h = this.h0;
        double var = this.arma.getInnovationVariance();
        double[] a = new double[this.dim];
        int nx = x.getColumnsCount();
        int n = y.length();
        double[] yl = new double[n];
        FastMatrix xl = FastMatrix.make(n, nx);
        double[][] A = new double[nx][];
        double[] px = xl.getStorage();
        int pos = 0;
        int ilast = this.dim - 1;
        DataBlockIterator xrows = x.rowsIterator();
        while (xrows.hasNext()) {
            double e;
            det.add(h);
            double s = Math.sqrt(h);
            yl[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + c[i] * v;
            }
            a[ilast] = la + c[ilast] * v;
            DataBlock xrow = xrows.next();
            int ix = 0;
            int ipx = pos;
            while (ix < nx) {
                double[] acur = A[ix];
                double xcur = xrow.get(ix);
                if (acur == null && xcur != 0.0) {
                    A[ix] = acur = new double[this.dim];
                }
                if (acur != null) {
                    px[ipx] = e = (xcur - acur[0]) / s;
                    v = e / s;
                    la = this.tlast(acur);
                    for (int i = 0; i < ilast; ++i) {
                        acur[i] = acur[i + 1] + c[i] * v;
                    }
                    acur[ilast] = la + c[ilast] * v;
                }
                ++ix;
                ipx += n;
            }
            double zl = l[0];
            double zlv = zl / h;
            if (!this.fast) {
                double llast = this.tlast(l);
                double clast = c[ilast];
                for (int i = 0; i < ilast; ++i) {
                    double li = l[i + 1];
                    if (zlv != 0.0) {
                        l[i] = li - c[i] * zlv;
                        int n2 = i;
                        c[n2] = c[n2] - zlv * li;
                        continue;
                    }
                    l[i] = li;
                }
                l[ilast] = llast - zlv * clast;
                int n3 = ilast;
                c[n3] = c[n3] - zlv * llast;
                if ((h -= zl * zlv) < var) {
                    h = var;
                }
                if (h - var <= this.eps) {
                    this.fast = true;
                }
            }
            xrows.next();
        }
        QRLeastSquaresSolution qr = QRLeastSquaresSolver.fastLeastSquares((DoubleSeq)DataBlock.of(yl), xl);
        double ssqerr = qr.getSsqErr();
        FastMatrix bvar = qr.unscaledCovariance();
        double ldet = det.getLogDeterminant();
        if (ao != null && !ao.isEmpty()) {
            DoubleSeq rdiag = qr.rawRDiagonal();
            n -= ao.getLength();
            for (int i = 0; i < ao.getLength(); ++i) {
                ldet += 2.0 * Math.log(Math.abs(rdiag.get(ao.get(i))));
            }
        }
        return ConcentratedLikelihoodWithMissing.builder().ndata(n).coefficients(qr.getB()).ssqErr(ssqerr).logDeterminant(ldet).residuals(qr.getE()).unscaledCovariance(bvar).build();
    }

    public void setEpsilon(double eps) {
        this.eps = eps;
    }

    public double getEpsilon() {
        return this.eps;
    }

    private double tlast(double[] x) {
        double last = 0.0;
        for (int i = 1; i < this.phi.length; ++i) {
            last -= this.phi[i] * x[this.dim - i];
        }
        return last;
    }

    private void tx(double[] x) {
        int i;
        double last = 0.0;
        for (i = 1; i < this.phi.length; ++i) {
            last -= this.phi[i] * x[this.dim - i];
        }
        for (i = 1; i < this.dim; ++i) {
            x[i - 1] = x[i];
        }
        x[this.dim - 1] = last;
    }
}

