/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.math.Complex;
import org.openscience.cdk.math.IMatrix;
import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;

public class AngularMomentum {
    private final double J;
    private final int size;
    private final Matrix basis;

    public AngularMomentum(double J) {
        int i;
        this.J = J;
        this.size = (int)Math.round(J * 2.0 + 1.0);
        this.basis = new Matrix(this.size, this.size);
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.basis.matrix[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.size; ++i) {
            this.basis.matrix[i][i] = 1.0;
        }
    }

    public IMatrix getIx() {
        return new IMatrix(this.getIplus().add(this.getIminus())).mul(new Complex(0.5, 0.0));
    }

    public IMatrix getIy() {
        return new IMatrix(this.getIplus().sub(this.getIminus())).mul(new Complex(0.0, 1.0)).mul(new Complex(0.5, 0.0));
    }

    public IMatrix getIz() {
        int i;
        IMatrix Iz = new IMatrix(this.size, this.size);
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                Iz.realmatrix[i][j] = 0.0;
                Iz.imagmatrix[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.size; ++i) {
            Iz.realmatrix[i][i] = this.J - (double)i;
            Iz.imagmatrix[i][i] = this.J - (double)i;
        }
        return Iz;
    }

    public Matrix getIplus() {
        int i;
        Matrix Iplus = new Matrix(this.size, this.size);
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                Iplus.matrix[i][j] = 0.0;
            }
        }
        for (i = 1; i < this.size; ++i) {
            Iplus.matrix[i - 1][i] = Math.sqrt(this.J * this.J + this.J - (this.J - (double)i + 1.0) * (this.J - (double)i + 1.0) + (this.J - (double)i + 1.0));
        }
        return Iplus;
    }

    public Matrix getIminus() {
        int i;
        Matrix Iminus = new Matrix(this.size, this.size);
        for (i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                Iminus.matrix[i][j] = 0.0;
            }
        }
        for (i = 1; i < this.size; ++i) {
            Iminus.matrix[i][i - 1] = Math.sqrt(this.J * this.J + this.J - (this.J - (double)i) * (this.J - (double)i) - (this.J - (double)i));
        }
        return Iminus;
    }

    public Vector getSpinVector(double theta, double phi) {
        Vector spinvector = new Vector(3);
        spinvector.vector[0] = Math.sin(theta) * Math.cos(phi);
        spinvector.vector[1] = Math.sin(theta) * Math.sin(phi);
        spinvector.vector[2] = Math.cos(phi);
        return spinvector;
    }
}

