% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_files.R
\name{search_files}
\alias{search_files}
\title{Search Files for a Pattern}
\usage{
search_files(what, verbose = TRUE, exclude = NULL, ...)
}
\arguments{
\item{what}{A regex pattern for which to search.}

\item{verbose}{Be verbose?}

\item{exclude}{A regular expression for excluding files.}

\item{...}{Arguments passed to \code{\link{list.files}}.}
}
\value{
\link[base:invisible]{Invisibly} a vector of names of files
containing the pattern given by \code{what}.
}
\description{
This is an approximation of \kbd{unix} \command{find} and \command{grep}.
}
\examples{
write.csv(mtcars, file.path(tempdir(), "mtcars.csv"))
 for (i in 0:9) {
     write.csv(iris, file.path(tempdir(), paste0("iris", i, ".csv")))
 }
search_files(what = "Mazda", path = tempdir(), pattern = "^.*\\\\.csv$")
search_files(what = "[Ss]etosa", path = tempdir(), pattern = "^.*\\\\.csv$")
x <- search_files(path = tempdir(),
                  pattern = "^.*\\\\.csv$",
                  exclude = "[2-9]\\\\.csv$",
                  what = "[Ss]etosa")
summary(x)
summary(x, type = "what")
summary(x, type = "matches")
try(search_files(what = "ABC", path = tempdir(), pattern = "^.*\\\\.csv$"))
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{fromto}()},
\code{\link{missing_docs}},
\code{\link{search_rows}()},
\code{\link{summary.filesearch}()}

Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
\concept{searching functions}
