/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmx21Client;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.QueryRunner;
import it.bancaditalia.oss.sdmx.util.Utils;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class DotStat
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public DotStat(Provider provider, String string) {
        super(provider, null, string);
    }

    public DotStat(Provider provider) {
        this(provider, "compact_v2");
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildFlowQuery(string, this.getAllKeyword(), this.getLatestKeyword());
        List<DataFlowStructure> list = QueryRunner.runQuery(new DataStructureParser(), uRL, null);
        if (list.size() > 0) {
            DataFlowStructure dataFlowStructure = list.get(0);
            Dataflow dataflow = new Dataflow(dataFlowStructure, dataFlowStructure.getName());
            dataflow.setDsdIdentifier(dataFlowStructure);
            return dataflow;
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        URL uRL = this.buildFlowQuery("ALL", this.getAllKeyword(), this.getLatestKeyword());
        List<DataFlowStructure> list = QueryRunner.runQuery(new DataStructureParser(), uRL, null);
        if (list.size() > 0) {
            HashMap<String, Dataflow> hashMap = new HashMap<String, Dataflow>();
            for (DataFlowStructure dataFlowStructure : list) {
                Dataflow dataflow = new Dataflow(dataFlowStructure, dataFlowStructure.getName());
                dataflow.setDsdIdentifier(dataFlowStructure);
                hashMap.put(dataFlowStructure.getId(), dataflow);
            }
            return hashMap;
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return this.buildDSDQuery(string, string2, string3, false);
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        Utils.checkString(string, "The name of the data structure cannot be null");
        return ((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)this.getBuilder()).addPath("GetDataStructure")).addPath(string)).build();
    }

    @Override
    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2, String string5) throws SdmxException {
        Utils.checkString(string, "The ts key must have valid values");
        if (dataflow != null) {
            return ((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)((RestSdmx21Client.Sdmx21QueryBuilder)this.getBuilder()).addPath("GetData")).addPath(dataflow.getId())).addPath(string)).withParam("startPeriod", string2)).withParam("endPeriod", string3)).withDetail(bl)).withParam("updatedAfter", string4)).withHistory(bl2)).withParam("format", string5)).build();
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.getProvider().getEndpoint());
    }
}

