/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.IRationalFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;

public class RationalForeFilter
implements IRationalFilter {
    private final RationalFunction m_rfe;

    public RationalForeFilter() {
        this.m_rfe = new RationalFunction();
    }

    public RationalForeFilter(ForeFilter num, ForeFilter denom) {
        this.m_rfe = new RationalFunction(num.getPolynomial(), denom.getPolynomial());
    }

    RationalForeFilter(RationalFunction rfe) {
        this.m_rfe = rfe;
    }

    public RationalForeFilter drop(int n) {
        RationalFunction rfe = this.m_rfe.drop(n);
        return new RationalForeFilter(rfe);
    }

    @Override
    public Complex frequencyResponse(double freq) {
        Complex n = Utilities.frequencyResponse(this.m_rfe.getNumerator().getCoefficients(), 0, freq);
        Complex d = Utilities.frequencyResponse(this.m_rfe.getDenominator().getCoefficients(), 0, freq);
        return n.div(d);
    }

    @Override
    public ForeFilter getDenominator() {
        Polynomial p = this.m_rfe.getDenominator();
        return new ForeFilter(p);
    }

    public int getLBound() {
        return 0;
    }

    public RationalBackFilter getMirror() {
        return new RationalBackFilter(this.m_rfe);
    }

    @Override
    public ForeFilter getNumerator() {
        Polynomial p = this.m_rfe.getNumerator();
        return new ForeFilter(p);
    }

    public RationalFunction getRationalFunction() {
        return this.m_rfe;
    }

    public int getUBound() {
        if (this.m_rfe.isFinite()) {
            return this.m_rfe.getNumerator().getDegree();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public double getWeight(int pos) {
        return this.m_rfe.get(pos);
    }

    public double[] getWeights(int n) {
        return this.m_rfe.coefficients(n);
    }

    @Override
    public boolean hasLowerBound() {
        return true;
    }

    @Override
    public boolean hasUpperBound() {
        return this.m_rfe.isFinite();
    }

    public void prepare(int n) {
        this.m_rfe.prepare(n);
    }

    public RationalForeFilter times(RationalForeFilter r) {
        Polynomial ln = this.m_rfe.getNumerator();
        Polynomial rn = r.m_rfe.getNumerator();
        Polynomial ld = this.m_rfe.getDenominator();
        Polynomial.SimplifyingTool psmp = new Polynomial.SimplifyingTool();
        Polynomial rd = r.m_rfe.getDenominator();
        if (psmp.simplify(ln, rd)) {
            ln = (Polynomial)psmp.getLeft();
            rd = (Polynomial)psmp.getRight();
        }
        if (psmp.simplify(rn, ld)) {
            rn = (Polynomial)psmp.getLeft();
            ld = (Polynomial)psmp.getRight();
        }
        Polynomial n = ln.times(rn);
        Polynomial d = ld.times(rd);
        double d0 = d.get(0);
        if (d0 != 1.0) {
            n = n.divide(d0);
            d = d.divide(d0);
        }
        RationalFunction rfe = new RationalFunction(n, d);
        return new RationalForeFilter(rfe);
    }
}

