/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class JohnsonSBDist
extends ContinuousDistribution {
    private double gamma;
    private double delta;
    private double xi;
    private double lambda;

    public JohnsonSBDist(double d, double d2, double d3, double d4) {
        this.setParams(d, d2, d3, d4);
    }

    public double density(double d) {
        return JohnsonSBDist.density(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double cdf(double d) {
        return JohnsonSBDist.cdf(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double inverseF(double d) {
        return JohnsonSBDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double getMean() {
        return JohnsonSBDist.getMean(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getVariance() {
        return JohnsonSBDist.getVariance(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getStandardDeviation() {
        return JohnsonSBDist.getStandardDeviation(this.gamma, this.delta, this.xi, this.lambda);
    }

    public static double density(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (d5 <= d3 || d5 >= d3 + d4) {
            return 0.0;
        }
        double d6 = (d5 - d3) / d4;
        double d7 = d + d2 * Math.log(d6 / (1.0 - d6));
        return d2 / (d4 * d6 * (1.0 - d6) * Math.sqrt(Math.PI * 2)) * Math.exp(-d7 * d7 / 2.0);
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (d5 <= d3) {
            return 0.0;
        }
        if (d5 >= d3 + d4) {
            return 1.0;
        }
        double d6 = (d5 - d3) / d4;
        return NormalDist.cdf01(d + d2 * Math.log(d6 / (1.0 - d6)));
    }

    public static double barF(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (d5 <= d3) {
            return 1.0;
        }
        if (d5 >= d3 + d4) {
            return 0.0;
        }
        double d6 = (d5 - d3) / d4;
        return NormalDist.barF01(d + d2 * Math.log(d6 / (1.0 - d6)));
    }

    public static double inverseF(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (d5 > 1.0 || d5 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d5 >= 1.0) {
            return d3 + d4;
        }
        if (d5 <= 0.0) {
            return d3;
        }
        double d6 = NormalDist.inverseF01(d5);
        double d7 = (d6 - d) / d2;
        if (d6 >= 100.0 || d7 >= 709.782712893384) {
            return d3 + d4;
        }
        if (d6 <= -100.0 || d7 <= -709.782712893384) {
            return d3;
        }
        d7 = Math.exp(d7);
        return (d3 + (d3 + d4) * d7) / (1.0 + d7);
    }

    public static double getMean(double d, double d2, double d3, double d4) {
        throw new UnsupportedOperationException("Unknown mean");
    }

    public static double getVariance(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        throw new UnsupportedOperationException("Unknown variance");
    }

    public static double getStandardDeviation(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        throw new UnsupportedOperationException("Unknown standard deviation");
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = d;
        this.delta = d2;
        this.xi = d3;
        this.lambda = d4;
        this.supportA = d3;
        this.supportB = d3 + d4;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.gamma, this.delta, this.xi, this.lambda};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : gamma = " + this.gamma + ", delta = " + this.delta + ", xi = " + this.xi + ", lambda = " + this.lambda;
    }
}

