/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import java.util.Arrays;

public class DoubleICC
implements DoublePreconditioner {
    private SparseRCDoubleMatrix2D R;
    private final DoubleMatrix1D y;
    private int[] diagind;
    private final int n;

    public DoubleICC(int n) {
        this.n = n;
        this.y = new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.upperTransSolve(doubleMatrix1D, this.y);
        return this.upperSolve(this.y, doubleMatrix1D2);
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        return this.apply(doubleMatrix1D, doubleMatrix1D2);
    }

    public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
        DoubleProperty.DEFAULT.isSquare(doubleMatrix2D);
        if (doubleMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.R = new SparseRCDoubleMatrix2D(this.n, this.n);
        this.R.assign(doubleMatrix2D);
        if (!this.R.hasColumnIndexesSorted()) {
            this.R.sortColumnIndexes();
        }
        this.factor();
    }

    private void factor() {
        int n = this.R.rows();
        int[] nArray = this.R.getColumnIndexes();
        int[] nArray2 = this.R.getRowPointers();
        double[] dArray = this.R.getValues();
        double[] dArray2 = new double[n];
        this.diagind = this.findDiagonalIndexes(n, nArray, nArray2);
        for (int i = 0; i < n; ++i) {
            int n2;
            Arrays.fill(dArray2, 0.0);
            for (n2 = nArray2[i]; n2 < nArray2[i + 1]; ++n2) {
                dArray2[nArray[n2]] = dArray[n2];
            }
            for (n2 = 0; n2 < i; ++n2) {
                double d = dArray[this.diagind[n2]];
                if (d == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (n2 + 1) + " during ICC process");
                }
                double d2 = dArray2[n2] / d;
                if (d2 == 0.0) continue;
                for (int j = this.diagind[n2] + 1; j < nArray2[n2 + 1]; ++j) {
                    int n3 = nArray[j];
                    dArray2[n3] = dArray2[n3] - d2 * dArray[j];
                }
            }
            if (dArray2[i] == 0.0) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (i + 1) + " during ICC process");
            }
            double d = Math.sqrt(dArray2[i]);
            for (int j = this.diagind[i]; j < nArray2[i + 1]; ++j) {
                dArray[j] = dArray2[nArray[j]] / d;
            }
        }
    }

    private int[] findDiagonalIndexes(int n, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = Sorting.binarySearchFromTo(nArray, i, nArray2[i], nArray2[i + 1] - 1);
            if (nArray3[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (i + 1));
        }
        return nArray3;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
        double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int[] nArray = this.R.getColumnIndexes();
        int[] nArray2 = this.R.getRowPointers();
        double[] dArray3 = this.R.getValues();
        int n = this.R.rows();
        for (int i = n - 1; i >= 0; --i) {
            double d = 0.0;
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                d += dArray3[j] * dArray2[nArray[j]];
            }
            dArray2[i] = (dArray[i] - d) / dArray3[this.diagind[i]];
        }
        return doubleMatrix1D2;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
        double[] dArray = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
        int[] nArray = this.R.getColumnIndexes();
        int[] nArray2 = this.R.getRowPointers();
        double[] dArray2 = this.R.getValues();
        int n = this.R.rows();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] / dArray2[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                int n3 = nArray[j];
                dArray[n3] = dArray[n3] - dArray2[j] * dArray[i];
            }
        }
        return doubleMatrix1D2;
    }
}

