/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.ohdsi.circe.check.checkers.BaseIterableCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Criteria;

public abstract class BaseCorelatedCriteriaCheck
extends BaseIterableCheck {
    @Override
    protected void internalCheck(CohortExpression expression, WarningReporter reporter) {
        expression.inclusionRules.forEach(inclusionRule -> Arrays.stream(inclusionRule.expression.criteriaList).forEach(criteria -> {
            this.checkCriteria((CorelatedCriteria)criteria, "inclusion rule " + inclusionRule.name, reporter);
            this.checkCriteriaGroup(criteria.criteria, "inclusion rule " + inclusionRule.name, reporter);
        }));
    }

    protected final void checkCriteriaGroup(Criteria criteria, String groupName, WarningReporter reporter) {
        if (Objects.nonNull(criteria.CorrelatedCriteria)) {
            Consumer<CorelatedCriteria> corelatedCriteriaCheck = corelatedCriteria -> {
                this.checkCriteria((CorelatedCriteria)corelatedCriteria, groupName, reporter);
                this.checkCriteriaGroup(corelatedCriteria.criteria, groupName, reporter);
            };
            Arrays.stream(criteria.CorrelatedCriteria.criteriaList).forEach(corelatedCriteriaCheck);
            Arrays.stream(criteria.CorrelatedCriteria.groups).forEach(group -> Arrays.stream(group.criteriaList).forEach(corelatedCriteriaCheck));
        }
    }

    protected abstract void checkCriteria(CorelatedCriteria var1, String var2, WarningReporter var3);
}

