/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.SpatialKernel;
import dr.inference.model.AbstractModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractOutbreak
extends AbstractModel
implements PatternList {
    protected GeneralDataType caseDataType;
    protected TaxonList taxa;
    private boolean hasLatentPeriods;
    protected final boolean hasGeography;
    private final String CASE_NAME = "hostID";
    protected ArrayList<AbstractCase> cases;
    protected int infectedSize = 0;

    public AbstractOutbreak(String string, Taxa taxa) {
        this(string, taxa, false, true);
    }

    public AbstractOutbreak(String string, Taxa taxa, boolean bl, boolean bl2) {
        super(string);
        this.taxa = taxa;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < taxa.getTaxonCount(); ++i) {
            arrayList.add((String)taxa.getTaxonAttribute(i, "hostID"));
        }
        this.caseDataType = new GeneralDataType(arrayList);
        this.hasLatentPeriods = bl;
        this.hasGeography = bl2;
    }

    public ArrayList<AbstractCase> getCases() {
        return new ArrayList<AbstractCase>(this.cases);
    }

    public boolean hasLatentPeriods() {
        return this.hasLatentPeriods;
    }

    public boolean hasGeography() {
        return this.hasGeography;
    }

    public abstract double getLatentPeriod(AbstractCase var1);

    public double getKernelValue(AbstractCase abstractCase, AbstractCase abstractCase2, SpatialKernel spatialKernel) {
        if (!this.hasGeography) {
            return 1.0;
        }
        return spatialKernel.value(this.getDistance(abstractCase, abstractCase2));
    }

    public double[] getKernelValues(AbstractCase abstractCase, SpatialKernel spatialKernel) {
        double[] dArray = new double[this.cases.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = spatialKernel.value(this.getDistance(abstractCase, this.cases.get(i)));
        }
        return dArray;
    }

    public int getCaseIndex(AbstractCase abstractCase) {
        return this.cases.indexOf(abstractCase);
    }

    public int size() {
        return this.cases.size();
    }

    public int infectedSize() {
        return this.infectedSize;
    }

    public abstract double getDistance(AbstractCase var1, AbstractCase var2);

    public AbstractCase getCase(int n) {
        return this.cases.get(n);
    }

    public AbstractCase getCase(String string) {
        for (AbstractCase abstractCase : this.cases) {
            if (!abstractCase.getName().equals(string)) continue;
            return abstractCase;
        }
        return null;
    }

    public TaxonList getTaxa() {
        return this.taxa;
    }

    @Override
    public int getPatternCount() {
        return 1;
    }

    @Override
    public int getStateCount() {
        return this.size();
    }

    @Override
    public int getPatternLength() {
        return this.taxa.getTaxonCount();
    }

    @Override
    public int[] getPattern(int n) {
        int[] nArray = new int[this.cases.size()];
        for (int i = 0; i < this.cases.size(); ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return n;
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public double getPatternWeight(int n) {
        return 1.0;
    }

    @Override
    public double[] getPatternWeights() {
        return new double[]{1.0};
    }

    @Override
    public double[] getStateFrequencies() {
        double[] dArray = new double[this.cases.size()];
        Arrays.fill(dArray, (double)(1 / this.cases.size()));
        return dArray;
    }

    @Override
    public boolean areUnique() {
        return false;
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    @Override
    public DataType getDataType() {
        return this.caseDataType;
    }

    @Override
    public int getTaxonCount() {
        return this.taxa.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.taxa.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.taxa.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.taxa.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.taxa.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        return this.taxa.asList();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.taxa.getTaxonAttribute(n, string);
    }

    @Override
    public Iterator<Taxon> iterator() {
        if (this.taxa == null) {
            throw new RuntimeException("Patterns has no TaxonList");
        }
        return this.taxa.iterator();
    }
}

